/* desktop-notifications.c generated by valac 0.56.3, the Vala compiler
 * generated from desktop-notifications.vala, do not modify */

/*
 * Copyright © 2016 Software Freedom Conservancy Inc.
 * Copyright © 2019-2020 Michael Gratton <mike@vee.net>.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "desktop-notifications.h"
#include <glib-object.h>
#include <glib.h>
#include <libpeas/peas.h>
#include "geary-client-43.0.h"
#include <gio/gio.h>
#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <handy.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define PLUGIN_DESKTOP_NOTIFICATIONS_ARRIVED_ID "email-arrived"

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	PLUGIN_DESKTOP_NOTIFICATIONS_0_PROPERTY,
	PLUGIN_DESKTOP_NOTIFICATIONS_NOTIFICATIONS_PROPERTY,
	PLUGIN_DESKTOP_NOTIFICATIONS_FOLDERS_PROPERTY,
	PLUGIN_DESKTOP_NOTIFICATIONS_EMAIL_PROPERTY,
	PLUGIN_DESKTOP_NOTIFICATIONS_CLIENT_APPLICATION_PROPERTY,
	PLUGIN_DESKTOP_NOTIFICATIONS_CLIENT_PLUGINS_PROPERTY,
	PLUGIN_DESKTOP_NOTIFICATIONS_NUM_PROPERTIES
};
static GParamSpec* plugin_desktop_notifications_properties[PLUGIN_DESKTOP_NOTIFICATIONS_NUM_PROPERTIES];
typedef struct _PluginDesktopNotificationsActivateData PluginDesktopNotificationsActivateData;
typedef struct _PluginDesktopNotificationsDeactivateData PluginDesktopNotificationsDeactivateData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _PluginDesktopNotificationsNotifySpecificMessageData PluginDesktopNotificationsNotifySpecificMessageData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PluginDesktopNotificationsHandleNewMessagesData PluginDesktopNotificationsHandleNewMessagesData;

struct _PluginDesktopNotificationsPrivate {
	PluginNotificationContext* _notifications;
	PluginFolderContext* _folders;
	PluginEmailContext* _email;
	ApplicationClient* _client_application;
	ApplicationPluginManager* _client_plugins;
	PluginEmailStore* email_store;
	GNotification* arrived_notification;
	GCancellable* cancellable;
};

struct _PluginDesktopNotificationsActivateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PluginDesktopNotifications* self;
	gboolean is_startup;
	GCancellable* _tmp0_;
	PluginEmailStore* _tmp1_;
	PluginEmailContext* _tmp2_;
	PluginEmailContext* _tmp3_;
	PluginEmailStore* _tmp4_;
	PluginEmailStore* _tmp5_;
	PluginNotificationContext* _tmp6_;
	PluginNotificationContext* _tmp7_;
	PluginNotificationContext* _tmp8_;
	PluginNotificationContext* _tmp9_;
	PluginFolderStore* folder_store;
	PluginFolderContext* _tmp10_;
	PluginFolderContext* _tmp11_;
	PluginFolderStore* _tmp12_;
	PluginFolderStore* _tmp13_;
	PluginFolderStore* _tmp14_;
	PluginFolderStore* _tmp15_;
	PluginFolderStore* _tmp16_;
	GeeCollection* _tmp17_;
	GeeCollection* _tmp18_;
	GError* _inner_error0_;
};

struct _PluginDesktopNotificationsDeactivateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PluginDesktopNotifications* self;
	gboolean is_shutdown;
	GCancellable* _tmp0_;
};

struct _PluginDesktopNotificationsNotifySpecificMessageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PluginDesktopNotifications* self;
	PluginFolder* folder;
	gint total;
	PluginEmail* email;
	gchar* title;
	PluginAccount* _tmp0_;
	PluginAccount* _tmp1_;
	gchar* _tmp2_;
	GIcon* icon;
	GearyRFC822MailboxAddress* originator;
	GearyRFC822MailboxAddress* _tmp3_;
	GearyRFC822MailboxAddress* _tmp4_;
	PluginContactStore* contacts;
	PluginNotificationContext* _tmp5_;
	PluginNotificationContext* _tmp6_;
	PluginContactStore* _tmp7_;
	ApplicationContact* contact;
	PluginContactStore* _tmp8_;
	GearyRFC822MailboxAddress* _tmp9_;
	GCancellable* _tmp10_;
	ApplicationContact* _tmp11_;
	gchar* _tmp12_;
	ApplicationContact* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	ApplicationContact* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	GearyRFC822MailboxAddress* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	ApplicationContact* _tmp23_;
	GLoadableIcon* _tmp24_;
	GLoadableIcon* _tmp25_;
	GIcon* _tmp26_;
	gchar* body;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gint window_scale;
	GdkDisplay* display;
	GdkDisplay* _tmp30_;
	GdkDisplay* _tmp31_;
	GdkDisplay* _tmp32_;
	GdkMonitor* monitor;
	GdkDisplay* _tmp33_;
	GdkMonitor* _tmp34_;
	GdkMonitor* _tmp35_;
	GdkMonitor* _tmp36_;
	GdkMonitor* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
	HdyAvatar* avatar;
	const gchar* _tmp40_;
	HdyAvatar* _tmp41_;
	HdyAvatar* _tmp42_;
	GIcon* _tmp43_;
	HdyAvatar* _tmp44_;
	GdkPixbuf* _tmp45_;
	const gchar* _tmp46_;
	const gchar* _tmp47_;
	GIcon* _tmp48_;
	PluginEmailIdentifier* _tmp49_;
	PluginEmailIdentifier* _tmp50_;
	GError* _inner_error0_;
};

struct _PluginDesktopNotificationsHandleNewMessagesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PluginDesktopNotifications* self;
	PluginFolder* folder;
	gint total;
	GeeCollection* added;
	PluginNotificationContext* _tmp0_;
	PluginNotificationContext* _tmp1_;
	gboolean notified;
	GeeCollection* _tmp2_;
	PluginEmailStore* _tmp3_;
	gpointer _tmp4_;
	PluginEmailIdentifier* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* _tmp7_;
	GCancellable* _tmp8_;
	GeeCollection* _tmp9_;
	GeeCollection* _tmp10_;
	PluginEmail* message;
	gpointer _tmp11_;
	PluginEmail* _tmp12_;
	PluginEmail* _tmp13_;
	GError* _error_;
	GError* _tmp14_;
	const gchar* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GError* _inner_error0_;
};

static gint PluginDesktopNotifications_private_offset;
static gpointer plugin_desktop_notifications_parent_class = NULL;
static PluginNotificationExtensionIface * plugin_desktop_notifications_plugin_notification_extension_parent_iface = NULL;
static PluginFolderExtensionIface * plugin_desktop_notifications_plugin_folder_extension_parent_iface = NULL;
static PluginEmailExtensionIface * plugin_desktop_notifications_plugin_email_extension_parent_iface = NULL;
static PluginTrustedExtensionIface * plugin_desktop_notifications_plugin_trusted_extension_parent_iface = NULL;
static GType plugin_desktop_notifications_type_id = 0;

static void plugin_desktop_notifications_real_activate_data_free (gpointer _data);
static void plugin_desktop_notifications_real_activate (PluginPluginBase* base,
                                                 gboolean is_startup,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static gboolean plugin_desktop_notifications_real_activate_co (PluginDesktopNotificationsActivateData* _data_);
static void plugin_desktop_notifications_activate_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_);
static void plugin_desktop_notifications_on_new_messages_arrived (PluginDesktopNotifications* self,
                                                           PluginFolder* folder,
                                                           gint total,
                                                           GeeCollection* added);
static void _plugin_desktop_notifications_on_new_messages_arrived_plugin_notification_context_new_messages_arrived (PluginNotificationContext* _sender,
                                                                                                             PluginFolder* parent,
                                                                                                             gint total,
                                                                                                             GeeCollection* added,
                                                                                                             gpointer self);
static void plugin_desktop_notifications_on_new_messages_retired (PluginDesktopNotifications* self,
                                                           PluginFolder* folder,
                                                           gint total);
static void _plugin_desktop_notifications_on_new_messages_retired_plugin_notification_context_new_messages_retired (PluginNotificationContext* _sender,
                                                                                                             PluginFolder* parent,
                                                                                                             gint total,
                                                                                                             gpointer self);
static void __lambda4_ (PluginDesktopNotifications* self,
                 GeeCollection* folders);
static void plugin_desktop_notifications_check_folders (PluginDesktopNotifications* self,
                                                 GeeCollection* folders);
static void ___lambda4__plugin_folder_store_folders_available (PluginFolderStore* _sender,
                                                        GeeCollection* available,
                                                        gpointer self);
static void __lambda5_ (PluginDesktopNotifications* self,
                 GeeCollection* folders);
static void ___lambda5__plugin_folder_store_folders_unavailable (PluginFolderStore* _sender,
                                                          GeeCollection* unavailable,
                                                          gpointer self);
static void __lambda6_ (PluginDesktopNotifications* self,
                 GeeCollection* folders);
static void ___lambda6__plugin_folder_store_folders_type_changed (PluginFolderStore* _sender,
                                                           GeeCollection* changed,
                                                           gpointer self);
static void plugin_desktop_notifications_real_deactivate_data_free (gpointer _data);
static void plugin_desktop_notifications_real_deactivate (PluginPluginBase* base,
                                                   gboolean is_shutdown,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static gboolean plugin_desktop_notifications_real_deactivate_co (PluginDesktopNotificationsDeactivateData* _data_);
static void plugin_desktop_notifications_clear_arrived_notification (PluginDesktopNotifications* self);
static void plugin_desktop_notifications_notify_specific_message_data_free (gpointer _data);
static void plugin_desktop_notifications_notify_specific_message (PluginDesktopNotifications* self,
                                                           PluginFolder* folder,
                                                           gint total,
                                                           PluginEmail* email,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
static void plugin_desktop_notifications_notify_specific_message_finish (PluginDesktopNotifications* self,
                                                                  GAsyncResult* _res_,
                                                                  GError** error);
static gboolean plugin_desktop_notifications_notify_specific_message_co (PluginDesktopNotificationsNotifySpecificMessageData* _data_);
static inline gchar* plugin_desktop_notifications_to_notitication_title (PluginDesktopNotifications* self,
                                                           PluginAccount* account,
                                                           gint count);
static void plugin_desktop_notifications_notify_specific_message_ready (GObject* source_object,
                                                                 GAsyncResult* _res_,
                                                                 gpointer _user_data_);
static void plugin_desktop_notifications_issue_arrived_notification (PluginDesktopNotifications* self,
                                                              const gchar* summary,
                                                              const gchar* body,
                                                              GIcon* icon,
                                                              PluginFolder* folder,
                                                              PluginEmailIdentifier* id);
static void plugin_desktop_notifications_notify_general (PluginDesktopNotifications* self,
                                                  PluginFolder* folder,
                                                  gint total,
                                                  gint added);
static GNotification* plugin_desktop_notifications_issue_notification (PluginDesktopNotifications* self,
                                                                const gchar* id,
                                                                const gchar* summary,
                                                                const gchar* body,
                                                                GIcon* icon,
                                                                const gchar* action,
                                                                GVariant* action_target);
static void plugin_desktop_notifications_handle_new_messages_data_free (gpointer _data);
static void plugin_desktop_notifications_handle_new_messages (PluginDesktopNotifications* self,
                                                       PluginFolder* folder,
                                                       gint total,
                                                       GeeCollection* added,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static void plugin_desktop_notifications_handle_new_messages_finish (PluginDesktopNotifications* self,
                                                              GAsyncResult* _res_);
static gboolean plugin_desktop_notifications_handle_new_messages_co (PluginDesktopNotificationsHandleNewMessagesData* _data_);
static void plugin_desktop_notifications_handle_new_messages_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
static gboolean _vala_geary_folder_special_use_array_contains (GearyFolderSpecialUse * stack,
                                                        gssize stack_length,
                                                        const GearyFolderSpecialUse needle);
static void plugin_desktop_notifications_finalize (GObject * obj);
static void _vala_plugin_desktop_notifications_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_plugin_desktop_notifications_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);

static const GearyFolderSpecialUse PLUGIN_DESKTOP_NOTIFICATIONS_MONITORED_TYPES[2] = {GEARY_FOLDER_SPECIAL_USE_INBOX, GEARY_FOLDER_SPECIAL_USE_NONE};

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* obj = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (module, g_type_module_get_type ()));
	plugin_desktop_notifications_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	obj = _tmp0_;
	peas_object_module_register_extension_type (obj, PLUGIN_TYPE_PLUGIN_BASE, PLUGIN_TYPE_DESKTOP_NOTIFICATIONS);
	_g_object_unref0 (obj);
}

static inline gpointer
plugin_desktop_notifications_get_instance_private (PluginDesktopNotifications* self)
{
	return G_STRUCT_MEMBER_P (self, PluginDesktopNotifications_private_offset);
}

static PluginNotificationContext*
plugin_desktop_notifications_real_get_notifications (PluginNotificationExtension* base)
{
	PluginNotificationContext* result;
	PluginDesktopNotifications* self;
	PluginNotificationContext* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PLUGIN_TYPE_DESKTOP_NOTIFICATIONS, PluginDesktopNotifications);
	_tmp0_ = self->priv->_notifications;
	result = _tmp0_;
	return result;
}

static void
plugin_desktop_notifications_real_set_notifications (PluginNotificationExtension* base,
                                                     PluginNotificationContext* value)
{
	PluginDesktopNotifications* self;
	PluginNotificationContext* old_value;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PLUGIN_TYPE_DESKTOP_NOTIFICATIONS, PluginDesktopNotifications);
	old_value = plugin_desktop_notifications_real_get_notifications (base);
	if (old_value != value) {
		PluginNotificationContext* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_notifications);
		self->priv->_notifications = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plugin_desktop_notifications_properties[PLUGIN_DESKTOP_NOTIFICATIONS_NOTIFICATIONS_PROPERTY]);
	}
}

static PluginFolderContext*
plugin_desktop_notifications_real_get_folders (PluginFolderExtension* base)
{
	PluginFolderContext* result;
	PluginDesktopNotifications* self;
	PluginFolderContext* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PLUGIN_TYPE_DESKTOP_NOTIFICATIONS, PluginDesktopNotifications);
	_tmp0_ = self->priv->_folders;
	result = _tmp0_;
	return result;
}

static void
plugin_desktop_notifications_real_set_folders (PluginFolderExtension* base,
                                               PluginFolderContext* value)
{
	PluginDesktopNotifications* self;
	PluginFolderContext* old_value;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PLUGIN_TYPE_DESKTOP_NOTIFICATIONS, PluginDesktopNotifications);
	old_value = plugin_desktop_notifications_real_get_folders (base);
	if (old_value != value) {
		PluginFolderContext* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_folders);
		self->priv->_folders = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plugin_desktop_notifications_properties[PLUGIN_DESKTOP_NOTIFICATIONS_FOLDERS_PROPERTY]);
	}
}

static PluginEmailContext*
plugin_desktop_notifications_real_get_email (PluginEmailExtension* base)
{
	PluginEmailContext* result;
	PluginDesktopNotifications* self;
	PluginEmailContext* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PLUGIN_TYPE_DESKTOP_NOTIFICATIONS, PluginDesktopNotifications);
	_tmp0_ = self->priv->_email;
	result = _tmp0_;
	return result;
}

static void
plugin_desktop_notifications_real_set_email (PluginEmailExtension* base,
                                             PluginEmailContext* value)
{
	PluginDesktopNotifications* self;
	PluginEmailContext* old_value;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PLUGIN_TYPE_DESKTOP_NOTIFICATIONS, PluginDesktopNotifications);
	old_value = plugin_desktop_notifications_real_get_email (base);
	if (old_value != value) {
		PluginEmailContext* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_email);
		self->priv->_email = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plugin_desktop_notifications_properties[PLUGIN_DESKTOP_NOTIFICATIONS_EMAIL_PROPERTY]);
	}
}

static ApplicationClient*
plugin_desktop_notifications_real_get_client_application (PluginTrustedExtension* base)
{
	ApplicationClient* result;
	PluginDesktopNotifications* self;
	ApplicationClient* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PLUGIN_TYPE_DESKTOP_NOTIFICATIONS, PluginDesktopNotifications);
	_tmp0_ = self->priv->_client_application;
	result = _tmp0_;
	return result;
}

static void
plugin_desktop_notifications_real_set_client_application (PluginTrustedExtension* base,
                                                          ApplicationClient* value)
{
	PluginDesktopNotifications* self;
	ApplicationClient* old_value;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PLUGIN_TYPE_DESKTOP_NOTIFICATIONS, PluginDesktopNotifications);
	old_value = plugin_desktop_notifications_real_get_client_application (base);
	if (old_value != value) {
		ApplicationClient* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_client_application);
		self->priv->_client_application = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plugin_desktop_notifications_properties[PLUGIN_DESKTOP_NOTIFICATIONS_CLIENT_APPLICATION_PROPERTY]);
	}
}

static ApplicationPluginManager*
plugin_desktop_notifications_real_get_client_plugins (PluginTrustedExtension* base)
{
	ApplicationPluginManager* result;
	PluginDesktopNotifications* self;
	ApplicationPluginManager* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PLUGIN_TYPE_DESKTOP_NOTIFICATIONS, PluginDesktopNotifications);
	_tmp0_ = self->priv->_client_plugins;
	result = _tmp0_;
	return result;
}

static void
plugin_desktop_notifications_real_set_client_plugins (PluginTrustedExtension* base,
                                                      ApplicationPluginManager* value)
{
	PluginDesktopNotifications* self;
	ApplicationPluginManager* old_value;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PLUGIN_TYPE_DESKTOP_NOTIFICATIONS, PluginDesktopNotifications);
	old_value = plugin_desktop_notifications_real_get_client_plugins (base);
	if (old_value != value) {
		ApplicationPluginManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_client_plugins);
		self->priv->_client_plugins = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, plugin_desktop_notifications_properties[PLUGIN_DESKTOP_NOTIFICATIONS_CLIENT_PLUGINS_PROPERTY]);
	}
}

static void
plugin_desktop_notifications_real_activate_data_free (gpointer _data)
{
	PluginDesktopNotificationsActivateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PluginDesktopNotificationsActivateData, _data_);
}

static void
plugin_desktop_notifications_real_activate (PluginPluginBase* base,
                                            gboolean is_startup,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	PluginDesktopNotifications * self;
	PluginDesktopNotificationsActivateData* _data_;
	PluginDesktopNotifications* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PLUGIN_TYPE_DESKTOP_NOTIFICATIONS, PluginDesktopNotifications);
	_data_ = g_slice_new0 (PluginDesktopNotificationsActivateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, plugin_desktop_notifications_real_activate_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->is_startup = is_startup;
	plugin_desktop_notifications_real_activate_co (_data_);
}

static void
plugin_desktop_notifications_activate_finish (PluginPluginBase* base,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	PluginDesktopNotificationsActivateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
plugin_desktop_notifications_activate_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_)
{
	PluginDesktopNotificationsActivateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	plugin_desktop_notifications_real_activate_co (_data_);
}

static void
_plugin_desktop_notifications_on_new_messages_arrived_plugin_notification_context_new_messages_arrived (PluginNotificationContext* _sender,
                                                                                                        PluginFolder* parent,
                                                                                                        gint total,
                                                                                                        GeeCollection* added,
                                                                                                        gpointer self)
{
	plugin_desktop_notifications_on_new_messages_arrived ((PluginDesktopNotifications*) self, parent, total, added);
}

static void
_plugin_desktop_notifications_on_new_messages_retired_plugin_notification_context_new_messages_retired (PluginNotificationContext* _sender,
                                                                                                        PluginFolder* parent,
                                                                                                        gint total,
                                                                                                        gpointer self)
{
	plugin_desktop_notifications_on_new_messages_retired ((PluginDesktopNotifications*) self, parent, total);
}

static void
__lambda4_ (PluginDesktopNotifications* self,
            GeeCollection* folders)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folders, GEE_TYPE_COLLECTION));
	plugin_desktop_notifications_check_folders (self, folders);
}

static void
___lambda4__plugin_folder_store_folders_available (PluginFolderStore* _sender,
                                                   GeeCollection* available,
                                                   gpointer self)
{
	__lambda4_ ((PluginDesktopNotifications*) self, available);
}

static void
__lambda5_ (PluginDesktopNotifications* self,
            GeeCollection* folders)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folders, GEE_TYPE_COLLECTION));
	plugin_desktop_notifications_check_folders (self, folders);
}

static void
___lambda5__plugin_folder_store_folders_unavailable (PluginFolderStore* _sender,
                                                     GeeCollection* unavailable,
                                                     gpointer self)
{
	__lambda5_ ((PluginDesktopNotifications*) self, unavailable);
}

static void
__lambda6_ (PluginDesktopNotifications* self,
            GeeCollection* folders)
{
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folders, GEE_TYPE_COLLECTION));
	plugin_desktop_notifications_check_folders (self, folders);
}

static void
___lambda6__plugin_folder_store_folders_type_changed (PluginFolderStore* _sender,
                                                      GeeCollection* changed,
                                                      gpointer self)
{
	__lambda6_ ((PluginDesktopNotifications*) self, changed);
}

static gboolean
plugin_desktop_notifications_real_activate_co (PluginDesktopNotificationsActivateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_cancellable_new ();
	_g_object_unref0 (_data_->self->priv->cancellable);
	_data_->self->priv->cancellable = _data_->_tmp0_;
	_data_->_tmp2_ = plugin_email_extension_get_email (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PLUGIN_TYPE_EMAIL_EXTENSION, PluginEmailExtension));
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_state_ = 1;
	plugin_email_context_get_email_store (_data_->_tmp3_, plugin_desktop_notifications_activate_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = plugin_email_context_get_email_store_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp1_ = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->_tmp1_;
	_data_->_tmp1_ = NULL;
	_g_object_unref0 (_data_->self->priv->email_store);
	_data_->self->priv->email_store = _data_->_tmp5_;
	_data_->_tmp6_ = plugin_notification_extension_get_notifications (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PLUGIN_TYPE_NOTIFICATION_EXTENSION, PluginNotificationExtension));
	_data_->_tmp7_ = _data_->_tmp6_;
	g_signal_connect_object (_data_->_tmp7_, "new-messages-arrived", (GCallback) _plugin_desktop_notifications_on_new_messages_arrived_plugin_notification_context_new_messages_arrived, _data_->self, 0);
	_data_->_tmp8_ = plugin_notification_extension_get_notifications (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PLUGIN_TYPE_NOTIFICATION_EXTENSION, PluginNotificationExtension));
	_data_->_tmp9_ = _data_->_tmp8_;
	g_signal_connect_object (_data_->_tmp9_, "new-messages-retired", (GCallback) _plugin_desktop_notifications_on_new_messages_retired_plugin_notification_context_new_messages_retired, _data_->self, 0);
	_data_->_tmp10_ = plugin_folder_extension_get_folders (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PLUGIN_TYPE_FOLDER_EXTENSION, PluginFolderExtension));
	_data_->_tmp11_ = _data_->_tmp10_;
	_data_->_state_ = 2;
	plugin_folder_context_get_folder_store (_data_->_tmp11_, plugin_desktop_notifications_activate_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp12_ = plugin_folder_context_get_folder_store_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error0_);
	_data_->folder_store = _data_->_tmp12_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp1_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp13_ = _data_->folder_store;
	g_signal_connect_object (_data_->_tmp13_, "folders-available", (GCallback) ___lambda4__plugin_folder_store_folders_available, _data_->self, 0);
	_data_->_tmp14_ = _data_->folder_store;
	g_signal_connect_object (_data_->_tmp14_, "folders-unavailable", (GCallback) ___lambda5__plugin_folder_store_folders_unavailable, _data_->self, 0);
	_data_->_tmp15_ = _data_->folder_store;
	g_signal_connect_object (_data_->_tmp15_, "folders-type-changed", (GCallback) ___lambda6__plugin_folder_store_folders_type_changed, _data_->self, 0);
	_data_->_tmp16_ = _data_->folder_store;
	_data_->_tmp17_ = plugin_folder_store_get_folders (_data_->_tmp16_);
	_data_->_tmp18_ = _data_->_tmp17_;
	plugin_desktop_notifications_check_folders (_data_->self, _data_->_tmp18_);
	_g_object_unref0 (_data_->_tmp18_);
	_g_object_unref0 (_data_->folder_store);
	_g_object_unref0 (_data_->_tmp1_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
plugin_desktop_notifications_real_deactivate_data_free (gpointer _data)
{
	PluginDesktopNotificationsDeactivateData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PluginDesktopNotificationsDeactivateData, _data_);
}

static void
plugin_desktop_notifications_real_deactivate (PluginPluginBase* base,
                                              gboolean is_shutdown,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	PluginDesktopNotifications * self;
	PluginDesktopNotificationsDeactivateData* _data_;
	PluginDesktopNotifications* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PLUGIN_TYPE_DESKTOP_NOTIFICATIONS, PluginDesktopNotifications);
	_data_ = g_slice_new0 (PluginDesktopNotificationsDeactivateData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, plugin_desktop_notifications_real_deactivate_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->is_shutdown = is_shutdown;
	plugin_desktop_notifications_real_deactivate_co (_data_);
}

static void
plugin_desktop_notifications_deactivate_finish (PluginPluginBase* base,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	PluginDesktopNotificationsDeactivateData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
plugin_desktop_notifications_real_deactivate_co (PluginDesktopNotificationsDeactivateData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->cancellable;
	g_cancellable_cancel (_data_->_tmp0_);
	if (!_data_->is_shutdown) {
		plugin_desktop_notifications_clear_arrived_notification (_data_->self);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
plugin_desktop_notifications_clear_arrived_notification (PluginDesktopNotifications* self)
{
	ApplicationClient* _tmp0_;
	ApplicationClient* _tmp1_;
	g_return_if_fail (PLUGIN_IS_DESKTOP_NOTIFICATIONS (self));
	_tmp0_ = plugin_trusted_extension_get_client_application (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_TRUSTED_EXTENSION, PluginTrustedExtension));
	_tmp1_ = _tmp0_;
	g_application_withdraw_notification (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_application_get_type (), GApplication), PLUGIN_DESKTOP_NOTIFICATIONS_ARRIVED_ID);
	_g_object_unref0 (self->priv->arrived_notification);
	self->priv->arrived_notification = NULL;
}

static void
plugin_desktop_notifications_notify_specific_message_data_free (gpointer _data)
{
	PluginDesktopNotificationsNotifySpecificMessageData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->folder);
	_g_object_unref0 (_data_->email);
	_g_object_unref0 (_data_->self);
	g_slice_free (PluginDesktopNotificationsNotifySpecificMessageData, _data_);
}

static void
plugin_desktop_notifications_notify_specific_message (PluginDesktopNotifications* self,
                                                      PluginFolder* folder,
                                                      gint total,
                                                      PluginEmail* email,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	PluginDesktopNotificationsNotifySpecificMessageData* _data_;
	PluginDesktopNotifications* _tmp0_;
	PluginFolder* _tmp1_;
	PluginEmail* _tmp2_;
	g_return_if_fail (PLUGIN_IS_DESKTOP_NOTIFICATIONS (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folder, PLUGIN_TYPE_FOLDER));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (email, PLUGIN_TYPE_EMAIL));
	_data_ = g_slice_new0 (PluginDesktopNotificationsNotifySpecificMessageData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, plugin_desktop_notifications_notify_specific_message_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (folder);
	_g_object_unref0 (_data_->folder);
	_data_->folder = _tmp1_;
	_data_->total = total;
	_tmp2_ = _g_object_ref0 (email);
	_g_object_unref0 (_data_->email);
	_data_->email = _tmp2_;
	plugin_desktop_notifications_notify_specific_message_co (_data_);
}

static void
plugin_desktop_notifications_notify_specific_message_finish (PluginDesktopNotifications* self,
                                                             GAsyncResult* _res_,
                                                             GError** error)
{
	PluginDesktopNotificationsNotifySpecificMessageData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
plugin_desktop_notifications_notify_specific_message_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_)
{
	PluginDesktopNotificationsNotifySpecificMessageData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	plugin_desktop_notifications_notify_specific_message_co (_data_);
}

static gboolean
plugin_desktop_notifications_notify_specific_message_co (PluginDesktopNotificationsNotifySpecificMessageData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = plugin_folder_get_account (_data_->folder);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = plugin_desktop_notifications_to_notitication_title (_data_->self, _data_->_tmp1_, _data_->total);
	_data_->title = _data_->_tmp2_;
	_data_->icon = NULL;
	_data_->_tmp3_ = plugin_email_get_primary_originator (_data_->email);
	_data_->originator = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->originator;
	if (_data_->_tmp4_ != NULL) {
		_data_->_tmp5_ = plugin_notification_extension_get_notifications (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PLUGIN_TYPE_NOTIFICATION_EXTENSION, PluginNotificationExtension));
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_state_ = 1;
		plugin_notification_context_get_contacts_for_folder (_data_->_tmp6_, _data_->folder, plugin_desktop_notifications_notify_specific_message_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp7_ = plugin_notification_context_get_contacts_for_folder_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
		_data_->contacts = _data_->_tmp7_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->originator);
			_g_object_unref0 (_data_->icon);
			_g_free0 (_data_->title);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp8_ = _data_->contacts;
		_data_->_tmp9_ = _data_->originator;
		_data_->_tmp10_ = _data_->self->priv->cancellable;
		_data_->_state_ = 2;
		plugin_contact_store_load (_data_->_tmp8_, _data_->_tmp9_, _data_->_tmp10_, plugin_desktop_notifications_notify_specific_message_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp11_ = plugin_contact_store_load_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error0_);
		_data_->contact = _data_->_tmp11_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->contacts);
			_g_object_unref0 (_data_->originator);
			_g_object_unref0 (_data_->icon);
			_g_free0 (_data_->title);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp13_ = _data_->contact;
		_data_->_tmp14_ = application_contact_get_is_trusted (_data_->_tmp13_);
		_data_->_tmp15_ = _data_->_tmp14_;
		if (_data_->_tmp15_) {
			_data_->_tmp16_ = _data_->contact;
			_data_->_tmp17_ = application_contact_get_display_name (_data_->_tmp16_);
			_data_->_tmp18_ = _data_->_tmp17_;
			_data_->_tmp19_ = g_strdup (_data_->_tmp18_);
			_g_free0 (_data_->_tmp12_);
			_data_->_tmp12_ = _data_->_tmp19_;
		} else {
			_data_->_tmp20_ = _data_->originator;
			_data_->_tmp21_ = geary_rf_c822_mailbox_address_to_short_display (_data_->_tmp20_);
			_g_free0 (_data_->_tmp12_);
			_data_->_tmp12_ = _data_->_tmp21_;
		}
		_data_->_tmp22_ = g_strdup (_data_->_tmp12_);
		_g_free0 (_data_->title);
		_data_->title = _data_->_tmp22_;
		_data_->_tmp23_ = _data_->contact;
		_data_->_tmp24_ = application_contact_get_avatar (_data_->_tmp23_);
		_data_->_tmp25_ = _data_->_tmp24_;
		_data_->_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp25_, g_icon_get_type (), GIcon));
		_g_object_unref0 (_data_->icon);
		_data_->icon = _data_->_tmp26_;
		_g_free0 (_data_->_tmp12_);
		_g_object_unref0 (_data_->contact);
		_g_object_unref0 (_data_->contacts);
	}
	_data_->_tmp27_ = util_email_strip_subject_prefixes (G_TYPE_CHECK_INSTANCE_CAST (_data_->email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
	_data_->body = _data_->_tmp27_;
	if (_data_->total > 1) {
		_data_->_tmp28_ = _data_->body;
		_data_->_tmp29_ = g_strdup_printf (ngettext ("%s\n(%d other new message)", "%s\n(%d other new messages)", (gulong) (_data_->total - 1)), _data_->_tmp28_, _data_->total - 1);
		_g_free0 (_data_->body);
		_data_->body = _data_->_tmp29_;
	}
	_data_->window_scale = 1;
	_data_->_tmp30_ = gdk_display_get_default ();
	_data_->_tmp31_ = _g_object_ref0 (_data_->_tmp30_);
	_data_->display = _data_->_tmp31_;
	_data_->_tmp32_ = _data_->display;
	if (_data_->_tmp32_ != NULL) {
		_data_->_tmp33_ = _data_->display;
		_data_->_tmp34_ = gdk_display_get_primary_monitor (_data_->_tmp33_);
		_data_->_tmp35_ = _g_object_ref0 (_data_->_tmp34_);
		_data_->monitor = _data_->_tmp35_;
		_data_->_tmp36_ = _data_->monitor;
		if (_data_->_tmp36_ != NULL) {
			_data_->_tmp37_ = _data_->monitor;
			_data_->_tmp38_ = gdk_monitor_get_scale_factor (_data_->_tmp37_);
			_data_->_tmp39_ = _data_->_tmp38_;
			_data_->window_scale = _data_->_tmp39_;
		}
		_g_object_unref0 (_data_->monitor);
	}
	_data_->_tmp40_ = _data_->title;
	_data_->_tmp41_ = (HdyAvatar*) hdy_avatar_new (32, _data_->_tmp40_, TRUE);
	g_object_ref_sink (_data_->_tmp41_);
	_data_->avatar = _data_->_tmp41_;
	_data_->_tmp42_ = _data_->avatar;
	_data_->_tmp43_ = _data_->icon;
	hdy_avatar_set_loadable_icon (_data_->_tmp42_, G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp43_, g_loadable_icon_get_type ()) ? ((GLoadableIcon*) _data_->_tmp43_) : NULL);
	_data_->_tmp44_ = _data_->avatar;
	_data_->_state_ = 3;
	hdy_avatar_draw_to_pixbuf_async (_data_->_tmp44_, 32, _data_->window_scale, NULL, plugin_desktop_notifications_notify_specific_message_ready, _data_);
	return FALSE;
	_state_3:
	_data_->_tmp45_ = hdy_avatar_draw_to_pixbuf_finish (_data_->_tmp44_, _data_->_res_);
	_g_object_unref0 (_data_->icon);
	_data_->icon = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp45_, g_icon_get_type (), GIcon);
	_data_->_tmp46_ = _data_->title;
	_data_->_tmp47_ = _data_->body;
	_data_->_tmp48_ = _data_->icon;
	_data_->_tmp49_ = plugin_email_get_identifier (_data_->email);
	_data_->_tmp50_ = _data_->_tmp49_;
	plugin_desktop_notifications_issue_arrived_notification (_data_->self, _data_->_tmp46_, _data_->_tmp47_, _data_->_tmp48_, _data_->folder, _data_->_tmp50_);
	_g_object_unref0 (_data_->avatar);
	_g_object_unref0 (_data_->display);
	_g_free0 (_data_->body);
	_g_object_unref0 (_data_->originator);
	_g_object_unref0 (_data_->icon);
	_g_free0 (_data_->title);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
plugin_desktop_notifications_notify_general (PluginDesktopNotifications* self,
                                             PluginFolder* folder,
                                             gint total,
                                             gint added)
{
	GIcon* icon = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GThemedIcon* _tmp2_;
	GIcon* _tmp3_;
	gchar* title = NULL;
	PluginAccount* _tmp4_;
	PluginAccount* _tmp5_;
	gchar* _tmp6_;
	gchar* body = NULL;
	gchar* _tmp7_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GIcon* _tmp12_;
	g_return_if_fail (PLUGIN_IS_DESKTOP_NOTIFICATIONS (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folder, PLUGIN_TYPE_FOLDER));
	_tmp0_ = g_strdup_printf ("%s-symbolic", APPLICATION_CLIENT_APP_ID);
	_tmp1_ = _tmp0_;
	_tmp2_ = (GThemedIcon*) g_themed_icon_new (_tmp1_);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, g_icon_get_type (), GIcon);
	_g_free0 (_tmp1_);
	icon = _tmp3_;
	_tmp4_ = plugin_folder_get_account (folder);
	_tmp5_ = _tmp4_;
	_tmp6_ = plugin_desktop_notifications_to_notitication_title (self, _tmp5_, total);
	title = _tmp6_;
	_tmp7_ = g_strdup_printf (ngettext ("%d new message", "%d new messages", (gulong) added), added);
	body = _tmp7_;
	if (total > added) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = body;
		_tmp9_ = g_strdup_printf (ngettext ("%s, %d new message total", "%s, %d new messages total", (gulong) total), _tmp8_, total);
		_g_free0 (body);
		body = _tmp9_;
	}
	_tmp10_ = title;
	_tmp11_ = body;
	_tmp12_ = icon;
	plugin_desktop_notifications_issue_arrived_notification (self, _tmp10_, _tmp11_, _tmp12_, folder, NULL);
	_g_free0 (body);
	_g_free0 (title);
	_g_object_unref0 (icon);
}

static void
plugin_desktop_notifications_issue_arrived_notification (PluginDesktopNotifications* self,
                                                         const gchar* summary,
                                                         const gchar* body,
                                                         GIcon* icon,
                                                         PluginFolder* folder,
                                                         PluginEmailIdentifier* id)
{
	gchar* action = NULL;
	GVariant* target_param = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GVariant* _tmp7_;
	GNotification* _tmp8_;
	g_return_if_fail (PLUGIN_IS_DESKTOP_NOTIFICATIONS (self));
	g_return_if_fail (summary != NULL);
	g_return_if_fail (body != NULL);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (icon, g_icon_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folder, PLUGIN_TYPE_FOLDER));
	g_return_if_fail ((id == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (id, PLUGIN_TYPE_EMAIL_IDENTIFIER));
	plugin_desktop_notifications_clear_arrived_notification (self);
	action = NULL;
	target_param = NULL;
	if (id == NULL) {
		gchar* _tmp0_;
		GVariant* _tmp1_;
		_tmp0_ = g_strdup (ACTION_APPLICATION_SHOW_FOLDER);
		_g_free0 (action);
		action = _tmp0_;
		_tmp1_ = plugin_folder_to_variant (folder);
		_g_variant_unref0 (target_param);
		target_param = _tmp1_;
	} else {
		gchar* _tmp2_;
		GVariant* _tmp3_;
		_tmp2_ = g_strdup (ACTION_APPLICATION_SHOW_EMAIL);
		_g_free0 (action);
		action = _tmp2_;
		_tmp3_ = plugin_email_identifier_to_variant (id);
		_g_variant_unref0 (target_param);
		target_param = _tmp3_;
	}
	_tmp4_ = action;
	_tmp5_ = action_application_prefix (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = target_param;
	_tmp8_ = plugin_desktop_notifications_issue_notification (self, PLUGIN_DESKTOP_NOTIFICATIONS_ARRIVED_ID, summary, body, icon, _tmp6_, _tmp7_);
	_g_object_unref0 (self->priv->arrived_notification);
	self->priv->arrived_notification = _tmp8_;
	_g_free0 (_tmp6_);
	_g_variant_unref0 (target_param);
	_g_free0 (action);
}

static GNotification*
plugin_desktop_notifications_issue_notification (PluginDesktopNotifications* self,
                                                 const gchar* id,
                                                 const gchar* summary,
                                                 const gchar* body,
                                                 GIcon* icon,
                                                 const gchar* action,
                                                 GVariant* action_target)
{
	GNotification* notification = NULL;
	GNotification* _tmp0_;
	GNotification* _tmp1_;
	GNotification* _tmp2_;
	ApplicationClient* _tmp3_;
	ApplicationClient* _tmp4_;
	ApplicationConfiguration* _tmp5_;
	ApplicationConfiguration* _tmp6_;
	ApplicationConfigurationDesktopEnvironment _tmp7_;
	ApplicationConfigurationDesktopEnvironment _tmp8_;
	GNotification* result;
	g_return_val_if_fail (PLUGIN_IS_DESKTOP_NOTIFICATIONS (self), NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (summary != NULL, NULL);
	g_return_val_if_fail (body != NULL, NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (icon, g_icon_get_type ()), NULL);
	_tmp0_ = g_notification_new (summary);
	notification = _tmp0_;
	_tmp1_ = notification;
	g_notification_set_body (_tmp1_, body);
	_tmp2_ = notification;
	g_notification_set_icon (_tmp2_, icon);
	_tmp3_ = plugin_trusted_extension_get_client_application (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_TRUSTED_EXTENSION, PluginTrustedExtension));
	_tmp4_ = _tmp3_;
	_tmp5_ = application_client_get_config (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = application_configuration_get_desktop_environment (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == APPLICATION_CONFIGURATION_DESKTOP_ENVIRONMENT_UNITY) {
		ApplicationClient* _tmp9_;
		ApplicationClient* _tmp10_;
		GNotification* _tmp11_;
		_tmp9_ = plugin_trusted_extension_get_client_application (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_TRUSTED_EXTENSION, PluginTrustedExtension));
		_tmp10_ = _tmp9_;
		_tmp11_ = notification;
		g_application_send_notification (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_application_get_type (), GApplication), id, _tmp11_);
		result = notification;
		return result;
	} else {
		ApplicationClient* _tmp13_;
		ApplicationClient* _tmp14_;
		GNotification* _tmp15_;
		if (action != NULL) {
			GNotification* _tmp12_;
			_tmp12_ = notification;
			g_notification_set_default_action_and_target_value (_tmp12_, action, action_target);
		}
		_tmp13_ = plugin_trusted_extension_get_client_application (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_TRUSTED_EXTENSION, PluginTrustedExtension));
		_tmp14_ = _tmp13_;
		_tmp15_ = notification;
		g_application_send_notification (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, g_application_get_type (), GApplication), id, _tmp15_);
		result = notification;
		return result;
	}
}

static void
plugin_desktop_notifications_handle_new_messages_data_free (gpointer _data)
{
	PluginDesktopNotificationsHandleNewMessagesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->folder);
	_g_object_unref0 (_data_->added);
	_g_object_unref0 (_data_->self);
	g_slice_free (PluginDesktopNotificationsHandleNewMessagesData, _data_);
}

static void
plugin_desktop_notifications_handle_new_messages (PluginDesktopNotifications* self,
                                                  PluginFolder* folder,
                                                  gint total,
                                                  GeeCollection* added,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	PluginDesktopNotificationsHandleNewMessagesData* _data_;
	PluginDesktopNotifications* _tmp0_;
	PluginFolder* _tmp1_;
	GeeCollection* _tmp2_;
	g_return_if_fail (PLUGIN_IS_DESKTOP_NOTIFICATIONS (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folder, PLUGIN_TYPE_FOLDER));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_COLLECTION));
	_data_ = g_slice_new0 (PluginDesktopNotificationsHandleNewMessagesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, plugin_desktop_notifications_handle_new_messages_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (folder);
	_g_object_unref0 (_data_->folder);
	_data_->folder = _tmp1_;
	_data_->total = total;
	_tmp2_ = _g_object_ref0 (added);
	_g_object_unref0 (_data_->added);
	_data_->added = _tmp2_;
	plugin_desktop_notifications_handle_new_messages_co (_data_);
}

static void
plugin_desktop_notifications_handle_new_messages_finish (PluginDesktopNotifications* self,
                                                         GAsyncResult* _res_)
{
	PluginDesktopNotificationsHandleNewMessagesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
plugin_desktop_notifications_handle_new_messages_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	PluginDesktopNotificationsHandleNewMessagesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	plugin_desktop_notifications_handle_new_messages_co (_data_);
}

static gboolean
plugin_desktop_notifications_handle_new_messages_co (PluginDesktopNotificationsHandleNewMessagesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = plugin_notification_extension_get_notifications (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, PLUGIN_TYPE_NOTIFICATION_EXTENSION, PluginNotificationExtension));
	_data_->_tmp1_ = _data_->_tmp0_;
	if (plugin_notification_context_should_notify_new_messages (_data_->_tmp1_, _data_->folder)) {
		_data_->notified = FALSE;
		{
			_data_->_tmp3_ = _data_->self->priv->email_store;
			_data_->_tmp4_ = geary_collection_first (PLUGIN_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->added);
			_data_->_tmp5_ = (PluginEmailIdentifier*) _data_->_tmp4_;
			_data_->_tmp6_ = geary_collection_single (PLUGIN_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->_tmp5_);
			_data_->_tmp7_ = _data_->_tmp6_;
			_data_->_tmp8_ = _data_->self->priv->cancellable;
			_data_->_state_ = 1;
			plugin_email_store_get_email (_data_->_tmp3_, _data_->_tmp7_, _data_->_tmp8_, plugin_desktop_notifications_handle_new_messages_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp9_ = plugin_email_store_get_email_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp10_ = _data_->_tmp9_;
			_g_object_unref0 (_data_->_tmp7_);
			_g_object_unref0 (_data_->_tmp5_);
			_data_->_tmp2_ = _data_->_tmp10_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp11_ = geary_collection_first (PLUGIN_TYPE_EMAIL, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->_tmp2_);
			_data_->message = (PluginEmail*) _data_->_tmp11_;
			_data_->_tmp12_ = _data_->message;
			if (_data_->_tmp12_ != NULL) {
				_data_->_tmp13_ = _data_->message;
				_data_->_state_ = 2;
				plugin_desktop_notifications_notify_specific_message (_data_->self, _data_->folder, _data_->total, _data_->_tmp13_, plugin_desktop_notifications_handle_new_messages_ready, _data_);
				return FALSE;
				_state_2:
				plugin_desktop_notifications_notify_specific_message_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->message);
					_g_object_unref0 (_data_->_tmp2_);
					goto __catch0_g_error;
				}
				_data_->notified = TRUE;
			} else {
				g_warning ("desktop-notifications.vala:252: Could not load email for notification");
			}
			_g_object_unref0 (_data_->message);
			_g_object_unref0 (_data_->_tmp2_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->_error_ = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp14_ = _data_->_error_;
			_data_->_tmp15_ = _data_->_tmp14_->message;
			g_warning ("desktop-notifications.vala:255: Error loading email for notification: " \
"%s", _data_->_tmp15_);
			_g_error_free0 (_data_->_error_);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		if (!_data_->notified) {
			_data_->_tmp16_ = gee_collection_get_size (_data_->added);
			_data_->_tmp17_ = _data_->_tmp16_;
			plugin_desktop_notifications_notify_general (_data_->self, _data_->folder, _data_->total, _data_->_tmp17_);
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
_vala_geary_folder_special_use_array_contains (GearyFolderSpecialUse * stack,
                                               gssize stack_length,
                                               const GearyFolderSpecialUse needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
plugin_desktop_notifications_check_folders (PluginDesktopNotifications* self,
                                            GeeCollection* folders)
{
	g_return_if_fail (PLUGIN_IS_DESKTOP_NOTIFICATIONS (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folders, GEE_TYPE_COLLECTION));
	{
		GeeIterator* _folder_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (folders, GEE_TYPE_ITERABLE, GeeIterable));
		_folder_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			PluginFolder* folder = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			PluginFolder* _tmp4_;
			GearyFolderSpecialUse _tmp5_;
			GearyFolderSpecialUse _tmp6_;
			_tmp1_ = _folder_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _folder_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			folder = (PluginFolder*) _tmp3_;
			_tmp4_ = folder;
			_tmp5_ = plugin_folder_get_used_as (_tmp4_);
			_tmp6_ = _tmp5_;
			if (_vala_geary_folder_special_use_array_contains (PLUGIN_DESKTOP_NOTIFICATIONS_MONITORED_TYPES, G_N_ELEMENTS (PLUGIN_DESKTOP_NOTIFICATIONS_MONITORED_TYPES), _tmp6_)) {
				PluginNotificationContext* _tmp7_;
				PluginNotificationContext* _tmp8_;
				PluginFolder* _tmp9_;
				_tmp7_ = plugin_notification_extension_get_notifications (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_NOTIFICATION_EXTENSION, PluginNotificationExtension));
				_tmp8_ = _tmp7_;
				_tmp9_ = folder;
				plugin_notification_context_start_monitoring_folder (_tmp8_, _tmp9_);
			} else {
				PluginNotificationContext* _tmp10_;
				PluginNotificationContext* _tmp11_;
				PluginFolder* _tmp12_;
				_tmp10_ = plugin_notification_extension_get_notifications (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_NOTIFICATION_EXTENSION, PluginNotificationExtension));
				_tmp11_ = _tmp10_;
				_tmp12_ = folder;
				plugin_notification_context_stop_monitoring_folder (_tmp11_, _tmp12_);
			}
			_g_object_unref0 (folder);
		}
		_g_object_unref0 (_folder_it);
	}
}

static inline gchar*
plugin_desktop_notifications_to_notitication_title (PluginDesktopNotifications* self,
                                                    PluginAccount* account,
                                                    gint count)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (PLUGIN_IS_DESKTOP_NOTIFICATIONS (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, PLUGIN_TYPE_ACCOUNT), NULL);
	_tmp0_ = g_strdup (ngettext ("New message", "New messages", (gulong) count));
	result = _tmp0_;
	return result;
}

static void
plugin_desktop_notifications_on_new_messages_arrived (PluginDesktopNotifications* self,
                                                      PluginFolder* folder,
                                                      gint total,
                                                      GeeCollection* added)
{
	g_return_if_fail (PLUGIN_IS_DESKTOP_NOTIFICATIONS (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folder, PLUGIN_TYPE_FOLDER));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_COLLECTION));
	plugin_desktop_notifications_handle_new_messages (self, folder, total, added, NULL, NULL);
}

static void
plugin_desktop_notifications_on_new_messages_retired (PluginDesktopNotifications* self,
                                                      PluginFolder* folder,
                                                      gint total)
{
	g_return_if_fail (PLUGIN_IS_DESKTOP_NOTIFICATIONS (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (folder, PLUGIN_TYPE_FOLDER));
	plugin_desktop_notifications_clear_arrived_notification (self);
}

PluginDesktopNotifications*
plugin_desktop_notifications_construct (GType object_type)
{
	PluginDesktopNotifications * self = NULL;
	self = (PluginDesktopNotifications*) plugin_plugin_base_construct (object_type);
	return self;
}

PluginDesktopNotifications*
plugin_desktop_notifications_new (void)
{
	return plugin_desktop_notifications_construct (PLUGIN_TYPE_DESKTOP_NOTIFICATIONS);
}

static void
plugin_desktop_notifications_class_init (PluginDesktopNotificationsClass * klass,
                                         gpointer klass_data)
{
	plugin_desktop_notifications_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PluginDesktopNotifications_private_offset);
	((PluginPluginBaseClass *) klass)->activate = (void (*) (PluginPluginBase*, gboolean, GAsyncReadyCallback, gpointer)) plugin_desktop_notifications_real_activate;
	((PluginPluginBaseClass *) klass)->activate_finish = (void (*) (PluginPluginBase*, GAsyncResult*, GError**)) plugin_desktop_notifications_activate_finish;
	((PluginPluginBaseClass *) klass)->deactivate = (void (*) (PluginPluginBase*, gboolean, GAsyncReadyCallback, gpointer)) plugin_desktop_notifications_real_deactivate;
	((PluginPluginBaseClass *) klass)->deactivate_finish = (void (*) (PluginPluginBase*, GAsyncResult*, GError**)) plugin_desktop_notifications_deactivate_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_plugin_desktop_notifications_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_plugin_desktop_notifications_set_property;
	G_OBJECT_CLASS (klass)->finalize = plugin_desktop_notifications_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLUGIN_DESKTOP_NOTIFICATIONS_NOTIFICATIONS_PROPERTY, plugin_desktop_notifications_properties[PLUGIN_DESKTOP_NOTIFICATIONS_NOTIFICATIONS_PROPERTY] = g_param_spec_object ("notifications", "notifications", "notifications", PLUGIN_TYPE_NOTIFICATION_CONTEXT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLUGIN_DESKTOP_NOTIFICATIONS_FOLDERS_PROPERTY, plugin_desktop_notifications_properties[PLUGIN_DESKTOP_NOTIFICATIONS_FOLDERS_PROPERTY] = g_param_spec_object ("folders", "folders", "folders", PLUGIN_TYPE_FOLDER_CONTEXT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLUGIN_DESKTOP_NOTIFICATIONS_EMAIL_PROPERTY, plugin_desktop_notifications_properties[PLUGIN_DESKTOP_NOTIFICATIONS_EMAIL_PROPERTY] = g_param_spec_object ("email", "email", "email", PLUGIN_TYPE_EMAIL_CONTEXT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLUGIN_DESKTOP_NOTIFICATIONS_CLIENT_APPLICATION_PROPERTY, plugin_desktop_notifications_properties[PLUGIN_DESKTOP_NOTIFICATIONS_CLIENT_APPLICATION_PROPERTY] = g_param_spec_object ("client-application", "client-application", "client-application", APPLICATION_TYPE_CLIENT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PLUGIN_DESKTOP_NOTIFICATIONS_CLIENT_PLUGINS_PROPERTY, plugin_desktop_notifications_properties[PLUGIN_DESKTOP_NOTIFICATIONS_CLIENT_PLUGINS_PROPERTY] = g_param_spec_object ("client-plugins", "client-plugins", "client-plugins", APPLICATION_TYPE_PLUGIN_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
plugin_desktop_notifications_plugin_notification_extension_interface_init (PluginNotificationExtensionIface * iface,
                                                                           gpointer iface_data)
{
	plugin_desktop_notifications_plugin_notification_extension_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_notifications = plugin_desktop_notifications_real_get_notifications;
	iface->set_notifications = plugin_desktop_notifications_real_set_notifications;
}

static void
plugin_desktop_notifications_plugin_folder_extension_interface_init (PluginFolderExtensionIface * iface,
                                                                     gpointer iface_data)
{
	plugin_desktop_notifications_plugin_folder_extension_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_folders = plugin_desktop_notifications_real_get_folders;
	iface->set_folders = plugin_desktop_notifications_real_set_folders;
}

static void
plugin_desktop_notifications_plugin_email_extension_interface_init (PluginEmailExtensionIface * iface,
                                                                    gpointer iface_data)
{
	plugin_desktop_notifications_plugin_email_extension_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_email = plugin_desktop_notifications_real_get_email;
	iface->set_email = plugin_desktop_notifications_real_set_email;
}

static void
plugin_desktop_notifications_plugin_trusted_extension_interface_init (PluginTrustedExtensionIface * iface,
                                                                      gpointer iface_data)
{
	plugin_desktop_notifications_plugin_trusted_extension_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_client_application = plugin_desktop_notifications_real_get_client_application;
	iface->set_client_application = plugin_desktop_notifications_real_set_client_application;
	iface->get_client_plugins = plugin_desktop_notifications_real_get_client_plugins;
	iface->set_client_plugins = plugin_desktop_notifications_real_set_client_plugins;
}

static void
plugin_desktop_notifications_instance_init (PluginDesktopNotifications * self,
                                            gpointer klass)
{
	self->priv = plugin_desktop_notifications_get_instance_private (self);
	self->priv->email_store = NULL;
	self->priv->arrived_notification = NULL;
	self->priv->cancellable = NULL;
}

static void
plugin_desktop_notifications_finalize (GObject * obj)
{
	PluginDesktopNotifications * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PLUGIN_TYPE_DESKTOP_NOTIFICATIONS, PluginDesktopNotifications);
	_g_object_unref0 (self->priv->_notifications);
	_g_object_unref0 (self->priv->_folders);
	_g_object_unref0 (self->priv->_email);
	_g_object_unref0 (self->priv->_client_application);
	_g_object_unref0 (self->priv->_client_plugins);
	_g_object_unref0 (self->priv->email_store);
	_g_object_unref0 (self->priv->arrived_notification);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (plugin_desktop_notifications_parent_class)->finalize (obj);
}

/**
 * Manages standard desktop application notifications.
 */
GType
plugin_desktop_notifications_get_type (void)
{
	return plugin_desktop_notifications_type_id;
}

GType
plugin_desktop_notifications_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (PluginDesktopNotificationsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plugin_desktop_notifications_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PluginDesktopNotifications), 0, (GInstanceInitFunc) plugin_desktop_notifications_instance_init, NULL };
	static const GInterfaceInfo plugin_notification_extension_info = { (GInterfaceInitFunc) plugin_desktop_notifications_plugin_notification_extension_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo plugin_folder_extension_info = { (GInterfaceInitFunc) plugin_desktop_notifications_plugin_folder_extension_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo plugin_email_extension_info = { (GInterfaceInitFunc) plugin_desktop_notifications_plugin_email_extension_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo plugin_trusted_extension_info = { (GInterfaceInitFunc) plugin_desktop_notifications_plugin_trusted_extension_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	plugin_desktop_notifications_type_id = g_type_module_register_type (module, PLUGIN_TYPE_PLUGIN_BASE, "PluginDesktopNotifications", &g_define_type_info, 0);
	g_type_module_add_interface (module, plugin_desktop_notifications_type_id, PLUGIN_TYPE_NOTIFICATION_EXTENSION, &plugin_notification_extension_info);
	g_type_module_add_interface (module, plugin_desktop_notifications_type_id, PLUGIN_TYPE_FOLDER_EXTENSION, &plugin_folder_extension_info);
	g_type_module_add_interface (module, plugin_desktop_notifications_type_id, PLUGIN_TYPE_EMAIL_EXTENSION, &plugin_email_extension_info);
	g_type_module_add_interface (module, plugin_desktop_notifications_type_id, PLUGIN_TYPE_TRUSTED_EXTENSION, &plugin_trusted_extension_info);
	PluginDesktopNotifications_private_offset = sizeof (PluginDesktopNotificationsPrivate);
	return plugin_desktop_notifications_type_id;
}

static void
_vala_plugin_desktop_notifications_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	PluginDesktopNotifications * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLUGIN_TYPE_DESKTOP_NOTIFICATIONS, PluginDesktopNotifications);
	switch (property_id) {
		case PLUGIN_DESKTOP_NOTIFICATIONS_NOTIFICATIONS_PROPERTY:
		g_value_set_object (value, plugin_notification_extension_get_notifications (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_NOTIFICATION_EXTENSION, PluginNotificationExtension)));
		break;
		case PLUGIN_DESKTOP_NOTIFICATIONS_FOLDERS_PROPERTY:
		g_value_set_object (value, plugin_folder_extension_get_folders (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_FOLDER_EXTENSION, PluginFolderExtension)));
		break;
		case PLUGIN_DESKTOP_NOTIFICATIONS_EMAIL_PROPERTY:
		g_value_set_object (value, plugin_email_extension_get_email (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_EMAIL_EXTENSION, PluginEmailExtension)));
		break;
		case PLUGIN_DESKTOP_NOTIFICATIONS_CLIENT_APPLICATION_PROPERTY:
		g_value_set_object (value, plugin_trusted_extension_get_client_application (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_TRUSTED_EXTENSION, PluginTrustedExtension)));
		break;
		case PLUGIN_DESKTOP_NOTIFICATIONS_CLIENT_PLUGINS_PROPERTY:
		g_value_set_object (value, plugin_trusted_extension_get_client_plugins (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_TRUSTED_EXTENSION, PluginTrustedExtension)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_plugin_desktop_notifications_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	PluginDesktopNotifications * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PLUGIN_TYPE_DESKTOP_NOTIFICATIONS, PluginDesktopNotifications);
	switch (property_id) {
		case PLUGIN_DESKTOP_NOTIFICATIONS_NOTIFICATIONS_PROPERTY:
		plugin_notification_extension_set_notifications (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_NOTIFICATION_EXTENSION, PluginNotificationExtension), g_value_get_object (value));
		break;
		case PLUGIN_DESKTOP_NOTIFICATIONS_FOLDERS_PROPERTY:
		plugin_folder_extension_set_folders (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_FOLDER_EXTENSION, PluginFolderExtension), g_value_get_object (value));
		break;
		case PLUGIN_DESKTOP_NOTIFICATIONS_EMAIL_PROPERTY:
		plugin_email_extension_set_email (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_EMAIL_EXTENSION, PluginEmailExtension), g_value_get_object (value));
		break;
		case PLUGIN_DESKTOP_NOTIFICATIONS_CLIENT_APPLICATION_PROPERTY:
		plugin_trusted_extension_set_client_application (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_TRUSTED_EXTENSION, PluginTrustedExtension), g_value_get_object (value));
		break;
		case PLUGIN_DESKTOP_NOTIFICATIONS_CLIENT_PLUGINS_PROPERTY:
		plugin_trusted_extension_set_client_plugins (G_TYPE_CHECK_INSTANCE_CAST (self, PLUGIN_TYPE_TRUSTED_EXTENSION, PluginTrustedExtension), g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

