/* geary-contact.c generated by valac 0.56.3, the Vala compiler
 * generated from geary-contact.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>

enum  {
	GEARY_CONTACT_0_PROPERTY,
	GEARY_CONTACT_NORMALIZED_EMAIL_PROPERTY,
	GEARY_CONTACT_EMAIL_PROPERTY,
	GEARY_CONTACT_REAL_NAME_PROPERTY,
	GEARY_CONTACT_HIGHEST_IMPORTANCE_PROPERTY,
	GEARY_CONTACT_FLAGS_PROPERTY,
	GEARY_CONTACT_NUM_PROPERTIES
};
static GParamSpec* geary_contact_properties[GEARY_CONTACT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	GEARY_CONTACT_FLAGS_0_PROPERTY,
	GEARY_CONTACT_FLAGS_NUM_PROPERTIES
};
static GParamSpec* geary_contact_flags_properties[GEARY_CONTACT_FLAGS_NUM_PROPERTIES];

struct _GearyContactPrivate {
	gchar* _normalized_email;
	gchar* _email;
	gchar* _real_name;
	gint _highest_importance;
	GearyContactFlags* _flags;
};

static gint GearyContact_private_offset;
static gpointer geary_contact_parent_class = NULL;
static gpointer geary_contact_flags_parent_class = NULL;
static GearyNamedFlag* geary_contact_flags__always_load_remote_images;
static GearyNamedFlag* geary_contact_flags__always_load_remote_images = NULL;

static void geary_contact_set_normalized_email (GearyContact* self,
                                         const gchar* value);
static void geary_contact_set_email (GearyContact* self,
                              const gchar* value);
static void geary_contact_flags_finalize (GObject * obj);
static GType geary_contact_flags_get_type_once (void);
static void _vala_geary_contact_flags_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void geary_contact_finalize (GObject * obj);
static GType geary_contact_get_type_once (void);
static void _vala_geary_contact_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_geary_contact_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
geary_contact_get_instance_private (GearyContact* self)
{
	return G_STRUCT_MEMBER_P (self, GearyContact_private_offset);
}

/**
     * Standard values for contact importance..
     */
 G_GNUC_NO_INLINE static GType
geary_contact_importance_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_CONTACT_IMPORTANCE_DESKTOP, "GEARY_CONTACT_IMPORTANCE_DESKTOP", "desktop"}, {GEARY_CONTACT_IMPORTANCE_SENT_TO, "GEARY_CONTACT_IMPORTANCE_SENT_TO", "sent-to"}, {GEARY_CONTACT_IMPORTANCE_RECEIVED_FROM, "GEARY_CONTACT_IMPORTANCE_RECEIVED_FROM", "received-from"}, {GEARY_CONTACT_IMPORTANCE_SEEN, "GEARY_CONTACT_IMPORTANCE_SEEN", "seen"}, {0, NULL, NULL}};
	GType geary_contact_importance_type_id;
	geary_contact_importance_type_id = g_enum_register_static ("GearyContactImportance", values);
	return geary_contact_importance_type_id;
}

GType
geary_contact_importance_get_type (void)
{
	static gsize geary_contact_importance_type_id__once = 0;
	if (g_once_init_enter (&geary_contact_importance_type_id__once)) {
		GType geary_contact_importance_type_id;
		geary_contact_importance_type_id = geary_contact_importance_get_type_once ();
		g_once_init_leave (&geary_contact_importance_type_id__once, geary_contact_importance_type_id);
	}
	return geary_contact_importance_type_id__once;
}

/** Normalises an email address as for {@link normalized_email}. */
gchar*
geary_contact_normalise_email (const gchar* address)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (address != NULL, NULL);
	_tmp0_ = g_utf8_normalize (address, (gssize) -1, G_NORMALIZE_DEFAULT);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_utf8_casefold (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

const gchar*
geary_contact_get_normalized_email (GearyContact* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IS_CONTACT (self), NULL);
	_tmp0_ = self->priv->_normalized_email;
	result = _tmp0_;
	return result;
}

static void
geary_contact_set_normalized_email (GearyContact* self,
                                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IS_CONTACT (self));
	old_value = geary_contact_get_normalized_email (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_normalized_email);
		self->priv->_normalized_email = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_contact_properties[GEARY_CONTACT_NORMALIZED_EMAIL_PROPERTY]);
	}
}

const gchar*
geary_contact_get_email (GearyContact* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IS_CONTACT (self), NULL);
	_tmp0_ = self->priv->_email;
	result = _tmp0_;
	return result;
}

static void
geary_contact_set_email (GearyContact* self,
                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IS_CONTACT (self));
	old_value = geary_contact_get_email (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_email);
		self->priv->_email = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_contact_properties[GEARY_CONTACT_EMAIL_PROPERTY]);
	}
}

const gchar*
geary_contact_get_real_name (GearyContact* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IS_CONTACT (self), NULL);
	_tmp0_ = self->priv->_real_name;
	result = _tmp0_;
	return result;
}

void
geary_contact_set_real_name (GearyContact* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IS_CONTACT (self));
	old_value = geary_contact_get_real_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_real_name);
		self->priv->_real_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_contact_properties[GEARY_CONTACT_REAL_NAME_PROPERTY]);
	}
}

gint
geary_contact_get_highest_importance (GearyContact* self)
{
	gint result;
	g_return_val_if_fail (GEARY_IS_CONTACT (self), 0);
	result = self->priv->_highest_importance;
	return result;
}

void
geary_contact_set_highest_importance (GearyContact* self,
                                      gint value)
{
	gint old_value;
	g_return_if_fail (GEARY_IS_CONTACT (self));
	old_value = geary_contact_get_highest_importance (self);
	if (old_value != value) {
		self->priv->_highest_importance = value;
		g_object_notify_by_pspec ((GObject *) self, geary_contact_properties[GEARY_CONTACT_HIGHEST_IMPORTANCE_PROPERTY]);
	}
}

GearyContactFlags*
geary_contact_get_flags (GearyContact* self)
{
	GearyContactFlags* result;
	GearyContactFlags* _tmp0_;
	g_return_val_if_fail (GEARY_IS_CONTACT (self), NULL);
	_tmp0_ = self->priv->_flags;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
geary_contact_set_flags (GearyContact* self,
                         GearyContactFlags* value)
{
	GearyContactFlags* old_value;
	g_return_if_fail (GEARY_IS_CONTACT (self));
	old_value = geary_contact_get_flags (self);
	if (old_value != value) {
		GearyContactFlags* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_flags);
		self->priv->_flags = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_contact_properties[GEARY_CONTACT_FLAGS_PROPERTY]);
	}
}

GearyContact*
geary_contact_construct (GType object_type,
                         const gchar* email,
                         const gchar* real_name,
                         gint highest_importance,
                         const gchar* normalized_email)
{
	GearyContact * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (email != NULL, NULL);
	self = (GearyContact*) geary_base_object_construct (object_type);
	_tmp1_ = g_strdup (normalized_email);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = geary_contact_normalise_email (email);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	geary_contact_set_normalized_email (self, _tmp0_);
	geary_contact_set_email (self, email);
	if (g_strcmp0 (real_name, email) != 0) {
		_tmp4_ = g_strcmp0 (real_name, normalized_email) != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = real_name;
	} else {
		_tmp3_ = NULL;
	}
	geary_contact_set_real_name (self, _tmp3_);
	geary_contact_set_highest_importance (self, highest_importance);
	_g_free0 (_tmp0_);
	return self;
}

GearyContact*
geary_contact_new (const gchar* email,
                   const gchar* real_name,
                   gint highest_importance,
                   const gchar* normalized_email)
{
	return geary_contact_construct (GEARY_TYPE_CONTACT, email, real_name, highest_importance, normalized_email);
}

GearyContact*
geary_contact_construct_from_rfc822_address (GType object_type,
                                             GearyRFC822MailboxAddress* address,
                                             gint highest_importance)
{
	GearyContact * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_val_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (address), NULL);
	if (geary_rf_c822_mailbox_address_has_distinct_name (address)) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = geary_rf_c822_mailbox_address_get_name (address);
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp3_ = geary_rf_c822_mailbox_address_get_address (address);
	_tmp4_ = _tmp3_;
	self = (GearyContact*) geary_contact_construct (object_type, _tmp4_, _tmp0_, highest_importance, NULL);
	return self;
}

GearyContact*
geary_contact_new_from_rfc822_address (GearyRFC822MailboxAddress* address,
                                       gint highest_importance)
{
	return geary_contact_construct_from_rfc822_address (GEARY_TYPE_CONTACT, address, highest_importance);
}

GearyRFC822MailboxAddress*
geary_contact_get_rfc822_address (GearyContact* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GearyRFC822MailboxAddress* _tmp2_;
	GearyRFC822MailboxAddress* result;
	g_return_val_if_fail (GEARY_IS_CONTACT (self), NULL);
	_tmp0_ = self->priv->_real_name;
	_tmp1_ = self->priv->_email;
	_tmp2_ = geary_rf_c822_mailbox_address_new (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}

GearyNamedFlag*
geary_contact_flags_get_ALWAYS_LOAD_REMOTE_IMAGES (void)
{
	GearyNamedFlag* result;
	GearyNamedFlag* _tmp0_;
	GearyNamedFlag* _tmp2_;
	_tmp0_ = geary_contact_flags__always_load_remote_images;
	if (_tmp0_ == NULL) {
		GearyNamedFlag* _tmp1_;
		_tmp1_ = geary_named_flag_new ("ALWAYSLOADREMOTEIMAGES");
		_g_object_unref0 (geary_contact_flags__always_load_remote_images);
		geary_contact_flags__always_load_remote_images = _tmp1_;
	}
	_tmp2_ = geary_contact_flags__always_load_remote_images;
	result = _tmp2_;
	return result;
}

gboolean
geary_contact_flags_always_load_remote_images (GearyContactFlags* self)
{
	GearyNamedFlag* _tmp0_;
	GearyNamedFlag* _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_CONTACT_IS_FLAGS (self), FALSE);
	_tmp0_ = geary_contact_flags_get_ALWAYS_LOAD_REMOTE_IMAGES ();
	_tmp1_ = _tmp0_;
	result = geary_named_flags_contains (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_NAMED_FLAGS, GearyNamedFlags), _tmp1_);
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

gchar*
geary_contact_flags_serialize (GearyContactFlags* self)
{
	gchar* ret = NULL;
	gchar* _tmp0_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* result;
	g_return_val_if_fail (GEARY_CONTACT_IS_FLAGS (self), NULL);
	_tmp0_ = g_strdup ("");
	ret = _tmp0_;
	{
		GeeIterator* _flag_it = NULL;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_;
		_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_NAMED_FLAGS, GearyNamedFlags)->list;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
		_flag_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_;
			GearyNamedFlag* flag = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			const gchar* _tmp6_;
			GearyNamedFlag* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp3_ = _flag_it;
			if (!gee_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _flag_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			flag = (GearyNamedFlag*) _tmp5_;
			_tmp6_ = ret;
			_tmp7_ = flag;
			_tmp8_ = geary_named_flag_serialise (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strconcat (_tmp9_, " ", NULL);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strconcat (_tmp6_, _tmp11_, NULL);
			_g_free0 (ret);
			ret = _tmp12_;
			_g_free0 (_tmp11_);
			_g_free0 (_tmp9_);
			_g_object_unref0 (flag);
		}
		_g_object_unref0 (_flag_it);
	}
	_tmp13_ = ret;
	_tmp14_ = string_strip (_tmp13_);
	result = _tmp14_;
	_g_free0 (ret);
	return result;
}

void
geary_contact_flags_deserialize (GearyContactFlags* self,
                                 const gchar* flags)
{
	g_return_if_fail (GEARY_CONTACT_IS_FLAGS (self));
	if (!geary_string_is_empty (flags)) {
		gchar** _tmp0_;
		gchar** _tmp1_;
		_tmp1_ = _tmp0_ = g_strsplit (flags, " ", 0);
		{
			gchar** flag_collection = NULL;
			gint flag_collection_length1 = 0;
			gint _flag_collection_size_ = 0;
			gint flag_it = 0;
			flag_collection = _tmp1_;
			flag_collection_length1 = _vala_array_length (_tmp0_);
			for (flag_it = 0; flag_it < flag_collection_length1; flag_it = flag_it + 1) {
				gchar* _tmp2_;
				gchar* flag = NULL;
				_tmp2_ = g_strdup (flag_collection[flag_it]);
				flag = _tmp2_;
				{
					const gchar* _tmp3_;
					GearyNamedFlag* _tmp4_;
					GearyNamedFlag* _tmp5_;
					_tmp3_ = flag;
					_tmp4_ = geary_named_flag_new (_tmp3_);
					_tmp5_ = _tmp4_;
					geary_named_flags_add (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_NAMED_FLAGS, GearyNamedFlags), _tmp5_);
					_g_object_unref0 (_tmp5_);
					_g_free0 (flag);
				}
			}
			flag_collection = (_vala_array_free (flag_collection, flag_collection_length1, (GDestroyNotify) g_free), NULL);
		}
	}
}

GearyContactFlags*
geary_contact_flags_construct (GType object_type)
{
	GearyContactFlags * self = NULL;
	self = (GearyContactFlags*) geary_named_flags_construct (object_type);
	return self;
}

GearyContactFlags*
geary_contact_flags_new (void)
{
	return geary_contact_flags_construct (GEARY_CONTACT_TYPE_FLAGS);
}

static void
geary_contact_flags_class_init (GearyContactFlagsClass * klass,
                                gpointer klass_data)
{
	geary_contact_flags_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_contact_flags_get_property;
	G_OBJECT_CLASS (klass)->finalize = geary_contact_flags_finalize;
}

static void
geary_contact_flags_instance_init (GearyContactFlags * self,
                                   gpointer klass)
{
}

static void
geary_contact_flags_finalize (GObject * obj)
{
	GearyContactFlags * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_CONTACT_TYPE_FLAGS, GearyContactFlags);
	G_OBJECT_CLASS (geary_contact_flags_parent_class)->finalize (obj);
}

/**
     * Named flags for contact objects.
     */
 G_GNUC_NO_INLINE static GType
geary_contact_flags_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyContactFlagsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_contact_flags_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyContactFlags), 0, (GInstanceInitFunc) geary_contact_flags_instance_init, NULL };
	GType geary_contact_flags_type_id;
	geary_contact_flags_type_id = g_type_register_static (GEARY_TYPE_NAMED_FLAGS, "GearyContactFlags", &g_define_type_info, 0);
	return geary_contact_flags_type_id;
}

GType
geary_contact_flags_get_type (void)
{
	static gsize geary_contact_flags_type_id__once = 0;
	if (g_once_init_enter (&geary_contact_flags_type_id__once)) {
		GType geary_contact_flags_type_id;
		geary_contact_flags_type_id = geary_contact_flags_get_type_once ();
		g_once_init_leave (&geary_contact_flags_type_id__once, geary_contact_flags_type_id);
	}
	return geary_contact_flags_type_id__once;
}

static void
_vala_geary_contact_flags_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	GearyContactFlags * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_CONTACT_TYPE_FLAGS, GearyContactFlags);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
geary_contact_class_init (GearyContactClass * klass,
                          gpointer klass_data)
{
	geary_contact_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyContact_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_contact_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_contact_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_contact_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_CONTACT_NORMALIZED_EMAIL_PROPERTY, geary_contact_properties[GEARY_CONTACT_NORMALIZED_EMAIL_PROPERTY] = g_param_spec_string ("normalized-email", "normalized-email", "normalized-email", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_CONTACT_EMAIL_PROPERTY, geary_contact_properties[GEARY_CONTACT_EMAIL_PROPERTY] = g_param_spec_string ("email", "email", "email", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_CONTACT_REAL_NAME_PROPERTY, geary_contact_properties[GEARY_CONTACT_REAL_NAME_PROPERTY] = g_param_spec_string ("real-name", "real-name", "real-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_CONTACT_HIGHEST_IMPORTANCE_PROPERTY, geary_contact_properties[GEARY_CONTACT_HIGHEST_IMPORTANCE_PROPERTY] = g_param_spec_int ("highest-importance", "highest-importance", "highest-importance", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_CONTACT_FLAGS_PROPERTY, geary_contact_properties[GEARY_CONTACT_FLAGS_PROPERTY] = g_param_spec_object ("flags", "flags", "flags", GEARY_CONTACT_TYPE_FLAGS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
geary_contact_instance_init (GearyContact * self,
                             gpointer klass)
{
	GearyContactFlags* _tmp0_;
	self->priv = geary_contact_get_instance_private (self);
	_tmp0_ = geary_contact_flags_new ();
	self->priv->_flags = _tmp0_;
}

static void
geary_contact_finalize (GObject * obj)
{
	GearyContact * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_CONTACT, GearyContact);
	_g_free0 (self->priv->_normalized_email);
	_g_free0 (self->priv->_email);
	_g_free0 (self->priv->_real_name);
	_g_object_unref0 (self->priv->_flags);
	G_OBJECT_CLASS (geary_contact_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_contact_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyContactClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_contact_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyContact), 0, (GInstanceInitFunc) geary_contact_instance_init, NULL };
	GType geary_contact_type_id;
	geary_contact_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyContact", &g_define_type_info, 0);
	GearyContact_private_offset = g_type_add_instance_private (geary_contact_type_id, sizeof (GearyContactPrivate));
	return geary_contact_type_id;
}

GType
geary_contact_get_type (void)
{
	static gsize geary_contact_type_id__once = 0;
	if (g_once_init_enter (&geary_contact_type_id__once)) {
		GType geary_contact_type_id;
		geary_contact_type_id = geary_contact_get_type_once ();
		g_once_init_leave (&geary_contact_type_id__once, geary_contact_type_id);
	}
	return geary_contact_type_id__once;
}

static void
_vala_geary_contact_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	GearyContact * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_CONTACT, GearyContact);
	switch (property_id) {
		case GEARY_CONTACT_NORMALIZED_EMAIL_PROPERTY:
		g_value_set_string (value, geary_contact_get_normalized_email (self));
		break;
		case GEARY_CONTACT_EMAIL_PROPERTY:
		g_value_set_string (value, geary_contact_get_email (self));
		break;
		case GEARY_CONTACT_REAL_NAME_PROPERTY:
		g_value_set_string (value, geary_contact_get_real_name (self));
		break;
		case GEARY_CONTACT_HIGHEST_IMPORTANCE_PROPERTY:
		g_value_set_int (value, geary_contact_get_highest_importance (self));
		break;
		case GEARY_CONTACT_FLAGS_PROPERTY:
		g_value_set_object (value, geary_contact_get_flags (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_contact_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	GearyContact * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_CONTACT, GearyContact);
	switch (property_id) {
		case GEARY_CONTACT_NORMALIZED_EMAIL_PROPERTY:
		geary_contact_set_normalized_email (self, g_value_get_string (value));
		break;
		case GEARY_CONTACT_EMAIL_PROPERTY:
		geary_contact_set_email (self, g_value_get_string (value));
		break;
		case GEARY_CONTACT_REAL_NAME_PROPERTY:
		geary_contact_set_real_name (self, g_value_get_string (value));
		break;
		case GEARY_CONTACT_HIGHEST_IMPORTANCE_PROPERTY:
		geary_contact_set_highest_importance (self, g_value_get_int (value));
		break;
		case GEARY_CONTACT_FLAGS_PROPERTY:
		geary_contact_set_flags (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

