/* geary-progress-monitor.c generated by valac 0.56.3, the Vala compiler
 * generated from geary-progress-monitor.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <glib-object.h>

enum  {
	GEARY_PROGRESS_MONITOR_0_PROPERTY,
	GEARY_PROGRESS_MONITOR_PROGRESS_PROPERTY,
	GEARY_PROGRESS_MONITOR_IS_IN_PROGRESS_PROPERTY,
	GEARY_PROGRESS_MONITOR_PROGRESS_TYPE_PROPERTY,
	GEARY_PROGRESS_MONITOR_NUM_PROPERTIES
};
static GParamSpec* geary_progress_monitor_properties[GEARY_PROGRESS_MONITOR_NUM_PROPERTIES];
enum  {
	GEARY_PROGRESS_MONITOR_START_SIGNAL,
	GEARY_PROGRESS_MONITOR_UPDATE_SIGNAL,
	GEARY_PROGRESS_MONITOR_FINISH_SIGNAL,
	GEARY_PROGRESS_MONITOR_NUM_SIGNALS
};
static guint geary_progress_monitor_signals[GEARY_PROGRESS_MONITOR_NUM_SIGNALS] = {0};
enum  {
	GEARY_REENTRANT_PROGRESS_MONITOR_0_PROPERTY,
	GEARY_REENTRANT_PROGRESS_MONITOR_NUM_PROPERTIES
};
static GParamSpec* geary_reentrant_progress_monitor_properties[GEARY_REENTRANT_PROGRESS_MONITOR_NUM_PROPERTIES];
enum  {
	GEARY_SIMPLE_PROGRESS_MONITOR_0_PROPERTY,
	GEARY_SIMPLE_PROGRESS_MONITOR_NUM_PROPERTIES
};
static GParamSpec* geary_simple_progress_monitor_properties[GEARY_SIMPLE_PROGRESS_MONITOR_NUM_PROPERTIES];
enum  {
	GEARY_INTERVAL_PROGRESS_MONITOR_0_PROPERTY,
	GEARY_INTERVAL_PROGRESS_MONITOR_NUM_PROPERTIES
};
static GParamSpec* geary_interval_progress_monitor_properties[GEARY_INTERVAL_PROGRESS_MONITOR_NUM_PROPERTIES];
enum  {
	GEARY_AGGREGATE_PROGRESS_MONITOR_0_PROPERTY,
	GEARY_AGGREGATE_PROGRESS_MONITOR_NUM_PROPERTIES
};
static GParamSpec* geary_aggregate_progress_monitor_properties[GEARY_AGGREGATE_PROGRESS_MONITOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GearyProgressMonitorPrivate {
	gdouble _progress;
	gboolean _is_in_progress;
	GearyProgressType _progress_type;
};

struct _GearyReentrantProgressMonitorPrivate {
	gint start_count;
};

struct _GearyIntervalProgressMonitorPrivate {
	gint min_interval;
	gint max_interval;
	gint current;
};

struct _GearyAggregateProgressMonitorPrivate {
	GeeHashSet* monitors;
};

static gint GearyProgressMonitor_private_offset;
static gpointer geary_progress_monitor_parent_class = NULL;
static gint GearyReentrantProgressMonitor_private_offset;
static gpointer geary_reentrant_progress_monitor_parent_class = NULL;
static gpointer geary_simple_progress_monitor_parent_class = NULL;
static gint GearyIntervalProgressMonitor_private_offset;
static gpointer geary_interval_progress_monitor_parent_class = NULL;
static gint GearyAggregateProgressMonitor_private_offset;
static gpointer geary_aggregate_progress_monitor_parent_class = NULL;

static void g_cclosure_user_marshal_VOID__DOUBLE_DOUBLE_OBJECT (GClosure * closure,
                                                         GValue * return_value,
                                                         guint n_param_values,
                                                         const GValue * param_values,
                                                         gpointer invocation_hint,
                                                         gpointer marshal_data);
static void geary_progress_monitor_real_notify_start (GearyProgressMonitor* self);
static void geary_progress_monitor_real_notify_finish (GearyProgressMonitor* self);
static void geary_progress_monitor_finalize (GObject * obj);
static GType geary_progress_monitor_get_type_once (void);
static void _vala_geary_progress_monitor_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_geary_progress_monitor_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void geary_reentrant_progress_monitor_real_notify_start (GearyProgressMonitor* base);
static void geary_reentrant_progress_monitor_real_notify_finish (GearyProgressMonitor* base);
static void geary_reentrant_progress_monitor_finalize (GObject * obj);
static GType geary_reentrant_progress_monitor_get_type_once (void);
static GType geary_simple_progress_monitor_get_type_once (void);
static void geary_interval_progress_monitor_real_notify_start (GearyProgressMonitor* base);
static void geary_interval_progress_monitor_finalize (GObject * obj);
static GType geary_interval_progress_monitor_get_type_once (void);
static void geary_aggregate_progress_monitor_on_start (GearyAggregateProgressMonitor* self);
static void _geary_aggregate_progress_monitor_on_start_geary_progress_monitor_start (GearyProgressMonitor* _sender,
                                                                              gpointer self);
static void geary_aggregate_progress_monitor_on_update (GearyAggregateProgressMonitor* self,
                                                 gdouble total_progress,
                                                 gdouble change,
                                                 GearyProgressMonitor* monitor);
static void _geary_aggregate_progress_monitor_on_update_geary_progress_monitor_update (GearyProgressMonitor* _sender,
                                                                                gdouble total_progress,
                                                                                gdouble change,
                                                                                GearyProgressMonitor* monitor,
                                                                                gpointer self);
static void geary_aggregate_progress_monitor_on_finish (GearyAggregateProgressMonitor* self);
static void _geary_aggregate_progress_monitor_on_finish_geary_progress_monitor_finish (GearyProgressMonitor* _sender,
                                                                                gpointer self);
static void geary_aggregate_progress_monitor_finalize (GObject * obj);
static GType geary_aggregate_progress_monitor_get_type_once (void);

/**
 * Type of progress monitor.
 */
 G_GNUC_NO_INLINE static GType
geary_progress_type_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_PROGRESS_TYPE_AGGREGATED, "GEARY_PROGRESS_TYPE_AGGREGATED", "aggregated"}, {GEARY_PROGRESS_TYPE_ACTIVITY, "GEARY_PROGRESS_TYPE_ACTIVITY", "activity"}, {GEARY_PROGRESS_TYPE_DB_UPGRADE, "GEARY_PROGRESS_TYPE_DB_UPGRADE", "db-upgrade"}, {GEARY_PROGRESS_TYPE_SEARCH_INDEX, "GEARY_PROGRESS_TYPE_SEARCH_INDEX", "search-index"}, {GEARY_PROGRESS_TYPE_DB_VACUUM, "GEARY_PROGRESS_TYPE_DB_VACUUM", "db-vacuum"}, {0, NULL, NULL}};
	GType geary_progress_type_type_id;
	geary_progress_type_type_id = g_enum_register_static ("GearyProgressType", values);
	return geary_progress_type_type_id;
}

GType
geary_progress_type_get_type (void)
{
	static gsize geary_progress_type_type_id__once = 0;
	if (g_once_init_enter (&geary_progress_type_type_id__once)) {
		GType geary_progress_type_type_id;
		geary_progress_type_type_id = geary_progress_type_get_type_once ();
		g_once_init_leave (&geary_progress_type_type_id__once, geary_progress_type_type_id);
	}
	return geary_progress_type_type_id__once;
}

static inline gpointer
geary_progress_monitor_get_instance_private (GearyProgressMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, GearyProgressMonitor_private_offset);
}

gdouble
geary_progress_monitor_get_progress (GearyProgressMonitor* self)
{
	gdouble result;
	g_return_val_if_fail (GEARY_IS_PROGRESS_MONITOR (self), 0.0);
	result = self->priv->_progress;
	return result;
}

void
geary_progress_monitor_set_progress (GearyProgressMonitor* self,
                                     gdouble value)
{
	gdouble old_value;
	g_return_if_fail (GEARY_IS_PROGRESS_MONITOR (self));
	old_value = geary_progress_monitor_get_progress (self);
	if (old_value != value) {
		self->priv->_progress = value;
		g_object_notify_by_pspec ((GObject *) self, geary_progress_monitor_properties[GEARY_PROGRESS_MONITOR_PROGRESS_PROPERTY]);
	}
}

gboolean
geary_progress_monitor_get_is_in_progress (GearyProgressMonitor* self)
{
	gboolean result;
	g_return_val_if_fail (GEARY_IS_PROGRESS_MONITOR (self), FALSE);
	result = self->priv->_is_in_progress;
	return result;
}

void
geary_progress_monitor_set_is_in_progress (GearyProgressMonitor* self,
                                           gboolean value)
{
	gboolean old_value;
	g_return_if_fail (GEARY_IS_PROGRESS_MONITOR (self));
	old_value = geary_progress_monitor_get_is_in_progress (self);
	if (old_value != value) {
		self->priv->_is_in_progress = value;
		g_object_notify_by_pspec ((GObject *) self, geary_progress_monitor_properties[GEARY_PROGRESS_MONITOR_IS_IN_PROGRESS_PROPERTY]);
	}
}

GearyProgressType
geary_progress_monitor_get_progress_type (GearyProgressMonitor* self)
{
	GearyProgressType result;
	g_return_val_if_fail (GEARY_IS_PROGRESS_MONITOR (self), 0);
	result = self->priv->_progress_type;
	return result;
}

void
geary_progress_monitor_set_progress_type (GearyProgressMonitor* self,
                                          GearyProgressType value)
{
	GearyProgressType old_value;
	g_return_if_fail (GEARY_IS_PROGRESS_MONITOR (self));
	old_value = geary_progress_monitor_get_progress_type (self);
	if (old_value != value) {
		self->priv->_progress_type = value;
		g_object_notify_by_pspec ((GObject *) self, geary_progress_monitor_properties[GEARY_PROGRESS_MONITOR_PROGRESS_TYPE_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__DOUBLE_DOUBLE_OBJECT (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__DOUBLE_DOUBLE_OBJECT) (gpointer data1, gdouble arg_1, gdouble arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__DOUBLE_DOUBLE_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__DOUBLE_DOUBLE_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_double (param_values + 1), g_value_get_double (param_values + 2), g_value_get_object (param_values + 3), data2);
}

/**
     * Users must call this before calling update.
     *
     * Must not be called again until {@link ProgressMonitor.notify_finish} has been called.
     */
static void
geary_progress_monitor_real_notify_start (GearyProgressMonitor* self)
{
	gboolean _tmp0_;
	_tmp0_ = self->priv->_is_in_progress;
	_vala_assert (!_tmp0_, "!is_in_progress");
	geary_progress_monitor_set_progress (self, GEARY_PROGRESS_MONITOR_MIN);
	geary_progress_monitor_set_is_in_progress (self, TRUE);
	g_signal_emit (self, geary_progress_monitor_signals[GEARY_PROGRESS_MONITOR_START_SIGNAL], 0);
}

void
geary_progress_monitor_notify_start (GearyProgressMonitor* self)
{
	GearyProgressMonitorClass* _klass_;
	g_return_if_fail (GEARY_IS_PROGRESS_MONITOR (self));
	_klass_ = GEARY_PROGRESS_MONITOR_GET_CLASS (self);
	if (_klass_->notify_start) {
		_klass_->notify_start (self);
	}
}

/**
     * Users must call this when progress has completed.
     *
     * Must only be called after {@link ProgressMonitor.notify_start}.
     */
static void
geary_progress_monitor_real_notify_finish (GearyProgressMonitor* self)
{
	gboolean _tmp0_;
	_tmp0_ = self->priv->_is_in_progress;
	_vala_assert (_tmp0_, "is_in_progress");
	geary_progress_monitor_set_is_in_progress (self, FALSE);
	g_signal_emit (self, geary_progress_monitor_signals[GEARY_PROGRESS_MONITOR_FINISH_SIGNAL], 0);
}

void
geary_progress_monitor_notify_finish (GearyProgressMonitor* self)
{
	GearyProgressMonitorClass* _klass_;
	g_return_if_fail (GEARY_IS_PROGRESS_MONITOR (self));
	_klass_ = GEARY_PROGRESS_MONITOR_GET_CLASS (self);
	if (_klass_->notify_finish) {
		_klass_->notify_finish (self);
	}
}

GearyProgressMonitor*
geary_progress_monitor_construct (GType object_type)
{
	GearyProgressMonitor * self = NULL;
	self = (GearyProgressMonitor*) geary_base_object_construct (object_type);
	return self;
}

static void
geary_progress_monitor_class_init (GearyProgressMonitorClass * klass,
                                   gpointer klass_data)
{
	geary_progress_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyProgressMonitor_private_offset);
	((GearyProgressMonitorClass *) klass)->notify_start = (void (*) (GearyProgressMonitor*)) geary_progress_monitor_real_notify_start;
	((GearyProgressMonitorClass *) klass)->notify_finish = (void (*) (GearyProgressMonitor*)) geary_progress_monitor_real_notify_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_progress_monitor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_progress_monitor_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_progress_monitor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_PROGRESS_MONITOR_PROGRESS_PROPERTY, geary_progress_monitor_properties[GEARY_PROGRESS_MONITOR_PROGRESS_PROPERTY] = g_param_spec_double ("progress", "progress", "progress", -G_MAXDOUBLE, G_MAXDOUBLE, GEARY_PROGRESS_MONITOR_MIN, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_PROGRESS_MONITOR_IS_IN_PROGRESS_PROPERTY, geary_progress_monitor_properties[GEARY_PROGRESS_MONITOR_IS_IN_PROGRESS_PROPERTY] = g_param_spec_boolean ("is-in-progress", "is-in-progress", "is-in-progress", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_PROGRESS_MONITOR_PROGRESS_TYPE_PROPERTY, geary_progress_monitor_properties[GEARY_PROGRESS_MONITOR_PROGRESS_TYPE_PROPERTY] = g_param_spec_enum ("progress-type", "progress-type", "progress-type", GEARY_TYPE_PROGRESS_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The start signal is fired just before progress begins.  It will not fire again until after
	     * {@link finish} has fired.
	     */
	geary_progress_monitor_signals[GEARY_PROGRESS_MONITOR_START_SIGNAL] = g_signal_new ("start", GEARY_TYPE_PROGRESS_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	     * Notifies the user of existing progress.  Note that monitor refers to the monitor that
	     * invoked this update, which may not be the same as this object.
	     */
	geary_progress_monitor_signals[GEARY_PROGRESS_MONITOR_UPDATE_SIGNAL] = g_signal_new ("update", GEARY_TYPE_PROGRESS_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__DOUBLE_DOUBLE_OBJECT, G_TYPE_NONE, 3, G_TYPE_DOUBLE, G_TYPE_DOUBLE, GEARY_TYPE_PROGRESS_MONITOR);
	/**
	     * Finish is fired when progress has completed.
	     */
	geary_progress_monitor_signals[GEARY_PROGRESS_MONITOR_FINISH_SIGNAL] = g_signal_new ("finish", GEARY_TYPE_PROGRESS_MONITOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
geary_progress_monitor_instance_init (GearyProgressMonitor * self,
                                      gpointer klass)
{
	self->priv = geary_progress_monitor_get_instance_private (self);
	self->priv->_progress = GEARY_PROGRESS_MONITOR_MIN;
	self->priv->_is_in_progress = FALSE;
}

static void
geary_progress_monitor_finalize (GObject * obj)
{
	GearyProgressMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor);
	G_OBJECT_CLASS (geary_progress_monitor_parent_class)->finalize (obj);
}

/**
 * Base class for progress monitoring.
 */
 G_GNUC_NO_INLINE static GType
geary_progress_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyProgressMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_progress_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyProgressMonitor), 0, (GInstanceInitFunc) geary_progress_monitor_instance_init, NULL };
	GType geary_progress_monitor_type_id;
	geary_progress_monitor_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyProgressMonitor", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	GearyProgressMonitor_private_offset = g_type_add_instance_private (geary_progress_monitor_type_id, sizeof (GearyProgressMonitorPrivate));
	return geary_progress_monitor_type_id;
}

GType
geary_progress_monitor_get_type (void)
{
	static gsize geary_progress_monitor_type_id__once = 0;
	if (g_once_init_enter (&geary_progress_monitor_type_id__once)) {
		GType geary_progress_monitor_type_id;
		geary_progress_monitor_type_id = geary_progress_monitor_get_type_once ();
		g_once_init_leave (&geary_progress_monitor_type_id__once, geary_progress_monitor_type_id);
	}
	return geary_progress_monitor_type_id__once;
}

static void
_vala_geary_progress_monitor_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GearyProgressMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor);
	switch (property_id) {
		case GEARY_PROGRESS_MONITOR_PROGRESS_PROPERTY:
		g_value_set_double (value, geary_progress_monitor_get_progress (self));
		break;
		case GEARY_PROGRESS_MONITOR_IS_IN_PROGRESS_PROPERTY:
		g_value_set_boolean (value, geary_progress_monitor_get_is_in_progress (self));
		break;
		case GEARY_PROGRESS_MONITOR_PROGRESS_TYPE_PROPERTY:
		g_value_set_enum (value, geary_progress_monitor_get_progress_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_progress_monitor_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GearyProgressMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor);
	switch (property_id) {
		case GEARY_PROGRESS_MONITOR_PROGRESS_PROPERTY:
		geary_progress_monitor_set_progress (self, g_value_get_double (value));
		break;
		case GEARY_PROGRESS_MONITOR_IS_IN_PROGRESS_PROPERTY:
		geary_progress_monitor_set_is_in_progress (self, g_value_get_boolean (value));
		break;
		case GEARY_PROGRESS_MONITOR_PROGRESS_TYPE_PROPERTY:
		geary_progress_monitor_set_progress_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
geary_reentrant_progress_monitor_get_instance_private (GearyReentrantProgressMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, GearyReentrantProgressMonitor_private_offset);
}

GearyReentrantProgressMonitor*
geary_reentrant_progress_monitor_construct (GType object_type,
                                            GearyProgressType type)
{
	GearyReentrantProgressMonitor * self = NULL;
	self = (GearyReentrantProgressMonitor*) geary_progress_monitor_construct (object_type);
	geary_progress_monitor_set_progress_type (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor), type);
	return self;
}

GearyReentrantProgressMonitor*
geary_reentrant_progress_monitor_new (GearyProgressType type)
{
	return geary_reentrant_progress_monitor_construct (GEARY_TYPE_REENTRANT_PROGRESS_MONITOR, type);
}

/**
     * {@inheritDoc}
     *
     * Unlike the base class implementation, this may be called multiple times successively without
     * a problem, but each must be matched by a {@link notify_finish} to completely stop the
     * monitor.
     *
     * This is not thread-safe; it's designed for single-threaded asynchronous (non-blocking) use.
     */
static void
geary_reentrant_progress_monitor_real_notify_start (GearyProgressMonitor* base)
{
	GearyReentrantProgressMonitor * self;
	gint _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_REENTRANT_PROGRESS_MONITOR, GearyReentrantProgressMonitor);
	_tmp0_ = self->priv->start_count;
	self->priv->start_count = _tmp0_ + 1;
	if (_tmp0_ == 0) {
		GEARY_PROGRESS_MONITOR_CLASS (geary_reentrant_progress_monitor_parent_class)->notify_start (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	}
}

/**
     * {@inheritDoc}
     *
     * Unlike the base class implementation, this may be called multiple times successively as
     * long as they were matched by a prior {@link notify_start}.
     *
     * This is not thread-safe; it's designed for single-threaded asynchronous (non-blocking) use.
     */
static void
geary_reentrant_progress_monitor_real_notify_finish (GearyProgressMonitor* base)
{
	GearyReentrantProgressMonitor * self;
	gboolean finished = FALSE;
	gint _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_REENTRANT_PROGRESS_MONITOR, GearyReentrantProgressMonitor);
	self->priv->start_count = self->priv->start_count - 1;
	_tmp0_ = self->priv->start_count;
	finished = _tmp0_ == 0;
	self->priv->start_count = CLAMP (self->priv->start_count, 0, G_MAXINT);
	if (finished) {
		GEARY_PROGRESS_MONITOR_CLASS (geary_reentrant_progress_monitor_parent_class)->notify_finish (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	}
}

static void
geary_reentrant_progress_monitor_class_init (GearyReentrantProgressMonitorClass * klass,
                                             gpointer klass_data)
{
	geary_reentrant_progress_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyReentrantProgressMonitor_private_offset);
	((GearyProgressMonitorClass *) klass)->notify_start = (void (*) (GearyProgressMonitor*)) geary_reentrant_progress_monitor_real_notify_start;
	((GearyProgressMonitorClass *) klass)->notify_finish = (void (*) (GearyProgressMonitor*)) geary_reentrant_progress_monitor_real_notify_finish;
	G_OBJECT_CLASS (klass)->finalize = geary_reentrant_progress_monitor_finalize;
}

static void
geary_reentrant_progress_monitor_instance_init (GearyReentrantProgressMonitor * self,
                                                gpointer klass)
{
	self->priv = geary_reentrant_progress_monitor_get_instance_private (self);
	self->priv->start_count = 0;
}

static void
geary_reentrant_progress_monitor_finalize (GObject * obj)
{
	GearyReentrantProgressMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_REENTRANT_PROGRESS_MONITOR, GearyReentrantProgressMonitor);
	G_OBJECT_CLASS (geary_reentrant_progress_monitor_parent_class)->finalize (obj);
}

/**
 * A reentrant {@link ProgressMonitor}.
 *
 * This is not thread-safe; it's designed for single-threaded asynchronous (non-blocking) use.
 */
 G_GNUC_NO_INLINE static GType
geary_reentrant_progress_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyReentrantProgressMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_reentrant_progress_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyReentrantProgressMonitor), 0, (GInstanceInitFunc) geary_reentrant_progress_monitor_instance_init, NULL };
	GType geary_reentrant_progress_monitor_type_id;
	geary_reentrant_progress_monitor_type_id = g_type_register_static (GEARY_TYPE_PROGRESS_MONITOR, "GearyReentrantProgressMonitor", &g_define_type_info, 0);
	GearyReentrantProgressMonitor_private_offset = g_type_add_instance_private (geary_reentrant_progress_monitor_type_id, sizeof (GearyReentrantProgressMonitorPrivate));
	return geary_reentrant_progress_monitor_type_id;
}

GType
geary_reentrant_progress_monitor_get_type (void)
{
	static gsize geary_reentrant_progress_monitor_type_id__once = 0;
	if (g_once_init_enter (&geary_reentrant_progress_monitor_type_id__once)) {
		GType geary_reentrant_progress_monitor_type_id;
		geary_reentrant_progress_monitor_type_id = geary_reentrant_progress_monitor_get_type_once ();
		g_once_init_leave (&geary_reentrant_progress_monitor_type_id__once, geary_reentrant_progress_monitor_type_id);
	}
	return geary_reentrant_progress_monitor_type_id__once;
}

/**
     * Creates a new progress monitor of the given type.
     */
GearySimpleProgressMonitor*
geary_simple_progress_monitor_construct (GType object_type,
                                         GearyProgressType type)
{
	GearySimpleProgressMonitor * self = NULL;
	self = (GearySimpleProgressMonitor*) geary_progress_monitor_construct (object_type);
	geary_progress_monitor_set_progress_type (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor), type);
	return self;
}

GearySimpleProgressMonitor*
geary_simple_progress_monitor_new (GearyProgressType type)
{
	return geary_simple_progress_monitor_construct (GEARY_TYPE_SIMPLE_PROGRESS_MONITOR, type);
}

/**
     * Updates the progress by the given value.  Must be between {@link ProgressMonitor.MIN} and
     * {@link ProgressMonitor.MAX}.
     *
     * Must only be called after {@link ProgressMonitor.notify_start} and before
     * {@link ProgressMonitor.notify_finish}.
     */
void
geary_simple_progress_monitor_increment (GearySimpleProgressMonitor* self,
                                         gdouble value)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	g_return_if_fail (GEARY_IS_SIMPLE_PROGRESS_MONITOR (self));
	_vala_assert (value > ((gdouble) 0), "value > 0");
	_tmp0_ = geary_progress_monitor_get_is_in_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_, "is_in_progress");
	_tmp2_ = geary_progress_monitor_get_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	_tmp3_ = _tmp2_;
	if ((_tmp3_ + value) > GEARY_PROGRESS_MONITOR_MAX) {
		gdouble _tmp4_;
		gdouble _tmp5_;
		_tmp4_ = geary_progress_monitor_get_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
		_tmp5_ = _tmp4_;
		value = GEARY_PROGRESS_MONITOR_MAX - _tmp5_;
	}
	_tmp6_ = geary_progress_monitor_get_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	_tmp7_ = _tmp6_;
	geary_progress_monitor_set_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor), _tmp7_ + value);
	_tmp8_ = geary_progress_monitor_get_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	_tmp9_ = _tmp8_;
	g_signal_emit (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor), geary_progress_monitor_signals[GEARY_PROGRESS_MONITOR_UPDATE_SIGNAL], 0, _tmp9_, value, G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
}

static void
geary_simple_progress_monitor_class_init (GearySimpleProgressMonitorClass * klass,
                                          gpointer klass_data)
{
	geary_simple_progress_monitor_parent_class = g_type_class_peek_parent (klass);
}

static void
geary_simple_progress_monitor_instance_init (GearySimpleProgressMonitor * self,
                                             gpointer klass)
{
}

/**
 * Captures the progress of a single action.
 */
 G_GNUC_NO_INLINE static GType
geary_simple_progress_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearySimpleProgressMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_simple_progress_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearySimpleProgressMonitor), 0, (GInstanceInitFunc) geary_simple_progress_monitor_instance_init, NULL };
	GType geary_simple_progress_monitor_type_id;
	geary_simple_progress_monitor_type_id = g_type_register_static (GEARY_TYPE_PROGRESS_MONITOR, "GearySimpleProgressMonitor", &g_define_type_info, 0);
	return geary_simple_progress_monitor_type_id;
}

GType
geary_simple_progress_monitor_get_type (void)
{
	static gsize geary_simple_progress_monitor_type_id__once = 0;
	if (g_once_init_enter (&geary_simple_progress_monitor_type_id__once)) {
		GType geary_simple_progress_monitor_type_id;
		geary_simple_progress_monitor_type_id = geary_simple_progress_monitor_get_type_once ();
		g_once_init_leave (&geary_simple_progress_monitor_type_id__once, geary_simple_progress_monitor_type_id);
	}
	return geary_simple_progress_monitor_type_id__once;
}

static inline gpointer
geary_interval_progress_monitor_get_instance_private (GearyIntervalProgressMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, GearyIntervalProgressMonitor_private_offset);
}

/**
     * Creates a new progress monitor with the given interval range.
     */
GearyIntervalProgressMonitor*
geary_interval_progress_monitor_construct (GType object_type,
                                           GearyProgressType type,
                                           gint min,
                                           gint max)
{
	GearyIntervalProgressMonitor * self = NULL;
	self = (GearyIntervalProgressMonitor*) geary_progress_monitor_construct (object_type);
	geary_progress_monitor_set_progress_type (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor), type);
	self->priv->min_interval = min;
	self->priv->max_interval = max;
	return self;
}

GearyIntervalProgressMonitor*
geary_interval_progress_monitor_new (GearyProgressType type,
                                     gint min,
                                     gint max)
{
	return geary_interval_progress_monitor_construct (GEARY_TYPE_INTERVAL_PROGRESS_MONITOR, type, min, max);
}

/**
     * Sets a new interval.  Must not be done while in progress.
     */
void
geary_interval_progress_monitor_set_interval (GearyIntervalProgressMonitor* self,
                                              gint min,
                                              gint max)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (GEARY_IS_INTERVAL_PROGRESS_MONITOR (self));
	_tmp0_ = geary_progress_monitor_get_is_in_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	_tmp1_ = _tmp0_;
	_vala_assert (!_tmp1_, "!is_in_progress");
	self->priv->min_interval = min;
	self->priv->max_interval = max;
}

static void
geary_interval_progress_monitor_real_notify_start (GearyProgressMonitor* base)
{
	GearyIntervalProgressMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_INTERVAL_PROGRESS_MONITOR, GearyIntervalProgressMonitor);
	self->priv->current = 0;
	GEARY_PROGRESS_MONITOR_CLASS (geary_interval_progress_monitor_parent_class)->notify_start (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
}

/**
     * Incrememts the progress
     */
void
geary_interval_progress_monitor_increment (GearyIntervalProgressMonitor* self,
                                           gint count)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble new_progress = 0.0;
	gdouble change = 0.0;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	g_return_if_fail (GEARY_IS_INTERVAL_PROGRESS_MONITOR (self));
	_tmp0_ = geary_progress_monitor_get_is_in_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_, "is_in_progress");
	_tmp2_ = geary_progress_monitor_get_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	_tmp3_ = _tmp2_;
	_vala_assert ((count + _tmp3_) >= ((gdouble) self->priv->min_interval), "count + progress >= min_interval");
	_tmp4_ = geary_progress_monitor_get_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	_tmp5_ = _tmp4_;
	_vala_assert ((count + _tmp5_) <= ((gdouble) self->priv->max_interval), "count + progress <= max_interval");
	self->priv->current = self->priv->current + count;
	new_progress = ((1.0 * self->priv->current) - self->priv->min_interval) / ((1.0 * self->priv->max_interval) - self->priv->min_interval);
	_tmp6_ = geary_progress_monitor_get_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	_tmp7_ = _tmp6_;
	change = new_progress - _tmp7_;
	geary_progress_monitor_set_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor), new_progress);
	_tmp8_ = geary_progress_monitor_get_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	_tmp9_ = _tmp8_;
	g_signal_emit (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor), geary_progress_monitor_signals[GEARY_PROGRESS_MONITOR_UPDATE_SIGNAL], 0, _tmp9_, change, G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
}

static void
geary_interval_progress_monitor_class_init (GearyIntervalProgressMonitorClass * klass,
                                            gpointer klass_data)
{
	geary_interval_progress_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyIntervalProgressMonitor_private_offset);
	((GearyProgressMonitorClass *) klass)->notify_start = (void (*) (GearyProgressMonitor*)) geary_interval_progress_monitor_real_notify_start;
	G_OBJECT_CLASS (klass)->finalize = geary_interval_progress_monitor_finalize;
}

static void
geary_interval_progress_monitor_instance_init (GearyIntervalProgressMonitor * self,
                                               gpointer klass)
{
	self->priv = geary_interval_progress_monitor_get_instance_private (self);
	self->priv->current = 0;
}

static void
geary_interval_progress_monitor_finalize (GObject * obj)
{
	GearyIntervalProgressMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_INTERVAL_PROGRESS_MONITOR, GearyIntervalProgressMonitor);
	G_OBJECT_CLASS (geary_interval_progress_monitor_parent_class)->finalize (obj);
}

/**
 * Monitors the progress of a countable interval.  Note that min and max are inclusive.
 */
 G_GNUC_NO_INLINE static GType
geary_interval_progress_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyIntervalProgressMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_interval_progress_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyIntervalProgressMonitor), 0, (GInstanceInitFunc) geary_interval_progress_monitor_instance_init, NULL };
	GType geary_interval_progress_monitor_type_id;
	geary_interval_progress_monitor_type_id = g_type_register_static (GEARY_TYPE_PROGRESS_MONITOR, "GearyIntervalProgressMonitor", &g_define_type_info, 0);
	GearyIntervalProgressMonitor_private_offset = g_type_add_instance_private (geary_interval_progress_monitor_type_id, sizeof (GearyIntervalProgressMonitorPrivate));
	return geary_interval_progress_monitor_type_id;
}

GType
geary_interval_progress_monitor_get_type (void)
{
	static gsize geary_interval_progress_monitor_type_id__once = 0;
	if (g_once_init_enter (&geary_interval_progress_monitor_type_id__once)) {
		GType geary_interval_progress_monitor_type_id;
		geary_interval_progress_monitor_type_id = geary_interval_progress_monitor_get_type_once ();
		g_once_init_leave (&geary_interval_progress_monitor_type_id__once, geary_interval_progress_monitor_type_id);
	}
	return geary_interval_progress_monitor_type_id__once;
}

static inline gpointer
geary_aggregate_progress_monitor_get_instance_private (GearyAggregateProgressMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, GearyAggregateProgressMonitor_private_offset);
}

/**
     * Creates an aggregate progress monitor.
     */
GearyAggregateProgressMonitor*
geary_aggregate_progress_monitor_construct (GType object_type)
{
	GearyAggregateProgressMonitor * self = NULL;
	self = (GearyAggregateProgressMonitor*) geary_progress_monitor_construct (object_type);
	geary_progress_monitor_set_progress_type (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor), GEARY_PROGRESS_TYPE_AGGREGATED);
	return self;
}

GearyAggregateProgressMonitor*
geary_aggregate_progress_monitor_new (void)
{
	return geary_aggregate_progress_monitor_construct (GEARY_TYPE_AGGREGATE_PROGRESS_MONITOR);
}

/**
     * Adds a new progress monitor to this aggregate.
     */
static void
_geary_aggregate_progress_monitor_on_start_geary_progress_monitor_start (GearyProgressMonitor* _sender,
                                                                         gpointer self)
{
	geary_aggregate_progress_monitor_on_start ((GearyAggregateProgressMonitor*) self);
}

static void
_geary_aggregate_progress_monitor_on_update_geary_progress_monitor_update (GearyProgressMonitor* _sender,
                                                                           gdouble total_progress,
                                                                           gdouble change,
                                                                           GearyProgressMonitor* monitor,
                                                                           gpointer self)
{
	geary_aggregate_progress_monitor_on_update ((GearyAggregateProgressMonitor*) self, total_progress, change, monitor);
}

static void
_geary_aggregate_progress_monitor_on_finish_geary_progress_monitor_finish (GearyProgressMonitor* _sender,
                                                                           gpointer self)
{
	geary_aggregate_progress_monitor_on_finish ((GearyAggregateProgressMonitor*) self);
}

void
geary_aggregate_progress_monitor_add (GearyAggregateProgressMonitor* self,
                                      GearyProgressMonitor* pm)
{
	GeeHashSet* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (GEARY_IS_AGGREGATE_PROGRESS_MONITOR (self));
	g_return_if_fail (GEARY_IS_PROGRESS_MONITOR (pm));
	_tmp0_ = self->priv->monitors;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), pm);
	g_signal_connect_object (pm, "start", (GCallback) _geary_aggregate_progress_monitor_on_start_geary_progress_monitor_start, self, 0);
	g_signal_connect_object (pm, "update", (GCallback) _geary_aggregate_progress_monitor_on_update_geary_progress_monitor_update, self, 0);
	g_signal_connect_object (pm, "finish", (GCallback) _geary_aggregate_progress_monitor_on_finish_geary_progress_monitor_finish, self, 0);
	_tmp2_ = geary_progress_monitor_get_is_in_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = geary_progress_monitor_get_is_in_progress (pm);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		geary_progress_monitor_notify_start (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	}
}

void
geary_aggregate_progress_monitor_remove (GearyAggregateProgressMonitor* self,
                                         GearyProgressMonitor* pm)
{
	GeeHashSet* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (GEARY_IS_AGGREGATE_PROGRESS_MONITOR (self));
	g_return_if_fail (GEARY_IS_PROGRESS_MONITOR (pm));
	_tmp0_ = self->priv->monitors;
	gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), pm);
	g_signal_parse_name ("start", GEARY_TYPE_PROGRESS_MONITOR, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (pm, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _geary_aggregate_progress_monitor_on_start_geary_progress_monitor_start, self);
	g_signal_parse_name ("update", GEARY_TYPE_PROGRESS_MONITOR, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (pm, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _geary_aggregate_progress_monitor_on_update_geary_progress_monitor_update, self);
	g_signal_parse_name ("finish", GEARY_TYPE_PROGRESS_MONITOR, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (pm, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _geary_aggregate_progress_monitor_on_finish_geary_progress_monitor_finish, self);
	_tmp5_ = geary_progress_monitor_get_is_in_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = geary_progress_monitor_get_is_in_progress (pm);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean issue_signal = FALSE;
		issue_signal = TRUE;
		{
			GeeIterator* _p_it = NULL;
			GeeHashSet* _tmp9_;
			GeeIterator* _tmp10_;
			_tmp9_ = self->priv->monitors;
			_tmp10_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_p_it = _tmp10_;
			while (TRUE) {
				GeeIterator* _tmp11_;
				GearyProgressMonitor* p = NULL;
				GeeIterator* _tmp12_;
				gpointer _tmp13_;
				GearyProgressMonitor* _tmp14_;
				gboolean _tmp15_;
				gboolean _tmp16_;
				_tmp11_ = _p_it;
				if (!gee_iterator_next (_tmp11_)) {
					break;
				}
				_tmp12_ = _p_it;
				_tmp13_ = gee_iterator_get (_tmp12_);
				p = (GearyProgressMonitor*) _tmp13_;
				_tmp14_ = p;
				_tmp15_ = geary_progress_monitor_get_is_in_progress (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_) {
					issue_signal = FALSE;
					_g_object_unref0 (p);
					break;
				}
				_g_object_unref0 (p);
			}
			_g_object_unref0 (_p_it);
		}
		if (issue_signal) {
			geary_progress_monitor_notify_finish (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
		}
	}
}

static void
geary_aggregate_progress_monitor_on_start (GearyAggregateProgressMonitor* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (GEARY_IS_AGGREGATE_PROGRESS_MONITOR (self));
	_tmp0_ = geary_progress_monitor_get_is_in_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		geary_progress_monitor_notify_start (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	}
}

static void
geary_aggregate_progress_monitor_on_update (GearyAggregateProgressMonitor* self,
                                            gdouble total_progress,
                                            gdouble change,
                                            GearyProgressMonitor* monitor)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gdouble updated_progress = 0.0;
	GeeHashSet* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gdouble aggregated_change = 0.0;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_;
	gdouble _tmp18_;
	gdouble _tmp19_;
	gdouble _tmp20_;
	g_return_if_fail (GEARY_IS_AGGREGATE_PROGRESS_MONITOR (self));
	g_return_if_fail (GEARY_IS_PROGRESS_MONITOR (monitor));
	_tmp0_ = geary_progress_monitor_get_is_in_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	_tmp1_ = _tmp0_;
	_vala_assert (_tmp1_, "is_in_progress");
	updated_progress = GEARY_PROGRESS_MONITOR_MIN;
	{
		GeeIterator* _pm_it = NULL;
		GeeHashSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp2_ = self->priv->monitors;
		_tmp3_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_pm_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			GearyProgressMonitor* pm = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			GearyProgressMonitor* _tmp7_;
			gdouble _tmp8_;
			gdouble _tmp9_;
			_tmp4_ = _pm_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _pm_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			pm = (GearyProgressMonitor*) _tmp6_;
			_tmp7_ = pm;
			_tmp8_ = geary_progress_monitor_get_progress (_tmp7_);
			_tmp9_ = _tmp8_;
			updated_progress += _tmp9_;
			_g_object_unref0 (pm);
		}
		_g_object_unref0 (_pm_it);
	}
	_tmp10_ = self->priv->monitors;
	_tmp11_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp12_ = _tmp11_;
	updated_progress /= (gdouble) _tmp12_;
	_tmp13_ = geary_progress_monitor_get_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	_tmp14_ = _tmp13_;
	aggregated_change = updated_progress - _tmp14_;
	if (aggregated_change < ((gdouble) 0)) {
		aggregated_change = (gdouble) 0;
	}
	_tmp15_ = geary_progress_monitor_get_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	_tmp16_ = _tmp15_;
	geary_progress_monitor_set_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor), _tmp16_ + updated_progress);
	_tmp17_ = geary_progress_monitor_get_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	_tmp18_ = _tmp17_;
	if (_tmp18_ > GEARY_PROGRESS_MONITOR_MAX) {
		geary_progress_monitor_set_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor), GEARY_PROGRESS_MONITOR_MAX);
	}
	_tmp19_ = geary_progress_monitor_get_progress (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
	_tmp20_ = _tmp19_;
	g_signal_emit (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor), geary_progress_monitor_signals[GEARY_PROGRESS_MONITOR_UPDATE_SIGNAL], 0, _tmp20_, aggregated_change, monitor);
}

static void
geary_aggregate_progress_monitor_on_finish (GearyAggregateProgressMonitor* self)
{
	g_return_if_fail (GEARY_IS_AGGREGATE_PROGRESS_MONITOR (self));
	{
		GeeIterator* _pm_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->monitors;
		_tmp1_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_pm_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			GearyProgressMonitor* pm = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			GearyProgressMonitor* _tmp5_;
			gboolean _tmp6_;
			gboolean _tmp7_;
			_tmp2_ = _pm_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _pm_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			pm = (GearyProgressMonitor*) _tmp4_;
			_tmp5_ = pm;
			_tmp6_ = geary_progress_monitor_get_is_in_progress (_tmp5_);
			_tmp7_ = _tmp6_;
			if (_tmp7_) {
				_g_object_unref0 (pm);
				_g_object_unref0 (_pm_it);
				return;
			}
			_g_object_unref0 (pm);
		}
		_g_object_unref0 (_pm_it);
	}
	geary_progress_monitor_notify_finish (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_PROGRESS_MONITOR, GearyProgressMonitor));
}

static void
geary_aggregate_progress_monitor_class_init (GearyAggregateProgressMonitorClass * klass,
                                             gpointer klass_data)
{
	geary_aggregate_progress_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyAggregateProgressMonitor_private_offset);
	G_OBJECT_CLASS (klass)->finalize = geary_aggregate_progress_monitor_finalize;
}

static void
geary_aggregate_progress_monitor_instance_init (GearyAggregateProgressMonitor * self,
                                                gpointer klass)
{
	GeeHashSet* _tmp0_;
	self->priv = geary_aggregate_progress_monitor_get_instance_private (self);
	_tmp0_ = gee_hash_set_new (GEARY_TYPE_PROGRESS_MONITOR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->monitors = _tmp0_;
}

static void
geary_aggregate_progress_monitor_finalize (GObject * obj)
{
	GearyAggregateProgressMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_AGGREGATE_PROGRESS_MONITOR, GearyAggregateProgressMonitor);
	_g_object_unref0 (self->priv->monitors);
	G_OBJECT_CLASS (geary_aggregate_progress_monitor_parent_class)->finalize (obj);
}

/**
 * Captures progress of multiple actions by composing
 * many progress monitors into one.
 */
 G_GNUC_NO_INLINE static GType
geary_aggregate_progress_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyAggregateProgressMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_aggregate_progress_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyAggregateProgressMonitor), 0, (GInstanceInitFunc) geary_aggregate_progress_monitor_instance_init, NULL };
	GType geary_aggregate_progress_monitor_type_id;
	geary_aggregate_progress_monitor_type_id = g_type_register_static (GEARY_TYPE_PROGRESS_MONITOR, "GearyAggregateProgressMonitor", &g_define_type_info, 0);
	GearyAggregateProgressMonitor_private_offset = g_type_add_instance_private (geary_aggregate_progress_monitor_type_id, sizeof (GearyAggregateProgressMonitorPrivate));
	return geary_aggregate_progress_monitor_type_id;
}

GType
geary_aggregate_progress_monitor_get_type (void)
{
	static gsize geary_aggregate_progress_monitor_type_id__once = 0;
	if (g_once_init_enter (&geary_aggregate_progress_monitor_type_id__once)) {
		GType geary_aggregate_progress_monitor_type_id;
		geary_aggregate_progress_monitor_type_id = geary_aggregate_progress_monitor_get_type_once ();
		g_once_init_leave (&geary_aggregate_progress_monitor_type_id__once, geary_aggregate_progress_monitor_type_id);
	}
	return geary_aggregate_progress_monitor_type_id__once;
}

