/* common-contact-harvester.c generated by valac 0.56.3, the Vala compiler
 * generated from common-contact-harvester.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2019 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <gee.h>
#include "geary-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define GEARY_CONTACT_HARVESTER_IMPL_REQUIRED_FIELDS (GEARY_EMAIL_FIELD_ORIGINATORS | GEARY_EMAIL_FIELD_RECEIVERS)

#define GEARY_TYPE_CONTACT_HARVESTER (geary_contact_harvester_get_type ())
#define GEARY_CONTACT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_TYPE_CONTACT_HARVESTER, GearyContactHarvester))
#define GEARY_IS_CONTACT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_TYPE_CONTACT_HARVESTER))
#define GEARY_CONTACT_HARVESTER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEARY_TYPE_CONTACT_HARVESTER, GearyContactHarvesterIface))

typedef struct _GearyContactHarvester GearyContactHarvester;
typedef struct _GearyContactHarvesterIface GearyContactHarvesterIface;

#define GEARY_TYPE_CONTACT_HARVESTER_IMPL (geary_contact_harvester_impl_get_type ())
#define GEARY_CONTACT_HARVESTER_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_TYPE_CONTACT_HARVESTER_IMPL, GearyContactHarvesterImpl))
#define GEARY_CONTACT_HARVESTER_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_TYPE_CONTACT_HARVESTER_IMPL, GearyContactHarvesterImplClass))
#define GEARY_IS_CONTACT_HARVESTER_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_TYPE_CONTACT_HARVESTER_IMPL))
#define GEARY_IS_CONTACT_HARVESTER_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_TYPE_CONTACT_HARVESTER_IMPL))
#define GEARY_CONTACT_HARVESTER_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_TYPE_CONTACT_HARVESTER_IMPL, GearyContactHarvesterImplClass))

typedef struct _GearyContactHarvesterImpl GearyContactHarvesterImpl;
typedef struct _GearyContactHarvesterImplClass GearyContactHarvesterImplClass;
typedef struct _GearyContactHarvesterImplPrivate GearyContactHarvesterImplPrivate;
enum  {
	GEARY_CONTACT_HARVESTER_IMPL_0_PROPERTY,
	GEARY_CONTACT_HARVESTER_IMPL_NUM_PROPERTIES
};
static GParamSpec* geary_contact_harvester_impl_properties[GEARY_CONTACT_HARVESTER_IMPL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GearyContactHarvesterImplHarvestFromEmailData GearyContactHarvesterImplHarvestFromEmailData;
typedef struct _GearyContactHarvesterImplAddContactsData GearyContactHarvesterImplAddContactsData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GearyContactHarvesterImplAddContactData GearyContactHarvesterImplAddContactData;

struct _GearyContactHarvesterIface {
	GTypeInterface parent_iface;
	void (*harvest_from_email) (GearyContactHarvester* self, GeeCollection* messages, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*harvest_from_email_finish) (GearyContactHarvester* self, GAsyncResult* _res_, GError** error);
};

struct _GearyContactHarvesterImpl {
	GearyBaseObject parent_instance;
	GearyContactHarvesterImplPrivate * priv;
};

struct _GearyContactHarvesterImplClass {
	GearyBaseObjectClass parent_class;
};

struct _GearyContactHarvesterImplPrivate {
	GearyContactStore* store;
	GeeCollection* owner_mailboxes;
	GearyFolderSpecialUse location;
	gboolean is_whitelisted;
};

struct _GearyContactHarvesterImplHarvestFromEmailData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyContactHarvesterImpl* self;
	GeeCollection* messages;
	GCancellable* cancellable;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeMap* contacts;
	GeeHashMap* _tmp3_;
	gint importance;
	GearyEmailField type;
	GeeIterator* _message_it;
	GeeIterator* _tmp4_;
	GeeIterator* _tmp5_;
	GearyEmail* message;
	GeeIterator* _tmp6_;
	gpointer _tmp7_;
	GearyEmail* _tmp8_;
	GearyEmailField _tmp9_;
	GearyEmailField _tmp10_;
	GeeMap* _tmp11_;
	GearyEmail* _tmp12_;
	GearyRFC822MailboxAddresses* _tmp13_;
	GearyRFC822MailboxAddresses* _tmp14_;
	GearyEmail* _tmp15_;
	GearyRFC822MailboxAddress* _tmp16_;
	GearyRFC822MailboxAddress* _tmp17_;
	GeeMap* _tmp18_;
	GearyEmail* _tmp19_;
	GearyRFC822MailboxAddress* _tmp20_;
	GearyRFC822MailboxAddress* _tmp21_;
	GeeMap* _tmp22_;
	GearyEmail* _tmp23_;
	GearyRFC822MailboxAddresses* _tmp24_;
	GearyRFC822MailboxAddresses* _tmp25_;
	GeeMap* _tmp26_;
	GearyEmail* _tmp27_;
	GearyRFC822MailboxAddresses* _tmp28_;
	GearyRFC822MailboxAddresses* _tmp29_;
	GeeMap* _tmp30_;
	GearyEmail* _tmp31_;
	GearyRFC822MailboxAddresses* _tmp32_;
	GearyRFC822MailboxAddresses* _tmp33_;
	GeeMap* _tmp34_;
	GearyEmail* _tmp35_;
	GearyRFC822MailboxAddresses* _tmp36_;
	GearyRFC822MailboxAddresses* _tmp37_;
	GearyContactStore* _tmp38_;
	GeeMap* _tmp39_;
	GeeCollection* _tmp40_;
	GeeCollection* _tmp41_;
	GeeCollection* _tmp42_;
	GError* _inner_error0_;
};

struct _GearyContactHarvesterImplAddContactsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyContactHarvesterImpl* self;
	GeeMap* contacts;
	GearyRFC822MailboxAddresses* addresses;
	GearyEmailField type;
	gint importance;
	GCancellable* cancellable;
	GearyRFC822MailboxAddresses* _address_list;
	gint _address_size;
	GearyRFC822MailboxAddresses* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _address_index;
	gint _tmp3_;
	gint _tmp4_;
	GearyRFC822MailboxAddress* address;
	GearyRFC822MailboxAddresses* _tmp5_;
	GearyRFC822MailboxAddress* _tmp6_;
	GearyRFC822MailboxAddress* _tmp7_;
	GError* _inner_error0_;
};

struct _GearyContactHarvesterImplAddContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyContactHarvesterImpl* self;
	GeeMap* contacts;
	GearyRFC822MailboxAddress* address;
	GearyEmailField type;
	gint importance;
	GCancellable* cancellable;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GeeCollection* _tmp2_;
	GearyContact* contact;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gpointer _tmp7_;
	GearyContact* _tmp8_;
	GearyContact* _tmp9_;
	GearyContact* _tmp10_;
	GearyContactStore* _tmp11_;
	GearyContact* _tmp12_;
	GearyContact* _tmp13_;
	GearyContact* _tmp14_;
	GearyContact* _tmp15_;
	GearyContact* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GearyContact* _tmp19_;
	gboolean _tmp20_;
	GearyContact* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	GearyContact* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	GearyContact* _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	GearyContact* _tmp32_;
	GError* _inner_error0_;
};

static gint GearyContactHarvesterImpl_private_offset;
static gpointer geary_contact_harvester_impl_parent_class = NULL;
static GearyContactHarvesterIface * geary_contact_harvester_impl_geary_contact_harvester_parent_iface = NULL;

VALA_EXTERN GType geary_contact_harvester_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void geary_contact_harvester_harvest_from_email (GearyContactHarvester* self,
                                                 GeeCollection* messages,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
VALA_EXTERN void geary_contact_harvester_harvest_from_email_finish (GearyContactHarvester* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
static GType geary_contact_harvester_get_type_once (void);
VALA_EXTERN GType geary_contact_harvester_impl_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyContactHarvesterImpl* geary_contact_harvester_impl_new (GearyContactStore* store,
                                                             GearyFolderSpecialUse location,
                                                             GeeCollection* owners);
VALA_EXTERN GearyContactHarvesterImpl* geary_contact_harvester_impl_construct (GType object_type,
                                                                   GearyContactStore* store,
                                                                   GearyFolderSpecialUse location,
                                                                   GeeCollection* owners);
static gboolean _vala_geary_folder_special_use_array_contains (GearyFolderSpecialUse * stack,
                                                        gssize stack_length,
                                                        const GearyFolderSpecialUse needle);
static void geary_contact_harvester_impl_real_harvest_from_email_data_free (gpointer _data);
static void geary_contact_harvester_impl_real_harvest_from_email (GearyContactHarvester* base,
                                                           GeeCollection* messages,
                                                           GCancellable* cancellable,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
static gboolean geary_contact_harvester_impl_real_harvest_from_email_co (GearyContactHarvesterImplHarvestFromEmailData* _data_);
static void geary_contact_harvester_impl_add_contacts (GearyContactHarvesterImpl* self,
                                                GeeMap* contacts,
                                                GearyRFC822MailboxAddresses* addresses,
                                                GearyEmailField type,
                                                gint importance,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void geary_contact_harvester_impl_add_contacts_finish (GearyContactHarvesterImpl* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static void geary_contact_harvester_impl_harvest_from_email_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_);
static void geary_contact_harvester_impl_add_contact (GearyContactHarvesterImpl* self,
                                               GeeMap* contacts,
                                               GearyRFC822MailboxAddress* address,
                                               GearyEmailField type,
                                               gint importance,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static void geary_contact_harvester_impl_add_contact_finish (GearyContactHarvesterImpl* self,
                                                      GAsyncResult* _res_,
                                                      GError** error);
static void geary_contact_harvester_impl_add_contacts_data_free (gpointer _data);
static gboolean geary_contact_harvester_impl_add_contacts_co (GearyContactHarvesterImplAddContactsData* _data_);
static void geary_contact_harvester_impl_add_contacts_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void geary_contact_harvester_impl_add_contact_data_free (gpointer _data);
static gboolean geary_contact_harvester_impl_add_contact_co (GearyContactHarvesterImplAddContactData* _data_);
static void geary_contact_harvester_impl_add_contact_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
static void geary_contact_harvester_impl_finalize (GObject * obj);
static GType geary_contact_harvester_impl_get_type_once (void);

static const GearyFolderSpecialUse GEARY_CONTACT_HARVESTER_IMPL_FOLDER_WHITELIST[4] = {GEARY_FOLDER_SPECIAL_USE_INBOX, GEARY_FOLDER_SPECIAL_USE_ARCHIVE, GEARY_FOLDER_SPECIAL_USE_SENT, GEARY_FOLDER_SPECIAL_USE_NONE};

void
geary_contact_harvester_harvest_from_email (GearyContactHarvester* self,
                                            GeeCollection* messages,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	GearyContactHarvesterIface* _iface_;
	_iface_ = GEARY_CONTACT_HARVESTER_GET_INTERFACE (self);
	if (_iface_->harvest_from_email) {
		_iface_->harvest_from_email (self, messages, cancellable, _callback_, _user_data_);
	}
}

void
geary_contact_harvester_harvest_from_email_finish (GearyContactHarvester* self,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	GearyContactHarvesterIface* _iface_;
	_iface_ = GEARY_CONTACT_HARVESTER_GET_INTERFACE (self);
	if (_iface_->harvest_from_email_finish) {
		_iface_->harvest_from_email_finish (self, _res_, error);
	}
}

static void
geary_contact_harvester_default_init (GearyContactHarvesterIface * iface,
                                      gpointer iface_data)
{
}

/** Denotes objects that extract contacts from email meages. */
 G_GNUC_NO_INLINE static GType
geary_contact_harvester_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyContactHarvesterIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_contact_harvester_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType geary_contact_harvester_type_id;
	geary_contact_harvester_type_id = g_type_register_static (G_TYPE_INTERFACE, "GearyContactHarvester", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (geary_contact_harvester_type_id, G_TYPE_OBJECT);
	return geary_contact_harvester_type_id;
}

GType
geary_contact_harvester_get_type (void)
{
	static gsize geary_contact_harvester_type_id__once = 0;
	if (g_once_init_enter (&geary_contact_harvester_type_id__once)) {
		GType geary_contact_harvester_type_id;
		geary_contact_harvester_type_id = geary_contact_harvester_get_type_once ();
		g_once_init_leave (&geary_contact_harvester_type_id__once, geary_contact_harvester_type_id);
	}
	return geary_contact_harvester_type_id__once;
}

static inline gpointer
geary_contact_harvester_impl_get_instance_private (GearyContactHarvesterImpl* self)
{
	return G_STRUCT_MEMBER_P (self, GearyContactHarvesterImpl_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_vala_geary_folder_special_use_array_contains (GearyFolderSpecialUse * stack,
                                               gssize stack_length,
                                               const GearyFolderSpecialUse needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

GearyContactHarvesterImpl*
geary_contact_harvester_impl_construct (GType object_type,
                                        GearyContactStore* store,
                                        GearyFolderSpecialUse location,
                                        GeeCollection* owners)
{
	GearyContactHarvesterImpl * self = NULL;
	GearyContactStore* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_val_if_fail (GEARY_IS_CONTACT_STORE (store), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (owners, GEE_TYPE_COLLECTION), NULL);
	self = (GearyContactHarvesterImpl*) geary_base_object_construct (object_type);
	_tmp0_ = _g_object_ref0 (store);
	_g_object_unref0 (self->priv->store);
	self->priv->store = _tmp0_;
	_tmp1_ = _g_object_ref0 (owners);
	_g_object_unref0 (self->priv->owner_mailboxes);
	self->priv->owner_mailboxes = _tmp1_;
	self->priv->location = location;
	self->priv->is_whitelisted = _vala_geary_folder_special_use_array_contains (GEARY_CONTACT_HARVESTER_IMPL_FOLDER_WHITELIST, G_N_ELEMENTS (GEARY_CONTACT_HARVESTER_IMPL_FOLDER_WHITELIST), location);
	return self;
}

GearyContactHarvesterImpl*
geary_contact_harvester_impl_new (GearyContactStore* store,
                                  GearyFolderSpecialUse location,
                                  GeeCollection* owners)
{
	return geary_contact_harvester_impl_construct (GEARY_TYPE_CONTACT_HARVESTER_IMPL, store, location, owners);
}

static void
geary_contact_harvester_impl_real_harvest_from_email_data_free (gpointer _data)
{
	GearyContactHarvesterImplHarvestFromEmailData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->messages);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyContactHarvesterImplHarvestFromEmailData, _data_);
}

static void
geary_contact_harvester_impl_real_harvest_from_email (GearyContactHarvester* base,
                                                      GeeCollection* messages,
                                                      GCancellable* cancellable,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	GearyContactHarvesterImpl * self;
	GearyContactHarvesterImplHarvestFromEmailData* _data_;
	GearyContactHarvesterImpl* _tmp0_;
	GeeCollection* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (messages, GEE_TYPE_COLLECTION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_TYPE_CONTACT_HARVESTER_IMPL, GearyContactHarvesterImpl);
	_data_ = g_slice_new0 (GearyContactHarvesterImplHarvestFromEmailData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_contact_harvester_impl_real_harvest_from_email_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (messages);
	_g_object_unref0 (_data_->messages);
	_data_->messages = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_contact_harvester_impl_real_harvest_from_email_co (_data_);
}

static void
geary_contact_harvester_impl_harvest_from_email_finish (GearyContactHarvester* base,
                                                        GAsyncResult* _res_,
                                                        GError** error)
{
	GearyContactHarvesterImplHarvestFromEmailData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_contact_harvester_impl_harvest_from_email_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_)
{
	GearyContactHarvesterImplHarvestFromEmailData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_contact_harvester_impl_real_harvest_from_email_co (_data_);
}

static gboolean
geary_contact_harvester_impl_real_harvest_from_email_co (GearyContactHarvesterImplHarvestFromEmailData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		case 7:
		goto _state_7;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->self->priv->is_whitelisted) {
		_data_->_tmp1_ = gee_collection_get_is_empty (_data_->messages);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp0_ = !_data_->_tmp2_;
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		_data_->_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEARY_TYPE_CONTACT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_data_->contacts = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, GEE_TYPE_MAP, GeeMap);
		_data_->importance = (gint) GEARY_CONTACT_IMPORTANCE_SEEN;
		if (_data_->self->priv->location == GEARY_FOLDER_SPECIAL_USE_SENT) {
			_data_->importance = (gint) GEARY_CONTACT_IMPORTANCE_SENT_TO;
		}
		_data_->type = 0;
		{
			_data_->_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_data_->messages, GEE_TYPE_ITERABLE, GeeIterable));
			_data_->_message_it = _data_->_tmp4_;
			while (TRUE) {
				_data_->_tmp5_ = _data_->_message_it;
				if (!gee_iterator_next (_data_->_tmp5_)) {
					break;
				}
				_data_->_tmp6_ = _data_->_message_it;
				_data_->_tmp7_ = gee_iterator_get (_data_->_tmp6_);
				_data_->message = (GearyEmail*) _data_->_tmp7_;
				_data_->_tmp8_ = _data_->message;
				_data_->_tmp9_ = geary_email_get_fields (_data_->_tmp8_);
				_data_->_tmp10_ = _data_->_tmp9_;
				if (geary_email_field_fulfills (_data_->_tmp10_, GEARY_CONTACT_HARVESTER_IMPL_REQUIRED_FIELDS)) {
					_data_->type = GEARY_EMAIL_FIELD_ORIGINATORS;
					_data_->_tmp11_ = _data_->contacts;
					_data_->_tmp12_ = _data_->message;
					_data_->_tmp13_ = geary_email_header_set_get_from (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
					_data_->_tmp14_ = _data_->_tmp13_;
					_data_->_state_ = 1;
					geary_contact_harvester_impl_add_contacts (_data_->self, _data_->_tmp11_, _data_->_tmp14_, _data_->type, _data_->importance, _data_->cancellable, geary_contact_harvester_impl_harvest_from_email_ready, _data_);
					return FALSE;
					_state_1:
					geary_contact_harvester_impl_add_contacts_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_g_object_unref0 (_data_->message);
						_g_object_unref0 (_data_->_message_it);
						_g_object_unref0 (_data_->contacts);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_data_->_tmp15_ = _data_->message;
					_data_->_tmp16_ = geary_email_header_set_get_sender (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp15_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
					_data_->_tmp17_ = _data_->_tmp16_;
					if (_data_->_tmp17_ != NULL) {
						_data_->_tmp18_ = _data_->contacts;
						_data_->_tmp19_ = _data_->message;
						_data_->_tmp20_ = geary_email_header_set_get_sender (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp19_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
						_data_->_tmp21_ = _data_->_tmp20_;
						_data_->_state_ = 2;
						geary_contact_harvester_impl_add_contact (_data_->self, _data_->_tmp18_, _data_->_tmp21_, _data_->type, _data_->importance, _data_->cancellable, geary_contact_harvester_impl_harvest_from_email_ready, _data_);
						return FALSE;
						_state_2:
						geary_contact_harvester_impl_add_contact_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
							_g_object_unref0 (_data_->message);
							_g_object_unref0 (_data_->_message_it);
							_g_object_unref0 (_data_->contacts);
							g_object_unref (_data_->_async_result);
							return FALSE;
						}
					}
					_data_->_tmp22_ = _data_->contacts;
					_data_->_tmp23_ = _data_->message;
					_data_->_tmp24_ = geary_email_header_set_get_bcc (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp23_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
					_data_->_tmp25_ = _data_->_tmp24_;
					_data_->_state_ = 3;
					geary_contact_harvester_impl_add_contacts (_data_->self, _data_->_tmp22_, _data_->_tmp25_, _data_->type, _data_->importance, _data_->cancellable, geary_contact_harvester_impl_harvest_from_email_ready, _data_);
					return FALSE;
					_state_3:
					geary_contact_harvester_impl_add_contacts_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_g_object_unref0 (_data_->message);
						_g_object_unref0 (_data_->_message_it);
						_g_object_unref0 (_data_->contacts);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_data_->type = GEARY_EMAIL_FIELD_RECEIVERS;
					_data_->_tmp26_ = _data_->contacts;
					_data_->_tmp27_ = _data_->message;
					_data_->_tmp28_ = geary_email_header_set_get_to (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp27_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
					_data_->_tmp29_ = _data_->_tmp28_;
					_data_->_state_ = 4;
					geary_contact_harvester_impl_add_contacts (_data_->self, _data_->_tmp26_, _data_->_tmp29_, _data_->type, _data_->importance, _data_->cancellable, geary_contact_harvester_impl_harvest_from_email_ready, _data_);
					return FALSE;
					_state_4:
					geary_contact_harvester_impl_add_contacts_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_g_object_unref0 (_data_->message);
						_g_object_unref0 (_data_->_message_it);
						_g_object_unref0 (_data_->contacts);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_data_->_tmp30_ = _data_->contacts;
					_data_->_tmp31_ = _data_->message;
					_data_->_tmp32_ = geary_email_header_set_get_cc (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp31_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
					_data_->_tmp33_ = _data_->_tmp32_;
					_data_->_state_ = 5;
					geary_contact_harvester_impl_add_contacts (_data_->self, _data_->_tmp30_, _data_->_tmp33_, _data_->type, _data_->importance, _data_->cancellable, geary_contact_harvester_impl_harvest_from_email_ready, _data_);
					return FALSE;
					_state_5:
					geary_contact_harvester_impl_add_contacts_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_g_object_unref0 (_data_->message);
						_g_object_unref0 (_data_->_message_it);
						_g_object_unref0 (_data_->contacts);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
					_data_->_tmp34_ = _data_->contacts;
					_data_->_tmp35_ = _data_->message;
					_data_->_tmp36_ = geary_email_header_set_get_bcc (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp35_, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
					_data_->_tmp37_ = _data_->_tmp36_;
					_data_->_state_ = 6;
					geary_contact_harvester_impl_add_contacts (_data_->self, _data_->_tmp34_, _data_->_tmp37_, _data_->type, _data_->importance, _data_->cancellable, geary_contact_harvester_impl_harvest_from_email_ready, _data_);
					return FALSE;
					_state_6:
					geary_contact_harvester_impl_add_contacts_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
						_g_object_unref0 (_data_->message);
						_g_object_unref0 (_data_->_message_it);
						_g_object_unref0 (_data_->contacts);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				_g_object_unref0 (_data_->message);
			}
			_g_object_unref0 (_data_->_message_it);
		}
		_data_->_tmp38_ = _data_->self->priv->store;
		_data_->_tmp39_ = _data_->contacts;
		_data_->_tmp40_ = gee_map_get_values (_data_->_tmp39_);
		_data_->_tmp41_ = _data_->_tmp40_;
		_data_->_tmp42_ = _data_->_tmp41_;
		_data_->_state_ = 7;
		geary_contact_store_update_contacts (_data_->_tmp38_, _data_->_tmp42_, _data_->cancellable, geary_contact_harvester_impl_harvest_from_email_ready, _data_);
		return FALSE;
		_state_7:
		geary_contact_store_update_contacts_finish (_data_->_tmp38_, _data_->_res_, &_data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp42_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->contacts);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->contacts);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_contact_harvester_impl_add_contacts_data_free (gpointer _data)
{
	GearyContactHarvesterImplAddContactsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->contacts);
	_g_object_unref0 (_data_->addresses);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyContactHarvesterImplAddContactsData, _data_);
}

static void
geary_contact_harvester_impl_add_contacts (GearyContactHarvesterImpl* self,
                                           GeeMap* contacts,
                                           GearyRFC822MailboxAddresses* addresses,
                                           GearyEmailField type,
                                           gint importance,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	GearyContactHarvesterImplAddContactsData* _data_;
	GearyContactHarvesterImpl* _tmp0_;
	GeeMap* _tmp1_;
	GearyRFC822MailboxAddresses* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (GEARY_IS_CONTACT_HARVESTER_IMPL (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (contacts, GEE_TYPE_MAP));
	g_return_if_fail ((addresses == NULL) || GEARY_RF_C822_IS_MAILBOX_ADDRESSES (addresses));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyContactHarvesterImplAddContactsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_contact_harvester_impl_add_contacts_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (contacts);
	_g_object_unref0 (_data_->contacts);
	_data_->contacts = _tmp1_;
	_tmp2_ = _g_object_ref0 (addresses);
	_g_object_unref0 (_data_->addresses);
	_data_->addresses = _tmp2_;
	_data_->type = type;
	_data_->importance = importance;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	geary_contact_harvester_impl_add_contacts_co (_data_);
}

static void
geary_contact_harvester_impl_add_contacts_finish (GearyContactHarvesterImpl* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	GearyContactHarvesterImplAddContactsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_contact_harvester_impl_add_contacts_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	GearyContactHarvesterImplAddContactsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_contact_harvester_impl_add_contacts_co (_data_);
}

static gboolean
geary_contact_harvester_impl_add_contacts_co (GearyContactHarvesterImplAddContactsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->addresses != NULL) {
		{
			_data_->_address_list = _data_->addresses;
			_data_->_tmp0_ = _data_->_address_list;
			_data_->_tmp1_ = geary_rf_c822_mailbox_addresses_get_size (_data_->_tmp0_);
			_data_->_tmp2_ = _data_->_tmp1_;
			_data_->_address_size = _data_->_tmp2_;
			_data_->_address_index = -1;
			while (TRUE) {
				_data_->_address_index = _data_->_address_index + 1;
				_data_->_tmp3_ = _data_->_address_index;
				_data_->_tmp4_ = _data_->_address_size;
				if (!(_data_->_tmp3_ < _data_->_tmp4_)) {
					break;
				}
				_data_->_tmp5_ = _data_->_address_list;
				_data_->_tmp6_ = geary_rf_c822_mailbox_addresses_get (_data_->_tmp5_, _data_->_address_index);
				_data_->address = _data_->_tmp6_;
				_data_->_tmp7_ = _data_->address;
				_data_->_state_ = 1;
				geary_contact_harvester_impl_add_contact (_data_->self, _data_->contacts, _data_->_tmp7_, _data_->type, _data_->importance, _data_->cancellable, geary_contact_harvester_impl_add_contacts_ready, _data_);
				return FALSE;
				_state_1:
				geary_contact_harvester_impl_add_contact_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
					_g_object_unref0 (_data_->address);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_g_object_unref0 (_data_->address);
			}
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_contact_harvester_impl_add_contact_data_free (gpointer _data)
{
	GearyContactHarvesterImplAddContactData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->contacts);
	_g_object_unref0 (_data_->address);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyContactHarvesterImplAddContactData, _data_);
}

static void
geary_contact_harvester_impl_add_contact (GearyContactHarvesterImpl* self,
                                          GeeMap* contacts,
                                          GearyRFC822MailboxAddress* address,
                                          GearyEmailField type,
                                          gint importance,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	GearyContactHarvesterImplAddContactData* _data_;
	GearyContactHarvesterImpl* _tmp0_;
	GeeMap* _tmp1_;
	GearyRFC822MailboxAddress* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (GEARY_IS_CONTACT_HARVESTER_IMPL (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (contacts, GEE_TYPE_MAP));
	g_return_if_fail (GEARY_RF_C822_IS_MAILBOX_ADDRESS (address));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyContactHarvesterImplAddContactData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_contact_harvester_impl_add_contact_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (contacts);
	_g_object_unref0 (_data_->contacts);
	_data_->contacts = _tmp1_;
	_tmp2_ = _g_object_ref0 (address);
	_g_object_unref0 (_data_->address);
	_data_->address = _tmp2_;
	_data_->type = type;
	_data_->importance = importance;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	geary_contact_harvester_impl_add_contact_co (_data_);
}

static void
geary_contact_harvester_impl_add_contact_finish (GearyContactHarvesterImpl* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	GearyContactHarvesterImplAddContactData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_contact_harvester_impl_add_contact_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	GearyContactHarvesterImplAddContactData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_contact_harvester_impl_add_contact_co (_data_);
}

static gboolean
geary_contact_harvester_impl_add_contact_co (GearyContactHarvesterImplAddContactData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (geary_rf_c822_mailbox_address_is_valid (_data_->address)) {
		_data_->_tmp0_ = !geary_rf_c822_mailbox_address_is_spoofed (_data_->address);
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		if (_data_->type == GEARY_EMAIL_FIELD_RECEIVERS) {
			_data_->_tmp2_ = _data_->self->priv->owner_mailboxes;
			_data_->_tmp1_ = gee_collection_contains (_data_->_tmp2_, _data_->address);
		} else {
			_data_->_tmp1_ = FALSE;
		}
		if (_data_->_tmp1_) {
			_data_->importance = (gint) GEARY_CONTACT_IMPORTANCE_RECEIVED_FROM;
		}
		_data_->_tmp3_ = geary_rf_c822_mailbox_address_get_address (_data_->address);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = geary_contact_normalise_email (_data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = gee_map_get (_data_->contacts, _data_->_tmp6_);
		_data_->_tmp8_ = (GearyContact*) _data_->_tmp7_;
		_g_free0 (_data_->_tmp6_);
		_data_->contact = _data_->_tmp8_;
		_data_->_tmp9_ = _data_->contact;
		if (_data_->_tmp9_ == NULL) {
			_data_->_tmp11_ = _data_->self->priv->store;
			_data_->_state_ = 1;
			geary_contact_store_get_by_rfc822 (_data_->_tmp11_, _data_->address, _data_->cancellable, geary_contact_harvester_impl_add_contact_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp12_ = geary_contact_store_get_by_rfc822_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp10_ = _data_->_tmp12_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->contact);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp13_ = _data_->_tmp10_;
			_data_->_tmp10_ = NULL;
			_g_object_unref0 (_data_->contact);
			_data_->contact = _data_->_tmp13_;
			_data_->_tmp14_ = _data_->contact;
			if (_data_->_tmp14_ == NULL) {
				_data_->_tmp15_ = geary_contact_new_from_rfc822_address (_data_->address, _data_->importance);
				_g_object_unref0 (_data_->contact);
				_data_->contact = _data_->_tmp15_;
			}
			_data_->_tmp16_ = _data_->contact;
			_data_->_tmp17_ = geary_contact_get_normalized_email (_data_->_tmp16_);
			_data_->_tmp18_ = _data_->_tmp17_;
			_data_->_tmp19_ = _data_->contact;
			gee_map_set (_data_->contacts, _data_->_tmp18_, _data_->_tmp19_);
			_g_object_unref0 (_data_->_tmp10_);
		}
		_data_->_tmp21_ = _data_->contact;
		_data_->_tmp22_ = geary_contact_get_highest_importance (_data_->_tmp21_);
		_data_->_tmp23_ = _data_->_tmp22_;
		if (_data_->_tmp23_ <= _data_->importance) {
			_data_->_tmp24_ = geary_rf_c822_mailbox_address_get_name (_data_->address);
			_data_->_tmp25_ = _data_->_tmp24_;
			_data_->_tmp20_ = !geary_string_is_empty_or_whitespace (_data_->_tmp25_);
		} else {
			_data_->_tmp20_ = FALSE;
		}
		if (_data_->_tmp20_) {
			_data_->_tmp26_ = _data_->contact;
			_data_->_tmp27_ = geary_rf_c822_mailbox_address_get_name (_data_->address);
			_data_->_tmp28_ = _data_->_tmp27_;
			geary_contact_set_real_name (_data_->_tmp26_, _data_->_tmp28_);
		}
		_data_->_tmp29_ = _data_->contact;
		_data_->_tmp30_ = geary_contact_get_highest_importance (_data_->_tmp29_);
		_data_->_tmp31_ = _data_->_tmp30_;
		if (_data_->_tmp31_ < _data_->importance) {
			_data_->_tmp32_ = _data_->contact;
			geary_contact_set_highest_importance (_data_->_tmp32_, _data_->importance);
		}
		_g_object_unref0 (_data_->contact);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_contact_harvester_impl_class_init (GearyContactHarvesterImplClass * klass,
                                         gpointer klass_data)
{
	geary_contact_harvester_impl_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyContactHarvesterImpl_private_offset);
	G_OBJECT_CLASS (klass)->finalize = geary_contact_harvester_impl_finalize;
}

static void
geary_contact_harvester_impl_geary_contact_harvester_interface_init (GearyContactHarvesterIface * iface,
                                                                     gpointer iface_data)
{
	geary_contact_harvester_impl_geary_contact_harvester_parent_iface = g_type_interface_peek_parent (iface);
	iface->harvest_from_email = (void (*) (GearyContactHarvester*, GeeCollection*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_contact_harvester_impl_real_harvest_from_email;
	iface->harvest_from_email_finish = (void (*) (GearyContactHarvester*, GAsyncResult*, GError**)) geary_contact_harvester_impl_harvest_from_email_finish;
}

static void
geary_contact_harvester_impl_instance_init (GearyContactHarvesterImpl * self,
                                            gpointer klass)
{
	self->priv = geary_contact_harvester_impl_get_instance_private (self);
}

static void
geary_contact_harvester_impl_finalize (GObject * obj)
{
	GearyContactHarvesterImpl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_TYPE_CONTACT_HARVESTER_IMPL, GearyContactHarvesterImpl);
	_g_object_unref0 (self->priv->store);
	_g_object_unref0 (self->priv->owner_mailboxes);
	G_OBJECT_CLASS (geary_contact_harvester_impl_parent_class)->finalize (obj);
}

/** Default harvester that saves contacts in the contact store. */
 G_GNUC_NO_INLINE static GType
geary_contact_harvester_impl_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyContactHarvesterImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_contact_harvester_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyContactHarvesterImpl), 0, (GInstanceInitFunc) geary_contact_harvester_impl_instance_init, NULL };
	static const GInterfaceInfo geary_contact_harvester_info = { (GInterfaceInitFunc) geary_contact_harvester_impl_geary_contact_harvester_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_contact_harvester_impl_type_id;
	geary_contact_harvester_impl_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyContactHarvesterImpl", &g_define_type_info, 0);
	g_type_add_interface_static (geary_contact_harvester_impl_type_id, GEARY_TYPE_CONTACT_HARVESTER, &geary_contact_harvester_info);
	GearyContactHarvesterImpl_private_offset = g_type_add_instance_private (geary_contact_harvester_impl_type_id, sizeof (GearyContactHarvesterImplPrivate));
	return geary_contact_harvester_impl_type_id;
}

GType
geary_contact_harvester_impl_get_type (void)
{
	static gsize geary_contact_harvester_impl_type_id__once = 0;
	if (g_once_init_enter (&geary_contact_harvester_impl_type_id__once)) {
		GType geary_contact_harvester_impl_type_id;
		geary_contact_harvester_impl_type_id = geary_contact_harvester_impl_get_type_once ();
		g_once_init_leave (&geary_contact_harvester_impl_type_id__once, geary_contact_harvester_impl_type_id);
	}
	return geary_contact_harvester_impl_type_id__once;
}

