/* imap-db-message-row.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-db-message-row.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <glib.h>
#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#define GEARY_IMAP_DB_TYPE_MESSAGE_ROW (geary_imap_db_message_row_get_type ())
#define GEARY_IMAP_DB_MESSAGE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_MESSAGE_ROW, GearyImapDBMessageRow))
#define GEARY_IMAP_DB_MESSAGE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_MESSAGE_ROW, GearyImapDBMessageRowClass))
#define GEARY_IMAP_DB_IS_MESSAGE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_MESSAGE_ROW))
#define GEARY_IMAP_DB_IS_MESSAGE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_MESSAGE_ROW))
#define GEARY_IMAP_DB_MESSAGE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_MESSAGE_ROW, GearyImapDBMessageRowClass))

typedef struct _GearyImapDBMessageRow GearyImapDBMessageRow;
typedef struct _GearyImapDBMessageRowClass GearyImapDBMessageRowClass;
typedef struct _GearyImapDBMessageRowPrivate GearyImapDBMessageRowPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _geary_imap_db_message_row_unref0(var) ((var == NULL) ? NULL : (var = (geary_imap_db_message_row_unref (var), NULL)))

#define GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER (geary_imap_db_email_identifier_get_type ())
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifier))
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifierClass))
#define GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER))
#define GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER))
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifierClass))

typedef struct _GearyImapDBEmailIdentifier GearyImapDBEmailIdentifier;
typedef struct _GearyImapDBEmailIdentifierClass GearyImapDBEmailIdentifierClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GearyImapDBParamSpecMessageRow GearyImapDBParamSpecMessageRow;

struct _GearyImapDBMessageRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GearyImapDBMessageRowPrivate * priv;
};

struct _GearyImapDBMessageRowClass {
	GTypeClass parent_class;
	void (*finalize) (GearyImapDBMessageRow *self);
};

struct _GearyImapDBMessageRowPrivate {
	gint64 _id;
	GearyEmailField _fields;
	gchar* _date;
	gint64 _date_time_t;
	gchar* _from;
	gchar* _sender;
	gchar* _reply_to;
	gchar* _to;
	gchar* _cc;
	gchar* _bcc;
	gchar* _message_id;
	gchar* _in_reply_to;
	gchar* _references;
	gchar* _subject;
	GearyMemoryBuffer* _header;
	GearyMemoryBuffer* _body;
	gchar* _preview;
	gchar* _email_flags;
	gchar* _internaldate;
	gint64 _internaldate_time_t;
	gint64 _rfc822_size;
};

struct _GearyImapDBParamSpecMessageRow {
	GParamSpec parent_instance;
};

static gint GearyImapDBMessageRow_private_offset;
static gpointer geary_imap_db_message_row_parent_class = NULL;

VALA_EXTERN gpointer geary_imap_db_message_row_ref (gpointer instance);
VALA_EXTERN void geary_imap_db_message_row_unref (gpointer instance);
VALA_EXTERN GParamSpec* geary_imap_db_param_spec_message_row (const gchar* name,
                                                  const gchar* nick,
                                                  const gchar* blurb,
                                                  GType object_type,
                                                  GParamFlags flags);
VALA_EXTERN void geary_imap_db_value_set_message_row (GValue* value,
                                          gpointer v_object);
VALA_EXTERN void geary_imap_db_value_take_message_row (GValue* value,
                                           gpointer v_object);
VALA_EXTERN gpointer geary_imap_db_value_get_message_row (const GValue* value);
VALA_EXTERN GType geary_imap_db_message_row_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gint64 geary_imap_db_message_row_get_id (GearyImapDBMessageRow* self);
VALA_EXTERN void geary_imap_db_message_row_set_id (GearyImapDBMessageRow* self,
                                       gint64 value);
VALA_EXTERN GearyEmailField geary_imap_db_message_row_get_fields (GearyImapDBMessageRow* self);
VALA_EXTERN void geary_imap_db_message_row_set_fields (GearyImapDBMessageRow* self,
                                           GearyEmailField value);
VALA_EXTERN const gchar* geary_imap_db_message_row_get_date (GearyImapDBMessageRow* self);
VALA_EXTERN void geary_imap_db_message_row_set_date (GearyImapDBMessageRow* self,
                                         const gchar* value);
VALA_EXTERN gint64 geary_imap_db_message_row_get_date_time_t (GearyImapDBMessageRow* self);
VALA_EXTERN void geary_imap_db_message_row_set_date_time_t (GearyImapDBMessageRow* self,
                                                gint64 value);
VALA_EXTERN const gchar* geary_imap_db_message_row_get_from (GearyImapDBMessageRow* self);
VALA_EXTERN void geary_imap_db_message_row_set_from (GearyImapDBMessageRow* self,
                                         const gchar* value);
VALA_EXTERN const gchar* geary_imap_db_message_row_get_sender (GearyImapDBMessageRow* self);
VALA_EXTERN void geary_imap_db_message_row_set_sender (GearyImapDBMessageRow* self,
                                           const gchar* value);
VALA_EXTERN const gchar* geary_imap_db_message_row_get_reply_to (GearyImapDBMessageRow* self);
VALA_EXTERN void geary_imap_db_message_row_set_reply_to (GearyImapDBMessageRow* self,
                                             const gchar* value);
VALA_EXTERN const gchar* geary_imap_db_message_row_get_to (GearyImapDBMessageRow* self);
VALA_EXTERN void geary_imap_db_message_row_set_to (GearyImapDBMessageRow* self,
                                       const gchar* value);
VALA_EXTERN const gchar* geary_imap_db_message_row_get_cc (GearyImapDBMessageRow* self);
VALA_EXTERN void geary_imap_db_message_row_set_cc (GearyImapDBMessageRow* self,
                                       const gchar* value);
VALA_EXTERN const gchar* geary_imap_db_message_row_get_bcc (GearyImapDBMessageRow* self);
VALA_EXTERN void geary_imap_db_message_row_set_bcc (GearyImapDBMessageRow* self,
                                        const gchar* value);
VALA_EXTERN const gchar* geary_imap_db_message_row_get_message_id (GearyImapDBMessageRow* self);
VALA_EXTERN void geary_imap_db_message_row_set_message_id (GearyImapDBMessageRow* self,
                                               const gchar* value);
VALA_EXTERN const gchar* geary_imap_db_message_row_get_in_reply_to (GearyImapDBMessageRow* self);
VALA_EXTERN void geary_imap_db_message_row_set_in_reply_to (GearyImapDBMessageRow* self,
                                                const gchar* value);
VALA_EXTERN const gchar* geary_imap_db_message_row_get_references (GearyImapDBMessageRow* self);
VALA_EXTERN void geary_imap_db_message_row_set_references (GearyImapDBMessageRow* self,
                                               const gchar* value);
VALA_EXTERN const gchar* geary_imap_db_message_row_get_subject (GearyImapDBMessageRow* self);
VALA_EXTERN void geary_imap_db_message_row_set_subject (GearyImapDBMessageRow* self,
                                            const gchar* value);
VALA_EXTERN GearyMemoryBuffer* geary_imap_db_message_row_get_header (GearyImapDBMessageRow* self);
VALA_EXTERN void geary_imap_db_message_row_set_header (GearyImapDBMessageRow* self,
                                           GearyMemoryBuffer* value);
VALA_EXTERN GearyMemoryBuffer* geary_imap_db_message_row_get_body (GearyImapDBMessageRow* self);
VALA_EXTERN void geary_imap_db_message_row_set_body (GearyImapDBMessageRow* self,
                                         GearyMemoryBuffer* value);
VALA_EXTERN const gchar* geary_imap_db_message_row_get_preview (GearyImapDBMessageRow* self);
VALA_EXTERN void geary_imap_db_message_row_set_preview (GearyImapDBMessageRow* self,
                                            const gchar* value);
VALA_EXTERN const gchar* geary_imap_db_message_row_get_email_flags (GearyImapDBMessageRow* self);
VALA_EXTERN void geary_imap_db_message_row_set_email_flags (GearyImapDBMessageRow* self,
                                                const gchar* value);
VALA_EXTERN const gchar* geary_imap_db_message_row_get_internaldate (GearyImapDBMessageRow* self);
VALA_EXTERN void geary_imap_db_message_row_set_internaldate (GearyImapDBMessageRow* self,
                                                 const gchar* value);
VALA_EXTERN gint64 geary_imap_db_message_row_get_internaldate_time_t (GearyImapDBMessageRow* self);
VALA_EXTERN void geary_imap_db_message_row_set_internaldate_time_t (GearyImapDBMessageRow* self,
                                                        gint64 value);
VALA_EXTERN gint64 geary_imap_db_message_row_get_rfc822_size (GearyImapDBMessageRow* self);
VALA_EXTERN void geary_imap_db_message_row_set_rfc822_size (GearyImapDBMessageRow* self,
                                                gint64 value);
VALA_EXTERN GearyImapDBMessageRow* geary_imap_db_message_row_new (void);
VALA_EXTERN GearyImapDBMessageRow* geary_imap_db_message_row_construct (GType object_type);
VALA_EXTERN GearyImapDBMessageRow* geary_imap_db_message_row_new_from_email (GearyEmail* email);
VALA_EXTERN GearyImapDBMessageRow* geary_imap_db_message_row_construct_from_email (GType object_type,
                                                                       GearyEmail* email);
static void geary_imap_db_message_row_set_from_email (GearyImapDBMessageRow* self,
                                               GearyEmail* email);
VALA_EXTERN GearyImapDBMessageRow* geary_imap_db_message_row_new_from_result (GearyEmailField requested_fields,
                                                                  GearyDbResult* results,
                                                                  GError** error);
VALA_EXTERN GearyImapDBMessageRow* geary_imap_db_message_row_construct_from_result (GType object_type,
                                                                        GearyEmailField requested_fields,
                                                                        GearyDbResult* results,
                                                                        GError** error);
VALA_EXTERN GType geary_imap_db_email_identifier_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyEmail* geary_imap_db_message_row_to_email (GearyImapDBMessageRow* self,
                                                GearyImapDBEmailIdentifier* id,
                                                GError** error);
static GearyRFC822Date* geary_imap_db_message_row_unflatten_date (GearyImapDBMessageRow* self,
                                                           const gchar* str);
static GearyRFC822MailboxAddresses* geary_imap_db_message_row_unflatten_addresses (GearyImapDBMessageRow* self,
                                                                            const gchar* str);
static GearyRFC822MailboxAddress* geary_imap_db_message_row_unflatten_address (GearyImapDBMessageRow* self,
                                                                        const gchar* str);
static GearyRFC822MessageID* geary_imap_db_message_row_unflatten_message_id (GearyImapDBMessageRow* self,
                                                                      const gchar* str);
static GearyRFC822MessageIDList* geary_imap_db_message_row_unflatten_message_id_list (GearyImapDBMessageRow* self,
                                                                               const gchar* str);
VALA_EXTERN GearyEmailFlags* geary_imap_db_message_row_get_generic_email_flags (GearyImapDBMessageRow* self);
VALA_EXTERN GearyImapEmailProperties* geary_imap_db_message_row_get_imap_email_properties (GearyImapDBMessageRow* self);
VALA_EXTERN void geary_imap_db_message_row_merge_from_remote (GearyImapDBMessageRow* self,
                                                  GearyEmail* email);
static gchar* geary_imap_db_message_row_flatten_addresses (GearyRFC822MailboxAddresses* addrs);
static gchar* geary_imap_db_message_row_flatten_address (GearyRFC822MailboxAddress* addr);
static void geary_imap_db_message_row_finalize (GearyImapDBMessageRow * obj);
static GType geary_imap_db_message_row_get_type_once (void);

static inline gpointer
geary_imap_db_message_row_get_instance_private (GearyImapDBMessageRow* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapDBMessageRow_private_offset);
}

gint64
geary_imap_db_message_row_get_id (GearyImapDBMessageRow* self)
{
	gint64 result;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), 0LL);
	result = self->priv->_id;
	return result;
}

void
geary_imap_db_message_row_set_id (GearyImapDBMessageRow* self,
                                  gint64 value)
{
	g_return_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self));
	self->priv->_id = value;
}

GearyEmailField
geary_imap_db_message_row_get_fields (GearyImapDBMessageRow* self)
{
	GearyEmailField result;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), 0);
	result = self->priv->_fields;
	return result;
}

void
geary_imap_db_message_row_set_fields (GearyImapDBMessageRow* self,
                                      GearyEmailField value)
{
	g_return_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self));
	self->priv->_fields = value;
}

const gchar*
geary_imap_db_message_row_get_date (GearyImapDBMessageRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), NULL);
	_tmp0_ = self->priv->_date;
	result = _tmp0_;
	return result;
}

void
geary_imap_db_message_row_set_date (GearyImapDBMessageRow* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_date);
	self->priv->_date = _tmp0_;
}

gint64
geary_imap_db_message_row_get_date_time_t (GearyImapDBMessageRow* self)
{
	gint64 result;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), 0LL);
	result = self->priv->_date_time_t;
	return result;
}

void
geary_imap_db_message_row_set_date_time_t (GearyImapDBMessageRow* self,
                                           gint64 value)
{
	g_return_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self));
	self->priv->_date_time_t = value;
}

const gchar*
geary_imap_db_message_row_get_from (GearyImapDBMessageRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), NULL);
	_tmp0_ = self->priv->_from;
	result = _tmp0_;
	return result;
}

void
geary_imap_db_message_row_set_from (GearyImapDBMessageRow* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_from);
	self->priv->_from = _tmp0_;
}

const gchar*
geary_imap_db_message_row_get_sender (GearyImapDBMessageRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), NULL);
	_tmp0_ = self->priv->_sender;
	result = _tmp0_;
	return result;
}

void
geary_imap_db_message_row_set_sender (GearyImapDBMessageRow* self,
                                      const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_sender);
	self->priv->_sender = _tmp0_;
}

const gchar*
geary_imap_db_message_row_get_reply_to (GearyImapDBMessageRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), NULL);
	_tmp0_ = self->priv->_reply_to;
	result = _tmp0_;
	return result;
}

void
geary_imap_db_message_row_set_reply_to (GearyImapDBMessageRow* self,
                                        const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_reply_to);
	self->priv->_reply_to = _tmp0_;
}

const gchar*
geary_imap_db_message_row_get_to (GearyImapDBMessageRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), NULL);
	_tmp0_ = self->priv->_to;
	result = _tmp0_;
	return result;
}

void
geary_imap_db_message_row_set_to (GearyImapDBMessageRow* self,
                                  const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_to);
	self->priv->_to = _tmp0_;
}

const gchar*
geary_imap_db_message_row_get_cc (GearyImapDBMessageRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), NULL);
	_tmp0_ = self->priv->_cc;
	result = _tmp0_;
	return result;
}

void
geary_imap_db_message_row_set_cc (GearyImapDBMessageRow* self,
                                  const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_cc);
	self->priv->_cc = _tmp0_;
}

const gchar*
geary_imap_db_message_row_get_bcc (GearyImapDBMessageRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), NULL);
	_tmp0_ = self->priv->_bcc;
	result = _tmp0_;
	return result;
}

void
geary_imap_db_message_row_set_bcc (GearyImapDBMessageRow* self,
                                   const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_bcc);
	self->priv->_bcc = _tmp0_;
}

const gchar*
geary_imap_db_message_row_get_message_id (GearyImapDBMessageRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), NULL);
	_tmp0_ = self->priv->_message_id;
	result = _tmp0_;
	return result;
}

void
geary_imap_db_message_row_set_message_id (GearyImapDBMessageRow* self,
                                          const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_message_id);
	self->priv->_message_id = _tmp0_;
}

const gchar*
geary_imap_db_message_row_get_in_reply_to (GearyImapDBMessageRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), NULL);
	_tmp0_ = self->priv->_in_reply_to;
	result = _tmp0_;
	return result;
}

void
geary_imap_db_message_row_set_in_reply_to (GearyImapDBMessageRow* self,
                                           const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_in_reply_to);
	self->priv->_in_reply_to = _tmp0_;
}

const gchar*
geary_imap_db_message_row_get_references (GearyImapDBMessageRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), NULL);
	_tmp0_ = self->priv->_references;
	result = _tmp0_;
	return result;
}

void
geary_imap_db_message_row_set_references (GearyImapDBMessageRow* self,
                                          const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_references);
	self->priv->_references = _tmp0_;
}

const gchar*
geary_imap_db_message_row_get_subject (GearyImapDBMessageRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), NULL);
	_tmp0_ = self->priv->_subject;
	result = _tmp0_;
	return result;
}

void
geary_imap_db_message_row_set_subject (GearyImapDBMessageRow* self,
                                       const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_subject);
	self->priv->_subject = _tmp0_;
}

GearyMemoryBuffer*
geary_imap_db_message_row_get_header (GearyImapDBMessageRow* self)
{
	GearyMemoryBuffer* result;
	GearyMemoryBuffer* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), NULL);
	_tmp0_ = self->priv->_header;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
geary_imap_db_message_row_set_header (GearyImapDBMessageRow* self,
                                      GearyMemoryBuffer* value)
{
	GearyMemoryBuffer* _tmp0_;
	g_return_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self));
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_header);
	self->priv->_header = _tmp0_;
}

GearyMemoryBuffer*
geary_imap_db_message_row_get_body (GearyImapDBMessageRow* self)
{
	GearyMemoryBuffer* result;
	GearyMemoryBuffer* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), NULL);
	_tmp0_ = self->priv->_body;
	result = _tmp0_;
	return result;
}

void
geary_imap_db_message_row_set_body (GearyImapDBMessageRow* self,
                                    GearyMemoryBuffer* value)
{
	GearyMemoryBuffer* _tmp0_;
	g_return_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self));
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_body);
	self->priv->_body = _tmp0_;
}

const gchar*
geary_imap_db_message_row_get_preview (GearyImapDBMessageRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), NULL);
	_tmp0_ = self->priv->_preview;
	result = _tmp0_;
	return result;
}

void
geary_imap_db_message_row_set_preview (GearyImapDBMessageRow* self,
                                       const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_preview);
	self->priv->_preview = _tmp0_;
}

const gchar*
geary_imap_db_message_row_get_email_flags (GearyImapDBMessageRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), NULL);
	_tmp0_ = self->priv->_email_flags;
	result = _tmp0_;
	return result;
}

void
geary_imap_db_message_row_set_email_flags (GearyImapDBMessageRow* self,
                                           const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_email_flags);
	self->priv->_email_flags = _tmp0_;
}

const gchar*
geary_imap_db_message_row_get_internaldate (GearyImapDBMessageRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), NULL);
	_tmp0_ = self->priv->_internaldate;
	result = _tmp0_;
	return result;
}

void
geary_imap_db_message_row_set_internaldate (GearyImapDBMessageRow* self,
                                            const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_internaldate);
	self->priv->_internaldate = _tmp0_;
}

gint64
geary_imap_db_message_row_get_internaldate_time_t (GearyImapDBMessageRow* self)
{
	gint64 result;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), 0LL);
	result = self->priv->_internaldate_time_t;
	return result;
}

void
geary_imap_db_message_row_set_internaldate_time_t (GearyImapDBMessageRow* self,
                                                   gint64 value)
{
	g_return_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self));
	self->priv->_internaldate_time_t = value;
}

gint64
geary_imap_db_message_row_get_rfc822_size (GearyImapDBMessageRow* self)
{
	gint64 result;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), 0LL);
	result = self->priv->_rfc822_size;
	return result;
}

void
geary_imap_db_message_row_set_rfc822_size (GearyImapDBMessageRow* self,
                                           gint64 value)
{
	g_return_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self));
	self->priv->_rfc822_size = value;
}

GearyImapDBMessageRow*
geary_imap_db_message_row_construct (GType object_type)
{
	GearyImapDBMessageRow* self = NULL;
	self = (GearyImapDBMessageRow*) g_type_create_instance (object_type);
	return self;
}

GearyImapDBMessageRow*
geary_imap_db_message_row_new (void)
{
	return geary_imap_db_message_row_construct (GEARY_IMAP_DB_TYPE_MESSAGE_ROW);
}

GearyImapDBMessageRow*
geary_imap_db_message_row_construct_from_email (GType object_type,
                                                GearyEmail* email)
{
	GearyImapDBMessageRow* self = NULL;
	g_return_val_if_fail (GEARY_IS_EMAIL (email), NULL);
	self = (GearyImapDBMessageRow*) g_type_create_instance (object_type);
	geary_imap_db_message_row_set_from_email (self, email);
	return self;
}

GearyImapDBMessageRow*
geary_imap_db_message_row_new_from_email (GearyEmail* email)
{
	return geary_imap_db_message_row_construct_from_email (GEARY_IMAP_DB_TYPE_MESSAGE_ROW, email);
}

GearyImapDBMessageRow*
geary_imap_db_message_row_construct_from_result (GType object_type,
                                                 GearyEmailField requested_fields,
                                                 GearyDbResult* results,
                                                 GError** error)
{
	GearyImapDBMessageRow* self = NULL;
	gint64 _tmp0_ = 0LL;
	gint _tmp1_ = 0;
	GearyEmailField _tmp2_;
	GearyEmailField _tmp6_;
	GearyEmailField _tmp13_;
	GearyEmailField _tmp20_;
	GearyEmailField _tmp27_;
	GearyEmailField _tmp30_;
	GearyEmailField _tmp33_;
	GearyEmailField _tmp36_;
	GearyEmailField _tmp39_;
	GearyEmailField _tmp42_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (GEARY_DB_IS_RESULT (results), NULL);
	self = (GearyImapDBMessageRow*) g_type_create_instance (object_type);
	_tmp0_ = geary_db_result_int64_for (results, "id", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_geary_imap_db_message_row_unref0 (self);
		return NULL;
	}
	geary_imap_db_message_row_set_id (self, _tmp0_);
	_tmp1_ = geary_db_result_int_for (results, "fields", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_geary_imap_db_message_row_unref0 (self);
		return NULL;
	}
	geary_imap_db_message_row_set_fields (self, requested_fields & _tmp1_);
	_tmp2_ = self->priv->_fields;
	if (geary_email_field_is_all_set (_tmp2_, GEARY_EMAIL_FIELD_DATE)) {
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_;
		gint64 _tmp5_ = 0LL;
		_tmp4_ = geary_db_result_string_for (results, "date_field", &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_geary_imap_db_message_row_unref0 (self);
			return NULL;
		}
		geary_imap_db_message_row_set_date (self, _tmp3_);
		_tmp5_ = geary_db_result_int64_for (results, "date_time_t", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_geary_imap_db_message_row_unref0 (self);
			return NULL;
		}
		geary_imap_db_message_row_set_date_time_t (self, _tmp5_);
	}
	_tmp6_ = self->priv->_fields;
	if (geary_email_field_is_all_set (_tmp6_, GEARY_EMAIL_FIELD_ORIGINATORS)) {
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_;
		_tmp8_ = geary_db_result_string_for (results, "from_field", &_inner_error0_);
		_tmp7_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_geary_imap_db_message_row_unref0 (self);
			return NULL;
		}
		geary_imap_db_message_row_set_from (self, _tmp7_);
		_tmp10_ = geary_db_result_string_for (results, "sender", &_inner_error0_);
		_tmp9_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_geary_imap_db_message_row_unref0 (self);
			return NULL;
		}
		geary_imap_db_message_row_set_sender (self, _tmp9_);
		_tmp12_ = geary_db_result_string_for (results, "reply_to", &_inner_error0_);
		_tmp11_ = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_geary_imap_db_message_row_unref0 (self);
			return NULL;
		}
		geary_imap_db_message_row_set_reply_to (self, _tmp11_);
	}
	_tmp13_ = self->priv->_fields;
	if (geary_email_field_is_all_set (_tmp13_, GEARY_EMAIL_FIELD_RECEIVERS)) {
		const gchar* _tmp14_ = NULL;
		const gchar* _tmp15_;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_;
		_tmp15_ = geary_db_result_string_for (results, "to_field", &_inner_error0_);
		_tmp14_ = _tmp15_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_geary_imap_db_message_row_unref0 (self);
			return NULL;
		}
		geary_imap_db_message_row_set_to (self, _tmp14_);
		_tmp17_ = geary_db_result_string_for (results, "cc", &_inner_error0_);
		_tmp16_ = _tmp17_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_geary_imap_db_message_row_unref0 (self);
			return NULL;
		}
		geary_imap_db_message_row_set_cc (self, _tmp16_);
		_tmp19_ = geary_db_result_string_for (results, "bcc", &_inner_error0_);
		_tmp18_ = _tmp19_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_geary_imap_db_message_row_unref0 (self);
			return NULL;
		}
		geary_imap_db_message_row_set_bcc (self, _tmp18_);
	}
	_tmp20_ = self->priv->_fields;
	if (geary_email_field_is_all_set (_tmp20_, GEARY_EMAIL_FIELD_REFERENCES)) {
		const gchar* _tmp21_ = NULL;
		const gchar* _tmp22_;
		const gchar* _tmp23_ = NULL;
		const gchar* _tmp24_;
		const gchar* _tmp25_ = NULL;
		const gchar* _tmp26_;
		_tmp22_ = geary_db_result_string_for (results, "message_id", &_inner_error0_);
		_tmp21_ = _tmp22_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_geary_imap_db_message_row_unref0 (self);
			return NULL;
		}
		geary_imap_db_message_row_set_message_id (self, _tmp21_);
		_tmp24_ = geary_db_result_string_for (results, "in_reply_to", &_inner_error0_);
		_tmp23_ = _tmp24_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_geary_imap_db_message_row_unref0 (self);
			return NULL;
		}
		geary_imap_db_message_row_set_in_reply_to (self, _tmp23_);
		_tmp26_ = geary_db_result_string_for (results, "reference_ids", &_inner_error0_);
		_tmp25_ = _tmp26_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_geary_imap_db_message_row_unref0 (self);
			return NULL;
		}
		geary_imap_db_message_row_set_references (self, _tmp25_);
	}
	_tmp27_ = self->priv->_fields;
	if (geary_email_field_is_all_set (_tmp27_, GEARY_EMAIL_FIELD_SUBJECT)) {
		const gchar* _tmp28_ = NULL;
		const gchar* _tmp29_;
		_tmp29_ = geary_db_result_string_for (results, "subject", &_inner_error0_);
		_tmp28_ = _tmp29_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_geary_imap_db_message_row_unref0 (self);
			return NULL;
		}
		geary_imap_db_message_row_set_subject (self, _tmp28_);
	}
	_tmp30_ = self->priv->_fields;
	if (geary_email_field_is_all_set (_tmp30_, GEARY_EMAIL_FIELD_HEADER)) {
		GearyMemoryBuffer* _tmp31_ = NULL;
		GearyMemoryBuffer* _tmp32_;
		_tmp32_ = geary_db_result_string_buffer_for (results, "header", &_inner_error0_);
		_tmp31_ = _tmp32_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_geary_imap_db_message_row_unref0 (self);
			return NULL;
		}
		geary_imap_db_message_row_set_header (self, _tmp31_);
		_g_object_unref0 (_tmp31_);
	}
	_tmp33_ = self->priv->_fields;
	if (geary_email_field_is_all_set (_tmp33_, GEARY_EMAIL_FIELD_BODY)) {
		GearyMemoryBuffer* _tmp34_ = NULL;
		GearyMemoryBuffer* _tmp35_;
		_tmp35_ = geary_db_result_string_buffer_for (results, "body", &_inner_error0_);
		_tmp34_ = _tmp35_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_geary_imap_db_message_row_unref0 (self);
			return NULL;
		}
		geary_imap_db_message_row_set_body (self, _tmp34_);
		_g_object_unref0 (_tmp34_);
	}
	_tmp36_ = self->priv->_fields;
	if (geary_email_field_is_all_set (_tmp36_, GEARY_EMAIL_FIELD_PREVIEW)) {
		const gchar* _tmp37_ = NULL;
		const gchar* _tmp38_;
		_tmp38_ = geary_db_result_string_for (results, "preview", &_inner_error0_);
		_tmp37_ = _tmp38_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_geary_imap_db_message_row_unref0 (self);
			return NULL;
		}
		geary_imap_db_message_row_set_preview (self, _tmp37_);
	}
	_tmp39_ = self->priv->_fields;
	if (geary_email_field_is_all_set (_tmp39_, GEARY_EMAIL_FIELD_FLAGS)) {
		const gchar* _tmp40_ = NULL;
		const gchar* _tmp41_;
		_tmp41_ = geary_db_result_string_for (results, "flags", &_inner_error0_);
		_tmp40_ = _tmp41_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_geary_imap_db_message_row_unref0 (self);
			return NULL;
		}
		geary_imap_db_message_row_set_email_flags (self, _tmp40_);
	}
	_tmp42_ = self->priv->_fields;
	if (geary_email_field_is_all_set (_tmp42_, GEARY_EMAIL_FIELD_PROPERTIES)) {
		const gchar* _tmp43_ = NULL;
		const gchar* _tmp44_;
		gint64 _tmp45_ = 0LL;
		gint64 _tmp46_ = 0LL;
		_tmp44_ = geary_db_result_string_for (results, "internaldate", &_inner_error0_);
		_tmp43_ = _tmp44_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_geary_imap_db_message_row_unref0 (self);
			return NULL;
		}
		geary_imap_db_message_row_set_internaldate (self, _tmp43_);
		_tmp45_ = geary_db_result_int64_for (results, "internaldate_time_t", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_geary_imap_db_message_row_unref0 (self);
			return NULL;
		}
		geary_imap_db_message_row_set_internaldate_time_t (self, _tmp45_);
		_tmp46_ = geary_db_result_int64_for (results, "rfc822_size", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_geary_imap_db_message_row_unref0 (self);
			return NULL;
		}
		geary_imap_db_message_row_set_rfc822_size (self, _tmp46_);
	}
	return self;
}

GearyImapDBMessageRow*
geary_imap_db_message_row_new_from_result (GearyEmailField requested_fields,
                                           GearyDbResult* results,
                                           GError** error)
{
	return geary_imap_db_message_row_construct_from_result (GEARY_IMAP_DB_TYPE_MESSAGE_ROW, requested_fields, results, error);
}

GearyEmail*
geary_imap_db_message_row_to_email (GearyImapDBMessageRow* self,
                                    GearyImapDBEmailIdentifier* id,
                                    GError** error)
{
	GearyEmail* email = NULL;
	GearyEmail* _tmp0_;
	GearyEmailField _tmp1_;
	GearyEmailField _tmp6_;
	GearyEmailField _tmp17_;
	GearyEmailField _tmp28_;
	GearyEmailField _tmp39_;
	GearyEmailField _tmp45_;
	GearyEmailField _tmp53_;
	GearyEmailField _tmp61_;
	GearyEmailField _tmp69_;
	GearyEmailField _tmp73_;
	GError* _inner_error0_ = NULL;
	GearyEmail* result;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), NULL);
	g_return_val_if_fail (GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER (id), NULL);
	_tmp0_ = geary_email_new (G_TYPE_CHECK_INSTANCE_CAST (id, GEARY_TYPE_EMAIL_IDENTIFIER, GearyEmailIdentifier));
	email = _tmp0_;
	_tmp1_ = self->priv->_fields;
	if (geary_email_field_is_all_set (_tmp1_, GEARY_EMAIL_FIELD_DATE)) {
		GearyEmail* _tmp2_;
		const gchar* _tmp3_;
		GearyRFC822Date* _tmp4_;
		GearyRFC822Date* _tmp5_;
		_tmp2_ = email;
		_tmp3_ = self->priv->_date;
		_tmp4_ = geary_imap_db_message_row_unflatten_date (self, _tmp3_);
		_tmp5_ = _tmp4_;
		geary_email_set_send_date (_tmp2_, _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
	_tmp6_ = self->priv->_fields;
	if (geary_email_field_is_all_set (_tmp6_, GEARY_EMAIL_FIELD_ORIGINATORS)) {
		GearyEmail* _tmp7_;
		const gchar* _tmp8_;
		GearyRFC822MailboxAddresses* _tmp9_;
		GearyRFC822MailboxAddresses* _tmp10_;
		const gchar* _tmp11_;
		GearyRFC822MailboxAddress* _tmp12_;
		GearyRFC822MailboxAddress* _tmp13_;
		const gchar* _tmp14_;
		GearyRFC822MailboxAddresses* _tmp15_;
		GearyRFC822MailboxAddresses* _tmp16_;
		_tmp7_ = email;
		_tmp8_ = self->priv->_from;
		_tmp9_ = geary_imap_db_message_row_unflatten_addresses (self, _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = self->priv->_sender;
		_tmp12_ = geary_imap_db_message_row_unflatten_address (self, _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = self->priv->_reply_to;
		_tmp15_ = geary_imap_db_message_row_unflatten_addresses (self, _tmp14_);
		_tmp16_ = _tmp15_;
		geary_email_set_originators (_tmp7_, _tmp10_, _tmp13_, _tmp16_, &_inner_error0_);
		_g_object_unref0 (_tmp16_);
		_g_object_unref0 (_tmp13_);
		_g_object_unref0 (_tmp10_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (email);
			return NULL;
		}
	}
	_tmp17_ = self->priv->_fields;
	if (geary_email_field_is_all_set (_tmp17_, GEARY_EMAIL_FIELD_RECEIVERS)) {
		GearyEmail* _tmp18_;
		const gchar* _tmp19_;
		GearyRFC822MailboxAddresses* _tmp20_;
		GearyRFC822MailboxAddresses* _tmp21_;
		const gchar* _tmp22_;
		GearyRFC822MailboxAddresses* _tmp23_;
		GearyRFC822MailboxAddresses* _tmp24_;
		const gchar* _tmp25_;
		GearyRFC822MailboxAddresses* _tmp26_;
		GearyRFC822MailboxAddresses* _tmp27_;
		_tmp18_ = email;
		_tmp19_ = self->priv->_to;
		_tmp20_ = geary_imap_db_message_row_unflatten_addresses (self, _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = self->priv->_cc;
		_tmp23_ = geary_imap_db_message_row_unflatten_addresses (self, _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = self->priv->_bcc;
		_tmp26_ = geary_imap_db_message_row_unflatten_addresses (self, _tmp25_);
		_tmp27_ = _tmp26_;
		geary_email_set_receivers (_tmp18_, _tmp21_, _tmp24_, _tmp27_);
		_g_object_unref0 (_tmp27_);
		_g_object_unref0 (_tmp24_);
		_g_object_unref0 (_tmp21_);
	}
	_tmp28_ = self->priv->_fields;
	if (geary_email_field_is_all_set (_tmp28_, GEARY_EMAIL_FIELD_REFERENCES)) {
		GearyEmail* _tmp29_;
		const gchar* _tmp30_;
		GearyRFC822MessageID* _tmp31_;
		GearyRFC822MessageID* _tmp32_;
		const gchar* _tmp33_;
		GearyRFC822MessageIDList* _tmp34_;
		GearyRFC822MessageIDList* _tmp35_;
		const gchar* _tmp36_;
		GearyRFC822MessageIDList* _tmp37_;
		GearyRFC822MessageIDList* _tmp38_;
		_tmp29_ = email;
		_tmp30_ = self->priv->_message_id;
		_tmp31_ = geary_imap_db_message_row_unflatten_message_id (self, _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = self->priv->_in_reply_to;
		_tmp34_ = geary_imap_db_message_row_unflatten_message_id_list (self, _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = self->priv->_references;
		_tmp37_ = geary_imap_db_message_row_unflatten_message_id_list (self, _tmp36_);
		_tmp38_ = _tmp37_;
		geary_email_set_full_references (_tmp29_, _tmp32_, _tmp35_, _tmp38_);
		_g_object_unref0 (_tmp38_);
		_g_object_unref0 (_tmp35_);
		_g_object_unref0 (_tmp32_);
	}
	_tmp39_ = self->priv->_fields;
	if (geary_email_field_is_all_set (_tmp39_, GEARY_EMAIL_FIELD_SUBJECT)) {
		const gchar* _tmp40_ = NULL;
		const gchar* _tmp41_;
		GearyEmail* _tmp42_;
		GearyRFC822Subject* _tmp43_;
		GearyRFC822Subject* _tmp44_;
		_tmp41_ = self->priv->_subject;
		_tmp40_ = _tmp41_;
		if (_tmp40_ == NULL) {
			_tmp40_ = "";
		}
		_tmp42_ = email;
		_tmp43_ = geary_rf_c822_subject_new_from_rfc822_string (_tmp40_);
		_tmp44_ = _tmp43_;
		geary_email_set_message_subject (_tmp42_, _tmp44_);
		_g_object_unref0 (_tmp44_);
	}
	_tmp45_ = self->priv->_fields;
	if (geary_email_field_is_all_set (_tmp45_, GEARY_EMAIL_FIELD_HEADER)) {
		GearyMemoryBuffer* _tmp46_ = NULL;
		GearyMemoryBuffer* _tmp47_;
		GearyRFC822Header* _tmp50_ = NULL;
		GearyRFC822Header* _tmp51_;
		GearyEmail* _tmp52_;
		_tmp47_ = self->priv->_header;
		_tmp46_ = _tmp47_;
		if (_tmp46_ == NULL) {
			GearyMemoryEmptyBuffer* _tmp48_;
			GearyMemoryEmptyBuffer* _tmp49_;
			_tmp48_ = geary_memory_empty_buffer_get_instance ();
			_tmp49_ = _tmp48_;
			_tmp46_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer);
		}
		_tmp51_ = geary_rf_c822_header_new (_tmp46_, &_inner_error0_);
		_tmp50_ = _tmp51_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (email);
			return NULL;
		}
		_tmp52_ = email;
		geary_email_set_message_header (_tmp52_, _tmp50_);
		_g_object_unref0 (_tmp50_);
	}
	_tmp53_ = self->priv->_fields;
	if (geary_email_field_is_all_set (_tmp53_, GEARY_EMAIL_FIELD_BODY)) {
		GearyMemoryBuffer* _tmp54_ = NULL;
		GearyMemoryBuffer* _tmp55_;
		GearyEmail* _tmp58_;
		GearyRFC822Text* _tmp59_;
		GearyRFC822Text* _tmp60_;
		_tmp55_ = self->priv->_body;
		_tmp54_ = _tmp55_;
		if (_tmp54_ == NULL) {
			GearyMemoryEmptyBuffer* _tmp56_;
			GearyMemoryEmptyBuffer* _tmp57_;
			_tmp56_ = geary_memory_empty_buffer_get_instance ();
			_tmp57_ = _tmp56_;
			_tmp54_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer);
		}
		_tmp58_ = email;
		_tmp59_ = geary_rf_c822_text_new (_tmp54_);
		_tmp60_ = _tmp59_;
		geary_email_set_message_body (_tmp58_, _tmp60_);
		_g_object_unref0 (_tmp60_);
	}
	_tmp61_ = self->priv->_fields;
	if (geary_email_field_is_all_set (_tmp61_, GEARY_EMAIL_FIELD_PREVIEW)) {
		const gchar* _tmp62_ = NULL;
		const gchar* _tmp63_;
		GearyEmail* _tmp64_;
		GearyMemoryStringBuffer* _tmp65_;
		GearyMemoryStringBuffer* _tmp66_;
		GearyRFC822PreviewText* _tmp67_;
		GearyRFC822PreviewText* _tmp68_;
		_tmp63_ = self->priv->_preview;
		_tmp62_ = _tmp63_;
		if (_tmp62_ == NULL) {
			_tmp62_ = "";
		}
		_tmp64_ = email;
		_tmp65_ = geary_memory_string_buffer_new (_tmp62_);
		_tmp66_ = _tmp65_;
		_tmp67_ = geary_rf_c822_preview_text_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer));
		_tmp68_ = _tmp67_;
		geary_email_set_message_preview (_tmp64_, _tmp68_);
		_g_object_unref0 (_tmp68_);
		_g_object_unref0 (_tmp66_);
	}
	_tmp69_ = self->priv->_fields;
	if (geary_email_field_is_all_set (_tmp69_, GEARY_EMAIL_FIELD_FLAGS)) {
		GearyEmail* _tmp70_;
		GearyEmailFlags* _tmp71_;
		GearyEmailFlags* _tmp72_;
		_tmp70_ = email;
		_tmp71_ = geary_imap_db_message_row_get_generic_email_flags (self);
		_tmp72_ = _tmp71_;
		geary_email_set_flags (_tmp70_, _tmp72_);
		_g_object_unref0 (_tmp72_);
	}
	_tmp73_ = self->priv->_fields;
	if (geary_email_field_is_all_set (_tmp73_, GEARY_EMAIL_FIELD_PROPERTIES)) {
		GearyImapEmailProperties* properties = NULL;
		GearyImapEmailProperties* _tmp74_;
		GearyImapEmailProperties* _tmp75_;
		_tmp74_ = geary_imap_db_message_row_get_imap_email_properties (self);
		properties = _tmp74_;
		_tmp75_ = properties;
		if (_tmp75_ != NULL) {
			GearyEmail* _tmp76_;
			GearyImapEmailProperties* _tmp77_;
			_tmp76_ = email;
			_tmp77_ = properties;
			geary_email_set_email_properties (_tmp76_, G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, GEARY_TYPE_EMAIL_PROPERTIES, GearyEmailProperties));
		}
		_g_object_unref0 (properties);
	}
	result = email;
	return result;
}

GearyImapEmailProperties*
geary_imap_db_message_row_get_imap_email_properties (GearyImapDBMessageRow* self)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	GearyImapInternalDate* constructed = NULL;
	GearyImapInternalDate* _tmp10_;
	gint64 _tmp11_;
	GearyImapRFC822Size* _tmp12_;
	GearyImapRFC822Size* _tmp13_;
	GearyImapEmailProperties* _tmp14_;
	GearyImapEmailProperties* _tmp15_;
	GError* _inner_error0_ = NULL;
	GearyImapEmailProperties* result;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), NULL);
	_tmp1_ = self->priv->_internaldate;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gint64 _tmp2_;
		_tmp2_ = self->priv->_rfc822_size;
		_tmp0_ = _tmp2_ < ((gint64) 0);
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	constructed = NULL;
	{
		GearyImapInternalDate* _tmp3_ = NULL;
		const gchar* _tmp4_;
		GearyImapInternalDate* _tmp5_;
		GearyImapInternalDate* _tmp6_;
		_tmp4_ = self->priv->_internaldate;
		_tmp5_ = geary_imap_internal_date_decode (_tmp4_, &_inner_error0_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp3_;
		_tmp3_ = NULL;
		_g_object_unref0 (constructed);
		constructed = _tmp6_;
		_g_object_unref0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = self->priv->_internaldate;
		_tmp8_ = err;
		_tmp9_ = _tmp8_->message;
		g_debug ("imap-db-message-row.vala:163: Unable to construct internaldate object " \
"from \"%s\": %s", _tmp7_, _tmp9_);
		result = NULL;
		_g_error_free0 (err);
		_g_object_unref0 (constructed);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (constructed);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp10_ = constructed;
	_tmp11_ = self->priv->_rfc822_size;
	_tmp12_ = geary_imap_rf_c822_size_new (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = geary_imap_email_properties_new (_tmp10_, _tmp13_);
	_tmp15_ = _tmp14_;
	_g_object_unref0 (_tmp13_);
	result = _tmp15_;
	_g_object_unref0 (constructed);
	return result;
}

GearyEmailFlags*
geary_imap_db_message_row_get_generic_email_flags (GearyImapDBMessageRow* self)
{
	GearyImapEmailFlags* _tmp0_ = NULL;
	const gchar* _tmp1_;
	GearyEmailFlags* result;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), NULL);
	_tmp1_ = self->priv->_email_flags;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		GearyImapMessageFlags* _tmp3_;
		GearyImapMessageFlags* _tmp4_;
		GearyImapEmailFlags* _tmp5_;
		_tmp2_ = self->priv->_email_flags;
		_tmp3_ = geary_imap_message_flags_deserialize (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = geary_imap_email_flags_new (_tmp4_);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
	} else {
		_g_object_unref0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_TYPE_EMAIL_FLAGS, GearyEmailFlags);
	return result;
}

void
geary_imap_db_message_row_merge_from_remote (GearyImapDBMessageRow* self,
                                             GearyEmail* email)
{
	g_return_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self));
	g_return_if_fail (GEARY_IS_EMAIL (email));
	geary_imap_db_message_row_set_from_email (self, email);
}

static void
geary_imap_db_message_row_set_from_email (GearyImapDBMessageRow* self,
                                          GearyEmail* email)
{
	GearyEmailField _tmp0_;
	GearyEmailField _tmp1_;
	GearyEmailField _tmp16_;
	GearyEmailField _tmp17_;
	GearyEmailField _tmp31_;
	GearyEmailField _tmp32_;
	GearyEmailField _tmp46_;
	GearyEmailField _tmp47_;
	GearyEmailField _tmp67_;
	GearyEmailField _tmp68_;
	GearyEmailField _tmp76_;
	GearyEmailField _tmp77_;
	GearyEmailField _tmp86_;
	GearyEmailField _tmp87_;
	GearyEmailField _tmp96_;
	GearyEmailField _tmp97_;
	GearyEmailField _tmp107_;
	GearyEmailField _tmp108_;
	GearyEmailField _tmp119_;
	GearyEmailField _tmp120_;
	g_return_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self));
	g_return_if_fail (GEARY_IS_EMAIL (email));
	_tmp0_ = geary_email_get_fields (email);
	_tmp1_ = _tmp0_;
	if (geary_email_field_is_all_set (_tmp1_, GEARY_EMAIL_FIELD_DATE)) {
		gchar* _tmp2_ = NULL;
		GearyRFC822Date* _tmp3_;
		GearyRFC822Date* _tmp4_;
		gint64 _tmp8_ = 0LL;
		GearyRFC822Date* _tmp9_;
		GearyRFC822Date* _tmp10_;
		GearyEmailField _tmp15_;
		_tmp3_ = geary_email_header_set_get_date (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			GearyRFC822Date* _tmp5_;
			GearyRFC822Date* _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = geary_email_header_set_get_date (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
			_tmp6_ = _tmp5_;
			_tmp7_ = geary_rf_c822_decoded_message_data_to_rfc822_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, GearyRFC822DecodedMessageData));
			_g_free0 (_tmp2_);
			_tmp2_ = _tmp7_;
		} else {
			_g_free0 (_tmp2_);
			_tmp2_ = NULL;
		}
		geary_imap_db_message_row_set_date (self, _tmp2_);
		_tmp9_ = geary_email_header_set_get_date (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp10_ = _tmp9_;
		if (_tmp10_ != NULL) {
			GearyRFC822Date* _tmp11_;
			GearyRFC822Date* _tmp12_;
			GDateTime* _tmp13_;
			GDateTime* _tmp14_;
			_tmp11_ = geary_email_header_set_get_date (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
			_tmp12_ = _tmp11_;
			_tmp13_ = geary_rf_c822_date_get_value (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp8_ = g_date_time_to_unix (_tmp14_);
		} else {
			_tmp8_ = (gint64) -1;
		}
		geary_imap_db_message_row_set_date_time_t (self, _tmp8_);
		_tmp15_ = self->priv->_fields;
		geary_imap_db_message_row_set_fields (self, geary_email_field_set (_tmp15_, GEARY_EMAIL_FIELD_DATE));
		_g_free0 (_tmp2_);
	}
	_tmp16_ = geary_email_get_fields (email);
	_tmp17_ = _tmp16_;
	if (geary_email_field_is_all_set (_tmp17_, GEARY_EMAIL_FIELD_ORIGINATORS)) {
		GearyRFC822MailboxAddresses* _tmp18_;
		GearyRFC822MailboxAddresses* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		GearyRFC822MailboxAddress* _tmp22_;
		GearyRFC822MailboxAddress* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		GearyRFC822MailboxAddresses* _tmp26_;
		GearyRFC822MailboxAddresses* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		GearyEmailField _tmp30_;
		_tmp18_ = geary_email_header_set_get_from (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp19_ = _tmp18_;
		_tmp20_ = geary_imap_db_message_row_flatten_addresses (_tmp19_);
		_tmp21_ = _tmp20_;
		geary_imap_db_message_row_set_from (self, _tmp21_);
		_g_free0 (_tmp21_);
		_tmp22_ = geary_email_header_set_get_sender (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp23_ = _tmp22_;
		_tmp24_ = geary_imap_db_message_row_flatten_address (_tmp23_);
		_tmp25_ = _tmp24_;
		geary_imap_db_message_row_set_sender (self, _tmp25_);
		_g_free0 (_tmp25_);
		_tmp26_ = geary_email_header_set_get_reply_to (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp27_ = _tmp26_;
		_tmp28_ = geary_imap_db_message_row_flatten_addresses (_tmp27_);
		_tmp29_ = _tmp28_;
		geary_imap_db_message_row_set_reply_to (self, _tmp29_);
		_g_free0 (_tmp29_);
		_tmp30_ = self->priv->_fields;
		geary_imap_db_message_row_set_fields (self, geary_email_field_set (_tmp30_, GEARY_EMAIL_FIELD_ORIGINATORS));
	}
	_tmp31_ = geary_email_get_fields (email);
	_tmp32_ = _tmp31_;
	if (geary_email_field_is_all_set (_tmp32_, GEARY_EMAIL_FIELD_RECEIVERS)) {
		GearyRFC822MailboxAddresses* _tmp33_;
		GearyRFC822MailboxAddresses* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		GearyRFC822MailboxAddresses* _tmp37_;
		GearyRFC822MailboxAddresses* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		GearyRFC822MailboxAddresses* _tmp41_;
		GearyRFC822MailboxAddresses* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		GearyEmailField _tmp45_;
		_tmp33_ = geary_email_header_set_get_to (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp34_ = _tmp33_;
		_tmp35_ = geary_imap_db_message_row_flatten_addresses (_tmp34_);
		_tmp36_ = _tmp35_;
		geary_imap_db_message_row_set_to (self, _tmp36_);
		_g_free0 (_tmp36_);
		_tmp37_ = geary_email_header_set_get_cc (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp38_ = _tmp37_;
		_tmp39_ = geary_imap_db_message_row_flatten_addresses (_tmp38_);
		_tmp40_ = _tmp39_;
		geary_imap_db_message_row_set_cc (self, _tmp40_);
		_g_free0 (_tmp40_);
		_tmp41_ = geary_email_header_set_get_bcc (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp42_ = _tmp41_;
		_tmp43_ = geary_imap_db_message_row_flatten_addresses (_tmp42_);
		_tmp44_ = _tmp43_;
		geary_imap_db_message_row_set_bcc (self, _tmp44_);
		_g_free0 (_tmp44_);
		_tmp45_ = self->priv->_fields;
		geary_imap_db_message_row_set_fields (self, geary_email_field_set (_tmp45_, GEARY_EMAIL_FIELD_RECEIVERS));
	}
	_tmp46_ = geary_email_get_fields (email);
	_tmp47_ = _tmp46_;
	if (geary_email_field_is_all_set (_tmp47_, GEARY_EMAIL_FIELD_REFERENCES)) {
		gchar* _tmp48_ = NULL;
		GearyRFC822MessageID* _tmp49_;
		GearyRFC822MessageID* _tmp50_;
		gchar* _tmp54_ = NULL;
		GearyRFC822MessageIDList* _tmp55_;
		GearyRFC822MessageIDList* _tmp56_;
		gchar* _tmp60_ = NULL;
		GearyRFC822MessageIDList* _tmp61_;
		GearyRFC822MessageIDList* _tmp62_;
		GearyEmailField _tmp66_;
		_tmp49_ = geary_email_header_set_get_message_id (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp50_ = _tmp49_;
		if (_tmp50_ != NULL) {
			GearyRFC822MessageID* _tmp51_;
			GearyRFC822MessageID* _tmp52_;
			gchar* _tmp53_;
			_tmp51_ = geary_email_header_set_get_message_id (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
			_tmp52_ = _tmp51_;
			_tmp53_ = geary_rf_c822_decoded_message_data_to_rfc822_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, GearyRFC822DecodedMessageData));
			_g_free0 (_tmp48_);
			_tmp48_ = _tmp53_;
		} else {
			_g_free0 (_tmp48_);
			_tmp48_ = NULL;
		}
		geary_imap_db_message_row_set_message_id (self, _tmp48_);
		_tmp55_ = geary_email_header_set_get_in_reply_to (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp56_ = _tmp55_;
		if (_tmp56_ != NULL) {
			GearyRFC822MessageIDList* _tmp57_;
			GearyRFC822MessageIDList* _tmp58_;
			gchar* _tmp59_;
			_tmp57_ = geary_email_header_set_get_in_reply_to (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
			_tmp58_ = _tmp57_;
			_tmp59_ = geary_rf_c822_decoded_message_data_to_rfc822_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, GearyRFC822DecodedMessageData));
			_g_free0 (_tmp54_);
			_tmp54_ = _tmp59_;
		} else {
			_g_free0 (_tmp54_);
			_tmp54_ = NULL;
		}
		geary_imap_db_message_row_set_in_reply_to (self, _tmp54_);
		_tmp61_ = geary_email_header_set_get_references (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp62_ = _tmp61_;
		if (_tmp62_ != NULL) {
			GearyRFC822MessageIDList* _tmp63_;
			GearyRFC822MessageIDList* _tmp64_;
			gchar* _tmp65_;
			_tmp63_ = geary_email_header_set_get_references (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
			_tmp64_ = _tmp63_;
			_tmp65_ = geary_rf_c822_decoded_message_data_to_rfc822_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, GearyRFC822DecodedMessageData));
			_g_free0 (_tmp60_);
			_tmp60_ = _tmp65_;
		} else {
			_g_free0 (_tmp60_);
			_tmp60_ = NULL;
		}
		geary_imap_db_message_row_set_references (self, _tmp60_);
		_tmp66_ = self->priv->_fields;
		geary_imap_db_message_row_set_fields (self, geary_email_field_set (_tmp66_, GEARY_EMAIL_FIELD_REFERENCES));
		_g_free0 (_tmp60_);
		_g_free0 (_tmp54_);
		_g_free0 (_tmp48_);
	}
	_tmp67_ = geary_email_get_fields (email);
	_tmp68_ = _tmp67_;
	if (geary_email_field_is_all_set (_tmp68_, GEARY_EMAIL_FIELD_SUBJECT)) {
		gchar* _tmp69_ = NULL;
		GearyRFC822Subject* _tmp70_;
		GearyRFC822Subject* _tmp71_;
		GearyEmailField _tmp75_;
		_tmp70_ = geary_email_header_set_get_subject (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
		_tmp71_ = _tmp70_;
		if (_tmp71_ != NULL) {
			GearyRFC822Subject* _tmp72_;
			GearyRFC822Subject* _tmp73_;
			gchar* _tmp74_;
			_tmp72_ = geary_email_header_set_get_subject (G_TYPE_CHECK_INSTANCE_CAST (email, GEARY_TYPE_EMAIL_HEADER_SET, GearyEmailHeaderSet));
			_tmp73_ = _tmp72_;
			_tmp74_ = geary_rf_c822_decoded_message_data_to_rfc822_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, GearyRFC822DecodedMessageData));
			_g_free0 (_tmp69_);
			_tmp69_ = _tmp74_;
		} else {
			_g_free0 (_tmp69_);
			_tmp69_ = NULL;
		}
		geary_imap_db_message_row_set_subject (self, _tmp69_);
		_tmp75_ = self->priv->_fields;
		geary_imap_db_message_row_set_fields (self, geary_email_field_set (_tmp75_, GEARY_EMAIL_FIELD_SUBJECT));
		_g_free0 (_tmp69_);
	}
	_tmp76_ = geary_email_get_fields (email);
	_tmp77_ = _tmp76_;
	if (geary_email_field_is_all_set (_tmp77_, GEARY_EMAIL_FIELD_HEADER)) {
		GearyMemoryBuffer* _tmp78_ = NULL;
		GearyRFC822Header* _tmp79_;
		GearyRFC822Header* _tmp80_;
		GearyEmailField _tmp85_;
		_tmp79_ = geary_email_get_header (email);
		_tmp80_ = _tmp79_;
		if (_tmp80_ != NULL) {
			GearyRFC822Header* _tmp81_;
			GearyRFC822Header* _tmp82_;
			GearyMemoryBuffer* _tmp83_;
			GearyMemoryBuffer* _tmp84_;
			_tmp81_ = geary_email_get_header (email);
			_tmp82_ = _tmp81_;
			_tmp83_ = geary_message_data_block_message_data_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, GEARY_MESSAGE_DATA_TYPE_BLOCK_MESSAGE_DATA, GearyMessageDataBlockMessageData));
			_tmp84_ = _tmp83_;
			_tmp78_ = _tmp84_;
		} else {
			_tmp78_ = NULL;
		}
		geary_imap_db_message_row_set_header (self, _tmp78_);
		_tmp85_ = self->priv->_fields;
		geary_imap_db_message_row_set_fields (self, geary_email_field_set (_tmp85_, GEARY_EMAIL_FIELD_HEADER));
	}
	_tmp86_ = geary_email_get_fields (email);
	_tmp87_ = _tmp86_;
	if (geary_email_field_is_all_set (_tmp87_, GEARY_EMAIL_FIELD_BODY)) {
		GearyMemoryBuffer* _tmp88_ = NULL;
		GearyRFC822Text* _tmp89_;
		GearyRFC822Text* _tmp90_;
		GearyEmailField _tmp95_;
		_tmp89_ = geary_email_get_body (email);
		_tmp90_ = _tmp89_;
		if (_tmp90_ != NULL) {
			GearyRFC822Text* _tmp91_;
			GearyRFC822Text* _tmp92_;
			GearyMemoryBuffer* _tmp93_;
			GearyMemoryBuffer* _tmp94_;
			_tmp91_ = geary_email_get_body (email);
			_tmp92_ = _tmp91_;
			_tmp93_ = geary_message_data_block_message_data_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp92_, GEARY_MESSAGE_DATA_TYPE_BLOCK_MESSAGE_DATA, GearyMessageDataBlockMessageData));
			_tmp94_ = _tmp93_;
			_tmp88_ = _tmp94_;
		} else {
			_tmp88_ = NULL;
		}
		geary_imap_db_message_row_set_body (self, _tmp88_);
		_tmp95_ = self->priv->_fields;
		geary_imap_db_message_row_set_fields (self, geary_email_field_set (_tmp95_, GEARY_EMAIL_FIELD_BODY));
	}
	_tmp96_ = geary_email_get_fields (email);
	_tmp97_ = _tmp96_;
	if (geary_email_field_is_all_set (_tmp97_, GEARY_EMAIL_FIELD_PREVIEW)) {
		gchar* _tmp98_ = NULL;
		GearyRFC822PreviewText* _tmp99_;
		GearyRFC822PreviewText* _tmp100_;
		GearyEmailField _tmp106_;
		_tmp99_ = geary_email_get_preview (email);
		_tmp100_ = _tmp99_;
		if (_tmp100_ != NULL) {
			GearyRFC822PreviewText* _tmp101_;
			GearyRFC822PreviewText* _tmp102_;
			GearyMemoryBuffer* _tmp103_;
			GearyMemoryBuffer* _tmp104_;
			gchar* _tmp105_;
			_tmp101_ = geary_email_get_preview (email);
			_tmp102_ = _tmp101_;
			_tmp103_ = geary_message_data_block_message_data_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, GEARY_MESSAGE_DATA_TYPE_BLOCK_MESSAGE_DATA, GearyMessageDataBlockMessageData));
			_tmp104_ = _tmp103_;
			_tmp105_ = geary_memory_buffer_to_string (_tmp104_);
			_g_free0 (_tmp98_);
			_tmp98_ = _tmp105_;
		} else {
			_g_free0 (_tmp98_);
			_tmp98_ = NULL;
		}
		geary_imap_db_message_row_set_preview (self, _tmp98_);
		_tmp106_ = self->priv->_fields;
		geary_imap_db_message_row_set_fields (self, geary_email_field_set (_tmp106_, GEARY_EMAIL_FIELD_PREVIEW));
		_g_free0 (_tmp98_);
	}
	_tmp107_ = geary_email_get_fields (email);
	_tmp108_ = _tmp107_;
	if (geary_email_field_is_all_set (_tmp108_, GEARY_EMAIL_FIELD_FLAGS)) {
		GearyImapEmailFlags* imap_flags = NULL;
		GearyEmailFlags* _tmp109_;
		GearyEmailFlags* _tmp110_;
		GearyImapEmailFlags* _tmp111_;
		gchar* _tmp112_ = NULL;
		GearyImapEmailFlags* _tmp113_;
		GearyEmailField _tmp118_;
		_tmp109_ = geary_email_get_email_flags (email);
		_tmp110_ = _tmp109_;
		_tmp111_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp110_, GEARY_IMAP_TYPE_EMAIL_FLAGS, GearyImapEmailFlags));
		imap_flags = _tmp111_;
		_tmp113_ = imap_flags;
		if (_tmp113_ != NULL) {
			GearyImapEmailFlags* _tmp114_;
			GearyImapMessageFlags* _tmp115_;
			GearyImapMessageFlags* _tmp116_;
			gchar* _tmp117_;
			_tmp114_ = imap_flags;
			_tmp115_ = geary_imap_email_flags_get_message_flags (_tmp114_);
			_tmp116_ = _tmp115_;
			_tmp117_ = geary_imap_flags_serialize (G_TYPE_CHECK_INSTANCE_CAST (_tmp116_, GEARY_IMAP_TYPE_FLAGS, GearyImapFlags));
			_g_free0 (_tmp112_);
			_tmp112_ = _tmp117_;
		} else {
			_g_free0 (_tmp112_);
			_tmp112_ = NULL;
		}
		geary_imap_db_message_row_set_email_flags (self, _tmp112_);
		_tmp118_ = self->priv->_fields;
		geary_imap_db_message_row_set_fields (self, geary_email_field_set (_tmp118_, GEARY_EMAIL_FIELD_FLAGS));
		_g_free0 (_tmp112_);
		_g_object_unref0 (imap_flags);
	}
	_tmp119_ = geary_email_get_fields (email);
	_tmp120_ = _tmp119_;
	if (geary_email_field_is_all_set (_tmp120_, GEARY_EMAIL_FIELD_PROPERTIES)) {
		GearyImapEmailProperties* imap_properties = NULL;
		GearyEmailProperties* _tmp121_;
		GearyEmailProperties* _tmp122_;
		GearyImapEmailProperties* _tmp123_;
		gchar* _tmp124_ = NULL;
		GearyImapEmailProperties* _tmp125_;
		gint64 _tmp130_ = 0LL;
		GearyImapEmailProperties* _tmp131_;
		gint64 _tmp137_ = 0LL;
		GearyImapEmailProperties* _tmp138_;
		GearyEmailField _tmp144_;
		_tmp121_ = geary_email_get_properties (email);
		_tmp122_ = _tmp121_;
		_tmp123_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp122_, GEARY_IMAP_TYPE_EMAIL_PROPERTIES, GearyImapEmailProperties));
		imap_properties = _tmp123_;
		_tmp125_ = imap_properties;
		if (_tmp125_ != NULL) {
			GearyImapEmailProperties* _tmp126_;
			GearyImapInternalDate* _tmp127_;
			GearyImapInternalDate* _tmp128_;
			gchar* _tmp129_;
			_tmp126_ = imap_properties;
			_tmp127_ = geary_imap_email_properties_get_internaldate (_tmp126_);
			_tmp128_ = _tmp127_;
			_tmp129_ = geary_imap_internal_date_serialize (_tmp128_);
			_g_free0 (_tmp124_);
			_tmp124_ = _tmp129_;
		} else {
			_g_free0 (_tmp124_);
			_tmp124_ = NULL;
		}
		geary_imap_db_message_row_set_internaldate (self, _tmp124_);
		_tmp131_ = imap_properties;
		if (_tmp131_ != NULL) {
			GearyImapEmailProperties* _tmp132_;
			GearyImapInternalDate* _tmp133_;
			GearyImapInternalDate* _tmp134_;
			GDateTime* _tmp135_;
			GDateTime* _tmp136_;
			_tmp132_ = imap_properties;
			_tmp133_ = geary_imap_email_properties_get_internaldate (_tmp132_);
			_tmp134_ = _tmp133_;
			_tmp135_ = geary_imap_internal_date_get_value (_tmp134_);
			_tmp136_ = _tmp135_;
			_tmp130_ = g_date_time_to_unix (_tmp136_);
		} else {
			_tmp130_ = (gint64) -1;
		}
		geary_imap_db_message_row_set_internaldate_time_t (self, _tmp130_);
		_tmp138_ = imap_properties;
		if (_tmp138_ != NULL) {
			GearyImapEmailProperties* _tmp139_;
			GearyImapRFC822Size* _tmp140_;
			GearyImapRFC822Size* _tmp141_;
			gint64 _tmp142_;
			gint64 _tmp143_;
			_tmp139_ = imap_properties;
			_tmp140_ = geary_imap_email_properties_get_rfc822_size (_tmp139_);
			_tmp141_ = _tmp140_;
			_tmp142_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp141_, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
			_tmp143_ = _tmp142_;
			_tmp137_ = _tmp143_;
		} else {
			_tmp137_ = (gint64) -1;
		}
		geary_imap_db_message_row_set_rfc822_size (self, _tmp137_);
		_tmp144_ = self->priv->_fields;
		geary_imap_db_message_row_set_fields (self, geary_email_field_set (_tmp144_, GEARY_EMAIL_FIELD_PROPERTIES));
		_g_free0 (_tmp124_);
		_g_object_unref0 (imap_properties);
	}
}

static gchar*
geary_imap_db_message_row_flatten_address (GearyRFC822MailboxAddress* addr)
{
	gchar* flat = NULL;
	gchar* result;
	g_return_val_if_fail ((addr == NULL) || GEARY_RF_C822_IS_MAILBOX_ADDRESS (addr), NULL);
	flat = NULL;
	if (addr != NULL) {
		gchar* _tmp0_;
		_tmp0_ = geary_rf_c822_decoded_message_data_to_rfc822_string (G_TYPE_CHECK_INSTANCE_CAST (addr, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, GearyRFC822DecodedMessageData));
		_g_free0 (flat);
		flat = _tmp0_;
	}
	result = flat;
	return result;
}

static gchar*
geary_imap_db_message_row_flatten_addresses (GearyRFC822MailboxAddresses* addrs)
{
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gchar* result;
	g_return_val_if_fail ((addrs == NULL) || GEARY_RF_C822_IS_MAILBOX_ADDRESSES (addrs), NULL);
	if (addrs == NULL) {
		_tmp1_ = TRUE;
	} else {
		gint _tmp2_;
		gint _tmp3_;
		_tmp2_ = geary_rf_c822_mailbox_addresses_get_size (addrs);
		_tmp3_ = _tmp2_;
		_tmp1_ = _tmp3_ == 0;
	}
	if (_tmp1_) {
		_g_free0 (_tmp0_);
		_tmp0_ = NULL;
	} else {
		gchar* _tmp4_;
		_tmp4_ = geary_rf_c822_decoded_message_data_to_rfc822_string (G_TYPE_CHECK_INSTANCE_CAST (addrs, GEARY_RF_C822_TYPE_DECODED_MESSAGE_DATA, GearyRFC822DecodedMessageData));
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

static GearyRFC822Date*
geary_imap_db_message_row_unflatten_date (GearyImapDBMessageRow* self,
                                          const gchar* str)
{
	GearyRFC822Date* date = NULL;
	GError* _inner_error0_ = NULL;
	GearyRFC822Date* result;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), NULL);
	date = NULL;
	if (!geary_string_is_empty_or_whitespace (str)) {
		{
			GearyRFC822Date* _tmp0_ = NULL;
			GearyRFC822Date* _tmp1_;
			GearyRFC822Date* _tmp2_;
			_tmp1_ = geary_rf_c822_date_new_from_rfc822_string (str, &_inner_error0_);
			_tmp0_ = _tmp1_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
					goto __catch0_geary_rf_c822_error;
				}
				_g_object_unref0 (date);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp2_ = _tmp0_;
			_tmp0_ = NULL;
			_g_object_unref0 (date);
			date = _tmp2_;
			_g_object_unref0 (_tmp0_);
		}
		goto __finally0;
		__catch0_geary_rf_c822_error:
		{
			GError* err = NULL;
			GError* _tmp3_;
			const gchar* _tmp4_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = err;
			_tmp4_ = _tmp3_->message;
			g_debug ("imap-db-message-row.vala:281: Invalid RFC822 date \"%s\": %s", str, _tmp4_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (date);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = date;
	return result;
}

static GearyRFC822MailboxAddress*
geary_imap_db_message_row_unflatten_address (GearyImapDBMessageRow* self,
                                             const gchar* str)
{
	GearyRFC822MailboxAddress* address = NULL;
	GError* _inner_error0_ = NULL;
	GearyRFC822MailboxAddress* result;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), NULL);
	address = NULL;
	if (!geary_string_is_empty_or_whitespace (str)) {
		{
			GearyRFC822MailboxAddress* _tmp0_ = NULL;
			GearyRFC822MailboxAddress* _tmp1_;
			GearyRFC822MailboxAddress* _tmp2_;
			_tmp1_ = geary_rf_c822_mailbox_address_new_from_rfc822_string (str, &_inner_error0_);
			_tmp0_ = _tmp1_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
					goto __catch0_geary_rf_c822_error;
				}
				_g_object_unref0 (address);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp2_ = _tmp0_;
			_tmp0_ = NULL;
			_g_object_unref0 (address);
			address = _tmp2_;
			_g_object_unref0 (_tmp0_);
		}
		goto __finally0;
		__catch0_geary_rf_c822_error:
		{
			GError* err = NULL;
			GError* _tmp3_;
			const gchar* _tmp4_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = err;
			_tmp4_ = _tmp3_->message;
			g_debug ("imap-db-message-row.vala:296: Invalid RFC822 mailbox address \"%s\": %" \
"s", str, _tmp4_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (address);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = address;
	return result;
}

static GearyRFC822MailboxAddresses*
geary_imap_db_message_row_unflatten_addresses (GearyImapDBMessageRow* self,
                                               const gchar* str)
{
	GearyRFC822MailboxAddresses* addresses = NULL;
	GError* _inner_error0_ = NULL;
	GearyRFC822MailboxAddresses* result;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), NULL);
	addresses = NULL;
	if (!geary_string_is_empty_or_whitespace (str)) {
		{
			GearyRFC822MailboxAddresses* _tmp0_ = NULL;
			GearyRFC822MailboxAddresses* _tmp1_;
			GearyRFC822MailboxAddresses* _tmp2_;
			_tmp1_ = geary_rf_c822_mailbox_addresses_new_from_rfc822_string (str, &_inner_error0_);
			_tmp0_ = _tmp1_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
					goto __catch0_geary_rf_c822_error;
				}
				_g_object_unref0 (addresses);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp2_ = _tmp0_;
			_tmp0_ = NULL;
			_g_object_unref0 (addresses);
			addresses = _tmp2_;
			_g_object_unref0 (_tmp0_);
		}
		goto __finally0;
		__catch0_geary_rf_c822_error:
		{
			GError* err = NULL;
			GError* _tmp3_;
			const gchar* _tmp4_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = err;
			_tmp4_ = _tmp3_->message;
			g_debug ("imap-db-message-row.vala:311: Invalid RFC822 mailbox addresses \"%s\":" \
" %s", str, _tmp4_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (addresses);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = addresses;
	return result;
}

static GearyRFC822MessageID*
geary_imap_db_message_row_unflatten_message_id (GearyImapDBMessageRow* self,
                                                const gchar* str)
{
	GearyRFC822MessageID* id = NULL;
	GError* _inner_error0_ = NULL;
	GearyRFC822MessageID* result;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), NULL);
	id = NULL;
	if (!geary_string_is_empty_or_whitespace (str)) {
		{
			GearyRFC822MessageID* _tmp0_ = NULL;
			GearyRFC822MessageID* _tmp1_;
			GearyRFC822MessageID* _tmp2_;
			_tmp1_ = geary_rf_c822_message_id_new_from_rfc822_string (str, &_inner_error0_);
			_tmp0_ = _tmp1_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
					goto __catch0_geary_rf_c822_error;
				}
				_g_object_unref0 (id);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp2_ = _tmp0_;
			_tmp0_ = NULL;
			_g_object_unref0 (id);
			id = _tmp2_;
			_g_object_unref0 (_tmp0_);
		}
		goto __finally0;
		__catch0_geary_rf_c822_error:
		{
			GError* err = NULL;
			GError* _tmp3_;
			const gchar* _tmp4_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = err;
			_tmp4_ = _tmp3_->message;
			g_debug ("imap-db-message-row.vala:326: Invalid RFC822 message id \"%s\": %s", str, _tmp4_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = id;
	return result;
}

static GearyRFC822MessageIDList*
geary_imap_db_message_row_unflatten_message_id_list (GearyImapDBMessageRow* self,
                                                     const gchar* str)
{
	GearyRFC822MessageIDList* ids = NULL;
	GError* _inner_error0_ = NULL;
	GearyRFC822MessageIDList* result;
	g_return_val_if_fail (GEARY_IMAP_DB_IS_MESSAGE_ROW (self), NULL);
	ids = NULL;
	if (!geary_string_is_empty_or_whitespace (str)) {
		{
			GearyRFC822MessageIDList* _tmp0_ = NULL;
			GearyRFC822MessageIDList* _tmp1_;
			GearyRFC822MessageIDList* _tmp2_;
			_tmp1_ = geary_rf_c822_message_id_list_new_from_rfc822_string (str, &_inner_error0_);
			_tmp0_ = _tmp1_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == GEARY_RF_C822_ERROR) {
					goto __catch0_geary_rf_c822_error;
				}
				_g_object_unref0 (ids);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp2_ = _tmp0_;
			_tmp0_ = NULL;
			_g_object_unref0 (ids);
			ids = _tmp2_;
			_g_object_unref0 (_tmp0_);
		}
		goto __finally0;
		__catch0_geary_rf_c822_error:
		{
			GError* err = NULL;
			GError* _tmp3_;
			const gchar* _tmp4_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp3_ = err;
			_tmp4_ = _tmp3_->message;
			g_debug ("imap-db-message-row.vala:341: Invalid RFC822 message id \"%s\": %s", str, _tmp4_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (ids);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = ids;
	return result;
}

static void
geary_imap_db_value_message_row_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
geary_imap_db_value_message_row_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		geary_imap_db_message_row_unref (value->data[0].v_pointer);
	}
}

static void
geary_imap_db_value_message_row_copy_value (const GValue* src_value,
                                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = geary_imap_db_message_row_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
geary_imap_db_value_message_row_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
geary_imap_db_value_message_row_collect_value (GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GearyImapDBMessageRow * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = geary_imap_db_message_row_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
geary_imap_db_value_message_row_lcopy_value (const GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	GearyImapDBMessageRow ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = geary_imap_db_message_row_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
geary_imap_db_param_spec_message_row (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags)
{
	GearyImapDBParamSpecMessageRow* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEARY_IMAP_DB_TYPE_MESSAGE_ROW), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
geary_imap_db_value_get_message_row (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_IMAP_DB_TYPE_MESSAGE_ROW), NULL);
	return value->data[0].v_pointer;
}

void
geary_imap_db_value_set_message_row (GValue* value,
                                     gpointer v_object)
{
	GearyImapDBMessageRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_IMAP_DB_TYPE_MESSAGE_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_IMAP_DB_TYPE_MESSAGE_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		geary_imap_db_message_row_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_imap_db_message_row_unref (old);
	}
}

void
geary_imap_db_value_take_message_row (GValue* value,
                                      gpointer v_object)
{
	GearyImapDBMessageRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_IMAP_DB_TYPE_MESSAGE_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_IMAP_DB_TYPE_MESSAGE_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_imap_db_message_row_unref (old);
	}
}

static void
geary_imap_db_message_row_class_init (GearyImapDBMessageRowClass * klass,
                                      gpointer klass_data)
{
	geary_imap_db_message_row_parent_class = g_type_class_peek_parent (klass);
	((GearyImapDBMessageRowClass *) klass)->finalize = geary_imap_db_message_row_finalize;
	g_type_class_adjust_private_offset (klass, &GearyImapDBMessageRow_private_offset);
}

static void
geary_imap_db_message_row_instance_init (GearyImapDBMessageRow * self,
                                         gpointer klass)
{
	self->priv = geary_imap_db_message_row_get_instance_private (self);
	self->priv->_id = GEARY_DB_INVALID_ROWID;
	self->priv->_fields = GEARY_EMAIL_FIELD_NONE;
	self->priv->_date = NULL;
	self->priv->_date_time_t = (gint64) -1;
	self->priv->_from = NULL;
	self->priv->_sender = NULL;
	self->priv->_reply_to = NULL;
	self->priv->_to = NULL;
	self->priv->_cc = NULL;
	self->priv->_bcc = NULL;
	self->priv->_message_id = NULL;
	self->priv->_in_reply_to = NULL;
	self->priv->_references = NULL;
	self->priv->_subject = NULL;
	self->priv->_header = NULL;
	self->priv->_body = NULL;
	self->priv->_preview = NULL;
	self->priv->_email_flags = NULL;
	self->priv->_internaldate = NULL;
	self->priv->_internaldate_time_t = (gint64) -1;
	self->priv->_rfc822_size = (gint64) -1;
	self->ref_count = 1;
}

static void
geary_imap_db_message_row_finalize (GearyImapDBMessageRow * obj)
{
	GearyImapDBMessageRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_DB_TYPE_MESSAGE_ROW, GearyImapDBMessageRow);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_date);
	_g_free0 (self->priv->_from);
	_g_free0 (self->priv->_sender);
	_g_free0 (self->priv->_reply_to);
	_g_free0 (self->priv->_to);
	_g_free0 (self->priv->_cc);
	_g_free0 (self->priv->_bcc);
	_g_free0 (self->priv->_message_id);
	_g_free0 (self->priv->_in_reply_to);
	_g_free0 (self->priv->_references);
	_g_free0 (self->priv->_subject);
	_g_object_unref0 (self->priv->_header);
	_g_object_unref0 (self->priv->_body);
	_g_free0 (self->priv->_preview);
	_g_free0 (self->priv->_email_flags);
	_g_free0 (self->priv->_internaldate);
}

 G_GNUC_NO_INLINE static GType
geary_imap_db_message_row_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { geary_imap_db_value_message_row_init, geary_imap_db_value_message_row_free_value, geary_imap_db_value_message_row_copy_value, geary_imap_db_value_message_row_peek_pointer, "p", geary_imap_db_value_message_row_collect_value, "p", geary_imap_db_value_message_row_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapDBMessageRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_db_message_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapDBMessageRow), 0, (GInstanceInitFunc) geary_imap_db_message_row_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType geary_imap_db_message_row_type_id;
	geary_imap_db_message_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GearyImapDBMessageRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
	GearyImapDBMessageRow_private_offset = g_type_add_instance_private (geary_imap_db_message_row_type_id, sizeof (GearyImapDBMessageRowPrivate));
	return geary_imap_db_message_row_type_id;
}

GType
geary_imap_db_message_row_get_type (void)
{
	static gsize geary_imap_db_message_row_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_db_message_row_type_id__once)) {
		GType geary_imap_db_message_row_type_id;
		geary_imap_db_message_row_type_id = geary_imap_db_message_row_get_type_once ();
		g_once_init_leave (&geary_imap_db_message_row_type_id__once, geary_imap_db_message_row_type_id);
	}
	return geary_imap_db_message_row_type_id__once;
}

gpointer
geary_imap_db_message_row_ref (gpointer instance)
{
	GearyImapDBMessageRow * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
geary_imap_db_message_row_unref (gpointer instance)
{
	GearyImapDBMessageRow * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEARY_IMAP_DB_MESSAGE_ROW_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

