/* imap-engine-gmail-folder.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-engine-gmail-folder.vala, do not modify */

/*
 * Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER (geary_imap_engine_minimal_folder_get_type ())
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolder))
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolderClass))
#define GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER))
#define GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER))
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolderClass))

typedef struct _GearyImapEngineMinimalFolder GearyImapEngineMinimalFolder;
typedef struct _GearyImapEngineMinimalFolderClass GearyImapEngineMinimalFolderClass;
typedef struct _GearyImapEngineMinimalFolderPrivate GearyImapEngineMinimalFolderPrivate;

#define GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION (geary_imap_engine_replay_operation_get_type ())
#define GEARY_IMAP_ENGINE_REPLAY_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation))
#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperationClass))
#define GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION))
#define GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION))
#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperationClass))

typedef struct _GearyImapEngineReplayOperation GearyImapEngineReplayOperation;
typedef struct _GearyImapEngineReplayOperationClass GearyImapEngineReplayOperationClass;

#define GEARY_IMAP_ENGINE_TYPE_GMAIL_FOLDER (geary_imap_engine_gmail_folder_get_type ())
#define GEARY_IMAP_ENGINE_GMAIL_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_GMAIL_FOLDER, GearyImapEngineGmailFolder))
#define GEARY_IMAP_ENGINE_GMAIL_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_GMAIL_FOLDER, GearyImapEngineGmailFolderClass))
#define GEARY_IMAP_ENGINE_IS_GMAIL_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_GMAIL_FOLDER))
#define GEARY_IMAP_ENGINE_IS_GMAIL_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_GMAIL_FOLDER))
#define GEARY_IMAP_ENGINE_GMAIL_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_GMAIL_FOLDER, GearyImapEngineGmailFolderClass))

typedef struct _GearyImapEngineGmailFolder GearyImapEngineGmailFolder;
typedef struct _GearyImapEngineGmailFolderClass GearyImapEngineGmailFolderClass;
typedef struct _GearyImapEngineGmailFolderPrivate GearyImapEngineGmailFolderPrivate;
enum  {
	GEARY_IMAP_ENGINE_GMAIL_FOLDER_0_PROPERTY,
	GEARY_IMAP_ENGINE_GMAIL_FOLDER_NUM_PROPERTIES
};
static GParamSpec* geary_imap_engine_gmail_folder_properties[GEARY_IMAP_ENGINE_GMAIL_FOLDER_NUM_PROPERTIES];

#define GEARY_IMAP_ENGINE_TYPE_GENERIC_ACCOUNT (geary_imap_engine_generic_account_get_type ())
#define GEARY_IMAP_ENGINE_GENERIC_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_GENERIC_ACCOUNT, GearyImapEngineGenericAccount))
#define GEARY_IMAP_ENGINE_GENERIC_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_GENERIC_ACCOUNT, GearyImapEngineGenericAccountClass))
#define GEARY_IMAP_ENGINE_IS_GENERIC_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_GENERIC_ACCOUNT))
#define GEARY_IMAP_ENGINE_IS_GENERIC_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_GENERIC_ACCOUNT))
#define GEARY_IMAP_ENGINE_GENERIC_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_GENERIC_ACCOUNT, GearyImapEngineGenericAccountClass))

typedef struct _GearyImapEngineGenericAccount GearyImapEngineGenericAccount;
typedef struct _GearyImapEngineGenericAccountClass GearyImapEngineGenericAccountClass;

#define GEARY_IMAP_ENGINE_TYPE_GMAIL_ACCOUNT (geary_imap_engine_gmail_account_get_type ())
#define GEARY_IMAP_ENGINE_GMAIL_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_GMAIL_ACCOUNT, GearyImapEngineGmailAccount))
#define GEARY_IMAP_ENGINE_GMAIL_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_GMAIL_ACCOUNT, GearyImapEngineGmailAccountClass))
#define GEARY_IMAP_ENGINE_IS_GMAIL_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_GMAIL_ACCOUNT))
#define GEARY_IMAP_ENGINE_IS_GMAIL_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_GMAIL_ACCOUNT))
#define GEARY_IMAP_ENGINE_GMAIL_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_GMAIL_ACCOUNT, GearyImapEngineGmailAccountClass))

typedef struct _GearyImapEngineGmailAccount GearyImapEngineGmailAccount;
typedef struct _GearyImapEngineGmailAccountClass GearyImapEngineGmailAccountClass;

#define GEARY_IMAP_DB_TYPE_FOLDER (geary_imap_db_folder_get_type ())
#define GEARY_IMAP_DB_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_FOLDER, GearyImapDBFolder))
#define GEARY_IMAP_DB_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_FOLDER, GearyImapDBFolderClass))
#define GEARY_IMAP_DB_IS_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_FOLDER))
#define GEARY_IMAP_DB_IS_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_FOLDER))
#define GEARY_IMAP_DB_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_FOLDER, GearyImapDBFolderClass))

typedef struct _GearyImapDBFolder GearyImapDBFolder;
typedef struct _GearyImapDBFolderClass GearyImapDBFolderClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _GearyImapEngineGmailFolderCreateEmailAsyncData GearyImapEngineGmailFolderCreateEmailAsyncData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GearyImapEngineGmailFolderArchiveEmailAsyncData GearyImapEngineGmailFolderArchiveEmailAsyncData;
typedef struct _GearyImapEngineGmailFolderRemoveEmailAsyncData GearyImapEngineGmailFolderRemoveEmailAsyncData;

#define GEARY_IMAP_TYPE_FOLDER_SESSION (geary_imap_folder_session_get_type ())
#define GEARY_IMAP_FOLDER_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSession))
#define GEARY_IMAP_FOLDER_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSessionClass))
#define GEARY_IMAP_IS_FOLDER_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION))
#define GEARY_IMAP_IS_FOLDER_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_TYPE_FOLDER_SESSION))
#define GEARY_IMAP_FOLDER_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSessionClass))

typedef struct _GearyImapFolderSession GearyImapFolderSession;
typedef struct _GearyImapFolderSessionClass GearyImapFolderSessionClass;
typedef struct _GearyImapEngineGmailFolderTrueRemoveEmailAsyncData GearyImapEngineGmailFolderTrueRemoveEmailAsyncData;

struct _GearyImapEngineMinimalFolder {
	GearyFolder parent_instance;
	GearyImapEngineMinimalFolderPrivate * priv;
};

struct _GearyImapEngineMinimalFolderClass {
	GearyFolderClass parent_class;
	void (*notify_closing) (GearyImapEngineMinimalFolder* self, GeeList* final_ops);
	void (*mark_email_async) (GearyImapEngineMinimalFolder* self, GeeCollection* to_mark, GearyEmailFlags* flags_to_add, GearyEmailFlags* flags_to_remove, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*mark_email_finish) (GearyImapEngineMinimalFolder* self, GAsyncResult* _res_, GError** error);
	void (*copy_email_async) (GearyImapEngineMinimalFolder* self, GeeCollection* to_copy, GearyFolderPath* destination, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*copy_email_finish) (GearyImapEngineMinimalFolder* self, GAsyncResult* _res_, GError** error);
	void (*move_email_async) (GearyImapEngineMinimalFolder* self, GeeCollection* to_move, GearyFolderPath* destination, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GearyRevokable* (*move_email_finish) (GearyImapEngineMinimalFolder* self, GAsyncResult* _res_, GError** error);
	void (*notify_marked_email_removed) (GearyImapEngineMinimalFolder* self, GeeCollection* removed);
};

struct _GearyImapEngineGmailFolder {
	GearyImapEngineMinimalFolder parent_instance;
	GearyImapEngineGmailFolderPrivate * priv;
};

struct _GearyImapEngineGmailFolderClass {
	GearyImapEngineMinimalFolderClass parent_class;
};

struct _GearyImapEngineGmailFolderCreateEmailAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineGmailFolder* self;
	GearyRFC822Message* rfc822;
	GearyEmailFlags* flags;
	GDateTime* date_received;
	GCancellable* cancellable;
	GearyEmailIdentifier* result;
	GearyEmailIdentifier* _tmp0_;
	GearyEmailIdentifier* _tmp1_;
	GearyEmailIdentifier* _tmp2_;
	GError* _inner_error0_;
};

struct _GearyImapEngineGmailFolderArchiveEmailAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineGmailFolder* self;
	GeeCollection* email_ids;
	GCancellable* cancellable;
	GearyRevokable* result;
	GearyFolder* all_mail;
	GearyAccount* _tmp0_;
	GearyAccount* _tmp1_;
	GearyFolder* _tmp2_;
	GearyFolder* _tmp3_;
	GearyRevokable* _tmp4_;
	GearyFolder* _tmp5_;
	GearyFolderPath* _tmp6_;
	GearyFolderPath* _tmp7_;
	GearyRevokable* _tmp8_;
	GearyRevokable* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GError* _inner_error0_;
};

struct _GearyImapEngineGmailFolderRemoveEmailAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineGmailFolder* self;
	GeeCollection* email_ids;
	GCancellable* cancellable;
	GError* _inner_error0_;
};

struct _GearyImapEngineGmailFolderTrueRemoveEmailAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineMinimalFolder* folder;
	GeeCollection* email_ids;
	GCancellable* cancellable;
	GearyFolder* trash;
	GearyAccount* _tmp0_;
	GearyAccount* _tmp1_;
	GearyFolder* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _tmp5_;
	GError* _tmp6_;
	GeeSet* uids;
	GearyFolderPath* _tmp7_;
	GearyFolderPath* _tmp8_;
	GeeSet* _tmp9_;
	gboolean _tmp10_;
	GeeSet* _tmp11_;
	GeeSet* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GearyImapEngineGenericAccount* account;
	GearyAccount* _tmp19_;
	GearyAccount* _tmp20_;
	GearyImapEngineGenericAccount* _tmp21_;
	GearyImapFolderSession* imap_trash;
	GearyImapEngineGenericAccount* _tmp22_;
	GearyFolderPath* _tmp23_;
	GearyFolderPath* _tmp24_;
	GearyImapFolderSession* _tmp25_;
	GearyImapFolderSession* _tmp26_;
	GeeSet* _tmp27_;
	GeeList* _tmp28_;
	GeeList* _tmp29_;
	GError* _inner_error1_;
	GearyImapEngineGenericAccount* _tmp30_;
	GearyImapFolderSession* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GeeSet* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	GError* _inner_error0_;
};

static gpointer geary_imap_engine_gmail_folder_parent_class = NULL;
static GearyFolderSupportArchiveIface * geary_imap_engine_gmail_folder_geary_folder_support_archive_parent_iface = NULL;
static GearyFolderSupportCreateIface * geary_imap_engine_gmail_folder_geary_folder_support_create_parent_iface = NULL;
static GearyFolderSupportRemoveIface * geary_imap_engine_gmail_folder_geary_folder_support_remove_parent_iface = NULL;

VALA_EXTERN GType geary_imap_engine_minimal_folder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_replay_operation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_gmail_folder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_generic_account_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_gmail_account_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_db_folder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyImapEngineGmailFolder* geary_imap_engine_gmail_folder_new (GearyImapEngineGmailAccount* account,
                                                                GearyImapDBFolder* local_folder,
                                                                GearyFolderSpecialUse use);
VALA_EXTERN GearyImapEngineGmailFolder* geary_imap_engine_gmail_folder_construct (GType object_type,
                                                                      GearyImapEngineGmailAccount* account,
                                                                      GearyImapDBFolder* local_folder,
                                                                      GearyFolderSpecialUse use);
VALA_EXTERN GearyImapEngineMinimalFolder* geary_imap_engine_minimal_folder_new (GearyImapEngineGenericAccount* account,
                                                                    GearyImapDBFolder* local_folder,
                                                                    GearyFolderSpecialUse use);
VALA_EXTERN GearyImapEngineMinimalFolder* geary_imap_engine_minimal_folder_construct (GType object_type,
                                                                          GearyImapEngineGenericAccount* account,
                                                                          GearyImapDBFolder* local_folder,
                                                                          GearyFolderSpecialUse use);
static void geary_imap_engine_gmail_folder_real_create_email_async_data_free (gpointer _data);
static void geary_imap_engine_gmail_folder_real_create_email_async (GearyFolderSupportCreate* base,
                                                             GearyRFC822Message* rfc822,
                                                             GearyEmailFlags* flags,
                                                             GDateTime* date_received,
                                                             GCancellable* cancellable,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static gboolean geary_imap_engine_gmail_folder_real_create_email_async_co (GearyImapEngineGmailFolderCreateEmailAsyncData* _data_);
VALA_EXTERN void geary_imap_engine_minimal_folder_create_email_async (GearyImapEngineMinimalFolder* self,
                                                          GearyRFC822Message* rfc822,
                                                          GearyEmailFlags* flags,
                                                          GDateTime* date_received,
                                                          GCancellable* cancellable,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
VALA_EXTERN GearyEmailIdentifier* geary_imap_engine_minimal_folder_create_email_finish (GearyImapEngineMinimalFolder* self,
                                                                            GAsyncResult* _res_,
                                                                            GError** error);
static void geary_imap_engine_gmail_folder_create_email_async_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
static void geary_imap_engine_gmail_folder_real_archive_email_async_data_free (gpointer _data);
static void geary_imap_engine_gmail_folder_real_archive_email_async (GearyFolderSupportArchive* base,
                                                              GeeCollection* email_ids,
                                                              GCancellable* cancellable,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_);
static gboolean geary_imap_engine_gmail_folder_real_archive_email_async_co (GearyImapEngineGmailFolderArchiveEmailAsyncData* _data_);
VALA_EXTERN void geary_imap_engine_minimal_folder_move_email_async (GearyImapEngineMinimalFolder* self,
                                                        GeeCollection* to_move,
                                                        GearyFolderPath* destination,
                                                        GCancellable* cancellable,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
VALA_EXTERN GearyRevokable* geary_imap_engine_minimal_folder_move_email_finish (GearyImapEngineMinimalFolder* self,
                                                                    GAsyncResult* _res_,
                                                                    GError** error);
static void geary_imap_engine_gmail_folder_archive_email_async_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_);
VALA_EXTERN void geary_imap_engine_minimal_folder_expunge_email_async (GearyImapEngineMinimalFolder* self,
                                                           GeeCollection* to_expunge,
                                                           GCancellable* cancellable,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
VALA_EXTERN void geary_imap_engine_minimal_folder_expunge_email_finish (GearyImapEngineMinimalFolder* self,
                                                            GAsyncResult* _res_,
                                                            GError** error);
static void geary_imap_engine_gmail_folder_real_remove_email_async_data_free (gpointer _data);
static void geary_imap_engine_gmail_folder_real_remove_email_async (GearyFolderSupportRemove* base,
                                                             GeeCollection* email_ids,
                                                             GCancellable* cancellable,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static gboolean geary_imap_engine_gmail_folder_real_remove_email_async_co (GearyImapEngineGmailFolderRemoveEmailAsyncData* _data_);
VALA_EXTERN void geary_imap_engine_gmail_folder_true_remove_email_async (GearyImapEngineMinimalFolder* folder,
                                                             GeeCollection* email_ids,
                                                             GCancellable* cancellable,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
VALA_EXTERN void geary_imap_engine_gmail_folder_true_remove_email_finish (GAsyncResult* _res_,
                                                              GError** error);
static void geary_imap_engine_gmail_folder_remove_email_async_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
static void geary_imap_engine_gmail_folder_true_remove_email_async_data_free (gpointer _data);
static gboolean geary_imap_engine_gmail_folder_true_remove_email_async_co (GearyImapEngineGmailFolderTrueRemoveEmailAsyncData* _data_);
VALA_EXTERN void geary_imap_engine_minimal_folder_copy_email_uids_async (GearyImapEngineMinimalFolder* self,
                                                             GeeCollection* to_copy,
                                                             GearyFolderPath* destination,
                                                             GCancellable* cancellable,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
VALA_EXTERN GeeSet* geary_imap_engine_minimal_folder_copy_email_uids_finish (GearyImapEngineMinimalFolder* self,
                                                                 GAsyncResult* _res_,
                                                                 GError** error);
static void geary_imap_engine_gmail_folder_true_remove_email_async_ready (GObject* source_object,
                                                                   GAsyncResult* _res_,
                                                                   gpointer _user_data_);
VALA_EXTERN GType geary_imap_folder_session_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void geary_imap_engine_generic_account_claim_folder_session (GearyImapEngineGenericAccount* self,
                                                             GearyFolderPath* path,
                                                             GCancellable* cancellable,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
VALA_EXTERN GearyImapFolderSession* geary_imap_engine_generic_account_claim_folder_session_finish (GearyImapEngineGenericAccount* self,
                                                                                       GAsyncResult* _res_,
                                                                                       GError** error);
VALA_EXTERN void geary_imap_folder_session_remove_email_async (GearyImapFolderSession* self,
                                                   GeeList* msg_sets,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN void geary_imap_folder_session_remove_email_finish (GearyImapFolderSession* self,
                                                    GAsyncResult* _res_,
                                                    GError** error);
VALA_EXTERN void geary_imap_engine_generic_account_release_folder_session (GearyImapEngineGenericAccount* self,
                                                               GearyImapFolderSession* session,
                                                               GAsyncReadyCallback _callback_,
                                                               gpointer _user_data_);
VALA_EXTERN void geary_imap_engine_generic_account_release_folder_session_finish (GearyImapEngineGenericAccount* self,
                                                                      GAsyncResult* _res_);
static GType geary_imap_engine_gmail_folder_get_type_once (void);

GearyImapEngineGmailFolder*
geary_imap_engine_gmail_folder_construct (GType object_type,
                                          GearyImapEngineGmailAccount* account,
                                          GearyImapDBFolder* local_folder,
                                          GearyFolderSpecialUse use)
{
	GearyImapEngineGmailFolder * self = NULL;
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_GMAIL_ACCOUNT (account), NULL);
	g_return_val_if_fail (GEARY_IMAP_DB_IS_FOLDER (local_folder), NULL);
	self = (GearyImapEngineGmailFolder*) geary_imap_engine_minimal_folder_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (account, GEARY_IMAP_ENGINE_TYPE_GENERIC_ACCOUNT, GearyImapEngineGenericAccount), local_folder, use);
	return self;
}

GearyImapEngineGmailFolder*
geary_imap_engine_gmail_folder_new (GearyImapEngineGmailAccount* account,
                                    GearyImapDBFolder* local_folder,
                                    GearyFolderSpecialUse use)
{
	return geary_imap_engine_gmail_folder_construct (GEARY_IMAP_ENGINE_TYPE_GMAIL_FOLDER, account, local_folder, use);
}

static void
geary_imap_engine_gmail_folder_real_create_email_async_data_free (gpointer _data)
{
	GearyImapEngineGmailFolderCreateEmailAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->rfc822);
	_g_object_unref0 (_data_->flags);
	_g_date_time_unref0 (_data_->date_received);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapEngineGmailFolderCreateEmailAsyncData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static void
geary_imap_engine_gmail_folder_real_create_email_async (GearyFolderSupportCreate* base,
                                                        GearyRFC822Message* rfc822,
                                                        GearyEmailFlags* flags,
                                                        GDateTime* date_received,
                                                        GCancellable* cancellable,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	GearyImapEngineGmailFolder * self;
	GearyImapEngineGmailFolderCreateEmailAsyncData* _data_;
	GearyImapEngineGmailFolder* _tmp0_;
	GearyRFC822Message* _tmp1_;
	GearyEmailFlags* _tmp2_;
	GDateTime* _tmp3_;
	GCancellable* _tmp4_;
	g_return_if_fail (GEARY_RF_C822_IS_MESSAGE (rfc822));
	g_return_if_fail ((flags == NULL) || GEARY_IS_EMAIL_FLAGS (flags));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_GMAIL_FOLDER, GearyImapEngineGmailFolder);
	_data_ = g_slice_new0 (GearyImapEngineGmailFolderCreateEmailAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_gmail_folder_real_create_email_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (rfc822);
	_g_object_unref0 (_data_->rfc822);
	_data_->rfc822 = _tmp1_;
	_tmp2_ = _g_object_ref0 (flags);
	_g_object_unref0 (_data_->flags);
	_data_->flags = _tmp2_;
	_tmp3_ = _g_date_time_ref0 (date_received);
	_g_date_time_unref0 (_data_->date_received);
	_data_->date_received = _tmp3_;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	geary_imap_engine_gmail_folder_real_create_email_async_co (_data_);
}

static GearyEmailIdentifier*
geary_imap_engine_gmail_folder_create_email_finish (GearyFolderSupportCreate* base,
                                                    GAsyncResult* _res_,
                                                    GError** error)
{
	GearyEmailIdentifier* result;
	GearyImapEngineGmailFolderCreateEmailAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
geary_imap_engine_gmail_folder_create_email_async_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	GearyImapEngineGmailFolderCreateEmailAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_engine_gmail_folder_real_create_email_async_co (_data_);
}

static gboolean
geary_imap_engine_gmail_folder_real_create_email_async_co (GearyImapEngineGmailFolderCreateEmailAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	geary_imap_engine_minimal_folder_create_email_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolder), _data_->rfc822, _data_->flags, _data_->date_received, _data_->cancellable, geary_imap_engine_gmail_folder_create_email_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = geary_imap_engine_minimal_folder_create_email_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolder), _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp2_;
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_engine_gmail_folder_real_archive_email_async_data_free (gpointer _data)
{
	GearyImapEngineGmailFolderArchiveEmailAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->email_ids);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapEngineGmailFolderArchiveEmailAsyncData, _data_);
}

static void
geary_imap_engine_gmail_folder_real_archive_email_async (GearyFolderSupportArchive* base,
                                                         GeeCollection* email_ids,
                                                         GCancellable* cancellable,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_)
{
	GearyImapEngineGmailFolder * self;
	GearyImapEngineGmailFolderArchiveEmailAsyncData* _data_;
	GearyImapEngineGmailFolder* _tmp0_;
	GeeCollection* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (email_ids, GEE_TYPE_COLLECTION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_GMAIL_FOLDER, GearyImapEngineGmailFolder);
	_data_ = g_slice_new0 (GearyImapEngineGmailFolderArchiveEmailAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_gmail_folder_real_archive_email_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (email_ids);
	_g_object_unref0 (_data_->email_ids);
	_data_->email_ids = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_imap_engine_gmail_folder_real_archive_email_async_co (_data_);
}

static GearyRevokable*
geary_imap_engine_gmail_folder_archive_email_finish (GearyFolderSupportArchive* base,
                                                     GAsyncResult* _res_,
                                                     GError** error)
{
	GearyRevokable* result;
	GearyImapEngineGmailFolderArchiveEmailAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
geary_imap_engine_gmail_folder_archive_email_async_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_)
{
	GearyImapEngineGmailFolderArchiveEmailAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_engine_gmail_folder_real_archive_email_async_co (_data_);
}

static gboolean
geary_imap_engine_gmail_folder_real_archive_email_async_co (GearyImapEngineGmailFolderArchiveEmailAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_TYPE_FOLDER, GearyFolder));
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = geary_account_get_special_folder (_data_->_tmp1_, GEARY_FOLDER_SPECIAL_USE_ALL_MAIL);
	_data_->all_mail = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->all_mail;
	if (_data_->_tmp3_ != NULL) {
		_data_->_tmp5_ = _data_->all_mail;
		_data_->_tmp6_ = geary_folder_get_path (_data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_state_ = 1;
		geary_imap_engine_minimal_folder_move_email_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolder), _data_->email_ids, _data_->_tmp7_, _data_->cancellable, geary_imap_engine_gmail_folder_archive_email_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp8_ = geary_imap_engine_minimal_folder_move_email_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolder), _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp4_ = _data_->_tmp8_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->all_mail);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp9_ = _data_->_tmp4_;
		_data_->_tmp4_ = NULL;
		_data_->result = _data_->_tmp9_;
		_g_object_unref0 (_data_->_tmp4_);
		_g_object_unref0 (_data_->all_mail);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
	_data_->_tmp11_ = _data_->_tmp10_;
	geary_logging_source_message (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "%s: Unable to perform revokable archive: All Mail not found", _data_->_tmp11_);
	_g_free0 (_data_->_tmp11_);
	_data_->_state_ = 2;
	geary_imap_engine_minimal_folder_expunge_email_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolder), _data_->email_ids, _data_->cancellable, geary_imap_engine_gmail_folder_archive_email_async_ready, _data_);
	return FALSE;
	_state_2:
	geary_imap_engine_minimal_folder_expunge_email_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolder), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->all_mail);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = NULL;
	_g_object_unref0 (_data_->all_mail);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_engine_gmail_folder_real_remove_email_async_data_free (gpointer _data)
{
	GearyImapEngineGmailFolderRemoveEmailAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->email_ids);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapEngineGmailFolderRemoveEmailAsyncData, _data_);
}

static void
geary_imap_engine_gmail_folder_real_remove_email_async (GearyFolderSupportRemove* base,
                                                        GeeCollection* email_ids,
                                                        GCancellable* cancellable,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	GearyImapEngineGmailFolder * self;
	GearyImapEngineGmailFolderRemoveEmailAsyncData* _data_;
	GearyImapEngineGmailFolder* _tmp0_;
	GeeCollection* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (email_ids, GEE_TYPE_COLLECTION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_GMAIL_FOLDER, GearyImapEngineGmailFolder);
	_data_ = g_slice_new0 (GearyImapEngineGmailFolderRemoveEmailAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_gmail_folder_real_remove_email_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (email_ids);
	_g_object_unref0 (_data_->email_ids);
	_data_->email_ids = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_imap_engine_gmail_folder_real_remove_email_async_co (_data_);
}

static void
geary_imap_engine_gmail_folder_remove_email_finish (GearyFolderSupportRemove* base,
                                                    GAsyncResult* _res_,
                                                    GError** error)
{
	GearyImapEngineGmailFolderRemoveEmailAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_imap_engine_gmail_folder_remove_email_async_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	GearyImapEngineGmailFolderRemoveEmailAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_engine_gmail_folder_real_remove_email_async_co (_data_);
}

static gboolean
geary_imap_engine_gmail_folder_real_remove_email_async_co (GearyImapEngineGmailFolderRemoveEmailAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	geary_imap_engine_gmail_folder_true_remove_email_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolder), _data_->email_ids, _data_->cancellable, geary_imap_engine_gmail_folder_remove_email_async_ready, _data_);
	return FALSE;
	_state_1:
	geary_imap_engine_gmail_folder_true_remove_email_finish (_data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_engine_gmail_folder_true_remove_email_async_data_free (gpointer _data)
{
	GearyImapEngineGmailFolderTrueRemoveEmailAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->folder);
	_g_object_unref0 (_data_->email_ids);
	_g_object_unref0 (_data_->cancellable);
	g_slice_free (GearyImapEngineGmailFolderTrueRemoveEmailAsyncData, _data_);
}

void
geary_imap_engine_gmail_folder_true_remove_email_async (GearyImapEngineMinimalFolder* folder,
                                                        GeeCollection* email_ids,
                                                        GCancellable* cancellable,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	GearyImapEngineGmailFolderTrueRemoveEmailAsyncData* _data_;
	GearyImapEngineMinimalFolder* _tmp0_;
	GeeCollection* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER (folder));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (email_ids, GEE_TYPE_COLLECTION));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearyImapEngineGmailFolderTrueRemoveEmailAsyncData);
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_gmail_folder_true_remove_email_async_data_free);
	_tmp0_ = _g_object_ref0 (folder);
	_g_object_unref0 (_data_->folder);
	_data_->folder = _tmp0_;
	_tmp1_ = _g_object_ref0 (email_ids);
	_g_object_unref0 (_data_->email_ids);
	_data_->email_ids = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_imap_engine_gmail_folder_true_remove_email_async_co (_data_);
}

void
geary_imap_engine_gmail_folder_true_remove_email_finish (GAsyncResult* _res_,
                                                         GError** error)
{
	GearyImapEngineGmailFolderTrueRemoveEmailAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

/**
     * Truly removes an email from Gmail by moving it to the Trash and then deleting it from the
     * Trash.
     *
     * TODO: Because the steps after copy don't go through the ReplayQueue, they won't be recorded
     * in the database directly.  This is important when/if offline mode is coded, as if there's
     * no connection (or the connection dies) there's no record that Geary needs to perform the
     * final remove when a connection is reestablished.
     */
static void
geary_imap_engine_gmail_folder_true_remove_email_async_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_)
{
	GearyImapEngineGmailFolderTrueRemoveEmailAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_engine_gmail_folder_true_remove_email_async_co (_data_);
}

static gboolean
geary_imap_engine_gmail_folder_true_remove_email_async_co (GearyImapEngineGmailFolderTrueRemoveEmailAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->folder, GEARY_TYPE_FOLDER, GearyFolder));
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = geary_account_get_special_folder (_data_->_tmp1_, GEARY_FOLDER_SPECIAL_USE_TRASH);
	_data_->trash = _data_->_tmp2_;
	if (_data_->trash == NULL) {
		_data_->_tmp3_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->folder, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = g_error_new (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_NOT_FOUND, "%s: Trash folder not found for removal", _data_->_tmp4_);
		_data_->_tmp6_ = _data_->_tmp5_;
		_g_free0 (_data_->_tmp4_);
		_data_->_inner_error0_ = _data_->_tmp6_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->trash);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = geary_folder_get_path (_data_->trash);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_state_ = 1;
	geary_imap_engine_minimal_folder_copy_email_uids_async (_data_->folder, _data_->email_ids, _data_->_tmp8_, _data_->cancellable, geary_imap_engine_gmail_folder_true_remove_email_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp9_ = geary_imap_engine_minimal_folder_copy_email_uids_finish (_data_->folder, _data_->_res_, &_data_->_inner_error0_);
	_data_->uids = _data_->_tmp9_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->trash);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp11_ = _data_->uids;
	if (_data_->_tmp11_ == NULL) {
		_data_->_tmp10_ = TRUE;
	} else {
		_data_->_tmp12_ = _data_->uids;
		_data_->_tmp13_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp12_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp10_ = _data_->_tmp14_ == 0;
	}
	if (_data_->_tmp10_) {
		_data_->_tmp15_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->folder, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp17_ = gee_collection_get_size (_data_->email_ids);
		_data_->_tmp18_ = _data_->_tmp17_;
		g_debug ("imap-engine-gmail-folder.vala:76: %s: Can't true-remove %d emails, no " \
"COPYUIDs returned", _data_->_tmp16_, _data_->_tmp18_);
		_g_free0 (_data_->_tmp16_);
		_g_object_unref0 (_data_->uids);
		_g_object_unref0 (_data_->trash);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp19_ = geary_folder_get_account (G_TYPE_CHECK_INSTANCE_CAST (_data_->folder, GEARY_TYPE_FOLDER, GearyFolder));
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp20_, GEARY_IMAP_ENGINE_TYPE_GENERIC_ACCOUNT, GearyImapEngineGenericAccount));
	_data_->account = _data_->_tmp21_;
	_data_->_tmp22_ = _data_->account;
	_data_->_tmp23_ = geary_folder_get_path (_data_->trash);
	_data_->_tmp24_ = _data_->_tmp23_;
	_data_->_state_ = 2;
	geary_imap_engine_generic_account_claim_folder_session (_data_->_tmp22_, _data_->_tmp24_, _data_->cancellable, geary_imap_engine_gmail_folder_true_remove_email_async_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp25_ = geary_imap_engine_generic_account_claim_folder_session_finish (_data_->_tmp22_, _data_->_res_, &_data_->_inner_error0_);
	_data_->imap_trash = _data_->_tmp25_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->account);
		_g_object_unref0 (_data_->uids);
		_g_object_unref0 (_data_->trash);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp26_ = _data_->imap_trash;
		_data_->_tmp27_ = _data_->uids;
		_data_->_tmp28_ = geary_imap_message_set_uid_sparse (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp27_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp29_ = _data_->_tmp28_;
		_data_->_state_ = 3;
		geary_imap_folder_session_remove_email_async (_data_->_tmp26_, _data_->_tmp29_, _data_->cancellable, geary_imap_engine_gmail_folder_true_remove_email_async_ready, _data_);
		return FALSE;
		_state_3:
		geary_imap_folder_session_remove_email_finish (_data_->_tmp26_, _data_->_res_, &_data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp29_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __finally0;
		}
	}
	__finally0:
	{
		_data_->_tmp30_ = _data_->account;
		_data_->_tmp31_ = _data_->imap_trash;
		_data_->_state_ = 4;
		geary_imap_engine_generic_account_release_folder_session (_data_->_tmp30_, _data_->_tmp31_, geary_imap_engine_gmail_folder_true_remove_email_async_ready, _data_);
		return FALSE;
		_state_4:
		geary_imap_engine_generic_account_release_folder_session_finish (_data_->_tmp30_, _data_->_res_);
	}
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->imap_trash);
		_g_object_unref0 (_data_->account);
		_g_object_unref0 (_data_->uids);
		_g_object_unref0 (_data_->trash);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp32_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->folder, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
	_data_->_tmp33_ = _data_->_tmp32_;
	_data_->_tmp34_ = _data_->uids;
	_data_->_tmp35_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp34_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->_tmp36_ = _data_->_tmp35_;
	_data_->_tmp37_ = gee_collection_get_size (_data_->email_ids);
	_data_->_tmp38_ = _data_->_tmp37_;
	g_debug ("imap-engine-gmail-folder.vala:95: %s: Successfully true-removed %d/%d " \
"emails", _data_->_tmp33_, _data_->_tmp36_, _data_->_tmp38_);
	_g_free0 (_data_->_tmp33_);
	_g_object_unref0 (_data_->imap_trash);
	_g_object_unref0 (_data_->account);
	_g_object_unref0 (_data_->uids);
	_g_object_unref0 (_data_->trash);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_engine_gmail_folder_class_init (GearyImapEngineGmailFolderClass * klass,
                                           gpointer klass_data)
{
	geary_imap_engine_gmail_folder_parent_class = g_type_class_peek_parent (klass);
}

static void
geary_imap_engine_gmail_folder_geary_folder_support_archive_interface_init (GearyFolderSupportArchiveIface * iface,
                                                                            gpointer iface_data)
{
	geary_imap_engine_gmail_folder_geary_folder_support_archive_parent_iface = g_type_interface_peek_parent (iface);
	iface->archive_email_async = (void (*) (GearyFolderSupportArchive*, GeeCollection*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_imap_engine_gmail_folder_real_archive_email_async;
	iface->archive_email_finish = (GearyRevokable* (*) (GearyFolderSupportArchive*, GAsyncResult*, GError**)) geary_imap_engine_gmail_folder_archive_email_finish;
}

static void
geary_imap_engine_gmail_folder_geary_folder_support_create_interface_init (GearyFolderSupportCreateIface * iface,
                                                                           gpointer iface_data)
{
	geary_imap_engine_gmail_folder_geary_folder_support_create_parent_iface = g_type_interface_peek_parent (iface);
	iface->create_email_async = (void (*) (GearyFolderSupportCreate*, GearyRFC822Message*, GearyEmailFlags*, GDateTime*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_imap_engine_gmail_folder_real_create_email_async;
	iface->create_email_finish = (GearyEmailIdentifier* (*) (GearyFolderSupportCreate*, GAsyncResult*, GError**)) geary_imap_engine_gmail_folder_create_email_finish;
}

static void
geary_imap_engine_gmail_folder_geary_folder_support_remove_interface_init (GearyFolderSupportRemoveIface * iface,
                                                                           gpointer iface_data)
{
	geary_imap_engine_gmail_folder_geary_folder_support_remove_parent_iface = g_type_interface_peek_parent (iface);
	iface->remove_email_async = (void (*) (GearyFolderSupportRemove*, GeeCollection*, GCancellable*, GAsyncReadyCallback, gpointer)) geary_imap_engine_gmail_folder_real_remove_email_async;
	iface->remove_email_finish = (void (*) (GearyFolderSupportRemove*, GAsyncResult*, GError**)) geary_imap_engine_gmail_folder_remove_email_finish;
}

static void
geary_imap_engine_gmail_folder_instance_init (GearyImapEngineGmailFolder * self,
                                              gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
geary_imap_engine_gmail_folder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapEngineGmailFolderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_engine_gmail_folder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapEngineGmailFolder), 0, (GInstanceInitFunc) geary_imap_engine_gmail_folder_instance_init, NULL };
	static const GInterfaceInfo geary_folder_support_archive_info = { (GInterfaceInitFunc) geary_imap_engine_gmail_folder_geary_folder_support_archive_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo geary_folder_support_create_info = { (GInterfaceInitFunc) geary_imap_engine_gmail_folder_geary_folder_support_create_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo geary_folder_support_remove_info = { (GInterfaceInitFunc) geary_imap_engine_gmail_folder_geary_folder_support_remove_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_imap_engine_gmail_folder_type_id;
	geary_imap_engine_gmail_folder_type_id = g_type_register_static (GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, "GearyImapEngineGmailFolder", &g_define_type_info, 0);
	g_type_add_interface_static (geary_imap_engine_gmail_folder_type_id, GEARY_FOLDER_SUPPORT_TYPE_ARCHIVE, &geary_folder_support_archive_info);
	g_type_add_interface_static (geary_imap_engine_gmail_folder_type_id, GEARY_FOLDER_SUPPORT_TYPE_CREATE, &geary_folder_support_create_info);
	g_type_add_interface_static (geary_imap_engine_gmail_folder_type_id, GEARY_FOLDER_SUPPORT_TYPE_REMOVE, &geary_folder_support_remove_info);
	return geary_imap_engine_gmail_folder_type_id;
}

GType
geary_imap_engine_gmail_folder_get_type (void)
{
	static gsize geary_imap_engine_gmail_folder_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_engine_gmail_folder_type_id__once)) {
		GType geary_imap_engine_gmail_folder_type_id;
		geary_imap_engine_gmail_folder_type_id = geary_imap_engine_gmail_folder_get_type_once ();
		g_once_init_leave (&geary_imap_engine_gmail_folder_type_id__once, geary_imap_engine_gmail_folder_type_id);
	}
	return geary_imap_engine_gmail_folder_type_id__once;
}

