/* imap-engine-fetch-email.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-engine-fetch-email.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define GEARY_IMAP_DB_FOLDER_REQUIRED_FIELDS ((GEARY_EMAIL_FIELD_PROPERTIES | GEARY_EMAIL_FIELD_REFERENCES) | GEARY_EMAIL_FIELD_FLAGS)

#define GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION (geary_imap_engine_replay_operation_get_type ())
#define GEARY_IMAP_ENGINE_REPLAY_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation))
#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperationClass))
#define GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION))
#define GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION))
#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperationClass))

typedef struct _GearyImapEngineReplayOperation GearyImapEngineReplayOperation;
typedef struct _GearyImapEngineReplayOperationClass GearyImapEngineReplayOperationClass;
typedef struct _GearyImapEngineReplayOperationPrivate GearyImapEngineReplayOperationPrivate;

#define GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER (geary_imap_db_email_identifier_get_type ())
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifier))
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifierClass))
#define GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER))
#define GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER))
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifierClass))

typedef struct _GearyImapDBEmailIdentifier GearyImapDBEmailIdentifier;
typedef struct _GearyImapDBEmailIdentifierClass GearyImapDBEmailIdentifierClass;
typedef enum  {
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_COMPLETED,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_CONTINUE
} GearyImapEngineReplayOperationStatus;

#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_TYPE_STATUS (geary_imap_engine_replay_operation_status_get_type ())

#define GEARY_IMAP_TYPE_FOLDER_SESSION (geary_imap_folder_session_get_type ())
#define GEARY_IMAP_FOLDER_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSession))
#define GEARY_IMAP_FOLDER_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSessionClass))
#define GEARY_IMAP_IS_FOLDER_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION))
#define GEARY_IMAP_IS_FOLDER_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_TYPE_FOLDER_SESSION))
#define GEARY_IMAP_FOLDER_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSessionClass))

typedef struct _GearyImapFolderSession GearyImapFolderSession;
typedef struct _GearyImapFolderSessionClass GearyImapFolderSessionClass;

#define GEARY_IMAP_ENGINE_TYPE_SEND_REPLAY_OPERATION (geary_imap_engine_send_replay_operation_get_type ())
#define GEARY_IMAP_ENGINE_SEND_REPLAY_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_SEND_REPLAY_OPERATION, GearyImapEngineSendReplayOperation))
#define GEARY_IMAP_ENGINE_SEND_REPLAY_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_SEND_REPLAY_OPERATION, GearyImapEngineSendReplayOperationClass))
#define GEARY_IMAP_ENGINE_IS_SEND_REPLAY_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_SEND_REPLAY_OPERATION))
#define GEARY_IMAP_ENGINE_IS_SEND_REPLAY_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_SEND_REPLAY_OPERATION))
#define GEARY_IMAP_ENGINE_SEND_REPLAY_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_SEND_REPLAY_OPERATION, GearyImapEngineSendReplayOperationClass))

typedef struct _GearyImapEngineSendReplayOperation GearyImapEngineSendReplayOperation;
typedef struct _GearyImapEngineSendReplayOperationClass GearyImapEngineSendReplayOperationClass;
typedef struct _GearyImapEngineSendReplayOperationPrivate GearyImapEngineSendReplayOperationPrivate;

#define GEARY_IMAP_ENGINE_TYPE_FETCH_EMAIL (geary_imap_engine_fetch_email_get_type ())
#define GEARY_IMAP_ENGINE_FETCH_EMAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_FETCH_EMAIL, GearyImapEngineFetchEmail))
#define GEARY_IMAP_ENGINE_FETCH_EMAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_FETCH_EMAIL, GearyImapEngineFetchEmailClass))
#define GEARY_IMAP_ENGINE_IS_FETCH_EMAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_FETCH_EMAIL))
#define GEARY_IMAP_ENGINE_IS_FETCH_EMAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_FETCH_EMAIL))
#define GEARY_IMAP_ENGINE_FETCH_EMAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_FETCH_EMAIL, GearyImapEngineFetchEmailClass))

typedef struct _GearyImapEngineFetchEmail GearyImapEngineFetchEmail;
typedef struct _GearyImapEngineFetchEmailClass GearyImapEngineFetchEmailClass;
typedef struct _GearyImapEngineFetchEmailPrivate GearyImapEngineFetchEmailPrivate;

#define GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER (geary_imap_engine_minimal_folder_get_type ())
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolder))
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolderClass))
#define GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER))
#define GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER))
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolderClass))

typedef struct _GearyImapEngineMinimalFolder GearyImapEngineMinimalFolder;
typedef struct _GearyImapEngineMinimalFolderClass GearyImapEngineMinimalFolderClass;
enum  {
	GEARY_IMAP_ENGINE_FETCH_EMAIL_0_PROPERTY,
	GEARY_IMAP_ENGINE_FETCH_EMAIL_NUM_PROPERTIES
};
static GParamSpec* geary_imap_engine_fetch_email_properties[GEARY_IMAP_ENGINE_FETCH_EMAIL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_THROW,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_RETRY,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_IGNORE_REMOTE
} GearyImapEngineReplayOperationOnError;

#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_TYPE_ON_ERROR (geary_imap_engine_replay_operation_on_error_get_type ())

#define GEARY_IMAP_DB_TYPE_FOLDER (geary_imap_db_folder_get_type ())
#define GEARY_IMAP_DB_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_FOLDER, GearyImapDBFolder))
#define GEARY_IMAP_DB_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_FOLDER, GearyImapDBFolderClass))
#define GEARY_IMAP_DB_IS_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_FOLDER))
#define GEARY_IMAP_DB_IS_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_FOLDER))
#define GEARY_IMAP_DB_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_FOLDER, GearyImapDBFolderClass))

typedef struct _GearyImapDBFolder GearyImapDBFolder;
typedef struct _GearyImapDBFolderClass GearyImapDBFolderClass;
typedef enum  {
	GEARY_IMAP_DB_FOLDER_LIST_FLAGS_NONE = 0,
	GEARY_IMAP_DB_FOLDER_LIST_FLAGS_PARTIAL_OK = 1 << 0,
	GEARY_IMAP_DB_FOLDER_LIST_FLAGS_INCLUDE_MARKED_FOR_REMOVE = 1 << 1,
	GEARY_IMAP_DB_FOLDER_LIST_FLAGS_INCLUDING_ID = 1 << 2,
	GEARY_IMAP_DB_FOLDER_LIST_FLAGS_OLDEST_TO_NEWEST = 1 << 3,
	GEARY_IMAP_DB_FOLDER_LIST_FLAGS_ONLY_INCOMPLETE = 1 << 4
} GearyImapDBFolderListFlags;

#define GEARY_IMAP_DB_FOLDER_TYPE_LIST_FLAGS (geary_imap_db_folder_list_flags_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GearyImapEngineFetchEmailReplayLocalAsyncData GearyImapEngineFetchEmailReplayLocalAsyncData;

#define GEARY_TYPE_CONTACT_HARVESTER (geary_contact_harvester_get_type ())
#define GEARY_CONTACT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_TYPE_CONTACT_HARVESTER, GearyContactHarvester))
#define GEARY_IS_CONTACT_HARVESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_TYPE_CONTACT_HARVESTER))
#define GEARY_CONTACT_HARVESTER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEARY_TYPE_CONTACT_HARVESTER, GearyContactHarvesterIface))

typedef struct _GearyContactHarvester GearyContactHarvester;
typedef struct _GearyContactHarvesterIface GearyContactHarvesterIface;
typedef struct _GearyImapEngineFetchEmailReplayRemoteAsyncData GearyImapEngineFetchEmailReplayRemoteAsyncData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GearyImapEngineReplayOperation {
	GearyBaseObject parent_instance;
	GearyImapEngineReplayOperationPrivate * priv;
};

struct _GearyImapEngineReplayOperationClass {
	GearyBaseObjectClass parent_class;
	void (*notify_remote_removed_position) (GearyImapEngineReplayOperation* self, GearyImapSequenceNumber* removed);
	void (*notify_remote_removed_ids) (GearyImapEngineReplayOperation* self, GeeCollection* ids);
	void (*get_ids_to_be_remote_removed) (GearyImapEngineReplayOperation* self, GeeCollection* ids);
	void (*replay_local_async) (GearyImapEngineReplayOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GearyImapEngineReplayOperationStatus (*replay_local_finish) (GearyImapEngineReplayOperation* self, GAsyncResult* _res_, GError** error);
	void (*replay_remote_async) (GearyImapEngineReplayOperation* self, GearyImapFolderSession* remote, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*replay_remote_finish) (GearyImapEngineReplayOperation* self, GAsyncResult* _res_, GError** error);
	void (*backout_local_async) (GearyImapEngineReplayOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*backout_local_finish) (GearyImapEngineReplayOperation* self, GAsyncResult* _res_, GError** error);
	gchar* (*describe_state) (GearyImapEngineReplayOperation* self);
};

struct _GearyImapEngineSendReplayOperation {
	GearyImapEngineReplayOperation parent_instance;
	GearyImapEngineSendReplayOperationPrivate * priv;
};

struct _GearyImapEngineSendReplayOperationClass {
	GearyImapEngineReplayOperationClass parent_class;
};

struct _GearyImapEngineFetchEmail {
	GearyImapEngineSendReplayOperation parent_instance;
	GearyEmail* email;
	GearyImapEngineFetchEmailPrivate * priv;
};

struct _GearyImapEngineFetchEmailClass {
	GearyImapEngineSendReplayOperationClass parent_class;
};

struct _GearyImapEngineFetchEmailPrivate {
	GearyImapEngineMinimalFolder* engine;
	GearyImapDBEmailIdentifier* id;
	GearyEmailField required_fields;
	GearyEmailField remaining_fields;
	GearyFolderListFlags flags;
	GCancellable* cancellable;
	GearyImapUID* uid;
	gboolean remote_removed;
};

struct _GearyImapEngineFetchEmailReplayLocalAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineFetchEmail* self;
	GearyImapEngineReplayOperationStatus result;
	GearyImapUID* _tmp0_;
	GearyImapEngineMinimalFolder* _tmp1_;
	GearyImapDBFolder* _tmp2_;
	GearyImapDBFolder* _tmp3_;
	GearyImapDBEmailIdentifier* _tmp4_;
	GCancellable* _tmp5_;
	GearyImapUID* _tmp6_;
	GearyImapUID* _tmp7_;
	gboolean local_only;
	GearyEmail* email;
	GearyEmail* _tmp8_;
	GearyImapEngineMinimalFolder* _tmp9_;
	GearyImapDBFolder* _tmp10_;
	GearyImapDBFolder* _tmp11_;
	GearyImapDBEmailIdentifier* _tmp12_;
	GCancellable* _tmp13_;
	GearyEmail* _tmp14_;
	GearyEmail* _tmp15_;
	GError* err;
	GError* _tmp16_;
	GError* _tmp17_;
	gboolean _tmp18_;
	GearyEmail* _tmp19_;
	GearyEmail* _tmp20_;
	GearyEmailField _tmp21_;
	GearyEmailField _tmp22_;
	GearyEmail* _tmp23_;
	GearyEmail* _tmp24_;
	GearyImapDBEmailIdentifier* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GError* _tmp30_;
	GError* _tmp31_;
	GearyEmail* _tmp32_;
	GearyEmail* _tmp33_;
	GearyEmailField _tmp34_;
	GearyEmailField _tmp35_;
	GearyEmail* _tmp36_;
	GearyEmail* _tmp37_;
	GearyEmailIdentifier* _tmp38_;
	GearyEmailIdentifier* _tmp39_;
	GearyImapUID* _tmp40_;
	GearyImapUID* _tmp41_;
	GearyImapUID* _tmp42_;
	GearyImapUID* _tmp43_;
	GearyImapEngineMinimalFolder* _tmp44_;
	GearyImapDBFolder* _tmp45_;
	GearyImapDBFolder* _tmp46_;
	GearyImapDBEmailIdentifier* _tmp47_;
	GCancellable* _tmp48_;
	GearyImapUID* _tmp49_;
	GearyImapUID* _tmp50_;
	GearyImapUID* _tmp51_;
	GearyImapDBEmailIdentifier* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	GearyImapEngineMinimalFolder* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	GError* _tmp58_;
	GError* _tmp59_;
	GError* _inner_error0_;
};

struct _GearyContactHarvesterIface {
	GTypeInterface parent_iface;
	void (*harvest_from_email) (GearyContactHarvester* self, GeeCollection* messages, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*harvest_from_email_finish) (GearyContactHarvester* self, GAsyncResult* _res_, GError** error);
};

struct _GearyImapEngineFetchEmailReplayRemoteAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineFetchEmail* self;
	GearyImapFolderSession* remote;
	GearyImapDBEmailIdentifier* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GearyImapEngineMinimalFolder* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _tmp6_;
	GError* _tmp7_;
	GeeList* list;
	GearyImapUID* _tmp8_;
	GearyImapMessageSet* _tmp9_;
	GearyImapMessageSet* _tmp10_;
	GCancellable* _tmp11_;
	GeeList* _tmp12_;
	GeeList* _tmp13_;
	gboolean _tmp14_;
	GeeList* _tmp15_;
	GeeList* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	GearyImapDBEmailIdentifier* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GearyImapEngineMinimalFolder* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GError* _tmp25_;
	GError* _tmp26_;
	GeeMap* created_or_merged;
	GearyImapEngineMinimalFolder* _tmp27_;
	GearyImapDBFolder* _tmp28_;
	GearyImapDBFolder* _tmp29_;
	GeeList* _tmp30_;
	GearyImapEngineMinimalFolder* _tmp31_;
	GearyContactHarvester* _tmp32_;
	GearyContactHarvester* _tmp33_;
	GCancellable* _tmp34_;
	GeeMap* _tmp35_;
	GearyEmail* email;
	GeeList* _tmp36_;
	gpointer _tmp37_;
	GeeMap* _tmp38_;
	GearyEmail* _tmp39_;
	gpointer _tmp40_;
	GeeCollection* ids;
	GearyEmail* _tmp41_;
	GearyEmailIdentifier* _tmp42_;
	GearyEmailIdentifier* _tmp43_;
	GearyIterable* _tmp44_;
	GearyIterable* _tmp45_;
	GeeArrayList* _tmp46_;
	GeeCollection* _tmp47_;
	GearyImapEngineMinimalFolder* _tmp48_;
	GeeCollection* _tmp49_;
	GearyImapEngineMinimalFolder* _tmp50_;
	GeeCollection* _tmp51_;
	GearyEmail* _tmp52_;
	GearyImapEngineMinimalFolder* _tmp53_;
	GearyImapDBFolder* _tmp54_;
	GearyImapDBFolder* _tmp55_;
	GearyImapDBEmailIdentifier* _tmp56_;
	GCancellable* _tmp57_;
	GearyEmail* _tmp58_;
	GearyEmail* _tmp59_;
	GError* _inner_error0_;
};

static gint GearyImapEngineFetchEmail_private_offset;
static gpointer geary_imap_engine_fetch_email_parent_class = NULL;

VALA_EXTERN GType geary_imap_engine_replay_operation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_db_email_identifier_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_replay_operation_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_folder_session_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_send_replay_operation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_fetch_email_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_minimal_folder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void geary_imap_engine_replay_operation_notify_remote_removed_ids (GearyImapEngineReplayOperation* self,
                                                                   GeeCollection* ids);
VALA_EXTERN void geary_imap_engine_replay_operation_replay_local_async (GearyImapEngineReplayOperation* self,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_);
VALA_EXTERN GearyImapEngineReplayOperationStatus geary_imap_engine_replay_operation_replay_local_finish (GearyImapEngineReplayOperation* self,
                                                                                             GAsyncResult* _res_,
                                                                                             GError** error);
VALA_EXTERN void geary_imap_engine_replay_operation_replay_remote_async (GearyImapEngineReplayOperation* self,
                                                             GearyImapFolderSession* remote,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
VALA_EXTERN void geary_imap_engine_replay_operation_replay_remote_finish (GearyImapEngineReplayOperation* self,
                                                              GAsyncResult* _res_,
                                                              GError** error);
VALA_EXTERN gchar* geary_imap_engine_replay_operation_describe_state (GearyImapEngineReplayOperation* self);
VALA_EXTERN GearyImapEngineFetchEmail* geary_imap_engine_fetch_email_new (GearyImapEngineMinimalFolder* engine,
                                                              GearyImapDBEmailIdentifier* id,
                                                              GearyEmailField required_fields,
                                                              GearyFolderListFlags flags,
                                                              GCancellable* cancellable);
VALA_EXTERN GearyImapEngineFetchEmail* geary_imap_engine_fetch_email_construct (GType object_type,
                                                                    GearyImapEngineMinimalFolder* engine,
                                                                    GearyImapDBEmailIdentifier* id,
                                                                    GearyEmailField required_fields,
                                                                    GearyFolderListFlags flags,
                                                                    GCancellable* cancellable);
VALA_EXTERN GType geary_imap_engine_replay_operation_on_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyImapEngineSendReplayOperation* geary_imap_engine_send_replay_operation_construct (GType object_type,
                                                                                       const gchar* name,
                                                                                       GearyImapEngineReplayOperationOnError on_remote_error);
static void geary_imap_engine_fetch_email_real_notify_remote_removed_ids (GearyImapEngineReplayOperation* base,
                                                                   GeeCollection* ids);
static void geary_imap_engine_fetch_email_real_replay_local_async_data_free (gpointer _data);
static void geary_imap_engine_fetch_email_real_replay_local_async (GearyImapEngineReplayOperation* base,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_);
static gboolean geary_imap_engine_fetch_email_real_replay_local_async_co (GearyImapEngineFetchEmailReplayLocalAsyncData* _data_);
VALA_EXTERN GType geary_imap_db_folder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyImapDBFolder* geary_imap_engine_minimal_folder_get_local_folder (GearyImapEngineMinimalFolder* self);
VALA_EXTERN GType geary_imap_db_folder_list_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void geary_imap_db_folder_get_uid_async (GearyImapDBFolder* self,
                                         GearyImapDBEmailIdentifier* id,
                                         GearyImapDBFolderListFlags flags,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
VALA_EXTERN GearyImapUID* geary_imap_db_folder_get_uid_finish (GearyImapDBFolder* self,
                                                   GAsyncResult* _res_,
                                                   GError** error);
static void geary_imap_engine_fetch_email_replay_local_async_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
VALA_EXTERN void geary_imap_db_folder_fetch_email_async (GearyImapDBFolder* self,
                                             GearyImapDBEmailIdentifier* id,
                                             GearyEmailField required_fields,
                                             GearyImapDBFolderListFlags flags,
                                             GCancellable* cancellable,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN GearyEmail* geary_imap_db_folder_fetch_email_finish (GearyImapDBFolder* self,
                                                     GAsyncResult* _res_,
                                                     GError** error);
VALA_EXTERN gchar* geary_imap_engine_replay_operation_to_string (GearyImapEngineReplayOperation* self);
VALA_EXTERN GearyImapUID* geary_imap_db_email_identifier_get_uid (GearyImapDBEmailIdentifier* self);
static void geary_imap_engine_fetch_email_real_replay_remote_async_data_free (gpointer _data);
static void geary_imap_engine_fetch_email_real_replay_remote_async (GearyImapEngineReplayOperation* base,
                                                             GearyImapFolderSession* remote,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static gboolean geary_imap_engine_fetch_email_real_replay_remote_async_co (GearyImapEngineFetchEmailReplayRemoteAsyncData* _data_);
VALA_EXTERN void geary_imap_folder_session_list_email_async (GearyImapFolderSession* self,
                                                 GearyImapMessageSet* msg_set,
                                                 GearyEmailField fields,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
VALA_EXTERN GeeList* geary_imap_folder_session_list_email_finish (GearyImapFolderSession* self,
                                                      GAsyncResult* _res_,
                                                      GError** error);
static void geary_imap_engine_fetch_email_replay_remote_async_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_);
VALA_EXTERN GType geary_contact_harvester_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void geary_imap_db_folder_create_or_merge_email_async (GearyImapDBFolder* self,
                                                       GeeCollection* emails,
                                                       gboolean update_totals,
                                                       GearyContactHarvester* harvester,
                                                       GCancellable* cancellable,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
VALA_EXTERN GeeMap* geary_imap_db_folder_create_or_merge_email_finish (GearyImapDBFolder* self,
                                                           GAsyncResult* _res_,
                                                           GError** error);
VALA_EXTERN GearyContactHarvester* geary_imap_engine_minimal_folder_get_harvester (GearyImapEngineMinimalFolder* self);
VALA_EXTERN void geary_imap_engine_minimal_folder_replay_notify_email_inserted (GearyImapEngineMinimalFolder* self,
                                                                    GeeCollection* ids);
VALA_EXTERN void geary_imap_engine_minimal_folder_replay_notify_email_locally_inserted (GearyImapEngineMinimalFolder* self,
                                                                            GeeCollection* ids);
static gchar* geary_imap_engine_fetch_email_real_describe_state (GearyImapEngineReplayOperation* base);
static void geary_imap_engine_fetch_email_finalize (GObject * obj);
static GType geary_imap_engine_fetch_email_get_type_once (void);

static inline gpointer
geary_imap_engine_fetch_email_get_instance_private (GearyImapEngineFetchEmail* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapEngineFetchEmail_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyImapEngineFetchEmail*
geary_imap_engine_fetch_email_construct (GType object_type,
                                         GearyImapEngineMinimalFolder* engine,
                                         GearyImapDBEmailIdentifier* id,
                                         GearyEmailField required_fields,
                                         GearyFolderListFlags flags,
                                         GCancellable* cancellable)
{
	GearyImapEngineFetchEmail * self = NULL;
	GearyImapEngineMinimalFolder* _tmp0_;
	GearyImapDBEmailIdentifier* _tmp1_;
	GCancellable* _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER (engine), NULL);
	g_return_val_if_fail (GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER (id), NULL);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	self = (GearyImapEngineFetchEmail*) geary_imap_engine_send_replay_operation_construct (object_type, "FetchEmail", GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_RETRY);
	_tmp0_ = _g_object_ref0 (engine);
	_g_object_unref0 (self->priv->engine);
	self->priv->engine = _tmp0_;
	_tmp1_ = _g_object_ref0 (id);
	_g_object_unref0 (self->priv->id);
	self->priv->id = _tmp1_;
	self->priv->required_fields = required_fields;
	self->priv->flags = flags;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp2_;
	if (!geary_folder_list_flags_is_all_set (flags, GEARY_FOLDER_LIST_FLAGS_LOCAL_ONLY)) {
		_tmp3_ = !geary_folder_list_flags_is_all_set (flags, GEARY_FOLDER_LIST_FLAGS_FORCE_UPDATE);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		self->priv->required_fields = self->priv->required_fields | GEARY_IMAP_DB_FOLDER_REQUIRED_FIELDS;
	}
	self->priv->remaining_fields = required_fields;
	return self;
}

GearyImapEngineFetchEmail*
geary_imap_engine_fetch_email_new (GearyImapEngineMinimalFolder* engine,
                                   GearyImapDBEmailIdentifier* id,
                                   GearyEmailField required_fields,
                                   GearyFolderListFlags flags,
                                   GCancellable* cancellable)
{
	return geary_imap_engine_fetch_email_construct (GEARY_IMAP_ENGINE_TYPE_FETCH_EMAIL, engine, id, required_fields, flags, cancellable);
}

static void
geary_imap_engine_fetch_email_real_notify_remote_removed_ids (GearyImapEngineReplayOperation* base,
                                                              GeeCollection* ids)
{
	GearyImapEngineFetchEmail * self;
	GearyImapDBEmailIdentifier* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_FETCH_EMAIL, GearyImapEngineFetchEmail);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
	_tmp0_ = self->priv->id;
	self->priv->remote_removed = gee_collection_contains (ids, _tmp0_);
}

static void
geary_imap_engine_fetch_email_real_replay_local_async_data_free (gpointer _data)
{
	GearyImapEngineFetchEmailReplayLocalAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapEngineFetchEmailReplayLocalAsyncData, _data_);
}

static void
geary_imap_engine_fetch_email_real_replay_local_async (GearyImapEngineReplayOperation* base,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_)
{
	GearyImapEngineFetchEmail * self;
	GearyImapEngineFetchEmailReplayLocalAsyncData* _data_;
	GearyImapEngineFetchEmail* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_FETCH_EMAIL, GearyImapEngineFetchEmail);
	_data_ = g_slice_new0 (GearyImapEngineFetchEmailReplayLocalAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_fetch_email_real_replay_local_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	geary_imap_engine_fetch_email_real_replay_local_async_co (_data_);
}

static GearyImapEngineReplayOperationStatus
geary_imap_engine_fetch_email_replay_local_finish (GearyImapEngineReplayOperation* base,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	GearyImapEngineReplayOperationStatus result;
	GearyImapEngineFetchEmailReplayLocalAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return 0;
	}
	result = _data_->result;
	return result;
}

static void
geary_imap_engine_fetch_email_replay_local_async_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	GearyImapEngineFetchEmailReplayLocalAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_engine_fetch_email_real_replay_local_async_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
geary_imap_engine_fetch_email_real_replay_local_async_co (GearyImapEngineFetchEmailReplayLocalAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (geary_folder_list_flags_is_all_set (_data_->self->priv->flags, GEARY_FOLDER_LIST_FLAGS_FORCE_UPDATE)) {
		_data_->_tmp1_ = _data_->self->priv->engine;
		_data_->_tmp2_ = geary_imap_engine_minimal_folder_get_local_folder (_data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = _data_->self->priv->id;
		_data_->_tmp5_ = _data_->self->priv->cancellable;
		_data_->_state_ = 1;
		geary_imap_db_folder_get_uid_async (_data_->_tmp3_, _data_->_tmp4_, GEARY_IMAP_DB_FOLDER_LIST_FLAGS_NONE, _data_->_tmp5_, geary_imap_engine_fetch_email_replay_local_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp6_ = geary_imap_db_folder_get_uid_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp7_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->uid);
		_data_->self->priv->uid = _data_->_tmp7_;
		_data_->result = GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_CONTINUE;
		_g_object_unref0 (_data_->_tmp0_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->local_only = geary_folder_list_flags_is_all_set (_data_->self->priv->flags, GEARY_FOLDER_LIST_FLAGS_LOCAL_ONLY);
	_data_->email = NULL;
	{
		_data_->_tmp9_ = _data_->self->priv->engine;
		_data_->_tmp10_ = geary_imap_engine_minimal_folder_get_local_folder (_data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp12_ = _data_->self->priv->id;
		_data_->_tmp13_ = _data_->self->priv->cancellable;
		_data_->_state_ = 2;
		geary_imap_db_folder_fetch_email_async (_data_->_tmp11_, _data_->_tmp12_, _data_->self->priv->required_fields, GEARY_IMAP_DB_FOLDER_LIST_FLAGS_PARTIAL_OK, _data_->_tmp13_, geary_imap_engine_fetch_email_replay_local_async_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp14_ = geary_imap_db_folder_fetch_email_finish (_data_->_tmp11_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp8_ = _data_->_tmp14_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			if (g_error_matches (_data_->_inner_error0_, GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_NOT_FOUND)) {
				goto __catch0_geary_engine_error_not_found;
			}
			goto __finally0;
		}
		_data_->_tmp15_ = _data_->_tmp8_;
		_data_->_tmp8_ = NULL;
		_g_object_unref0 (_data_->email);
		_data_->email = _data_->_tmp15_;
		_g_object_unref0 (_data_->_tmp8_);
	}
	goto __finally0;
	__catch0_geary_engine_error_not_found:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		if (_data_->local_only) {
			_data_->_tmp16_ = _data_->err;
			_data_->_tmp17_ = _g_error_copy0 (_data_->_tmp16_);
			_data_->_inner_error0_ = _data_->_tmp17_;
			_g_error_free0 (_data_->err);
			goto __finally0;
		}
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->email);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp19_ = _data_->email;
	if (_data_->_tmp19_ != NULL) {
		_data_->_tmp20_ = _data_->email;
		_data_->_tmp21_ = geary_email_get_fields (_data_->_tmp20_);
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp18_ = geary_email_field_fulfills (_data_->_tmp22_, _data_->self->priv->required_fields);
	} else {
		_data_->_tmp18_ = FALSE;
	}
	if (_data_->_tmp18_) {
		_data_->_tmp23_ = _data_->email;
		_data_->_tmp24_ = _g_object_ref0 (_data_->_tmp23_);
		_g_object_unref0 (_data_->self->email);
		_data_->self->email = _data_->_tmp24_;
		_data_->self->priv->remaining_fields = GEARY_EMAIL_FIELD_NONE;
		_data_->result = GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_COMPLETED;
		_g_object_unref0 (_data_->email);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		if (_data_->local_only) {
			_data_->_tmp25_ = _data_->self->priv->id;
			_data_->_tmp26_ = geary_email_identifier_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp25_, GEARY_TYPE_EMAIL_IDENTIFIER, GearyEmailIdentifier));
			_data_->_tmp27_ = _data_->_tmp26_;
			_data_->_tmp28_ = geary_imap_engine_replay_operation_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation));
			_data_->_tmp29_ = _data_->_tmp28_;
			_data_->_tmp30_ = g_error_new (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_INCOMPLETE_MESSAGE, "Email %s with fields %Xh locally incomplete %s", _data_->_tmp27_, (guint) _data_->self->priv->required_fields, _data_->_tmp29_);
			_data_->_tmp31_ = _data_->_tmp30_;
			_g_free0 (_data_->_tmp29_);
			_g_free0 (_data_->_tmp27_);
			_data_->_inner_error0_ = _data_->_tmp31_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->email);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp32_ = _data_->email;
	if (_data_->_tmp32_ != NULL) {
		_data_->_tmp33_ = _data_->email;
		_data_->_tmp34_ = geary_email_get_fields (_data_->_tmp33_);
		_data_->_tmp35_ = _data_->_tmp34_;
		_data_->self->priv->remaining_fields = geary_email_field_clear (_data_->self->priv->required_fields, _data_->_tmp35_);
	} else {
		_data_->self->priv->remaining_fields = _data_->self->priv->required_fields;
	}
	_vala_assert (_data_->self->priv->remaining_fields != 0, "remaining_fields != 0");
	_data_->_tmp36_ = _data_->email;
	if (_data_->_tmp36_ != NULL) {
		_data_->_tmp37_ = _data_->email;
		_data_->_tmp38_ = geary_email_get_id (_data_->_tmp37_);
		_data_->_tmp39_ = _data_->_tmp38_;
		_data_->_tmp40_ = geary_imap_db_email_identifier_get_uid (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp39_, GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifier));
		_data_->_tmp41_ = _data_->_tmp40_;
		_data_->_tmp42_ = _g_object_ref0 (_data_->_tmp41_);
		_g_object_unref0 (_data_->self->priv->uid);
		_data_->self->priv->uid = _data_->_tmp42_;
	} else {
		_data_->_tmp44_ = _data_->self->priv->engine;
		_data_->_tmp45_ = geary_imap_engine_minimal_folder_get_local_folder (_data_->_tmp44_);
		_data_->_tmp46_ = _data_->_tmp45_;
		_data_->_tmp47_ = _data_->self->priv->id;
		_data_->_tmp48_ = _data_->self->priv->cancellable;
		_data_->_state_ = 3;
		geary_imap_db_folder_get_uid_async (_data_->_tmp46_, _data_->_tmp47_, GEARY_IMAP_DB_FOLDER_LIST_FLAGS_NONE, _data_->_tmp48_, geary_imap_engine_fetch_email_replay_local_async_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp49_ = geary_imap_db_folder_get_uid_finish (_data_->_tmp46_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp43_ = _data_->_tmp49_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->email);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp50_ = _data_->_tmp43_;
		_data_->_tmp43_ = NULL;
		_g_object_unref0 (_data_->self->priv->uid);
		_data_->self->priv->uid = _data_->_tmp50_;
		_g_object_unref0 (_data_->_tmp43_);
	}
	_data_->_tmp51_ = _data_->self->priv->uid;
	if (_data_->_tmp51_ == NULL) {
		_data_->_tmp52_ = _data_->self->priv->id;
		_data_->_tmp53_ = geary_email_identifier_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp52_, GEARY_TYPE_EMAIL_IDENTIFIER, GearyEmailIdentifier));
		_data_->_tmp54_ = _data_->_tmp53_;
		_data_->_tmp55_ = _data_->self->priv->engine;
		_data_->_tmp56_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp55_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_data_->_tmp57_ = _data_->_tmp56_;
		_data_->_tmp58_ = g_error_new (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_NOT_FOUND, "Unable to find %s in %s", _data_->_tmp54_, _data_->_tmp57_);
		_data_->_tmp59_ = _data_->_tmp58_;
		_g_free0 (_data_->_tmp57_);
		_g_free0 (_data_->_tmp54_);
		_data_->_inner_error0_ = _data_->_tmp59_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->email);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_CONTINUE;
	_g_object_unref0 (_data_->email);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_engine_fetch_email_real_replay_remote_async_data_free (gpointer _data)
{
	GearyImapEngineFetchEmailReplayRemoteAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->remote);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapEngineFetchEmailReplayRemoteAsyncData, _data_);
}

static void
geary_imap_engine_fetch_email_real_replay_remote_async (GearyImapEngineReplayOperation* base,
                                                        GearyImapFolderSession* remote,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	GearyImapEngineFetchEmail * self;
	GearyImapEngineFetchEmailReplayRemoteAsyncData* _data_;
	GearyImapEngineFetchEmail* _tmp0_;
	GearyImapFolderSession* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_FOLDER_SESSION (remote));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_FETCH_EMAIL, GearyImapEngineFetchEmail);
	_data_ = g_slice_new0 (GearyImapEngineFetchEmailReplayRemoteAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_fetch_email_real_replay_remote_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (remote);
	_g_object_unref0 (_data_->remote);
	_data_->remote = _tmp1_;
	geary_imap_engine_fetch_email_real_replay_remote_async_co (_data_);
}

static void
geary_imap_engine_fetch_email_replay_remote_finish (GearyImapEngineReplayOperation* base,
                                                    GAsyncResult* _res_,
                                                    GError** error)
{
	GearyImapEngineFetchEmailReplayRemoteAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_imap_engine_fetch_email_replay_remote_async_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_)
{
	GearyImapEngineFetchEmailReplayRemoteAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_engine_fetch_email_real_replay_remote_async_co (_data_);
}

static gboolean
geary_imap_engine_fetch_email_real_replay_remote_async_co (GearyImapEngineFetchEmailReplayRemoteAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->self->priv->remote_removed) {
		_data_->_tmp0_ = _data_->self->priv->id;
		_data_->_tmp1_ = geary_email_identifier_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_TYPE_EMAIL_IDENTIFIER, GearyEmailIdentifier));
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = _data_->self->priv->engine;
		_data_->_tmp4_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = g_error_new (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_NOT_FOUND, "Unable to fetch %s in %s (removed from remote)", _data_->_tmp2_, _data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_g_free0 (_data_->_tmp5_);
		_g_free0 (_data_->_tmp2_);
		_data_->_inner_error0_ = _data_->_tmp7_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->self->priv->uid;
	_data_->_tmp9_ = geary_imap_message_set_new_uid (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = _data_->self->priv->cancellable;
	_data_->_state_ = 1;
	geary_imap_folder_session_list_email_async (_data_->remote, _data_->_tmp10_, _data_->self->priv->remaining_fields, _data_->_tmp11_, geary_imap_engine_fetch_email_replay_remote_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp12_ = geary_imap_folder_session_list_email_finish (_data_->remote, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp13_ = _data_->_tmp12_;
	_g_object_unref0 (_data_->_tmp10_);
	_data_->list = _data_->_tmp13_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp15_ = _data_->list;
	if (_data_->_tmp15_ == NULL) {
		_data_->_tmp14_ = TRUE;
	} else {
		_data_->_tmp16_ = _data_->list;
		_data_->_tmp17_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp16_, GEE_TYPE_COLLECTION, GeeCollection));
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp14_ = _data_->_tmp18_ != 1;
	}
	if (_data_->_tmp14_) {
		_data_->_tmp19_ = _data_->self->priv->id;
		_data_->_tmp20_ = geary_email_identifier_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp19_, GEARY_TYPE_EMAIL_IDENTIFIER, GearyEmailIdentifier));
		_data_->_tmp21_ = _data_->_tmp20_;
		_data_->_tmp22_ = _data_->self->priv->engine;
		_data_->_tmp23_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp22_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_data_->_tmp24_ = _data_->_tmp23_;
		_data_->_tmp25_ = g_error_new (GEARY_ENGINE_ERROR, GEARY_ENGINE_ERROR_NOT_FOUND, "Unable to fetch %s in %s", _data_->_tmp21_, _data_->_tmp24_);
		_data_->_tmp26_ = _data_->_tmp25_;
		_g_free0 (_data_->_tmp24_);
		_g_free0 (_data_->_tmp21_);
		_data_->_inner_error0_ = _data_->_tmp26_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->list);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp27_ = _data_->self->priv->engine;
	_data_->_tmp28_ = geary_imap_engine_minimal_folder_get_local_folder (_data_->_tmp27_);
	_data_->_tmp29_ = _data_->_tmp28_;
	_data_->_tmp30_ = _data_->list;
	_data_->_tmp31_ = _data_->self->priv->engine;
	_data_->_tmp32_ = geary_imap_engine_minimal_folder_get_harvester (_data_->_tmp31_);
	_data_->_tmp33_ = _data_->_tmp32_;
	_data_->_tmp34_ = _data_->self->priv->cancellable;
	_data_->_state_ = 2;
	geary_imap_db_folder_create_or_merge_email_async (_data_->_tmp29_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp30_, GEE_TYPE_COLLECTION, GeeCollection), TRUE, _data_->_tmp33_, _data_->_tmp34_, geary_imap_engine_fetch_email_replay_remote_async_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp35_ = geary_imap_db_folder_create_or_merge_email_finish (_data_->_tmp29_, _data_->_res_, &_data_->_inner_error0_);
	_data_->created_or_merged = _data_->_tmp35_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->list);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp36_ = _data_->list;
	_data_->_tmp37_ = gee_list_get (_data_->_tmp36_, 0);
	_data_->email = (GearyEmail*) _data_->_tmp37_;
	_data_->_tmp38_ = _data_->created_or_merged;
	_data_->_tmp39_ = _data_->email;
	_data_->_tmp40_ = gee_map_get (_data_->_tmp38_, _data_->_tmp39_);
	if ((gboolean) ((gintptr) _data_->_tmp40_)) {
		_data_->_tmp41_ = _data_->email;
		_data_->_tmp42_ = geary_email_get_id (_data_->_tmp41_);
		_data_->_tmp43_ = _data_->_tmp42_;
		_data_->_tmp44_ = geary_iterate (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->_tmp43_, NULL);
		_data_->_tmp45_ = _data_->_tmp44_;
		_data_->_tmp46_ = geary_iterable_to_array_list (_data_->_tmp45_, NULL, NULL, NULL);
		_data_->_tmp47_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp46_, GEE_TYPE_COLLECTION, GeeCollection);
		_g_object_unref0 (_data_->_tmp45_);
		_data_->ids = _data_->_tmp47_;
		_data_->_tmp48_ = _data_->self->priv->engine;
		_data_->_tmp49_ = _data_->ids;
		geary_imap_engine_minimal_folder_replay_notify_email_inserted (_data_->_tmp48_, _data_->_tmp49_);
		_data_->_tmp50_ = _data_->self->priv->engine;
		_data_->_tmp51_ = _data_->ids;
		geary_imap_engine_minimal_folder_replay_notify_email_locally_inserted (_data_->_tmp50_, _data_->_tmp51_);
		_g_object_unref0 (_data_->ids);
	}
	_data_->_tmp53_ = _data_->self->priv->engine;
	_data_->_tmp54_ = geary_imap_engine_minimal_folder_get_local_folder (_data_->_tmp53_);
	_data_->_tmp55_ = _data_->_tmp54_;
	_data_->_tmp56_ = _data_->self->priv->id;
	_data_->_tmp57_ = _data_->self->priv->cancellable;
	_data_->_state_ = 3;
	geary_imap_db_folder_fetch_email_async (_data_->_tmp55_, _data_->_tmp56_, _data_->self->priv->required_fields, GEARY_IMAP_DB_FOLDER_LIST_FLAGS_NONE, _data_->_tmp57_, geary_imap_engine_fetch_email_replay_remote_async_ready, _data_);
	return FALSE;
	_state_3:
	_data_->_tmp58_ = geary_imap_db_folder_fetch_email_finish (_data_->_tmp55_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp52_ = _data_->_tmp58_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->email);
		_g_object_unref0 (_data_->created_or_merged);
		_g_object_unref0 (_data_->list);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp59_ = _data_->_tmp52_;
	_data_->_tmp52_ = NULL;
	_g_object_unref0 (_data_->self->email);
	_data_->self->email = _data_->_tmp59_;
	_g_object_unref0 (_data_->_tmp52_);
	_g_object_unref0 (_data_->email);
	_g_object_unref0 (_data_->created_or_merged);
	_g_object_unref0 (_data_->list);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static gchar*
geary_imap_engine_fetch_email_real_describe_state (GearyImapEngineReplayOperation* base)
{
	GearyImapEngineFetchEmail * self;
	GearyImapDBEmailIdentifier* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GearyEmail* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_FETCH_EMAIL, GearyImapEngineFetchEmail);
	_tmp0_ = self->priv->id;
	_tmp1_ = geary_email_identifier_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_TYPE_EMAIL_IDENTIFIER, GearyEmailIdentifier));
	_tmp2_ = _tmp1_;
	_tmp3_ = self->email;
	_tmp4_ = bool_to_string (_tmp3_ == NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("id=%s required_fields=%Xh remaining_fields=%Xh flags=%Xh has_email=%s", _tmp2_, (guint) self->priv->required_fields, (guint) self->priv->remaining_fields, (guint) self->priv->flags, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	result = _tmp7_;
	return result;
}

static void
geary_imap_engine_fetch_email_class_init (GearyImapEngineFetchEmailClass * klass,
                                          gpointer klass_data)
{
	geary_imap_engine_fetch_email_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapEngineFetchEmail_private_offset);
	((GearyImapEngineReplayOperationClass *) klass)->notify_remote_removed_ids = (void (*) (GearyImapEngineReplayOperation*, GeeCollection*)) geary_imap_engine_fetch_email_real_notify_remote_removed_ids;
	((GearyImapEngineReplayOperationClass *) klass)->replay_local_async = (void (*) (GearyImapEngineReplayOperation*, GAsyncReadyCallback, gpointer)) geary_imap_engine_fetch_email_real_replay_local_async;
	((GearyImapEngineReplayOperationClass *) klass)->replay_local_finish = (GearyImapEngineReplayOperationStatus (*) (GearyImapEngineReplayOperation*, GAsyncResult*, GError**)) geary_imap_engine_fetch_email_replay_local_finish;
	((GearyImapEngineReplayOperationClass *) klass)->replay_remote_async = (void (*) (GearyImapEngineReplayOperation*, GearyImapFolderSession*, GAsyncReadyCallback, gpointer)) geary_imap_engine_fetch_email_real_replay_remote_async;
	((GearyImapEngineReplayOperationClass *) klass)->replay_remote_finish = (void (*) (GearyImapEngineReplayOperation*, GAsyncResult*, GError**)) geary_imap_engine_fetch_email_replay_remote_finish;
	((GearyImapEngineReplayOperationClass *) klass)->describe_state = (gchar* (*) (GearyImapEngineReplayOperation*)) geary_imap_engine_fetch_email_real_describe_state;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_engine_fetch_email_finalize;
}

static void
geary_imap_engine_fetch_email_instance_init (GearyImapEngineFetchEmail * self,
                                             gpointer klass)
{
	self->priv = geary_imap_engine_fetch_email_get_instance_private (self);
	self->email = NULL;
	self->priv->uid = NULL;
	self->priv->remote_removed = FALSE;
}

static void
geary_imap_engine_fetch_email_finalize (GObject * obj)
{
	GearyImapEngineFetchEmail * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_ENGINE_TYPE_FETCH_EMAIL, GearyImapEngineFetchEmail);
	_g_object_unref0 (self->email);
	_g_object_unref0 (self->priv->engine);
	_g_object_unref0 (self->priv->id);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->uid);
	G_OBJECT_CLASS (geary_imap_engine_fetch_email_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_imap_engine_fetch_email_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapEngineFetchEmailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_engine_fetch_email_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapEngineFetchEmail), 0, (GInstanceInitFunc) geary_imap_engine_fetch_email_instance_init, NULL };
	GType geary_imap_engine_fetch_email_type_id;
	geary_imap_engine_fetch_email_type_id = g_type_register_static (GEARY_IMAP_ENGINE_TYPE_SEND_REPLAY_OPERATION, "GearyImapEngineFetchEmail", &g_define_type_info, 0);
	GearyImapEngineFetchEmail_private_offset = g_type_add_instance_private (geary_imap_engine_fetch_email_type_id, sizeof (GearyImapEngineFetchEmailPrivate));
	return geary_imap_engine_fetch_email_type_id;
}

GType
geary_imap_engine_fetch_email_get_type (void)
{
	static gsize geary_imap_engine_fetch_email_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_engine_fetch_email_type_id__once)) {
		GType geary_imap_engine_fetch_email_type_id;
		geary_imap_engine_fetch_email_type_id = geary_imap_engine_fetch_email_get_type_once ();
		g_once_init_leave (&geary_imap_engine_fetch_email_type_id__once, geary_imap_engine_fetch_email_type_id);
	}
	return geary_imap_engine_fetch_email_type_id__once;
}

