/* imap-engine-replay-removal.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-engine-replay-removal.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION (geary_imap_engine_replay_operation_get_type ())
#define GEARY_IMAP_ENGINE_REPLAY_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation))
#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperationClass))
#define GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION))
#define GEARY_IMAP_ENGINE_IS_REPLAY_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION))
#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperationClass))

typedef struct _GearyImapEngineReplayOperation GearyImapEngineReplayOperation;
typedef struct _GearyImapEngineReplayOperationClass GearyImapEngineReplayOperationClass;
typedef struct _GearyImapEngineReplayOperationPrivate GearyImapEngineReplayOperationPrivate;

#define GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER (geary_imap_db_email_identifier_get_type ())
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifier))
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifierClass))
#define GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER))
#define GEARY_IMAP_DB_IS_EMAIL_IDENTIFIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER))
#define GEARY_IMAP_DB_EMAIL_IDENTIFIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, GearyImapDBEmailIdentifierClass))

typedef struct _GearyImapDBEmailIdentifier GearyImapDBEmailIdentifier;
typedef struct _GearyImapDBEmailIdentifierClass GearyImapDBEmailIdentifierClass;
typedef enum  {
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_COMPLETED,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_STATUS_CONTINUE
} GearyImapEngineReplayOperationStatus;

#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_TYPE_STATUS (geary_imap_engine_replay_operation_status_get_type ())

#define GEARY_IMAP_TYPE_FOLDER_SESSION (geary_imap_folder_session_get_type ())
#define GEARY_IMAP_FOLDER_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSession))
#define GEARY_IMAP_FOLDER_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSessionClass))
#define GEARY_IMAP_IS_FOLDER_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION))
#define GEARY_IMAP_IS_FOLDER_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_TYPE_FOLDER_SESSION))
#define GEARY_IMAP_FOLDER_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_TYPE_FOLDER_SESSION, GearyImapFolderSessionClass))

typedef struct _GearyImapFolderSession GearyImapFolderSession;
typedef struct _GearyImapFolderSessionClass GearyImapFolderSessionClass;

#define GEARY_IMAP_ENGINE_TYPE_REPLAY_REMOVAL (geary_imap_engine_replay_removal_get_type ())
#define GEARY_IMAP_ENGINE_REPLAY_REMOVAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_REMOVAL, GearyImapEngineReplayRemoval))
#define GEARY_IMAP_ENGINE_REPLAY_REMOVAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_REPLAY_REMOVAL, GearyImapEngineReplayRemovalClass))
#define GEARY_IMAP_ENGINE_IS_REPLAY_REMOVAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_REMOVAL))
#define GEARY_IMAP_ENGINE_IS_REPLAY_REMOVAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_REPLAY_REMOVAL))
#define GEARY_IMAP_ENGINE_REPLAY_REMOVAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_REMOVAL, GearyImapEngineReplayRemovalClass))

typedef struct _GearyImapEngineReplayRemoval GearyImapEngineReplayRemoval;
typedef struct _GearyImapEngineReplayRemovalClass GearyImapEngineReplayRemovalClass;
typedef struct _GearyImapEngineReplayRemovalPrivate GearyImapEngineReplayRemovalPrivate;

#define GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER (geary_imap_engine_minimal_folder_get_type ())
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolder))
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolderClass))
#define GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER))
#define GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER))
#define GEARY_IMAP_ENGINE_MINIMAL_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_MINIMAL_FOLDER, GearyImapEngineMinimalFolderClass))

typedef struct _GearyImapEngineMinimalFolder GearyImapEngineMinimalFolder;
typedef struct _GearyImapEngineMinimalFolderClass GearyImapEngineMinimalFolderClass;
enum  {
	GEARY_IMAP_ENGINE_REPLAY_REMOVAL_0_PROPERTY,
	GEARY_IMAP_ENGINE_REPLAY_REMOVAL_NUM_PROPERTIES
};
static GParamSpec* geary_imap_engine_replay_removal_properties[GEARY_IMAP_ENGINE_REPLAY_REMOVAL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_LOCAL_AND_REMOTE,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_LOCAL_ONLY,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_REMOTE_ONLY
} GearyImapEngineReplayOperationScope;

#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_TYPE_SCOPE (geary_imap_engine_replay_operation_scope_get_type ())
typedef enum  {
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_THROW,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_RETRY,
	GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_IGNORE_REMOTE
} GearyImapEngineReplayOperationOnError;

#define GEARY_IMAP_ENGINE_REPLAY_OPERATION_TYPE_ON_ERROR (geary_imap_engine_replay_operation_on_error_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GearyImapEngineReplayRemovalReplayRemoteAsyncData GearyImapEngineReplayRemovalReplayRemoteAsyncData;

#define GEARY_IMAP_DB_TYPE_FOLDER (geary_imap_db_folder_get_type ())
#define GEARY_IMAP_DB_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_DB_TYPE_FOLDER, GearyImapDBFolder))
#define GEARY_IMAP_DB_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_DB_TYPE_FOLDER, GearyImapDBFolderClass))
#define GEARY_IMAP_DB_IS_FOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_DB_TYPE_FOLDER))
#define GEARY_IMAP_DB_IS_FOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_DB_TYPE_FOLDER))
#define GEARY_IMAP_DB_FOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_DB_TYPE_FOLDER, GearyImapDBFolderClass))

typedef struct _GearyImapDBFolder GearyImapDBFolder;
typedef struct _GearyImapDBFolderClass GearyImapDBFolderClass;
typedef enum  {
	GEARY_IMAP_DB_FOLDER_LIST_FLAGS_NONE = 0,
	GEARY_IMAP_DB_FOLDER_LIST_FLAGS_PARTIAL_OK = 1 << 0,
	GEARY_IMAP_DB_FOLDER_LIST_FLAGS_INCLUDE_MARKED_FOR_REMOVE = 1 << 1,
	GEARY_IMAP_DB_FOLDER_LIST_FLAGS_INCLUDING_ID = 1 << 2,
	GEARY_IMAP_DB_FOLDER_LIST_FLAGS_OLDEST_TO_NEWEST = 1 << 3,
	GEARY_IMAP_DB_FOLDER_LIST_FLAGS_ONLY_INCOMPLETE = 1 << 4
} GearyImapDBFolderListFlags;

#define GEARY_IMAP_DB_FOLDER_TYPE_LIST_FLAGS (geary_imap_db_folder_list_flags_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GEARY_IMAP_ENGINE_TYPE_REPLAY_QUEUE (geary_imap_engine_replay_queue_get_type ())
#define GEARY_IMAP_ENGINE_REPLAY_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_QUEUE, GearyImapEngineReplayQueue))
#define GEARY_IMAP_ENGINE_REPLAY_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_IMAP_ENGINE_TYPE_REPLAY_QUEUE, GearyImapEngineReplayQueueClass))
#define GEARY_IMAP_ENGINE_IS_REPLAY_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_QUEUE))
#define GEARY_IMAP_ENGINE_IS_REPLAY_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_IMAP_ENGINE_TYPE_REPLAY_QUEUE))
#define GEARY_IMAP_ENGINE_REPLAY_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_IMAP_ENGINE_TYPE_REPLAY_QUEUE, GearyImapEngineReplayQueueClass))

typedef struct _GearyImapEngineReplayQueue GearyImapEngineReplayQueue;
typedef struct _GearyImapEngineReplayQueueClass GearyImapEngineReplayQueueClass;
typedef struct _GearyImapEngineReplayRemovalDoReplayRemovedMessageData GearyImapEngineReplayRemovalDoReplayRemovedMessageData;
enum  {
	GEARY_IMAP_ENGINE_REPLAY_REMOVAL_EMAIL_REMOVED_SIGNAL,
	GEARY_IMAP_ENGINE_REPLAY_REMOVAL_MARKED_EMAIL_REMOVED_SIGNAL,
	GEARY_IMAP_ENGINE_REPLAY_REMOVAL_EMAIL_COUNT_CHANGED_SIGNAL,
	GEARY_IMAP_ENGINE_REPLAY_REMOVAL_NUM_SIGNALS
};
static guint geary_imap_engine_replay_removal_signals[GEARY_IMAP_ENGINE_REPLAY_REMOVAL_NUM_SIGNALS] = {0};

struct _GearyImapEngineReplayOperation {
	GearyBaseObject parent_instance;
	GearyImapEngineReplayOperationPrivate * priv;
};

struct _GearyImapEngineReplayOperationClass {
	GearyBaseObjectClass parent_class;
	void (*notify_remote_removed_position) (GearyImapEngineReplayOperation* self, GearyImapSequenceNumber* removed);
	void (*notify_remote_removed_ids) (GearyImapEngineReplayOperation* self, GeeCollection* ids);
	void (*get_ids_to_be_remote_removed) (GearyImapEngineReplayOperation* self, GeeCollection* ids);
	void (*replay_local_async) (GearyImapEngineReplayOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GearyImapEngineReplayOperationStatus (*replay_local_finish) (GearyImapEngineReplayOperation* self, GAsyncResult* _res_, GError** error);
	void (*replay_remote_async) (GearyImapEngineReplayOperation* self, GearyImapFolderSession* remote, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*replay_remote_finish) (GearyImapEngineReplayOperation* self, GAsyncResult* _res_, GError** error);
	void (*backout_local_async) (GearyImapEngineReplayOperation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*backout_local_finish) (GearyImapEngineReplayOperation* self, GAsyncResult* _res_, GError** error);
	gchar* (*describe_state) (GearyImapEngineReplayOperation* self);
};

struct _GearyImapEngineReplayRemoval {
	GearyImapEngineReplayOperation parent_instance;
	GearyImapEngineReplayRemovalPrivate * priv;
};

struct _GearyImapEngineReplayRemovalClass {
	GearyImapEngineReplayOperationClass parent_class;
};

struct _GearyImapEngineReplayRemovalPrivate {
	GearyImapEngineMinimalFolder* owner;
	gint remote_count;
	GearyImapSequenceNumber* position;
};

struct _GearyImapEngineReplayRemovalReplayRemoteAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineReplayRemoval* self;
	GearyImapFolderSession* remote;
	GearyImapEngineMinimalFolder* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GearyImapSequenceNumber* _tmp3_;
	gint64 _tmp4_;
	gint64 _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GearyImapSequenceNumber* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
};

struct _GearyImapEngineReplayRemovalDoReplayRemovedMessageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearyImapEngineReplayRemoval* self;
	gint local_count;
	gint64 local_position;
	GearyImapDBEmailIdentifier* owned_id;
	gint _tmp0_;
	GearyImapEngineMinimalFolder* _tmp1_;
	GearyImapDBFolder* _tmp2_;
	GearyImapDBFolder* _tmp3_;
	GearyImapSequenceNumber* _tmp4_;
	gint64 _tmp5_;
	gint64 _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GearyImapDBEmailIdentifier* _tmp11_;
	GearyImapEngineMinimalFolder* _tmp12_;
	GearyImapDBFolder* _tmp13_;
	GearyImapDBFolder* _tmp14_;
	GearyImapDBEmailIdentifier* _tmp15_;
	GearyImapDBEmailIdentifier* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GError* err;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GearyImapSequenceNumber* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GError* _tmp26_;
	const gchar* _tmp27_;
	gboolean marked;
	GearyImapDBEmailIdentifier* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GearyImapDBEmailIdentifier* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GearyImapEngineMinimalFolder* _tmp34_;
	GearyImapDBFolder* _tmp35_;
	GearyImapDBFolder* _tmp36_;
	GearyImapDBEmailIdentifier* _tmp37_;
	gboolean _tmp38_;
	GError* _vala1_err;
	gchar* _tmp39_;
	gchar* _tmp40_;
	GearyImapSequenceNumber* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	GError* _tmp44_;
	const gchar* _tmp45_;
	GearyImapEngineMinimalFolder* _tmp46_;
	GearyImapEngineReplayQueue* _tmp47_;
	GearyImapEngineReplayQueue* _tmp48_;
	GearyImapDBEmailIdentifier* _tmp49_;
	GearyIterable* _tmp50_;
	GearyIterable* _tmp51_;
	GeeArrayList* _tmp52_;
	GeeArrayList* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	GearyImapSequenceNumber* _tmp56_;
	gint64 _tmp57_;
	gint64 _tmp58_;
	gint new_local_count;
	gint _tmp59_;
	GearyImapEngineMinimalFolder* _tmp60_;
	GearyImapDBFolder* _tmp61_;
	GearyImapDBFolder* _tmp62_;
	GError* _vala2_err;
	gchar* _tmp63_;
	gchar* _tmp64_;
	GError* _tmp65_;
	const gchar* _tmp66_;
	GearyImapEngineMinimalFolder* _tmp67_;
	GearyImapDBFolder* _tmp68_;
	GearyImapDBFolder* _tmp69_;
	GError* _vala3_err;
	gchar* _tmp70_;
	gchar* _tmp71_;
	GError* _tmp72_;
	const gchar* _tmp73_;
	GearyImapDBEmailIdentifier* _tmp74_;
	GeeList* removed;
	GearyImapDBEmailIdentifier* _tmp75_;
	GearyIterable* _tmp76_;
	GearyIterable* _tmp77_;
	GeeArrayList* _tmp78_;
	GeeList* _tmp79_;
	GeeList* _tmp80_;
	GeeList* _tmp81_;
	GearyImapEngineMinimalFolder* _tmp82_;
	GearyImapEngineMinimalFolder* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	GearyImapSequenceNumber* _tmp86_;
	gint64 _tmp87_;
	gint64 _tmp88_;
	gchar* _tmp89_;
	gchar* _tmp90_;
	GError* _inner_error0_;
};

static gint GearyImapEngineReplayRemoval_private_offset;
static gpointer geary_imap_engine_replay_removal_parent_class = NULL;

VALA_EXTERN GType geary_imap_engine_replay_operation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_db_email_identifier_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_replay_operation_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_folder_session_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_replay_removal_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_minimal_folder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void geary_imap_engine_replay_operation_notify_remote_removed_position (GearyImapEngineReplayOperation* self,
                                                                        GearyImapSequenceNumber* removed);
VALA_EXTERN void geary_imap_engine_replay_operation_notify_remote_removed_ids (GearyImapEngineReplayOperation* self,
                                                                   GeeCollection* ids);
VALA_EXTERN void geary_imap_engine_replay_operation_get_ids_to_be_remote_removed (GearyImapEngineReplayOperation* self,
                                                                      GeeCollection* ids);
VALA_EXTERN void geary_imap_engine_replay_operation_replay_remote_async (GearyImapEngineReplayOperation* self,
                                                             GearyImapFolderSession* remote,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
VALA_EXTERN void geary_imap_engine_replay_operation_replay_remote_finish (GearyImapEngineReplayOperation* self,
                                                              GAsyncResult* _res_,
                                                              GError** error);
VALA_EXTERN gchar* geary_imap_engine_replay_operation_describe_state (GearyImapEngineReplayOperation* self);
static void g_cclosure_user_marshal_VOID__INT_FLAGS (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
VALA_EXTERN GearyImapEngineReplayRemoval* geary_imap_engine_replay_removal_new (GearyImapEngineMinimalFolder* owner,
                                                                    gint remote_count,
                                                                    GearyImapSequenceNumber* position);
VALA_EXTERN GearyImapEngineReplayRemoval* geary_imap_engine_replay_removal_construct (GType object_type,
                                                                          GearyImapEngineMinimalFolder* owner,
                                                                          gint remote_count,
                                                                          GearyImapSequenceNumber* position);
VALA_EXTERN GType geary_imap_engine_replay_operation_scope_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType geary_imap_engine_replay_operation_on_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyImapEngineReplayOperation* geary_imap_engine_replay_operation_construct (GType object_type,
                                                                              const gchar* name,
                                                                              GearyImapEngineReplayOperationScope scope,
                                                                              GearyImapEngineReplayOperationOnError on_remote_error);
static void geary_imap_engine_replay_removal_real_notify_remote_removed_position (GearyImapEngineReplayOperation* base,
                                                                           GearyImapSequenceNumber* removed);
static void geary_imap_engine_replay_removal_real_notify_remote_removed_ids (GearyImapEngineReplayOperation* base,
                                                                      GeeCollection* ids);
static void geary_imap_engine_replay_removal_real_get_ids_to_be_remote_removed (GearyImapEngineReplayOperation* base,
                                                                         GeeCollection* ids);
static void geary_imap_engine_replay_removal_real_replay_remote_async_data_free (gpointer _data);
static void geary_imap_engine_replay_removal_real_replay_remote_async (GearyImapEngineReplayOperation* base,
                                                                GearyImapFolderSession* remote,
                                                                GAsyncReadyCallback _callback_,
                                                                gpointer _user_data_);
static gboolean geary_imap_engine_replay_removal_real_replay_remote_async_co (GearyImapEngineReplayRemovalReplayRemoteAsyncData* _data_);
static void geary_imap_engine_replay_removal_do_replay_removed_message (GearyImapEngineReplayRemoval* self,
                                                                 GAsyncReadyCallback _callback_,
                                                                 gpointer _user_data_);
static void geary_imap_engine_replay_removal_do_replay_removed_message_finish (GearyImapEngineReplayRemoval* self,
                                                                        GAsyncResult* _res_);
static void geary_imap_engine_replay_removal_replay_remote_async_ready (GObject* source_object,
                                                                 GAsyncResult* _res_,
                                                                 gpointer _user_data_);
VALA_EXTERN gchar* geary_imap_engine_replay_operation_to_string (GearyImapEngineReplayOperation* self);
static gchar* geary_imap_engine_replay_removal_real_describe_state (GearyImapEngineReplayOperation* base);
static void geary_imap_engine_replay_removal_do_replay_removed_message_data_free (gpointer _data);
static gboolean geary_imap_engine_replay_removal_do_replay_removed_message_co (GearyImapEngineReplayRemovalDoReplayRemovedMessageData* _data_);
VALA_EXTERN GType geary_imap_db_folder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyImapDBFolder* geary_imap_engine_minimal_folder_get_local_folder (GearyImapEngineMinimalFolder* self);
VALA_EXTERN GType geary_imap_db_folder_list_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void geary_imap_db_folder_get_email_count_async (GearyImapDBFolder* self,
                                                 GearyImapDBFolderListFlags flags,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
VALA_EXTERN gint geary_imap_db_folder_get_email_count_finish (GearyImapDBFolder* self,
                                                  GAsyncResult* _res_,
                                                  GError** error);
static void geary_imap_engine_replay_removal_do_replay_removed_message_ready (GObject* source_object,
                                                                       GAsyncResult* _res_,
                                                                       gpointer _user_data_);
VALA_EXTERN void geary_imap_db_folder_get_id_at_async (GearyImapDBFolder* self,
                                           gint64 pos,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN GearyImapDBEmailIdentifier* geary_imap_db_folder_get_id_at_finish (GearyImapDBFolder* self,
                                                                   GAsyncResult* _res_,
                                                                   GError** error);
VALA_EXTERN void geary_imap_db_folder_detach_single_email_async (GearyImapDBFolder* self,
                                                     GearyImapDBEmailIdentifier* id,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
VALA_EXTERN void geary_imap_db_folder_detach_single_email_finish (GearyImapDBFolder* self,
                                                      GAsyncResult* _res_,
                                                      gboolean* is_marked,
                                                      GError** error);
VALA_EXTERN GType geary_imap_engine_replay_queue_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyImapEngineReplayQueue* geary_imap_engine_minimal_folder_get_replay_queue (GearyImapEngineMinimalFolder* self);
VALA_EXTERN void geary_imap_engine_replay_queue_notify_remote_removed_ids (GearyImapEngineReplayQueue* self,
                                                               GeeCollection* ids);
VALA_EXTERN void geary_imap_db_folder_update_remote_selected_message_count (GearyImapDBFolder* self,
                                                                gint count,
                                                                GCancellable* cancellable,
                                                                GAsyncReadyCallback _callback_,
                                                                gpointer _user_data_);
VALA_EXTERN void geary_imap_db_folder_update_remote_selected_message_count_finish (GearyImapDBFolder* self,
                                                                       GAsyncResult* _res_,
                                                                       GError** error);
VALA_EXTERN void geary_imap_engine_minimal_folder_replay_notify_email_count_changed (GearyImapEngineMinimalFolder* self,
                                                                         gint new_count,
                                                                         GearyFolderCountChangeReason reason);
static void geary_imap_engine_replay_removal_finalize (GObject * obj);
static GType geary_imap_engine_replay_removal_get_type_once (void);

static inline gpointer
geary_imap_engine_replay_removal_get_instance_private (GearyImapEngineReplayRemoval* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapEngineReplayRemoval_private_offset);
}

static void
g_cclosure_user_marshal_VOID__INT_FLAGS (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_FLAGS) (gpointer data1, gint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_FLAGS callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_FLAGS) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_flags (param_values + 2), data2);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyImapEngineReplayRemoval*
geary_imap_engine_replay_removal_construct (GType object_type,
                                            GearyImapEngineMinimalFolder* owner,
                                            gint remote_count,
                                            GearyImapSequenceNumber* position)
{
	GearyImapEngineReplayRemoval * self = NULL;
	GearyImapEngineMinimalFolder* _tmp0_;
	GearyImapSequenceNumber* _tmp1_;
	g_return_val_if_fail (GEARY_IMAP_ENGINE_IS_MINIMAL_FOLDER (owner), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_SEQUENCE_NUMBER (position), NULL);
	self = (GearyImapEngineReplayRemoval*) geary_imap_engine_replay_operation_construct (object_type, "Removal", GEARY_IMAP_ENGINE_REPLAY_OPERATION_SCOPE_REMOTE_ONLY, GEARY_IMAP_ENGINE_REPLAY_OPERATION_ON_ERROR_IGNORE_REMOTE);
	_tmp0_ = _g_object_ref0 (owner);
	_g_object_unref0 (self->priv->owner);
	self->priv->owner = _tmp0_;
	self->priv->remote_count = remote_count;
	_tmp1_ = _g_object_ref0 (position);
	_g_object_unref0 (self->priv->position);
	self->priv->position = _tmp1_;
	return self;
}

GearyImapEngineReplayRemoval*
geary_imap_engine_replay_removal_new (GearyImapEngineMinimalFolder* owner,
                                      gint remote_count,
                                      GearyImapSequenceNumber* position)
{
	return geary_imap_engine_replay_removal_construct (GEARY_IMAP_ENGINE_TYPE_REPLAY_REMOVAL, owner, remote_count, position);
}

static void
geary_imap_engine_replay_removal_real_notify_remote_removed_position (GearyImapEngineReplayOperation* base,
                                                                      GearyImapSequenceNumber* removed)
{
	GearyImapEngineReplayRemoval * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_REPLAY_REMOVAL, GearyImapEngineReplayRemoval);
	g_return_if_fail (GEARY_IMAP_IS_SEQUENCE_NUMBER (removed));
}

static void
geary_imap_engine_replay_removal_real_notify_remote_removed_ids (GearyImapEngineReplayOperation* base,
                                                                 GeeCollection* ids)
{
	GearyImapEngineReplayRemoval * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_REPLAY_REMOVAL, GearyImapEngineReplayRemoval);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
}

static void
geary_imap_engine_replay_removal_real_get_ids_to_be_remote_removed (GearyImapEngineReplayOperation* base,
                                                                    GeeCollection* ids)
{
	GearyImapEngineReplayRemoval * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_REPLAY_REMOVAL, GearyImapEngineReplayRemoval);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (ids, GEE_TYPE_COLLECTION));
}

static void
geary_imap_engine_replay_removal_real_replay_remote_async_data_free (gpointer _data)
{
	GearyImapEngineReplayRemovalReplayRemoteAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->remote);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapEngineReplayRemovalReplayRemoteAsyncData, _data_);
}

static void
geary_imap_engine_replay_removal_real_replay_remote_async (GearyImapEngineReplayOperation* base,
                                                           GearyImapFolderSession* remote,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_)
{
	GearyImapEngineReplayRemoval * self;
	GearyImapEngineReplayRemovalReplayRemoteAsyncData* _data_;
	GearyImapEngineReplayRemoval* _tmp0_;
	GearyImapFolderSession* _tmp1_;
	g_return_if_fail (GEARY_IMAP_IS_FOLDER_SESSION (remote));
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_REPLAY_REMOVAL, GearyImapEngineReplayRemoval);
	_data_ = g_slice_new0 (GearyImapEngineReplayRemovalReplayRemoteAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_replay_removal_real_replay_remote_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (remote);
	_g_object_unref0 (_data_->remote);
	_data_->remote = _tmp1_;
	geary_imap_engine_replay_removal_real_replay_remote_async_co (_data_);
}

static void
geary_imap_engine_replay_removal_replay_remote_finish (GearyImapEngineReplayOperation* base,
                                                       GAsyncResult* _res_,
                                                       GError** error)
{
	GearyImapEngineReplayRemovalReplayRemoteAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_imap_engine_replay_removal_replay_remote_async_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_)
{
	GearyImapEngineReplayRemovalReplayRemoteAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_engine_replay_removal_real_replay_remote_async_co (_data_);
}

static gboolean
geary_imap_engine_replay_removal_real_replay_remote_async_co (GearyImapEngineReplayRemovalReplayRemoteAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->owner;
	_data_->_tmp1_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->self->priv->position;
	_data_->_tmp4_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp3_, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp5_);
	_data_->_tmp7_ = _data_->_tmp6_;
	g_debug ("imap-engine-replay-removal.vala:45: %s: ReplayRemoval this.position=%s" \
" reported_remote_count=%d", _data_->_tmp2_, _data_->_tmp7_, _data_->self->priv->remote_count);
	_g_free0 (_data_->_tmp7_);
	_g_free0 (_data_->_tmp2_);
	_data_->_tmp8_ = _data_->self->priv->position;
	if (geary_imap_sequence_number_is_valid (_data_->_tmp8_)) {
		_data_->_state_ = 1;
		geary_imap_engine_replay_removal_do_replay_removed_message (_data_->self, geary_imap_engine_replay_removal_replay_remote_async_ready, _data_);
		return FALSE;
		_state_1:
		geary_imap_engine_replay_removal_do_replay_removed_message_finish (_data_->self, _data_->_res_);
	} else {
		_data_->_tmp9_ = geary_imap_engine_replay_operation_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation));
		_data_->_tmp10_ = _data_->_tmp9_;
		g_debug ("imap-engine-replay-removal.vala:51: %s do_replay_removed_message: igno" \
"ring, invalid remote position or count", _data_->_tmp10_);
		_g_free0 (_data_->_tmp10_);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
geary_imap_engine_replay_removal_real_describe_state (GearyImapEngineReplayOperation* base)
{
	GearyImapEngineReplayRemoval * self;
	GearyImapSequenceNumber* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_ENGINE_TYPE_REPLAY_REMOVAL, GearyImapEngineReplayRemoval);
	_tmp0_ = self->priv->position;
	_tmp1_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf ("position=%s", _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static void
geary_imap_engine_replay_removal_do_replay_removed_message_data_free (gpointer _data)
{
	GearyImapEngineReplayRemovalDoReplayRemovedMessageData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GearyImapEngineReplayRemovalDoReplayRemovedMessageData, _data_);
}

static void
geary_imap_engine_replay_removal_do_replay_removed_message (GearyImapEngineReplayRemoval* self,
                                                            GAsyncReadyCallback _callback_,
                                                            gpointer _user_data_)
{
	GearyImapEngineReplayRemovalDoReplayRemovedMessageData* _data_;
	GearyImapEngineReplayRemoval* _tmp0_;
	g_return_if_fail (GEARY_IMAP_ENGINE_IS_REPLAY_REMOVAL (self));
	_data_ = g_slice_new0 (GearyImapEngineReplayRemovalDoReplayRemovedMessageData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_imap_engine_replay_removal_do_replay_removed_message_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	geary_imap_engine_replay_removal_do_replay_removed_message_co (_data_);
}

static void
geary_imap_engine_replay_removal_do_replay_removed_message_finish (GearyImapEngineReplayRemoval* self,
                                                                   GAsyncResult* _res_)
{
	GearyImapEngineReplayRemovalDoReplayRemovedMessageData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
geary_imap_engine_replay_removal_do_replay_removed_message_ready (GObject* source_object,
                                                                  GAsyncResult* _res_,
                                                                  gpointer _user_data_)
{
	GearyImapEngineReplayRemovalDoReplayRemovedMessageData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_imap_engine_replay_removal_do_replay_removed_message_co (_data_);
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static gboolean
geary_imap_engine_replay_removal_do_replay_removed_message_co (GearyImapEngineReplayRemovalDoReplayRemovedMessageData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->local_count = -1;
	_data_->local_position = (gint64) -1;
	_data_->owned_id = NULL;
	{
		_data_->_tmp1_ = _data_->self->priv->owner;
		_data_->_tmp2_ = geary_imap_engine_minimal_folder_get_local_folder (_data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_state_ = 1;
		geary_imap_db_folder_get_email_count_async (_data_->_tmp3_, GEARY_IMAP_DB_FOLDER_LIST_FLAGS_INCLUDE_MARKED_FOR_REMOVE, NULL, geary_imap_engine_replay_removal_do_replay_removed_message_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = geary_imap_db_folder_get_email_count_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->local_count = _data_->_tmp0_;
		_data_->_tmp4_ = _data_->self->priv->position;
		_data_->_tmp5_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->local_position = _data_->_tmp6_ - ((_data_->self->priv->remote_count + 1) - _data_->local_count);
		if (_data_->local_position > ((gint64) 0)) {
			_data_->_tmp7_ = geary_imap_engine_replay_operation_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation));
			_data_->_tmp8_ = _data_->_tmp7_;
			_data_->_tmp9_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->local_position);
			_data_->_tmp10_ = _data_->_tmp9_;
			g_debug ("imap-engine-replay-removal.vala:78: %s do_replay_removed_message: loca" \
"l_count=%d local_position=%s", _data_->_tmp8_, _data_->local_count, _data_->_tmp10_);
			_g_free0 (_data_->_tmp10_);
			_g_free0 (_data_->_tmp8_);
			_data_->_tmp12_ = _data_->self->priv->owner;
			_data_->_tmp13_ = geary_imap_engine_minimal_folder_get_local_folder (_data_->_tmp12_);
			_data_->_tmp14_ = _data_->_tmp13_;
			_data_->_state_ = 2;
			geary_imap_db_folder_get_id_at_async (_data_->_tmp14_, _data_->local_position, NULL, geary_imap_engine_replay_removal_do_replay_removed_message_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp15_ = geary_imap_db_folder_get_id_at_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp11_ = _data_->_tmp15_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp16_ = _data_->_tmp11_;
			_data_->_tmp11_ = NULL;
			_g_object_unref0 (_data_->owned_id);
			_data_->owned_id = _data_->_tmp16_;
			_g_object_unref0 (_data_->_tmp11_);
		} else {
			_data_->_tmp17_ = geary_imap_engine_replay_operation_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation));
			_data_->_tmp18_ = _data_->_tmp17_;
			_data_->_tmp19_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->local_position);
			_data_->_tmp20_ = _data_->_tmp19_;
			g_debug ("imap-engine-replay-removal.vala:83: %s do_replay_removed_message: mess" \
"age not stored locally (local_count=%d local_position=%s)", _data_->_tmp18_, _data_->local_count, _data_->_tmp20_);
			_g_free0 (_data_->_tmp20_);
			_g_free0 (_data_->_tmp18_);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp21_ = geary_imap_engine_replay_operation_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation));
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp23_ = _data_->self->priv->position;
		_data_->_tmp24_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp23_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
		_data_->_tmp25_ = _data_->_tmp24_;
		_data_->_tmp26_ = _data_->err;
		_data_->_tmp27_ = _data_->_tmp26_->message;
		g_debug ("imap-engine-replay-removal.vala:87: %s do_replay_removed_message: unab" \
"le to determine ID of removed message %s: %s", _data_->_tmp22_, _data_->_tmp25_, _data_->_tmp27_);
		_g_free0 (_data_->_tmp25_);
		_g_free0 (_data_->_tmp22_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->owned_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->marked = FALSE;
	_data_->_tmp28_ = _data_->owned_id;
	if (_data_->_tmp28_ != NULL) {
		_data_->_tmp29_ = geary_imap_engine_replay_operation_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation));
		_data_->_tmp30_ = _data_->_tmp29_;
		_data_->_tmp31_ = _data_->owned_id;
		_data_->_tmp32_ = geary_email_identifier_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp31_, GEARY_TYPE_EMAIL_IDENTIFIER, GearyEmailIdentifier));
		_data_->_tmp33_ = _data_->_tmp32_;
		g_debug ("imap-engine-replay-removal.vala:93: %s do_replay_removed_message: deta" \
"ching from local store Email ID %s", _data_->_tmp30_, _data_->_tmp33_);
		_g_free0 (_data_->_tmp33_);
		_g_free0 (_data_->_tmp30_);
		{
			_data_->_tmp34_ = _data_->self->priv->owner;
			_data_->_tmp35_ = geary_imap_engine_minimal_folder_get_local_folder (_data_->_tmp34_);
			_data_->_tmp36_ = _data_->_tmp35_;
			_data_->_tmp37_ = _data_->owned_id;
			_data_->_tmp38_ = FALSE;
			_data_->_state_ = 3;
			geary_imap_db_folder_detach_single_email_async (_data_->_tmp36_, _data_->_tmp37_, NULL, geary_imap_engine_replay_removal_do_replay_removed_message_ready, _data_);
			return FALSE;
			_state_3:
			geary_imap_db_folder_detach_single_email_finish (_data_->_tmp36_, _data_->_res_, &_data_->_tmp38_, &_data_->_inner_error0_);
			_data_->marked = _data_->_tmp38_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->_vala1_err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp39_ = geary_imap_engine_replay_operation_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation));
			_data_->_tmp40_ = _data_->_tmp39_;
			_data_->_tmp41_ = _data_->self->priv->position;
			_data_->_tmp42_ = geary_message_data_abstract_message_data_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp41_, GEARY_MESSAGE_DATA_TYPE_ABSTRACT_MESSAGE_DATA, GearyMessageDataAbstractMessageData));
			_data_->_tmp43_ = _data_->_tmp42_;
			_data_->_tmp44_ = _data_->_vala1_err;
			_data_->_tmp45_ = _data_->_tmp44_->message;
			g_debug ("imap-engine-replay-removal.vala:99: %s do_replay_removed_message: unab" \
"le to remove message #%s: %s", _data_->_tmp40_, _data_->_tmp43_, _data_->_tmp45_);
			_g_free0 (_data_->_tmp43_);
			_g_free0 (_data_->_tmp40_);
			_g_error_free0 (_data_->_vala1_err);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->owned_id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp46_ = _data_->self->priv->owner;
		_data_->_tmp47_ = geary_imap_engine_minimal_folder_get_replay_queue (_data_->_tmp46_);
		_data_->_tmp48_ = _data_->_tmp47_;
		_data_->_tmp49_ = _data_->owned_id;
		_data_->_tmp50_ = geary_iterate (GEARY_IMAP_DB_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _data_->_tmp49_, NULL);
		_data_->_tmp51_ = _data_->_tmp50_;
		_data_->_tmp52_ = geary_iterable_to_array_list (_data_->_tmp51_, NULL, NULL, NULL);
		_data_->_tmp53_ = _data_->_tmp52_;
		geary_imap_engine_replay_queue_notify_remote_removed_ids (_data_->_tmp48_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp53_, GEE_TYPE_COLLECTION, GeeCollection));
		_g_object_unref0 (_data_->_tmp53_);
		_g_object_unref0 (_data_->_tmp51_);
	} else {
		_data_->_tmp54_ = geary_imap_engine_replay_operation_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation));
		_data_->_tmp55_ = _data_->_tmp54_;
		_data_->_tmp56_ = _data_->self->priv->position;
		_data_->_tmp57_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp56_, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
		_data_->_tmp58_ = _data_->_tmp57_;
		g_debug ("%s do_replay_removed_message: this.position=%lld unknown in local stor" \
"e " "(this.remote_count=%d local_position=%lld local_count=%d)", _data_->_tmp55_, _data_->_tmp58_, _data_->self->priv->remote_count, _data_->local_position, _data_->local_count);
		_g_free0 (_data_->_tmp55_);
	}
	_data_->new_local_count = -1;
	{
		_data_->_tmp60_ = _data_->self->priv->owner;
		_data_->_tmp61_ = geary_imap_engine_minimal_folder_get_local_folder (_data_->_tmp60_);
		_data_->_tmp62_ = _data_->_tmp61_;
		_data_->_state_ = 4;
		geary_imap_db_folder_get_email_count_async (_data_->_tmp62_, GEARY_IMAP_DB_FOLDER_LIST_FLAGS_INCLUDE_MARKED_FOR_REMOVE, NULL, geary_imap_engine_replay_removal_do_replay_removed_message_ready, _data_);
		return FALSE;
		_state_4:
		_data_->_tmp59_ = geary_imap_db_folder_get_email_count_finish (_data_->_tmp62_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_data_->new_local_count = _data_->_tmp59_;
	}
	goto __finally2;
	__catch2_g_error:
	{
		_data_->_vala2_err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp63_ = geary_imap_engine_replay_operation_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation));
		_data_->_tmp64_ = _data_->_tmp63_;
		_data_->_tmp65_ = _data_->_vala2_err;
		_data_->_tmp66_ = _data_->_tmp65_->message;
		g_debug ("imap-engine-replay-removal.vala:118: %s do_replay_removed_message: err" \
"or fetching new local count: %s", _data_->_tmp64_, _data_->_tmp66_);
		_g_free0 (_data_->_tmp64_);
		_g_error_free0 (_data_->_vala2_err);
	}
	__finally2:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->owned_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp67_ = _data_->self->priv->owner;
		_data_->_tmp68_ = geary_imap_engine_minimal_folder_get_local_folder (_data_->_tmp67_);
		_data_->_tmp69_ = _data_->_tmp68_;
		_data_->_state_ = 5;
		geary_imap_db_folder_update_remote_selected_message_count (_data_->_tmp69_, _data_->self->priv->remote_count, NULL, geary_imap_engine_replay_removal_do_replay_removed_message_ready, _data_);
		return FALSE;
		_state_5:
		geary_imap_db_folder_update_remote_selected_message_count_finish (_data_->_tmp69_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		_data_->_vala3_err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp70_ = geary_imap_engine_replay_operation_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, GearyImapEngineReplayOperation));
		_data_->_tmp71_ = _data_->_tmp70_;
		_data_->_tmp72_ = _data_->_vala3_err;
		_data_->_tmp73_ = _data_->_tmp72_->message;
		g_debug ("imap-engine-replay-removal.vala:127: %s do_replay_removed_message: una" \
"ble to save removed remote count: %s", _data_->_tmp71_, _data_->_tmp73_);
		_g_free0 (_data_->_tmp71_);
		_g_error_free0 (_data_->_vala3_err);
	}
	__finally3:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->owned_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp74_ = _data_->owned_id;
	if (_data_->_tmp74_ != NULL) {
		_data_->_tmp75_ = _data_->owned_id;
		_data_->_tmp76_ = geary_iterate (GEARY_TYPE_EMAIL_IDENTIFIER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp75_, GEARY_TYPE_EMAIL_IDENTIFIER, GearyEmailIdentifier), NULL);
		_data_->_tmp77_ = _data_->_tmp76_;
		_data_->_tmp78_ = geary_iterable_to_array_list (_data_->_tmp77_, NULL, NULL, NULL);
		_data_->_tmp79_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp78_, GEE_TYPE_LIST, GeeList);
		_g_object_unref0 (_data_->_tmp77_);
		_data_->removed = _data_->_tmp79_;
		if (!_data_->marked) {
			_data_->_tmp80_ = _data_->removed;
			g_signal_emit (_data_->self, geary_imap_engine_replay_removal_signals[GEARY_IMAP_ENGINE_REPLAY_REMOVAL_EMAIL_REMOVED_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp80_, GEE_TYPE_COLLECTION, GeeCollection));
		} else {
			_data_->_tmp81_ = _data_->removed;
			g_signal_emit (_data_->self, geary_imap_engine_replay_removal_signals[GEARY_IMAP_ENGINE_REPLAY_REMOVAL_MARKED_EMAIL_REMOVED_SIGNAL], 0, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp81_, GEE_TYPE_COLLECTION, GeeCollection));
		}
		_g_object_unref0 (_data_->removed);
	}
	if (!_data_->marked) {
		_data_->_tmp82_ = _data_->self->priv->owner;
		geary_imap_engine_minimal_folder_replay_notify_email_count_changed (_data_->_tmp82_, _data_->self->priv->remote_count, GEARY_FOLDER_COUNT_CHANGE_REASON_REMOVED);
	}
	_data_->_tmp83_ = _data_->self->priv->owner;
	_data_->_tmp84_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp83_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
	_data_->_tmp85_ = _data_->_tmp84_;
	_data_->_tmp86_ = _data_->self->priv->position;
	_data_->_tmp87_ = geary_message_data_int64_message_data_get_value (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp86_, GEARY_MESSAGE_DATA_TYPE_INT64_MESSAGE_DATA, GearyMessageDataInt64MessageData));
	_data_->_tmp88_ = _data_->_tmp87_;
	_data_->_tmp89_ = bool_to_string (_data_->marked);
	_data_->_tmp90_ = _data_->_tmp89_;
	g_debug ("%s ReplayRemoval: completed, " "(this.remote_count=%d local_count=%d starting local_count=%d this.posi" \
"tion=%lld local_position=%lld marked=%s)", _data_->_tmp85_, _data_->self->priv->remote_count, _data_->new_local_count, _data_->local_count, _data_->_tmp88_, _data_->local_position, _data_->_tmp90_);
	_g_free0 (_data_->_tmp90_);
	_g_free0 (_data_->_tmp85_);
	_g_object_unref0 (_data_->owned_id);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_imap_engine_replay_removal_class_init (GearyImapEngineReplayRemovalClass * klass,
                                             gpointer klass_data)
{
	geary_imap_engine_replay_removal_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapEngineReplayRemoval_private_offset);
	((GearyImapEngineReplayOperationClass *) klass)->notify_remote_removed_position = (void (*) (GearyImapEngineReplayOperation*, GearyImapSequenceNumber*)) geary_imap_engine_replay_removal_real_notify_remote_removed_position;
	((GearyImapEngineReplayOperationClass *) klass)->notify_remote_removed_ids = (void (*) (GearyImapEngineReplayOperation*, GeeCollection*)) geary_imap_engine_replay_removal_real_notify_remote_removed_ids;
	((GearyImapEngineReplayOperationClass *) klass)->get_ids_to_be_remote_removed = (void (*) (GearyImapEngineReplayOperation*, GeeCollection*)) geary_imap_engine_replay_removal_real_get_ids_to_be_remote_removed;
	((GearyImapEngineReplayOperationClass *) klass)->replay_remote_async = (void (*) (GearyImapEngineReplayOperation*, GearyImapFolderSession*, GAsyncReadyCallback, gpointer)) geary_imap_engine_replay_removal_real_replay_remote_async;
	((GearyImapEngineReplayOperationClass *) klass)->replay_remote_finish = (void (*) (GearyImapEngineReplayOperation*, GAsyncResult*, GError**)) geary_imap_engine_replay_removal_replay_remote_finish;
	((GearyImapEngineReplayOperationClass *) klass)->describe_state = (gchar* (*) (GearyImapEngineReplayOperation*)) geary_imap_engine_replay_removal_real_describe_state;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_engine_replay_removal_finalize;
	geary_imap_engine_replay_removal_signals[GEARY_IMAP_ENGINE_REPLAY_REMOVAL_EMAIL_REMOVED_SIGNAL] = g_signal_new ("email-removed", GEARY_IMAP_ENGINE_TYPE_REPLAY_REMOVAL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	geary_imap_engine_replay_removal_signals[GEARY_IMAP_ENGINE_REPLAY_REMOVAL_MARKED_EMAIL_REMOVED_SIGNAL] = g_signal_new ("marked-email-removed", GEARY_IMAP_ENGINE_TYPE_REPLAY_REMOVAL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	geary_imap_engine_replay_removal_signals[GEARY_IMAP_ENGINE_REPLAY_REMOVAL_EMAIL_COUNT_CHANGED_SIGNAL] = g_signal_new ("email-count-changed", GEARY_IMAP_ENGINE_TYPE_REPLAY_REMOVAL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_FLAGS, G_TYPE_NONE, 2, G_TYPE_INT, GEARY_FOLDER_TYPE_COUNT_CHANGE_REASON);
}

static void
geary_imap_engine_replay_removal_instance_init (GearyImapEngineReplayRemoval * self,
                                                gpointer klass)
{
	self->priv = geary_imap_engine_replay_removal_get_instance_private (self);
}

static void
geary_imap_engine_replay_removal_finalize (GObject * obj)
{
	GearyImapEngineReplayRemoval * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_ENGINE_TYPE_REPLAY_REMOVAL, GearyImapEngineReplayRemoval);
	_g_object_unref0 (self->priv->owner);
	_g_object_unref0 (self->priv->position);
	G_OBJECT_CLASS (geary_imap_engine_replay_removal_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_imap_engine_replay_removal_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapEngineReplayRemovalClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_engine_replay_removal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapEngineReplayRemoval), 0, (GInstanceInitFunc) geary_imap_engine_replay_removal_instance_init, NULL };
	GType geary_imap_engine_replay_removal_type_id;
	geary_imap_engine_replay_removal_type_id = g_type_register_static (GEARY_IMAP_ENGINE_TYPE_REPLAY_OPERATION, "GearyImapEngineReplayRemoval", &g_define_type_info, 0);
	GearyImapEngineReplayRemoval_private_offset = g_type_add_instance_private (geary_imap_engine_replay_removal_type_id, sizeof (GearyImapEngineReplayRemovalPrivate));
	return geary_imap_engine_replay_removal_type_id;
}

GType
geary_imap_engine_replay_removal_get_type (void)
{
	static gsize geary_imap_engine_replay_removal_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_engine_replay_removal_type_id__once)) {
		GType geary_imap_engine_replay_removal_type_id;
		geary_imap_engine_replay_removal_type_id = geary_imap_engine_replay_removal_get_type_once ();
		g_once_init_leave (&geary_imap_engine_replay_removal_type_id__once, geary_imap_engine_replay_removal_type_id);
	}
	return geary_imap_engine_replay_removal_type_id__once;
}

