/* imap-flag.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-flag.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>

enum  {
	GEARY_IMAP_FLAG_0_PROPERTY,
	GEARY_IMAP_FLAG_VALUE_PROPERTY,
	GEARY_IMAP_FLAG_NUM_PROPERTIES
};
static GParamSpec* geary_imap_flag_properties[GEARY_IMAP_FLAG_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GearyImapFlagPrivate {
	gchar* _value;
};

static gint GearyImapFlag_private_offset;
static gpointer geary_imap_flag_parent_class = NULL;
static GeeHashableIface * geary_imap_flag_gee_hashable_parent_iface = NULL;

static void geary_imap_flag_set_value (GearyImapFlag* self,
                                const gchar* value);
static gboolean geary_imap_flag_real_equal_to (GeeHashable* base,
                                        GearyImapFlag* flag);
static guint geary_imap_flag_real_hash (GeeHashable* base);
static void geary_imap_flag_finalize (GObject * obj);
static GType geary_imap_flag_get_type_once (void);
static void _vala_geary_imap_flag_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_geary_imap_flag_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
geary_imap_flag_get_instance_private (GearyImapFlag* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapFlag_private_offset);
}

const gchar*
geary_imap_flag_get_value (GearyImapFlag* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_FLAG (self), NULL);
	_tmp0_ = self->priv->_value;
	result = _tmp0_;
	return result;
}

static void
geary_imap_flag_set_value (GearyImapFlag* self,
                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IMAP_IS_FLAG (self));
	old_value = geary_imap_flag_get_value (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_value);
		self->priv->_value = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_flag_properties[GEARY_IMAP_FLAG_VALUE_PROPERTY]);
	}
}

/**
     * Constructs a new flag.
     *
     * The given keyword must be an IMAP atom.
     */
GearyImapFlag*
geary_imap_flag_construct (GType object_type,
                           const gchar* name)
{
	GearyImapFlag * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (GearyImapFlag*) geary_base_object_construct (object_type);
	geary_imap_flag_set_value (self, name);
	return self;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

gboolean
geary_imap_flag_is_system (GearyImapFlag* self)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_FLAG (self), FALSE);
	_tmp0_ = self->priv->_value;
	result = string_get (_tmp0_, (glong) 0) == '\\';
	return result;
}

gboolean
geary_imap_flag_equals_string (GearyImapFlag* self,
                               const gchar* value)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_FLAG (self), FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	_tmp0_ = self->priv->_value;
	result = geary_ascii_stri_equal (_tmp0_, value);
	return result;
}

static gboolean
geary_imap_flag_real_equal_to (GeeHashable* base,
                               GearyImapFlag* flag)
{
	GearyImapFlag * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_FLAG, GearyImapFlag);
	g_return_val_if_fail (GEARY_IMAP_IS_FLAG (flag), FALSE);
	if (flag == self) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->_value;
		_tmp0_ = geary_imap_flag_equals_string (flag, _tmp1_);
	}
	result = _tmp0_;
	return result;
}

/**
     * Returns the {@link Flag} as an appropriate {@link Parameter}.
     */
GearyImapStringParameter*
geary_imap_flag_to_parameter (GearyImapFlag* self,
                              GError** error)
{
	const gchar* _tmp0_;
	GearyImapUnquotedStringParameter* _tmp1_;
	GearyImapStringParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_FLAG (self), NULL);
	_tmp0_ = self->priv->_value;
	_tmp1_ = geary_imap_unquoted_string_parameter_new (_tmp0_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter);
	return result;
}

static guint
geary_imap_flag_real_hash (GeeHashable* base)
{
	GearyImapFlag * self;
	const gchar* _tmp0_;
	guint result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_IMAP_TYPE_FLAG, GearyImapFlag);
	_tmp0_ = self->priv->_value;
	result = geary_ascii_stri_hash (_tmp0_);
	return result;
}

gchar*
geary_imap_flag_to_string (GearyImapFlag* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (GEARY_IMAP_IS_FLAG (self), NULL);
	_tmp0_ = self->priv->_value;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
geary_imap_flag_class_init (GearyImapFlagClass * klass,
                            gpointer klass_data)
{
	geary_imap_flag_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapFlag_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_flag_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_flag_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_flag_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_FLAG_VALUE_PROPERTY, geary_imap_flag_properties[GEARY_IMAP_FLAG_VALUE_PROPERTY] = g_param_spec_string ("value", "value", "value", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_flag_gee_hashable_interface_init (GeeHashableIface * iface,
                                             gpointer iface_data)
{
	geary_imap_flag_gee_hashable_parent_iface = g_type_interface_peek_parent (iface);
	iface->equal_to = (gboolean (*) (GeeHashable*, gconstpointer)) geary_imap_flag_real_equal_to;
	iface->hash = (guint (*) (GeeHashable*)) geary_imap_flag_real_hash;
}

static void
geary_imap_flag_instance_init (GearyImapFlag * self,
                               gpointer klass)
{
	self->priv = geary_imap_flag_get_instance_private (self);
}

static void
geary_imap_flag_finalize (GObject * obj)
{
	GearyImapFlag * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_FLAG, GearyImapFlag);
	_g_free0 (self->priv->_value);
	G_OBJECT_CLASS (geary_imap_flag_parent_class)->finalize (obj);
}

/**
 * A generic IMAP message or mailbox flag.
 *
 * In IMAP, message and mailbox flags have similar syntax, which is encapsulated here.
 *
 * @see MessageFlag
 * @see MailboxAttribute
 */
 G_GNUC_NO_INLINE static GType
geary_imap_flag_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapFlagClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_flag_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapFlag), 0, (GInstanceInitFunc) geary_imap_flag_instance_init, NULL };
	static const GInterfaceInfo gee_hashable_info = { (GInterfaceInitFunc) geary_imap_flag_gee_hashable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_imap_flag_type_id;
	geary_imap_flag_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyImapFlag", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (geary_imap_flag_type_id, GEE_TYPE_HASHABLE, &gee_hashable_info);
	GearyImapFlag_private_offset = g_type_add_instance_private (geary_imap_flag_type_id, sizeof (GearyImapFlagPrivate));
	return geary_imap_flag_type_id;
}

GType
geary_imap_flag_get_type (void)
{
	static gsize geary_imap_flag_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_flag_type_id__once)) {
		GType geary_imap_flag_type_id;
		geary_imap_flag_type_id = geary_imap_flag_get_type_once ();
		g_once_init_leave (&geary_imap_flag_type_id__once, geary_imap_flag_type_id);
	}
	return geary_imap_flag_type_id__once;
}

static void
_vala_geary_imap_flag_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	GearyImapFlag * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_FLAG, GearyImapFlag);
	switch (property_id) {
		case GEARY_IMAP_FLAG_VALUE_PROPERTY:
		g_value_set_string (value, geary_imap_flag_get_value (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_flag_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	GearyImapFlag * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_FLAG, GearyImapFlag);
	switch (property_id) {
		case GEARY_IMAP_FLAG_VALUE_PROPERTY:
		geary_imap_flag_set_value (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

