/* imap-server-response.c generated by valac 0.56.3, the Vala compiler
 * generated from imap-server-response.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

enum  {
	GEARY_IMAP_SERVER_RESPONSE_0_PROPERTY,
	GEARY_IMAP_SERVER_RESPONSE_TAG_PROPERTY,
	GEARY_IMAP_SERVER_RESPONSE_QUIRKS_PROPERTY,
	GEARY_IMAP_SERVER_RESPONSE_NUM_PROPERTIES
};
static GParamSpec* geary_imap_server_response_properties[GEARY_IMAP_SERVER_RESPONSE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GearyImapServerResponsePrivate {
	GearyImapTag* _tag;
	GearyImapQuirks* _quirks;
};

static gint GearyImapServerResponse_private_offset;
static gpointer geary_imap_server_response_parent_class = NULL;

static void geary_imap_server_response_set_tag (GearyImapServerResponse* self,
                                         GearyImapTag* value);
static void geary_imap_server_response_set_quirks (GearyImapServerResponse* self,
                                            GearyImapQuirks* value);
static void geary_imap_server_response_finalize (GObject * obj);
static GType geary_imap_server_response_get_type_once (void);
static void _vala_geary_imap_server_response_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_geary_imap_server_response_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);

static inline gpointer
geary_imap_server_response_get_instance_private (GearyImapServerResponse* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapServerResponse_private_offset);
}

GearyImapTag*
geary_imap_server_response_get_tag (GearyImapServerResponse* self)
{
	GearyImapTag* result;
	GearyImapTag* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_SERVER_RESPONSE (self), NULL);
	_tmp0_ = self->priv->_tag;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_imap_server_response_set_tag (GearyImapServerResponse* self,
                                    GearyImapTag* value)
{
	GearyImapTag* old_value;
	g_return_if_fail (GEARY_IMAP_IS_SERVER_RESPONSE (self));
	old_value = geary_imap_server_response_get_tag (self);
	if (old_value != value) {
		GearyImapTag* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_tag);
		self->priv->_tag = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_server_response_properties[GEARY_IMAP_SERVER_RESPONSE_TAG_PROPERTY]);
	}
}

GearyImapQuirks*
geary_imap_server_response_get_quirks (GearyImapServerResponse* self)
{
	GearyImapQuirks* result;
	GearyImapQuirks* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_SERVER_RESPONSE (self), NULL);
	_tmp0_ = self->priv->_quirks;
	result = _tmp0_;
	return result;
}

static void
geary_imap_server_response_set_quirks (GearyImapServerResponse* self,
                                       GearyImapQuirks* value)
{
	GearyImapQuirks* old_value;
	g_return_if_fail (GEARY_IMAP_IS_SERVER_RESPONSE (self));
	old_value = geary_imap_server_response_get_quirks (self);
	if (old_value != value) {
		GearyImapQuirks* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_quirks);
		self->priv->_quirks = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_server_response_properties[GEARY_IMAP_SERVER_RESPONSE_QUIRKS_PROPERTY]);
	}
}

GearyImapServerResponse*
geary_imap_server_response_construct (GType object_type,
                                      GearyImapTag* tag,
                                      GearyImapQuirks* quirks)
{
	GearyImapServerResponse * self = NULL;
	g_return_val_if_fail (GEARY_IMAP_IS_TAG (tag), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_QUIRKS (quirks), NULL);
	self = (GearyImapServerResponse*) geary_imap_root_parameters_construct (object_type);
	geary_imap_server_response_set_tag (self, tag);
	geary_imap_server_response_set_quirks (self, quirks);
	return self;
}

/**
     * Converts the {@link RootParameters} into a ServerResponse.
     *
     * The supplied root is "stripped" of its children.
     */
GearyImapServerResponse*
geary_imap_server_response_construct_migrate (GType object_type,
                                              GearyImapRootParameters* root,
                                              GearyImapQuirks* quirks,
                                              GError** error)
{
	GearyImapServerResponse * self = NULL;
	GearyImapTag* _tmp4_;
	GearyImapTag* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (GEARY_IMAP_IS_ROOT_PARAMETERS (root), NULL);
	g_return_val_if_fail (GEARY_IMAP_IS_QUIRKS (quirks), NULL);
	self = (GearyImapServerResponse*) geary_imap_root_parameters_construct_migrate (object_type, root);
	geary_imap_server_response_set_quirks (self, quirks);
	if (!geary_imap_root_parameters_has_tag (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_ROOT_PARAMETERS, GearyImapRootParameters))) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		GError* _tmp2_;
		GError* _tmp3_;
		_tmp0_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
		_tmp1_ = _tmp0_;
		_tmp2_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Server response does not have a tag token: %s", _tmp1_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		_inner_error0_ = _tmp3_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp4_ = geary_imap_root_parameters_get_tag (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_IMAP_TYPE_ROOT_PARAMETERS, GearyImapRootParameters));
	_tmp5_ = _tmp4_;
	geary_imap_server_response_set_tag (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	return self;
}

static void
geary_imap_server_response_class_init (GearyImapServerResponseClass * klass,
                                       gpointer klass_data)
{
	geary_imap_server_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapServerResponse_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_server_response_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_server_response_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_server_response_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_SERVER_RESPONSE_TAG_PROPERTY, geary_imap_server_response_properties[GEARY_IMAP_SERVER_RESPONSE_TAG_PROPERTY] = g_param_spec_object ("tag", "tag", "tag", GEARY_IMAP_TYPE_TAG, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_SERVER_RESPONSE_QUIRKS_PROPERTY, geary_imap_server_response_properties[GEARY_IMAP_SERVER_RESPONSE_QUIRKS_PROPERTY] = g_param_spec_object ("quirks", "quirks", "quirks", GEARY_IMAP_TYPE_QUIRKS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_server_response_instance_init (GearyImapServerResponse * self,
                                          gpointer klass)
{
	self->priv = geary_imap_server_response_get_instance_private (self);
}

static void
geary_imap_server_response_finalize (GObject * obj)
{
	GearyImapServerResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_SERVER_RESPONSE, GearyImapServerResponse);
	_g_object_unref0 (self->priv->_tag);
	_g_object_unref0 (self->priv->_quirks);
	G_OBJECT_CLASS (geary_imap_server_response_parent_class)->finalize (obj);
}

/**
 * A response sent from the server to client.
 *
 * ServerResponses can take various shapes, including tagged/untagged and some common forms where
 * status and status text are supplied.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-7]] for more information.
 */
 G_GNUC_NO_INLINE static GType
geary_imap_server_response_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapServerResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_server_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapServerResponse), 0, (GInstanceInitFunc) geary_imap_server_response_instance_init, NULL };
	GType geary_imap_server_response_type_id;
	geary_imap_server_response_type_id = g_type_register_static (GEARY_IMAP_TYPE_ROOT_PARAMETERS, "GearyImapServerResponse", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	GearyImapServerResponse_private_offset = g_type_add_instance_private (geary_imap_server_response_type_id, sizeof (GearyImapServerResponsePrivate));
	return geary_imap_server_response_type_id;
}

GType
geary_imap_server_response_get_type (void)
{
	static gsize geary_imap_server_response_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_server_response_type_id__once)) {
		GType geary_imap_server_response_type_id;
		geary_imap_server_response_type_id = geary_imap_server_response_get_type_once ();
		g_once_init_leave (&geary_imap_server_response_type_id__once, geary_imap_server_response_type_id);
	}
	return geary_imap_server_response_type_id__once;
}

static void
_vala_geary_imap_server_response_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	GearyImapServerResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_SERVER_RESPONSE, GearyImapServerResponse);
	switch (property_id) {
		case GEARY_IMAP_SERVER_RESPONSE_TAG_PROPERTY:
		g_value_set_object (value, geary_imap_server_response_get_tag (self));
		break;
		case GEARY_IMAP_SERVER_RESPONSE_QUIRKS_PROPERTY:
		g_value_set_object (value, geary_imap_server_response_get_quirks (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_server_response_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	GearyImapServerResponse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_SERVER_RESPONSE, GearyImapServerResponse);
	switch (property_id) {
		case GEARY_IMAP_SERVER_RESPONSE_TAG_PROPERTY:
		geary_imap_server_response_set_tag (self, g_value_get_object (value));
		break;
		case GEARY_IMAP_SERVER_RESPONSE_QUIRKS_PROPERTY:
		geary_imap_server_response_set_quirks (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

