/* memory-byte-buffer.c generated by valac 0.56.3, the Vala compiler
 * generated from memory-byte-buffer.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <gio/gio.h>

enum  {
	GEARY_MEMORY_BYTE_BUFFER_0_PROPERTY,
	GEARY_MEMORY_BYTE_BUFFER_SIZE_PROPERTY,
	GEARY_MEMORY_BYTE_BUFFER_ALLOCATED_SIZE_PROPERTY,
	GEARY_MEMORY_BYTE_BUFFER_NUM_PROPERTIES
};
static GParamSpec* geary_memory_byte_buffer_properties[GEARY_MEMORY_BYTE_BUFFER_NUM_PROPERTIES];
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GearyMemoryByteBufferPrivate {
	GBytes* bytes;
	gsize allocated_bytes;
};

static gint GearyMemoryByteBuffer_private_offset;
static gpointer geary_memory_byte_buffer_parent_class = NULL;
static GearyMemoryUnownedBytesBufferIface * geary_memory_byte_buffer_geary_memory_unowned_bytes_buffer_parent_iface = NULL;

static guint8* _vala_array_dup9 (guint8* self,
                          gssize length);
static GBytes* geary_memory_byte_buffer_real_get_bytes (GearyMemoryBuffer* base);
static guint8* geary_memory_byte_buffer_real_to_unowned_uint8_array (GearyMemoryUnownedBytesBuffer* base,
                                                              gint* result_length1);
static void geary_memory_byte_buffer_finalize (GObject * obj);
static GType geary_memory_byte_buffer_get_type_once (void);
static void _vala_geary_memory_byte_buffer_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);

static inline gpointer
geary_memory_byte_buffer_get_instance_private (GearyMemoryByteBuffer* self)
{
	return G_STRUCT_MEMBER_P (self, GearyMemoryByteBuffer_private_offset);
}

static gint
_vala_g_bytes_get_length (GBytes* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) g_bytes_get_size (self);
	return result;
}

static gsize
geary_memory_byte_buffer_real_get_size (GearyMemoryBuffer* base)
{
	gsize result;
	GearyMemoryByteBuffer* self;
	GBytes* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MEMORY_TYPE_BYTE_BUFFER, GearyMemoryByteBuffer);
	_tmp0_ = self->priv->bytes;
	_tmp1_ = _vala_g_bytes_get_length (_tmp0_);
	_tmp2_ = _tmp1_;
	result = (gsize) _tmp2_;
	return result;
}

static gsize
geary_memory_byte_buffer_real_get_allocated_size (GearyMemoryBuffer* base)
{
	gsize result;
	GearyMemoryByteBuffer* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MEMORY_TYPE_BYTE_BUFFER, GearyMemoryByteBuffer);
	result = self->priv->allocated_bytes;
	return result;
}

/**
     * filled is the number of usable bytes in the supplied buffer, allocated is the total size
     * of the buffer.
     *
     * filled must be less than or equal to the allocated size of the buffer.
     *
     * A copy of the data buffer is made.  See {@link ByteBuffer.ByteBuffer.take} for a no-copy
     * alternative.
     */
GearyMemoryByteBuffer*
geary_memory_byte_buffer_construct (GType object_type,
                                    guint8* data,
                                    gint data_length1,
                                    gsize filled)
{
	GearyMemoryByteBuffer * self = NULL;
	GBytes* _tmp0_;
	GBytes* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	self = (GearyMemoryByteBuffer*) geary_memory_buffer_construct (object_type);
	_vala_assert (filled <= ((gsize) data_length1), "filled <= data.length");
	_tmp0_ = g_bytes_new (data + 0, ((gint) filled) - 0);
	_g_bytes_unref0 (self->priv->bytes);
	self->priv->bytes = _tmp0_;
	_tmp1_ = self->priv->bytes;
	_tmp2_ = _vala_g_bytes_get_length (_tmp1_);
	_tmp3_ = _tmp2_;
	self->priv->allocated_bytes = (gsize) _tmp3_;
	return self;
}

GearyMemoryByteBuffer*
geary_memory_byte_buffer_new (guint8* data,
                              gint data_length1,
                              gsize filled)
{
	return geary_memory_byte_buffer_construct (GEARY_MEMORY_TYPE_BYTE_BUFFER, data, data_length1, filled);
}

/**
     * filled is the number of usable bytes in the supplied buffer, allocated is the total size
     * of the buffer.
     *
     * filled must be less than or equal to the allocated size of the buffer.
     */
static guint8*
_vala_array_dup9 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

GearyMemoryByteBuffer*
geary_memory_byte_buffer_construct_take (GType object_type,
                                         guint8* data,
                                         gint data_length1,
                                         gsize filled)
{
	GearyMemoryByteBuffer * self = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	GBytes* _tmp1_;
	self = (GearyMemoryByteBuffer*) geary_memory_buffer_construct (object_type);
	_vala_assert (filled <= ((gsize) data_length1), "filled <= data.length");
	_tmp0_ = (data != NULL) ? _vala_array_dup9 (data + 0, ((gint) filled) - 0) : data;
	_tmp0__length1 = ((gint) filled) - 0;
	_tmp1_ = g_bytes_new_take (_tmp0_, _tmp0__length1);
	_g_bytes_unref0 (self->priv->bytes);
	self->priv->bytes = _tmp1_;
	self->priv->allocated_bytes = (gsize) data_length1;
	data = (g_free (data), NULL);
	return self;
}

GearyMemoryByteBuffer*
geary_memory_byte_buffer_new_take (guint8* data,
                                   gint data_length1,
                                   gsize filled)
{
	return geary_memory_byte_buffer_construct_take (GEARY_MEMORY_TYPE_BYTE_BUFFER, data, data_length1, filled);
}

/**
     * Takes ownership and converts a ByteArray to a {@link ByteBuffer}.
     *
     * The ByteArray is freed after this call and should not be used.
     */
static gpointer
_g_byte_array_ref0 (gpointer self)
{
	return self ? g_byte_array_ref (self) : NULL;
}

GearyMemoryByteBuffer*
geary_memory_byte_buffer_construct_from_byte_array (GType object_type,
                                                    GByteArray* byte_array)
{
	GearyMemoryByteBuffer * self = NULL;
	GByteArray* _tmp0_;
	GBytes* _tmp1_;
	GBytes* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (byte_array != NULL, NULL);
	self = (GearyMemoryByteBuffer*) geary_memory_buffer_construct (object_type);
	_tmp0_ = _g_byte_array_ref0 (byte_array);
	_tmp1_ = g_byte_array_free_to_bytes (_tmp0_);
	_g_bytes_unref0 (self->priv->bytes);
	self->priv->bytes = _tmp1_;
	_tmp2_ = self->priv->bytes;
	_tmp3_ = _vala_g_bytes_get_length (_tmp2_);
	_tmp4_ = _tmp3_;
	self->priv->allocated_bytes = (gsize) _tmp4_;
	return self;
}

GearyMemoryByteBuffer*
geary_memory_byte_buffer_new_from_byte_array (GByteArray* byte_array)
{
	return geary_memory_byte_buffer_construct_from_byte_array (GEARY_MEMORY_TYPE_BYTE_BUFFER, byte_array);
}

/**
     * Takes ownership and converts a MemoryOutputStream to a {@link ByteBuffer}.
     *
     * The MemoryOutputStream ''must'' be closed before this call.
     */
GearyMemoryByteBuffer*
geary_memory_byte_buffer_construct_from_memory_output_stream (GType object_type,
                                                              GMemoryOutputStream* mouts)
{
	GearyMemoryByteBuffer * self = NULL;
	GBytes* _tmp0_;
	GBytes* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (mouts, g_memory_output_stream_get_type ()), NULL);
	self = (GearyMemoryByteBuffer*) geary_memory_buffer_construct (object_type);
	_vala_assert (g_output_stream_is_closed (G_TYPE_CHECK_INSTANCE_CAST (mouts, g_output_stream_get_type (), GOutputStream)), "mouts.is_closed()");
	_tmp0_ = g_memory_output_stream_steal_as_bytes (mouts);
	_g_bytes_unref0 (self->priv->bytes);
	self->priv->bytes = _tmp0_;
	_tmp1_ = self->priv->bytes;
	_tmp2_ = _vala_g_bytes_get_length (_tmp1_);
	_tmp3_ = _tmp2_;
	self->priv->allocated_bytes = (gsize) _tmp3_;
	return self;
}

GearyMemoryByteBuffer*
geary_memory_byte_buffer_new_from_memory_output_stream (GMemoryOutputStream* mouts)
{
	return geary_memory_byte_buffer_construct_from_memory_output_stream (GEARY_MEMORY_TYPE_BYTE_BUFFER, mouts);
}

/**
     * {@inheritDoc}
     */
static gpointer
_g_bytes_ref0 (gpointer self)
{
	return self ? g_bytes_ref (self) : NULL;
}

static GBytes*
geary_memory_byte_buffer_real_get_bytes (GearyMemoryBuffer* base)
{
	GearyMemoryByteBuffer * self;
	GBytes* _tmp0_;
	GBytes* _tmp1_;
	GBytes* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MEMORY_TYPE_BYTE_BUFFER, GearyMemoryByteBuffer);
	_tmp0_ = self->priv->bytes;
	_tmp1_ = _g_bytes_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
     * {@inheritDoc}
     */
static guint8*
geary_memory_byte_buffer_real_to_unowned_uint8_array (GearyMemoryUnownedBytesBuffer* base,
                                                      gint* result_length1)
{
	GearyMemoryByteBuffer * self;
	GBytes* _tmp0_;
	gsize _tmp1_ = 0;
	guint8* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_MEMORY_TYPE_BYTE_BUFFER, GearyMemoryByteBuffer);
	_tmp0_ = self->priv->bytes;
	_tmp2_ = g_bytes_get_data (_tmp0_, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static void
geary_memory_byte_buffer_class_init (GearyMemoryByteBufferClass * klass,
                                     gpointer klass_data)
{
	geary_memory_byte_buffer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyMemoryByteBuffer_private_offset);
	((GearyMemoryBufferClass *) klass)->get_bytes = (GBytes* (*) (GearyMemoryBuffer*)) geary_memory_byte_buffer_real_get_bytes;
	GEARY_MEMORY_BUFFER_CLASS (klass)->get_size = geary_memory_byte_buffer_real_get_size;
	GEARY_MEMORY_BUFFER_CLASS (klass)->get_allocated_size = geary_memory_byte_buffer_real_get_allocated_size;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_memory_byte_buffer_get_property;
	G_OBJECT_CLASS (klass)->finalize = geary_memory_byte_buffer_finalize;
	/**
	     * {@inheritDoc}
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_MEMORY_BYTE_BUFFER_SIZE_PROPERTY, geary_memory_byte_buffer_properties[GEARY_MEMORY_BYTE_BUFFER_SIZE_PROPERTY] = g_param_spec_ulong ("size", "size", "size", 0, G_MAXULONG, 0UL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * {@inheritDoc}
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_MEMORY_BYTE_BUFFER_ALLOCATED_SIZE_PROPERTY, geary_memory_byte_buffer_properties[GEARY_MEMORY_BYTE_BUFFER_ALLOCATED_SIZE_PROPERTY] = g_param_spec_ulong ("allocated-size", "allocated-size", "allocated-size", 0, G_MAXULONG, 0UL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_memory_byte_buffer_geary_memory_unowned_bytes_buffer_interface_init (GearyMemoryUnownedBytesBufferIface * iface,
                                                                           gpointer iface_data)
{
	geary_memory_byte_buffer_geary_memory_unowned_bytes_buffer_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_unowned_uint8_array = (guint8* (*) (GearyMemoryUnownedBytesBuffer*, gint*)) geary_memory_byte_buffer_real_to_unowned_uint8_array;
}

static void
geary_memory_byte_buffer_instance_init (GearyMemoryByteBuffer * self,
                                        gpointer klass)
{
	self->priv = geary_memory_byte_buffer_get_instance_private (self);
}

static void
geary_memory_byte_buffer_finalize (GObject * obj)
{
	GearyMemoryByteBuffer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_MEMORY_TYPE_BYTE_BUFFER, GearyMemoryByteBuffer);
	_g_bytes_unref0 (self->priv->bytes);
	G_OBJECT_CLASS (geary_memory_byte_buffer_parent_class)->finalize (obj);
}

/**
 * Allows for a plain block of bytes to be represented as an {@link Buffer}.
 */
 G_GNUC_NO_INLINE static GType
geary_memory_byte_buffer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyMemoryByteBufferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_memory_byte_buffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyMemoryByteBuffer), 0, (GInstanceInitFunc) geary_memory_byte_buffer_instance_init, NULL };
	static const GInterfaceInfo geary_memory_unowned_bytes_buffer_info = { (GInterfaceInitFunc) geary_memory_byte_buffer_geary_memory_unowned_bytes_buffer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_memory_byte_buffer_type_id;
	geary_memory_byte_buffer_type_id = g_type_register_static (GEARY_MEMORY_TYPE_BUFFER, "GearyMemoryByteBuffer", &g_define_type_info, 0);
	g_type_add_interface_static (geary_memory_byte_buffer_type_id, GEARY_MEMORY_TYPE_UNOWNED_BYTES_BUFFER, &geary_memory_unowned_bytes_buffer_info);
	GearyMemoryByteBuffer_private_offset = g_type_add_instance_private (geary_memory_byte_buffer_type_id, sizeof (GearyMemoryByteBufferPrivate));
	return geary_memory_byte_buffer_type_id;
}

GType
geary_memory_byte_buffer_get_type (void)
{
	static gsize geary_memory_byte_buffer_type_id__once = 0;
	if (g_once_init_enter (&geary_memory_byte_buffer_type_id__once)) {
		GType geary_memory_byte_buffer_type_id;
		geary_memory_byte_buffer_type_id = geary_memory_byte_buffer_get_type_once ();
		g_once_init_leave (&geary_memory_byte_buffer_type_id__once, geary_memory_byte_buffer_type_id);
	}
	return geary_memory_byte_buffer_type_id__once;
}

static void
_vala_geary_memory_byte_buffer_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	GearyMemoryByteBuffer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_MEMORY_TYPE_BYTE_BUFFER, GearyMemoryByteBuffer);
	switch (property_id) {
		case GEARY_MEMORY_BYTE_BUFFER_SIZE_PROPERTY:
		g_value_set_ulong (value, geary_memory_buffer_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer)));
		break;
		case GEARY_MEMORY_BYTE_BUFFER_ALLOCATED_SIZE_PROPERTY:
		g_value_set_ulong (value, geary_memory_buffer_get_allocated_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

