/* mime-content-type.c generated by valac 0.56.3, the Vala compiler
 * generated from mime-content-type.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gmime/gmime.h>
#include <gio/gio.h>

enum  {
	GEARY_MIME_CONTENT_TYPE_0_PROPERTY,
	GEARY_MIME_CONTENT_TYPE_MEDIA_TYPE_PROPERTY,
	GEARY_MIME_CONTENT_TYPE_MEDIA_SUBTYPE_PROPERTY,
	GEARY_MIME_CONTENT_TYPE_PARAMS_PROPERTY,
	GEARY_MIME_CONTENT_TYPE_NUM_PROPERTIES
};
static GParamSpec* geary_mime_content_type_properties[GEARY_MIME_CONTENT_TYPE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GMimeParserOptions_free0(var) ((var == NULL) ? NULL : (var = (_vala_GMimeParserOptions_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _GearyMimeContentTypePrivate {
	gchar* _media_type;
	gchar* _media_subtype;
	GearyMimeContentParameters* _params;
};

static gint GearyMimeContentType_private_offset;
static gpointer geary_mime_content_type_parent_class = NULL;
GearyMimeContentType* geary_mime_content_type_DISPLAY_DEFAULT = NULL;
GearyMimeContentType* geary_mime_content_type_ATTACHMENT_DEFAULT = NULL;
static GeeMap* geary_mime_content_type_TYPES_TO_EXTENSIONS;
static GeeMap* geary_mime_content_type_TYPES_TO_EXTENSIONS = NULL;

VALA_EXTERN GearyMimeContentType* geary_mime_content_type_new_from_gmime (GMimeContentType* content_type);
VALA_EXTERN GearyMimeContentType* geary_mime_content_type_construct_from_gmime (GType object_type,
                                                                    GMimeContentType* content_type);
static void _vala_GMimeParserOptions_free (GMimeParserOptions* self);
static guint8* _vala_array_dup11 (guint8* self,
                           gssize length);
static guint8* _vala_array_dup12 (guint8* self,
                           gssize length);
static void geary_mime_content_type_set_media_type (GearyMimeContentType* self,
                                             const gchar* value);
static void geary_mime_content_type_set_media_subtype (GearyMimeContentType* self,
                                                const gchar* value);
static void geary_mime_content_type_set_params (GearyMimeContentType* self,
                                         GearyMimeContentParameters* value);
VALA_EXTERN GearyMimeContentParameters* geary_mime_content_parameters_new_from_gmime (GMimeParamList* gmime);
VALA_EXTERN GearyMimeContentParameters* geary_mime_content_parameters_construct_from_gmime (GType object_type,
                                                                                GMimeParamList* gmime);
static void geary_mime_content_type_finalize (GObject * obj);
static GType geary_mime_content_type_get_type_once (void);
static void _vala_geary_mime_content_type_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_geary_mime_content_type_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
geary_mime_content_type_get_instance_private (GearyMimeContentType* self)
{
	return G_STRUCT_MEMBER_P (self, GearyMimeContentType_private_offset);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
_vala_GMimeParserOptions_free (GMimeParserOptions* self)
{
	g_boxed_free (g_mime_parser_options_get_type (), self);
}

GearyMimeContentType*
geary_mime_content_type_parse (const gchar* str,
                               GError** error)
{
	GMimeParserOptions* _tmp2_;
	GMimeParserOptions* _tmp3_;
	GMimeContentType* _tmp4_;
	GMimeContentType* _tmp5_;
	GearyMimeContentType* _tmp6_;
	GearyMimeContentType* _tmp7_;
	GError* _inner_error0_ = NULL;
	GearyMimeContentType* result;
	g_return_val_if_fail (str != NULL, NULL);
	if (geary_string_is_empty (str)) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (GEARY_MIME_ERROR, GEARY_MIME_ERROR_PARSE, "Empty MIME Content-Type");
		_inner_error0_ = _tmp0_;
		if (_inner_error0_->domain == GEARY_MIME_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (!string_contains (str, "/")) {
		GError* _tmp1_;
		_tmp1_ = g_error_new (GEARY_MIME_ERROR, GEARY_MIME_ERROR_PARSE, "Invalid MIME Content-Type: %s", str);
		_inner_error0_ = _tmp1_;
		if (_inner_error0_->domain == GEARY_MIME_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp2_ = geary_rf_c822_get_parser_options ();
	_tmp3_ = _tmp2_;
	_tmp4_ = g_mime_content_type_parse (_tmp3_, str);
	_tmp5_ = _tmp4_;
	_tmp6_ = geary_mime_content_type_new_from_gmime (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	__vala_GMimeParserOptions_free0 (_tmp3_);
	result = _tmp7_;
	return result;
}

/**
     * Attempts to guess the content type for a buffer using GIO sniffing.
     *
     * Returns null if it could not be guessed.
     */
static GBytes*
_vala_g_bytes_slice (GBytes* self,
                     gsize start,
                     gsize end)
{
	GBytes* _tmp0_;
	GBytes* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_bytes_new_from_bytes (self, start, end - start);
	result = _tmp0_;
	return result;
}

static guint8*
_vala_array_dup11 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static guint8*
_vala_array_dup12 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

GearyMimeContentType*
geary_mime_content_type_guess_type (const gchar* file_name,
                                    GearyMemoryBuffer* buf,
                                    GError** error)
{
	gchar* mime_type = NULL;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	GearyMimeContentType* _tmp23_ = NULL;
	const gchar* _tmp24_;
	GError* _inner_error0_ = NULL;
	GearyMimeContentType* result;
	g_return_val_if_fail ((buf == NULL) || GEARY_MEMORY_IS_BUFFER (buf), NULL);
	mime_type = NULL;
	if (file_name != NULL) {
		gchar* glib_type = NULL;
		gchar* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp0_ = g_content_type_guess (file_name, NULL, (gsize) 0, NULL);
		glib_type = _tmp0_;
		_tmp1_ = glib_type;
		_tmp2_ = g_content_type_get_mime_type (_tmp1_);
		_g_free0 (mime_type);
		mime_type = _tmp2_;
		_tmp3_ = mime_type;
		if (geary_string_is_empty (_tmp3_)) {
			_g_free0 (mime_type);
			mime_type = NULL;
		}
		_g_free0 (glib_type);
	}
	_tmp5_ = mime_type;
	if (_tmp5_ == NULL) {
		_tmp4_ = buf != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gint max_len = 0;
		guint8* _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		gint __tmp6__size_ = 0;
		gsize _tmp7_;
		gsize _tmp8_;
		guint8* data = NULL;
		guint8* _tmp18_;
		gint _tmp18__length1;
		gint data_length1;
		gint _data_size_;
		gchar* glib_type = NULL;
		guint8* _tmp19_;
		gint _tmp19__length1;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		max_len = 4096;
		_tmp7_ = geary_memory_buffer_get_size (buf);
		_tmp8_ = _tmp7_;
		if (_tmp8_ <= ((gsize) max_len)) {
			gint _tmp9_ = 0;
			guint8* _tmp10_;
			_tmp10_ = geary_memory_buffer_get_uint8_array (buf, &_tmp9_);
			_tmp6_ = (g_free (_tmp6_), NULL);
			_tmp6_ = _tmp10_;
			_tmp6__length1 = _tmp9_;
			__tmp6__size_ = _tmp6__length1;
		} else {
			GBytes* _tmp11_;
			GBytes* _tmp12_;
			GBytes* _tmp13_;
			GBytes* _tmp14_;
			gsize _tmp15_ = 0;
			guint8* _tmp16_;
			guint8* _tmp17_;
			gint _tmp17__length1;
			_tmp11_ = geary_memory_buffer_get_bytes (buf);
			_tmp12_ = _tmp11_;
			_tmp13_ = _vala_g_bytes_slice (_tmp12_, (gsize) 0, (gsize) max_len);
			_tmp14_ = _tmp13_;
			_tmp16_ = g_bytes_get_data (_tmp14_, &_tmp15_);
			_tmp17_ = (_tmp16_ != NULL) ? _vala_array_dup11 (_tmp16_, _tmp15_) : _tmp16_;
			_tmp17__length1 = _tmp15_;
			_tmp6_ = (g_free (_tmp6_), NULL);
			_tmp6_ = _tmp17_;
			_tmp6__length1 = _tmp17__length1;
			__tmp6__size_ = _tmp6__length1;
			_g_bytes_unref0 (_tmp14_);
			_g_bytes_unref0 (_tmp12_);
		}
		_tmp18_ = (_tmp6_ != NULL) ? _vala_array_dup12 (_tmp6_, _tmp6__length1) : _tmp6_;
		_tmp18__length1 = _tmp6__length1;
		data = _tmp18_;
		data_length1 = _tmp18__length1;
		_data_size_ = data_length1;
		_tmp19_ = data;
		_tmp19__length1 = data_length1;
		_tmp20_ = g_content_type_guess (NULL, _tmp19_, (gsize) _tmp19__length1, NULL);
		glib_type = _tmp20_;
		_tmp21_ = glib_type;
		_tmp22_ = g_content_type_get_mime_type (_tmp21_);
		_g_free0 (mime_type);
		mime_type = _tmp22_;
		_g_free0 (glib_type);
		data = (g_free (data), NULL);
		_tmp6_ = (g_free (_tmp6_), NULL);
	}
	_tmp24_ = mime_type;
	if (!geary_string_is_empty_or_whitespace (_tmp24_)) {
		const gchar* _tmp25_;
		GearyMimeContentType* _tmp26_;
		_tmp25_ = mime_type;
		_tmp26_ = geary_mime_content_type_parse (_tmp25_, &_inner_error0_);
		_g_object_unref0 (_tmp23_);
		_tmp23_ = _tmp26_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (_tmp23_);
			_g_free0 (mime_type);
			return NULL;
		}
	} else {
		_g_object_unref0 (_tmp23_);
		_tmp23_ = NULL;
	}
	result = _tmp23_;
	_g_free0 (mime_type);
	return result;
}

const gchar*
geary_mime_content_type_get_media_type (GearyMimeContentType* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_TYPE (self), NULL);
	_tmp0_ = self->priv->_media_type;
	result = _tmp0_;
	return result;
}

static void
geary_mime_content_type_set_media_type (GearyMimeContentType* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_MIME_IS_CONTENT_TYPE (self));
	old_value = geary_mime_content_type_get_media_type (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_media_type);
		self->priv->_media_type = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_mime_content_type_properties[GEARY_MIME_CONTENT_TYPE_MEDIA_TYPE_PROPERTY]);
	}
}

const gchar*
geary_mime_content_type_get_media_subtype (GearyMimeContentType* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_TYPE (self), NULL);
	_tmp0_ = self->priv->_media_subtype;
	result = _tmp0_;
	return result;
}

static void
geary_mime_content_type_set_media_subtype (GearyMimeContentType* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_MIME_IS_CONTENT_TYPE (self));
	old_value = geary_mime_content_type_get_media_subtype (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_media_subtype);
		self->priv->_media_subtype = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_mime_content_type_properties[GEARY_MIME_CONTENT_TYPE_MEDIA_SUBTYPE_PROPERTY]);
	}
}

GearyMimeContentParameters*
geary_mime_content_type_get_params (GearyMimeContentType* self)
{
	GearyMimeContentParameters* result;
	GearyMimeContentParameters* _tmp0_;
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_TYPE (self), NULL);
	_tmp0_ = self->priv->_params;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_mime_content_type_set_params (GearyMimeContentType* self,
                                    GearyMimeContentParameters* value)
{
	GearyMimeContentParameters* old_value;
	g_return_if_fail (GEARY_MIME_IS_CONTENT_TYPE (self));
	old_value = geary_mime_content_type_get_params (self);
	if (old_value != value) {
		GearyMimeContentParameters* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_params);
		self->priv->_params = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_mime_content_type_properties[GEARY_MIME_CONTENT_TYPE_PARAMS_PROPERTY]);
	}
}

/**
     * Create a MIME Content-Type representative object.
     */
static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

GearyMimeContentType*
geary_mime_content_type_construct (GType object_type,
                                   const gchar* media_type,
                                   const gchar* media_subtype,
                                   GearyMimeContentParameters* params)
{
	GearyMimeContentType * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GearyMimeContentParameters* _tmp4_ = NULL;
	GearyMimeContentParameters* _tmp5_;
	g_return_val_if_fail (media_type != NULL, NULL);
	g_return_val_if_fail (media_subtype != NULL, NULL);
	g_return_val_if_fail ((params == NULL) || GEARY_MIME_IS_CONTENT_PARAMETERS (params), NULL);
	self = (GearyMimeContentType*) geary_base_object_construct (object_type);
	_tmp0_ = string_strip (media_type);
	_tmp1_ = _tmp0_;
	geary_mime_content_type_set_media_type (self, _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = string_strip (media_subtype);
	_tmp3_ = _tmp2_;
	geary_mime_content_type_set_media_subtype (self, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp5_ = _g_object_ref0 (params);
	_tmp4_ = _tmp5_;
	if (_tmp4_ == NULL) {
		GearyMimeContentParameters* _tmp6_;
		_tmp6_ = geary_mime_content_parameters_new (NULL);
		_g_object_unref0 (_tmp4_);
		_tmp4_ = _tmp6_;
	}
	geary_mime_content_type_set_params (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	return self;
}

GearyMimeContentType*
geary_mime_content_type_new (const gchar* media_type,
                             const gchar* media_subtype,
                             GearyMimeContentParameters* params)
{
	return geary_mime_content_type_construct (GEARY_MIME_TYPE_CONTENT_TYPE, media_type, media_subtype, params);
}

GearyMimeContentType*
geary_mime_content_type_construct_from_gmime (GType object_type,
                                              GMimeContentType* content_type)
{
	GearyMimeContentType * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GMimeParamList* _tmp6_;
	GearyMimeContentParameters* _tmp7_;
	GearyMimeContentParameters* _tmp8_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (content_type, g_mime_content_type_get_type ()), NULL);
	self = (GearyMimeContentType*) geary_base_object_construct (object_type);
	_tmp0_ = g_mime_content_type_get_media_type (content_type);
	_tmp1_ = string_strip (_tmp0_);
	_tmp2_ = _tmp1_;
	geary_mime_content_type_set_media_type (self, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = g_mime_content_type_get_media_subtype (content_type);
	_tmp4_ = string_strip (_tmp3_);
	_tmp5_ = _tmp4_;
	geary_mime_content_type_set_media_subtype (self, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = g_mime_content_type_get_parameters (content_type);
	_tmp7_ = geary_mime_content_parameters_new_from_gmime (_tmp6_);
	_tmp8_ = _tmp7_;
	geary_mime_content_type_set_params (self, _tmp8_);
	_g_object_unref0 (_tmp8_);
	return self;
}

GearyMimeContentType*
geary_mime_content_type_new_from_gmime (GMimeContentType* content_type)
{
	return geary_mime_content_type_construct_from_gmime (GEARY_MIME_TYPE_CONTENT_TYPE, content_type);
}

/**
     * Compares the {@link media_type} with the supplied type.
     *
     * An asterisk ("*") or {@link WILDCARD} are accepted, which will always return true.
     *
     * @see is_type
     */
gboolean
geary_mime_content_type_has_media_type (GearyMimeContentType* self,
                                        const gchar* media_type)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_TYPE (self), FALSE);
	g_return_val_if_fail (media_type != NULL, FALSE);
	if (g_strcmp0 (media_type, GEARY_MIME_CONTENT_TYPE_WILDCARD) != 0) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->_media_type;
		_tmp0_ = geary_ascii_stri_equal (_tmp1_, media_type);
	} else {
		_tmp0_ = TRUE;
	}
	result = _tmp0_;
	return result;
}

/**
     * Compares the {@link media_subtype} with the supplied subtype.
     *
     * An asterisk ("*") or {@link WILDCARD} are accepted, which will always return true.
     *
     * @see is_type
     */
gboolean
geary_mime_content_type_has_media_subtype (GearyMimeContentType* self,
                                           const gchar* media_subtype)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_TYPE (self), FALSE);
	g_return_val_if_fail (media_subtype != NULL, FALSE);
	if (g_strcmp0 (media_subtype, GEARY_MIME_CONTENT_TYPE_WILDCARD) != 0) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->_media_subtype;
		_tmp0_ = geary_ascii_stri_equal (_tmp1_, media_subtype);
	} else {
		_tmp0_ = TRUE;
	}
	result = _tmp0_;
	return result;
}

/**
     * Returns the {@link ContentType}'s media content type (its "MIME type").
     *
     * This returns the bare MIME content type description lacking all parameters.  For example,
     * "image/jpeg; name='photo.JPG'" will be returned as "image/jpeg".
     *
     * @see serialize
     */
gchar*
geary_mime_content_type_get_mime_type (GearyMimeContentType* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_TYPE (self), NULL);
	_tmp0_ = self->priv->_media_type;
	_tmp1_ = self->priv->_media_subtype;
	_tmp2_ = g_strdup_printf ("%s/%s", _tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}

/**
     * Returns the file name extension for this type, if known.
     */
gchar*
geary_mime_content_type_get_file_name_extension (GearyMimeContentType* self)
{
	GeeMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gpointer _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_TYPE (self), NULL);
	_tmp0_ = geary_mime_content_type_TYPES_TO_EXTENSIONS;
	_tmp1_ = geary_mime_content_type_get_mime_type (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_map_get (_tmp0_, _tmp2_);
	_tmp4_ = (gchar*) _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

/**
     * Compares the supplied type and subtype with this instance's.
     *
     * Asterisks (or {@link WILDCARD}) may be supplied for either field.
     *
     * @see is_same
     */
gboolean
geary_mime_content_type_is_type (GearyMimeContentType* self,
                                 const gchar* media_type,
                                 const gchar* media_subtype)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_TYPE (self), FALSE);
	g_return_val_if_fail (media_type != NULL, FALSE);
	g_return_val_if_fail (media_subtype != NULL, FALSE);
	if (geary_mime_content_type_has_media_type (self, media_type)) {
		_tmp0_ = geary_mime_content_type_has_media_subtype (self, media_subtype);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
     * Compares this {@link ContentType} with another instance.
     *
     * This is slightly different than the notion of "equal to", as it's possible for
     * {@link ContentType} to hold {@link WILDCARD}s, which don't imply equality.
     *
     * @see is_type
     */
gboolean
geary_mime_content_type_is_same (GearyMimeContentType* self,
                                 GearyMimeContentType* other)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_TYPE (self), FALSE);
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_TYPE (other), FALSE);
	_tmp0_ = other->priv->_media_type;
	_tmp1_ = other->priv->_media_subtype;
	result = geary_mime_content_type_is_type (self, _tmp0_, _tmp1_);
	return result;
}

/**
     * Compares the supplied MIME type (i.e. "image/jpeg") with this instance.
     *
     * As in {@link get_mime_type}, this method is only worried about the media type and subtype
     * in the supplied string.  Parameters are ignored.
     *
     * Throws {@link MimeError} if the supplied string doesn't look like a MIME type.
     */
static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gboolean
geary_mime_content_type_is_mime_type (GearyMimeContentType* self,
                                      const gchar* mime_type,
                                      GError** error)
{
	gint index = 0;
	gchar* mime_media_type = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* mime_media_subtype = NULL;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_TYPE (self), FALSE);
	g_return_val_if_fail (mime_type != NULL, FALSE);
	index = string_index_of_char (mime_type, (gunichar) '/', 0);
	if (index < 0) {
		GError* _tmp0_;
		_tmp0_ = g_error_new (GEARY_MIME_ERROR, GEARY_MIME_ERROR_PARSE, "Invalid MIME type: %s", mime_type);
		_inner_error0_ = _tmp0_;
		if (_inner_error0_->domain == GEARY_MIME_ERROR) {
			gboolean _tmp1_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp1_;
		} else {
			gboolean _tmp2_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp2_;
		}
	}
	_tmp3_ = string_substring (mime_type, (glong) 0, (glong) index);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_strip (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	mime_media_type = _tmp6_;
	_tmp7_ = string_substring (mime_type, (glong) (index + 1), (glong) -1);
	mime_media_subtype = _tmp7_;
	_tmp8_ = mime_media_subtype;
	index = string_index_of_char (_tmp8_, (gunichar) ';', 0);
	if (index >= 0) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = mime_media_subtype;
		_tmp10_ = string_substring (_tmp9_, (glong) 0, (glong) index);
		_g_free0 (mime_media_subtype);
		mime_media_subtype = _tmp10_;
	}
	_tmp11_ = mime_media_subtype;
	_tmp12_ = string_strip (_tmp11_);
	_g_free0 (mime_media_subtype);
	mime_media_subtype = _tmp12_;
	_tmp14_ = mime_media_type;
	if (geary_string_is_empty (_tmp14_)) {
		_tmp13_ = TRUE;
	} else {
		const gchar* _tmp15_;
		_tmp15_ = mime_media_subtype;
		_tmp13_ = geary_string_is_empty (_tmp15_);
	}
	if (_tmp13_) {
		GError* _tmp16_;
		_tmp16_ = g_error_new (GEARY_MIME_ERROR, GEARY_MIME_ERROR_PARSE, "Invalid MIME type: %s", mime_type);
		_inner_error0_ = _tmp16_;
		if (_inner_error0_->domain == GEARY_MIME_ERROR) {
			gboolean _tmp17_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (mime_media_subtype);
			_g_free0 (mime_media_type);
			return _tmp17_;
		} else {
			gboolean _tmp18_ = FALSE;
			_g_free0 (mime_media_subtype);
			_g_free0 (mime_media_type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp18_;
		}
	}
	_tmp19_ = mime_media_type;
	_tmp20_ = mime_media_subtype;
	result = geary_mime_content_type_is_type (self, _tmp19_, _tmp20_);
	_g_free0 (mime_media_subtype);
	_g_free0 (mime_media_type);
	return result;
}

gchar*
geary_mime_content_type_serialize (GearyMimeContentType* self)
{
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GearyMimeContentParameters* _tmp5_;
	GString* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* result;
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_TYPE (self), NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = builder;
	_tmp2_ = self->priv->_media_type;
	_tmp3_ = self->priv->_media_subtype;
	g_string_append_printf (_tmp1_, "%s/%s", _tmp2_, _tmp3_);
	_tmp5_ = self->priv->_params;
	if (_tmp5_ != NULL) {
		GearyMimeContentParameters* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = self->priv->_params;
		_tmp7_ = geary_mime_content_parameters_get_size (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp4_ = _tmp8_ > 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		{
			GeeIterator* _attribute_it = NULL;
			GearyMimeContentParameters* _tmp9_;
			GeeCollection* _tmp10_;
			GeeCollection* _tmp11_;
			GeeCollection* _tmp12_;
			GeeIterator* _tmp13_;
			GeeIterator* _tmp14_;
			_tmp9_ = self->priv->_params;
			_tmp10_ = geary_mime_content_parameters_get_attributes (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = _tmp11_;
			_tmp13_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ITERABLE, GeeIterable));
			_tmp14_ = _tmp13_;
			_g_object_unref0 (_tmp12_);
			_attribute_it = _tmp14_;
			while (TRUE) {
				GeeIterator* _tmp15_;
				gchar* attribute = NULL;
				GeeIterator* _tmp16_;
				gpointer _tmp17_;
				gchar* value = NULL;
				GearyMimeContentParameters* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				const gchar* _tmp21_;
				_tmp15_ = _attribute_it;
				if (!gee_iterator_next (_tmp15_)) {
					break;
				}
				_tmp16_ = _attribute_it;
				_tmp17_ = gee_iterator_get (_tmp16_);
				attribute = (gchar*) _tmp17_;
				_tmp18_ = self->priv->_params;
				_tmp19_ = attribute;
				_tmp20_ = geary_mime_content_parameters_get_value (_tmp18_, _tmp19_);
				value = _tmp20_;
				_tmp21_ = value;
				switch (geary_mime_data_format_get_encoding_requirement (_tmp21_)) {
					case GEARY_MIME_DATA_FORMAT_ENCODING_QUOTING_OPTIONAL:
					{
						GString* _tmp22_;
						const gchar* _tmp23_;
						const gchar* _tmp24_;
						_tmp22_ = builder;
						_tmp23_ = attribute;
						_tmp24_ = value;
						g_string_append_printf (_tmp22_, "; %s=%s", _tmp23_, _tmp24_);
						break;
					}
					case GEARY_MIME_DATA_FORMAT_ENCODING_QUOTING_REQUIRED:
					{
						GString* _tmp25_;
						const gchar* _tmp26_;
						const gchar* _tmp27_;
						_tmp25_ = builder;
						_tmp26_ = attribute;
						_tmp27_ = value;
						g_string_append_printf (_tmp25_, "; %s=\"%s\"", _tmp26_, _tmp27_);
						break;
					}
					case GEARY_MIME_DATA_FORMAT_ENCODING_UNALLOWED:
					{
						const gchar* _tmp28_;
						const gchar* _tmp29_;
						_tmp28_ = attribute;
						_tmp29_ = value;
						g_message ("mime-content-type.vala:280: Cannot encode ContentType param value %s=\"" \
"%s\": unallowed", _tmp28_, _tmp29_);
						break;
					}
					default:
					{
						g_assert_not_reached ();
					}
				}
				_g_free0 (value);
				_g_free0 (attribute);
			}
			_g_object_unref0 (_attribute_it);
		}
	}
	_tmp30_ = builder;
	_tmp31_ = _tmp30_->str;
	_tmp32_ = g_strdup (_tmp31_);
	result = _tmp32_;
	_g_string_free0 (builder);
	return result;
}

gchar*
geary_mime_content_type_to_string (GearyMimeContentType* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (GEARY_MIME_IS_CONTENT_TYPE (self), NULL);
	_tmp0_ = geary_mime_content_type_serialize (self);
	result = _tmp0_;
	return result;
}

static void
geary_mime_content_type_class_init (GearyMimeContentTypeClass * klass,
                                    gpointer klass_data)
{
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	GearyMimeContentParameters* _tmp5_;
	GearyMimeContentParameters* _tmp6_;
	GearyMimeContentType* _tmp7_;
	GearyMimeContentType* _tmp8_;
	GeeMap* _tmp9_;
	GeeMap* _tmp10_;
	GeeMap* _tmp11_;
	GeeMap* _tmp12_;
	GeeMap* _tmp13_;
	GeeMap* _tmp14_;
	geary_mime_content_type_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyMimeContentType_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_mime_content_type_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_mime_content_type_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_mime_content_type_finalize;
	/**
	     * The type (discrete or concrete) portion of the Content-Type field.
	     *
	     * It's highly recommended the caller use the various ''has'' and ''is'' methods when performing
	     * comparisons rather than direct string operations.
	     *
	     * media_type may be {@link WILDCARD}, in which case it matches with any other media_type.
	     *
	     * @see has_media_type
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_MIME_CONTENT_TYPE_MEDIA_TYPE_PROPERTY, geary_mime_content_type_properties[GEARY_MIME_CONTENT_TYPE_MEDIA_TYPE_PROPERTY] = g_param_spec_string ("media-type", "media-type", "media-type", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * The subtype (extension-token or iana-token) portion of the Content-Type field.
	     *
	     * It's highly recommended the caller use the various ''has'' and ''is'' methods when performing
	     * comparisons rather than direct string operations.
	     *
	     * media_subtype may be {@link WILDCARD}, in which case it matches with any other media_subtype.
	     *
	     * @see has_media_subtype
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_MIME_CONTENT_TYPE_MEDIA_SUBTYPE_PROPERTY, geary_mime_content_type_properties[GEARY_MIME_CONTENT_TYPE_MEDIA_SUBTYPE_PROPERTY] = g_param_spec_string ("media-subtype", "media-subtype", "media-subtype", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Content parameters, if any, in the Content-Type field.
	     *
	     * This is never null.  Rather, an empty ContentParameters is held if the Content-Type has
	     * no parameters.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_MIME_CONTENT_TYPE_PARAMS_PROPERTY, geary_mime_content_type_properties[GEARY_MIME_CONTENT_TYPE_PARAMS_PROPERTY] = g_param_spec_object ("params", "params", "params", GEARY_MIME_TYPE_CONTENT_PARAMETERS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	geary_mime_content_type_TYPES_TO_EXTENSIONS = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap);
	_tmp1_ = g_strdup ("charset");
	_tmp2_ = g_strdup ("us-ascii");
	_tmp3_ = g_new0 (gchar*, (1 * 2) + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	_tmp4__length2 = 2;
	_tmp5_ = geary_mime_content_parameters_new_from_array (_tmp4_, 1, 2);
	_tmp6_ = _tmp5_;
	_tmp7_ = geary_mime_content_type_new ("text", "plain", _tmp6_);
	_g_object_unref0 (geary_mime_content_type_DISPLAY_DEFAULT);
	geary_mime_content_type_DISPLAY_DEFAULT = _tmp7_;
	_g_object_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1 * _tmp4__length2, (GDestroyNotify) g_free), NULL);
	_tmp8_ = geary_mime_content_type_new ("application", "octet-stream", NULL);
	_g_object_unref0 (geary_mime_content_type_ATTACHMENT_DEFAULT);
	geary_mime_content_type_ATTACHMENT_DEFAULT = _tmp8_;
	_tmp9_ = geary_mime_content_type_TYPES_TO_EXTENSIONS;
	gee_map_set (_tmp9_, "image/jpeg", ".jpeg");
	_tmp10_ = geary_mime_content_type_TYPES_TO_EXTENSIONS;
	gee_map_set (_tmp10_, "image/png", ".png");
	_tmp11_ = geary_mime_content_type_TYPES_TO_EXTENSIONS;
	gee_map_set (_tmp11_, "image/gif", ".gif");
	_tmp12_ = geary_mime_content_type_TYPES_TO_EXTENSIONS;
	gee_map_set (_tmp12_, "image/svg+xml", ".svg");
	_tmp13_ = geary_mime_content_type_TYPES_TO_EXTENSIONS;
	gee_map_set (_tmp13_, "image/bmp", ".bmp");
	_tmp14_ = geary_mime_content_type_TYPES_TO_EXTENSIONS;
	gee_map_set (_tmp14_, "image/x-bmp", ".bmp");
}

static void
geary_mime_content_type_instance_init (GearyMimeContentType * self,
                                       gpointer klass)
{
	self->priv = geary_mime_content_type_get_instance_private (self);
}

static void
geary_mime_content_type_finalize (GObject * obj)
{
	GearyMimeContentType * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_MIME_TYPE_CONTENT_TYPE, GearyMimeContentType);
	_g_free0 (self->priv->_media_type);
	_g_free0 (self->priv->_media_subtype);
	_g_object_unref0 (self->priv->_params);
	G_OBJECT_CLASS (geary_mime_content_type_parent_class)->finalize (obj);
}

/**
 * A representation of an RFC 2045 MIME Content-Type field.
 *
 * See [[https://tools.ietf.org/html/rfc2045#section-5]]
 *
 * This class is immutable.
 */
 G_GNUC_NO_INLINE static GType
geary_mime_content_type_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyMimeContentTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_mime_content_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyMimeContentType), 0, (GInstanceInitFunc) geary_mime_content_type_instance_init, NULL };
	GType geary_mime_content_type_type_id;
	geary_mime_content_type_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearyMimeContentType", &g_define_type_info, 0);
	GearyMimeContentType_private_offset = g_type_add_instance_private (geary_mime_content_type_type_id, sizeof (GearyMimeContentTypePrivate));
	return geary_mime_content_type_type_id;
}

GType
geary_mime_content_type_get_type (void)
{
	static gsize geary_mime_content_type_type_id__once = 0;
	if (g_once_init_enter (&geary_mime_content_type_type_id__once)) {
		GType geary_mime_content_type_type_id;
		geary_mime_content_type_type_id = geary_mime_content_type_get_type_once ();
		g_once_init_leave (&geary_mime_content_type_type_id__once, geary_mime_content_type_type_id);
	}
	return geary_mime_content_type_type_id__once;
}

static void
_vala_geary_mime_content_type_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GearyMimeContentType * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_MIME_TYPE_CONTENT_TYPE, GearyMimeContentType);
	switch (property_id) {
		case GEARY_MIME_CONTENT_TYPE_MEDIA_TYPE_PROPERTY:
		g_value_set_string (value, geary_mime_content_type_get_media_type (self));
		break;
		case GEARY_MIME_CONTENT_TYPE_MEDIA_SUBTYPE_PROPERTY:
		g_value_set_string (value, geary_mime_content_type_get_media_subtype (self));
		break;
		case GEARY_MIME_CONTENT_TYPE_PARAMS_PROPERTY:
		g_value_set_object (value, geary_mime_content_type_get_params (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_mime_content_type_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	GearyMimeContentType * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_MIME_TYPE_CONTENT_TYPE, GearyMimeContentType);
	switch (property_id) {
		case GEARY_MIME_CONTENT_TYPE_MEDIA_TYPE_PROPERTY:
		geary_mime_content_type_set_media_type (self, g_value_get_string (value));
		break;
		case GEARY_MIME_CONTENT_TYPE_MEDIA_SUBTYPE_PROPERTY:
		geary_mime_content_type_set_media_subtype (self, g_value_get_string (value));
		break;
		case GEARY_MIME_CONTENT_TYPE_PARAMS_PROPERTY:
		geary_mime_content_type_set_params (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

