/* mime-multipart-subtype.c generated by valac 0.56.3, the Vala compiler
 * generated from mime-multipart-subtype.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

/**
 * A representation of a MIME multipart Content-Type subtype.
 *
 * See [[https://tools.ietf.org/html/rfc2046#section-5.1]]
 */
/**
     * Converts a {@link ContentType} into a {@link MultipartSubtype}.
     *
     * If unknown, {@link MIXED} is returned but is_unknown will be true.
     */
GearyMimeMultipartSubtype
geary_mime_multipart_subtype_from_content_type (GearyMimeContentType* content_type,
                                                gboolean* is_unknown)
{
	gboolean _vala_is_unknown = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	static GQuark _tmp5_label2 = 0;
	GearyMimeMultipartSubtype result;
	g_return_val_if_fail ((content_type == NULL) || GEARY_MIME_IS_CONTENT_TYPE (content_type), 0);
	if (content_type == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !geary_mime_content_type_has_media_type (content_type, "multipart");
	}
	if (_tmp0_) {
		_vala_is_unknown = TRUE;
		result = GEARY_MIME_MULTIPART_SUBTYPE_MIXED;
		if (is_unknown) {
			*is_unknown = _vala_is_unknown;
		}
		return result;
	}
	_vala_is_unknown = FALSE;
	_tmp1_ = geary_mime_content_type_get_media_subtype (content_type);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_ascii_strdown (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	g_free (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("mixed")))) {
		switch (0) {
			default:
			{
				result = GEARY_MIME_MULTIPART_SUBTYPE_MIXED;
				if (is_unknown) {
					*is_unknown = _vala_is_unknown;
				}
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("alternative")))) {
		switch (0) {
			default:
			{
				result = GEARY_MIME_MULTIPART_SUBTYPE_ALTERNATIVE;
				if (is_unknown) {
					*is_unknown = _vala_is_unknown;
				}
				return result;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("related")))) {
		switch (0) {
			default:
			{
				result = GEARY_MIME_MULTIPART_SUBTYPE_RELATED;
				if (is_unknown) {
					*is_unknown = _vala_is_unknown;
				}
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				_vala_is_unknown = TRUE;
				result = GEARY_MIME_MULTIPART_SUBTYPE_MIXED;
				if (is_unknown) {
					*is_unknown = _vala_is_unknown;
				}
				return result;
			}
		}
	}
}

 G_GNUC_NO_INLINE static GType
geary_mime_multipart_subtype_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_MIME_MULTIPART_SUBTYPE_UNSPECIFIED, "GEARY_MIME_MULTIPART_SUBTYPE_UNSPECIFIED", "unspecified"}, {GEARY_MIME_MULTIPART_SUBTYPE_MIXED, "GEARY_MIME_MULTIPART_SUBTYPE_MIXED", "mixed"}, {GEARY_MIME_MULTIPART_SUBTYPE_ALTERNATIVE, "GEARY_MIME_MULTIPART_SUBTYPE_ALTERNATIVE", "alternative"}, {GEARY_MIME_MULTIPART_SUBTYPE_RELATED, "GEARY_MIME_MULTIPART_SUBTYPE_RELATED", "related"}, {0, NULL, NULL}};
	GType geary_mime_multipart_subtype_type_id;
	geary_mime_multipart_subtype_type_id = g_enum_register_static ("GearyMimeMultipartSubtype", values);
	return geary_mime_multipart_subtype_type_id;
}

GType
geary_mime_multipart_subtype_get_type (void)
{
	static gsize geary_mime_multipart_subtype_type_id__once = 0;
	if (g_once_init_enter (&geary_mime_multipart_subtype_type_id__once)) {
		GType geary_mime_multipart_subtype_type_id;
		geary_mime_multipart_subtype_type_id = geary_mime_multipart_subtype_get_type_once ();
		g_once_init_leave (&geary_mime_multipart_subtype_type_id__once, geary_mime_multipart_subtype_type_id);
	}
	return geary_mime_multipart_subtype_type_id__once;
}

