/* smtp-client-connection.c generated by valac 0.56.3, the Vala compiler
 * generated from smtp-client-connection.vala, do not modify */

/*
 * Copyright © 2016 Software Freedom Conservancy Inc.
 * Copyright © 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>

#define GEARY_SMTP_CLIENT_CONNECTION_DEFAULT_TIMEOUT_SEC ((guint) 20)

#define GEARY_SMTP_TYPE_CLIENT_CONNECTION (geary_smtp_client_connection_get_type ())
#define GEARY_SMTP_CLIENT_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_SMTP_TYPE_CLIENT_CONNECTION, GearySmtpClientConnection))
#define GEARY_SMTP_CLIENT_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_SMTP_TYPE_CLIENT_CONNECTION, GearySmtpClientConnectionClass))
#define GEARY_SMTP_IS_CLIENT_CONNECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_SMTP_TYPE_CLIENT_CONNECTION))
#define GEARY_SMTP_IS_CLIENT_CONNECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_SMTP_TYPE_CLIENT_CONNECTION))
#define GEARY_SMTP_CLIENT_CONNECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_SMTP_TYPE_CLIENT_CONNECTION, GearySmtpClientConnectionClass))

typedef struct _GearySmtpClientConnection GearySmtpClientConnection;
typedef struct _GearySmtpClientConnectionClass GearySmtpClientConnectionClass;
typedef struct _GearySmtpClientConnectionPrivate GearySmtpClientConnectionPrivate;
enum  {
	GEARY_SMTP_CLIENT_CONNECTION_0_PROPERTY,
	GEARY_SMTP_CLIENT_CONNECTION_CAPABILITIES_PROPERTY,
	GEARY_SMTP_CLIENT_CONNECTION_LOGGING_PARENT_PROPERTY,
	GEARY_SMTP_CLIENT_CONNECTION_NUM_PROPERTIES
};
static GParamSpec* geary_smtp_client_connection_properties[GEARY_SMTP_CLIENT_CONNECTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _geary_smtp_response_unref0(var) ((var == NULL) ? NULL : (var = (geary_smtp_response_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GearySmtpClientConnectionConnectAsyncData GearySmtpClientConnectionConnectAsyncData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GearySmtpClientConnectionDisconnectAsyncData GearySmtpClientConnectionDisconnectAsyncData;
#define _geary_smtp_request_unref0(var) ((var == NULL) ? NULL : (var = (geary_smtp_request_unref (var), NULL)))
typedef struct _GearySmtpClientConnectionAuthenticateAsyncData GearySmtpClientConnectionAuthenticateAsyncData;
typedef struct _GearySmtpClientConnectionSendDataAsyncData GearySmtpClientConnectionSendDataAsyncData;
typedef struct _GearySmtpClientConnectionSendRequestAsyncData GearySmtpClientConnectionSendRequestAsyncData;
#define _geary_smtp_response_line_unref0(var) ((var == NULL) ? NULL : (var = (geary_smtp_response_line_unref (var), NULL)))
typedef struct _GearySmtpClientConnectionRecvResponseLinesAsyncData GearySmtpClientConnectionRecvResponseLinesAsyncData;
typedef struct _GearySmtpClientConnectionRecvResponseAsyncData GearySmtpClientConnectionRecvResponseAsyncData;
typedef struct _GearySmtpClientConnectionSayHelloAsyncData GearySmtpClientConnectionSayHelloAsyncData;
typedef struct _GearySmtpClientConnectionEstablishConnectionAsyncData GearySmtpClientConnectionEstablishConnectionAsyncData;
typedef struct _GearySmtpClientConnectionQuitAsyncData GearySmtpClientConnectionQuitAsyncData;
typedef struct _GearySmtpClientConnectionTransactionAsyncData GearySmtpClientConnectionTransactionAsyncData;
typedef struct _GearySmtpClientConnectionReadLineAsyncData GearySmtpClientConnectionReadLineAsyncData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GearySmtpClientConnection {
	GearyBaseObject parent_instance;
	GearySmtpClientConnectionPrivate * priv;
};

struct _GearySmtpClientConnectionClass {
	GearyBaseObjectClass parent_class;
	GearyLoggingState* (*to_logging_state) (GearySmtpClientConnection* self);
};

struct _GearySmtpClientConnectionPrivate {
	GearySmtpCapabilities* _capabilities;
	GearyLoggingSource* _logging_parent;
	GearyEndpoint* endpoint;
	GIOStream* cx;
	GSocketConnection* socket_cx;
	GDataInputStream* dins;
	GDataOutputStream* douts;
};

struct _GearySmtpClientConnectionConnectAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientConnection* self;
	GCancellable* cancellable;
	GearySmtpGreeting* result;
	GIOStream* _tmp0_;
	GSocketConnection* _tmp1_;
	GearyEndpoint* _tmp2_;
	GSocketConnection* _tmp3_;
	GSocketConnection* _tmp4_;
	GSocketConnection* _tmp5_;
	GIOStream* _tmp6_;
	GIOStream* _tmp7_;
	GeeList* _tmp8_;
	GeeList* _tmp9_;
	GearySmtpGreeting* greeting;
	GearySmtpGreeting* _tmp10_;
	GearySmtpGreeting* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GError* _inner_error0_;
};

struct _GearySmtpClientConnectionDisconnectAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientConnection* self;
	GCancellable* cancellable;
	gboolean result;
	GIOStream* _tmp0_;
	GError* disconnect_error;
	GIOStream* _tmp1_;
	GError* err;
	GError* _tmp2_;
	GError* _tmp3_;
	GError* _tmp4_;
	GError* _tmp5_;
	GError* _tmp6_;
	GError* _inner_error0_;
};

struct _GearySmtpClientConnectionAuthenticateAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientConnection* self;
	GearySmtpAuthenticator* authenticator;
	GCancellable* cancellable;
	GearySmtpResponse* result;
	GearySmtpResponse* response;
	GearySmtpRequest* _tmp0_;
	GearySmtpRequest* _tmp1_;
	GearySmtpResponse* _tmp2_;
	GearySmtpResponse* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint step;
	GearySmtpResponse* _tmp6_;
	GearySmtpResponseCode* _tmp7_;
	GearySmtpResponseCode* _tmp8_;
	GearyMemoryBuffer* data;
	gint _tmp9_;
	GearySmtpResponse* _tmp10_;
	GearyMemoryBuffer* _tmp11_;
	gboolean _tmp12_;
	GearyMemoryBuffer* _tmp13_;
	GearyMemoryBuffer* _tmp14_;
	gsize _tmp15_;
	gsize _tmp16_;
	GearyMemoryStringBuffer* _tmp17_;
	GDataOutputStream* _tmp18_;
	GearyMemoryBuffer* _tmp19_;
	GDataOutputStream* _tmp20_;
	GDataOutputStream* _tmp21_;
	GearySmtpResponse* _tmp22_;
	GearySmtpResponse* _tmp23_;
	GearySmtpResponse* _tmp24_;
	GError* _inner_error0_;
};

struct _GearySmtpClientConnectionSendDataAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientConnection* self;
	GearyMemoryBuffer* data;
	GCancellable* cancellable;
	GearySmtpResponse* result;
	GearySmtpResponse* response;
	GearySmtpRequest* _tmp0_;
	GearySmtpRequest* _tmp1_;
	GearySmtpResponse* _tmp2_;
	GearySmtpResponse* _tmp3_;
	GearySmtpResponse* _tmp4_;
	GearySmtpResponseCode* _tmp5_;
	GearySmtpResponseCode* _tmp6_;
	gsize _tmp7_;
	gsize _tmp8_;
	GDataOutputStream* _tmp9_;
	GDataOutputStream* _tmp10_;
	GDataOutputStream* _tmp11_;
	GearySmtpResponse* _tmp12_;
	GearySmtpResponse* _tmp13_;
	GearySmtpResponse* _tmp14_;
	GError* _inner_error0_;
};

struct _GearySmtpClientConnectionSendRequestAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientConnection* self;
	GearySmtpRequest* request;
	GCancellable* cancellable;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GDataOutputStream* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GDataOutputStream* _tmp5_;
	GDataOutputStream* _tmp6_;
	GError* _inner_error0_;
};

struct _GearySmtpClientConnectionRecvResponseLinesAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientConnection* self;
	GCancellable* cancellable;
	GeeList* result;
	GeeList* lines;
	GeeArrayList* _tmp0_;
	gboolean _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GearySmtpResponseLine* line;
	GearySmtpResponseLine* _tmp4_;
	GeeList* _tmp5_;
	GearySmtpResponseLine* _tmp6_;
	GearySmtpResponseLine* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GeeList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GError* _inner_error0_;
};

struct _GearySmtpClientConnectionRecvResponseAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientConnection* self;
	GCancellable* cancellable;
	GearySmtpResponse* result;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GearySmtpResponse* response;
	GearySmtpResponse* _tmp2_;
	GearySmtpResponse* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _inner_error0_;
};

struct _GearySmtpClientConnectionSayHelloAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientConnection* self;
	GCancellable* cancellable;
	GearySmtpResponse* result;
	GSocketAddress* _tmp0_;
	GSocketConnection* _tmp1_;
	GSocketAddress* _tmp2_;
	GInetAddress* local_addr;
	GInetAddress* _tmp3_;
	GInetAddress* _tmp4_;
	gchar* fqdn;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GInetAddress* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GInetAddress* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GInetAddress* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gchar* _tmp16_;
	GResolver* _tmp17_;
	GResolver* _tmp18_;
	GInetAddress* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GError* err;
	GInetAddress* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	GError* _tmp26_;
	const gchar* _tmp27_;
	GearySmtpEhloRequest* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	GearySmtpEhloRequest* _tmp31_;
	GInetAddress* _tmp32_;
	GearySmtpEhloRequest* _tmp33_;
	GearySmtpEhloRequest* ehlo;
	GearySmtpEhloRequest* _tmp34_;
	GearySmtpResponse* response;
	GearySmtpEhloRequest* _tmp35_;
	GearySmtpResponse* _tmp36_;
	GearySmtpResponse* _tmp37_;
	GearySmtpResponseCode* _tmp38_;
	GearySmtpResponseCode* _tmp39_;
	GearySmtpCapabilities* _tmp40_;
	GearySmtpCapabilities* _tmp41_;
	GearySmtpCapabilities* _tmp42_;
	GearySmtpResponse* _tmp43_;
	gchar* first_response;
	GearySmtpResponse* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	GearySmtpHeloRequest* _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	GearySmtpHeloRequest* _tmp52_;
	GInetAddress* _tmp53_;
	GearySmtpHeloRequest* _tmp54_;
	GearySmtpHeloRequest* helo;
	GearySmtpHeloRequest* _tmp55_;
	GearySmtpResponse* _tmp56_;
	GearySmtpHeloRequest* _tmp57_;
	GearySmtpResponse* _tmp58_;
	GearySmtpResponse* _tmp59_;
	GearySmtpResponse* _tmp60_;
	GearySmtpResponseCode* _tmp61_;
	GearySmtpResponseCode* _tmp62_;
	const gchar* _tmp63_;
	GearySmtpResponse* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	GError* _tmp69_;
	GError* _tmp70_;
	GError* _inner_error0_;
};

struct _GearySmtpClientConnectionEstablishConnectionAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientConnection* self;
	GCancellable* cancellable;
	GearySmtpResponse* result;
	GearySmtpResponse* response;
	GearySmtpResponse* _tmp0_;
	GearyEndpoint* _tmp1_;
	GearyTlsNegotiationMethod _tmp2_;
	GearyTlsNegotiationMethod _tmp3_;
	GearySmtpCapabilities* _tmp4_;
	GearyEndpoint* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError* _tmp8_;
	GError* _tmp9_;
	GearySmtpResponse* starttls_response;
	GearySmtpRequest* _tmp10_;
	GearySmtpRequest* _tmp11_;
	GearySmtpResponse* _tmp12_;
	GearySmtpResponse* _tmp13_;
	GearySmtpResponse* _tmp14_;
	GearySmtpResponseCode* _tmp15_;
	GearySmtpResponseCode* _tmp16_;
	GearySmtpResponse* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	GError* _tmp20_;
	GError* _tmp21_;
	GTlsClientConnection* tls_cx;
	GearyEndpoint* _tmp22_;
	GIOStream* _tmp23_;
	GTlsClientConnection* _tmp24_;
	GTlsClientConnection* _tmp25_;
	GIOStream* _tmp26_;
	GTlsClientConnection* _tmp27_;
	GearySmtpResponse* _tmp28_;
	GearySmtpResponse* _tmp29_;
	GearySmtpResponse* _tmp30_;
	GError* _inner_error0_;
};

struct _GearySmtpClientConnectionQuitAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientConnection* self;
	GCancellable* cancellable;
	GearySmtpResponse* result;
	GearySmtpResponse* _tmp0_;
	GearySmtpRequest* _tmp1_;
	GearySmtpRequest* _tmp2_;
	GearySmtpResponse* _tmp3_;
	GearySmtpResponse* _tmp4_;
	GearySmtpResponse* _tmp5_;
	GError* _inner_error0_;
};

struct _GearySmtpClientConnectionTransactionAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientConnection* self;
	GearySmtpRequest* request;
	GCancellable* cancellable;
	GearySmtpResponse* result;
	GearySmtpResponse* _tmp0_;
	GearySmtpResponse* _tmp1_;
	GearySmtpResponse* _tmp2_;
	GError* _inner_error0_;
};

struct _GearySmtpClientConnectionReadLineAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GearySmtpClientConnection* self;
	GCancellable* cancellable;
	gchar* result;
	gsize length;
	gchar* line;
	GDataInputStream* _tmp0_;
	gsize _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GError* _tmp6_;
	GError* _tmp7_;
	GError* _inner_error0_;
};

static gint GearySmtpClientConnection_private_offset;
static gpointer geary_smtp_client_connection_parent_class = NULL;
static GearyLoggingSourceIface * geary_smtp_client_connection_geary_logging_source_parent_iface = NULL;

VALA_EXTERN GType geary_smtp_client_connection_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearyLoggingState* geary_smtp_client_connection_to_logging_state (GearySmtpClientConnection* self);
VALA_EXTERN GearySmtpCapabilities* geary_smtp_client_connection_get_capabilities (GearySmtpClientConnection* self);
static void geary_smtp_client_connection_set_capabilities (GearySmtpClientConnection* self,
                                                    GearySmtpCapabilities* value);
VALA_EXTERN GearySmtpClientConnection* geary_smtp_client_connection_new (GearyEndpoint* endpoint);
VALA_EXTERN GearySmtpClientConnection* geary_smtp_client_connection_construct (GType object_type,
                                                                   GearyEndpoint* endpoint);
VALA_EXTERN gboolean geary_smtp_client_connection_is_connected (GearySmtpClientConnection* self);
static void geary_smtp_client_connection_connect_async_data_free (gpointer _data);
VALA_EXTERN void geary_smtp_client_connection_connect_async (GearySmtpClientConnection* self,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
VALA_EXTERN GearySmtpGreeting* geary_smtp_client_connection_connect_finish (GearySmtpClientConnection* self,
                                                                GAsyncResult* _res_,
                                                                GError** error);
static gboolean geary_smtp_client_connection_connect_async_co (GearySmtpClientConnectionConnectAsyncData* _data_);
static void geary_smtp_client_connection_connect_async_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void geary_smtp_client_connection_set_data_streams (GearySmtpClientConnection* self,
                                                    GIOStream* stream);
static void geary_smtp_client_connection_recv_response_lines_async (GearySmtpClientConnection* self,
                                                             GCancellable* cancellable,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
static GeeList* geary_smtp_client_connection_recv_response_lines_finish (GearySmtpClientConnection* self,
                                                                  GAsyncResult* _res_,
                                                                  GError** error);
static void geary_smtp_client_connection_disconnect_async_data_free (gpointer _data);
VALA_EXTERN void geary_smtp_client_connection_disconnect_async (GearySmtpClientConnection* self,
                                                    GCancellable* cancellable,
                                                    GAsyncReadyCallback _callback_,
                                                    gpointer _user_data_);
VALA_EXTERN gboolean geary_smtp_client_connection_disconnect_finish (GearySmtpClientConnection* self,
                                                         GAsyncResult* _res_,
                                                         GError** error);
static gboolean geary_smtp_client_connection_disconnect_async_co (GearySmtpClientConnectionDisconnectAsyncData* _data_);
static void geary_smtp_client_connection_disconnect_async_ready (GObject* source_object,
                                                          GAsyncResult* _res_,
                                                          gpointer _user_data_);
static void geary_smtp_client_connection_authenticate_async_data_free (gpointer _data);
VALA_EXTERN void geary_smtp_client_connection_authenticate_async (GearySmtpClientConnection* self,
                                                      GearySmtpAuthenticator* authenticator,
                                                      GCancellable* cancellable,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
VALA_EXTERN GearySmtpResponse* geary_smtp_client_connection_authenticate_finish (GearySmtpClientConnection* self,
                                                                     GAsyncResult* _res_,
                                                                     GError** error);
static gboolean geary_smtp_client_connection_authenticate_async_co (GearySmtpClientConnectionAuthenticateAsyncData* _data_);
static void geary_smtp_client_connection_check_connected (GearySmtpClientConnection* self,
                                                   GError** error);
VALA_EXTERN void geary_smtp_client_connection_transaction_async (GearySmtpClientConnection* self,
                                                     GearySmtpRequest* request,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
VALA_EXTERN GearySmtpResponse* geary_smtp_client_connection_transaction_finish (GearySmtpClientConnection* self,
                                                                    GAsyncResult* _res_,
                                                                    GError** error);
static void geary_smtp_client_connection_authenticate_async_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_);
VALA_EXTERN void geary_smtp_client_connection_recv_response_async (GearySmtpClientConnection* self,
                                                       GCancellable* cancellable,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
VALA_EXTERN GearySmtpResponse* geary_smtp_client_connection_recv_response_finish (GearySmtpClientConnection* self,
                                                                      GAsyncResult* _res_,
                                                                      GError** error);
static void geary_smtp_client_connection_send_data_async_data_free (gpointer _data);
VALA_EXTERN void geary_smtp_client_connection_send_data_async (GearySmtpClientConnection* self,
                                                   GearyMemoryBuffer* data,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN GearySmtpResponse* geary_smtp_client_connection_send_data_finish (GearySmtpClientConnection* self,
                                                                  GAsyncResult* _res_,
                                                                  GError** error);
static gboolean geary_smtp_client_connection_send_data_async_co (GearySmtpClientConnectionSendDataAsyncData* _data_);
static void geary_smtp_client_connection_send_data_async_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static void geary_smtp_client_connection_send_request_async_data_free (gpointer _data);
VALA_EXTERN void geary_smtp_client_connection_send_request_async (GearySmtpClientConnection* self,
                                                      GearySmtpRequest* request,
                                                      GCancellable* cancellable,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
VALA_EXTERN void geary_smtp_client_connection_send_request_finish (GearySmtpClientConnection* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static gboolean geary_smtp_client_connection_send_request_async_co (GearySmtpClientConnectionSendRequestAsyncData* _data_);
static void geary_smtp_client_connection_send_request_async_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_);
static void geary_smtp_client_connection_recv_response_lines_async_data_free (gpointer _data);
static gboolean geary_smtp_client_connection_recv_response_lines_async_co (GearySmtpClientConnectionRecvResponseLinesAsyncData* _data_);
static void geary_smtp_client_connection_read_line_async (GearySmtpClientConnection* self,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
static gchar* geary_smtp_client_connection_read_line_finish (GearySmtpClientConnection* self,
                                                      GAsyncResult* _res_,
                                                      GError** error);
static void geary_smtp_client_connection_recv_response_lines_async_ready (GObject* source_object,
                                                                   GAsyncResult* _res_,
                                                                   gpointer _user_data_);
static void geary_smtp_client_connection_recv_response_async_data_free (gpointer _data);
static gboolean geary_smtp_client_connection_recv_response_async_co (GearySmtpClientConnectionRecvResponseAsyncData* _data_);
static void geary_smtp_client_connection_recv_response_async_ready (GObject* source_object,
                                                             GAsyncResult* _res_,
                                                             gpointer _user_data_);
static void geary_smtp_client_connection_say_hello_async_data_free (gpointer _data);
VALA_EXTERN void geary_smtp_client_connection_say_hello_async (GearySmtpClientConnection* self,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_);
VALA_EXTERN GearySmtpResponse* geary_smtp_client_connection_say_hello_finish (GearySmtpClientConnection* self,
                                                                  GAsyncResult* _res_,
                                                                  GError** error);
static gboolean geary_smtp_client_connection_say_hello_async_co (GearySmtpClientConnectionSayHelloAsyncData* _data_);
static void geary_smtp_client_connection_say_hello_async_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static void geary_smtp_client_connection_establish_connection_async_data_free (gpointer _data);
VALA_EXTERN void geary_smtp_client_connection_establish_connection_async (GearySmtpClientConnection* self,
                                                              GCancellable* cancellable,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_);
VALA_EXTERN GearySmtpResponse* geary_smtp_client_connection_establish_connection_finish (GearySmtpClientConnection* self,
                                                                             GAsyncResult* _res_,
                                                                             GError** error);
static gboolean geary_smtp_client_connection_establish_connection_async_co (GearySmtpClientConnectionEstablishConnectionAsyncData* _data_);
static void geary_smtp_client_connection_establish_connection_async_ready (GObject* source_object,
                                                                    GAsyncResult* _res_,
                                                                    gpointer _user_data_);
static void geary_smtp_client_connection_quit_async_data_free (gpointer _data);
VALA_EXTERN void geary_smtp_client_connection_quit_async (GearySmtpClientConnection* self,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
VALA_EXTERN GearySmtpResponse* geary_smtp_client_connection_quit_finish (GearySmtpClientConnection* self,
                                                             GAsyncResult* _res_,
                                                             GError** error);
static gboolean geary_smtp_client_connection_quit_async_co (GearySmtpClientConnectionQuitAsyncData* _data_);
static void geary_smtp_client_connection_quit_async_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void geary_smtp_client_connection_transaction_async_data_free (gpointer _data);
static gboolean geary_smtp_client_connection_transaction_async_co (GearySmtpClientConnectionTransactionAsyncData* _data_);
static void geary_smtp_client_connection_transaction_async_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_);
static void geary_smtp_client_connection_read_line_async_data_free (gpointer _data);
static gboolean geary_smtp_client_connection_read_line_async_co (GearySmtpClientConnectionReadLineAsyncData* _data_);
static void geary_smtp_client_connection_read_line_async_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static GearyLoggingState* geary_smtp_client_connection_real_to_logging_state (GearySmtpClientConnection* self);
VALA_EXTERN void geary_smtp_client_connection_set_logging_parent (GearySmtpClientConnection* self,
                                                      GearyLoggingSource* parent);
static void geary_smtp_client_connection_finalize (GObject * obj);
static GType geary_smtp_client_connection_get_type_once (void);
static void _vala_geary_smtp_client_connection_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_geary_smtp_client_connection_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);

static inline gpointer
geary_smtp_client_connection_get_instance_private (GearySmtpClientConnection* self)
{
	return G_STRUCT_MEMBER_P (self, GearySmtpClientConnection_private_offset);
}

GearySmtpCapabilities*
geary_smtp_client_connection_get_capabilities (GearySmtpClientConnection* self)
{
	GearySmtpCapabilities* result;
	GearySmtpCapabilities* _tmp0_;
	g_return_val_if_fail (GEARY_SMTP_IS_CLIENT_CONNECTION (self), NULL);
	_tmp0_ = self->priv->_capabilities;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_smtp_client_connection_set_capabilities (GearySmtpClientConnection* self,
                                               GearySmtpCapabilities* value)
{
	GearySmtpCapabilities* old_value;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_CONNECTION (self));
	old_value = geary_smtp_client_connection_get_capabilities (self);
	if (old_value != value) {
		GearySmtpCapabilities* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_capabilities);
		self->priv->_capabilities = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_smtp_client_connection_properties[GEARY_SMTP_CLIENT_CONNECTION_CAPABILITIES_PROPERTY]);
	}
}

static const gchar*
geary_smtp_client_connection_real_get_logging_domain (GearyLoggingSource* base)
{
	const gchar* result;
	GearySmtpClientConnection* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_SMTP_TYPE_CLIENT_CONNECTION, GearySmtpClientConnection);
	result = GEARY_SMTP_CLIENT_SERVICE_PROTOCOL_LOGGING_DOMAIN;
	return result;
}

static GearyLoggingSource*
geary_smtp_client_connection_real_get_logging_parent (GearyLoggingSource* base)
{
	GearyLoggingSource* result;
	GearySmtpClientConnection* self;
	GearyLoggingSource* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_SMTP_TYPE_CLIENT_CONNECTION, GearySmtpClientConnection);
	_tmp0_ = self->priv->_logging_parent;
	result = _tmp0_;
	return result;
}

GearySmtpClientConnection*
geary_smtp_client_connection_construct (GType object_type,
                                        GearyEndpoint* endpoint)
{
	GearySmtpClientConnection * self = NULL;
	GearyEndpoint* _tmp0_;
	g_return_val_if_fail (GEARY_IS_ENDPOINT (endpoint), NULL);
	self = (GearySmtpClientConnection*) geary_base_object_construct (object_type);
	_tmp0_ = _g_object_ref0 (endpoint);
	_g_object_unref0 (self->priv->endpoint);
	self->priv->endpoint = _tmp0_;
	return self;
}

GearySmtpClientConnection*
geary_smtp_client_connection_new (GearyEndpoint* endpoint)
{
	return geary_smtp_client_connection_construct (GEARY_SMTP_TYPE_CLIENT_CONNECTION, endpoint);
}

gboolean
geary_smtp_client_connection_is_connected (GearySmtpClientConnection* self)
{
	GIOStream* _tmp0_;
	gboolean result;
	g_return_val_if_fail (GEARY_SMTP_IS_CLIENT_CONNECTION (self), FALSE);
	_tmp0_ = self->priv->cx;
	result = _tmp0_ != NULL;
	return result;
}

static void
geary_smtp_client_connection_connect_async_data_free (gpointer _data)
{
	GearySmtpClientConnectionConnectAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_geary_smtp_response_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientConnectionConnectAsyncData, _data_);
}

void
geary_smtp_client_connection_connect_async (GearySmtpClientConnection* self,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	GearySmtpClientConnectionConnectAsyncData* _data_;
	GearySmtpClientConnection* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientConnectionConnectAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_connection_connect_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_smtp_client_connection_connect_async_co (_data_);
}

GearySmtpGreeting*
geary_smtp_client_connection_connect_finish (GearySmtpClientConnection* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	GearySmtpGreeting* result;
	GearySmtpClientConnectionConnectAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
geary_smtp_client_connection_connect_async_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	GearySmtpClientConnectionConnectAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_connection_connect_async_co (_data_);
}

static gboolean
geary_smtp_client_connection_connect_async_co (GearySmtpClientConnectionConnectAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->cx;
	if (_data_->_tmp0_ != NULL) {
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Already connected");
		_data_->result = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->endpoint;
	_data_->_state_ = 1;
	geary_endpoint_connect_async (_data_->_tmp2_, _data_->cancellable, geary_smtp_client_connection_connect_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = geary_endpoint_connect_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp1_ = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->_tmp1_;
	_data_->_tmp1_ = NULL;
	_g_object_unref0 (_data_->self->priv->socket_cx);
	_data_->self->priv->socket_cx = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->self->priv->socket_cx;
	_data_->_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, g_io_stream_get_type (), GIOStream));
	_g_object_unref0 (_data_->self->priv->cx);
	_data_->self->priv->cx = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->self->priv->cx;
	geary_smtp_client_connection_set_data_streams (_data_->self, _data_->_tmp7_);
	_data_->_state_ = 2;
	geary_smtp_client_connection_recv_response_lines_async (_data_->self, _data_->cancellable, geary_smtp_client_connection_connect_async_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp9_ = geary_smtp_client_connection_recv_response_lines_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp8_ = _data_->_tmp9_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp1_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = geary_smtp_greeting_new (_data_->_tmp8_);
	_data_->greeting = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->greeting;
	_data_->_tmp12_ = geary_smtp_response_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp11_, GEARY_SMTP_TYPE_RESPONSE, GearySmtpResponse));
	_data_->_tmp13_ = _data_->_tmp12_;
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "SMTP Greeting: %s", _data_->_tmp13_);
	_g_free0 (_data_->_tmp13_);
	_data_->result = _data_->greeting;
	_g_object_unref0 (_data_->_tmp8_);
	_g_object_unref0 (_data_->_tmp1_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_connection_disconnect_async_data_free (gpointer _data)
{
	GearySmtpClientConnectionDisconnectAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientConnectionDisconnectAsyncData, _data_);
}

void
geary_smtp_client_connection_disconnect_async (GearySmtpClientConnection* self,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_)
{
	GearySmtpClientConnectionDisconnectAsyncData* _data_;
	GearySmtpClientConnection* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientConnectionDisconnectAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_connection_disconnect_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_smtp_client_connection_disconnect_async_co (_data_);
}

gboolean
geary_smtp_client_connection_disconnect_finish (GearySmtpClientConnection* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	gboolean result;
	GearySmtpClientConnectionDisconnectAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
geary_smtp_client_connection_disconnect_async_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_)
{
	GearySmtpClientConnectionDisconnectAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_connection_disconnect_async_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
geary_smtp_client_connection_disconnect_async_co (GearySmtpClientConnectionDisconnectAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->cx;
	if (_data_->_tmp0_ == NULL) {
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->disconnect_error = NULL;
	{
		_data_->_tmp1_ = _data_->self->priv->cx;
		_data_->_state_ = 1;
		g_io_stream_close_async (_data_->_tmp1_, G_PRIORITY_DEFAULT, _data_->cancellable, geary_smtp_client_connection_disconnect_async_ready, _data_);
		return FALSE;
		_state_1:
		g_io_stream_close_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp2_ = _data_->err;
		_data_->_tmp3_ = _g_error_copy0 (_data_->_tmp2_);
		_g_error_free0 (_data_->disconnect_error);
		_data_->disconnect_error = _data_->_tmp3_;
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_error_free0 (_data_->disconnect_error);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->self->priv->cx);
	_data_->self->priv->cx = NULL;
	_data_->_tmp4_ = _data_->disconnect_error;
	if (_data_->_tmp4_ != NULL) {
		_data_->_tmp5_ = _data_->disconnect_error;
		_data_->_tmp6_ = _g_error_copy0 (_data_->_tmp5_);
		_data_->_inner_error0_ = _data_->_tmp6_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_error_free0 (_data_->disconnect_error);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = TRUE;
	_g_error_free0 (_data_->disconnect_error);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_connection_authenticate_async_data_free (gpointer _data)
{
	GearySmtpClientConnectionAuthenticateAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->authenticator);
	_g_object_unref0 (_data_->cancellable);
	_geary_smtp_response_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientConnectionAuthenticateAsyncData, _data_);
}

void
geary_smtp_client_connection_authenticate_async (GearySmtpClientConnection* self,
                                                 GearySmtpAuthenticator* authenticator,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	GearySmtpClientConnectionAuthenticateAsyncData* _data_;
	GearySmtpClientConnection* _tmp0_;
	GearySmtpAuthenticator* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail (GEARY_SMTP_IS_AUTHENTICATOR (authenticator));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientConnectionAuthenticateAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_connection_authenticate_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (authenticator);
	_g_object_unref0 (_data_->authenticator);
	_data_->authenticator = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_smtp_client_connection_authenticate_async_co (_data_);
}

GearySmtpResponse*
geary_smtp_client_connection_authenticate_finish (GearySmtpClientConnection* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	GearySmtpResponse* result;
	GearySmtpClientConnectionAuthenticateAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Returns the final Response of the challenge-response.
     */
static void
geary_smtp_client_connection_authenticate_async_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_)
{
	GearySmtpClientConnectionAuthenticateAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_connection_authenticate_async_co (_data_);
}

static gboolean
geary_smtp_client_connection_authenticate_async_co (GearySmtpClientConnectionAuthenticateAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	geary_smtp_client_connection_check_connected (_data_->self, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = geary_smtp_authenticator_initiate (_data_->authenticator);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_state_ = 1;
	geary_smtp_client_connection_transaction_async (_data_->self, _data_->_tmp1_, _data_->cancellable, geary_smtp_client_connection_authenticate_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = geary_smtp_client_connection_transaction_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_geary_smtp_request_unref0 (_data_->_tmp1_);
	_data_->response = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = geary_smtp_authenticator_to_string (_data_->authenticator);
	_data_->_tmp5_ = _data_->_tmp4_;
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Initiated SMTP %s authentication", _data_->_tmp5_);
	_g_free0 (_data_->_tmp5_);
	_data_->step = 0;
	while (TRUE) {
		_data_->_tmp6_ = _data_->response;
		_data_->_tmp7_ = geary_smtp_response_get_code (_data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		if (!geary_smtp_response_code_is_success_intermediate (_data_->_tmp8_)) {
			break;
		}
		_data_->_tmp9_ = _data_->step;
		_data_->step = _data_->_tmp9_ + 1;
		_data_->_tmp10_ = _data_->response;
		_data_->_tmp11_ = geary_smtp_authenticator_challenge (_data_->authenticator, _data_->_tmp9_, _data_->_tmp10_, &_data_->_inner_error0_);
		_data_->data = _data_->_tmp11_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_geary_smtp_response_unref0 (_data_->response);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp13_ = _data_->data;
		if (_data_->_tmp13_ == NULL) {
			_data_->_tmp12_ = TRUE;
		} else {
			_data_->_tmp14_ = _data_->data;
			_data_->_tmp15_ = geary_memory_buffer_get_size (_data_->_tmp14_);
			_data_->_tmp16_ = _data_->_tmp15_;
			_data_->_tmp12_ = _data_->_tmp16_ == ((gsize) 0);
		}
		if (_data_->_tmp12_) {
			_data_->_tmp17_ = geary_memory_string_buffer_new (GEARY_SMTP_DATA_FORMAT_CANCEL_AUTHENTICATION);
			_g_object_unref0 (_data_->data);
			_data_->data = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp17_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer);
		}
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "SMTP AUTH Challenge recvd");
		_data_->_tmp18_ = _data_->self->priv->douts;
		_data_->_tmp19_ = _data_->data;
		_data_->_state_ = 2;
		geary_stream_write_all_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp18_, g_output_stream_get_type (), GOutputStream), _data_->_tmp19_, _data_->cancellable, geary_smtp_client_connection_authenticate_async_ready, _data_);
		return FALSE;
		_state_2:
		geary_stream_write_all_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->data);
			_geary_smtp_response_unref0 (_data_->response);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp20_ = _data_->self->priv->douts;
		g_data_output_stream_put_string (_data_->_tmp20_, GEARY_SMTP_DATA_FORMAT_LINE_TERMINATOR, NULL, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->data);
			_geary_smtp_response_unref0 (_data_->response);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp21_ = _data_->self->priv->douts;
		_data_->_state_ = 3;
		g_output_stream_flush_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp21_, g_output_stream_get_type (), GOutputStream), G_PRIORITY_DEFAULT, _data_->cancellable, geary_smtp_client_connection_authenticate_async_ready, _data_);
		return FALSE;
		_state_3:
		g_output_stream_flush_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp21_, g_output_stream_get_type (), GOutputStream), _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->data);
			_geary_smtp_response_unref0 (_data_->response);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_state_ = 4;
		geary_smtp_client_connection_recv_response_async (_data_->self, _data_->cancellable, geary_smtp_client_connection_authenticate_async_ready, _data_);
		return FALSE;
		_state_4:
		_data_->_tmp23_ = geary_smtp_client_connection_recv_response_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp22_ = _data_->_tmp23_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->data);
			_geary_smtp_response_unref0 (_data_->response);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp24_ = _data_->_tmp22_;
		_data_->_tmp22_ = NULL;
		_geary_smtp_response_unref0 (_data_->response);
		_data_->response = _data_->_tmp24_;
		_geary_smtp_response_unref0 (_data_->_tmp22_);
		_g_object_unref0 (_data_->data);
	}
	_data_->result = _data_->response;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_connection_send_data_async_data_free (gpointer _data)
{
	GearySmtpClientConnectionSendDataAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->data);
	_g_object_unref0 (_data_->cancellable);
	_geary_smtp_response_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientConnectionSendDataAsyncData, _data_);
}

void
geary_smtp_client_connection_send_data_async (GearySmtpClientConnection* self,
                                              GearyMemoryBuffer* data,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	GearySmtpClientConnectionSendDataAsyncData* _data_;
	GearySmtpClientConnection* _tmp0_;
	GearyMemoryBuffer* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail (GEARY_MEMORY_IS_BUFFER (data));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientConnectionSendDataAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_connection_send_data_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (data);
	_g_object_unref0 (_data_->data);
	_data_->data = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_smtp_client_connection_send_data_async_co (_data_);
}

GearySmtpResponse*
geary_smtp_client_connection_send_data_finish (GearySmtpClientConnection* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	GearySmtpResponse* result;
	GearySmtpClientConnectionSendDataAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Sends a block of data
     *
     * This first issues a DATA command and transmits the block if the
     * appropriate response is sent.
     *
     * Returns the final Response of the transaction. If the
     * ResponseCode is not a successful completion, the message should
     * not be considered sent.
     */
static void
geary_smtp_client_connection_send_data_async_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	GearySmtpClientConnectionSendDataAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_connection_send_data_async_co (_data_);
}

static gboolean
geary_smtp_client_connection_send_data_async_co (GearySmtpClientConnectionSendDataAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	geary_smtp_client_connection_check_connected (_data_->self, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = geary_smtp_request_new (GEARY_SMTP_COMMAND_DATA, NULL, 0);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_state_ = 1;
	geary_smtp_client_connection_transaction_async (_data_->self, _data_->_tmp1_, _data_->cancellable, geary_smtp_client_connection_send_data_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = geary_smtp_client_connection_transaction_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_geary_smtp_request_unref0 (_data_->_tmp1_);
	_data_->response = _data_->_tmp3_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->response;
	_data_->_tmp5_ = geary_smtp_response_get_code (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	if (geary_smtp_response_code_is_start_data (_data_->_tmp6_)) {
		_data_->_tmp7_ = geary_memory_buffer_get_size (_data_->data);
		_data_->_tmp8_ = _data_->_tmp7_;
		geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "SMTP Data: <%z>", _data_->_tmp8_);
		_data_->_tmp9_ = _data_->self->priv->douts;
		_data_->_state_ = 2;
		geary_stream_write_all_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp9_, g_output_stream_get_type (), GOutputStream), _data_->data, _data_->cancellable, geary_smtp_client_connection_send_data_async_ready, _data_);
		return FALSE;
		_state_2:
		geary_stream_write_all_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_geary_smtp_response_unref0 (_data_->response);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp10_ = _data_->self->priv->douts;
		_data_->_state_ = 3;
		geary_stream_write_string_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp10_, g_output_stream_get_type (), GOutputStream), GEARY_SMTP_DATA_FORMAT_DATA_TERMINATOR, _data_->cancellable, geary_smtp_client_connection_send_data_async_ready, _data_);
		return FALSE;
		_state_3:
		geary_stream_write_string_finish (_data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_geary_smtp_response_unref0 (_data_->response);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp11_ = _data_->self->priv->douts;
		_data_->_state_ = 4;
		g_output_stream_flush_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp11_, g_output_stream_get_type (), GOutputStream), G_PRIORITY_DEFAULT, _data_->cancellable, geary_smtp_client_connection_send_data_async_ready, _data_);
		return FALSE;
		_state_4:
		g_output_stream_flush_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp11_, g_output_stream_get_type (), GOutputStream), _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_geary_smtp_response_unref0 (_data_->response);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_state_ = 5;
		geary_smtp_client_connection_recv_response_async (_data_->self, _data_->cancellable, geary_smtp_client_connection_send_data_async_ready, _data_);
		return FALSE;
		_state_5:
		_data_->_tmp13_ = geary_smtp_client_connection_recv_response_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp12_ = _data_->_tmp13_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_geary_smtp_response_unref0 (_data_->response);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp14_ = _data_->_tmp12_;
		_data_->_tmp12_ = NULL;
		_geary_smtp_response_unref0 (_data_->response);
		_data_->response = _data_->_tmp14_;
		_geary_smtp_response_unref0 (_data_->_tmp12_);
	}
	_data_->result = _data_->response;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_connection_send_request_async_data_free (gpointer _data)
{
	GearySmtpClientConnectionSendRequestAsyncData* _data_;
	_data_ = _data;
	_geary_smtp_request_unref0 (_data_->request);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientConnectionSendRequestAsyncData, _data_);
}

static gpointer
_geary_smtp_request_ref0 (gpointer self)
{
	return self ? geary_smtp_request_ref (self) : NULL;
}

void
geary_smtp_client_connection_send_request_async (GearySmtpClientConnection* self,
                                                 GearySmtpRequest* request,
                                                 GCancellable* cancellable,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	GearySmtpClientConnectionSendRequestAsyncData* _data_;
	GearySmtpClientConnection* _tmp0_;
	GearySmtpRequest* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail (GEARY_SMTP_IS_REQUEST (request));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientConnectionSendRequestAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_connection_send_request_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _geary_smtp_request_ref0 (request);
	_geary_smtp_request_unref0 (_data_->request);
	_data_->request = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_smtp_client_connection_send_request_async_co (_data_);
}

void
geary_smtp_client_connection_send_request_finish (GearySmtpClientConnection* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	GearySmtpClientConnectionSendRequestAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
geary_smtp_client_connection_send_request_async_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_)
{
	GearySmtpClientConnectionSendRequestAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_connection_send_request_async_co (_data_);
}

static gboolean
geary_smtp_client_connection_send_request_async_co (GearySmtpClientConnectionSendRequestAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	geary_smtp_client_connection_check_connected (_data_->self, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = geary_smtp_request_to_string (_data_->request);
	_data_->_tmp1_ = _data_->_tmp0_;
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "SMTP Request: %s", _data_->_tmp1_);
	_g_free0 (_data_->_tmp1_);
	_data_->_tmp2_ = _data_->self->priv->douts;
	_data_->_tmp3_ = geary_smtp_request_serialize (_data_->request);
	_data_->_tmp4_ = _data_->_tmp3_;
	g_data_output_stream_put_string (_data_->_tmp2_, _data_->_tmp4_, NULL, &_data_->_inner_error0_);
	_g_free0 (_data_->_tmp4_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->self->priv->douts;
	g_data_output_stream_put_string (_data_->_tmp5_, GEARY_SMTP_DATA_FORMAT_LINE_TERMINATOR, NULL, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->self->priv->douts;
	_data_->_state_ = 1;
	g_output_stream_flush_async (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, g_output_stream_get_type (), GOutputStream), G_PRIORITY_DEFAULT, _data_->cancellable, geary_smtp_client_connection_send_request_async_ready, _data_);
	return FALSE;
	_state_1:
	g_output_stream_flush_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, g_output_stream_get_type (), GOutputStream), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_connection_recv_response_lines_async_data_free (gpointer _data)
{
	GearySmtpClientConnectionRecvResponseLinesAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientConnectionRecvResponseLinesAsyncData, _data_);
}

static void
geary_smtp_client_connection_recv_response_lines_async (GearySmtpClientConnection* self,
                                                        GCancellable* cancellable,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	GearySmtpClientConnectionRecvResponseLinesAsyncData* _data_;
	GearySmtpClientConnection* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientConnectionRecvResponseLinesAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_connection_recv_response_lines_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_smtp_client_connection_recv_response_lines_async_co (_data_);
}

static GeeList*
geary_smtp_client_connection_recv_response_lines_finish (GearySmtpClientConnection* self,
                                                         GAsyncResult* _res_,
                                                         GError** error)
{
	GeeList* result;
	GearySmtpClientConnectionRecvResponseLinesAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
geary_smtp_client_connection_recv_response_lines_async_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_)
{
	GearySmtpClientConnectionRecvResponseLinesAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_connection_recv_response_lines_async_co (_data_);
}

static gboolean
geary_smtp_client_connection_recv_response_lines_async_co (GearySmtpClientConnectionRecvResponseLinesAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	geary_smtp_client_connection_check_connected (_data_->self, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = gee_array_list_new (GEARY_SMTP_TYPE_RESPONSE_LINE, (GBoxedCopyFunc) geary_smtp_response_line_ref, (GDestroyNotify) geary_smtp_response_line_unref, NULL, NULL, NULL);
	_data_->lines = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, GEE_TYPE_LIST, GeeList);
	{
		_data_->_tmp1_ = TRUE;
		while (TRUE) {
			if (!_data_->_tmp1_) {
			}
			_data_->_tmp1_ = FALSE;
			_data_->_state_ = 1;
			geary_smtp_client_connection_read_line_async (_data_->self, _data_->cancellable, geary_smtp_client_connection_recv_response_lines_async_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp3_ = geary_smtp_client_connection_read_line_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp2_ = _data_->_tmp3_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->lines);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp4_ = geary_smtp_response_line_deserialize (_data_->_tmp2_, &_data_->_inner_error0_);
			_data_->line = _data_->_tmp4_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_free0 (_data_->_tmp2_);
				_g_object_unref0 (_data_->lines);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp5_ = _data_->lines;
			_data_->_tmp6_ = _data_->line;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, GEE_TYPE_COLLECTION, GeeCollection), _data_->_tmp6_);
			_data_->_tmp7_ = _data_->line;
			_data_->_tmp8_ = geary_smtp_response_line_get_continued (_data_->_tmp7_);
			_data_->_tmp9_ = _data_->_tmp8_;
			if (!_data_->_tmp9_) {
				_geary_smtp_response_line_unref0 (_data_->line);
				_g_free0 (_data_->_tmp2_);
				break;
			}
			_geary_smtp_response_line_unref0 (_data_->line);
			_g_free0 (_data_->_tmp2_);
		}
	}
	_data_->_tmp10_ = _data_->lines;
	_data_->_tmp11_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp10_, GEE_TYPE_COLLECTION, GeeCollection));
	_data_->_tmp12_ = _data_->_tmp11_;
	_vala_assert (_data_->_tmp12_ > 0, "lines.size > 0");
	_data_->result = _data_->lines;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_connection_recv_response_async_data_free (gpointer _data)
{
	GearySmtpClientConnectionRecvResponseAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_geary_smtp_response_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientConnectionRecvResponseAsyncData, _data_);
}

void
geary_smtp_client_connection_recv_response_async (GearySmtpClientConnection* self,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	GearySmtpClientConnectionRecvResponseAsyncData* _data_;
	GearySmtpClientConnection* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientConnectionRecvResponseAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_connection_recv_response_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_smtp_client_connection_recv_response_async_co (_data_);
}

GearySmtpResponse*
geary_smtp_client_connection_recv_response_finish (GearySmtpClientConnection* self,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	GearySmtpResponse* result;
	GearySmtpClientConnectionRecvResponseAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
geary_smtp_client_connection_recv_response_async_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_)
{
	GearySmtpClientConnectionRecvResponseAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_connection_recv_response_async_co (_data_);
}

static gboolean
geary_smtp_client_connection_recv_response_async_co (GearySmtpClientConnectionRecvResponseAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	geary_smtp_client_connection_recv_response_lines_async (_data_->self, _data_->cancellable, geary_smtp_client_connection_recv_response_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = geary_smtp_client_connection_recv_response_lines_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = geary_smtp_response_new (_data_->_tmp0_);
	_data_->response = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->response;
	_data_->_tmp4_ = geary_smtp_response_to_string (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "SMTP Response: %s", _data_->_tmp5_);
	_g_free0 (_data_->_tmp5_);
	_data_->result = _data_->response;
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_connection_say_hello_async_data_free (gpointer _data)
{
	GearySmtpClientConnectionSayHelloAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_geary_smtp_response_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientConnectionSayHelloAsyncData, _data_);
}

void
geary_smtp_client_connection_say_hello_async (GearySmtpClientConnection* self,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	GearySmtpClientConnectionSayHelloAsyncData* _data_;
	GearySmtpClientConnection* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientConnectionSayHelloAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_connection_say_hello_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_smtp_client_connection_say_hello_async_co (_data_);
}

GearySmtpResponse*
geary_smtp_client_connection_say_hello_finish (GearySmtpClientConnection* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	GearySmtpResponse* result;
	GearySmtpClientConnectionSayHelloAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Sends the appropriate HELO/EHLO command and returns the response of the one that worked.
     * Also saves the server's capabilities in the capabilities property (overwriting any that may
     * already be present).
     */
static void
geary_smtp_client_connection_say_hello_async_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	GearySmtpClientConnectionSayHelloAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_connection_say_hello_async_co (_data_);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
geary_smtp_client_connection_say_hello_async_co (GearySmtpClientConnectionSayHelloAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->self->priv->socket_cx;
	_data_->_tmp2_ = g_socket_connection_get_local_address (_data_->_tmp1_, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = g_inet_socket_address_get_address (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp0_, g_inet_socket_address_get_type (), GInetSocketAddress));
	_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
	_data_->local_addr = _data_->_tmp4_;
	_data_->fqdn = NULL;
	_data_->_tmp7_ = _data_->local_addr;
	_data_->_tmp8_ = g_inet_address_get_is_link_local (_data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	if (!_data_->_tmp9_) {
		_data_->_tmp10_ = _data_->local_addr;
		_data_->_tmp11_ = g_inet_address_get_is_loopback (_data_->_tmp10_);
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp6_ = !_data_->_tmp12_;
	} else {
		_data_->_tmp6_ = FALSE;
	}
	if (_data_->_tmp6_) {
		_data_->_tmp13_ = _data_->local_addr;
		_data_->_tmp14_ = g_inet_address_get_is_site_local (_data_->_tmp13_);
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp5_ = !_data_->_tmp15_;
	} else {
		_data_->_tmp5_ = FALSE;
	}
	if (_data_->_tmp5_) {
		{
			_data_->_tmp17_ = g_resolver_get_default ();
			_data_->_tmp18_ = _data_->_tmp17_;
			_data_->_tmp19_ = _data_->local_addr;
			_data_->_state_ = 1;
			g_resolver_lookup_by_address_async (_data_->_tmp18_, _data_->_tmp19_, _data_->cancellable, geary_smtp_client_connection_say_hello_async_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp20_ = g_resolver_lookup_by_address_finish (_data_->_tmp18_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp21_ = _data_->_tmp20_;
			_g_object_unref0 (_data_->_tmp18_);
			_data_->_tmp16_ = _data_->_tmp21_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp22_ = _data_->_tmp16_;
			_data_->_tmp16_ = NULL;
			_g_free0 (_data_->fqdn);
			_data_->fqdn = _data_->_tmp22_;
			_g_free0 (_data_->_tmp16_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->err = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp23_ = _data_->local_addr;
			_data_->_tmp24_ = g_inet_address_to_string (_data_->_tmp23_);
			_data_->_tmp25_ = _data_->_tmp24_;
			_data_->_tmp26_ = _data_->err;
			_data_->_tmp27_ = _data_->_tmp26_->message;
			geary_logging_source_debug (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "Unable to lookup local address for %s: %s", _data_->_tmp25_, _data_->_tmp27_);
			_g_free0 (_data_->_tmp25_);
			_g_error_free0 (_data_->err);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->fqdn);
			_g_object_unref0 (_data_->local_addr);
			_g_object_unref0 (_data_->_tmp0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp29_ = _data_->fqdn;
	if (!geary_string_is_empty (_data_->_tmp29_)) {
		_data_->_tmp30_ = _data_->fqdn;
		_data_->_tmp31_ = geary_smtp_ehlo_request_new (_data_->_tmp30_);
		_geary_smtp_request_unref0 (_data_->_tmp28_);
		_data_->_tmp28_ = _data_->_tmp31_;
	} else {
		_data_->_tmp32_ = _data_->local_addr;
		_data_->_tmp33_ = geary_smtp_ehlo_request_new_for_local_address (_data_->_tmp32_);
		_geary_smtp_request_unref0 (_data_->_tmp28_);
		_data_->_tmp28_ = _data_->_tmp33_;
	}
	_data_->_tmp34_ = _geary_smtp_request_ref0 (_data_->_tmp28_);
	_data_->ehlo = _data_->_tmp34_;
	_data_->_tmp35_ = _data_->ehlo;
	_data_->_state_ = 2;
	geary_smtp_client_connection_transaction_async (_data_->self, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp35_, GEARY_SMTP_TYPE_REQUEST, GearySmtpRequest), _data_->cancellable, geary_smtp_client_connection_say_hello_async_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp36_ = geary_smtp_client_connection_transaction_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->response = _data_->_tmp36_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_geary_smtp_request_unref0 (_data_->ehlo);
		_geary_smtp_request_unref0 (_data_->_tmp28_);
		_g_free0 (_data_->fqdn);
		_g_object_unref0 (_data_->local_addr);
		_g_object_unref0 (_data_->_tmp0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp37_ = _data_->response;
	_data_->_tmp38_ = geary_smtp_response_get_code (_data_->_tmp37_);
	_data_->_tmp39_ = _data_->_tmp38_;
	if (geary_smtp_response_code_is_success_completed (_data_->_tmp39_)) {
		_data_->_tmp40_ = geary_smtp_capabilities_new ();
		_data_->_tmp41_ = _data_->_tmp40_;
		geary_smtp_client_connection_set_capabilities (_data_->self, _data_->_tmp41_);
		_g_object_unref0 (_data_->_tmp41_);
		_data_->_tmp42_ = _data_->self->priv->_capabilities;
		_data_->_tmp43_ = _data_->response;
		geary_smtp_capabilities_add_ehlo_response (_data_->_tmp42_, _data_->_tmp43_);
	} else {
		_data_->_tmp44_ = _data_->response;
		_data_->_tmp45_ = geary_smtp_response_to_string (_data_->_tmp44_);
		_data_->_tmp46_ = _data_->_tmp45_;
		_data_->_tmp47_ = string_strip (_data_->_tmp46_);
		_data_->_tmp48_ = _data_->_tmp47_;
		_g_free0 (_data_->_tmp46_);
		_data_->first_response = _data_->_tmp48_;
		_data_->_tmp50_ = _data_->fqdn;
		if (!geary_string_is_empty (_data_->_tmp50_)) {
			_data_->_tmp51_ = _data_->fqdn;
			_data_->_tmp52_ = geary_smtp_helo_request_new (_data_->_tmp51_);
			_geary_smtp_request_unref0 (_data_->_tmp49_);
			_data_->_tmp49_ = _data_->_tmp52_;
		} else {
			_data_->_tmp53_ = _data_->local_addr;
			_data_->_tmp54_ = geary_smtp_helo_request_new_for_local_address (_data_->_tmp53_);
			_geary_smtp_request_unref0 (_data_->_tmp49_);
			_data_->_tmp49_ = _data_->_tmp54_;
		}
		_data_->_tmp55_ = _geary_smtp_request_ref0 (_data_->_tmp49_);
		_data_->helo = _data_->_tmp55_;
		_data_->_tmp57_ = _data_->helo;
		_data_->_state_ = 3;
		geary_smtp_client_connection_transaction_async (_data_->self, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp57_, GEARY_SMTP_TYPE_REQUEST, GearySmtpRequest), _data_->cancellable, geary_smtp_client_connection_say_hello_async_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp58_ = geary_smtp_client_connection_transaction_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp56_ = _data_->_tmp58_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_geary_smtp_request_unref0 (_data_->helo);
			_geary_smtp_request_unref0 (_data_->_tmp49_);
			_g_free0 (_data_->first_response);
			_geary_smtp_response_unref0 (_data_->response);
			_geary_smtp_request_unref0 (_data_->ehlo);
			_geary_smtp_request_unref0 (_data_->_tmp28_);
			_g_free0 (_data_->fqdn);
			_g_object_unref0 (_data_->local_addr);
			_g_object_unref0 (_data_->_tmp0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp59_ = _data_->_tmp56_;
		_data_->_tmp56_ = NULL;
		_geary_smtp_response_unref0 (_data_->response);
		_data_->response = _data_->_tmp59_;
		_data_->_tmp60_ = _data_->response;
		_data_->_tmp61_ = geary_smtp_response_get_code (_data_->_tmp60_);
		_data_->_tmp62_ = _data_->_tmp61_;
		if (!geary_smtp_response_code_is_success_completed (_data_->_tmp62_)) {
			_data_->_tmp63_ = _data_->first_response;
			_data_->_tmp64_ = _data_->response;
			_data_->_tmp65_ = geary_smtp_response_to_string (_data_->_tmp64_);
			_data_->_tmp66_ = _data_->_tmp65_;
			_data_->_tmp67_ = string_strip (_data_->_tmp66_);
			_data_->_tmp68_ = _data_->_tmp67_;
			_data_->_tmp69_ = g_error_new (GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_SERVER_ERROR, "Refused service: \"%s\" and \"%s\"", _data_->_tmp63_, _data_->_tmp68_);
			_data_->_tmp70_ = _data_->_tmp69_;
			_g_free0 (_data_->_tmp68_);
			_g_free0 (_data_->_tmp66_);
			_data_->_inner_error0_ = _data_->_tmp70_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_geary_smtp_response_unref0 (_data_->_tmp56_);
			_geary_smtp_request_unref0 (_data_->helo);
			_geary_smtp_request_unref0 (_data_->_tmp49_);
			_g_free0 (_data_->first_response);
			_geary_smtp_response_unref0 (_data_->response);
			_geary_smtp_request_unref0 (_data_->ehlo);
			_geary_smtp_request_unref0 (_data_->_tmp28_);
			_g_free0 (_data_->fqdn);
			_g_object_unref0 (_data_->local_addr);
			_g_object_unref0 (_data_->_tmp0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_geary_smtp_response_unref0 (_data_->_tmp56_);
		_geary_smtp_request_unref0 (_data_->helo);
		_geary_smtp_request_unref0 (_data_->_tmp49_);
		_g_free0 (_data_->first_response);
	}
	_data_->result = _data_->response;
	_geary_smtp_request_unref0 (_data_->ehlo);
	_geary_smtp_request_unref0 (_data_->_tmp28_);
	_g_free0 (_data_->fqdn);
	_g_object_unref0 (_data_->local_addr);
	_g_object_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_connection_establish_connection_async_data_free (gpointer _data)
{
	GearySmtpClientConnectionEstablishConnectionAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_geary_smtp_response_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientConnectionEstablishConnectionAsyncData, _data_);
}

void
geary_smtp_client_connection_establish_connection_async (GearySmtpClientConnection* self,
                                                         GCancellable* cancellable,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_)
{
	GearySmtpClientConnectionEstablishConnectionAsyncData* _data_;
	GearySmtpClientConnection* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientConnectionEstablishConnectionAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_connection_establish_connection_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_smtp_client_connection_establish_connection_async_co (_data_);
}

GearySmtpResponse*
geary_smtp_client_connection_establish_connection_finish (GearySmtpClientConnection* self,
                                                          GAsyncResult* _res_,
                                                          GError** error)
{
	GearySmtpResponse* result;
	GearySmtpClientConnectionEstablishConnectionAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

/**
     * Sends the appropriate hello command to the server (EHLO / HELO) and establishes whatever
     * additional connection features are available (STARTTLS, compression).  For general-purpose
     * use, this is the preferred method for establishing a session with a server, as it will do
     * whatever is necessary to ensure quality-of-service and security.
     *
     * Note that this does *not* connect to the server; connect_async() should be used before
     * calling this method.
     *
     * Returns the Response of the final hello command (there may be more than one).
     */
static void
geary_smtp_client_connection_establish_connection_async_ready (GObject* source_object,
                                                               GAsyncResult* _res_,
                                                               gpointer _user_data_)
{
	GearySmtpClientConnectionEstablishConnectionAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_connection_establish_connection_async_co (_data_);
}

static gboolean
geary_smtp_client_connection_establish_connection_async_co (GearySmtpClientConnectionEstablishConnectionAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	geary_smtp_client_connection_check_connected (_data_->self, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 1;
	geary_smtp_client_connection_say_hello_async (_data_->self, _data_->cancellable, geary_smtp_client_connection_establish_connection_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = geary_smtp_client_connection_say_hello_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->response = _data_->_tmp0_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->endpoint;
	_data_->_tmp2_ = geary_endpoint_get_tls_method (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	if (_data_->_tmp3_ == GEARY_TLS_NEGOTIATION_METHOD_START_TLS) {
		_data_->_tmp4_ = _data_->self->priv->_capabilities;
		if (!geary_generic_capabilities_has_capability (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, GEARY_TYPE_GENERIC_CAPABILITIES, GearyGenericCapabilities), GEARY_SMTP_CAPABILITIES_STARTTLS)) {
			_data_->_tmp5_ = _data_->self->priv->endpoint;
			_data_->_tmp6_ = geary_endpoint_to_string (_data_->_tmp5_);
			_data_->_tmp7_ = _data_->_tmp6_;
			_data_->_tmp8_ = g_error_new (GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_NOT_SUPPORTED, "STARTTLS not available for %s", _data_->_tmp7_);
			_data_->_tmp9_ = _data_->_tmp8_;
			_g_free0 (_data_->_tmp7_);
			_data_->_inner_error0_ = _data_->_tmp9_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_geary_smtp_response_unref0 (_data_->response);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp10_ = geary_smtp_request_new (GEARY_SMTP_COMMAND_STARTTLS, NULL, 0);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_state_ = 2;
		geary_smtp_client_connection_transaction_async (_data_->self, _data_->_tmp11_, NULL, geary_smtp_client_connection_establish_connection_async_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp12_ = geary_smtp_client_connection_transaction_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp13_ = _data_->_tmp12_;
		_geary_smtp_request_unref0 (_data_->_tmp11_);
		_data_->starttls_response = _data_->_tmp13_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_geary_smtp_response_unref0 (_data_->response);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp14_ = _data_->starttls_response;
		_data_->_tmp15_ = geary_smtp_response_get_code (_data_->_tmp14_);
		_data_->_tmp16_ = _data_->_tmp15_;
		if (!geary_smtp_response_code_is_starttls_ready (_data_->_tmp16_)) {
			_data_->_tmp17_ = _data_->response;
			_data_->_tmp18_ = geary_smtp_response_to_string (_data_->_tmp17_);
			_data_->_tmp19_ = _data_->_tmp18_;
			_data_->_tmp20_ = g_error_new (GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_STARTTLS_FAILED, "STARTTLS failed: %s", _data_->_tmp19_);
			_data_->_tmp21_ = _data_->_tmp20_;
			_g_free0 (_data_->_tmp19_);
			_data_->_inner_error0_ = _data_->_tmp21_;
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_geary_smtp_response_unref0 (_data_->starttls_response);
			_geary_smtp_response_unref0 (_data_->response);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp22_ = _data_->self->priv->endpoint;
		_data_->_tmp23_ = _data_->self->priv->cx;
		_data_->_state_ = 3;
		geary_endpoint_starttls_handshake_async (_data_->_tmp22_, _data_->_tmp23_, _data_->cancellable, geary_smtp_client_connection_establish_connection_async_ready, _data_);
		return FALSE;
		_state_3:
		_data_->_tmp24_ = geary_endpoint_starttls_handshake_finish (_data_->_tmp22_, _data_->_res_, &_data_->_inner_error0_);
		_data_->tls_cx = _data_->_tmp24_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_geary_smtp_response_unref0 (_data_->starttls_response);
			_geary_smtp_response_unref0 (_data_->response);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp25_ = _data_->tls_cx;
		_data_->_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp25_, g_io_stream_get_type (), GIOStream));
		_g_object_unref0 (_data_->self->priv->cx);
		_data_->self->priv->cx = _data_->_tmp26_;
		_data_->_tmp27_ = _data_->tls_cx;
		geary_smtp_client_connection_set_data_streams (_data_->self, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp27_, g_io_stream_get_type (), GIOStream));
		_data_->_state_ = 4;
		geary_smtp_client_connection_say_hello_async (_data_->self, _data_->cancellable, geary_smtp_client_connection_establish_connection_async_ready, _data_);
		return FALSE;
		_state_4:
		_data_->_tmp29_ = geary_smtp_client_connection_say_hello_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp28_ = _data_->_tmp29_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->tls_cx);
			_geary_smtp_response_unref0 (_data_->starttls_response);
			_geary_smtp_response_unref0 (_data_->response);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp30_ = _data_->_tmp28_;
		_data_->_tmp28_ = NULL;
		_geary_smtp_response_unref0 (_data_->response);
		_data_->response = _data_->_tmp30_;
		_geary_smtp_response_unref0 (_data_->_tmp28_);
		_g_object_unref0 (_data_->tls_cx);
		_geary_smtp_response_unref0 (_data_->starttls_response);
	}
	_data_->result = _data_->response;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_connection_quit_async_data_free (gpointer _data)
{
	GearySmtpClientConnectionQuitAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_geary_smtp_response_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientConnectionQuitAsyncData, _data_);
}

void
geary_smtp_client_connection_quit_async (GearySmtpClientConnection* self,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GearySmtpClientConnectionQuitAsyncData* _data_;
	GearySmtpClientConnection* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientConnectionQuitAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_connection_quit_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_smtp_client_connection_quit_async_co (_data_);
}

GearySmtpResponse*
geary_smtp_client_connection_quit_finish (GearySmtpClientConnection* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	GearySmtpResponse* result;
	GearySmtpClientConnectionQuitAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
geary_smtp_client_connection_quit_async_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	GearySmtpClientConnectionQuitAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_connection_quit_async_co (_data_);
}

static gboolean
geary_smtp_client_connection_quit_async_co (GearySmtpClientConnectionQuitAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	geary_smtp_client_connection_set_capabilities (_data_->self, NULL);
	_data_->_tmp1_ = geary_smtp_request_new (GEARY_SMTP_COMMAND_QUIT, NULL, 0);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_state_ = 1;
	geary_smtp_client_connection_transaction_async (_data_->self, _data_->_tmp2_, _data_->cancellable, geary_smtp_client_connection_quit_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp3_ = geary_smtp_client_connection_transaction_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp4_ = _data_->_tmp3_;
	_geary_smtp_request_unref0 (_data_->_tmp2_);
	_data_->_tmp0_ = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp5_;
	_geary_smtp_response_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_connection_transaction_async_data_free (gpointer _data)
{
	GearySmtpClientConnectionTransactionAsyncData* _data_;
	_data_ = _data;
	_geary_smtp_request_unref0 (_data_->request);
	_g_object_unref0 (_data_->cancellable);
	_geary_smtp_response_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientConnectionTransactionAsyncData, _data_);
}

void
geary_smtp_client_connection_transaction_async (GearySmtpClientConnection* self,
                                                GearySmtpRequest* request,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_)
{
	GearySmtpClientConnectionTransactionAsyncData* _data_;
	GearySmtpClientConnection* _tmp0_;
	GearySmtpRequest* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail (GEARY_SMTP_IS_REQUEST (request));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientConnectionTransactionAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_connection_transaction_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _geary_smtp_request_ref0 (request);
	_geary_smtp_request_unref0 (_data_->request);
	_data_->request = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	geary_smtp_client_connection_transaction_async_co (_data_);
}

GearySmtpResponse*
geary_smtp_client_connection_transaction_finish (GearySmtpClientConnection* self,
                                                 GAsyncResult* _res_,
                                                 GError** error)
{
	GearySmtpResponse* result;
	GearySmtpClientConnectionTransactionAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
geary_smtp_client_connection_transaction_async_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_)
{
	GearySmtpClientConnectionTransactionAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_connection_transaction_async_co (_data_);
}

static gboolean
geary_smtp_client_connection_transaction_async_co (GearySmtpClientConnectionTransactionAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	geary_smtp_client_connection_send_request_async (_data_->self, _data_->request, _data_->cancellable, geary_smtp_client_connection_transaction_async_ready, _data_);
	return FALSE;
	_state_1:
	geary_smtp_client_connection_send_request_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 2;
	geary_smtp_client_connection_recv_response_async (_data_->self, _data_->cancellable, geary_smtp_client_connection_transaction_async_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp1_ = geary_smtp_client_connection_recv_response_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->_tmp0_ = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->_tmp0_;
	_data_->_tmp0_ = NULL;
	_data_->result = _data_->_tmp2_;
	_geary_smtp_response_unref0 (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_connection_read_line_async_data_free (gpointer _data)
{
	GearySmtpClientConnectionReadLineAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GearySmtpClientConnectionReadLineAsyncData, _data_);
}

static void
geary_smtp_client_connection_read_line_async (GearySmtpClientConnection* self,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_)
{
	GearySmtpClientConnectionReadLineAsyncData* _data_;
	GearySmtpClientConnection* _tmp0_;
	GCancellable* _tmp1_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_data_ = g_slice_new0 (GearySmtpClientConnectionReadLineAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_smtp_client_connection_read_line_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	geary_smtp_client_connection_read_line_async_co (_data_);
}

static gchar*
geary_smtp_client_connection_read_line_finish (GearySmtpClientConnection* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	gchar* result;
	GearySmtpClientConnectionReadLineAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
geary_smtp_client_connection_read_line_async_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	GearySmtpClientConnectionReadLineAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	geary_smtp_client_connection_read_line_async_co (_data_);
}

static gboolean
geary_smtp_client_connection_read_line_async_co (GearySmtpClientConnectionReadLineAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->dins;
	_data_->_tmp1_ = 0UL;
	_data_->_state_ = 1;
	g_data_input_stream_read_line_async (_data_->_tmp0_, G_PRIORITY_DEFAULT, _data_->cancellable, geary_smtp_client_connection_read_line_async_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = g_data_input_stream_read_line_finish (_data_->_tmp0_, _data_->_res_, &_data_->_tmp1_, &_data_->_inner_error0_);
	_data_->length = _data_->_tmp1_;
	_data_->line = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->line;
	if (geary_string_is_empty (_data_->_tmp3_)) {
		_data_->_tmp4_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_data_->_tmp5_ = _data_->_tmp4_;
		_data_->_tmp6_ = g_error_new (G_IO_ERROR, G_IO_ERROR_CLOSED, "End of stream detected on %s", _data_->_tmp5_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_g_free0 (_data_->_tmp5_);
		_data_->_inner_error0_ = _data_->_tmp7_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->line);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->line;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_smtp_client_connection_check_connected (GearySmtpClientConnection* self,
                                              GError** error)
{
	GIOStream* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_CONNECTION (self));
	_tmp0_ = self->priv->cx;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		GError* _tmp3_;
		GError* _tmp4_;
		_tmp1_ = geary_logging_source_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
		_tmp2_ = _tmp1_;
		_tmp3_ = g_error_new (GEARY_SMTP_ERROR, GEARY_SMTP_ERROR_NOT_CONNECTED, "Not connected to %s", _tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_inner_error0_ = _tmp4_;
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

/** {@inheritDoc} */
static GearyLoggingState*
geary_smtp_client_connection_real_to_logging_state (GearySmtpClientConnection* self)
{
	const gchar* _tmp0_ = NULL;
	GearyEndpoint* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GearyLoggingState* _tmp4_;
	GearyLoggingState* _tmp5_;
	GearyLoggingState* result;
	if (geary_smtp_client_connection_is_connected (self)) {
		_tmp0_ = "connected";
	} else {
		_tmp0_ = "disconnected";
	}
	_tmp1_ = self->priv->endpoint;
	_tmp2_ = geary_endpoint_to_string (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = geary_logging_state_new (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource), "%s/%s", _tmp3_, _tmp0_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}

GearyLoggingState*
geary_smtp_client_connection_to_logging_state (GearySmtpClientConnection* self)
{
	GearySmtpClientConnectionClass* _klass_;
	g_return_val_if_fail (GEARY_SMTP_IS_CLIENT_CONNECTION (self), NULL);
	_klass_ = GEARY_SMTP_CLIENT_CONNECTION_GET_CLASS (self);
	if (_klass_->to_logging_state) {
		return _klass_->to_logging_state (self);
	}
	return NULL;
}

/** Sets the service's logging parent. */
void
geary_smtp_client_connection_set_logging_parent (GearySmtpClientConnection* self,
                                                 GearyLoggingSource* parent)
{
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail (GEARY_LOGGING_IS_SOURCE (parent));
	self->priv->_logging_parent = parent;
}

static void
geary_smtp_client_connection_set_data_streams (GearySmtpClientConnection* self,
                                               GIOStream* stream)
{
	GInputStream* _tmp0_;
	GInputStream* _tmp1_;
	GDataInputStream* _tmp2_;
	GDataInputStream* _tmp3_;
	GDataInputStream* _tmp4_;
	GOutputStream* _tmp5_;
	GOutputStream* _tmp6_;
	GDataOutputStream* _tmp7_;
	GDataOutputStream* _tmp8_;
	g_return_if_fail (GEARY_SMTP_IS_CLIENT_CONNECTION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (stream, g_io_stream_get_type ()));
	_tmp0_ = g_io_stream_get_input_stream (stream);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_data_input_stream_new (_tmp1_);
	_g_object_unref0 (self->priv->dins);
	self->priv->dins = _tmp2_;
	_tmp3_ = self->priv->dins;
	g_data_input_stream_set_newline_type (_tmp3_, GEARY_SMTP_DATA_FORMAT_LINE_TERMINATOR_TYPE);
	_tmp4_ = self->priv->dins;
	g_filter_input_stream_set_close_base_stream (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_filter_input_stream_get_type (), GFilterInputStream), FALSE);
	_tmp5_ = g_io_stream_get_output_stream (stream);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_data_output_stream_new (_tmp6_);
	_g_object_unref0 (self->priv->douts);
	self->priv->douts = _tmp7_;
	_tmp8_ = self->priv->douts;
	g_filter_output_stream_set_close_base_stream (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, g_filter_output_stream_get_type (), GFilterOutputStream), FALSE);
}

static void
geary_smtp_client_connection_class_init (GearySmtpClientConnectionClass * klass,
                                         gpointer klass_data)
{
	geary_smtp_client_connection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearySmtpClientConnection_private_offset);
	((GearySmtpClientConnectionClass *) klass)->to_logging_state = (GearyLoggingState* (*) (GearySmtpClientConnection*)) geary_smtp_client_connection_real_to_logging_state;
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_smtp_client_connection_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_smtp_client_connection_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_smtp_client_connection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_SMTP_CLIENT_CONNECTION_CAPABILITIES_PROPERTY, geary_smtp_client_connection_properties[GEARY_SMTP_CLIENT_CONNECTION_CAPABILITIES_PROPERTY] = g_param_spec_object ("capabilities", "capabilities", "capabilities", GEARY_SMTP_TYPE_CAPABILITIES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** {@inheritDoc} */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_SMTP_CLIENT_CONNECTION_LOGGING_PARENT_PROPERTY, geary_smtp_client_connection_properties[GEARY_SMTP_CLIENT_CONNECTION_LOGGING_PARENT_PROPERTY] = g_param_spec_object ("logging-parent", "logging-parent", "logging-parent", GEARY_LOGGING_TYPE_SOURCE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_smtp_client_connection_geary_logging_source_interface_init (GearyLoggingSourceIface * iface,
                                                                  gpointer iface_data)
{
	geary_smtp_client_connection_geary_logging_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->to_logging_state = (GearyLoggingState* (*) (GearyLoggingSource*)) geary_smtp_client_connection_to_logging_state;
	iface->get_logging_domain = geary_smtp_client_connection_real_get_logging_domain;
	iface->get_logging_parent = geary_smtp_client_connection_real_get_logging_parent;
}

static void
geary_smtp_client_connection_instance_init (GearySmtpClientConnection * self,
                                            gpointer klass)
{
	self->priv = geary_smtp_client_connection_get_instance_private (self);
	self->priv->_capabilities = NULL;
	self->priv->_logging_parent = NULL;
	self->priv->cx = NULL;
	self->priv->socket_cx = NULL;
	self->priv->dins = NULL;
	self->priv->douts = NULL;
}

static void
geary_smtp_client_connection_finalize (GObject * obj)
{
	GearySmtpClientConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_SMTP_TYPE_CLIENT_CONNECTION, GearySmtpClientConnection);
	_g_object_unref0 (self->priv->_capabilities);
	_g_object_unref0 (self->priv->endpoint);
	_g_object_unref0 (self->priv->cx);
	_g_object_unref0 (self->priv->socket_cx);
	_g_object_unref0 (self->priv->dins);
	_g_object_unref0 (self->priv->douts);
	G_OBJECT_CLASS (geary_smtp_client_connection_parent_class)->finalize (obj);
}

/** A network connection to a SMTP service. */
 G_GNUC_NO_INLINE static GType
geary_smtp_client_connection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearySmtpClientConnectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_smtp_client_connection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearySmtpClientConnection), 0, (GInstanceInitFunc) geary_smtp_client_connection_instance_init, NULL };
	static const GInterfaceInfo geary_logging_source_info = { (GInterfaceInitFunc) geary_smtp_client_connection_geary_logging_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_smtp_client_connection_type_id;
	geary_smtp_client_connection_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearySmtpClientConnection", &g_define_type_info, 0);
	g_type_add_interface_static (geary_smtp_client_connection_type_id, GEARY_LOGGING_TYPE_SOURCE, &geary_logging_source_info);
	GearySmtpClientConnection_private_offset = g_type_add_instance_private (geary_smtp_client_connection_type_id, sizeof (GearySmtpClientConnectionPrivate));
	return geary_smtp_client_connection_type_id;
}

GType
geary_smtp_client_connection_get_type (void)
{
	static gsize geary_smtp_client_connection_type_id__once = 0;
	if (g_once_init_enter (&geary_smtp_client_connection_type_id__once)) {
		GType geary_smtp_client_connection_type_id;
		geary_smtp_client_connection_type_id = geary_smtp_client_connection_get_type_once ();
		g_once_init_leave (&geary_smtp_client_connection_type_id__once, geary_smtp_client_connection_type_id);
	}
	return geary_smtp_client_connection_type_id__once;
}

static void
_vala_geary_smtp_client_connection_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	GearySmtpClientConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_SMTP_TYPE_CLIENT_CONNECTION, GearySmtpClientConnection);
	switch (property_id) {
		case GEARY_SMTP_CLIENT_CONNECTION_CAPABILITIES_PROPERTY:
		g_value_set_object (value, geary_smtp_client_connection_get_capabilities (self));
		break;
		case GEARY_SMTP_CLIENT_CONNECTION_LOGGING_PARENT_PROPERTY:
		g_value_set_object (value, geary_logging_source_get_logging_parent (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_smtp_client_connection_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	GearySmtpClientConnection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_SMTP_TYPE_CLIENT_CONNECTION, GearySmtpClientConnection);
	switch (property_id) {
		case GEARY_SMTP_CLIENT_CONNECTION_CAPABILITIES_PROPERTY:
		geary_smtp_client_connection_set_capabilities (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

