/* util-logging.c generated by valac 0.56.3, the Vala compiler
 * generated from util-logging.vala, do not modify */

/*
 * Copyright © 2016 Software Freedom Conservancy Inc.
 * Copyright © 2018-2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <glib.h>
#include <stdio.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <gobject/gvaluecollector.h>
#include <float.h>
#include <math.h>

#define GEARY_LOGGING_SOURCE_CONTEXT_FIELD_COUNT ((guint8) 8)

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _geary_logging_record_unref0(var) ((var == NULL) ? NULL : (var = (geary_logging_record_unref (var), NULL)))
#define _geary_logging_state_unref0(var) ((var == NULL) ? NULL : (var = (geary_logging_state_unref (var), NULL)))
typedef struct _GearyLoggingParamSpecState GearyLoggingParamSpecState;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _GearyLoggingParamSpecRecord GearyLoggingParamSpecRecord;

struct _GearyLoggingStatePrivate {
	GearyLoggingSource* _source;
	gchar* message;
};

struct _GearyLoggingParamSpecState {
	GParamSpec parent_instance;
};

struct _GearyLoggingRecordPrivate {
	gchar* _domain;
	GearyAccount* _account;
	GearyClientService* _service;
	GearyFolder* _folder;
	GearyLoggingRecord* _next;
	gchar** states;
	gint states_length1;
	gint _states_size_;
	gboolean filled;
	gboolean old_log_api;
};

struct _GearyLoggingParamSpecRecord {
	GParamSpec parent_instance;
};

VALA_EXTERN gboolean geary_logging_was_init;
gboolean geary_logging_was_init = FALSE;
VALA_EXTERN GMutex geary_logging_record_lock;
GMutex geary_logging_record_lock = {0};
VALA_EXTERN GearyLoggingRecord* geary_logging_first_record;
GearyLoggingRecord* geary_logging_first_record = NULL;
VALA_EXTERN GearyLoggingRecord* geary_logging_last_record;
GearyLoggingRecord* geary_logging_last_record = NULL;
VALA_EXTERN guint geary_logging_log_length;
guint geary_logging_log_length = (guint) 0;
VALA_EXTERN guint geary_logging_max_log_length;
guint geary_logging_max_log_length = (guint) 0;
VALA_EXTERN GearyLoggingLogRecord geary_logging_listener;
VALA_EXTERN gpointer geary_logging_listener_target;
GearyLoggingLogRecord geary_logging_listener = NULL;
gpointer geary_logging_listener_target = NULL;
VALA_EXTERN GMutex geary_logging_writer_lock;
GMutex geary_logging_writer_lock = {0};
VALA_EXTERN FILE* geary_logging_stream;
FILE* geary_logging_stream = NULL;
VALA_EXTERN GLogLevelFlags geary_logging_set_breakpoint_on;
GLogLevelFlags geary_logging_set_breakpoint_on = 0;
VALA_EXTERN GeeSet* geary_logging_suppressed_domains;
GeeSet* geary_logging_suppressed_domains = NULL;
static gint GearyLoggingState_private_offset;
static gpointer geary_logging_state_parent_class = NULL;
static gint GearyLoggingRecord_private_offset;
static gpointer geary_logging_record_parent_class = NULL;

static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
VALA_EXTERN void geary_logging_write_record (GearyLoggingRecord* record,
                                 GLogLevelFlags levels);
VALA_EXTERN GearyLoggingRecord* geary_logging_record_new (GLogField* fields,
                                              gint fields_length1,
                                              GLogLevelFlags levels,
                                              gint64 timestamp);
VALA_EXTERN GearyLoggingRecord* geary_logging_record_construct (GType object_type,
                                                    GLogField* fields,
                                                    gint fields_length1,
                                                    GLogLevelFlags levels,
                                                    gint64 timestamp);
VALA_EXTERN gboolean geary_logging_should_blacklist (GearyLoggingRecord* record);
VALA_EXTERN void geary_logging_record_set_next (GearyLoggingRecord* self,
                                    GearyLoggingRecord* value);
VALA_EXTERN gchar* geary_logging_to_prefix (GLogLevelFlags level);
VALA_EXTERN gchar* geary_logging_field_to_string (GLogField* field);
static gchar* geary_logging_source_log_level_to_priority (GLogLevelFlags level);
static gchar* geary_logging_source_real_to_string (GearyLoggingSource* self);
static inline void geary_logging_source_log_structured (GearyLoggingSource* self,
                                          GLogLevelFlags levels,
                                          const gchar* fmt,
                                          va_list args);
static void geary_logging_source_context_init (GearyLoggingSourceContext *self,
                                        const gchar* domain,
                                        GLogLevelFlags level,
                                        const gchar* message,
                                        va_list args);
static GLogField* _vala_array_dup17 (GLogField* self,
                              gssize length);
static GLogField* _vala_array_dup18 (GLogField* self,
                              gssize length);
static GType geary_logging_source_get_type_once (void);
static void geary_logging_state_set_source (GearyLoggingState* self,
                                     GearyLoggingSource* value);
static void geary_logging_state_finalize (GearyLoggingState * obj);
static GType geary_logging_state_get_type_once (void);
static void geary_logging_record_set_domain (GearyLoggingRecord* self,
                                      const gchar* value);
static void geary_logging_record_set_account (GearyLoggingRecord* self,
                                       GearyAccount* value);
static void geary_logging_record_set_service (GearyLoggingRecord* self,
                                       GearyClientService* value);
static void geary_logging_record_set_folder (GearyLoggingRecord* self,
                                      GearyFolder* value);
static GType* _g_type_dup (GType* self);
static gchar** _vala_array_dup19 (gchar** self,
                           gssize length);
static void geary_logging_record_finalize (GearyLoggingRecord * obj);
static GType geary_logging_record_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);

/**
     * Must be called before ''any'' call to the Logging namespace.
     *
     * This will be initialized by the Engine when it's opened, but
     * applications may want to set up logging before that, in which case,
     * call this directly.
     */
static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

void
geary_logging_init (void)
{
	if (!geary_logging_was_init) {
		GeeHashSet* _tmp0_;
		gchar* debug_var = NULL;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		geary_logging_was_init = TRUE;
		_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (geary_logging_suppressed_domains);
		geary_logging_suppressed_domains = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_SET, GeeSet);
		_vala_clear_GMutex (&geary_logging_record_lock);
		g_mutex_init (&geary_logging_record_lock);
		_vala_clear_GMutex (&geary_logging_writer_lock);
		g_mutex_init (&geary_logging_writer_lock);
		geary_logging_max_log_length = GEARY_LOGGING_DEFAULT_MAX_LOG_BUFFER_LENGTH;
		_tmp1_ = g_getenv ("G_DEBUG");
		_tmp2_ = g_strdup (_tmp1_);
		debug_var = _tmp2_;
		_tmp3_ = debug_var;
		if (_tmp3_ != NULL) {
			gchar** parts = NULL;
			const gchar* _tmp4_;
			gchar** _tmp5_;
			gchar** _tmp6_;
			gint parts_length1;
			gint _parts_size_;
			gchar** _tmp7_;
			gint _tmp7__length1;
			gchar** _tmp8_;
			gint _tmp8__length1;
			_tmp4_ = debug_var;
			_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, ",", 0);
			parts = _tmp6_;
			parts_length1 = _vala_array_length (_tmp5_);
			_parts_size_ = parts_length1;
			_tmp7_ = parts;
			_tmp7__length1 = parts_length1;
			if (_vala_string_array_contains (_tmp7_, _tmp7__length1, "fatal-warnings")) {
				geary_logging_set_breakpoint_on = geary_logging_set_breakpoint_on | G_LOG_LEVEL_WARNING;
				geary_logging_set_breakpoint_on = geary_logging_set_breakpoint_on | G_LOG_LEVEL_CRITICAL;
			}
			_tmp8_ = parts;
			_tmp8__length1 = parts_length1;
			if (_vala_string_array_contains (_tmp8_, _tmp8__length1, "fatal-criticals")) {
				geary_logging_set_breakpoint_on = geary_logging_set_breakpoint_on | G_LOG_LEVEL_CRITICAL;
			}
			parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (debug_var);
	}
}

/**
     * Sets a function to be called when a new log record is created.
     *
     * For any log records to be created, {@link default_log_writer}
     * must be set as the GLib structured log writer.
     *
     * Note that the given function *must* be thread-safe, since
     * logging can occur on multiple threads at once.
     *
     * @see default_log_writer
     */
void
geary_logging_set_log_listener (GearyLoggingLogRecord new_listener,
                                gpointer new_listener_target)
{
	geary_logging_listener = new_listener;
	geary_logging_listener_target = new_listener_target;
}

/**
     * Returns the oldest log record in the logging system's buffer.
     *
     * For any log records to be created, {@link default_log_writer}
     * must be set as the GLib structured log writer.
     *
     * @see default_log_writer
     */
static gpointer
_geary_logging_record_ref0 (gpointer self)
{
	return self ? geary_logging_record_ref (self) : NULL;
}

GearyLoggingRecord*
geary_logging_get_earliest_record (void)
{
	GearyLoggingRecord* _tmp0_;
	GearyLoggingRecord* _tmp1_;
	GearyLoggingRecord* result;
	_tmp0_ = geary_logging_first_record;
	_tmp1_ = _geary_logging_record_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
     * Returns the most recent log record in the logging system's buffer.
     *
     * For any log records to be created, {@link default_log_writer}
     * must be set as the GLib structured log writer.
     *
     * @see default_log_writer
     */
GearyLoggingRecord*
geary_logging_get_latest_record (void)
{
	GearyLoggingRecord* _tmp0_;
	GearyLoggingRecord* _tmp1_;
	GearyLoggingRecord* result;
	_tmp0_ = geary_logging_last_record;
	_tmp1_ = _geary_logging_record_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
     * Clears all log records.
     *
     * Since log records hold references to Geary engine objects, it may
     * be desirable to clear the records prior to shutdown so that the
     * objects can be destroyed.
     */
void
geary_logging_clear (void)
{
	GearyLoggingRecord* old_first = NULL;
	GearyLoggingRecord* _tmp0_;
	GearyLoggingRecord* _tmp1_;
	old_first = NULL;
	g_mutex_lock (&geary_logging_record_lock);
	_tmp0_ = geary_logging_first_record;
	_tmp1_ = _geary_logging_record_ref0 (_tmp0_);
	_geary_logging_record_unref0 (old_first);
	old_first = _tmp1_;
	_geary_logging_record_unref0 (geary_logging_first_record);
	geary_logging_first_record = NULL;
	_geary_logging_record_unref0 (geary_logging_last_record);
	geary_logging_last_record = NULL;
	geary_logging_log_length = (guint) 0;
	g_mutex_unlock (&geary_logging_record_lock);
	while (TRUE) {
		GearyLoggingRecord* _tmp2_;
		GearyLoggingRecord* _tmp3_;
		GearyLoggingRecord* _tmp4_;
		GearyLoggingRecord* _tmp5_;
		GearyLoggingRecord* _tmp6_;
		_tmp2_ = old_first;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = old_first;
		_tmp4_ = geary_logging_record_get_next (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _geary_logging_record_ref0 (_tmp5_);
		_geary_logging_record_unref0 (old_first);
		old_first = _tmp6_;
	}
	_geary_logging_record_unref0 (old_first);
}

/**
     * Suppresses printing of debug logging for a given logging domain.
     *
     * If a logging domain is suppressed, DEBUG-level logging will not
     * be printed by {@link default_log_writer}.
     *
     * @return true if the domain was suppressed
     * @see unsuppress_domain
     */
gboolean
geary_logging_suppress_domain (const gchar* domain)
{
	GeeSet* _tmp0_;
	gboolean result;
	g_return_val_if_fail (domain != NULL, FALSE);
	_tmp0_ = geary_logging_suppressed_domains;
	result = gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), domain);
	return result;
}

/**
     * Determines if given logging domain is suppressed.
     *
     * @return true if the domain is suppressed
     */
gboolean
geary_logging_is_suppressed_domain (const gchar* domain)
{
	GeeSet* _tmp0_;
	gboolean result;
	g_return_val_if_fail (domain != NULL, FALSE);
	_tmp0_ = geary_logging_suppressed_domains;
	result = gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), domain);
	return result;
}

/**
     * Un-suppresses printing debug logging for a given logging domain.
     *
     * Un-suppressing a suppressed logging domain will cause it to be
     * printed by {@link default_log_writer} again.
     *
     * @return true if the domain was unsuppressed
     * @see suppress_domain
     */
gboolean
geary_logging_unsuppress_domain (const gchar* domain)
{
	GeeSet* _tmp0_;
	gboolean result;
	g_return_val_if_fail (domain != NULL, FALSE);
	_tmp0_ = geary_logging_suppressed_domains;
	result = gee_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), domain);
	return result;
}

/**
     * Registers a stream for log output from {@link default_log_writer}.
     *
     * If stream is null, no logging of then DEBUG-level,
     * INFORMATION-level, and MESSAGE-level structured log messages
     * occurs (the default). If non-null and the stream was previously
     * null, all pending log records will be output before proceeding.
     *
     * This only has effect if {@link default_log_writer} has been set
     * as the GLib structured log writer via a call to {@link
     * GLib.Log.set_writer_func}.
     */
void
geary_logging_log_to (FILE* stream)
{
	gboolean _tmp0_ = FALSE;
	gboolean catch_up = FALSE;
	if (stream != NULL) {
		FILE* _tmp1_;
		_tmp1_ = geary_logging_stream;
		_tmp0_ = _tmp1_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	catch_up = _tmp0_;
	geary_logging_stream = stream;
	if (catch_up) {
		GearyLoggingRecord* record = NULL;
		GearyLoggingRecord* _tmp2_;
		GearyLoggingRecord* _tmp3_;
		_tmp2_ = geary_logging_first_record;
		_tmp3_ = _geary_logging_record_ref0 (_tmp2_);
		record = _tmp3_;
		while (TRUE) {
			GearyLoggingRecord* _tmp4_;
			GearyLoggingRecord* _tmp5_;
			GearyLoggingRecord* _tmp6_;
			GearyLoggingRecord* _tmp7_;
			GearyLoggingRecord* _tmp8_;
			GearyLoggingRecord* _tmp9_;
			GearyLoggingRecord* _tmp10_;
			_tmp4_ = record;
			if (!(_tmp4_ != NULL)) {
				break;
			}
			_tmp5_ = record;
			_tmp6_ = record;
			geary_logging_write_record (_tmp5_, _tmp6_->levels);
			_tmp7_ = record;
			_tmp8_ = geary_logging_record_get_next (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = _geary_logging_record_ref0 (_tmp9_);
			_geary_logging_record_unref0 (record);
			record = _tmp10_;
		}
		_geary_logging_record_unref0 (record);
	}
}

/**
     * A GLib structured logging writer that records logging messages.
     *
     * Installing this function as the GLib structured log writer by
     * passing it in a call to {@link GLib.Log.set_writer_func} will
     * enable the engine's log record keeping and printing services.
     *
     * Instances of {@link Record} will be created for each structured
     * logging message received, and made available to applications
     * via {@link get_earliest_record}, {@link get_latest_record}, and
     * {@link set_log_listener}.
     *
     * Further, if a destination stream has been set via a call to
     * {@link log_to}, structured log messages will be printed to the
     * given stream.
     */
GLogWriterOutput
geary_logging_default_log_writer (GLogLevelFlags levels,
                                  GLogField* fields,
                                  gint fields_length1)
{
	GearyLoggingRecord* record = NULL;
	GearyLoggingRecord* _tmp0_;
	GearyLoggingRecord* _tmp1_;
	GLogWriterOutput result;
	_tmp0_ = geary_logging_record_new (fields, fields_length1, levels, g_get_real_time ());
	record = _tmp0_;
	_tmp1_ = record;
	if (!geary_logging_should_blacklist (_tmp1_)) {
		GearyLoggingRecord* old_record = NULL;
		GearyLoggingRecord* _tmp2_;
		GearyLoggingRecord* _tmp3_;
		GearyLoggingRecord* _tmp4_;
		GearyLoggingLogRecord _tmp18_;
		gpointer _tmp18__target;
		GearyLoggingRecord* _tmp21_;
		old_record = NULL;
		g_mutex_lock (&geary_logging_record_lock);
		_tmp2_ = geary_logging_first_record;
		_tmp3_ = _geary_logging_record_ref0 (_tmp2_);
		_geary_logging_record_unref0 (old_record);
		old_record = _tmp3_;
		_tmp4_ = geary_logging_first_record;
		if (_tmp4_ == NULL) {
			GearyLoggingRecord* _tmp5_;
			GearyLoggingRecord* _tmp6_;
			GearyLoggingRecord* _tmp7_;
			GearyLoggingRecord* _tmp8_;
			_tmp5_ = record;
			_tmp6_ = _geary_logging_record_ref0 (_tmp5_);
			_geary_logging_record_unref0 (geary_logging_first_record);
			geary_logging_first_record = _tmp6_;
			_tmp7_ = record;
			_tmp8_ = _geary_logging_record_ref0 (_tmp7_);
			_geary_logging_record_unref0 (geary_logging_last_record);
			geary_logging_last_record = _tmp8_;
		} else {
			GearyLoggingRecord* _tmp9_;
			GearyLoggingRecord* _tmp10_;
			GearyLoggingRecord* _tmp11_;
			GearyLoggingRecord* _tmp12_;
			_tmp9_ = geary_logging_last_record;
			_tmp10_ = record;
			geary_logging_record_set_next (_tmp9_, _tmp10_);
			_tmp11_ = record;
			_tmp12_ = _geary_logging_record_ref0 (_tmp11_);
			_geary_logging_record_unref0 (geary_logging_last_record);
			geary_logging_last_record = _tmp12_;
		}
		if (geary_logging_log_length == geary_logging_max_log_length) {
			GearyLoggingRecord* _tmp13_;
			GearyLoggingRecord* _tmp14_;
			GearyLoggingRecord* _tmp15_;
			GearyLoggingRecord* _tmp16_;
			_tmp13_ = geary_logging_first_record;
			_tmp14_ = geary_logging_record_get_next (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = _geary_logging_record_ref0 (_tmp15_);
			_geary_logging_record_unref0 (geary_logging_first_record);
			geary_logging_first_record = _tmp16_;
		} else {
			guint _tmp17_;
			_tmp17_ = geary_logging_log_length;
			geary_logging_log_length = _tmp17_ + 1;
		}
		g_mutex_unlock (&geary_logging_record_lock);
		_geary_logging_record_unref0 (old_record);
		old_record = NULL;
		_tmp18_ = geary_logging_listener;
		_tmp18__target = geary_logging_listener_target;
		if (_tmp18_ != NULL) {
			GearyLoggingLogRecord _tmp19_;
			gpointer _tmp19__target;
			GearyLoggingRecord* _tmp20_;
			_tmp19_ = geary_logging_listener;
			_tmp19__target = geary_logging_listener_target;
			_tmp20_ = record;
			_tmp19_ (_tmp20_, _tmp19__target);
		}
		_tmp21_ = record;
		geary_logging_write_record (_tmp21_, levels);
		_geary_logging_record_unref0 (old_record);
	}
	result = G_LOG_WRITER_HANDLED;
	_geary_logging_record_unref0 (record);
	return result;
}

inline gboolean
geary_logging_should_blacklist (GearyLoggingRecord* record)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	g_return_val_if_fail (GEARY_LOGGING_IS_RECORD (record), FALSE);
	if (record->levels == G_LOG_LEVEL_WARNING) {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = geary_logging_record_get_domain (record);
		_tmp4_ = _tmp3_;
		_tmp2_ = g_strcmp0 (_tmp4_, "Gtk") == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp5_;
		_tmp5_ = record->message;
		_tmp1_ = g_str_has_prefix (_tmp5_, "actionhelper:");
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp6_;
		_tmp6_ = record->message;
		_tmp0_ = g_str_has_suffix (_tmp6_, "target type NULL)");
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

inline void
geary_logging_write_record (GearyLoggingRecord* record,
                            GLogLevelFlags levels)
{
	FILE* out = NULL;
	FILE* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	FILE* _tmp5_;
	g_return_if_fail (GEARY_LOGGING_IS_RECORD (record));
	_tmp0_ = geary_logging_stream;
	out = _tmp0_;
	_tmp5_ = out;
	if (_tmp5_ != NULL) {
		GeeSet* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp6_ = geary_logging_suppressed_domains;
		_tmp7_ = geary_logging_record_get_domain (record);
		_tmp8_ = _tmp7_;
		_tmp4_ = !gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_COLLECTION, GeeCollection), _tmp8_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = (levels & G_LOG_LEVEL_WARNING) == G_LOG_LEVEL_WARNING;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = (levels & G_LOG_LEVEL_CRITICAL) == G_LOG_LEVEL_CRITICAL;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (levels & G_LOG_LEVEL_ERROR) == G_LOG_LEVEL_ERROR;
	}
	if (_tmp1_) {
		FILE* _tmp9_;
		FILE* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		FILE* _tmp14_;
		_tmp9_ = out;
		if (_tmp9_ == NULL) {
			FILE* _tmp10_;
			_tmp10_ = stderr;
			out = _tmp10_;
		}
		g_mutex_lock (&geary_logging_writer_lock);
		_tmp11_ = out;
		_tmp12_ = geary_logging_record_format (record);
		_tmp13_ = _tmp12_;
		fputs (_tmp13_, _tmp11_);
		_g_free0 (_tmp13_);
		_tmp14_ = out;
		fputc ('\n', _tmp14_);
		g_mutex_unlock (&geary_logging_writer_lock);
		if ((geary_logging_set_breakpoint_on & levels) == levels) {
			G_BREAKPOINT ();
		}
	}
}

inline gchar*
geary_logging_to_prefix (GLogLevelFlags level)
{
	gchar* result;
	switch (level) {
		case G_LOG_LEVEL_ERROR:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("![err]");
			result = _tmp0_;
			return result;
		}
		case G_LOG_LEVEL_CRITICAL:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("![crt]");
			result = _tmp1_;
			return result;
		}
		case G_LOG_LEVEL_WARNING:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("*[wrn]");
			result = _tmp2_;
			return result;
		}
		case G_LOG_LEVEL_MESSAGE:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (" [msg]");
			result = _tmp3_;
			return result;
		}
		case G_LOG_LEVEL_INFO:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (" [inf]");
			result = _tmp4_;
			return result;
		}
		case G_LOG_LEVEL_DEBUG:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (" [deb]");
			result = _tmp5_;
			return result;
		}
		case G_LOG_LEVEL_MASK:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("![***]");
			result = _tmp6_;
			return result;
		}
		default:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup ("![???]");
			result = _tmp7_;
			return result;
		}
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

inline gchar*
geary_logging_field_to_string (GLogField* field)
{
	gchar* value = NULL;
	GLogField _tmp0_;
	gchar* result;
	g_return_val_if_fail (field != NULL, NULL);
	value = NULL;
	_tmp0_ = *field;
	if (_tmp0_.length < ((gssize) 0)) {
		GLogField _tmp1_;
		gconstpointer _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = *field;
		_tmp2_ = _tmp1_.value;
		_tmp3_ = g_strdup ((const gchar*) _tmp2_);
		_g_free0 (value);
		value = _tmp3_;
	} else {
		GLogField _tmp4_;
		_tmp4_ = *field;
		if (_tmp4_.length > ((gssize) 0)) {
			GLogField _tmp5_;
			gconstpointer _tmp6_;
			GLogField _tmp7_;
			gchar* _tmp8_;
			_tmp5_ = *field;
			_tmp6_ = _tmp5_.value;
			_tmp7_ = *field;
			_tmp8_ = string_substring ((const gchar*) _tmp6_, (glong) 0, (glong) _tmp7_.length);
			_g_free0 (value);
			value = _tmp8_;
		}
	}
	result = value;
	return result;
}

/**
     * Returns a string representation of a source based on its state.
     *
     * The string returned will include the source's type name, the
     * its current logging state, and the value of extra_values, if
     * any.
     */
gchar*
geary_logging_source_default_to_string (GearyLoggingSource* source,
                                        const gchar* extra_values)
{
	const gchar* _tmp0_;
	GearyLoggingState* _tmp1_;
	GearyLoggingState* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (GEARY_LOGGING_IS_SOURCE (source), NULL);
	g_return_val_if_fail (extra_values != NULL, NULL);
	_tmp0_ = g_type_name (G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (source, G_TYPE_OBJECT, GObject)));
	_tmp1_ = geary_logging_source_to_logging_state (source);
	_tmp2_ = _tmp1_;
	_tmp3_ = geary_logging_state_format_message (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s(%s%s)", _tmp0_, _tmp4_, extra_values);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_geary_logging_state_unref0 (_tmp2_);
	result = _tmp6_;
	return result;
}

static gchar*
geary_logging_source_log_level_to_priority (GLogLevelFlags level)
{
	gchar* _tmp6_;
	gchar* result;
	if ((level & G_LOG_LEVEL_ERROR) == G_LOG_LEVEL_ERROR) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("3");
		result = _tmp0_;
		return result;
	}
	if ((level & G_LOG_LEVEL_CRITICAL) == G_LOG_LEVEL_CRITICAL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("4");
		result = _tmp1_;
		return result;
	}
	if ((level & G_LOG_LEVEL_WARNING) == G_LOG_LEVEL_WARNING) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("4");
		result = _tmp2_;
		return result;
	}
	if ((level & G_LOG_LEVEL_MESSAGE) == G_LOG_LEVEL_MESSAGE) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("5");
		result = _tmp3_;
		return result;
	}
	if ((level & G_LOG_LEVEL_INFO) == G_LOG_LEVEL_INFO) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("6");
		result = _tmp4_;
		return result;
	}
	if ((level & G_LOG_LEVEL_DEBUG) == G_LOG_LEVEL_DEBUG) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("7");
		result = _tmp5_;
		return result;
	}
	_tmp6_ = g_strdup ("5");
	result = _tmp6_;
	return result;
}

const gchar*
geary_logging_source_get_logging_domain (GearyLoggingSource* self)
{
	GearyLoggingSourceIface* _iface_;
	g_return_val_if_fail (GEARY_LOGGING_IS_SOURCE (self), NULL);
	_iface_ = GEARY_LOGGING_SOURCE_GET_INTERFACE (self);
	if (_iface_->get_logging_domain) {
		return _iface_->get_logging_domain (self);
	}
	return NULL;
}

static const gchar*
geary_logging_source_real_get_logging_domain (GearyLoggingSource* base)
{
	const gchar* result;
	GearyLoggingSource* self;
	self = base;
	result = GEARY_LOGGING_DOMAIN;
	return result;
}

GearyLoggingSource*
geary_logging_source_get_logging_parent (GearyLoggingSource* self)
{
	GearyLoggingSourceIface* _iface_;
	g_return_val_if_fail (GEARY_LOGGING_IS_SOURCE (self), NULL);
	_iface_ = GEARY_LOGGING_SOURCE_GET_INTERFACE (self);
	if (_iface_->get_logging_parent) {
		return _iface_->get_logging_parent (self);
	}
	return NULL;
}

/**
     * Returns a loggable representation of this source's current state.
     *
     * Since this source's internal state may change between being
     * logged and being used from a log record, this records relevant
     * state at the time when it was logged so it may be displayed or
     * recorded as it is right now.
     */
GearyLoggingState*
geary_logging_source_to_logging_state (GearyLoggingSource* self)
{
	GearyLoggingSourceIface* _iface_;
	g_return_val_if_fail (GEARY_LOGGING_IS_SOURCE (self), NULL);
	_iface_ = GEARY_LOGGING_SOURCE_GET_INTERFACE (self);
	if (_iface_->to_logging_state) {
		return _iface_->to_logging_state (self);
	}
	return NULL;
}

/**
     * Returns a string representation of this source based on its state.
     *
     * This simply calls {@link default_to_string} with this source
     * and the empty string, returning the result. Implementations of
     * this interface can call that method if they need to override
     * the default behaviour of this method.
     */
static gchar*
geary_logging_source_real_to_string (GearyLoggingSource* self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = geary_logging_source_default_to_string (self, "");
	result = _tmp0_;
	return result;
}

gchar*
geary_logging_source_to_string (GearyLoggingSource* self)
{
	GearyLoggingSourceIface* _iface_;
	g_return_val_if_fail (GEARY_LOGGING_IS_SOURCE (self), NULL);
	_iface_ = GEARY_LOGGING_SOURCE_GET_INTERFACE (self);
	if (_iface_->to_string) {
		return _iface_->to_string (self);
	}
	return NULL;
}

/**
     * Logs a debug-level log message with this object as context.
     */
inline void
geary_logging_source_debug (GearyLoggingSource* self,
                            const gchar* fmt,
                            ...)
{
	va_list _tmp0_ = {0};
	g_return_if_fail (fmt != NULL);
	va_start (_tmp0_, fmt);
	geary_logging_source_log_structured (self, G_LOG_LEVEL_DEBUG, fmt, _tmp0_);
	va_end (_tmp0_);
}

/**
     * Logs a message-level log message with this object as context.
     */
inline void
geary_logging_source_message (GearyLoggingSource* self,
                              const gchar* fmt,
                              ...)
{
	va_list _tmp0_ = {0};
	g_return_if_fail (fmt != NULL);
	va_start (_tmp0_, fmt);
	geary_logging_source_log_structured (self, G_LOG_LEVEL_MESSAGE, fmt, _tmp0_);
	va_end (_tmp0_);
}

/**
     * Logs a warning-level log message with this object as context.
     */
inline void
geary_logging_source_warning (GearyLoggingSource* self,
                              const gchar* fmt,
                              ...)
{
	va_list _tmp0_ = {0};
	g_return_if_fail (fmt != NULL);
	va_start (_tmp0_, fmt);
	geary_logging_source_log_structured (self, G_LOG_LEVEL_WARNING, fmt, _tmp0_);
	va_end (_tmp0_);
}

/**
     * Logs a error-level log message with this object as context.
     */
inline void
geary_logging_source_error (GearyLoggingSource* self,
                            const gchar* fmt,
                            ...)
{
	va_list _tmp0_ = {0};
	g_return_if_fail (fmt != NULL);
	va_start (_tmp0_, fmt);
	geary_logging_source_log_structured (self, G_LOG_LEVEL_ERROR, fmt, _tmp0_);
	va_end (_tmp0_);
}

/**
     * Logs a critical-level log message with this object as context.
     */
inline void
geary_logging_source_critical (GearyLoggingSource* self,
                               const gchar* fmt,
                               ...)
{
	va_list _tmp0_ = {0};
	g_return_if_fail (fmt != NULL);
	va_start (_tmp0_, fmt);
	geary_logging_source_log_structured (self, G_LOG_LEVEL_CRITICAL, fmt, _tmp0_);
	va_end (_tmp0_);
}

static inline void
geary_logging_source_log_structured (GearyLoggingSource* self,
                                     GLogLevelFlags levels,
                                     const gchar* fmt,
                                     va_list args)
{
	GearyLoggingSourceContext context = {0};
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GearyLoggingSource* decorated = NULL;
	gint _tmp8_ = 0;
	GLogField* _tmp9_;
	GLogField* _tmp10_;
	gint _tmp10__length1;
	g_return_if_fail (fmt != NULL);
	_tmp0_ = geary_logging_source_get_logging_domain (self);
	_tmp1_ = _tmp0_;
	geary_logging_source_context_init (&context, _tmp1_, levels, fmt, args);
	decorated = self;
	while (TRUE) {
		GearyLoggingSource* _tmp2_;
		GearyLoggingSource* _tmp3_;
		GearyLoggingSource* _tmp5_;
		GearyLoggingSource* _tmp6_;
		GearyLoggingSource* _tmp7_;
		_tmp2_ = decorated;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = decorated;
		if (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, G_TYPE_OBJECT, GObject)->ref_count > ((guint) 0)) {
			GearyLoggingSource* _tmp4_;
			_tmp4_ = decorated;
			geary_logging_source_context_append_source (&context, _tmp4_);
		}
		_tmp5_ = decorated;
		_tmp6_ = geary_logging_source_get_logging_parent (_tmp5_);
		_tmp7_ = _tmp6_;
		decorated = _tmp7_;
	}
	_tmp9_ = geary_logging_source_context_to_array (&context, &_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp8_;
	g_log_structured_array (levels, _tmp10_, (gint) _tmp8_);
	_tmp10_ = (g_free (_tmp10_), NULL);
	geary_logging_source_context_destroy (&context);
}

static void
geary_logging_source_context_init (GearyLoggingSourceContext *self,
                                   const gchar* domain,
                                   GLogLevelFlags level,
                                   const gchar* message,
                                   va_list args)
{
	GLogField* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	va_list _tmp3_ = {0};
	gchar* _tmp4_;
	g_return_if_fail (domain != NULL);
	g_return_if_fail (message != NULL);
	memset (self, 0, sizeof (GearyLoggingSourceContext));
	_tmp0_ = g_new0 (GLogField, GEARY_LOGGING_SOURCE_CONTEXT_FIELD_COUNT);
	(*self).fields = (g_free ((*self).fields), NULL);
	(*self).fields = _tmp0_;
	(*self).fields_length1 = GEARY_LOGGING_SOURCE_CONTEXT_FIELD_COUNT;
	(*self).len = GEARY_LOGGING_SOURCE_CONTEXT_FIELD_COUNT;
	(*self).count = (guint8) 0;
	_tmp1_ = geary_logging_source_log_level_to_priority (level);
	_tmp2_ = _tmp1_;
	geary_logging_source_context_append (&(*self), G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, "PRIORITY", _tmp2_);
	_g_free0 (_tmp2_);
	geary_logging_source_context_append (&(*self), G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, "GLIB_DOMAIN", domain);
	va_copy (_tmp3_, args);
	_tmp4_ = g_strdup_vprintf (message, _tmp3_);
	_g_free0 ((*self).message);
	(*self).message = _tmp4_;
	va_end (_tmp3_);
}

void
geary_logging_source_context_append (GearyLoggingSourceContext *self,
                                     GType t_type,
                                     GBoxedCopyFunc t_dup_func,
                                     GDestroyNotify t_destroy_func,
                                     const gchar* key,
                                     gconstpointer value)
{
	guint8 count = 0U;
	GLogField* _tmp1_;
	gint _tmp1__length1;
	GLogField* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	GLogField* _tmp4_;
	gint _tmp4__length1;
	guint8 _tmp5_;
	g_return_if_fail (key != NULL);
	count = (*self).count;
	if ((count + 1) >= ((gint) (*self).len)) {
		gint _tmp0_;
		_tmp0_ = (gint) ((*self).len + GEARY_LOGGING_SOURCE_CONTEXT_FIELD_COUNT);
		(*self).fields = g_renew (GLogField, (*self).fields, (gint) ((*self).len + GEARY_LOGGING_SOURCE_CONTEXT_FIELD_COUNT));
		(_tmp0_ > (*self).fields_length1) ? memset ((*self).fields + (*self).fields_length1, 0, sizeof (GLogField) * (_tmp0_ - (*self).fields_length1)) : NULL;
		(*self).fields_length1 = _tmp0_;
	}
	_tmp1_ = (*self).fields;
	_tmp1__length1 = (*self).fields_length1;
	_tmp1_[count].key = key;
	_tmp2_ = (*self).fields;
	_tmp2__length1 = (*self).fields_length1;
	_tmp2_[count].value = value;
	if (t_type == G_TYPE_STRING) {
		_tmp3_ = -1;
	} else {
		_tmp3_ = 0;
	}
	_tmp4_ = (*self).fields;
	_tmp4__length1 = (*self).fields_length1;
	_tmp4_[count].length = (gssize) _tmp3_;
	_tmp5_ = (*self).count;
	(*self).count = _tmp5_ + 1;
}

inline void
geary_logging_source_context_append_source (GearyLoggingSourceContext *self,
                                            GearyLoggingSource* value)
{
	g_return_if_fail (GEARY_LOGGING_IS_SOURCE (value));
	geary_logging_source_context_append (&(*self), GEARY_LOGGING_TYPE_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, "GEARY_LOGGING_SOURCE", value);
}

static GLogField*
_vala_array_dup17 (GLogField* self,
                   gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (GLogField));
	}
	return NULL;
}

GLogField*
geary_logging_source_context_to_array (GearyLoggingSourceContext *self,
                                       gint* result_length1)
{
	const gchar* _tmp0_;
	GLogField* _tmp1_;
	gint _tmp1__length1;
	GLogField* _tmp2_;
	gint _tmp2__length1;
	GLogField* _tmp3_;
	gint _tmp3__length1;
	GLogField* result;
	_tmp0_ = (*self).message;
	geary_logging_source_context_append (&(*self), G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, "MESSAGE", _tmp0_);
	_tmp1_ = (*self).fields;
	_tmp1__length1 = (*self).fields_length1;
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup17 (_tmp1_ + 0, ((gint) (*self).count) - 0) : _tmp1_;
	_tmp2__length1 = ((gint) (*self).count) - 0;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static GLogField*
_vala_array_dup18 (GLogField* self,
                   gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (GLogField));
	}
	return NULL;
}

void
geary_logging_source_context_copy (const GearyLoggingSourceContext* self,
                                   GearyLoggingSourceContext* dest)
{
	GLogField* _tmp0_;
	gint _tmp0__length1;
	GLogField* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).fields;
	_tmp0__length1 = (*self).fields_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup18 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	(*dest).fields = (g_free ((*dest).fields), NULL);
	(*dest).fields = _tmp1_;
	(*dest).fields_length1 = _tmp1__length1;
	(*dest).len = (*self).len;
	(*dest).count = (*self).count;
	_tmp2_ = (*self).message;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).message);
	(*dest).message = _tmp3_;
}

void
geary_logging_source_context_destroy (GearyLoggingSourceContext* self)
{
	(*self).fields = (g_free ((*self).fields), NULL);
	_g_free0 ((*self).message);
}

GearyLoggingSourceContext*
geary_logging_source_context_dup (const GearyLoggingSourceContext* self)
{
	GearyLoggingSourceContext* dup;
	dup = g_new0 (GearyLoggingSourceContext, 1);
	geary_logging_source_context_copy (self, dup);
	return dup;
}

void
geary_logging_source_context_free (GearyLoggingSourceContext* self)
{
	geary_logging_source_context_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
geary_logging_source_context_get_type_once (void)
{
	GType geary_logging_source_context_type_id;
	geary_logging_source_context_type_id = g_boxed_type_register_static ("GearyLoggingSourceContext", (GBoxedCopyFunc) geary_logging_source_context_dup, (GBoxedFreeFunc) geary_logging_source_context_free);
	return geary_logging_source_context_type_id;
}

GType
geary_logging_source_context_get_type (void)
{
	static gsize geary_logging_source_context_type_id__once = 0;
	if (g_once_init_enter (&geary_logging_source_context_type_id__once)) {
		GType geary_logging_source_context_type_id;
		geary_logging_source_context_type_id = geary_logging_source_context_get_type_once ();
		g_once_init_leave (&geary_logging_source_context_type_id__once, geary_logging_source_context_type_id);
	}
	return geary_logging_source_context_type_id__once;
}

static void
geary_logging_source_default_init (GearyLoggingSourceIface * iface,
                                   gpointer iface_data)
{
	/**
	     * The parent of this source.
	     *
	     * If not null, the parent and its ancestors recursively will be
	     * added to to log message context.
	     */
	g_object_interface_install_property (iface, g_param_spec_object ("logging-parent", "logging-parent", "logging-parent", GEARY_LOGGING_TYPE_SOURCE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	iface->to_string = geary_logging_source_real_to_string;
	iface->get_logging_domain = geary_logging_source_real_get_logging_domain;
}

/**
 * Mixin interface for objects that support structured logging.
 *
 * Logging sources provide both a standard means to obtain a string
 * representation of the object for display to humans, and keep a weak
 * reference to some parent source, enabling context to be
 * automatically added to logging calls. For example, if a Foo object
 * is the logging source parent of a Bar object, log calls made by Bar
 * will automatically be decorated with Foo.
 */
 G_GNUC_NO_INLINE static GType
geary_logging_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyLoggingSourceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_logging_source_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType geary_logging_source_type_id;
	geary_logging_source_type_id = g_type_register_static (G_TYPE_INTERFACE, "GearyLoggingSource", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (geary_logging_source_type_id, G_TYPE_OBJECT);
	return geary_logging_source_type_id;
}

GType
geary_logging_source_get_type (void)
{
	static gsize geary_logging_source_type_id__once = 0;
	if (g_once_init_enter (&geary_logging_source_type_id__once)) {
		GType geary_logging_source_type_id;
		geary_logging_source_type_id = geary_logging_source_get_type_once ();
		g_once_init_leave (&geary_logging_source_type_id__once, geary_logging_source_type_id);
	}
	return geary_logging_source_type_id__once;
}

static inline gpointer
geary_logging_state_get_instance_private (GearyLoggingState* self)
{
	return G_STRUCT_MEMBER_P (self, GearyLoggingState_private_offset);
}

GearyLoggingSource*
geary_logging_state_get_source (GearyLoggingState* self)
{
	GearyLoggingSource* result;
	GearyLoggingSource* _tmp0_;
	g_return_val_if_fail (GEARY_LOGGING_IS_STATE (self), NULL);
	_tmp0_ = self->priv->_source;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
geary_logging_state_set_source (GearyLoggingState* self,
                                GearyLoggingSource* value)
{
	GearyLoggingSource* _tmp0_;
	g_return_if_fail (GEARY_LOGGING_IS_STATE (self));
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_source);
	self->priv->_source = _tmp0_;
}

GearyLoggingState*
geary_logging_state_constructv (GType object_type,
                                GearyLoggingSource* source,
                                const gchar* message,
                                va_list _vala_va_list)
{
	GearyLoggingState* self = NULL;
	gchar* _tmp0_;
	va_list _tmp1_ = {0};
	gchar* _tmp2_;
	g_return_val_if_fail (GEARY_LOGGING_IS_SOURCE (source), NULL);
	g_return_val_if_fail (message != NULL, NULL);
	self = (GearyLoggingState*) g_type_create_instance (object_type);
	geary_logging_state_set_source (self, source);
	_tmp0_ = g_strdup (message);
	_g_free0 (self->priv->message);
	self->priv->message = _tmp0_;
	va_copy (_tmp1_, _vala_va_list);
	_tmp2_ = g_strdup_vprintf (message, _tmp1_);
	_g_free0 (self->priv->message);
	self->priv->message = _tmp2_;
	va_end (_tmp1_);
	return self;
}

GearyLoggingState*
geary_logging_state_new (GearyLoggingSource* source,
                         const gchar* message,
                         ...)
{
	va_list _vala_va_list_obj;
	va_start (_vala_va_list_obj, message);
	return geary_logging_state_constructv (GEARY_LOGGING_TYPE_STATE, source, message, _vala_va_list_obj);
}

GearyLoggingState*
geary_logging_state_construct (GType object_type,
                               GearyLoggingSource* source,
                               const gchar* message,
                               ...)
{
	va_list _vala_va_list_obj;
	va_start (_vala_va_list_obj, message);
	return geary_logging_state_constructv (object_type, source, message, _vala_va_list_obj);
}

gchar*
geary_logging_state_format_message (GearyLoggingState* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (GEARY_LOGGING_IS_STATE (self), NULL);
	_tmp0_ = self->priv->message;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
geary_logging_value_state_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
geary_logging_value_state_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		geary_logging_state_unref (value->data[0].v_pointer);
	}
}

static void
geary_logging_value_state_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = geary_logging_state_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
geary_logging_value_state_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
geary_logging_value_state_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GearyLoggingState * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = geary_logging_state_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
geary_logging_value_state_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	GearyLoggingState ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = geary_logging_state_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
geary_logging_param_spec_state (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	GearyLoggingParamSpecState* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEARY_LOGGING_TYPE_STATE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
geary_logging_value_get_state (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_LOGGING_TYPE_STATE), NULL);
	return value->data[0].v_pointer;
}

void
geary_logging_value_set_state (GValue* value,
                               gpointer v_object)
{
	GearyLoggingState * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_LOGGING_TYPE_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_LOGGING_TYPE_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		geary_logging_state_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_logging_state_unref (old);
	}
}

void
geary_logging_value_take_state (GValue* value,
                                gpointer v_object)
{
	GearyLoggingState * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_LOGGING_TYPE_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_LOGGING_TYPE_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_logging_state_unref (old);
	}
}

static void
geary_logging_state_class_init (GearyLoggingStateClass * klass,
                                gpointer klass_data)
{
	geary_logging_state_parent_class = g_type_class_peek_parent (klass);
	((GearyLoggingStateClass *) klass)->finalize = geary_logging_state_finalize;
	g_type_class_adjust_private_offset (klass, &GearyLoggingState_private_offset);
}

static void
geary_logging_state_instance_init (GearyLoggingState * self,
                                   gpointer klass)
{
	self->priv = geary_logging_state_get_instance_private (self);
	self->ref_count = 1;
}

static void
geary_logging_state_finalize (GearyLoggingState * obj)
{
	GearyLoggingState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_LOGGING_TYPE_STATE, GearyLoggingState);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->_source);
	_g_free0 (self->priv->message);
}

/**
 * A record of the state of a logging source to be recorded.
 *
 * @see Source.to_logging_state
 */
 G_GNUC_NO_INLINE static GType
geary_logging_state_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { geary_logging_value_state_init, geary_logging_value_state_free_value, geary_logging_value_state_copy_value, geary_logging_value_state_peek_pointer, "p", geary_logging_value_state_collect_value, "p", geary_logging_value_state_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GearyLoggingStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_logging_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyLoggingState), 0, (GInstanceInitFunc) geary_logging_state_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType geary_logging_state_type_id;
	geary_logging_state_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GearyLoggingState", &g_define_type_info, &g_define_type_fundamental_info, 0);
	GearyLoggingState_private_offset = g_type_add_instance_private (geary_logging_state_type_id, sizeof (GearyLoggingStatePrivate));
	return geary_logging_state_type_id;
}

GType
geary_logging_state_get_type (void)
{
	static gsize geary_logging_state_type_id__once = 0;
	if (g_once_init_enter (&geary_logging_state_type_id__once)) {
		GType geary_logging_state_type_id;
		geary_logging_state_type_id = geary_logging_state_get_type_once ();
		g_once_init_leave (&geary_logging_state_type_id__once, geary_logging_state_type_id);
	}
	return geary_logging_state_type_id__once;
}

gpointer
geary_logging_state_ref (gpointer instance)
{
	GearyLoggingState * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
geary_logging_state_unref (gpointer instance)
{
	GearyLoggingState * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEARY_LOGGING_STATE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
geary_logging_record_get_instance_private (GearyLoggingRecord* self)
{
	return G_STRUCT_MEMBER_P (self, GearyLoggingRecord_private_offset);
}

const gchar*
geary_logging_record_get_domain (GearyLoggingRecord* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_LOGGING_IS_RECORD (self), NULL);
	_tmp0_ = self->priv->_domain;
	result = _tmp0_;
	return result;
}

static void
geary_logging_record_set_domain (GearyLoggingRecord* self,
                                 const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (GEARY_LOGGING_IS_RECORD (self));
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_domain);
	self->priv->_domain = _tmp0_;
}

GearyAccount*
geary_logging_record_get_account (GearyLoggingRecord* self)
{
	GearyAccount* result;
	GearyAccount* _tmp0_;
	g_return_val_if_fail (GEARY_LOGGING_IS_RECORD (self), NULL);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}

static void
geary_logging_record_set_account (GearyLoggingRecord* self,
                                  GearyAccount* value)
{
	GearyAccount* _tmp0_;
	g_return_if_fail (GEARY_LOGGING_IS_RECORD (self));
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_account);
	self->priv->_account = _tmp0_;
}

GearyClientService*
geary_logging_record_get_service (GearyLoggingRecord* self)
{
	GearyClientService* result;
	GearyClientService* _tmp0_;
	g_return_val_if_fail (GEARY_LOGGING_IS_RECORD (self), NULL);
	_tmp0_ = self->priv->_service;
	result = _tmp0_;
	return result;
}

static void
geary_logging_record_set_service (GearyLoggingRecord* self,
                                  GearyClientService* value)
{
	GearyClientService* _tmp0_;
	g_return_if_fail (GEARY_LOGGING_IS_RECORD (self));
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_service);
	self->priv->_service = _tmp0_;
}

GearyFolder*
geary_logging_record_get_folder (GearyLoggingRecord* self)
{
	GearyFolder* result;
	GearyFolder* _tmp0_;
	g_return_val_if_fail (GEARY_LOGGING_IS_RECORD (self), NULL);
	_tmp0_ = self->priv->_folder;
	result = _tmp0_;
	return result;
}

static void
geary_logging_record_set_folder (GearyLoggingRecord* self,
                                 GearyFolder* value)
{
	GearyFolder* _tmp0_;
	g_return_if_fail (GEARY_LOGGING_IS_RECORD (self));
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_folder);
	self->priv->_folder = _tmp0_;
}

GearyLoggingRecord*
geary_logging_record_get_next (GearyLoggingRecord* self)
{
	GearyLoggingRecord* result;
	GearyLoggingRecord* _tmp0_;
	g_return_val_if_fail (GEARY_LOGGING_IS_RECORD (self), NULL);
	_tmp0_ = self->priv->_next;
	result = _tmp0_;
	return result;
}

void
geary_logging_record_set_next (GearyLoggingRecord* self,
                               GearyLoggingRecord* value)
{
	GearyLoggingRecord* _tmp0_;
	g_return_if_fail (GEARY_LOGGING_IS_RECORD (self));
	_tmp0_ = _geary_logging_record_ref0 (value);
	_geary_logging_record_unref0 (self->priv->_next);
	self->priv->_next = _tmp0_;
}

static GType*
_g_type_dup (GType* self)
{
	GType* dup;
	dup = g_new0 (GType, 1);
	memcpy (dup, self, sizeof (GType));
	return dup;
}

static gpointer
__g_type_dup0 (gpointer self)
{
	return self ? _g_type_dup (self) : NULL;
}

GearyLoggingRecord*
geary_logging_record_construct (GType object_type,
                                GLogField* fields,
                                gint fields_length1,
                                GLogLevelFlags levels,
                                gint64 timestamp)
{
	GearyLoggingRecord* self = NULL;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp3_;
	gint state_count = 0;
	self = (GearyLoggingRecord*) g_type_create_instance (object_type);
	self->levels = levels;
	self->timestamp = timestamp;
	if (fields_length1 > 0) {
		GLogField _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = fields[0];
		_tmp2_ = _tmp1_.key;
		_tmp0_ = g_strcmp0 (_tmp2_, "GLIB_OLD_LOG_API") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	self->priv->old_log_api = _tmp0_;
	_tmp3_ = g_new0 (gchar*, fields_length1 + 1);
	self->priv->states = (_vala_array_free (self->priv->states, self->priv->states_length1, (GDestroyNotify) g_free), NULL);
	self->priv->states = _tmp3_;
	self->priv->states_length1 = fields_length1;
	self->priv->_states_size_ = self->priv->states_length1;
	state_count = 0;
	{
		GLogField* field_collection = NULL;
		gint field_collection_length1 = 0;
		gint _field_collection_size_ = 0;
		gint field_it = 0;
		field_collection = fields;
		field_collection_length1 = fields_length1;
		for (field_it = 0; field_it < field_collection_length1; field_it = field_it + 1) {
			GLogField field = {0};
			field = field_collection[field_it];
			{
				GLogField _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				GQuark _tmp8_ = 0U;
				static GQuark _tmp7_label0 = 0;
				static GQuark _tmp7_label1 = 0;
				static GQuark _tmp7_label2 = 0;
				static GQuark _tmp7_label3 = 0;
				static GQuark _tmp7_label4 = 0;
				static GQuark _tmp7_label5 = 0;
				_tmp4_ = field;
				_tmp5_ = _tmp4_.key;
				_tmp6_ = _tmp5_;
				_tmp8_ = (NULL == _tmp6_) ? 0 : g_quark_from_string (_tmp6_);
				if (_tmp8_ == ((0 != _tmp7_label0) ? _tmp7_label0 : (_tmp7_label0 = g_quark_from_static_string ("GEARY_LOGGING_SOURCE")))) {
					switch (0) {
						default:
						{
							GearyLoggingState* state = NULL;
							GLogField _tmp9_;
							gconstpointer _tmp10_;
							GearyLoggingState* _tmp11_;
							GType type = 0UL;
							GearyLoggingState* _tmp12_;
							GearyLoggingSource* _tmp13_;
							GearyLoggingSource* _tmp14_;
							gchar** _tmp16_;
							gint _tmp16__length1;
							gint _tmp17_;
							GearyLoggingState* _tmp18_;
							gchar* _tmp19_;
							_tmp9_ = field;
							_tmp10_ = _tmp9_.value;
							_tmp11_ = geary_logging_source_to_logging_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEARY_LOGGING_TYPE_SOURCE, GearyLoggingSource));
							state = _tmp11_;
							_tmp12_ = state;
							_tmp13_ = geary_logging_state_get_source (_tmp12_);
							_tmp14_ = _tmp13_;
							type = G_TYPE_FROM_INSTANCE (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, G_TYPE_OBJECT, GObject));
							if (state_count == 0) {
								GType* _tmp15_;
								_tmp15_ = __g_type_dup0 (&type);
								_g_free0 (self->source_type);
								self->source_type = _tmp15_;
							}
							_tmp16_ = self->priv->states;
							_tmp16__length1 = self->priv->states_length1;
							_tmp17_ = state_count;
							state_count = _tmp17_ + 1;
							_tmp18_ = state;
							_tmp19_ = geary_logging_state_format_message (_tmp18_);
							_g_free0 (_tmp16_[_tmp17_]);
							_tmp16_[_tmp17_] = _tmp19_;
							if (g_type_is_a (type, GEARY_TYPE_ACCOUNT)) {
								GearyLoggingState* _tmp20_;
								GearyLoggingSource* _tmp21_;
								GearyLoggingSource* _tmp22_;
								_tmp20_ = state;
								_tmp21_ = geary_logging_state_get_source (_tmp20_);
								_tmp22_ = _tmp21_;
								geary_logging_record_set_account (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEARY_TYPE_ACCOUNT, GearyAccount));
							} else {
								if (g_type_is_a (type, GEARY_TYPE_CLIENT_SERVICE)) {
									GearyLoggingState* _tmp23_;
									GearyLoggingSource* _tmp24_;
									GearyLoggingSource* _tmp25_;
									_tmp23_ = state;
									_tmp24_ = geary_logging_state_get_source (_tmp23_);
									_tmp25_ = _tmp24_;
									geary_logging_record_set_service (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEARY_TYPE_CLIENT_SERVICE, GearyClientService));
								} else {
									if (g_type_is_a (type, GEARY_TYPE_FOLDER)) {
										GearyLoggingState* _tmp26_;
										GearyLoggingSource* _tmp27_;
										GearyLoggingSource* _tmp28_;
										_tmp26_ = state;
										_tmp27_ = geary_logging_state_get_source (_tmp26_);
										_tmp28_ = _tmp27_;
										geary_logging_record_set_folder (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEARY_TYPE_FOLDER, GearyFolder));
									}
								}
							}
							_geary_logging_state_unref0 (state);
							break;
						}
					}
				} else if (_tmp8_ == ((0 != _tmp7_label1) ? _tmp7_label1 : (_tmp7_label1 = g_quark_from_static_string ("GLIB_DOMAIN")))) {
					switch (0) {
						default:
						{
							GLogField _tmp29_;
							gchar* _tmp30_;
							gchar* _tmp31_;
							_tmp29_ = field;
							_tmp30_ = geary_logging_field_to_string (&_tmp29_);
							_tmp31_ = _tmp30_;
							geary_logging_record_set_domain (self, _tmp31_);
							_g_free0 (_tmp31_);
							break;
						}
					}
				} else if (_tmp8_ == ((0 != _tmp7_label2) ? _tmp7_label2 : (_tmp7_label2 = g_quark_from_static_string ("MESSAGE")))) {
					switch (0) {
						default:
						{
							GLogField _tmp32_;
							gchar* _tmp33_;
							_tmp32_ = field;
							_tmp33_ = geary_logging_field_to_string (&_tmp32_);
							_g_free0 (self->message);
							self->message = _tmp33_;
							break;
						}
					}
				} else if (_tmp8_ == ((0 != _tmp7_label3) ? _tmp7_label3 : (_tmp7_label3 = g_quark_from_static_string ("CODE_FILE")))) {
					switch (0) {
						default:
						{
							GLogField _tmp34_;
							gchar* _tmp35_;
							_tmp34_ = field;
							_tmp35_ = geary_logging_field_to_string (&_tmp34_);
							_g_free0 (self->source_filename);
							self->source_filename = _tmp35_;
							break;
						}
					}
				} else if (_tmp8_ == ((0 != _tmp7_label4) ? _tmp7_label4 : (_tmp7_label4 = g_quark_from_static_string ("CODE_LINE")))) {
					switch (0) {
						default:
						{
							GLogField _tmp36_;
							gchar* _tmp37_;
							_tmp36_ = field;
							_tmp37_ = geary_logging_field_to_string (&_tmp36_);
							_g_free0 (self->source_line_number);
							self->source_line_number = _tmp37_;
							break;
						}
					}
				} else if (_tmp8_ == ((0 != _tmp7_label5) ? _tmp7_label5 : (_tmp7_label5 = g_quark_from_static_string ("CODE_FUNC")))) {
					switch (0) {
						default:
						{
							GLogField _tmp38_;
							gchar* _tmp39_;
							_tmp38_ = field;
							_tmp39_ = geary_logging_field_to_string (&_tmp38_);
							_g_free0 (self->source_function);
							self->source_function = _tmp39_;
							break;
						}
					}
				}
			}
		}
	}
	self->priv->states_length1 = state_count;
	return self;
}

GearyLoggingRecord*
geary_logging_record_new (GLogField* fields,
                          gint fields_length1,
                          GLogLevelFlags levels,
                          gint64 timestamp)
{
	return geary_logging_record_construct (GEARY_LOGGING_TYPE_RECORD, fields, fields_length1, levels, timestamp);
}

/**
     * Copy constructor.
     *
     * Copies all properties of the given record except its next
     * record.
     */
static gchar**
_vala_array_dup19 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

GearyLoggingRecord*
geary_logging_record_construct_copy (GType object_type,
                                     GearyLoggingRecord* other)
{
	GearyLoggingRecord* self = NULL;
	const gchar* _tmp0_;
	GearyAccount* _tmp1_;
	GearyClientService* _tmp2_;
	GearyFolder* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GType* _tmp6_;
	GType* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** _tmp15_;
	gint _tmp15__length1;
	g_return_val_if_fail (GEARY_LOGGING_IS_RECORD (other), NULL);
	self = (GearyLoggingRecord*) g_type_create_instance (object_type);
	_tmp0_ = other->priv->_domain;
	geary_logging_record_set_domain (self, _tmp0_);
	_tmp1_ = other->priv->_account;
	geary_logging_record_set_account (self, _tmp1_);
	_tmp2_ = other->priv->_service;
	geary_logging_record_set_service (self, _tmp2_);
	_tmp3_ = other->priv->_folder;
	geary_logging_record_set_folder (self, _tmp3_);
	_tmp4_ = other->message;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->message);
	self->message = _tmp5_;
	_tmp6_ = other->source_type;
	_tmp7_ = __g_type_dup0 (_tmp6_);
	_g_free0 (self->source_type);
	self->source_type = _tmp7_;
	_tmp8_ = other->source_filename;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (self->source_filename);
	self->source_filename = _tmp9_;
	_tmp10_ = other->source_line_number;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (self->source_line_number);
	self->source_line_number = _tmp11_;
	_tmp12_ = other->source_function;
	_tmp13_ = g_strdup (_tmp12_);
	_g_free0 (self->source_function);
	self->source_function = _tmp13_;
	self->levels = other->levels;
	self->timestamp = other->timestamp;
	geary_logging_record_set_next (self, NULL);
	_tmp14_ = other->priv->states;
	_tmp14__length1 = other->priv->states_length1;
	_tmp15_ = (_tmp14_ != NULL) ? _vala_array_dup19 (_tmp14_, _tmp14__length1) : _tmp14_;
	_tmp15__length1 = _tmp14__length1;
	self->priv->states = (_vala_array_free (self->priv->states, self->priv->states_length1, (GDestroyNotify) g_free), NULL);
	self->priv->states = _tmp15_;
	self->priv->states_length1 = _tmp15__length1;
	self->priv->_states_size_ = self->priv->states_length1;
	self->priv->filled = other->priv->filled;
	self->priv->old_log_api = other->priv->old_log_api;
	return self;
}

GearyLoggingRecord*
geary_logging_record_new_copy (GearyLoggingRecord* other)
{
	return geary_logging_record_construct_copy (GEARY_LOGGING_TYPE_RECORD, other);
}

/**
     * Sets the well-known logging source properties.
     *
     * Call this before trying to access {@link account}, {@link
     * folder} and {@link service}. Determining these can be
     * computationally complex and hence is not done by default.
     */
void
geary_logging_record_fill_well_known_sources (GearyLoggingRecord* self)
{
	g_return_if_fail (GEARY_LOGGING_IS_RECORD (self));
}

/** Returns a formatted string representation of this record. */
static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gchar*
geary_logging_record_format (GearyLoggingRecord* self)
{
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* domain = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	gchar* message = NULL;
	gchar* _tmp5_;
	gdouble float_secs = 0.0;
	gdouble floor_secs = 0.0;
	gint ms = 0;
	GDateTime* time = NULL;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	GString* str = NULL;
	GString* _tmp10_;
	GString* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GDateTime* _tmp14_;
	GDateTime* _tmp15_;
	GDateTime* _tmp16_;
	const gchar* _tmp17_;
	gboolean disabled = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	GString* _tmp50_;
	const gchar* _tmp51_;
	GString* _tmp52_;
	const gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* result;
	g_return_val_if_fail (GEARY_LOGGING_IS_RECORD (self), NULL);
	geary_logging_record_fill_well_known_sources (self);
	_tmp1_ = self->priv->_domain;
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "[no domain]";
	}
	_tmp2_ = g_strdup (_tmp0_);
	domain = _tmp2_;
	_tmp4_ = self->message;
	_tmp3_ = _tmp4_;
	if (_tmp3_ == NULL) {
		_tmp3_ = "[no message]";
	}
	_tmp5_ = g_strdup (_tmp3_);
	message = _tmp5_;
	float_secs = (self->timestamp / 1000.0) / 1000.0;
	floor_secs = floor (float_secs);
	ms = (gint) round ((float_secs - floor_secs) * 1000.0);
	_tmp6_ = g_date_time_new_from_unix_utc ((gint64) float_secs);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_date_time_to_local (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_date_time_unref0 (_tmp7_);
	time = _tmp9_;
	_tmp10_ = g_string_sized_new ((gsize) 128);
	str = _tmp10_;
	_tmp11_ = str;
	_tmp12_ = geary_logging_to_prefix (self->levels);
	_tmp13_ = _tmp12_;
	_tmp14_ = time;
	_tmp15_ = time;
	_tmp16_ = time;
	_tmp17_ = domain;
	g_string_printf (_tmp11_, "%s %02d:%02d:%02d.%04d %s:", _tmp13_, g_date_time_get_hour (_tmp14_), g_date_time_get_minute (_tmp15_), g_date_time_get_second (_tmp16_), ms, _tmp17_);
	_g_free0 (_tmp13_);
	{
		gint i = 0;
		gchar** _tmp18_;
		gint _tmp18__length1;
		_tmp18_ = self->priv->states;
		_tmp18__length1 = self->priv->states_length1;
		i = _tmp18__length1 - 1;
		{
			gboolean _tmp19_ = FALSE;
			_tmp19_ = TRUE;
			while (TRUE) {
				GString* _tmp21_;
				GString* _tmp22_;
				gchar** _tmp23_;
				gint _tmp23__length1;
				const gchar* _tmp24_;
				GString* _tmp25_;
				if (!_tmp19_) {
					gint _tmp20_;
					_tmp20_ = i;
					i = _tmp20_ - 1;
				}
				_tmp19_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp21_ = str;
				g_string_append (_tmp21_, " [");
				_tmp22_ = str;
				_tmp23_ = self->priv->states;
				_tmp23__length1 = self->priv->states_length1;
				_tmp24_ = _tmp23_[i];
				g_string_append (_tmp22_, _tmp24_);
				_tmp25_ = str;
				g_string_append (_tmp25_, "]");
			}
		}
	}
	disabled = TRUE;
	if (!disabled) {
		_tmp27_ = !self->priv->old_log_api;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		const gchar* _tmp28_;
		_tmp28_ = self->source_filename;
		_tmp26_ = _tmp28_ != NULL;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		GString* _tmp29_;
		GString* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp38_;
		GString* _tmp43_;
		_tmp29_ = str;
		g_string_append (_tmp29_, " [");
		_tmp30_ = str;
		_tmp31_ = self->source_filename;
		_tmp32_ = g_path_get_basename (_tmp31_);
		_tmp33_ = _tmp32_;
		g_string_append (_tmp30_, _tmp33_);
		_g_free0 (_tmp33_);
		_tmp34_ = self->source_line_number;
		if (_tmp34_ != NULL) {
			GString* _tmp35_;
			GString* _tmp36_;
			const gchar* _tmp37_;
			_tmp35_ = str;
			g_string_append_c (_tmp35_, ':');
			_tmp36_ = str;
			_tmp37_ = self->source_line_number;
			g_string_append (_tmp36_, _tmp37_);
		}
		_tmp38_ = self->source_function;
		if (_tmp38_ != NULL) {
			GString* _tmp39_;
			GString* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			_tmp39_ = str;
			g_string_append_c (_tmp39_, ':');
			_tmp40_ = str;
			_tmp41_ = self->source_function;
			_tmp42_ = string_to_string (_tmp41_);
			g_string_append (_tmp40_, _tmp42_);
		}
		_tmp43_ = str;
		g_string_append (_tmp43_, "]: ");
	} else {
		GType* _tmp44_;
		_tmp44_ = self->source_type;
		if (_tmp44_ != NULL) {
			GString* _tmp45_;
			GString* _tmp46_;
			GType* _tmp47_;
			const gchar* _tmp48_;
			GString* _tmp49_;
			_tmp45_ = str;
			g_string_append (_tmp45_, " ");
			_tmp46_ = str;
			_tmp47_ = self->source_type;
			_tmp48_ = g_type_name (*_tmp47_);
			g_string_append (_tmp46_, _tmp48_);
			_tmp49_ = str;
			g_string_append (_tmp49_, ": ");
		}
	}
	_tmp50_ = str;
	_tmp51_ = message;
	g_string_append (_tmp50_, _tmp51_);
	_tmp52_ = str;
	_tmp53_ = _tmp52_->str;
	_tmp54_ = g_strdup (_tmp53_);
	result = _tmp54_;
	_g_string_free0 (str);
	_g_date_time_unref0 (time);
	_g_free0 (message);
	_g_free0 (domain);
	return result;
}

static void
geary_logging_value_record_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
geary_logging_value_record_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		geary_logging_record_unref (value->data[0].v_pointer);
	}
}

static void
geary_logging_value_record_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = geary_logging_record_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
geary_logging_value_record_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
geary_logging_value_record_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GearyLoggingRecord * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = geary_logging_record_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
geary_logging_value_record_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	GearyLoggingRecord ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = geary_logging_record_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
geary_logging_param_spec_record (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	GearyLoggingParamSpecRecord* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GEARY_LOGGING_TYPE_RECORD), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
geary_logging_value_get_record (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_LOGGING_TYPE_RECORD), NULL);
	return value->data[0].v_pointer;
}

void
geary_logging_value_set_record (GValue* value,
                                gpointer v_object)
{
	GearyLoggingRecord * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_LOGGING_TYPE_RECORD));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_LOGGING_TYPE_RECORD));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		geary_logging_record_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_logging_record_unref (old);
	}
}

void
geary_logging_value_take_record (GValue* value,
                                 gpointer v_object)
{
	GearyLoggingRecord * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GEARY_LOGGING_TYPE_RECORD));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GEARY_LOGGING_TYPE_RECORD));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		geary_logging_record_unref (old);
	}
}

static void
geary_logging_record_class_init (GearyLoggingRecordClass * klass,
                                 gpointer klass_data)
{
	geary_logging_record_parent_class = g_type_class_peek_parent (klass);
	((GearyLoggingRecordClass *) klass)->finalize = geary_logging_record_finalize;
	g_type_class_adjust_private_offset (klass, &GearyLoggingRecord_private_offset);
}

static void
geary_logging_record_instance_init (GearyLoggingRecord * self,
                                    gpointer klass)
{
	self->priv = geary_logging_record_get_instance_private (self);
	self->priv->_domain = NULL;
	self->priv->_account = NULL;
	self->priv->_service = NULL;
	self->priv->_folder = NULL;
	self->message = NULL;
	self->source_type = NULL;
	self->source_filename = NULL;
	self->source_line_number = NULL;
	self->source_function = NULL;
	self->priv->_next = NULL;
	self->priv->filled = FALSE;
	self->priv->old_log_api = FALSE;
	self->ref_count = 1;
}

static void
geary_logging_record_finalize (GearyLoggingRecord * obj)
{
	GearyLoggingRecord * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_LOGGING_TYPE_RECORD, GearyLoggingRecord);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_domain);
	_g_object_unref0 (self->priv->_account);
	_g_object_unref0 (self->priv->_service);
	_g_object_unref0 (self->priv->_folder);
	_g_free0 (self->message);
	_g_free0 (self->source_type);
	_g_free0 (self->source_filename);
	_g_free0 (self->source_line_number);
	_g_free0 (self->source_function);
	_geary_logging_record_unref0 (self->priv->_next);
	self->priv->states = (_vala_array_free (self->priv->states, self->priv->states_length1, (GDestroyNotify) g_free), NULL);
}

/**
 * A record of a single message sent to the logging system.
 *
 * A record is created for each message logged, and stored in a
 * limited-length, singly-linked buffer. Applications can retrieve
 * this by calling {@link get_earliest_record} and then {get_next},
 * and can be notified of new records via {@link set_log_listener}.
 */
 G_GNUC_NO_INLINE static GType
geary_logging_record_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { geary_logging_value_record_init, geary_logging_value_record_free_value, geary_logging_value_record_copy_value, geary_logging_value_record_peek_pointer, "p", geary_logging_value_record_collect_value, "p", geary_logging_value_record_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GearyLoggingRecordClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_logging_record_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyLoggingRecord), 0, (GInstanceInitFunc) geary_logging_record_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType geary_logging_record_type_id;
	geary_logging_record_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GearyLoggingRecord", &g_define_type_info, &g_define_type_fundamental_info, 0);
	GearyLoggingRecord_private_offset = g_type_add_instance_private (geary_logging_record_type_id, sizeof (GearyLoggingRecordPrivate));
	return geary_logging_record_type_id;
}

GType
geary_logging_record_get_type (void)
{
	static gsize geary_logging_record_type_id__once = 0;
	if (g_once_init_enter (&geary_logging_record_type_id__once)) {
		GType geary_logging_record_type_id;
		geary_logging_record_type_id = geary_logging_record_get_type_once ();
		g_once_init_leave (&geary_logging_record_type_id__once, geary_logging_record_type_id);
	}
	return geary_logging_record_type_id__once;
}

gpointer
geary_logging_record_ref (gpointer instance)
{
	GearyLoggingRecord * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
geary_logging_record_unref (gpointer instance)
{
	GearyLoggingRecord * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GEARY_LOGGING_RECORD_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static void
_vala_clear_GMutex (GMutex * mutex)
{
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}

static void
_vala_clear_GRecMutex (GRecMutex * mutex)
{
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}

static void
_vala_clear_GRWLock (GRWLock * mutex)
{
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}

static void
_vala_clear_GCond (GCond * mutex)
{
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}

