/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DisabledPluginsState {
    private static volatile Set<PluginId> ourDisabledPlugins;
    @Nullable
    private static Runnable disabledPluginListener;

    public static void dontLoadDisabledPlugins() {
        ourDisabledPlugins = Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void loadDisabledPlugins(@NotNull String configPath, @NotNull Collection<PluginId> disabledPlugins) {
        List<String> nonEssentialSuppressedPlugins;
        Path file2;
        if (configPath == null) {
            DisabledPluginsState.$$$reportNull$$$0(1);
        }
        if (disabledPlugins == null) {
            DisabledPluginsState.$$$reportNull$$$0(2);
        }
        if (!Files.isRegularFile(file2 = Paths.get(configPath, "disabled_plugins.txt"), new LinkOption[0])) {
            return;
        }
        List<String> requiredPlugins = Arrays.asList(System.getProperty("idea.required.plugins.id", "").split(","));
        String[] suppressedPlugins = System.getProperty("idea.suppressed.plugins.id", "").split(",");
        if (suppressedPlugins.length == 0) {
            nonEssentialSuppressedPlugins = Collections.emptyList();
        } else {
            ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
            ArrayList<String> result2 = new ArrayList<String>(suppressedPlugins.length);
            for (String t : suppressedPlugins) {
                if (appInfo.isEssentialPlugin(t)) continue;
                result2.add(t);
            }
            nonEssentialSuppressedPlugins = result2;
        }
        try {
            boolean updateDisablePluginsList = false;
            try (BufferedReader reader = Files.newBufferedReader(file2);){
                String id;
                while ((id = reader.readLine()) != null) {
                    if (!requiredPlugins.contains(id = id.trim()) && !ApplicationInfoImpl.getShadowInstance().isEssentialPlugin(id)) {
                        disabledPlugins.add(PluginId.getId(id));
                        continue;
                    }
                    updateDisablePluginsList = true;
                }
                for (String suppressedId : nonEssentialSuppressedPlugins) {
                    if (!disabledPlugins.add(PluginId.getId(suppressedId))) continue;
                    updateDisablePluginsList = true;
                }
            }
            finally {
                if (updateDisablePluginsList) {
                    PluginManagerCore.savePluginsList(disabledPlugins, file2, false);
                    DisabledPluginsState.fireEditDisablePlugins();
                }
            }
        }
        catch (IOException e) {
            DisabledPluginsState.getLogger().info("Unable to load disabled plugins list from " + file2, e);
        }
    }

    @NotNull
    public static Set<PluginId> disabledPlugins() {
        Set<PluginId> set = Collections.unmodifiableSet(DisabledPluginsState.getDisabledIds());
        if (set == null) {
            DisabledPluginsState.$$$reportNull$$$0(3);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static Set<PluginId> getDisabledIds() {
        Set<PluginId> result2 = ourDisabledPlugins;
        if (result2 != null) {
            Set<PluginId> set = result2;
            if (set == null) {
                DisabledPluginsState.$$$reportNull$$$0(4);
            }
            return set;
        }
        if (System.getProperty("idea.ignore.disabled.plugins") != null) {
            Set<PluginId> set = Collections.emptySet();
            if (set == null) {
                DisabledPluginsState.$$$reportNull$$$0(5);
            }
            return set;
        }
        Class<PluginManagerCore> clazz = PluginManagerCore.class;
        synchronized (PluginManagerCore.class) {
            block10: {
                result2 = ourDisabledPlugins;
                if (result2 == null) break block10;
                Set<PluginId> set = result2;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                if (set == null) {
                    DisabledPluginsState.$$$reportNull$$$0(6);
                }
                return set;
            }
            result2 = new LinkedHashSet<PluginId>();
            DisabledPluginsState.loadDisabledPlugins(PathManager.getConfigPath(), result2);
            ourDisabledPlugins = result2;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            Set<PluginId> set = result2;
            if (set == null) {
                DisabledPluginsState.$$$reportNull$$$0(7);
            }
            return set;
        }
    }

    private static void fireEditDisablePlugins() {
        if (disabledPluginListener != null) {
            disabledPluginListener.run();
        }
    }

    @NotNull
    public static Logger getLogger() {
        Logger logger = Logger.getInstance("#com.intellij.ide.plugins.DisabledPluginsState");
        if (logger == null) {
            DisabledPluginsState.$$$reportNull$$$0(18);
        }
        return logger;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 18: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPath";
                break;
            }
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPlugins";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/DisabledPluginsState";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIdsToEnable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginIdsToDisable";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/DisabledPluginsState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "disabledPlugins";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIds";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setDisabledPluginListener";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadDisabledPlugins";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 18: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "disablePlugin";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugin";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugins";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "enablePluginsById";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateDisabledPluginsState";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "trySaveDisabledPlugins";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "saveDisabledPlugins";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 18: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

