/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.psi.impl.cache.CommentTokenSetProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public final class CacheUtil {
    public static boolean isInComments(IElementType tokenType) {
        TokenSet commentTokens;
        Language language = tokenType.getLanguage();
        for (CommentTokenSetProvider provider2 : CommentTokenSetProvider.EXTENSION.allForLanguage(language)) {
            if (!provider2.isInComments(tokenType)) continue;
            return true;
        }
        boolean inComments = false;
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        if (parserDefinition != null && (commentTokens = parserDefinition.getCommentTokens()).contains(tokenType)) {
            inComments = true;
        }
        return inComments;
    }
}

