/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.ClasspathCache;
import com.intellij.util.lang.JarMemoryLoader;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.Resource;
import com.intellij.util.lang.fastutil.StrippedIntOpenHashSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JarLoader
extends Loader {
    private static final List<Map.Entry<Resource.Attribute, Attributes.Name>> PACKAGE_FIELDS = Arrays.asList(new AbstractMap.SimpleImmutableEntry<Resource.Attribute, Attributes.Name>(Resource.Attribute.SPEC_TITLE, Attributes.Name.SPECIFICATION_TITLE), new AbstractMap.SimpleImmutableEntry<Resource.Attribute, Attributes.Name>(Resource.Attribute.SPEC_VERSION, Attributes.Name.SPECIFICATION_VERSION), new AbstractMap.SimpleImmutableEntry<Resource.Attribute, Attributes.Name>(Resource.Attribute.SPEC_VENDOR, Attributes.Name.SPECIFICATION_VENDOR), new AbstractMap.SimpleImmutableEntry<Resource.Attribute, Attributes.Name>(Resource.Attribute.IMPL_TITLE, Attributes.Name.IMPLEMENTATION_TITLE), new AbstractMap.SimpleImmutableEntry<Resource.Attribute, Attributes.Name>(Resource.Attribute.IMPL_VERSION, Attributes.Name.IMPLEMENTATION_VERSION), new AbstractMap.SimpleImmutableEntry<Resource.Attribute, Attributes.Name>(Resource.Attribute.IMPL_VENDOR, Attributes.Name.IMPLEMENTATION_VENDOR));
    private final String myFilePath;
    private final ClassPath myConfiguration;
    private final URL myUrl;
    private SoftReference<JarMemoryLoader> myMemoryLoader;
    private volatile SoftReference<ZipFile> myZipFileSoftReference;
    private volatile Map<Resource.Attribute, String> myAttributes;
    private volatile String myClassPathManifestAttribute;
    private final AtomicInteger myNumberOfRequests;
    private volatile StrippedIntOpenHashSet myPackageHashesInside;
    private static final Object ourLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JarLoader(@NotNull URL url, @NotNull String filePath2, int index2, @NotNull ClassPath configuration2) throws IOException {
        if (url == null) {
            JarLoader.$$$reportNull$$$0(0);
        }
        if (filePath2 == null) {
            JarLoader.$$$reportNull$$$0(1);
        }
        if (configuration2 == null) {
            JarLoader.$$$reportNull$$$0(2);
        }
        super(new URL("jar", "", -1, url + "!/"), index2);
        this.myNumberOfRequests = new AtomicInteger();
        this.myFilePath = filePath2;
        this.myConfiguration = configuration2;
        this.myUrl = url;
        if (!configuration2.myLazyClassloadingCaches) {
            ZipFile zipFile2 = this.getZipFile();
            try {
                JarMemoryLoader loader;
                if (configuration2.myPreloadJarContents && (loader = JarMemoryLoader.load(zipFile2, this.getBaseURL(), this)) != null) {
                    this.myMemoryLoader = new SoftReference<JarMemoryLoader>(loader);
                }
            }
            finally {
                this.releaseZipFile(zipFile2);
            }
        }
    }

    Map<Resource.Attribute, String> getAttributes() {
        this.loadManifestAttributes();
        return this.myAttributes;
    }

    @Nullable
    String getClassPathManifestAttribute() {
        this.loadManifestAttributes();
        String manifestAttribute = this.myClassPathManifestAttribute;
        return manifestAttribute != "<null>" ? manifestAttribute : null;
    }

    @Nullable
    private static Map<Resource.Attribute, String> getAttributes(@Nullable Attributes attributes2) {
        if (attributes2 == null) {
            return null;
        }
        EnumMap<Resource.Attribute, String> map = null;
        for (Map.Entry<Resource.Attribute, Attributes.Name> p : PACKAGE_FIELDS) {
            String value2 = attributes2.getValue(p.getValue());
            if (value2 == null) continue;
            if (map == null) {
                map = new EnumMap<Resource.Attribute, String>(Resource.Attribute.class);
            }
            map.put(p.getKey(), value2);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadManifestAttributes() {
        if (this.myClassPathManifestAttribute != null) {
            return;
        }
        JarLoader jarLoader = this;
        synchronized (jarLoader) {
            try {
                if (this.myClassPathManifestAttribute != null) {
                    return;
                }
                ZipFile zipFile2 = this.getZipFile();
                try {
                    Attributes manifestAttributes = this.myConfiguration.getManifestData(this.myUrl);
                    if (manifestAttributes == null) {
                        ZipEntry entry = zipFile2.getEntry("META-INF/MANIFEST.MF");
                        if (entry != null) {
                            manifestAttributes = JarLoader.loadManifestAttributes(zipFile2.getInputStream(entry));
                        }
                        if (manifestAttributes == null) {
                            manifestAttributes = new Attributes(0);
                        }
                        this.myConfiguration.cacheManifestData(this.myUrl, manifestAttributes);
                    }
                    this.myAttributes = JarLoader.getAttributes(manifestAttributes);
                    Object attribute = manifestAttributes.get(Attributes.Name.CLASS_PATH);
                    this.myClassPathManifestAttribute = attribute instanceof String ? (String)attribute : "<null>";
                }
                finally {
                    this.releaseZipFile(zipFile2);
                }
            }
            catch (IOException io) {
                throw new RuntimeException(io);
            }
        }
    }

    @Nullable
    private static Attributes loadManifestAttributes(InputStream stream) {
        Attributes attributes2;
        try {
            attributes2 = new Manifest(stream).getMainAttributes();
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (Exception exception) {
                return null;
            }
        }
        stream.close();
        return attributes2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ClasspathCache.LoaderData buildData() throws IOException {
        ZipFile zipFile2 = this.getZipFile();
        ClasspathCache.LoaderDataBuilder loaderDataBuilder = new ClasspathCache.LoaderDataBuilder();
        Enumeration<? extends ZipEntry> entries = zipFile2.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (name.endsWith(".class")) {
                loaderDataBuilder.addClassPackageFromName(name);
            } else {
                loaderDataBuilder.addResourcePackageFromName(name);
            }
            loaderDataBuilder.addPossiblyDuplicateNameEntry(name);
        }
        ClasspathCache.LoaderData loaderData = loaderDataBuilder.build();
        ClasspathCache.LoaderData loaderData2 = loaderData;
        if (loaderData2 == null) {
            JarLoader.$$$reportNull$$$0(3);
        }
        return loaderData2;
        finally {
            this.releaseZipFile(zipFile2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    private StrippedIntOpenHashSet buildPackageHashes() {
        ZipFile zipFile2 = this.getZipFile();
        Enumeration<? extends ZipEntry> entries = zipFile2.entries();
        StrippedIntOpenHashSet result2 = new StrippedIntOpenHashSet();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            result2.add(ClasspathCache.getPackageNameHash(entry.getName()));
        }
        result2.add(0);
        StrippedIntOpenHashSet strippedIntOpenHashSet = result2;
        this.releaseZipFile(zipFile2);
        StrippedIntOpenHashSet strippedIntOpenHashSet2 = strippedIntOpenHashSet;
        if (strippedIntOpenHashSet2 == null) {
            JarLoader.$$$reportNull$$$0(4);
        }
        return strippedIntOpenHashSet2;
        {
            catch (Throwable throwable) {
                try {
                    this.releaseZipFile(zipFile2);
                    throw throwable;
                }
                catch (Exception e) {
                    this.error("url: " + this.myFilePath, e);
                    return new StrippedIntOpenHashSet(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    Resource getResource(@NotNull String name) {
        Resource resource;
        JarMemoryLoader loader;
        if (name == null) {
            JarLoader.$$$reportNull$$$0(5);
        }
        if (this.myConfiguration.myLazyClassloadingCaches) {
            int numberOfHits = this.myNumberOfRequests.incrementAndGet();
            StrippedIntOpenHashSet packagesInside = this.myPackageHashesInside;
            if (numberOfHits > 1000 && packagesInside == null) {
                this.myPackageHashesInside = packagesInside = this.buildPackageHashes();
            }
            if (packagesInside != null && !packagesInside.contains(ClasspathCache.getPackageNameHash(name))) {
                return null;
            }
        }
        JarMemoryLoader jarMemoryLoader = loader = this.myMemoryLoader != null ? this.myMemoryLoader.get() : null;
        if (loader != null && (resource = loader.getResource(name)) != null) {
            return resource;
        }
        try {
            ZipFile zipFile2 = this.getZipFile();
            try {
                ZipEntry entry = zipFile2.getEntry(name);
                if (entry == null) return null;
                Resource resource2 = this.instantiateResource(this.getBaseURL(), entry);
                return resource2;
            }
            finally {
                this.releaseZipFile(zipFile2);
            }
        }
        catch (Exception e) {
            this.error("url: " + this.myFilePath, e);
        }
        return null;
    }

    @NotNull
    protected Resource instantiateResource(@NotNull URL url, @NotNull ZipEntry entry) throws IOException {
        if (url == null) {
            JarLoader.$$$reportNull$$$0(6);
        }
        if (entry == null) {
            JarLoader.$$$reportNull$$$0(7);
        }
        return new MyResource(url, entry);
    }

    protected void error(@NotNull String message, @NotNull Throwable t) {
        if (message == null) {
            JarLoader.$$$reportNull$$$0(8);
        }
        if (t == null) {
            JarLoader.$$$reportNull$$$0(9);
        }
        if (this.myConfiguration.myLogErrorOnMissingJar) {
            LoggerRt.getInstance(JarLoader.class).error(message, t);
        } else {
            LoggerRt.getInstance(JarLoader.class).warn(message, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected ZipFile getZipFile() throws IOException {
        ZipFile zipFile2;
        if (!this.myConfiguration.myCanLockJars) {
            ZipFile zipFile3 = this.createZipFile(this.myFilePath);
            if (zipFile3 != null) return zipFile3;
            JarLoader.$$$reportNull$$$0(13);
            return zipFile3;
        }
        SoftReference<ZipFile> ref = this.myZipFileSoftReference;
        ZipFile zipFile4 = zipFile2 = ref == null ? null : ref.get();
        if (zipFile2 != null) {
            ZipFile zipFile5 = zipFile2;
            if (zipFile5 != null) return zipFile5;
            JarLoader.$$$reportNull$$$0(10);
            return zipFile5;
        }
        Object object = ourLock;
        // MONITORENTER : object
        ref = this.myZipFileSoftReference;
        ZipFile zipFile6 = zipFile2 = ref == null ? null : ref.get();
        if (zipFile2 != null) {
            ZipFile zipFile7 = zipFile2;
            // MONITOREXIT : object
            if (zipFile7 != null) return zipFile7;
            JarLoader.$$$reportNull$$$0(11);
            return zipFile7;
        }
        zipFile2 = this.createZipFile(this.myFilePath);
        this.myZipFileSoftReference = new SoftReference<ZipFile>(zipFile2);
        ZipFile zipFile8 = zipFile2;
        // MONITOREXIT : object
        if (zipFile8 != null) return zipFile8;
        JarLoader.$$$reportNull$$$0(12);
        return zipFile8;
    }

    @NotNull
    protected ZipFile createZipFile(@NotNull String path2) throws IOException {
        if (path2 == null) {
            JarLoader.$$$reportNull$$$0(14);
        }
        return new ZipFile(path2);
    }

    protected void releaseZipFile(@NotNull ZipFile zipFile2) throws IOException {
        if (zipFile2 == null) {
            JarLoader.$$$reportNull$$$0(15);
        }
        if (!this.myConfiguration.myCanLockJars) {
            zipFile2.close();
        }
    }

    public String toString() {
        return "JarLoader [" + this.myFilePath + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/JarLoader";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/JarLoader";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPackageHashes";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getZipFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResource";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "instantiateResource";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createZipFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "releaseZipFile";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    protected class MyResource
    extends Resource {
        protected final URL myUrl;
        protected final ZipEntry myEntry;

        MyResource(@NotNull URL url, ZipEntry entry) throws IOException {
            if (url == null) {
                MyResource.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                MyResource.$$$reportNull$$$0(1);
            }
            this.myUrl = new URL(url, entry.getName());
            this.myEntry = entry;
        }

        @Override
        @NotNull
        public URL getURL() {
            URL uRL = this.myUrl;
            if (uRL == null) {
                MyResource.$$$reportNull$$$0(2);
            }
            return uRL;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.getBytes());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public byte[] getBytes() throws IOException {
            byte[] byArray;
            InputStream stream;
            ZipFile file2;
            block4: {
                file2 = JarLoader.this.getZipFile();
                stream = null;
                stream = file2.getInputStream(this.myEntry);
                byArray = FileUtilRt.loadBytes(stream, (int)this.myEntry.getSize());
                if (byArray != null) break block4;
                MyResource.$$$reportNull$$$0(3);
            }
            return byArray;
            finally {
                if (stream != null) {
                    stream.close();
                }
                JarLoader.this.releaseZipFile(file2);
            }
        }

        @Override
        public String getValue(@NotNull Resource.Attribute key) {
            if (key == null) {
                MyResource.$$$reportNull$$$0(4);
            }
            JarLoader.this.loadManifestAttributes();
            return JarLoader.this.myAttributes != null ? (String)JarLoader.this.myAttributes.get((Object)key) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/lang/JarLoader$MyResource";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/lang/JarLoader$MyResource";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getURL";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBytes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getValue";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

