/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReporterWithContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterConfiguration;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.checker.EvaluationMode;
import org.jetbrains.kotlin.ir.interpreter.checker.IrConstTransformer;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmBackendErrors;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ConstEvaluationLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "configuration", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterConfiguration;", "getConfiguration", "()Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterConfiguration;", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "interpreter", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "getInterpreter", "()Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.jvm.lower"})
public final class ConstEvaluationLowering
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final IrInterpreterConfiguration configuration;
    @NotNull
    private final IrInterpreter interpreter;

    public ConstEvaluationLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
        this.configuration = new IrInterpreterConfiguration(0, 0, false, true, false, 23, null);
        this.interpreter = new IrInterpreter(new IrInterpreterEnvironment(this.context.getIrBuiltIns(), this.configuration), MapsKt.emptyMap());
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrInterpreterConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final IrInterpreter getInterpreter() {
        return this.interpreter;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        boolean suppressErrors = this.context.getConfiguration().getBoolean(JVMConfigurationKeys.IGNORE_CONST_OPTIMIZATION_ERRORS);
        IrConstTransformer transformer2 = new IrConstTransformer(this.interpreter, irFile, EvaluationMode.ONLY_INTRINSIC_CONST, (Function2<? super IrElement, ? super IrErrorExpression, Unit>)new Function2<IrElement, IrErrorExpression, Unit>(this, irFile){
            final /* synthetic */ ConstEvaluationLowering this$0;
            final /* synthetic */ IrFile $irFile;
            {
                this.this$0 = $receiver;
                this.$irFile = $irFile;
                super(2);
            }

            public final void invoke(@NotNull IrElement p0, @NotNull IrErrorExpression p1) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                Intrinsics.checkNotNullParameter(p1, "p1");
                ConstEvaluationLowering.access$lower$onWarning(this.this$0, this.$irFile, p0, p1);
            }

            @NotNull
            public final String getSignature() {
                return "lower$onWarning(Lorg/jetbrains/kotlin/backend/jvm/lower/ConstEvaluationLowering;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/expressions/IrErrorExpression;)V";
            }

            @NotNull
            public final String getName() {
                return "onWarning";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Intrinsics.Kotlin.class);
            }
        }, (Function2<? super IrElement, ? super IrErrorExpression, Unit>)new Function2<IrElement, IrErrorExpression, Unit>(this, irFile){
            final /* synthetic */ ConstEvaluationLowering this$0;
            final /* synthetic */ IrFile $irFile;
            {
                this.this$0 = $receiver;
                this.$irFile = $irFile;
                super(2);
            }

            public final void invoke(@NotNull IrElement p0, @NotNull IrErrorExpression p1) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                Intrinsics.checkNotNullParameter(p1, "p1");
                ConstEvaluationLowering.access$lower$onError(this.this$0, this.$irFile, p0, p1);
            }

            @NotNull
            public final String getSignature() {
                return "lower$onError(Lorg/jetbrains/kotlin/backend/jvm/lower/ConstEvaluationLowering;Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lorg/jetbrains/kotlin/ir/IrElement;Lorg/jetbrains/kotlin/ir/expressions/IrErrorExpression;)V";
            }

            @NotNull
            public final String getName() {
                return "onError";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Intrinsics.Kotlin.class);
            }
        }, suppressErrors);
        irFile.transformChildren(transformer2, null);
    }

    private static final void lower$onError(ConstEvaluationLowering this$0, IrFile $irFile, IrElement element, IrErrorExpression error) {
        KtDiagnosticReporterWithContext.DiagnosticContextImpl.report$default(this$0.context.getKtDiagnosticReporter().at(element, $irFile), JvmBackendErrors.INSTANCE.getEXCEPTION_IN_CONST_VAL_INITIALIZER(), error.getDescription(), null, 4, null);
    }

    private static final void lower$onWarning(ConstEvaluationLowering this$0, IrFile $irFile, IrElement element, IrErrorExpression warning) {
        KtDiagnosticReporterWithContext.DiagnosticContextImpl.report$default(this$0.context.getKtDiagnosticReporter().at(element, $irFile), JvmBackendErrors.INSTANCE.getEXCEPTION_IN_CONST_EXPRESSION(), warning.getDescription(), null, 4, null);
    }

    public static final /* synthetic */ void access$lower$onWarning(ConstEvaluationLowering this$0, IrFile $irFile, IrElement element, IrErrorExpression warning) {
        ConstEvaluationLowering.lower$onWarning(this$0, $irFile, element, warning);
    }

    public static final /* synthetic */ void access$lower$onError(ConstEvaluationLowering this$0, IrFile $irFile, IrElement element, IrErrorExpression error) {
        ConstEvaluationLowering.lower$onError(this$0, $irFile, element, error);
    }
}

