## Name

GUI Markup Language (GML)

## Description

GML is Serenity's graphic user interface (GUI) markup language. GML files are human-readable text files and have no easily detectable filemagic. The format is strongly influenced by QML, the Qt Modeling Language.

It allows you to easily define GUI interfaces for your applications. It is easy to learn and use in C++.

You can easily add GML files to your project in Hack Studio either using

`Project > New > GML File`

Or right clicking on a folder in the TreeView and using

`New > GML File`

## See also

-   [gml-format(1)](help://man/1/gml-format) formats your GML files.
-   [GML Playground(1)](help://man/1/GMLPlayground) is an interactive GML creation tool.

### List of GML manpages

-   [Using GML](help://man/5/GML-Usage)
-   [GML syntax](help://man/5/GML-Syntax)
-   Extending GML
    -   [Define properties](help://man/5/GML-Define-property)
    -   [Define widgets](help://man/5/GML-Define-widget)
-   GML object and property reference
    -   [Core::Object](help://man/5/GML-CoreObject)
    -   [UI Dimensions](help://man/5/GML-UI-Dimensions)
    -   Layouts
        -   [HorizontalBoxLayout](help://man/5/GML-Layout-HorizontalBoxLayout)
        -   [VerticalBoxLayout](help://man/5/GML-Layout-VerticalBoxLayout)
    -   Widgets
        -   [Breadcrumbbar](help://man/5/GML-Widget-Breadcrumbbar)
        -   [Button](help://man/5/GML-Widget-Button)
        -   [Calendar](help://man/5/GML-Widget-Calendar)
        -   [CheckBox](help://man/5/GML-Widget-CheckBox)
        -   [ColorInput](help://man/5/GML-Widget-ColorInput)
        -   [ComboBox](help://man/5/GML-Widget-ComboBox)
        -   [Frame](help://man/5/GML-Widget-Frame)
        -   [GroupBox](help://man/5/GML-Widget-GroupBox)
        -   [HorizontalProgressbar](help://man/5/GML-Widget-HorizontalProgressbar)
        -   [HorizontalSeparator](help://man/5/GML-Widget-HorizontalSeparator)
        -   [HorizontalSlider](help://man/5/GML-Widget-HorizontalSlider)
        -   [HorizontalSplitter](help://man/5/GML-Widget-HorizontalSplitter)
        -   [IconView](help://man/5/GML-Widget-IconView)
        -   [ImageWidget](help://man/5/GML-Widget-ImageWidget)
        -   [Label](help://man/5/GML-Widget-Label)
        -   [ListView](help://man/5/GML-Widget-ListView)
        -   [MultiView](help://man/5/GML-Widget-MultiView)
        -   [OpacitySlider](help://man/5/GML-Widget-OpacitySlider)
        -   [PasswordBox](help://man/5/GML-Widget-PasswordBox)
        -   [Progressbar](help://man/5/GML-Widget-Progressbar)
        -   [RadioButton](help://man/5/GML-Widget-RadioButton)
        -   [ScrollableContainerWidget](help://man/5/GML-Widget-ScrollableContainerWidget)
        -   [Scrollbar](help://man/5/GML-Widget-Scrollbar)
        -   [Slider](help://man/5/GML-Widget-Slider)
        -   [SpinBox](help://man/5/GML-Widget-SpinBox)
        -   [StackWidget](help://man/5/GML-Widget-StackWidget)
        -   [Statusbar](help://man/5/GML-Widget-Statusbar)
        -   [TableView](help://man/5/GML-Widget-TableView)
        -   [TabWidget](help://man/5/GML-Widget-TabWidget)
        -   [TextBox](help://man/5/GML-Widget-TextBox)
        -   [TextEditor](help://man/5/GML-Widget-TextEditor)
        -   [Toolbar](help://man/5/GML-Widget-Toolbar)
        -   [ToolbarContainer](help://man/5/GML-Widget-ToolbarContainer)
        -   [Tray](help://man/5/GML-Widget-Tray)
        -   [TreeView](help://man/5/GML-Widget-TreeView)
        -   [UrlBox](help://man/5/GML-Widget-UrlBox)
        -   [ValueSlider](help://man/5/GML-Widget-ValueSlider)
        -   [VerticalProgressbar](help://man/5/GML-Widget-VerticalProgressbar)
        -   [VerticalSeparator](help://man/5/GML-Widget-VerticalSeparator)
        -   [VerticalSlider](help://man/5/GML-Widget-VerticalSlider)
        -   [VerticalSplitter](help://man/5/GML-Widget-VerticalSplitter)
        -   [Widget](help://man/5/GML-Widget)

