/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.transport.unload;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.ml.common.transport.unload.UnloadModelNodeResponse;

public class UnloadModelNodesResponse
extends BaseNodesResponse<UnloadModelNodeResponse>
implements ToXContentObject {
    public UnloadModelNodesResponse(StreamInput in) throws IOException {
        super(new ClusterName(in), in.readList(UnloadModelNodeResponse::readStats), in.readList(FailedNodeException::new));
    }

    public UnloadModelNodesResponse(ClusterName clusterName, List<UnloadModelNodeResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
    }

    public void writeNodesTo(StreamOutput out, List<UnloadModelNodeResponse> nodes) throws IOException {
        out.writeList(nodes);
    }

    public List<UnloadModelNodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(UnloadModelNodeResponse::readStats);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (UnloadModelNodeResponse unloadStats : this.getNodes()) {
            if (unloadStats.isEmpty()) continue;
            DiscoveryNode node = unloadStats.getNode();
            String nodeId = node.getId();
            builder.startObject(nodeId);
            unloadStats.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }
}

