/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.transport;

import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;

public class MLPredictActionRequest
extends ActionRequest {
    private final String modelId;
    private final List<String> inputSentencesList;

    public MLPredictActionRequest(StreamInput in) throws IOException {
        super(in);
        this.modelId = in.readString();
        this.inputSentencesList = in.readStringList();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.modelId);
        out.writeStringCollection(this.inputSentencesList);
    }

    public ActionRequestValidationException validate() {
        if (!Strings.hasText((String)this.modelId)) {
            return ValidateActions.addValidationError((String)"Model id cannot be empty ", null);
        }
        if (this.inputSentencesList.size() == 0) {
            return ValidateActions.addValidationError((String)"Input Sentences List cannot be empty ", null);
        }
        return null;
    }

    @Generated
    public MLPredictActionRequest(String modelId, List<String> inputSentencesList) {
        this.modelId = modelId;
        this.inputSentencesList = inputSentencesList;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLPredictActionRequest)) {
            return false;
        }
        MLPredictActionRequest other = (MLPredictActionRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$modelId = this.getModelId();
        String other$modelId = other.getModelId();
        if (this$modelId == null ? other$modelId != null : !this$modelId.equals(other$modelId)) {
            return false;
        }
        List<String> this$inputSentencesList = this.getInputSentencesList();
        List<String> other$inputSentencesList = other.getInputSentencesList();
        return !(this$inputSentencesList == null ? other$inputSentencesList != null : !((Object)this$inputSentencesList).equals(other$inputSentencesList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLPredictActionRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $modelId = this.getModelId();
        result = result * 59 + ($modelId == null ? 43 : $modelId.hashCode());
        List<String> $inputSentencesList = this.getInputSentencesList();
        result = result * 59 + ($inputSentencesList == null ? 43 : ((Object)$inputSentencesList).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MLPredictActionRequest(modelId=" + this.getModelId() + ", inputSentencesList=" + this.getInputSentencesList() + ")";
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public List<String> getInputSentencesList() {
        return this.inputSentencesList;
    }
}

