/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.observability.action;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.commons.authuser.User;
import org.opensearch.observability.action.CreateObservabilityObjectRequest;
import org.opensearch.observability.action.CreateObservabilityObjectResponse;
import org.opensearch.observability.action.DeleteObservabilityObjectRequest;
import org.opensearch.observability.action.DeleteObservabilityObjectResponse;
import org.opensearch.observability.action.GetObservabilityObjectRequest;
import org.opensearch.observability.action.GetObservabilityObjectResponse;
import org.opensearch.observability.action.UpdateObservabilityObjectRequest;
import org.opensearch.observability.action.UpdateObservabilityObjectResponse;
import org.opensearch.observability.index.ObservabilityIndex;
import org.opensearch.observability.model.ObservabilityObjectDoc;
import org.opensearch.observability.model.ObservabilityObjectDocInfo;
import org.opensearch.observability.model.ObservabilityObjectSearchResult;
import org.opensearch.observability.security.UserAccessManager;
import org.opensearch.observability.util.HelpersKt;
import org.opensearch.rest.RestStatus;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J \u0010\u000f\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00152\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u00182\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u001a\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u00182\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u001a\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J \u0010\u001a\u001a\u00020\u00172\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u001d2\b\u0010\r\u001a\u0004\u0018\u00010\u000eR\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lorg/opensearch/observability/action/ObservabilityActions;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "create", "Lorg/opensearch/observability/action/CreateObservabilityObjectResponse;", "request", "Lorg/opensearch/observability/action/CreateObservabilityObjectRequest;", "user", "Lorg/opensearch/commons/authuser/User;", "delete", "Lorg/opensearch/observability/action/DeleteObservabilityObjectResponse;", "objectId", "", "objectIds", "", "Lorg/opensearch/observability/action/DeleteObservabilityObjectRequest;", "get", "Lorg/opensearch/observability/action/GetObservabilityObjectResponse;", "Lorg/opensearch/observability/action/GetObservabilityObjectRequest;", "getAll", "info", "update", "Lorg/opensearch/observability/action/UpdateObservabilityObjectResponse;", "Lorg/opensearch/observability/action/UpdateObservabilityObjectRequest;", "opensearch-observability"})
public final class ObservabilityActions {
    @NotNull
    public static final ObservabilityActions INSTANCE = new ObservabilityActions();
    @NotNull
    private static final Lazy log$delegate = HelpersKt.logger(ObservabilityActions.class);

    private ObservabilityActions() {
    }

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public final CreateObservabilityObjectResponse create(@NotNull CreateObservabilityObjectRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.getLog().info("observability:ObservabilityObject-create");
        UserAccessManager.INSTANCE.validateUser(user);
        Instant currentTime = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)currentTime, (String)"currentTime");
        ObservabilityObjectDoc objectDoc = new ObservabilityObjectDoc("ignore", currentTime, currentTime, UserAccessManager.INSTANCE.getUserTenant(user), UserAccessManager.INSTANCE.getAllAccessInfo(user), request.getType(), request.getObjectData());
        String docId = ObservabilityIndex.INSTANCE.createObservabilityObject(objectDoc, request.getObjectId());
        if (docId == null) {
            throw new OpenSearchStatusException("ObservabilityObject Creation failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        return new CreateObservabilityObjectResponse(docId);
    }

    @NotNull
    public final UpdateObservabilityObjectResponse update(@NotNull UpdateObservabilityObjectRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.getLog().info("observability:ObservabilityObject-update " + request.getObjectId());
        UserAccessManager.INSTANCE.validateUser(user);
        ObservabilityObjectDocInfo observabilityObject = ObservabilityIndex.INSTANCE.getObservabilityObject(request.getObjectId());
        if (observabilityObject == null) {
            throw new OpenSearchStatusException("ObservabilityObject " + request.getObjectId() + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        ObservabilityObjectDoc currentDoc = observabilityObject.getObservabilityObjectDoc();
        if (!UserAccessManager.INSTANCE.doesUserHasAccess(user, currentDoc.getTenant(), currentDoc.getAccess())) {
            throw new OpenSearchStatusException("Permission denied for ObservabilityObject " + request.getObjectId(), RestStatus.FORBIDDEN, new Object[0]);
        }
        if (currentDoc.getType() != request.getType()) {
            throw new OpenSearchStatusException("Object type cannot be changed after creation", RestStatus.CONFLICT, new Object[0]);
        }
        Instant currentTime = Instant.now();
        String string = request.getObjectId();
        Intrinsics.checkNotNullExpressionValue((Object)currentTime, (String)"currentTime");
        ObservabilityObjectDoc objectDoc = new ObservabilityObjectDoc(string, currentTime, currentDoc.getCreatedTime(), UserAccessManager.INSTANCE.getUserTenant(user), UserAccessManager.INSTANCE.getAllAccessInfo(user), request.getType(), request.getObjectData());
        if (!ObservabilityIndex.INSTANCE.updateObservabilityObject(request.getObjectId(), objectDoc)) {
            throw new OpenSearchStatusException("ObservabilityObject Update failed", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        return new UpdateObservabilityObjectResponse(request.getObjectId());
    }

    @NotNull
    public final GetObservabilityObjectResponse get(@NotNull GetObservabilityObjectRequest request, @Nullable User user) {
        GetObservabilityObjectResponse getObservabilityObjectResponse;
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.getLog().info("observability:ObservabilityObject-get " + request.getObjectIds());
        UserAccessManager.INSTANCE.validateUser(user);
        switch (request.getObjectIds().size()) {
            case 0: {
                getObservabilityObjectResponse = this.getAll(request, user);
                break;
            }
            case 1: {
                getObservabilityObjectResponse = this.info((String)CollectionsKt.first((Iterable)request.getObjectIds()), user);
                break;
            }
            default: {
                getObservabilityObjectResponse = this.info(request.getObjectIds(), user);
            }
        }
        return getObservabilityObjectResponse;
    }

    private final GetObservabilityObjectResponse info(String objectId, User user) {
        this.getLog().info("observability:ObservabilityObject-info " + objectId);
        ObservabilityObjectDocInfo observabilityObjectDocInfo = ObservabilityIndex.INSTANCE.getObservabilityObject(objectId);
        if (observabilityObjectDocInfo == null) {
            ObservabilityActions $this$info_u24lambda_u2d0 = this;
            boolean bl = false;
            throw new OpenSearchStatusException("ObservabilityObject " + objectId + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        ObservabilityObjectDoc currentDoc = observabilityObjectDocInfo.getObservabilityObjectDoc();
        if (!UserAccessManager.INSTANCE.doesUserHasAccess(user, currentDoc.getTenant(), currentDoc.getAccess())) {
            throw new OpenSearchStatusException("Permission denied for ObservabilityObject " + objectId, RestStatus.FORBIDDEN, new Object[0]);
        }
        ObservabilityObjectDoc docInfo = new ObservabilityObjectDoc(objectId, currentDoc.getUpdatedTime(), currentDoc.getCreatedTime(), currentDoc.getTenant(), currentDoc.getAccess(), currentDoc.getType(), currentDoc.getObjectData());
        return new GetObservabilityObjectResponse(new ObservabilityObjectSearchResult(docInfo), UserAccessManager.INSTANCE.hasAllInfoAccess(user));
    }

    /*
     * WARNING - void declaration
     */
    private final GetObservabilityObjectResponse info(Set<String> objectIds, User user) {
        void $this$mapTo$iv$iv;
        Object element$iv3;
        this.getLog().info("observability:ObservabilityObject-info " + objectIds);
        List<ObservabilityObjectDocInfo> objectDocs = ObservabilityIndex.INSTANCE.getObservabilityObjects(objectIds);
        if (objectDocs.size() != objectIds.size()) {
            Set mutableSet = CollectionsKt.toMutableSet((Iterable)objectIds);
            Iterable $this$forEach$iv = objectDocs;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                ObservabilityObjectDocInfo it = (ObservabilityObjectDocInfo)element$iv2;
                boolean bl = false;
                ((Collection)mutableSet).remove(it.getId());
            }
            throw new OpenSearchStatusException("ObservabilityObject " + mutableSet + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        Iterable $this$forEach$iv = objectDocs;
        boolean $i$f$forEach = false;
        for (Object element$iv3 : $this$forEach$iv) {
            ObservabilityObjectDocInfo it = (ObservabilityObjectDocInfo)element$iv3;
            boolean bl = false;
            ObservabilityObjectDoc currentDoc = it.getObservabilityObjectDoc();
            if (UserAccessManager.INSTANCE.doesUserHasAccess(user, currentDoc.getTenant(), currentDoc.getAccess())) continue;
            throw new OpenSearchStatusException("Permission denied for ObservabilityObject " + it.getId(), RestStatus.FORBIDDEN, new Object[0]);
        }
        Iterable $this$map$iv = objectDocs;
        boolean $i$f$map = false;
        element$iv3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ObservabilityObjectDocInfo observabilityObjectDocInfo = (ObservabilityObjectDocInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getId();
            Intrinsics.checkNotNull((Object)string);
            collection.add(new ObservabilityObjectDoc(string, it.getObservabilityObjectDoc().getUpdatedTime(), it.getObservabilityObjectDoc().getCreatedTime(), it.getObservabilityObjectDoc().getTenant(), it.getObservabilityObjectDoc().getAccess(), it.getObservabilityObjectDoc().getType(), it.getObservabilityObjectDoc().getObjectData()));
        }
        List configSearchResult = (List)destination$iv$iv;
        return new GetObservabilityObjectResponse(new ObservabilityObjectSearchResult(configSearchResult), UserAccessManager.INSTANCE.hasAllInfoAccess(user));
    }

    private final GetObservabilityObjectResponse getAll(GetObservabilityObjectRequest request, User user) {
        this.getLog().info("observability:ObservabilityObject-getAll");
        ObservabilityObjectSearchResult searchResult = ObservabilityIndex.INSTANCE.getAllObservabilityObjects(UserAccessManager.INSTANCE.getUserTenant(user), UserAccessManager.INSTANCE.getSearchAccessInfo(user), request);
        return new GetObservabilityObjectResponse(searchResult, UserAccessManager.INSTANCE.hasAllInfoAccess(user));
    }

    @NotNull
    public final DeleteObservabilityObjectResponse delete(@NotNull DeleteObservabilityObjectRequest request, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        this.getLog().info("observability:ObservabilityObject-delete " + request.getObjectIds());
        return request.getObjectIds().size() == 1 ? this.delete((String)CollectionsKt.first((Iterable)request.getObjectIds()), user) : this.delete(request.getObjectIds(), user);
    }

    private final DeleteObservabilityObjectResponse delete(String objectId, User user) {
        this.getLog().info("observability:ObservabilityObject-delete " + objectId);
        UserAccessManager.INSTANCE.validateUser(user);
        ObservabilityObjectDocInfo observabilityObjectDocInfo = ObservabilityIndex.INSTANCE.getObservabilityObject(objectId);
        if (observabilityObjectDocInfo == null) {
            ObservabilityActions $this$delete_u24lambda_u2d4 = this;
            boolean bl = false;
            throw new OpenSearchStatusException("ObservabilityObject " + objectId + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        ObservabilityObjectDoc currentDoc = observabilityObjectDocInfo.getObservabilityObjectDoc();
        if (!UserAccessManager.INSTANCE.doesUserHasAccess(user, currentDoc.getTenant(), currentDoc.getAccess())) {
            throw new OpenSearchStatusException("Permission denied for ObservabilityObject " + objectId, RestStatus.FORBIDDEN, new Object[0]);
        }
        if (!ObservabilityIndex.INSTANCE.deleteObservabilityObject(objectId)) {
            throw new OpenSearchStatusException("ObservabilityObject " + objectId + " delete failed", RestStatus.REQUEST_TIMEOUT, new Object[0]);
        }
        return new DeleteObservabilityObjectResponse(MapsKt.mapOf((Pair)new Pair((Object)objectId, (Object)RestStatus.OK)));
    }

    private final DeleteObservabilityObjectResponse delete(Set<String> objectIds, User user) {
        this.getLog().info("observability:ObservabilityObject-delete " + objectIds);
        UserAccessManager.INSTANCE.validateUser(user);
        List<ObservabilityObjectDocInfo> configDocs = ObservabilityIndex.INSTANCE.getObservabilityObjects(objectIds);
        if (configDocs.size() != objectIds.size()) {
            Set mutableSet = CollectionsKt.toMutableSet((Iterable)objectIds);
            Iterable $this$forEach$iv = configDocs;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ObservabilityObjectDocInfo it = (ObservabilityObjectDocInfo)element$iv;
                boolean bl = false;
                ((Collection)mutableSet).remove(it.getId());
            }
            throw new OpenSearchStatusException("ObservabilityObject " + mutableSet + " not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        Iterable $this$forEach$iv = configDocs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ObservabilityObjectDocInfo it = (ObservabilityObjectDocInfo)element$iv;
            boolean bl = false;
            ObservabilityObjectDoc currentDoc = it.getObservabilityObjectDoc();
            if (UserAccessManager.INSTANCE.doesUserHasAccess(user, currentDoc.getTenant(), currentDoc.getAccess())) continue;
            throw new OpenSearchStatusException("Permission denied for ObservabilityObject " + it.getId(), RestStatus.FORBIDDEN, new Object[0]);
        }
        Map<String, RestStatus> deleteStatus = ObservabilityIndex.INSTANCE.deleteObservabilityObjects(objectIds);
        return new DeleteObservabilityObjectResponse(deleteStatus);
    }
}

