# A simple message for testing interoperability.
# More tests are in the interop directory.

import some_message_pb2  # generated by: protoc some_message.proto --python_out=.

msg = some_message_pb2.SomeMessage()
msg.first = 100
msg.second = "abcd"
msg.third.extend(["foo", "bar"])
msg.fourth = True
msg.fifth.value = -666
msg.fifth.text = "negative 666"
msg.sixth.extend([msg.NestedMessage(value=1234, text="onetwothreefour"),
                  msg.NestedMessage(value=2222, text="four twos")])
msg.seventh.extend([1,2,3,4])
msg.eighth.extend([100,-200,1000])

print(msg)
print([i for i in msg.SerializeToString()])
with open("some_message.wire", "wb") as wire:
    wire.write(msg.SerializeToString())

msg2 = some_message_pb2.SomeMessage(
    first = 100,
    second = "abcd",
    third = ["foo", "bar"],
    fourth = True,
    fifth = some_message_pb2.SomeMessage.NestedMessage(value=-666, text = "negative 666"),
    sixth = [some_message_pb2.SomeMessage.NestedMessage(value=1234, text="onetwothreefour"),
             some_message_pb2.SomeMessage.NestedMessage(value=2222, text="four twos")],
    seventh = [1,2,3,4],
    eighth = [100,-200,1000],
    )

print('=========')
print(msg2)

assert msg.SerializeToString() == msg2.SerializeToString()
