/* interaction.c generated by valac 0.56.3, the Vala compiler
 * generated from interaction.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2008 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2017 Niels De Graef
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, see
 * <http://www.gnu.org/licenses/>.
 */
/* FIXME: there are no bindings generated for these functions*/

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "seahorse-common.h"
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>

enum  {
	SEAHORSE_INTERACTION_0_PROPERTY,
	SEAHORSE_INTERACTION_PARENT_PROPERTY,
	SEAHORSE_INTERACTION_NUM_PROPERTIES
};
static GParamSpec* seahorse_interaction_properties[SEAHORSE_INTERACTION_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _SeahorseInteractionPrivate {
	GtkWindow* _parent;
};

static gint SeahorseInteraction_private_offset;
static gpointer seahorse_interaction_parent_class = NULL;

gchar* gcr_secure_memory_strdup (const gchar* str);
void gcr_secure_memory_free (void* str);
static GTlsInteractionResult seahorse_interaction_real_ask_password (GTlsInteraction* base,
                                                              GTlsPassword* password,
                                                              GCancellable* cancellable,
                                                              GError** error);
static gchar* seahorse_interaction_calc_description (SeahorseInteraction* self,
                                              GTlsPassword* password);
static void _gcr_secure_memory_free_gdestroy_notify (void* data);
static void seahorse_interaction_finalize (GObject * obj);
static GType seahorse_interaction_get_type_once (void);
static void _vala_seahorse_interaction_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_seahorse_interaction_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
seahorse_interaction_get_instance_private (SeahorseInteraction* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorseInteraction_private_offset);
}

SeahorseInteraction*
seahorse_interaction_construct (GType object_type,
                                GtkWindow* parent)
{
	SeahorseInteraction * self = NULL;
	self = (SeahorseInteraction*) g_object_new (object_type, NULL);
	seahorse_interaction_set_parent (self, parent);
	return self;
}

SeahorseInteraction*
seahorse_interaction_new (GtkWindow* parent)
{
	return seahorse_interaction_construct (SEAHORSE_TYPE_INTERACTION, parent);
}

static void
_gcr_secure_memory_free_gdestroy_notify (void* data)
{
	gcr_secure_memory_free (data);
}

static GTlsInteractionResult
seahorse_interaction_real_ask_password (GTlsInteraction* base,
                                        GTlsPassword* password,
                                        GCancellable* cancellable,
                                        GError** error)
{
	SeahorseInteraction * self;
	gchar* description = NULL;
	gchar* _tmp0_;
	SeahorsePassphrasePrompt* dialog = NULL;
	const gchar* _tmp1_;
	SeahorsePassphrasePrompt* _tmp2_;
	GtkWindow* _tmp3_;
	gint response = 0;
	SeahorsePassphrasePrompt* _tmp6_;
	SeahorsePassphrasePrompt* _tmp11_;
	GError* _inner_error0_ = NULL;
	GTlsInteractionResult result;
	self = (SeahorseInteraction*) base;
	g_return_val_if_fail (password != NULL, 0);
	_tmp0_ = seahorse_interaction_calc_description (self, password);
	description = _tmp0_;
	_tmp1_ = description;
	_tmp2_ = seahorse_passphrase_prompt_show_dialog (NULL, _tmp1_, NULL, NULL, FALSE);
	dialog = _tmp2_;
	_tmp3_ = self->priv->_parent;
	if (_tmp3_ != NULL) {
		SeahorsePassphrasePrompt* _tmp4_;
		GtkWindow* _tmp5_;
		_tmp4_ = dialog;
		_tmp5_ = self->priv->_parent;
		gtk_window_set_transient_for ((GtkWindow*) _tmp4_, _tmp5_);
	}
	_tmp6_ = dialog;
	response = gtk_dialog_run ((GtkDialog*) _tmp6_);
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
		SeahorsePassphrasePrompt* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp7_ = dialog;
		_tmp8_ = seahorse_passphrase_prompt_get_text (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = gcr_secure_memory_strdup (_tmp9_);
		g_tls_password_set_value_full (password, (guint8*) _tmp10_, (gssize) -1, _gcr_secure_memory_free_gdestroy_notify);
		_g_free0 (_tmp9_);
	}
	_tmp11_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp11_);
	if (response != ((gint) GTK_RESPONSE_ACCEPT)) {
		GError* _tmp12_;
		_tmp12_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "The password request was cancelled by the user");
		_inner_error0_ = _tmp12_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dialog);
		_g_free0 (description);
		return 0;
	}
	result = G_TLS_INTERACTION_HANDLED;
	_g_object_unref0 (dialog);
	_g_free0 (description);
	return result;
}

static gchar*
seahorse_interaction_calc_description (SeahorseInteraction* self,
                                       GTlsPassword* password)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (password != NULL, NULL);
	_tmp0_ = g_tls_password_get_description (password);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf (_ ("Enter PIN or password for: %s"), _tmp1_);
	result = _tmp2_;
	return result;
}

GtkWindow*
seahorse_interaction_get_parent (SeahorseInteraction* self)
{
	GtkWindow* result;
	GtkWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parent;
	result = _tmp0_;
	return result;
}

void
seahorse_interaction_set_parent (SeahorseInteraction* self,
                                 GtkWindow* value)
{
	GtkWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = seahorse_interaction_get_parent (self);
	if (old_value != value) {
		self->priv->_parent = value;
		g_object_notify_by_pspec ((GObject *) self, seahorse_interaction_properties[SEAHORSE_INTERACTION_PARENT_PROPERTY]);
	}
}

static void
seahorse_interaction_class_init (SeahorseInteractionClass * klass,
                                 gpointer klass_data)
{
	seahorse_interaction_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorseInteraction_private_offset);
	((GTlsInteractionClass *) klass)->ask_password = (GTlsInteractionResult (*) (GTlsInteraction*, GTlsPassword*, GCancellable*, GError**)) seahorse_interaction_real_ask_password;
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_interaction_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_interaction_set_property;
	G_OBJECT_CLASS (klass)->finalize = seahorse_interaction_finalize;
	/**
	     * The parent window
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_INTERACTION_PARENT_PROPERTY, seahorse_interaction_properties[SEAHORSE_INTERACTION_PARENT_PROPERTY] = g_param_spec_object ("parent", "parent", "parent", gtk_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
seahorse_interaction_instance_init (SeahorseInteraction * self,
                                    gpointer klass)
{
	self->priv = seahorse_interaction_get_instance_private (self);
}

static void
seahorse_interaction_finalize (GObject * obj)
{
	SeahorseInteraction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_TYPE_INTERACTION, SeahorseInteraction);
	G_OBJECT_CLASS (seahorse_interaction_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_interaction_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorseInteractionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_interaction_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorseInteraction), 0, (GInstanceInitFunc) seahorse_interaction_instance_init, NULL };
	GType seahorse_interaction_type_id;
	seahorse_interaction_type_id = g_type_register_static (g_tls_interaction_get_type (), "SeahorseInteraction", &g_define_type_info, 0);
	SeahorseInteraction_private_offset = g_type_add_instance_private (seahorse_interaction_type_id, sizeof (SeahorseInteractionPrivate));
	return seahorse_interaction_type_id;
}

GType
seahorse_interaction_get_type (void)
{
	static volatile gsize seahorse_interaction_type_id__once = 0;
	if (g_once_init_enter (&seahorse_interaction_type_id__once)) {
		GType seahorse_interaction_type_id;
		seahorse_interaction_type_id = seahorse_interaction_get_type_once ();
		g_once_init_leave (&seahorse_interaction_type_id__once, seahorse_interaction_type_id);
	}
	return seahorse_interaction_type_id__once;
}

static void
_vala_seahorse_interaction_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	SeahorseInteraction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_INTERACTION, SeahorseInteraction);
	switch (property_id) {
		case SEAHORSE_INTERACTION_PARENT_PROPERTY:
		g_value_set_object (value, seahorse_interaction_get_parent (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_interaction_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	SeahorseInteraction * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_TYPE_INTERACTION, SeahorseInteraction);
	switch (property_id) {
		case SEAHORSE_INTERACTION_PARENT_PROPERTY:
		seahorse_interaction_set_parent (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

