"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getBackgroundAnalysisMaxFiles = exports.getHighlightParsingError = exports.getGlobPattern = exports.getExplainshellEndpoint = exports.getShellcheckPath = exports.DEFAULT_BACKGROUND_ANALYSIS_MAX_FILES = exports.DEFAULT_GLOB_PATTERN = void 0;
exports.DEFAULT_GLOB_PATTERN = '**/*@(.sh|.inc|.bash|.command)';
exports.DEFAULT_BACKGROUND_ANALYSIS_MAX_FILES = 500;
function getShellcheckPath() {
    const { SHELLCHECK_PATH } = process.env;
    // If this is an empty string, this should coalesce to null and disable linting via shellcheck:
    return typeof SHELLCHECK_PATH === 'string' ? SHELLCHECK_PATH || null : 'shellcheck';
}
exports.getShellcheckPath = getShellcheckPath;
function getExplainshellEndpoint() {
    const { EXPLAINSHELL_ENDPOINT } = process.env;
    return typeof EXPLAINSHELL_ENDPOINT === 'string' && EXPLAINSHELL_ENDPOINT.trim() !== ''
        ? EXPLAINSHELL_ENDPOINT
        : null;
}
exports.getExplainshellEndpoint = getExplainshellEndpoint;
/**
 * Get the glob pattern for files to run background analysis on.
 */
function getGlobPattern() {
    const { GLOB_PATTERN } = process.env;
    return typeof GLOB_PATTERN === 'string' && GLOB_PATTERN.trim() !== ''
        ? GLOB_PATTERN
        : exports.DEFAULT_GLOB_PATTERN;
}
exports.getGlobPattern = getGlobPattern;
function getHighlightParsingError() {
    const { HIGHLIGHT_PARSING_ERRORS } = process.env;
    return typeof HIGHLIGHT_PARSING_ERRORS !== 'undefined'
        ? toBoolean(HIGHLIGHT_PARSING_ERRORS)
        : false;
}
exports.getHighlightParsingError = getHighlightParsingError;
/**
 * Get the maximum number of files to run background analysis on.
 */
function getBackgroundAnalysisMaxFiles() {
    const { BACKGROUND_ANALYSIS_MAX_FILES } = process.env;
    const parsed = parseInt(BACKGROUND_ANALYSIS_MAX_FILES || '', 10);
    return !isNaN(parsed) ? parsed : exports.DEFAULT_BACKGROUND_ANALYSIS_MAX_FILES;
}
exports.getBackgroundAnalysisMaxFiles = getBackgroundAnalysisMaxFiles;
const toBoolean = (s) => s === 'true' || s === '1';
//# sourceMappingURL=config.js.map