/* calendar.c generated by valac 0.56.3, the Vala compiler
 * generated from calendar.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "raven.h"
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib-object.h>

#define ENABLE_WEEK_NUM "enable-week-numbers"
#define CALENDAR_WIDGET_date_format "%e %b %Y"

enum  {
	CALENDAR_WIDGET_0_PROPERTY,
	CALENDAR_WIDGET_NUM_PROPERTIES
};
static GParamSpec* calendar_widget_properties[CALENDAR_WIDGET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _CalendarWidgetPrivate {
	BudgieHeaderWidget* header;
	GtkCalendar* cal;
	GSettings* settings;
};

static gint CalendarWidget_private_offset;
static gpointer calendar_widget_parent_class = NULL;

static gboolean calendar_widget_update_date (CalendarWidget* self);
static gboolean _calendar_widget_update_date_gsource_func (gpointer self);
static void __lambda8_ (CalendarWidget* self);
static void ___lambda8__gtk_calendar_month_changed (GtkCalendar* _sender,
                                             gpointer self);
static void __lambda9_ (CalendarWidget* self,
                 const gchar* key);
static void calendar_widget_set_week_number (CalendarWidget* self);
static void ___lambda9__g_settings_changed (GSettings* _sender,
                                     const gchar* key,
                                     gpointer self);
static void calendar_widget_finalize (GObject * obj);
static GType calendar_widget_get_type_once (void);

static inline gpointer
calendar_widget_get_instance_private (CalendarWidget* self)
{
	return G_STRUCT_MEMBER_P (self, CalendarWidget_private_offset);
}

static gboolean
_calendar_widget_update_date_gsource_func (gpointer self)
{
	gboolean result;
	result = calendar_widget_update_date ((CalendarWidget*) self);
	return result;
}

static void
__lambda8_ (CalendarWidget* self)
{
	calendar_widget_update_date (self);
}

static void
___lambda8__gtk_calendar_month_changed (GtkCalendar* _sender,
                                        gpointer self)
{
	__lambda8_ ((CalendarWidget*) self);
}

static void
__lambda9_ (CalendarWidget* self,
            const gchar* key)
{
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, ENABLE_WEEK_NUM) == 0) {
		calendar_widget_set_week_number (self);
	} else {
		return;
	}
}

static void
___lambda9__g_settings_changed (GSettings* _sender,
                                const gchar* key,
                                gpointer self)
{
	__lambda9_ ((CalendarWidget*) self, key);
}

CalendarWidget*
calendar_widget_construct (GType object_type,
                           GSettings* c_settings)
{
	CalendarWidget * self = NULL;
	GDateTime* time = NULL;
	GDateTime* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	BudgieHeaderWidget* _tmp3_;
	BudgieRavenExpander* expander = NULL;
	BudgieHeaderWidget* _tmp4_;
	BudgieRavenExpander* _tmp5_;
	GtkCalendar* _tmp6_;
	GtkCalendar* _tmp7_;
	GtkStyleContext* _tmp8_;
	GtkEventBox* ebox = NULL;
	GtkEventBox* _tmp9_;
	GtkStyleContext* _tmp10_;
	GtkCalendar* _tmp11_;
	GtkCalendar* _tmp12_;
	GSettings* _tmp13_;
	g_return_val_if_fail (c_settings != NULL, NULL);
	self = (CalendarWidget*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, NULL);
	self->priv->settings = c_settings;
	_tmp0_ = g_date_time_new_now_local ();
	time = _tmp0_;
	_tmp1_ = g_date_time_format (time, CALENDAR_WIDGET_date_format);
	_tmp2_ = _tmp1_;
	_tmp3_ = budgie_header_widget_new (_tmp2_, "x-office-calendar-symbolic", FALSE, NULL, NULL);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->header);
	self->priv->header = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp4_ = self->priv->header;
	_tmp5_ = budgie_raven_expander_new (_tmp4_);
	g_object_ref_sink (_tmp5_);
	expander = _tmp5_;
	budgie_raven_expander_set_expanded (expander, TRUE);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) expander, FALSE, FALSE, (guint) 0);
	_tmp6_ = (GtkCalendar*) gtk_calendar_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->cal);
	self->priv->cal = _tmp6_;
	_tmp7_ = self->priv->cal;
	_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
	gtk_style_context_add_class (_tmp8_, "raven-calendar");
	_tmp9_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp9_);
	ebox = _tmp9_;
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) ebox);
	gtk_style_context_add_class (_tmp10_, "raven-background");
	_tmp11_ = self->priv->cal;
	gtk_container_add ((GtkContainer*) ebox, (GtkWidget*) _tmp11_);
	gtk_container_add ((GtkContainer*) expander, (GtkWidget*) ebox);
	g_timeout_add_seconds_full (G_PRIORITY_LOW, (guint) 30, _calendar_widget_update_date_gsource_func, g_object_ref (self), g_object_unref);
	_tmp12_ = self->priv->cal;
	g_signal_connect_object (_tmp12_, "month-changed", (GCallback) ___lambda8__gtk_calendar_month_changed, self, 0);
	_tmp13_ = self->priv->settings;
	g_signal_connect_object (_tmp13_, "changed", (GCallback) ___lambda9__g_settings_changed, self, 0);
	calendar_widget_set_week_number (self);
	_g_object_unref0 (ebox);
	_g_object_unref0 (expander);
	_g_date_time_unref0 (time);
	return self;
}

CalendarWidget*
calendar_widget_new (GSettings* c_settings)
{
	return calendar_widget_construct (TYPE_CALENDAR_WIDGET, c_settings);
}

/**
 * set_week_number will set the display of the week number
 */
static void
calendar_widget_set_week_number (CalendarWidget* self)
{
	gboolean show = FALSE;
	GSettings* _tmp0_;
	GtkCalendar* _tmp2_;
	g_return_if_fail (self != NULL);
	show = FALSE;
	_tmp0_ = self->priv->settings;
	if (_tmp0_ != NULL) {
		GSettings* _tmp1_;
		_tmp1_ = self->priv->settings;
		show = g_settings_get_boolean (_tmp1_, ENABLE_WEEK_NUM);
	}
	_tmp2_ = self->priv->cal;
	g_object_set (_tmp2_, "show-week-numbers", show, NULL);
}

static gboolean
calendar_widget_update_date (CalendarWidget* self)
{
	GDateTime* time = NULL;
	GDateTime* _tmp0_;
	gchar* strf = NULL;
	GDateTime* _tmp1_;
	gchar* _tmp2_;
	BudgieHeaderWidget* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	GtkCalendar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GDateTime* _tmp10_;
	GtkCalendar* _tmp16_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_date_time_new_now_local ();
	time = _tmp0_;
	_tmp1_ = time;
	_tmp2_ = g_date_time_format (_tmp1_, CALENDAR_WIDGET_date_format);
	strf = _tmp2_;
	_tmp3_ = self->priv->header;
	_tmp4_ = strf;
	budgie_header_widget_set_text (_tmp3_, _tmp4_);
	_tmp7_ = self->priv->cal;
	g_object_get (_tmp7_, "month", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = time;
	if ((_tmp9_ + 1) == g_date_time_get_month (_tmp10_)) {
		GtkCalendar* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		GDateTime* _tmp14_;
		_tmp11_ = self->priv->cal;
		g_object_get (_tmp11_, "year", &_tmp12_, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = time;
		_tmp6_ = _tmp13_ == g_date_time_get_year (_tmp14_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GDateTime* _tmp15_;
		_tmp15_ = time;
		_tmp5_ = g_date_time_get_day_of_month (_tmp15_);
	} else {
		_tmp5_ = 0;
	}
	_tmp16_ = self->priv->cal;
	g_object_set (_tmp16_, "day", _tmp5_, NULL);
	result = TRUE;
	_g_free0 (strf);
	_g_date_time_unref0 (time);
	return result;
}

static void
calendar_widget_class_init (CalendarWidgetClass * klass,
                            gpointer klass_data)
{
	calendar_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &CalendarWidget_private_offset);
	G_OBJECT_CLASS (klass)->finalize = calendar_widget_finalize;
}

static void
calendar_widget_instance_init (CalendarWidget * self,
                               gpointer klass)
{
	self->priv = calendar_widget_get_instance_private (self);
	self->priv->header = NULL;
	self->priv->cal = NULL;
	self->priv->settings = NULL;
}

static void
calendar_widget_finalize (GObject * obj)
{
	CalendarWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CALENDAR_WIDGET, CalendarWidget);
	_g_object_unref0 (self->priv->header);
	_g_object_unref0 (self->priv->cal);
	G_OBJECT_CLASS (calendar_widget_parent_class)->finalize (obj);
}

static GType
calendar_widget_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CalendarWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) calendar_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CalendarWidget), 0, (GInstanceInitFunc) calendar_widget_instance_init, NULL };
	GType calendar_widget_type_id;
	calendar_widget_type_id = g_type_register_static (TYPE_RAVEN_WIDGET, "CalendarWidget", &g_define_type_info, 0);
	CalendarWidget_private_offset = g_type_add_instance_private (calendar_widget_type_id, sizeof (CalendarWidgetPrivate));
	return calendar_widget_type_id;
}

GType
calendar_widget_get_type (void)
{
	static volatile gsize calendar_widget_type_id__once = 0;
	if (g_once_init_enter (&calendar_widget_type_id__once)) {
		GType calendar_widget_type_id;
		calendar_widget_type_id = calendar_widget_get_type_once ();
		g_once_init_leave (&calendar_widget_type_id__once, calendar_widget_type_id);
	}
	return calendar_widget_type_id__once;
}

