/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.LiteWeightTestNGMethod;
import org.testng.internal.MethodHelper;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.Systematiser;
import org.testng.internal.Utils;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class FailedReporter
implements IReporter {
    public static final String TESTNG_FAILED_XML = "testng-failed.xml";
    private XmlSuite m_xmlSuite;

    public FailedReporter() {
    }

    public FailedReporter(XmlSuite xmlSuite) {
        this.m_xmlSuite = xmlSuite;
    }

    @Override
    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectory) {
        for (ISuite suite : suites) {
            this.generateFailureSuite(suite.getXmlSuite(), suite, outputDirectory);
        }
    }

    protected void generateFailureSuite(XmlSuite xmlSuite, ISuite suite, String outputDir) {
        XmlSuite failedSuite = xmlSuite.shallowCopy();
        failedSuite.setName("Failed suite [" + xmlSuite.getName() + "]");
        this.m_xmlSuite = failedSuite;
        Map<String, ISuiteResult> results = suite.getResults();
        for (Map.Entry<String, ISuiteResult> entry : results.entrySet()) {
            ISuiteResult suiteResult = entry.getValue();
            ITestContext testContext = suiteResult.getTestContext();
            this.generateXmlTest(testContext.getCurrentXmlTest(), testContext, testContext.getFailedTests().getAllResults(), testContext.getSkippedTests().getAllResults());
        }
        if (null != failedSuite.getTests() && failedSuite.getTests().size() > 0) {
            Utils.writeUtf8File(outputDir, TESTNG_FAILED_XML, failedSuite.toXml());
            Utils.writeUtf8File(suite.getOutputDirectory(), TESTNG_FAILED_XML, failedSuite.toXml());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void generateXmlTest(XmlTest xmlTest, ITestContext context, Set<ITestResult> failedTests, Set<ITestResult> skippedTests) {
        if (skippedTests.size() > 0 || failedTests.size() > 0) {
            Set methodsToReRun = Sets.newHashSet();
            Set<ITestResult> allTests = Sets.newHashSet();
            allTests.addAll(failedTests);
            allTests.addAll(skippedTests);
            ITestNGMethod[] allTestMethods = context.getAllTestMethods();
            for (ITestResult failedTest : allTests) {
                ITestNGMethod current = failedTest.getMethod();
                if (!current.isTest()) continue;
                methodsToReRun.add(current);
                List<ITestNGMethod> methodsDependedUpon = MethodHelper.getMethodsDependedUpon(current, allTestMethods, Systematiser.getComparator());
                for (ITestNGMethod iTestNGMethod : methodsDependedUpon) {
                    if (!iTestNGMethod.isTest()) continue;
                    methodsToReRun.add(iTestNGMethod);
                }
            }
            List<ITestNGMethod> result = Lists.newArrayList();
            Set<ITestNGMethod> relevantConfigs = Sets.newHashSet();
            for (ITestNGMethod iTestNGMethod : allTestMethods) {
                void var13_19;
                if (RuntimeBehavior.isMemoryFriendlyMode()) {
                    LiteWeightTestNGMethod liteWeightTestNGMethod = new LiteWeightTestNGMethod(iTestNGMethod);
                }
                if (!methodsToReRun.contains(var13_19)) continue;
                result.add((ITestNGMethod)var13_19);
                FailedReporter.getAllApplicableConfigs(relevantConfigs, var13_19.getTestClass());
                FailedReporter.getAllGroupApplicableConfigs(context, relevantConfigs, (ITestNGMethod)var13_19);
            }
            Set upstreamConfigFailures = Stream.of(context.getFailedConfigurations().getAllMethods(), context.getSkippedConfigurations().getAllMethods()).flatMap(Collection::stream).filter(FailedReporter::isNotClassLevelConfigurationMethod).collect(Collectors.toSet());
            result.addAll(upstreamConfigFailures);
            result.addAll(relevantConfigs);
            this.createXmlTest(context, result, xmlTest);
        }
    }

    private static boolean isNotClassLevelConfigurationMethod(ITestNGMethod each) {
        return each.isBeforeSuiteConfiguration() || each.isAfterSuiteConfiguration() || each.isBeforeTestConfiguration() || each.isAfterTestConfiguration() || each.isBeforeGroupsConfiguration() || each.isAfterGroupsConfiguration();
    }

    private static void getAllApplicableConfigs(Set<ITestNGMethod> configs, ITestClass iTestClass) {
        configs.addAll(Arrays.asList(iTestClass.getBeforeSuiteMethods()));
        configs.addAll(Arrays.asList(iTestClass.getAfterSuiteMethods()));
        configs.addAll(Arrays.asList(iTestClass.getBeforeTestConfigurationMethods()));
        configs.addAll(Arrays.asList(iTestClass.getAfterTestConfigurationMethods()));
        configs.addAll(Arrays.asList(iTestClass.getBeforeTestMethods()));
        configs.addAll(Arrays.asList(iTestClass.getAfterTestMethods()));
        configs.addAll(Arrays.asList(iTestClass.getBeforeClassMethods()));
        configs.addAll(Arrays.asList(iTestClass.getAfterClassMethods()));
    }

    private static void getAllGroupApplicableConfigs(ITestContext context, Set<ITestNGMethod> relevantConfigs, ITestNGMethod m) {
        context.getPassedConfigurations().getAllMethods().stream().filter(method -> relevantConfigs.stream().map(ITestNGMethod::getConstructorOrMethod).map(ConstructorOrMethod::getMethod).noneMatch(configMethod -> method.getConstructorOrMethod().getMethod().equals(configMethod))).filter(method -> method.getGroups().length > 0).filter(method -> context.getPassedTests().getAllMethods().stream().map(ITestNGMethod::getInstance).noneMatch(i -> i.equals(method.getInstance()))).filter(method -> Arrays.stream(m.getGroups()).anyMatch(group -> Arrays.asList(method.getGroups()).contains(group))).forEach(relevantConfigs::add);
    }

    private void createXmlTest(ITestContext context, List<ITestNGMethod> methods, XmlTest srcXmlTest) {
        XmlTest xmlTest = new XmlTest(this.m_xmlSuite);
        xmlTest.setName(context.getName() + "(failed)");
        xmlTest.setScript(srcXmlTest.getScript());
        xmlTest.setIncludedGroups(srcXmlTest.getIncludedGroups());
        xmlTest.setExcludedGroups(srcXmlTest.getExcludedGroups());
        xmlTest.setParallel(srcXmlTest.getParallel());
        xmlTest.setParameters(srcXmlTest.getLocalParameters());
        xmlTest.setJUnit(srcXmlTest.isJUnit());
        List<XmlClass> xmlClasses = this.createXmlClasses(methods, srcXmlTest);
        xmlTest.setXmlClasses(xmlClasses);
    }

    /*
     * WARNING - void declaration
     */
    private List<XmlClass> createXmlClasses(List<ITestNGMethod> methods, XmlTest srcXmlTest) {
        List<XmlClass> result = Lists.newArrayList();
        Map<Class, Set> methodsMap = Maps.newHashMap();
        for (ITestNGMethod iTestNGMethod : methods) {
            Object instances = iTestNGMethod.getInstance();
            Class<?> clazz = instances == null ? iTestNGMethod.getRealClass() : instances.getClass();
            Set methodList = methodsMap.computeIfAbsent(clazz, k -> Sets.newHashSet());
            methodList.add(iTestNGMethod);
        }
        Map<String, Map<String, String>> classParameters = Maps.newHashMap();
        for (XmlClass c : srcXmlTest.getClasses()) {
            classParameters.put(c.getName(), c.getLocalParameters());
        }
        boolean bl = false;
        for (Map.Entry entry : methodsMap.entrySet()) {
            void var6_9;
            Class clazz = (Class)entry.getKey();
            Set methodList = (Set)entry.getValue();
            XmlClass xmlClass = new XmlClass(clazz.getName(), (int)(++var6_9), false);
            Map<ConstructorOrMethod, List<ITestNGMethod>> group = methodList.stream().collect(Collectors.groupingBy(ITestNGMethod::getConstructorOrMethod));
            List<XmlInclude> groupedByMethodNames = group.values().stream().map(each -> FailedReporter.asXmlIncludes(each, srcXmlTest)).map(each -> {
                if (each.size() > 1) {
                    XmlInclude tmpMethodName = (XmlInclude)each.get(0);
                    each.stream().map(XmlInclude::getInvocationNumbers).reduce((a1, a2) -> {
                        HashSet set = new HashSet(a1);
                        set.addAll(a2);
                        return new ArrayList(set);
                    }).ifPresent(tmpMethodName::addInvocationNumbers);
                    return Collections.singletonList(tmpMethodName);
                }
                return each;
            }).flatMap(Collection::stream).collect(Collectors.toList());
            xmlClass.setIncludedMethods(groupedByMethodNames);
            xmlClass.setParameters(classParameters.getOrDefault(xmlClass.getName(), classParameters.values().stream().flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2))));
            result.add(xmlClass);
        }
        return result;
    }

    private static Map<String, String> findMethodLocalParameters(XmlTest srcXmlTest, ITestNGMethod method) {
        Class clazz = method.getRealClass();
        for (XmlClass c : srcXmlTest.getClasses()) {
            if (clazz != c.getSupportClass()) continue;
            for (XmlInclude xmlInclude : c.getIncludedMethods()) {
                if (!xmlInclude.getName().equals(method.getMethodName())) continue;
                return xmlInclude.getLocalParameters();
            }
        }
        return Collections.emptyMap();
    }

    private static List<XmlInclude> asXmlIncludes(List<ITestNGMethod> methods, XmlTest srcXmlTest) {
        AtomicInteger i = new AtomicInteger(0);
        return methods.stream().map(m -> {
            XmlInclude methodName = new XmlInclude(m.getMethodName(), m.getFailedInvocationNumbers(), i.getAndIncrement());
            methodName.setParameters(FailedReporter.findMethodLocalParameters(srcXmlTest, m));
            return methodName;
        }).collect(Collectors.toList());
    }
}

