/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.prefix;

import java.awt.BorderLayout;
import javax.swing.JToolBar;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.ui.prefix.AddPrefixMappingAction;
import org.protege.editor.owl.ui.prefix.GeneratePrefixFromOntologyAction;
import org.protege.editor.owl.ui.prefix.PrefixMapperTable;
import org.protege.editor.owl.ui.prefix.PrefixMapperTables;
import org.protege.editor.owl.ui.prefix.RemovePrefixMappingAction;
import org.protege.editor.owl.ui.view.AbstractActiveOntologyViewComponent;
import org.semanticweb.owlapi.model.OWLOntology;

public class PrefixMapperView
extends AbstractActiveOntologyViewComponent {
    private static final long serialVersionUID = 787248046135787437L;
    private PrefixMapperTables tables;
    private PrefixMapperTable currentTable;
    private OWLModelManagerListener entitiesChangedListener = new OWLModelManagerListener(){

        @Override
        public void handleChange(OWLModelManagerChangeEvent event) {
            if (event.getType() == EventType.ENTITY_RENDERER_CHANGED) {
                PrefixMapperView.this.tables.refill();
            }
        }
    };

    @Override
    protected void initialiseOntologyView() throws Exception {
        this.setLayout(new BorderLayout());
        this.tables = new PrefixMapperTables(this.getOWLModelManager());
        this.add(this.createButtons(), "North");
        this.add(this.tables, "Center");
        this.updateView(this.getOWLModelManager().getActiveOntology());
        this.getOWLModelManager().addListener(this.entitiesChangedListener);
    }

    private JToolBar createButtons() {
        JToolBar panel = new JToolBar();
        panel.add(new AddPrefixMappingAction(this.tables));
        panel.add(new GeneratePrefixFromOntologyAction(this.getOWLEditorKit(), this.tables));
        panel.add(new RemovePrefixMappingAction(this.tables));
        return panel;
    }

    @Override
    protected void disposeOntologyView() {
        if (this.currentTable != null) {
            this.getOWLModelManager().removeListener(this.entitiesChangedListener);
        }
    }

    @Override
    protected void updateView(OWLOntology activeOntology) throws Exception {
        this.tables.setOntology(activeOntology);
        this.currentTable = this.tables.getPrefixMapperTable();
    }
}

