/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.data.UpdateGPSImgDirection;
import org.fibs.geotag.tasks.UndoableBackgroundTask;
import org.fibs.geotag.util.Util;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class EditDirectionTask
extends UndoableBackgroundTask<ImageInfo> {
    private static final I18n i18n = I18nFactory.getI18n(EditDirectionTask.class);
    private ImageInfo imageInfo;
    private String newDirection;
    private ImageInfo.DATA_SOURCE dataSource;

    public EditDirectionTask(String name, ImageInfo imageInfo, String newDirection, ImageInfo.DATA_SOURCE dataSource) {
        super(null, name);
        this.imageInfo = imageInfo;
        this.newDirection = newDirection;
        this.dataSource = dataSource;
    }

    @Override
    public int getCurrentProgress() {
        return 1;
    }

    @Override
    public int getMaxProgress() {
        return 1;
    }

    @Override
    public int getMinProgress() {
        return 1;
    }

    @Override
    protected String doInBackground() throws Exception {
        if (this.imageInfo != null) {
            if (this.newDirection.length() == 0) {
                new UpdateGPSImgDirection(this.imageInfo, null, this.dataSource);
            } else {
                double direction = Util.degreesFromCardinalDirection(this.newDirection);
                if (Double.isNaN(direction)) {
                    try {
                        direction = Double.parseDouble(this.newDirection);
                        if (direction < 0.0 || direction >= 360.0) {
                            direction = Double.NaN;
                        }
                    }
                    catch (RuntimeException e) {
                        direction = Double.NaN;
                    }
                }
                if (!Double.isNaN(direction)) {
                    new UpdateGPSImgDirection(this.imageInfo, Double.toString(direction), this.dataSource);
                }
            }
            this.publish(this.imageInfo);
        }
        return i18n.tr("Direction edited");
    }
}

