/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "xdp-impl-dbus.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Access
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpDbusImplAccess
 * @title: XdpDbusImplAccess
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Access D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Access.top_of_page">org.freedesktop.impl.portal.Access</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Access ---- */

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_access_method_info_access_dialog_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_access_method_info_access_dialog_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_access_method_info_access_dialog_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_access_method_info_access_dialog_IN_ARG_title =
{
  {
    -1,
    (gchar *) "title",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_access_method_info_access_dialog_IN_ARG_subtitle =
{
  {
    -1,
    (gchar *) "subtitle",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_access_method_info_access_dialog_IN_ARG_body =
{
  {
    -1,
    (gchar *) "body",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_access_method_info_access_dialog_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_access_method_info_access_dialog_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_access_method_info_access_dialog_IN_ARG_handle.parent_struct,
  &_xdp_dbus_impl_access_method_info_access_dialog_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_access_method_info_access_dialog_IN_ARG_parent_window.parent_struct,
  &_xdp_dbus_impl_access_method_info_access_dialog_IN_ARG_title.parent_struct,
  &_xdp_dbus_impl_access_method_info_access_dialog_IN_ARG_subtitle.parent_struct,
  &_xdp_dbus_impl_access_method_info_access_dialog_IN_ARG_body.parent_struct,
  &_xdp_dbus_impl_access_method_info_access_dialog_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_access_method_info_access_dialog_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_access_method_info_access_dialog_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_access_method_info_access_dialog_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_access_method_info_access_dialog_OUT_ARG_response.parent_struct,
  &_xdp_dbus_impl_access_method_info_access_dialog_OUT_ARG_results.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_access_method_info_access_dialog =
{
  {
    -1,
    (gchar *) "AccessDialog",
    (GDBusArgInfo **) &_xdp_dbus_impl_access_method_info_access_dialog_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_access_method_info_access_dialog_OUT_ARG_pointers,
    NULL
  },
  "handle-access-dialog",
  FALSE
};

static const GDBusMethodInfo * const _xdp_dbus_impl_access_method_info_pointers[] =
{
  &_xdp_dbus_impl_access_method_info_access_dialog.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_dbus_impl_access_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Access",
    (GDBusMethodInfo **) &_xdp_dbus_impl_access_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "access",
};


/**
 * xdp_dbus_impl_access_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Access.top_of_page">org.freedesktop.impl.portal.Access</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_dbus_impl_access_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_dbus_impl_access_interface_info.parent_struct;
}

/**
 * xdp_dbus_impl_access_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpDbusImplAccess interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_dbus_impl_access_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XdpDbusImplAccess:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Access.top_of_page">org.freedesktop.impl.portal.Access</link>.
 */

/**
 * XdpDbusImplAccessIface:
 * @parent_iface: The parent interface.
 * @handle_access_dialog: Handler for the #XdpDbusImplAccess::handle-access-dialog signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Access.top_of_page">org.freedesktop.impl.portal.Access</link>.
 */

typedef XdpDbusImplAccessIface XdpDbusImplAccessInterface;
G_DEFINE_INTERFACE (XdpDbusImplAccess, xdp_dbus_impl_access, G_TYPE_OBJECT)

static void
xdp_dbus_impl_access_default_init (XdpDbusImplAccessIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpDbusImplAccess::handle-access-dialog:
   * @object: A #XdpDbusImplAccess.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_title: Argument passed by remote caller.
   * @arg_subtitle: Argument passed by remote caller.
   * @arg_body: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Access.AccessDialog">AccessDialog()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_access_complete_access_dialog() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-access-dialog",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplAccessIface, handle_access_dialog),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    8,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * xdp_dbus_impl_access_call_access_dialog:
 * @proxy: A #XdpDbusImplAccessProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_subtitle: Argument to pass with the method invocation.
 * @arg_body: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Access.AccessDialog">AccessDialog()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_access_call_access_dialog_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_access_call_access_dialog_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_access_call_access_dialog (
    XdpDbusImplAccess *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    const gchar *arg_subtitle,
    const gchar *arg_body,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AccessDialog",
    g_variant_new ("(osssss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_subtitle,
                   arg_body,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_access_call_access_dialog_finish:
 * @proxy: A #XdpDbusImplAccessProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_access_call_access_dialog().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_access_call_access_dialog().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_access_call_access_dialog_finish (
    XdpDbusImplAccess *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_access_call_access_dialog_sync:
 * @proxy: A #XdpDbusImplAccessProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_subtitle: Argument to pass with the method invocation.
 * @arg_body: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Access.AccessDialog">AccessDialog()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_access_call_access_dialog() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_access_call_access_dialog_sync (
    XdpDbusImplAccess *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    const gchar *arg_subtitle,
    const gchar *arg_body,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AccessDialog",
    g_variant_new ("(osssss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_subtitle,
                   arg_body,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_access_complete_access_dialog:
 * @object: A #XdpDbusImplAccess.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Access.AccessDialog">AccessDialog()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_access_complete_access_dialog (
    XdpDbusImplAccess *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplAccessProxy:
 *
 * The #XdpDbusImplAccessProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplAccessProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplAccessProxy.
 */

struct _XdpDbusImplAccessProxyPrivate
{
  GData *qdata;
};

static void xdp_dbus_impl_access_proxy_iface_init (XdpDbusImplAccessIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplAccessProxy, xdp_dbus_impl_access_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpDbusImplAccessProxy)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_ACCESS, xdp_dbus_impl_access_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplAccessProxy, xdp_dbus_impl_access_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_ACCESS, xdp_dbus_impl_access_proxy_iface_init))

#endif
static void
xdp_dbus_impl_access_proxy_finalize (GObject *object)
{
  XdpDbusImplAccessProxy *proxy = XDP_DBUS_IMPL_ACCESS_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_dbus_impl_access_proxy_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_access_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_dbus_impl_access_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_dbus_impl_access_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_dbus_impl_access_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_DBUS_IMPL_TYPE_ACCESS);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_ACCESS);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_dbus_impl_access_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpDbusImplAccessProxy *proxy = XDP_DBUS_IMPL_ACCESS_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_access_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_access_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_dbus_impl_access_proxy_init (XdpDbusImplAccessProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_dbus_impl_access_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_DBUS_IMPL_TYPE_ACCESS_PROXY, XdpDbusImplAccessProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_dbus_impl_access_interface_info ());
}

static void
xdp_dbus_impl_access_proxy_class_init (XdpDbusImplAccessProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_dbus_impl_access_proxy_finalize;
  gobject_class->get_property = xdp_dbus_impl_access_proxy_get_property;
  gobject_class->set_property = xdp_dbus_impl_access_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_dbus_impl_access_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_dbus_impl_access_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplAccessProxyPrivate));
#endif
}

static void
xdp_dbus_impl_access_proxy_iface_init (XdpDbusImplAccessIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_dbus_impl_access_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Access.top_of_page">org.freedesktop.impl.portal.Access</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_access_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_access_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_access_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_ACCESS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Access", NULL);
}

/**
 * xdp_dbus_impl_access_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_access_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_access_proxy_new().
 *
 * Returns: (transfer full) (type XdpDbusImplAccessProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplAccess *
xdp_dbus_impl_access_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_ACCESS (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_access_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Access.top_of_page">org.freedesktop.impl.portal.Access</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_access_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplAccessProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplAccess *
xdp_dbus_impl_access_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_ACCESS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Access", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_ACCESS (ret);
  else
    return NULL;
}


/**
 * xdp_dbus_impl_access_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_dbus_impl_access_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_access_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_access_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_access_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_ACCESS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Access", NULL);
}

/**
 * xdp_dbus_impl_access_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_access_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_access_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpDbusImplAccessProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplAccess *
xdp_dbus_impl_access_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_ACCESS (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_access_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_dbus_impl_access_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_access_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplAccessProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplAccess *
xdp_dbus_impl_access_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_ACCESS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Access", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_ACCESS (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplAccessSkeleton:
 *
 * The #XdpDbusImplAccessSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplAccessSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplAccessSkeleton.
 */

struct _XdpDbusImplAccessSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_dbus_impl_access_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpDbusImplAccessSkeleton *skeleton = XDP_DBUS_IMPL_ACCESS_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_DBUS_IMPL_TYPE_ACCESS);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_ACCESS);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_dbus_impl_access_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplAccessSkeleton *skeleton = XDP_DBUS_IMPL_ACCESS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_access_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_dbus_impl_access_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplAccessSkeleton *skeleton = XDP_DBUS_IMPL_ACCESS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_access_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_dbus_impl_access_skeleton_vtable =
{
  _xdp_dbus_impl_access_skeleton_handle_method_call,
  _xdp_dbus_impl_access_skeleton_handle_get_property,
  _xdp_dbus_impl_access_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_dbus_impl_access_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_dbus_impl_access_interface_info ();
}

static GDBusInterfaceVTable *
xdp_dbus_impl_access_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_dbus_impl_access_skeleton_vtable;
}

static GVariant *
xdp_dbus_impl_access_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDbusImplAccessSkeleton *skeleton = XDP_DBUS_IMPL_ACCESS_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_dbus_impl_access_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_dbus_impl_access_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_dbus_impl_access_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_dbus_impl_access_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Access", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_dbus_impl_access_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void xdp_dbus_impl_access_skeleton_iface_init (XdpDbusImplAccessIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplAccessSkeleton, xdp_dbus_impl_access_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpDbusImplAccessSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_ACCESS, xdp_dbus_impl_access_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplAccessSkeleton, xdp_dbus_impl_access_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_ACCESS, xdp_dbus_impl_access_skeleton_iface_init))

#endif
static void
xdp_dbus_impl_access_skeleton_finalize (GObject *object)
{
  XdpDbusImplAccessSkeleton *skeleton = XDP_DBUS_IMPL_ACCESS_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_dbus_impl_access_skeleton_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_access_skeleton_init (XdpDbusImplAccessSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_dbus_impl_access_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_DBUS_IMPL_TYPE_ACCESS_SKELETON, XdpDbusImplAccessSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_dbus_impl_access_skeleton_class_init (XdpDbusImplAccessSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_dbus_impl_access_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_dbus_impl_access_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_dbus_impl_access_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_dbus_impl_access_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_dbus_impl_access_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplAccessSkeletonPrivate));
#endif
}

static void
xdp_dbus_impl_access_skeleton_iface_init (XdpDbusImplAccessIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_dbus_impl_access_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Access.top_of_page">org.freedesktop.impl.portal.Access</link>.
 *
 * Returns: (transfer full) (type XdpDbusImplAccessSkeleton): The skeleton object.
 */
XdpDbusImplAccess *
xdp_dbus_impl_access_skeleton_new (void)
{
  return XDP_DBUS_IMPL_ACCESS (g_object_new (XDP_DBUS_IMPL_TYPE_ACCESS_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Account
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpDbusImplAccount
 * @title: XdpDbusImplAccount
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Account D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Account.top_of_page">org.freedesktop.impl.portal.Account</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Account ---- */

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_account_method_info_get_user_information_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_account_method_info_get_user_information_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_account_method_info_get_user_information_IN_ARG_window =
{
  {
    -1,
    (gchar *) "window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_account_method_info_get_user_information_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_account_method_info_get_user_information_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_account_method_info_get_user_information_IN_ARG_handle.parent_struct,
  &_xdp_dbus_impl_account_method_info_get_user_information_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_account_method_info_get_user_information_IN_ARG_window.parent_struct,
  &_xdp_dbus_impl_account_method_info_get_user_information_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_account_method_info_get_user_information_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_account_method_info_get_user_information_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_account_method_info_get_user_information_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_account_method_info_get_user_information_OUT_ARG_response.parent_struct,
  &_xdp_dbus_impl_account_method_info_get_user_information_OUT_ARG_results.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_account_method_info_get_user_information =
{
  {
    -1,
    (gchar *) "GetUserInformation",
    (GDBusArgInfo **) &_xdp_dbus_impl_account_method_info_get_user_information_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_account_method_info_get_user_information_OUT_ARG_pointers,
    NULL
  },
  "handle-get-user-information",
  FALSE
};

static const GDBusMethodInfo * const _xdp_dbus_impl_account_method_info_pointers[] =
{
  &_xdp_dbus_impl_account_method_info_get_user_information.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_dbus_impl_account_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Account",
    (GDBusMethodInfo **) &_xdp_dbus_impl_account_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "account",
};


/**
 * xdp_dbus_impl_account_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Account.top_of_page">org.freedesktop.impl.portal.Account</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_dbus_impl_account_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_dbus_impl_account_interface_info.parent_struct;
}

/**
 * xdp_dbus_impl_account_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpDbusImplAccount interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_dbus_impl_account_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XdpDbusImplAccount:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Account.top_of_page">org.freedesktop.impl.portal.Account</link>.
 */

/**
 * XdpDbusImplAccountIface:
 * @parent_iface: The parent interface.
 * @handle_get_user_information: Handler for the #XdpDbusImplAccount::handle-get-user-information signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Account.top_of_page">org.freedesktop.impl.portal.Account</link>.
 */

typedef XdpDbusImplAccountIface XdpDbusImplAccountInterface;
G_DEFINE_INTERFACE (XdpDbusImplAccount, xdp_dbus_impl_account, G_TYPE_OBJECT)

static void
xdp_dbus_impl_account_default_init (XdpDbusImplAccountIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpDbusImplAccount::handle-get-user-information:
   * @object: A #XdpDbusImplAccount.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_window: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Account.GetUserInformation">GetUserInformation()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_account_complete_get_user_information() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-user-information",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplAccountIface, handle_get_user_information),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * xdp_dbus_impl_account_call_get_user_information:
 * @proxy: A #XdpDbusImplAccountProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Account.GetUserInformation">GetUserInformation()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_account_call_get_user_information_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_account_call_get_user_information_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_account_call_get_user_information (
    XdpDbusImplAccount *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_window,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetUserInformation",
    g_variant_new ("(oss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_account_call_get_user_information_finish:
 * @proxy: A #XdpDbusImplAccountProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_account_call_get_user_information().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_account_call_get_user_information().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_account_call_get_user_information_finish (
    XdpDbusImplAccount *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_account_call_get_user_information_sync:
 * @proxy: A #XdpDbusImplAccountProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Account.GetUserInformation">GetUserInformation()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_account_call_get_user_information() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_account_call_get_user_information_sync (
    XdpDbusImplAccount *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_window,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetUserInformation",
    g_variant_new ("(oss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_account_complete_get_user_information:
 * @object: A #XdpDbusImplAccount.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Account.GetUserInformation">GetUserInformation()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_account_complete_get_user_information (
    XdpDbusImplAccount *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplAccountProxy:
 *
 * The #XdpDbusImplAccountProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplAccountProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplAccountProxy.
 */

struct _XdpDbusImplAccountProxyPrivate
{
  GData *qdata;
};

static void xdp_dbus_impl_account_proxy_iface_init (XdpDbusImplAccountIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplAccountProxy, xdp_dbus_impl_account_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpDbusImplAccountProxy)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_ACCOUNT, xdp_dbus_impl_account_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplAccountProxy, xdp_dbus_impl_account_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_ACCOUNT, xdp_dbus_impl_account_proxy_iface_init))

#endif
static void
xdp_dbus_impl_account_proxy_finalize (GObject *object)
{
  XdpDbusImplAccountProxy *proxy = XDP_DBUS_IMPL_ACCOUNT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_dbus_impl_account_proxy_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_account_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_dbus_impl_account_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_dbus_impl_account_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_dbus_impl_account_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_DBUS_IMPL_TYPE_ACCOUNT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_ACCOUNT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_dbus_impl_account_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpDbusImplAccountProxy *proxy = XDP_DBUS_IMPL_ACCOUNT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_account_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_account_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_dbus_impl_account_proxy_init (XdpDbusImplAccountProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_dbus_impl_account_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_DBUS_IMPL_TYPE_ACCOUNT_PROXY, XdpDbusImplAccountProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_dbus_impl_account_interface_info ());
}

static void
xdp_dbus_impl_account_proxy_class_init (XdpDbusImplAccountProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_dbus_impl_account_proxy_finalize;
  gobject_class->get_property = xdp_dbus_impl_account_proxy_get_property;
  gobject_class->set_property = xdp_dbus_impl_account_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_dbus_impl_account_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_dbus_impl_account_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplAccountProxyPrivate));
#endif
}

static void
xdp_dbus_impl_account_proxy_iface_init (XdpDbusImplAccountIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_dbus_impl_account_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Account.top_of_page">org.freedesktop.impl.portal.Account</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_account_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_account_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_account_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_ACCOUNT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Account", NULL);
}

/**
 * xdp_dbus_impl_account_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_account_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_account_proxy_new().
 *
 * Returns: (transfer full) (type XdpDbusImplAccountProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplAccount *
xdp_dbus_impl_account_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_ACCOUNT (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_account_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Account.top_of_page">org.freedesktop.impl.portal.Account</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_account_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplAccountProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplAccount *
xdp_dbus_impl_account_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_ACCOUNT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Account", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_ACCOUNT (ret);
  else
    return NULL;
}


/**
 * xdp_dbus_impl_account_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_dbus_impl_account_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_account_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_account_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_account_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_ACCOUNT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Account", NULL);
}

/**
 * xdp_dbus_impl_account_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_account_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_account_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpDbusImplAccountProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplAccount *
xdp_dbus_impl_account_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_ACCOUNT (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_account_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_dbus_impl_account_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_account_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplAccountProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplAccount *
xdp_dbus_impl_account_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_ACCOUNT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Account", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_ACCOUNT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplAccountSkeleton:
 *
 * The #XdpDbusImplAccountSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplAccountSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplAccountSkeleton.
 */

struct _XdpDbusImplAccountSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_dbus_impl_account_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpDbusImplAccountSkeleton *skeleton = XDP_DBUS_IMPL_ACCOUNT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_DBUS_IMPL_TYPE_ACCOUNT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_ACCOUNT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_dbus_impl_account_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplAccountSkeleton *skeleton = XDP_DBUS_IMPL_ACCOUNT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_account_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_dbus_impl_account_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplAccountSkeleton *skeleton = XDP_DBUS_IMPL_ACCOUNT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_account_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_dbus_impl_account_skeleton_vtable =
{
  _xdp_dbus_impl_account_skeleton_handle_method_call,
  _xdp_dbus_impl_account_skeleton_handle_get_property,
  _xdp_dbus_impl_account_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_dbus_impl_account_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_dbus_impl_account_interface_info ();
}

static GDBusInterfaceVTable *
xdp_dbus_impl_account_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_dbus_impl_account_skeleton_vtable;
}

static GVariant *
xdp_dbus_impl_account_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDbusImplAccountSkeleton *skeleton = XDP_DBUS_IMPL_ACCOUNT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_dbus_impl_account_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_dbus_impl_account_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_dbus_impl_account_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_dbus_impl_account_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Account", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_dbus_impl_account_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void xdp_dbus_impl_account_skeleton_iface_init (XdpDbusImplAccountIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplAccountSkeleton, xdp_dbus_impl_account_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpDbusImplAccountSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_ACCOUNT, xdp_dbus_impl_account_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplAccountSkeleton, xdp_dbus_impl_account_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_ACCOUNT, xdp_dbus_impl_account_skeleton_iface_init))

#endif
static void
xdp_dbus_impl_account_skeleton_finalize (GObject *object)
{
  XdpDbusImplAccountSkeleton *skeleton = XDP_DBUS_IMPL_ACCOUNT_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_dbus_impl_account_skeleton_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_account_skeleton_init (XdpDbusImplAccountSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_dbus_impl_account_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_DBUS_IMPL_TYPE_ACCOUNT_SKELETON, XdpDbusImplAccountSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_dbus_impl_account_skeleton_class_init (XdpDbusImplAccountSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_dbus_impl_account_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_dbus_impl_account_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_dbus_impl_account_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_dbus_impl_account_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_dbus_impl_account_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplAccountSkeletonPrivate));
#endif
}

static void
xdp_dbus_impl_account_skeleton_iface_init (XdpDbusImplAccountIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_dbus_impl_account_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Account.top_of_page">org.freedesktop.impl.portal.Account</link>.
 *
 * Returns: (transfer full) (type XdpDbusImplAccountSkeleton): The skeleton object.
 */
XdpDbusImplAccount *
xdp_dbus_impl_account_skeleton_new (void)
{
  return XDP_DBUS_IMPL_ACCOUNT (g_object_new (XDP_DBUS_IMPL_TYPE_ACCOUNT_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.AppChooser
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpDbusImplAppChooser
 * @title: XdpDbusImplAppChooser
 * @short_description: Generated C code for the org.freedesktop.impl.portal.AppChooser D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-AppChooser.top_of_page">org.freedesktop.impl.portal.AppChooser</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.AppChooser ---- */

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_app_chooser_method_info_choose_application_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_app_chooser_method_info_choose_application_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_app_chooser_method_info_choose_application_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_app_chooser_method_info_choose_application_IN_ARG_choices =
{
  {
    -1,
    (gchar *) "choices",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_app_chooser_method_info_choose_application_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_app_chooser_method_info_choose_application_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_app_chooser_method_info_choose_application_IN_ARG_handle.parent_struct,
  &_xdp_dbus_impl_app_chooser_method_info_choose_application_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_app_chooser_method_info_choose_application_IN_ARG_parent_window.parent_struct,
  &_xdp_dbus_impl_app_chooser_method_info_choose_application_IN_ARG_choices.parent_struct,
  &_xdp_dbus_impl_app_chooser_method_info_choose_application_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_app_chooser_method_info_choose_application_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_app_chooser_method_info_choose_application_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_app_chooser_method_info_choose_application_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_app_chooser_method_info_choose_application_OUT_ARG_response.parent_struct,
  &_xdp_dbus_impl_app_chooser_method_info_choose_application_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_app_chooser_method_choose_application_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In4",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_app_chooser_method_choose_application_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_dbus_impl_app_chooser_method_choose_application_annotation_info_pointers[] =
{
  &_xdp_dbus_impl_app_chooser_method_choose_application_annotation_info_0,
  &_xdp_dbus_impl_app_chooser_method_choose_application_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_app_chooser_method_info_choose_application =
{
  {
    -1,
    (gchar *) "ChooseApplication",
    (GDBusArgInfo **) &_xdp_dbus_impl_app_chooser_method_info_choose_application_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_app_chooser_method_info_choose_application_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_dbus_impl_app_chooser_method_choose_application_annotation_info_pointers
  },
  "handle-choose-application",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_app_chooser_method_info_update_choices_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_app_chooser_method_info_update_choices_IN_ARG_choices =
{
  {
    -1,
    (gchar *) "choices",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_app_chooser_method_info_update_choices_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_app_chooser_method_info_update_choices_IN_ARG_handle.parent_struct,
  &_xdp_dbus_impl_app_chooser_method_info_update_choices_IN_ARG_choices.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_app_chooser_method_info_update_choices =
{
  {
    -1,
    (gchar *) "UpdateChoices",
    (GDBusArgInfo **) &_xdp_dbus_impl_app_chooser_method_info_update_choices_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-update-choices",
  FALSE
};

static const GDBusMethodInfo * const _xdp_dbus_impl_app_chooser_method_info_pointers[] =
{
  &_xdp_dbus_impl_app_chooser_method_info_choose_application.parent_struct,
  &_xdp_dbus_impl_app_chooser_method_info_update_choices.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_dbus_impl_app_chooser_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.AppChooser",
    (GDBusMethodInfo **) &_xdp_dbus_impl_app_chooser_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "app-chooser",
};


/**
 * xdp_dbus_impl_app_chooser_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-AppChooser.top_of_page">org.freedesktop.impl.portal.AppChooser</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_dbus_impl_app_chooser_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_dbus_impl_app_chooser_interface_info.parent_struct;
}

/**
 * xdp_dbus_impl_app_chooser_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpDbusImplAppChooser interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_dbus_impl_app_chooser_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XdpDbusImplAppChooser:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-AppChooser.top_of_page">org.freedesktop.impl.portal.AppChooser</link>.
 */

/**
 * XdpDbusImplAppChooserIface:
 * @parent_iface: The parent interface.
 * @handle_choose_application: Handler for the #XdpDbusImplAppChooser::handle-choose-application signal.
 * @handle_update_choices: Handler for the #XdpDbusImplAppChooser::handle-update-choices signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-AppChooser.top_of_page">org.freedesktop.impl.portal.AppChooser</link>.
 */

typedef XdpDbusImplAppChooserIface XdpDbusImplAppChooserInterface;
G_DEFINE_INTERFACE (XdpDbusImplAppChooser, xdp_dbus_impl_app_chooser, G_TYPE_OBJECT)

static void
xdp_dbus_impl_app_chooser_default_init (XdpDbusImplAppChooserIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpDbusImplAppChooser::handle-choose-application:
   * @object: A #XdpDbusImplAppChooser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_choices: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-AppChooser.ChooseApplication">ChooseApplication()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_app_chooser_complete_choose_application() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-choose-application",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplAppChooserIface, handle_choose_application),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_VARIANT);

  /**
   * XdpDbusImplAppChooser::handle-update-choices:
   * @object: A #XdpDbusImplAppChooser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_choices: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-AppChooser.UpdateChoices">UpdateChoices()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_app_chooser_complete_update_choices() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-update-choices",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplAppChooserIface, handle_update_choices),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRV);

}

/**
 * xdp_dbus_impl_app_chooser_call_choose_application:
 * @proxy: A #XdpDbusImplAppChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_choices: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-AppChooser.ChooseApplication">ChooseApplication()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_app_chooser_call_choose_application_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_app_chooser_call_choose_application_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_app_chooser_call_choose_application (
    XdpDbusImplAppChooser *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *const *arg_choices,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ChooseApplication",
    g_variant_new ("(oss^as@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_choices,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_app_chooser_call_choose_application_finish:
 * @proxy: A #XdpDbusImplAppChooserProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_app_chooser_call_choose_application().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_app_chooser_call_choose_application().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_app_chooser_call_choose_application_finish (
    XdpDbusImplAppChooser *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_app_chooser_call_choose_application_sync:
 * @proxy: A #XdpDbusImplAppChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_choices: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-AppChooser.ChooseApplication">ChooseApplication()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_app_chooser_call_choose_application() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_app_chooser_call_choose_application_sync (
    XdpDbusImplAppChooser *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *const *arg_choices,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ChooseApplication",
    g_variant_new ("(oss^as@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_choices,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_app_chooser_call_update_choices:
 * @proxy: A #XdpDbusImplAppChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_choices: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-AppChooser.UpdateChoices">UpdateChoices()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_app_chooser_call_update_choices_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_app_chooser_call_update_choices_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_app_chooser_call_update_choices (
    XdpDbusImplAppChooser *proxy,
    const gchar *arg_handle,
    const gchar *const *arg_choices,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "UpdateChoices",
    g_variant_new ("(o^as)",
                   arg_handle,
                   arg_choices),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_app_chooser_call_update_choices_finish:
 * @proxy: A #XdpDbusImplAppChooserProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_app_chooser_call_update_choices().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_app_chooser_call_update_choices().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_app_chooser_call_update_choices_finish (
    XdpDbusImplAppChooser *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_app_chooser_call_update_choices_sync:
 * @proxy: A #XdpDbusImplAppChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_choices: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-AppChooser.UpdateChoices">UpdateChoices()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_app_chooser_call_update_choices() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_app_chooser_call_update_choices_sync (
    XdpDbusImplAppChooser *proxy,
    const gchar *arg_handle,
    const gchar *const *arg_choices,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "UpdateChoices",
    g_variant_new ("(o^as)",
                   arg_handle,
                   arg_choices),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_app_chooser_complete_choose_application:
 * @object: A #XdpDbusImplAppChooser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-AppChooser.ChooseApplication">ChooseApplication()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_app_chooser_complete_choose_application (
    XdpDbusImplAppChooser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * xdp_dbus_impl_app_chooser_complete_update_choices:
 * @object: A #XdpDbusImplAppChooser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-AppChooser.UpdateChoices">UpdateChoices()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_app_chooser_complete_update_choices (
    XdpDbusImplAppChooser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplAppChooserProxy:
 *
 * The #XdpDbusImplAppChooserProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplAppChooserProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplAppChooserProxy.
 */

struct _XdpDbusImplAppChooserProxyPrivate
{
  GData *qdata;
};

static void xdp_dbus_impl_app_chooser_proxy_iface_init (XdpDbusImplAppChooserIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplAppChooserProxy, xdp_dbus_impl_app_chooser_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpDbusImplAppChooserProxy)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_APP_CHOOSER, xdp_dbus_impl_app_chooser_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplAppChooserProxy, xdp_dbus_impl_app_chooser_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_APP_CHOOSER, xdp_dbus_impl_app_chooser_proxy_iface_init))

#endif
static void
xdp_dbus_impl_app_chooser_proxy_finalize (GObject *object)
{
  XdpDbusImplAppChooserProxy *proxy = XDP_DBUS_IMPL_APP_CHOOSER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_dbus_impl_app_chooser_proxy_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_app_chooser_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_dbus_impl_app_chooser_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_dbus_impl_app_chooser_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_dbus_impl_app_chooser_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_DBUS_IMPL_TYPE_APP_CHOOSER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_APP_CHOOSER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_dbus_impl_app_chooser_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpDbusImplAppChooserProxy *proxy = XDP_DBUS_IMPL_APP_CHOOSER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_app_chooser_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_app_chooser_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_dbus_impl_app_chooser_proxy_init (XdpDbusImplAppChooserProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_dbus_impl_app_chooser_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_DBUS_IMPL_TYPE_APP_CHOOSER_PROXY, XdpDbusImplAppChooserProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_dbus_impl_app_chooser_interface_info ());
}

static void
xdp_dbus_impl_app_chooser_proxy_class_init (XdpDbusImplAppChooserProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_dbus_impl_app_chooser_proxy_finalize;
  gobject_class->get_property = xdp_dbus_impl_app_chooser_proxy_get_property;
  gobject_class->set_property = xdp_dbus_impl_app_chooser_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_dbus_impl_app_chooser_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_dbus_impl_app_chooser_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplAppChooserProxyPrivate));
#endif
}

static void
xdp_dbus_impl_app_chooser_proxy_iface_init (XdpDbusImplAppChooserIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_dbus_impl_app_chooser_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-AppChooser.top_of_page">org.freedesktop.impl.portal.AppChooser</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_app_chooser_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_app_chooser_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_app_chooser_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_APP_CHOOSER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.AppChooser", NULL);
}

/**
 * xdp_dbus_impl_app_chooser_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_app_chooser_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_app_chooser_proxy_new().
 *
 * Returns: (transfer full) (type XdpDbusImplAppChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplAppChooser *
xdp_dbus_impl_app_chooser_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_APP_CHOOSER (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_app_chooser_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-AppChooser.top_of_page">org.freedesktop.impl.portal.AppChooser</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_app_chooser_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplAppChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplAppChooser *
xdp_dbus_impl_app_chooser_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_APP_CHOOSER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.AppChooser", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_APP_CHOOSER (ret);
  else
    return NULL;
}


/**
 * xdp_dbus_impl_app_chooser_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_dbus_impl_app_chooser_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_app_chooser_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_app_chooser_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_app_chooser_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_APP_CHOOSER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.AppChooser", NULL);
}

/**
 * xdp_dbus_impl_app_chooser_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_app_chooser_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_app_chooser_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpDbusImplAppChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplAppChooser *
xdp_dbus_impl_app_chooser_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_APP_CHOOSER (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_app_chooser_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_dbus_impl_app_chooser_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_app_chooser_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplAppChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplAppChooser *
xdp_dbus_impl_app_chooser_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_APP_CHOOSER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.AppChooser", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_APP_CHOOSER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplAppChooserSkeleton:
 *
 * The #XdpDbusImplAppChooserSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplAppChooserSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplAppChooserSkeleton.
 */

struct _XdpDbusImplAppChooserSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_dbus_impl_app_chooser_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpDbusImplAppChooserSkeleton *skeleton = XDP_DBUS_IMPL_APP_CHOOSER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_DBUS_IMPL_TYPE_APP_CHOOSER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_APP_CHOOSER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_dbus_impl_app_chooser_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplAppChooserSkeleton *skeleton = XDP_DBUS_IMPL_APP_CHOOSER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_app_chooser_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_dbus_impl_app_chooser_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplAppChooserSkeleton *skeleton = XDP_DBUS_IMPL_APP_CHOOSER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_app_chooser_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_dbus_impl_app_chooser_skeleton_vtable =
{
  _xdp_dbus_impl_app_chooser_skeleton_handle_method_call,
  _xdp_dbus_impl_app_chooser_skeleton_handle_get_property,
  _xdp_dbus_impl_app_chooser_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_dbus_impl_app_chooser_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_dbus_impl_app_chooser_interface_info ();
}

static GDBusInterfaceVTable *
xdp_dbus_impl_app_chooser_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_dbus_impl_app_chooser_skeleton_vtable;
}

static GVariant *
xdp_dbus_impl_app_chooser_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDbusImplAppChooserSkeleton *skeleton = XDP_DBUS_IMPL_APP_CHOOSER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_dbus_impl_app_chooser_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_dbus_impl_app_chooser_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_dbus_impl_app_chooser_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_dbus_impl_app_chooser_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.AppChooser", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_dbus_impl_app_chooser_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void xdp_dbus_impl_app_chooser_skeleton_iface_init (XdpDbusImplAppChooserIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplAppChooserSkeleton, xdp_dbus_impl_app_chooser_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpDbusImplAppChooserSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_APP_CHOOSER, xdp_dbus_impl_app_chooser_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplAppChooserSkeleton, xdp_dbus_impl_app_chooser_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_APP_CHOOSER, xdp_dbus_impl_app_chooser_skeleton_iface_init))

#endif
static void
xdp_dbus_impl_app_chooser_skeleton_finalize (GObject *object)
{
  XdpDbusImplAppChooserSkeleton *skeleton = XDP_DBUS_IMPL_APP_CHOOSER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_dbus_impl_app_chooser_skeleton_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_app_chooser_skeleton_init (XdpDbusImplAppChooserSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_dbus_impl_app_chooser_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_DBUS_IMPL_TYPE_APP_CHOOSER_SKELETON, XdpDbusImplAppChooserSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_dbus_impl_app_chooser_skeleton_class_init (XdpDbusImplAppChooserSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_dbus_impl_app_chooser_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_dbus_impl_app_chooser_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_dbus_impl_app_chooser_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_dbus_impl_app_chooser_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_dbus_impl_app_chooser_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplAppChooserSkeletonPrivate));
#endif
}

static void
xdp_dbus_impl_app_chooser_skeleton_iface_init (XdpDbusImplAppChooserIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_dbus_impl_app_chooser_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-AppChooser.top_of_page">org.freedesktop.impl.portal.AppChooser</link>.
 *
 * Returns: (transfer full) (type XdpDbusImplAppChooserSkeleton): The skeleton object.
 */
XdpDbusImplAppChooser *
xdp_dbus_impl_app_chooser_skeleton_new (void)
{
  return XDP_DBUS_IMPL_APP_CHOOSER (g_object_new (XDP_DBUS_IMPL_TYPE_APP_CHOOSER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Background
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpDbusImplBackground
 * @title: XdpDbusImplBackground
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Background D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Background.top_of_page">org.freedesktop.impl.portal.Background</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Background ---- */

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_background_method_info_get_app_state_OUT_ARG_apps =
{
  {
    -1,
    (gchar *) "apps",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_background_method_info_get_app_state_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_background_method_info_get_app_state_OUT_ARG_apps.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_background_method_info_get_app_state =
{
  {
    -1,
    (gchar *) "GetAppState",
    NULL,
    (GDBusArgInfo **) &_xdp_dbus_impl_background_method_info_get_app_state_OUT_ARG_pointers,
    NULL
  },
  "handle-get-app-state",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_background_method_info_notify_background_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_background_method_info_notify_background_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_background_method_info_notify_background_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_background_method_info_notify_background_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_background_method_info_notify_background_IN_ARG_handle.parent_struct,
  &_xdp_dbus_impl_background_method_info_notify_background_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_background_method_info_notify_background_IN_ARG_name.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_background_method_info_notify_background_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_background_method_info_notify_background_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_background_method_info_notify_background_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_background_method_info_notify_background_OUT_ARG_response.parent_struct,
  &_xdp_dbus_impl_background_method_info_notify_background_OUT_ARG_results.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_background_method_info_notify_background =
{
  {
    -1,
    (gchar *) "NotifyBackground",
    (GDBusArgInfo **) &_xdp_dbus_impl_background_method_info_notify_background_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_background_method_info_notify_background_OUT_ARG_pointers,
    NULL
  },
  "handle-notify-background",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_background_method_info_enable_autostart_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_background_method_info_enable_autostart_IN_ARG_enable =
{
  {
    -1,
    (gchar *) "enable",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_background_method_info_enable_autostart_IN_ARG_commandline =
{
  {
    -1,
    (gchar *) "commandline",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_background_method_info_enable_autostart_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_background_method_info_enable_autostart_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_background_method_info_enable_autostart_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_background_method_info_enable_autostart_IN_ARG_enable.parent_struct,
  &_xdp_dbus_impl_background_method_info_enable_autostart_IN_ARG_commandline.parent_struct,
  &_xdp_dbus_impl_background_method_info_enable_autostart_IN_ARG_flags.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_background_method_info_enable_autostart_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_background_method_info_enable_autostart_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_background_method_info_enable_autostart_OUT_ARG_result.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_background_method_info_enable_autostart =
{
  {
    -1,
    (gchar *) "EnableAutostart",
    (GDBusArgInfo **) &_xdp_dbus_impl_background_method_info_enable_autostart_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_background_method_info_enable_autostart_OUT_ARG_pointers,
    NULL
  },
  "handle-enable-autostart",
  FALSE
};

static const GDBusMethodInfo * const _xdp_dbus_impl_background_method_info_pointers[] =
{
  &_xdp_dbus_impl_background_method_info_get_app_state.parent_struct,
  &_xdp_dbus_impl_background_method_info_notify_background.parent_struct,
  &_xdp_dbus_impl_background_method_info_enable_autostart.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xdp_dbus_impl_background_signal_info_running_applications_changed =
{
  {
    -1,
    (gchar *) "RunningApplicationsChanged",
    NULL,
    NULL
  },
  "running-applications-changed"
};

static const GDBusSignalInfo * const _xdp_dbus_impl_background_signal_info_pointers[] =
{
  &_xdp_dbus_impl_background_signal_info_running_applications_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_dbus_impl_background_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Background",
    (GDBusMethodInfo **) &_xdp_dbus_impl_background_method_info_pointers,
    (GDBusSignalInfo **) &_xdp_dbus_impl_background_signal_info_pointers,
    NULL,
    NULL
  },
  "background",
};


/**
 * xdp_dbus_impl_background_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Background.top_of_page">org.freedesktop.impl.portal.Background</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_dbus_impl_background_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_dbus_impl_background_interface_info.parent_struct;
}

/**
 * xdp_dbus_impl_background_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpDbusImplBackground interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_dbus_impl_background_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XdpDbusImplBackground:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Background.top_of_page">org.freedesktop.impl.portal.Background</link>.
 */

/**
 * XdpDbusImplBackgroundIface:
 * @parent_iface: The parent interface.
 * @handle_enable_autostart: Handler for the #XdpDbusImplBackground::handle-enable-autostart signal.
 * @handle_get_app_state: Handler for the #XdpDbusImplBackground::handle-get-app-state signal.
 * @handle_notify_background: Handler for the #XdpDbusImplBackground::handle-notify-background signal.
 * @running_applications_changed: Handler for the #XdpDbusImplBackground::running-applications-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Background.top_of_page">org.freedesktop.impl.portal.Background</link>.
 */

typedef XdpDbusImplBackgroundIface XdpDbusImplBackgroundInterface;
G_DEFINE_INTERFACE (XdpDbusImplBackground, xdp_dbus_impl_background, G_TYPE_OBJECT)

static void
xdp_dbus_impl_background_default_init (XdpDbusImplBackgroundIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpDbusImplBackground::handle-get-app-state:
   * @object: A #XdpDbusImplBackground.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.GetAppState">GetAppState()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_background_complete_get_app_state() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-app-state",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplBackgroundIface, handle_get_app_state),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * XdpDbusImplBackground::handle-notify-background:
   * @object: A #XdpDbusImplBackground.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_name: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.NotifyBackground">NotifyBackground()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_background_complete_notify_background() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-background",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplBackgroundIface, handle_notify_background),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XdpDbusImplBackground::handle-enable-autostart:
   * @object: A #XdpDbusImplBackground.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_enable: Argument passed by remote caller.
   * @arg_commandline: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.EnableAutostart">EnableAutostart()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_background_complete_enable_autostart() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-enable-autostart",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplBackgroundIface, handle_enable_autostart),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_STRV, G_TYPE_UINT);

  /* GObject signals for received D-Bus signals: */
  /**
   * XdpDbusImplBackground::running-applications-changed:
   * @object: A #XdpDbusImplBackground.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-impl-portal-Background.RunningApplicationsChanged">"RunningApplicationsChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("running-applications-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplBackgroundIface, running_applications_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    0);

}

/**
 * xdp_dbus_impl_background_emit_running_applications_changed:
 * @object: A #XdpDbusImplBackground.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-impl-portal-Background.RunningApplicationsChanged">"RunningApplicationsChanged"</link> D-Bus signal.
 */
void
xdp_dbus_impl_background_emit_running_applications_changed (
    XdpDbusImplBackground *object)
{
  g_signal_emit_by_name (object, "running-applications-changed");
}

/**
 * xdp_dbus_impl_background_call_get_app_state:
 * @proxy: A #XdpDbusImplBackgroundProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.GetAppState">GetAppState()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_background_call_get_app_state_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_background_call_get_app_state_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_background_call_get_app_state (
    XdpDbusImplBackground *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetAppState",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_background_call_get_app_state_finish:
 * @proxy: A #XdpDbusImplBackgroundProxy.
 * @out_apps: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_background_call_get_app_state().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_background_call_get_app_state().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_background_call_get_app_state_finish (
    XdpDbusImplBackground *proxy,
    GVariant **out_apps,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_apps);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_background_call_get_app_state_sync:
 * @proxy: A #XdpDbusImplBackgroundProxy.
 * @out_apps: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.GetAppState">GetAppState()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_background_call_get_app_state() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_background_call_get_app_state_sync (
    XdpDbusImplBackground *proxy,
    GVariant **out_apps,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetAppState",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_apps);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_background_call_notify_background:
 * @proxy: A #XdpDbusImplBackgroundProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.NotifyBackground">NotifyBackground()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_background_call_notify_background_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_background_call_notify_background_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_background_call_notify_background (
    XdpDbusImplBackground *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_name,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyBackground",
    g_variant_new ("(oss)",
                   arg_handle,
                   arg_app_id,
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_background_call_notify_background_finish:
 * @proxy: A #XdpDbusImplBackgroundProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_background_call_notify_background().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_background_call_notify_background().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_background_call_notify_background_finish (
    XdpDbusImplBackground *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_background_call_notify_background_sync:
 * @proxy: A #XdpDbusImplBackgroundProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.NotifyBackground">NotifyBackground()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_background_call_notify_background() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_background_call_notify_background_sync (
    XdpDbusImplBackground *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_name,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyBackground",
    g_variant_new ("(oss)",
                   arg_handle,
                   arg_app_id,
                   arg_name),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_background_call_enable_autostart:
 * @proxy: A #XdpDbusImplBackgroundProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_enable: Argument to pass with the method invocation.
 * @arg_commandline: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.EnableAutostart">EnableAutostart()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_background_call_enable_autostart_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_background_call_enable_autostart_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_background_call_enable_autostart (
    XdpDbusImplBackground *proxy,
    const gchar *arg_app_id,
    gboolean arg_enable,
    const gchar *const *arg_commandline,
    guint arg_flags,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "EnableAutostart",
    g_variant_new ("(sb^asu)",
                   arg_app_id,
                   arg_enable,
                   arg_commandline,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_background_call_enable_autostart_finish:
 * @proxy: A #XdpDbusImplBackgroundProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_background_call_enable_autostart().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_background_call_enable_autostart().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_background_call_enable_autostart_finish (
    XdpDbusImplBackground *proxy,
    gboolean *out_result,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_background_call_enable_autostart_sync:
 * @proxy: A #XdpDbusImplBackgroundProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_enable: Argument to pass with the method invocation.
 * @arg_commandline: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.EnableAutostart">EnableAutostart()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_background_call_enable_autostart() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_background_call_enable_autostart_sync (
    XdpDbusImplBackground *proxy,
    const gchar *arg_app_id,
    gboolean arg_enable,
    const gchar *const *arg_commandline,
    guint arg_flags,
    gboolean *out_result,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "EnableAutostart",
    g_variant_new ("(sb^asu)",
                   arg_app_id,
                   arg_enable,
                   arg_commandline,
                   arg_flags),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(b)",
                 out_result);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_background_complete_get_app_state:
 * @object: A #XdpDbusImplBackground.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @apps: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.GetAppState">GetAppState()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_background_complete_get_app_state (
    XdpDbusImplBackground *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *apps)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   apps));
}

/**
 * xdp_dbus_impl_background_complete_notify_background:
 * @object: A #XdpDbusImplBackground.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.NotifyBackground">NotifyBackground()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_background_complete_notify_background (
    XdpDbusImplBackground *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * xdp_dbus_impl_background_complete_enable_autostart:
 * @object: A #XdpDbusImplBackground.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Background.EnableAutostart">EnableAutostart()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_background_complete_enable_autostart (
    XdpDbusImplBackground *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gboolean result)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(b)",
                   result));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplBackgroundProxy:
 *
 * The #XdpDbusImplBackgroundProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplBackgroundProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplBackgroundProxy.
 */

struct _XdpDbusImplBackgroundProxyPrivate
{
  GData *qdata;
};

static void xdp_dbus_impl_background_proxy_iface_init (XdpDbusImplBackgroundIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplBackgroundProxy, xdp_dbus_impl_background_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpDbusImplBackgroundProxy)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_BACKGROUND, xdp_dbus_impl_background_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplBackgroundProxy, xdp_dbus_impl_background_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_BACKGROUND, xdp_dbus_impl_background_proxy_iface_init))

#endif
static void
xdp_dbus_impl_background_proxy_finalize (GObject *object)
{
  XdpDbusImplBackgroundProxy *proxy = XDP_DBUS_IMPL_BACKGROUND_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_dbus_impl_background_proxy_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_background_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_dbus_impl_background_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_dbus_impl_background_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_dbus_impl_background_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_DBUS_IMPL_TYPE_BACKGROUND);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_BACKGROUND);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_dbus_impl_background_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpDbusImplBackgroundProxy *proxy = XDP_DBUS_IMPL_BACKGROUND_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_background_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_background_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_dbus_impl_background_proxy_init (XdpDbusImplBackgroundProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_dbus_impl_background_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_DBUS_IMPL_TYPE_BACKGROUND_PROXY, XdpDbusImplBackgroundProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_dbus_impl_background_interface_info ());
}

static void
xdp_dbus_impl_background_proxy_class_init (XdpDbusImplBackgroundProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_dbus_impl_background_proxy_finalize;
  gobject_class->get_property = xdp_dbus_impl_background_proxy_get_property;
  gobject_class->set_property = xdp_dbus_impl_background_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_dbus_impl_background_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_dbus_impl_background_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplBackgroundProxyPrivate));
#endif
}

static void
xdp_dbus_impl_background_proxy_iface_init (XdpDbusImplBackgroundIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_dbus_impl_background_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Background.top_of_page">org.freedesktop.impl.portal.Background</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_background_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_background_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_background_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_BACKGROUND_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Background", NULL);
}

/**
 * xdp_dbus_impl_background_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_background_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_background_proxy_new().
 *
 * Returns: (transfer full) (type XdpDbusImplBackgroundProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplBackground *
xdp_dbus_impl_background_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_BACKGROUND (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_background_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Background.top_of_page">org.freedesktop.impl.portal.Background</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_background_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplBackgroundProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplBackground *
xdp_dbus_impl_background_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_BACKGROUND_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Background", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_BACKGROUND (ret);
  else
    return NULL;
}


/**
 * xdp_dbus_impl_background_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_dbus_impl_background_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_background_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_background_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_background_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_BACKGROUND_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Background", NULL);
}

/**
 * xdp_dbus_impl_background_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_background_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_background_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpDbusImplBackgroundProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplBackground *
xdp_dbus_impl_background_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_BACKGROUND (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_background_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_dbus_impl_background_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_background_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplBackgroundProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplBackground *
xdp_dbus_impl_background_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_BACKGROUND_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Background", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_BACKGROUND (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplBackgroundSkeleton:
 *
 * The #XdpDbusImplBackgroundSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplBackgroundSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplBackgroundSkeleton.
 */

struct _XdpDbusImplBackgroundSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_dbus_impl_background_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpDbusImplBackgroundSkeleton *skeleton = XDP_DBUS_IMPL_BACKGROUND_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_DBUS_IMPL_TYPE_BACKGROUND);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_BACKGROUND);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_dbus_impl_background_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplBackgroundSkeleton *skeleton = XDP_DBUS_IMPL_BACKGROUND_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_background_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_dbus_impl_background_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplBackgroundSkeleton *skeleton = XDP_DBUS_IMPL_BACKGROUND_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_background_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_dbus_impl_background_skeleton_vtable =
{
  _xdp_dbus_impl_background_skeleton_handle_method_call,
  _xdp_dbus_impl_background_skeleton_handle_get_property,
  _xdp_dbus_impl_background_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_dbus_impl_background_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_dbus_impl_background_interface_info ();
}

static GDBusInterfaceVTable *
xdp_dbus_impl_background_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_dbus_impl_background_skeleton_vtable;
}

static GVariant *
xdp_dbus_impl_background_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDbusImplBackgroundSkeleton *skeleton = XDP_DBUS_IMPL_BACKGROUND_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_dbus_impl_background_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_dbus_impl_background_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_dbus_impl_background_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_dbus_impl_background_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Background", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_dbus_impl_background_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_xdp_dbus_impl_background_on_signal_running_applications_changed (
    XdpDbusImplBackground *object)
{
  XdpDbusImplBackgroundSkeleton *skeleton = XDP_DBUS_IMPL_BACKGROUND_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("()"));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Background", "RunningApplicationsChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void xdp_dbus_impl_background_skeleton_iface_init (XdpDbusImplBackgroundIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplBackgroundSkeleton, xdp_dbus_impl_background_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpDbusImplBackgroundSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_BACKGROUND, xdp_dbus_impl_background_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplBackgroundSkeleton, xdp_dbus_impl_background_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_BACKGROUND, xdp_dbus_impl_background_skeleton_iface_init))

#endif
static void
xdp_dbus_impl_background_skeleton_finalize (GObject *object)
{
  XdpDbusImplBackgroundSkeleton *skeleton = XDP_DBUS_IMPL_BACKGROUND_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_dbus_impl_background_skeleton_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_background_skeleton_init (XdpDbusImplBackgroundSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_dbus_impl_background_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_DBUS_IMPL_TYPE_BACKGROUND_SKELETON, XdpDbusImplBackgroundSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_dbus_impl_background_skeleton_class_init (XdpDbusImplBackgroundSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_dbus_impl_background_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_dbus_impl_background_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_dbus_impl_background_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_dbus_impl_background_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_dbus_impl_background_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplBackgroundSkeletonPrivate));
#endif
}

static void
xdp_dbus_impl_background_skeleton_iface_init (XdpDbusImplBackgroundIface *iface)
{
  iface->running_applications_changed = _xdp_dbus_impl_background_on_signal_running_applications_changed;
}

/**
 * xdp_dbus_impl_background_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Background.top_of_page">org.freedesktop.impl.portal.Background</link>.
 *
 * Returns: (transfer full) (type XdpDbusImplBackgroundSkeleton): The skeleton object.
 */
XdpDbusImplBackground *
xdp_dbus_impl_background_skeleton_new (void)
{
  return XDP_DBUS_IMPL_BACKGROUND (g_object_new (XDP_DBUS_IMPL_TYPE_BACKGROUND_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.DynamicLauncher
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpDbusImplDynamicLauncher
 * @title: XdpDbusImplDynamicLauncher
 * @short_description: Generated C code for the org.freedesktop.impl.portal.DynamicLauncher D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-DynamicLauncher.top_of_page">org.freedesktop.impl.portal.DynamicLauncher</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.DynamicLauncher ---- */

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_icon_v =
{
  {
    -1,
    (gchar *) "icon_v",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_handle.parent_struct,
  &_xdp_dbus_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_parent_window.parent_struct,
  &_xdp_dbus_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_name.parent_struct,
  &_xdp_dbus_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_icon_v.parent_struct,
  &_xdp_dbus_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_dynamic_launcher_method_info_prepare_install_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_dynamic_launcher_method_info_prepare_install_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_dynamic_launcher_method_info_prepare_install_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_dynamic_launcher_method_info_prepare_install_OUT_ARG_response.parent_struct,
  &_xdp_dbus_impl_dynamic_launcher_method_info_prepare_install_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_dynamic_launcher_method_prepare_install_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_dbus_impl_dynamic_launcher_method_prepare_install_annotation_info_pointers[] =
{
  &_xdp_dbus_impl_dynamic_launcher_method_prepare_install_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_dynamic_launcher_method_info_prepare_install =
{
  {
    -1,
    (gchar *) "PrepareInstall",
    (GDBusArgInfo **) &_xdp_dbus_impl_dynamic_launcher_method_info_prepare_install_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_dynamic_launcher_method_info_prepare_install_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_dbus_impl_dynamic_launcher_method_prepare_install_annotation_info_pointers
  },
  "handle-prepare-install",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_dynamic_launcher_method_info_request_install_token_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_dynamic_launcher_method_info_request_install_token_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_dynamic_launcher_method_info_request_install_token_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_dynamic_launcher_method_info_request_install_token_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_dynamic_launcher_method_info_request_install_token_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_dynamic_launcher_method_info_request_install_token_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_dynamic_launcher_method_info_request_install_token_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_dynamic_launcher_method_info_request_install_token_OUT_ARG_response.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_dynamic_launcher_method_info_request_install_token =
{
  {
    -1,
    (gchar *) "RequestInstallToken",
    (GDBusArgInfo **) &_xdp_dbus_impl_dynamic_launcher_method_info_request_install_token_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_dynamic_launcher_method_info_request_install_token_OUT_ARG_pointers,
    NULL
  },
  "handle-request-install-token",
  FALSE
};

static const GDBusMethodInfo * const _xdp_dbus_impl_dynamic_launcher_method_info_pointers[] =
{
  &_xdp_dbus_impl_dynamic_launcher_method_info_prepare_install.parent_struct,
  &_xdp_dbus_impl_dynamic_launcher_method_info_request_install_token.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_dbus_impl_dynamic_launcher_property_info_supported_launcher_types =
{
  {
    -1,
    (gchar *) "SupportedLauncherTypes",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supported-launcher-types",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_dbus_impl_dynamic_launcher_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_dbus_impl_dynamic_launcher_property_info_pointers[] =
{
  &_xdp_dbus_impl_dynamic_launcher_property_info_supported_launcher_types.parent_struct,
  &_xdp_dbus_impl_dynamic_launcher_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_dbus_impl_dynamic_launcher_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.DynamicLauncher",
    (GDBusMethodInfo **) &_xdp_dbus_impl_dynamic_launcher_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_xdp_dbus_impl_dynamic_launcher_property_info_pointers,
    NULL
  },
  "dynamic-launcher",
};


/**
 * xdp_dbus_impl_dynamic_launcher_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-DynamicLauncher.top_of_page">org.freedesktop.impl.portal.DynamicLauncher</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_dbus_impl_dynamic_launcher_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_dbus_impl_dynamic_launcher_interface_info.parent_struct;
}

/**
 * xdp_dbus_impl_dynamic_launcher_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpDbusImplDynamicLauncher interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_dbus_impl_dynamic_launcher_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "supported-launcher-types");
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpDbusImplDynamicLauncher:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-DynamicLauncher.top_of_page">org.freedesktop.impl.portal.DynamicLauncher</link>.
 */

/**
 * XdpDbusImplDynamicLauncherIface:
 * @parent_iface: The parent interface.
 * @handle_prepare_install: Handler for the #XdpDbusImplDynamicLauncher::handle-prepare-install signal.
 * @handle_request_install_token: Handler for the #XdpDbusImplDynamicLauncher::handle-request-install-token signal.
 * @get_supported_launcher_types: Getter for the #XdpDbusImplDynamicLauncher:supported-launcher-types property.
 * @get_version: Getter for the #XdpDbusImplDynamicLauncher:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-DynamicLauncher.top_of_page">org.freedesktop.impl.portal.DynamicLauncher</link>.
 */

typedef XdpDbusImplDynamicLauncherIface XdpDbusImplDynamicLauncherInterface;
G_DEFINE_INTERFACE (XdpDbusImplDynamicLauncher, xdp_dbus_impl_dynamic_launcher, G_TYPE_OBJECT)

static void
xdp_dbus_impl_dynamic_launcher_default_init (XdpDbusImplDynamicLauncherIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpDbusImplDynamicLauncher::handle-prepare-install:
   * @object: A #XdpDbusImplDynamicLauncher.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_name: Argument passed by remote caller.
   * @arg_icon_v: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-DynamicLauncher.PrepareInstall">PrepareInstall()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_dynamic_launcher_complete_prepare_install() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-prepare-install",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplDynamicLauncherIface, handle_prepare_install),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    7,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * XdpDbusImplDynamicLauncher::handle-request-install-token:
   * @object: A #XdpDbusImplDynamicLauncher.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-DynamicLauncher.RequestInstallToken">RequestInstallToken()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_dynamic_launcher_complete_request_install_token() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-request-install-token",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplDynamicLauncherIface, handle_request_install_token),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpDbusImplDynamicLauncher:supported-launcher-types:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-DynamicLauncher.SupportedLauncherTypes">"SupportedLauncherTypes"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("supported-launcher-types", "SupportedLauncherTypes", "SupportedLauncherTypes", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpDbusImplDynamicLauncher:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-DynamicLauncher.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_dbus_impl_dynamic_launcher_get_supported_launcher_types: (skip)
 * @object: A #XdpDbusImplDynamicLauncher.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-DynamicLauncher.SupportedLauncherTypes">"SupportedLauncherTypes"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_dbus_impl_dynamic_launcher_get_supported_launcher_types (XdpDbusImplDynamicLauncher *object)
{
  return XDP_DBUS_IMPL_DYNAMIC_LAUNCHER_GET_IFACE (object)->get_supported_launcher_types (object);
}

/**
 * xdp_dbus_impl_dynamic_launcher_set_supported_launcher_types: (skip)
 * @object: A #XdpDbusImplDynamicLauncher.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-DynamicLauncher.SupportedLauncherTypes">"SupportedLauncherTypes"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_dbus_impl_dynamic_launcher_set_supported_launcher_types (XdpDbusImplDynamicLauncher *object, guint value)
{
  g_object_set (G_OBJECT (object), "supported-launcher-types", value, NULL);
}

/**
 * xdp_dbus_impl_dynamic_launcher_get_version: (skip)
 * @object: A #XdpDbusImplDynamicLauncher.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-DynamicLauncher.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_dbus_impl_dynamic_launcher_get_version (XdpDbusImplDynamicLauncher *object)
{
  return XDP_DBUS_IMPL_DYNAMIC_LAUNCHER_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_dbus_impl_dynamic_launcher_set_version: (skip)
 * @object: A #XdpDbusImplDynamicLauncher.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-DynamicLauncher.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_dbus_impl_dynamic_launcher_set_version (XdpDbusImplDynamicLauncher *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_dbus_impl_dynamic_launcher_call_prepare_install:
 * @proxy: A #XdpDbusImplDynamicLauncherProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_icon_v: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-DynamicLauncher.PrepareInstall">PrepareInstall()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_dynamic_launcher_call_prepare_install_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_dynamic_launcher_call_prepare_install_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_dynamic_launcher_call_prepare_install (
    XdpDbusImplDynamicLauncher *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_name,
    GVariant *arg_icon_v,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PrepareInstall",
    g_variant_new ("(osss@v@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_name,
                   arg_icon_v,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_dynamic_launcher_call_prepare_install_finish:
 * @proxy: A #XdpDbusImplDynamicLauncherProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_dynamic_launcher_call_prepare_install().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_dynamic_launcher_call_prepare_install().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_dynamic_launcher_call_prepare_install_finish (
    XdpDbusImplDynamicLauncher *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_dynamic_launcher_call_prepare_install_sync:
 * @proxy: A #XdpDbusImplDynamicLauncherProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_name: Argument to pass with the method invocation.
 * @arg_icon_v: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-DynamicLauncher.PrepareInstall">PrepareInstall()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_dynamic_launcher_call_prepare_install() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_dynamic_launcher_call_prepare_install_sync (
    XdpDbusImplDynamicLauncher *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_name,
    GVariant *arg_icon_v,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PrepareInstall",
    g_variant_new ("(osss@v@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_name,
                   arg_icon_v,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_dynamic_launcher_call_request_install_token:
 * @proxy: A #XdpDbusImplDynamicLauncherProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-DynamicLauncher.RequestInstallToken">RequestInstallToken()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_dynamic_launcher_call_request_install_token_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_dynamic_launcher_call_request_install_token_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_dynamic_launcher_call_request_install_token (
    XdpDbusImplDynamicLauncher *proxy,
    const gchar *arg_app_id,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RequestInstallToken",
    g_variant_new ("(s@a{sv})",
                   arg_app_id,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_dynamic_launcher_call_request_install_token_finish:
 * @proxy: A #XdpDbusImplDynamicLauncherProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_dynamic_launcher_call_request_install_token().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_dynamic_launcher_call_request_install_token().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_dynamic_launcher_call_request_install_token_finish (
    XdpDbusImplDynamicLauncher *proxy,
    guint *out_response,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_response);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_dynamic_launcher_call_request_install_token_sync:
 * @proxy: A #XdpDbusImplDynamicLauncherProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-DynamicLauncher.RequestInstallToken">RequestInstallToken()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_dynamic_launcher_call_request_install_token() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_dynamic_launcher_call_request_install_token_sync (
    XdpDbusImplDynamicLauncher *proxy,
    const gchar *arg_app_id,
    GVariant *arg_options,
    guint *out_response,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RequestInstallToken",
    g_variant_new ("(s@a{sv})",
                   arg_app_id,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_response);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_dynamic_launcher_complete_prepare_install:
 * @object: A #XdpDbusImplDynamicLauncher.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-DynamicLauncher.PrepareInstall">PrepareInstall()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_dynamic_launcher_complete_prepare_install (
    XdpDbusImplDynamicLauncher *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * xdp_dbus_impl_dynamic_launcher_complete_request_install_token:
 * @object: A #XdpDbusImplDynamicLauncher.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-DynamicLauncher.RequestInstallToken">RequestInstallToken()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_dynamic_launcher_complete_request_install_token (
    XdpDbusImplDynamicLauncher *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   response));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplDynamicLauncherProxy:
 *
 * The #XdpDbusImplDynamicLauncherProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplDynamicLauncherProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplDynamicLauncherProxy.
 */

struct _XdpDbusImplDynamicLauncherProxyPrivate
{
  GData *qdata;
};

static void xdp_dbus_impl_dynamic_launcher_proxy_iface_init (XdpDbusImplDynamicLauncherIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplDynamicLauncherProxy, xdp_dbus_impl_dynamic_launcher_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpDbusImplDynamicLauncherProxy)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_DYNAMIC_LAUNCHER, xdp_dbus_impl_dynamic_launcher_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplDynamicLauncherProxy, xdp_dbus_impl_dynamic_launcher_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_DYNAMIC_LAUNCHER, xdp_dbus_impl_dynamic_launcher_proxy_iface_init))

#endif
static void
xdp_dbus_impl_dynamic_launcher_proxy_finalize (GObject *object)
{
  XdpDbusImplDynamicLauncherProxy *proxy = XDP_DBUS_IMPL_DYNAMIC_LAUNCHER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_dbus_impl_dynamic_launcher_proxy_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_dynamic_launcher_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_dbus_impl_dynamic_launcher_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_dbus_impl_dynamic_launcher_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.impl.portal.DynamicLauncher: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_dbus_impl_dynamic_launcher_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_dbus_impl_dynamic_launcher_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.impl.portal.DynamicLauncher", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_dbus_impl_dynamic_launcher_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_dbus_impl_dynamic_launcher_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_dbus_impl_dynamic_launcher_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_DBUS_IMPL_TYPE_DYNAMIC_LAUNCHER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_DYNAMIC_LAUNCHER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_dbus_impl_dynamic_launcher_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpDbusImplDynamicLauncherProxy *proxy = XDP_DBUS_IMPL_DYNAMIC_LAUNCHER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_dynamic_launcher_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_dynamic_launcher_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_dbus_impl_dynamic_launcher_proxy_get_supported_launcher_types (XdpDbusImplDynamicLauncher *object)
{
  XdpDbusImplDynamicLauncherProxy *proxy = XDP_DBUS_IMPL_DYNAMIC_LAUNCHER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SupportedLauncherTypes");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
xdp_dbus_impl_dynamic_launcher_proxy_get_version (XdpDbusImplDynamicLauncher *object)
{
  XdpDbusImplDynamicLauncherProxy *proxy = XDP_DBUS_IMPL_DYNAMIC_LAUNCHER_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_dbus_impl_dynamic_launcher_proxy_init (XdpDbusImplDynamicLauncherProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_dbus_impl_dynamic_launcher_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_DBUS_IMPL_TYPE_DYNAMIC_LAUNCHER_PROXY, XdpDbusImplDynamicLauncherProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_dbus_impl_dynamic_launcher_interface_info ());
}

static void
xdp_dbus_impl_dynamic_launcher_proxy_class_init (XdpDbusImplDynamicLauncherProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_dbus_impl_dynamic_launcher_proxy_finalize;
  gobject_class->get_property = xdp_dbus_impl_dynamic_launcher_proxy_get_property;
  gobject_class->set_property = xdp_dbus_impl_dynamic_launcher_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_dbus_impl_dynamic_launcher_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_dbus_impl_dynamic_launcher_proxy_g_properties_changed;

  xdp_dbus_impl_dynamic_launcher_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplDynamicLauncherProxyPrivate));
#endif
}

static void
xdp_dbus_impl_dynamic_launcher_proxy_iface_init (XdpDbusImplDynamicLauncherIface *iface)
{
  iface->get_supported_launcher_types = xdp_dbus_impl_dynamic_launcher_proxy_get_supported_launcher_types;
  iface->get_version = xdp_dbus_impl_dynamic_launcher_proxy_get_version;
}

/**
 * xdp_dbus_impl_dynamic_launcher_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-DynamicLauncher.top_of_page">org.freedesktop.impl.portal.DynamicLauncher</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_dynamic_launcher_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_dynamic_launcher_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_dynamic_launcher_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_DYNAMIC_LAUNCHER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.DynamicLauncher", NULL);
}

/**
 * xdp_dbus_impl_dynamic_launcher_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_dynamic_launcher_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_dynamic_launcher_proxy_new().
 *
 * Returns: (transfer full) (type XdpDbusImplDynamicLauncherProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplDynamicLauncher *
xdp_dbus_impl_dynamic_launcher_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_DYNAMIC_LAUNCHER (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_dynamic_launcher_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-DynamicLauncher.top_of_page">org.freedesktop.impl.portal.DynamicLauncher</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_dynamic_launcher_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplDynamicLauncherProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplDynamicLauncher *
xdp_dbus_impl_dynamic_launcher_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_DYNAMIC_LAUNCHER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.DynamicLauncher", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_DYNAMIC_LAUNCHER (ret);
  else
    return NULL;
}


/**
 * xdp_dbus_impl_dynamic_launcher_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_dbus_impl_dynamic_launcher_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_dynamic_launcher_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_dynamic_launcher_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_dynamic_launcher_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_DYNAMIC_LAUNCHER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.DynamicLauncher", NULL);
}

/**
 * xdp_dbus_impl_dynamic_launcher_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_dynamic_launcher_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_dynamic_launcher_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpDbusImplDynamicLauncherProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplDynamicLauncher *
xdp_dbus_impl_dynamic_launcher_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_DYNAMIC_LAUNCHER (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_dynamic_launcher_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_dbus_impl_dynamic_launcher_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_dynamic_launcher_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplDynamicLauncherProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplDynamicLauncher *
xdp_dbus_impl_dynamic_launcher_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_DYNAMIC_LAUNCHER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.DynamicLauncher", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_DYNAMIC_LAUNCHER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplDynamicLauncherSkeleton:
 *
 * The #XdpDbusImplDynamicLauncherSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplDynamicLauncherSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplDynamicLauncherSkeleton.
 */

struct _XdpDbusImplDynamicLauncherSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_dbus_impl_dynamic_launcher_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpDbusImplDynamicLauncherSkeleton *skeleton = XDP_DBUS_IMPL_DYNAMIC_LAUNCHER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_DBUS_IMPL_TYPE_DYNAMIC_LAUNCHER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_DYNAMIC_LAUNCHER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_dbus_impl_dynamic_launcher_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplDynamicLauncherSkeleton *skeleton = XDP_DBUS_IMPL_DYNAMIC_LAUNCHER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_dynamic_launcher_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_dbus_impl_dynamic_launcher_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplDynamicLauncherSkeleton *skeleton = XDP_DBUS_IMPL_DYNAMIC_LAUNCHER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_dynamic_launcher_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_dbus_impl_dynamic_launcher_skeleton_vtable =
{
  _xdp_dbus_impl_dynamic_launcher_skeleton_handle_method_call,
  _xdp_dbus_impl_dynamic_launcher_skeleton_handle_get_property,
  _xdp_dbus_impl_dynamic_launcher_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_dbus_impl_dynamic_launcher_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_dbus_impl_dynamic_launcher_interface_info ();
}

static GDBusInterfaceVTable *
xdp_dbus_impl_dynamic_launcher_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_dbus_impl_dynamic_launcher_skeleton_vtable;
}

static GVariant *
xdp_dbus_impl_dynamic_launcher_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDbusImplDynamicLauncherSkeleton *skeleton = XDP_DBUS_IMPL_DYNAMIC_LAUNCHER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_dbus_impl_dynamic_launcher_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_dbus_impl_dynamic_launcher_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_dbus_impl_dynamic_launcher_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_dbus_impl_dynamic_launcher_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.DynamicLauncher", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_dbus_impl_dynamic_launcher_emit_changed (gpointer user_data);

static void
xdp_dbus_impl_dynamic_launcher_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDbusImplDynamicLauncherSkeleton *skeleton = XDP_DBUS_IMPL_DYNAMIC_LAUNCHER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_dbus_impl_dynamic_launcher_emit_changed (skeleton);
}

static void xdp_dbus_impl_dynamic_launcher_skeleton_iface_init (XdpDbusImplDynamicLauncherIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplDynamicLauncherSkeleton, xdp_dbus_impl_dynamic_launcher_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpDbusImplDynamicLauncherSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_DYNAMIC_LAUNCHER, xdp_dbus_impl_dynamic_launcher_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplDynamicLauncherSkeleton, xdp_dbus_impl_dynamic_launcher_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_DYNAMIC_LAUNCHER, xdp_dbus_impl_dynamic_launcher_skeleton_iface_init))

#endif
static void
xdp_dbus_impl_dynamic_launcher_skeleton_finalize (GObject *object)
{
  XdpDbusImplDynamicLauncherSkeleton *skeleton = XDP_DBUS_IMPL_DYNAMIC_LAUNCHER_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_dbus_impl_dynamic_launcher_skeleton_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_dynamic_launcher_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpDbusImplDynamicLauncherSkeleton *skeleton = XDP_DBUS_IMPL_DYNAMIC_LAUNCHER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_dbus_impl_dynamic_launcher_emit_changed (gpointer user_data)
{
  XdpDbusImplDynamicLauncherSkeleton *skeleton = XDP_DBUS_IMPL_DYNAMIC_LAUNCHER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.impl.portal.DynamicLauncher",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_dbus_impl_dynamic_launcher_schedule_emit_changed (XdpDbusImplDynamicLauncherSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_dbus_impl_dynamic_launcher_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpDbusImplDynamicLauncherSkeleton *skeleton = XDP_DBUS_IMPL_DYNAMIC_LAUNCHER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_dbus_impl_dynamic_launcher_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_dbus_impl_dynamic_launcher_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_dbus_impl_dynamic_launcher_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpDbusImplDynamicLauncherSkeleton *skeleton = XDP_DBUS_IMPL_DYNAMIC_LAUNCHER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_dbus_impl_dynamic_launcher_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_dbus_impl_dynamic_launcher_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_dbus_impl_dynamic_launcher_skeleton_init (XdpDbusImplDynamicLauncherSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_dbus_impl_dynamic_launcher_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_DBUS_IMPL_TYPE_DYNAMIC_LAUNCHER_SKELETON, XdpDbusImplDynamicLauncherSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT);
}

static guint 
xdp_dbus_impl_dynamic_launcher_skeleton_get_supported_launcher_types (XdpDbusImplDynamicLauncher *object)
{
  XdpDbusImplDynamicLauncherSkeleton *skeleton = XDP_DBUS_IMPL_DYNAMIC_LAUNCHER_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
xdp_dbus_impl_dynamic_launcher_skeleton_get_version (XdpDbusImplDynamicLauncher *object)
{
  XdpDbusImplDynamicLauncherSkeleton *skeleton = XDP_DBUS_IMPL_DYNAMIC_LAUNCHER_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_dbus_impl_dynamic_launcher_skeleton_class_init (XdpDbusImplDynamicLauncherSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_dbus_impl_dynamic_launcher_skeleton_finalize;
  gobject_class->get_property = xdp_dbus_impl_dynamic_launcher_skeleton_get_property;
  gobject_class->set_property = xdp_dbus_impl_dynamic_launcher_skeleton_set_property;
  gobject_class->notify       = xdp_dbus_impl_dynamic_launcher_skeleton_notify;


  xdp_dbus_impl_dynamic_launcher_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_dbus_impl_dynamic_launcher_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_dbus_impl_dynamic_launcher_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_dbus_impl_dynamic_launcher_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_dbus_impl_dynamic_launcher_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplDynamicLauncherSkeletonPrivate));
#endif
}

static void
xdp_dbus_impl_dynamic_launcher_skeleton_iface_init (XdpDbusImplDynamicLauncherIface *iface)
{
  iface->get_supported_launcher_types = xdp_dbus_impl_dynamic_launcher_skeleton_get_supported_launcher_types;
  iface->get_version = xdp_dbus_impl_dynamic_launcher_skeleton_get_version;
}

/**
 * xdp_dbus_impl_dynamic_launcher_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-DynamicLauncher.top_of_page">org.freedesktop.impl.portal.DynamicLauncher</link>.
 *
 * Returns: (transfer full) (type XdpDbusImplDynamicLauncherSkeleton): The skeleton object.
 */
XdpDbusImplDynamicLauncher *
xdp_dbus_impl_dynamic_launcher_skeleton_new (void)
{
  return XDP_DBUS_IMPL_DYNAMIC_LAUNCHER (g_object_new (XDP_DBUS_IMPL_TYPE_DYNAMIC_LAUNCHER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Email
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpDbusImplEmail
 * @title: XdpDbusImplEmail
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Email D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Email.top_of_page">org.freedesktop.impl.portal.Email</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Email ---- */

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_email_method_info_compose_email_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_email_method_info_compose_email_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_email_method_info_compose_email_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_email_method_info_compose_email_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_email_method_info_compose_email_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_email_method_info_compose_email_IN_ARG_handle.parent_struct,
  &_xdp_dbus_impl_email_method_info_compose_email_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_email_method_info_compose_email_IN_ARG_parent_window.parent_struct,
  &_xdp_dbus_impl_email_method_info_compose_email_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_email_method_info_compose_email_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_email_method_info_compose_email_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_email_method_info_compose_email_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_email_method_info_compose_email_OUT_ARG_response.parent_struct,
  &_xdp_dbus_impl_email_method_info_compose_email_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_email_method_compose_email_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In3",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_email_method_compose_email_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_dbus_impl_email_method_compose_email_annotation_info_pointers[] =
{
  &_xdp_dbus_impl_email_method_compose_email_annotation_info_0,
  &_xdp_dbus_impl_email_method_compose_email_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_email_method_info_compose_email =
{
  {
    -1,
    (gchar *) "ComposeEmail",
    (GDBusArgInfo **) &_xdp_dbus_impl_email_method_info_compose_email_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_email_method_info_compose_email_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_dbus_impl_email_method_compose_email_annotation_info_pointers
  },
  "handle-compose-email",
  FALSE
};

static const GDBusMethodInfo * const _xdp_dbus_impl_email_method_info_pointers[] =
{
  &_xdp_dbus_impl_email_method_info_compose_email.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_dbus_impl_email_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Email",
    (GDBusMethodInfo **) &_xdp_dbus_impl_email_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "email",
};


/**
 * xdp_dbus_impl_email_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Email.top_of_page">org.freedesktop.impl.portal.Email</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_dbus_impl_email_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_dbus_impl_email_interface_info.parent_struct;
}

/**
 * xdp_dbus_impl_email_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpDbusImplEmail interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_dbus_impl_email_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XdpDbusImplEmail:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Email.top_of_page">org.freedesktop.impl.portal.Email</link>.
 */

/**
 * XdpDbusImplEmailIface:
 * @parent_iface: The parent interface.
 * @handle_compose_email: Handler for the #XdpDbusImplEmail::handle-compose-email signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Email.top_of_page">org.freedesktop.impl.portal.Email</link>.
 */

typedef XdpDbusImplEmailIface XdpDbusImplEmailInterface;
G_DEFINE_INTERFACE (XdpDbusImplEmail, xdp_dbus_impl_email, G_TYPE_OBJECT)

static void
xdp_dbus_impl_email_default_init (XdpDbusImplEmailIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpDbusImplEmail::handle-compose-email:
   * @object: A #XdpDbusImplEmail.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Email.ComposeEmail">ComposeEmail()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_email_complete_compose_email() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-compose-email",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplEmailIface, handle_compose_email),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * xdp_dbus_impl_email_call_compose_email:
 * @proxy: A #XdpDbusImplEmailProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Email.ComposeEmail">ComposeEmail()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_email_call_compose_email_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_email_call_compose_email_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_email_call_compose_email (
    XdpDbusImplEmail *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ComposeEmail",
    g_variant_new ("(oss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_email_call_compose_email_finish:
 * @proxy: A #XdpDbusImplEmailProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_email_call_compose_email().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_email_call_compose_email().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_email_call_compose_email_finish (
    XdpDbusImplEmail *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_email_call_compose_email_sync:
 * @proxy: A #XdpDbusImplEmailProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Email.ComposeEmail">ComposeEmail()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_email_call_compose_email() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_email_call_compose_email_sync (
    XdpDbusImplEmail *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ComposeEmail",
    g_variant_new ("(oss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_email_complete_compose_email:
 * @object: A #XdpDbusImplEmail.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Email.ComposeEmail">ComposeEmail()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_email_complete_compose_email (
    XdpDbusImplEmail *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplEmailProxy:
 *
 * The #XdpDbusImplEmailProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplEmailProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplEmailProxy.
 */

struct _XdpDbusImplEmailProxyPrivate
{
  GData *qdata;
};

static void xdp_dbus_impl_email_proxy_iface_init (XdpDbusImplEmailIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplEmailProxy, xdp_dbus_impl_email_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpDbusImplEmailProxy)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_EMAIL, xdp_dbus_impl_email_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplEmailProxy, xdp_dbus_impl_email_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_EMAIL, xdp_dbus_impl_email_proxy_iface_init))

#endif
static void
xdp_dbus_impl_email_proxy_finalize (GObject *object)
{
  XdpDbusImplEmailProxy *proxy = XDP_DBUS_IMPL_EMAIL_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_dbus_impl_email_proxy_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_email_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_dbus_impl_email_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_dbus_impl_email_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_dbus_impl_email_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_DBUS_IMPL_TYPE_EMAIL);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_EMAIL);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_dbus_impl_email_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpDbusImplEmailProxy *proxy = XDP_DBUS_IMPL_EMAIL_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_email_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_email_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_dbus_impl_email_proxy_init (XdpDbusImplEmailProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_dbus_impl_email_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_DBUS_IMPL_TYPE_EMAIL_PROXY, XdpDbusImplEmailProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_dbus_impl_email_interface_info ());
}

static void
xdp_dbus_impl_email_proxy_class_init (XdpDbusImplEmailProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_dbus_impl_email_proxy_finalize;
  gobject_class->get_property = xdp_dbus_impl_email_proxy_get_property;
  gobject_class->set_property = xdp_dbus_impl_email_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_dbus_impl_email_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_dbus_impl_email_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplEmailProxyPrivate));
#endif
}

static void
xdp_dbus_impl_email_proxy_iface_init (XdpDbusImplEmailIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_dbus_impl_email_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Email.top_of_page">org.freedesktop.impl.portal.Email</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_email_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_email_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_email_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_EMAIL_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Email", NULL);
}

/**
 * xdp_dbus_impl_email_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_email_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_email_proxy_new().
 *
 * Returns: (transfer full) (type XdpDbusImplEmailProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplEmail *
xdp_dbus_impl_email_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_EMAIL (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_email_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Email.top_of_page">org.freedesktop.impl.portal.Email</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_email_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplEmailProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplEmail *
xdp_dbus_impl_email_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_EMAIL_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Email", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_EMAIL (ret);
  else
    return NULL;
}


/**
 * xdp_dbus_impl_email_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_dbus_impl_email_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_email_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_email_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_email_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_EMAIL_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Email", NULL);
}

/**
 * xdp_dbus_impl_email_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_email_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_email_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpDbusImplEmailProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplEmail *
xdp_dbus_impl_email_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_EMAIL (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_email_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_dbus_impl_email_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_email_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplEmailProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplEmail *
xdp_dbus_impl_email_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_EMAIL_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Email", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_EMAIL (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplEmailSkeleton:
 *
 * The #XdpDbusImplEmailSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplEmailSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplEmailSkeleton.
 */

struct _XdpDbusImplEmailSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_dbus_impl_email_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpDbusImplEmailSkeleton *skeleton = XDP_DBUS_IMPL_EMAIL_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_DBUS_IMPL_TYPE_EMAIL);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_EMAIL);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_dbus_impl_email_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplEmailSkeleton *skeleton = XDP_DBUS_IMPL_EMAIL_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_email_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_dbus_impl_email_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplEmailSkeleton *skeleton = XDP_DBUS_IMPL_EMAIL_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_email_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_dbus_impl_email_skeleton_vtable =
{
  _xdp_dbus_impl_email_skeleton_handle_method_call,
  _xdp_dbus_impl_email_skeleton_handle_get_property,
  _xdp_dbus_impl_email_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_dbus_impl_email_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_dbus_impl_email_interface_info ();
}

static GDBusInterfaceVTable *
xdp_dbus_impl_email_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_dbus_impl_email_skeleton_vtable;
}

static GVariant *
xdp_dbus_impl_email_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDbusImplEmailSkeleton *skeleton = XDP_DBUS_IMPL_EMAIL_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_dbus_impl_email_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_dbus_impl_email_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_dbus_impl_email_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_dbus_impl_email_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Email", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_dbus_impl_email_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void xdp_dbus_impl_email_skeleton_iface_init (XdpDbusImplEmailIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplEmailSkeleton, xdp_dbus_impl_email_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpDbusImplEmailSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_EMAIL, xdp_dbus_impl_email_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplEmailSkeleton, xdp_dbus_impl_email_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_EMAIL, xdp_dbus_impl_email_skeleton_iface_init))

#endif
static void
xdp_dbus_impl_email_skeleton_finalize (GObject *object)
{
  XdpDbusImplEmailSkeleton *skeleton = XDP_DBUS_IMPL_EMAIL_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_dbus_impl_email_skeleton_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_email_skeleton_init (XdpDbusImplEmailSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_dbus_impl_email_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_DBUS_IMPL_TYPE_EMAIL_SKELETON, XdpDbusImplEmailSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_dbus_impl_email_skeleton_class_init (XdpDbusImplEmailSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_dbus_impl_email_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_dbus_impl_email_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_dbus_impl_email_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_dbus_impl_email_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_dbus_impl_email_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplEmailSkeletonPrivate));
#endif
}

static void
xdp_dbus_impl_email_skeleton_iface_init (XdpDbusImplEmailIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_dbus_impl_email_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Email.top_of_page">org.freedesktop.impl.portal.Email</link>.
 *
 * Returns: (transfer full) (type XdpDbusImplEmailSkeleton): The skeleton object.
 */
XdpDbusImplEmail *
xdp_dbus_impl_email_skeleton_new (void)
{
  return XDP_DBUS_IMPL_EMAIL (g_object_new (XDP_DBUS_IMPL_TYPE_EMAIL_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.FileChooser
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpDbusImplFileChooser
 * @title: XdpDbusImplFileChooser
 * @short_description: Generated C code for the org.freedesktop.impl.portal.FileChooser D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-FileChooser.top_of_page">org.freedesktop.impl.portal.FileChooser</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.FileChooser ---- */

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_file_chooser_method_info_open_file_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_file_chooser_method_info_open_file_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_file_chooser_method_info_open_file_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_file_chooser_method_info_open_file_IN_ARG_title =
{
  {
    -1,
    (gchar *) "title",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_file_chooser_method_info_open_file_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_file_chooser_method_info_open_file_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_file_chooser_method_info_open_file_IN_ARG_handle.parent_struct,
  &_xdp_dbus_impl_file_chooser_method_info_open_file_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_file_chooser_method_info_open_file_IN_ARG_parent_window.parent_struct,
  &_xdp_dbus_impl_file_chooser_method_info_open_file_IN_ARG_title.parent_struct,
  &_xdp_dbus_impl_file_chooser_method_info_open_file_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_file_chooser_method_info_open_file_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_file_chooser_method_info_open_file_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_file_chooser_method_info_open_file_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_file_chooser_method_info_open_file_OUT_ARG_response.parent_struct,
  &_xdp_dbus_impl_file_chooser_method_info_open_file_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_file_chooser_method_open_file_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In4",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_file_chooser_method_open_file_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_dbus_impl_file_chooser_method_open_file_annotation_info_pointers[] =
{
  &_xdp_dbus_impl_file_chooser_method_open_file_annotation_info_0,
  &_xdp_dbus_impl_file_chooser_method_open_file_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_file_chooser_method_info_open_file =
{
  {
    -1,
    (gchar *) "OpenFile",
    (GDBusArgInfo **) &_xdp_dbus_impl_file_chooser_method_info_open_file_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_file_chooser_method_info_open_file_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_dbus_impl_file_chooser_method_open_file_annotation_info_pointers
  },
  "handle-open-file",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_file_chooser_method_info_save_file_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_file_chooser_method_info_save_file_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_file_chooser_method_info_save_file_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_file_chooser_method_info_save_file_IN_ARG_title =
{
  {
    -1,
    (gchar *) "title",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_file_chooser_method_info_save_file_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_file_chooser_method_info_save_file_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_file_chooser_method_info_save_file_IN_ARG_handle.parent_struct,
  &_xdp_dbus_impl_file_chooser_method_info_save_file_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_file_chooser_method_info_save_file_IN_ARG_parent_window.parent_struct,
  &_xdp_dbus_impl_file_chooser_method_info_save_file_IN_ARG_title.parent_struct,
  &_xdp_dbus_impl_file_chooser_method_info_save_file_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_file_chooser_method_info_save_file_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_file_chooser_method_info_save_file_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_file_chooser_method_info_save_file_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_file_chooser_method_info_save_file_OUT_ARG_response.parent_struct,
  &_xdp_dbus_impl_file_chooser_method_info_save_file_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_file_chooser_method_save_file_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In4",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_file_chooser_method_save_file_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_dbus_impl_file_chooser_method_save_file_annotation_info_pointers[] =
{
  &_xdp_dbus_impl_file_chooser_method_save_file_annotation_info_0,
  &_xdp_dbus_impl_file_chooser_method_save_file_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_file_chooser_method_info_save_file =
{
  {
    -1,
    (gchar *) "SaveFile",
    (GDBusArgInfo **) &_xdp_dbus_impl_file_chooser_method_info_save_file_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_file_chooser_method_info_save_file_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_dbus_impl_file_chooser_method_save_file_annotation_info_pointers
  },
  "handle-save-file",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_file_chooser_method_info_save_files_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_file_chooser_method_info_save_files_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_file_chooser_method_info_save_files_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_file_chooser_method_info_save_files_IN_ARG_title =
{
  {
    -1,
    (gchar *) "title",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_file_chooser_method_info_save_files_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_file_chooser_method_info_save_files_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_file_chooser_method_info_save_files_IN_ARG_handle.parent_struct,
  &_xdp_dbus_impl_file_chooser_method_info_save_files_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_file_chooser_method_info_save_files_IN_ARG_parent_window.parent_struct,
  &_xdp_dbus_impl_file_chooser_method_info_save_files_IN_ARG_title.parent_struct,
  &_xdp_dbus_impl_file_chooser_method_info_save_files_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_file_chooser_method_info_save_files_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_file_chooser_method_info_save_files_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_file_chooser_method_info_save_files_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_file_chooser_method_info_save_files_OUT_ARG_response.parent_struct,
  &_xdp_dbus_impl_file_chooser_method_info_save_files_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_file_chooser_method_save_files_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In4",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_file_chooser_method_save_files_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_dbus_impl_file_chooser_method_save_files_annotation_info_pointers[] =
{
  &_xdp_dbus_impl_file_chooser_method_save_files_annotation_info_0,
  &_xdp_dbus_impl_file_chooser_method_save_files_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_file_chooser_method_info_save_files =
{
  {
    -1,
    (gchar *) "SaveFiles",
    (GDBusArgInfo **) &_xdp_dbus_impl_file_chooser_method_info_save_files_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_file_chooser_method_info_save_files_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_dbus_impl_file_chooser_method_save_files_annotation_info_pointers
  },
  "handle-save-files",
  FALSE
};

static const GDBusMethodInfo * const _xdp_dbus_impl_file_chooser_method_info_pointers[] =
{
  &_xdp_dbus_impl_file_chooser_method_info_open_file.parent_struct,
  &_xdp_dbus_impl_file_chooser_method_info_save_file.parent_struct,
  &_xdp_dbus_impl_file_chooser_method_info_save_files.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_dbus_impl_file_chooser_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.FileChooser",
    (GDBusMethodInfo **) &_xdp_dbus_impl_file_chooser_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "file-chooser",
};


/**
 * xdp_dbus_impl_file_chooser_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-FileChooser.top_of_page">org.freedesktop.impl.portal.FileChooser</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_dbus_impl_file_chooser_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_dbus_impl_file_chooser_interface_info.parent_struct;
}

/**
 * xdp_dbus_impl_file_chooser_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpDbusImplFileChooser interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_dbus_impl_file_chooser_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XdpDbusImplFileChooser:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-FileChooser.top_of_page">org.freedesktop.impl.portal.FileChooser</link>.
 */

/**
 * XdpDbusImplFileChooserIface:
 * @parent_iface: The parent interface.
 * @handle_open_file: Handler for the #XdpDbusImplFileChooser::handle-open-file signal.
 * @handle_save_file: Handler for the #XdpDbusImplFileChooser::handle-save-file signal.
 * @handle_save_files: Handler for the #XdpDbusImplFileChooser::handle-save-files signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-FileChooser.top_of_page">org.freedesktop.impl.portal.FileChooser</link>.
 */

typedef XdpDbusImplFileChooserIface XdpDbusImplFileChooserInterface;
G_DEFINE_INTERFACE (XdpDbusImplFileChooser, xdp_dbus_impl_file_chooser, G_TYPE_OBJECT)

static void
xdp_dbus_impl_file_chooser_default_init (XdpDbusImplFileChooserIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpDbusImplFileChooser::handle-open-file:
   * @object: A #XdpDbusImplFileChooser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_title: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.OpenFile">OpenFile()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_file_chooser_complete_open_file() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-open-file",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplFileChooserIface, handle_open_file),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpDbusImplFileChooser::handle-save-file:
   * @object: A #XdpDbusImplFileChooser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_title: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.SaveFile">SaveFile()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_file_chooser_complete_save_file() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-save-file",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplFileChooserIface, handle_save_file),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpDbusImplFileChooser::handle-save-files:
   * @object: A #XdpDbusImplFileChooser.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_title: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.SaveFiles">SaveFiles()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_file_chooser_complete_save_files() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-save-files",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplFileChooserIface, handle_save_files),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * xdp_dbus_impl_file_chooser_call_open_file:
 * @proxy: A #XdpDbusImplFileChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.OpenFile">OpenFile()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_file_chooser_call_open_file_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_file_chooser_call_open_file_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_file_chooser_call_open_file (
    XdpDbusImplFileChooser *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "OpenFile",
    g_variant_new ("(osss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_file_chooser_call_open_file_finish:
 * @proxy: A #XdpDbusImplFileChooserProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_file_chooser_call_open_file().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_file_chooser_call_open_file().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_file_chooser_call_open_file_finish (
    XdpDbusImplFileChooser *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_file_chooser_call_open_file_sync:
 * @proxy: A #XdpDbusImplFileChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.OpenFile">OpenFile()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_file_chooser_call_open_file() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_file_chooser_call_open_file_sync (
    XdpDbusImplFileChooser *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "OpenFile",
    g_variant_new ("(osss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_file_chooser_call_save_file:
 * @proxy: A #XdpDbusImplFileChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.SaveFile">SaveFile()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_file_chooser_call_save_file_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_file_chooser_call_save_file_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_file_chooser_call_save_file (
    XdpDbusImplFileChooser *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SaveFile",
    g_variant_new ("(osss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_file_chooser_call_save_file_finish:
 * @proxy: A #XdpDbusImplFileChooserProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_file_chooser_call_save_file().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_file_chooser_call_save_file().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_file_chooser_call_save_file_finish (
    XdpDbusImplFileChooser *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_file_chooser_call_save_file_sync:
 * @proxy: A #XdpDbusImplFileChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.SaveFile">SaveFile()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_file_chooser_call_save_file() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_file_chooser_call_save_file_sync (
    XdpDbusImplFileChooser *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SaveFile",
    g_variant_new ("(osss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_file_chooser_call_save_files:
 * @proxy: A #XdpDbusImplFileChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.SaveFiles">SaveFiles()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_file_chooser_call_save_files_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_file_chooser_call_save_files_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_file_chooser_call_save_files (
    XdpDbusImplFileChooser *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SaveFiles",
    g_variant_new ("(osss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_file_chooser_call_save_files_finish:
 * @proxy: A #XdpDbusImplFileChooserProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_file_chooser_call_save_files().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_file_chooser_call_save_files().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_file_chooser_call_save_files_finish (
    XdpDbusImplFileChooser *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_file_chooser_call_save_files_sync:
 * @proxy: A #XdpDbusImplFileChooserProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.SaveFiles">SaveFiles()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_file_chooser_call_save_files() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_file_chooser_call_save_files_sync (
    XdpDbusImplFileChooser *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SaveFiles",
    g_variant_new ("(osss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_file_chooser_complete_open_file:
 * @object: A #XdpDbusImplFileChooser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.OpenFile">OpenFile()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_file_chooser_complete_open_file (
    XdpDbusImplFileChooser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * xdp_dbus_impl_file_chooser_complete_save_file:
 * @object: A #XdpDbusImplFileChooser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.SaveFile">SaveFile()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_file_chooser_complete_save_file (
    XdpDbusImplFileChooser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * xdp_dbus_impl_file_chooser_complete_save_files:
 * @object: A #XdpDbusImplFileChooser.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-FileChooser.SaveFiles">SaveFiles()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_file_chooser_complete_save_files (
    XdpDbusImplFileChooser *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplFileChooserProxy:
 *
 * The #XdpDbusImplFileChooserProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplFileChooserProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplFileChooserProxy.
 */

struct _XdpDbusImplFileChooserProxyPrivate
{
  GData *qdata;
};

static void xdp_dbus_impl_file_chooser_proxy_iface_init (XdpDbusImplFileChooserIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplFileChooserProxy, xdp_dbus_impl_file_chooser_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpDbusImplFileChooserProxy)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_FILE_CHOOSER, xdp_dbus_impl_file_chooser_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplFileChooserProxy, xdp_dbus_impl_file_chooser_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_FILE_CHOOSER, xdp_dbus_impl_file_chooser_proxy_iface_init))

#endif
static void
xdp_dbus_impl_file_chooser_proxy_finalize (GObject *object)
{
  XdpDbusImplFileChooserProxy *proxy = XDP_DBUS_IMPL_FILE_CHOOSER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_dbus_impl_file_chooser_proxy_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_file_chooser_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_dbus_impl_file_chooser_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_dbus_impl_file_chooser_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_dbus_impl_file_chooser_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_DBUS_IMPL_TYPE_FILE_CHOOSER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_FILE_CHOOSER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_dbus_impl_file_chooser_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpDbusImplFileChooserProxy *proxy = XDP_DBUS_IMPL_FILE_CHOOSER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_file_chooser_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_file_chooser_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_dbus_impl_file_chooser_proxy_init (XdpDbusImplFileChooserProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_dbus_impl_file_chooser_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_DBUS_IMPL_TYPE_FILE_CHOOSER_PROXY, XdpDbusImplFileChooserProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_dbus_impl_file_chooser_interface_info ());
}

static void
xdp_dbus_impl_file_chooser_proxy_class_init (XdpDbusImplFileChooserProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_dbus_impl_file_chooser_proxy_finalize;
  gobject_class->get_property = xdp_dbus_impl_file_chooser_proxy_get_property;
  gobject_class->set_property = xdp_dbus_impl_file_chooser_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_dbus_impl_file_chooser_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_dbus_impl_file_chooser_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplFileChooserProxyPrivate));
#endif
}

static void
xdp_dbus_impl_file_chooser_proxy_iface_init (XdpDbusImplFileChooserIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_dbus_impl_file_chooser_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-FileChooser.top_of_page">org.freedesktop.impl.portal.FileChooser</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_file_chooser_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_file_chooser_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_file_chooser_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_FILE_CHOOSER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.FileChooser", NULL);
}

/**
 * xdp_dbus_impl_file_chooser_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_file_chooser_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_file_chooser_proxy_new().
 *
 * Returns: (transfer full) (type XdpDbusImplFileChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplFileChooser *
xdp_dbus_impl_file_chooser_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_FILE_CHOOSER (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_file_chooser_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-FileChooser.top_of_page">org.freedesktop.impl.portal.FileChooser</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_file_chooser_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplFileChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplFileChooser *
xdp_dbus_impl_file_chooser_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_FILE_CHOOSER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.FileChooser", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_FILE_CHOOSER (ret);
  else
    return NULL;
}


/**
 * xdp_dbus_impl_file_chooser_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_dbus_impl_file_chooser_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_file_chooser_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_file_chooser_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_file_chooser_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_FILE_CHOOSER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.FileChooser", NULL);
}

/**
 * xdp_dbus_impl_file_chooser_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_file_chooser_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_file_chooser_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpDbusImplFileChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplFileChooser *
xdp_dbus_impl_file_chooser_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_FILE_CHOOSER (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_file_chooser_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_dbus_impl_file_chooser_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_file_chooser_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplFileChooserProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplFileChooser *
xdp_dbus_impl_file_chooser_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_FILE_CHOOSER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.FileChooser", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_FILE_CHOOSER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplFileChooserSkeleton:
 *
 * The #XdpDbusImplFileChooserSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplFileChooserSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplFileChooserSkeleton.
 */

struct _XdpDbusImplFileChooserSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_dbus_impl_file_chooser_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpDbusImplFileChooserSkeleton *skeleton = XDP_DBUS_IMPL_FILE_CHOOSER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_DBUS_IMPL_TYPE_FILE_CHOOSER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_FILE_CHOOSER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_dbus_impl_file_chooser_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplFileChooserSkeleton *skeleton = XDP_DBUS_IMPL_FILE_CHOOSER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_file_chooser_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_dbus_impl_file_chooser_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplFileChooserSkeleton *skeleton = XDP_DBUS_IMPL_FILE_CHOOSER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_file_chooser_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_dbus_impl_file_chooser_skeleton_vtable =
{
  _xdp_dbus_impl_file_chooser_skeleton_handle_method_call,
  _xdp_dbus_impl_file_chooser_skeleton_handle_get_property,
  _xdp_dbus_impl_file_chooser_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_dbus_impl_file_chooser_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_dbus_impl_file_chooser_interface_info ();
}

static GDBusInterfaceVTable *
xdp_dbus_impl_file_chooser_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_dbus_impl_file_chooser_skeleton_vtable;
}

static GVariant *
xdp_dbus_impl_file_chooser_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDbusImplFileChooserSkeleton *skeleton = XDP_DBUS_IMPL_FILE_CHOOSER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_dbus_impl_file_chooser_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_dbus_impl_file_chooser_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_dbus_impl_file_chooser_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_dbus_impl_file_chooser_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.FileChooser", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_dbus_impl_file_chooser_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void xdp_dbus_impl_file_chooser_skeleton_iface_init (XdpDbusImplFileChooserIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplFileChooserSkeleton, xdp_dbus_impl_file_chooser_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpDbusImplFileChooserSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_FILE_CHOOSER, xdp_dbus_impl_file_chooser_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplFileChooserSkeleton, xdp_dbus_impl_file_chooser_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_FILE_CHOOSER, xdp_dbus_impl_file_chooser_skeleton_iface_init))

#endif
static void
xdp_dbus_impl_file_chooser_skeleton_finalize (GObject *object)
{
  XdpDbusImplFileChooserSkeleton *skeleton = XDP_DBUS_IMPL_FILE_CHOOSER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_dbus_impl_file_chooser_skeleton_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_file_chooser_skeleton_init (XdpDbusImplFileChooserSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_dbus_impl_file_chooser_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_DBUS_IMPL_TYPE_FILE_CHOOSER_SKELETON, XdpDbusImplFileChooserSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_dbus_impl_file_chooser_skeleton_class_init (XdpDbusImplFileChooserSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_dbus_impl_file_chooser_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_dbus_impl_file_chooser_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_dbus_impl_file_chooser_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_dbus_impl_file_chooser_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_dbus_impl_file_chooser_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplFileChooserSkeletonPrivate));
#endif
}

static void
xdp_dbus_impl_file_chooser_skeleton_iface_init (XdpDbusImplFileChooserIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_dbus_impl_file_chooser_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-FileChooser.top_of_page">org.freedesktop.impl.portal.FileChooser</link>.
 *
 * Returns: (transfer full) (type XdpDbusImplFileChooserSkeleton): The skeleton object.
 */
XdpDbusImplFileChooser *
xdp_dbus_impl_file_chooser_skeleton_new (void)
{
  return XDP_DBUS_IMPL_FILE_CHOOSER (g_object_new (XDP_DBUS_IMPL_TYPE_FILE_CHOOSER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Inhibit
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpDbusImplInhibit
 * @title: XdpDbusImplInhibit
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Inhibit D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Inhibit.top_of_page">org.freedesktop.impl.portal.Inhibit</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Inhibit ---- */

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_inhibit_method_info_inhibit_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_inhibit_method_info_inhibit_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_inhibit_method_info_inhibit_IN_ARG_window =
{
  {
    -1,
    (gchar *) "window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_inhibit_method_info_inhibit_IN_ARG_flags =
{
  {
    -1,
    (gchar *) "flags",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_inhibit_method_info_inhibit_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_inhibit_method_info_inhibit_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_inhibit_method_info_inhibit_IN_ARG_handle.parent_struct,
  &_xdp_dbus_impl_inhibit_method_info_inhibit_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_inhibit_method_info_inhibit_IN_ARG_window.parent_struct,
  &_xdp_dbus_impl_inhibit_method_info_inhibit_IN_ARG_flags.parent_struct,
  &_xdp_dbus_impl_inhibit_method_info_inhibit_IN_ARG_options.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_inhibit_method_inhibit_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In4",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_dbus_impl_inhibit_method_inhibit_annotation_info_pointers[] =
{
  &_xdp_dbus_impl_inhibit_method_inhibit_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_inhibit_method_info_inhibit =
{
  {
    -1,
    (gchar *) "Inhibit",
    (GDBusArgInfo **) &_xdp_dbus_impl_inhibit_method_info_inhibit_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_xdp_dbus_impl_inhibit_method_inhibit_annotation_info_pointers
  },
  "handle-inhibit",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_inhibit_method_info_create_monitor_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_inhibit_method_info_create_monitor_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_inhibit_method_info_create_monitor_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_inhibit_method_info_create_monitor_IN_ARG_window =
{
  {
    -1,
    (gchar *) "window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_inhibit_method_info_create_monitor_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_inhibit_method_info_create_monitor_IN_ARG_handle.parent_struct,
  &_xdp_dbus_impl_inhibit_method_info_create_monitor_IN_ARG_session_handle.parent_struct,
  &_xdp_dbus_impl_inhibit_method_info_create_monitor_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_inhibit_method_info_create_monitor_IN_ARG_window.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_inhibit_method_info_create_monitor_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_inhibit_method_info_create_monitor_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_inhibit_method_info_create_monitor_OUT_ARG_response.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_inhibit_method_info_create_monitor =
{
  {
    -1,
    (gchar *) "CreateMonitor",
    (GDBusArgInfo **) &_xdp_dbus_impl_inhibit_method_info_create_monitor_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_inhibit_method_info_create_monitor_OUT_ARG_pointers,
    NULL
  },
  "handle-create-monitor",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_inhibit_method_info_query_end_response_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_inhibit_method_info_query_end_response_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_inhibit_method_info_query_end_response_IN_ARG_session_handle.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_inhibit_method_info_query_end_response =
{
  {
    -1,
    (gchar *) "QueryEndResponse",
    (GDBusArgInfo **) &_xdp_dbus_impl_inhibit_method_info_query_end_response_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-query-end-response",
  FALSE
};

static const GDBusMethodInfo * const _xdp_dbus_impl_inhibit_method_info_pointers[] =
{
  &_xdp_dbus_impl_inhibit_method_info_inhibit.parent_struct,
  &_xdp_dbus_impl_inhibit_method_info_create_monitor.parent_struct,
  &_xdp_dbus_impl_inhibit_method_info_query_end_response.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_inhibit_signal_info_state_changed_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_inhibit_signal_info_state_changed_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_inhibit_signal_info_state_changed_ARG_pointers[] =
{
  &_xdp_dbus_impl_inhibit_signal_info_state_changed_ARG_session_handle.parent_struct,
  &_xdp_dbus_impl_inhibit_signal_info_state_changed_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xdp_dbus_impl_inhibit_signal_info_state_changed =
{
  {
    -1,
    (gchar *) "StateChanged",
    (GDBusArgInfo **) &_xdp_dbus_impl_inhibit_signal_info_state_changed_ARG_pointers,
    NULL
  },
  "state-changed"
};

static const GDBusSignalInfo * const _xdp_dbus_impl_inhibit_signal_info_pointers[] =
{
  &_xdp_dbus_impl_inhibit_signal_info_state_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_dbus_impl_inhibit_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Inhibit",
    (GDBusMethodInfo **) &_xdp_dbus_impl_inhibit_method_info_pointers,
    (GDBusSignalInfo **) &_xdp_dbus_impl_inhibit_signal_info_pointers,
    NULL,
    NULL
  },
  "inhibit",
};


/**
 * xdp_dbus_impl_inhibit_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Inhibit.top_of_page">org.freedesktop.impl.portal.Inhibit</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_dbus_impl_inhibit_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_dbus_impl_inhibit_interface_info.parent_struct;
}

/**
 * xdp_dbus_impl_inhibit_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpDbusImplInhibit interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_dbus_impl_inhibit_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XdpDbusImplInhibit:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Inhibit.top_of_page">org.freedesktop.impl.portal.Inhibit</link>.
 */

/**
 * XdpDbusImplInhibitIface:
 * @parent_iface: The parent interface.
 * @handle_create_monitor: Handler for the #XdpDbusImplInhibit::handle-create-monitor signal.
 * @handle_inhibit: Handler for the #XdpDbusImplInhibit::handle-inhibit signal.
 * @handle_query_end_response: Handler for the #XdpDbusImplInhibit::handle-query-end-response signal.
 * @state_changed: Handler for the #XdpDbusImplInhibit::state-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Inhibit.top_of_page">org.freedesktop.impl.portal.Inhibit</link>.
 */

typedef XdpDbusImplInhibitIface XdpDbusImplInhibitInterface;
G_DEFINE_INTERFACE (XdpDbusImplInhibit, xdp_dbus_impl_inhibit, G_TYPE_OBJECT)

static void
xdp_dbus_impl_inhibit_default_init (XdpDbusImplInhibitIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpDbusImplInhibit::handle-inhibit:
   * @object: A #XdpDbusImplInhibit.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_window: Argument passed by remote caller.
   * @arg_flags: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.Inhibit">Inhibit()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_inhibit_complete_inhibit() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-inhibit",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplInhibitIface, handle_inhibit),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_VARIANT);

  /**
   * XdpDbusImplInhibit::handle-create-monitor:
   * @object: A #XdpDbusImplInhibit.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_window: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.CreateMonitor">CreateMonitor()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_inhibit_complete_create_monitor() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-monitor",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplInhibitIface, handle_create_monitor),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XdpDbusImplInhibit::handle-query-end-response:
   * @object: A #XdpDbusImplInhibit.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.QueryEndResponse">QueryEndResponse()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_inhibit_complete_query_end_response() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-query-end-response",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplInhibitIface, handle_query_end_response),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * XdpDbusImplInhibit::state-changed:
   * @object: A #XdpDbusImplInhibit.
   * @arg_session_handle: Argument.
   * @arg_state: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-impl-portal-Inhibit.StateChanged">"StateChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("state-changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplInhibitIface, state_changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * xdp_dbus_impl_inhibit_emit_state_changed:
 * @object: A #XdpDbusImplInhibit.
 * @arg_session_handle: Argument to pass with the signal.
 * @arg_state: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-impl-portal-Inhibit.StateChanged">"StateChanged"</link> D-Bus signal.
 */
void
xdp_dbus_impl_inhibit_emit_state_changed (
    XdpDbusImplInhibit *object,
    const gchar *arg_session_handle,
    GVariant *arg_state)
{
  g_signal_emit_by_name (object, "state-changed", arg_session_handle, arg_state);
}

/**
 * xdp_dbus_impl_inhibit_call_inhibit:
 * @proxy: A #XdpDbusImplInhibitProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_window: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.Inhibit">Inhibit()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_inhibit_call_inhibit_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_inhibit_call_inhibit_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_inhibit_call_inhibit (
    XdpDbusImplInhibit *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_window,
    guint arg_flags,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Inhibit",
    g_variant_new ("(ossu@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_window,
                   arg_flags,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_inhibit_call_inhibit_finish:
 * @proxy: A #XdpDbusImplInhibitProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_inhibit_call_inhibit().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_inhibit_call_inhibit().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_inhibit_call_inhibit_finish (
    XdpDbusImplInhibit *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_inhibit_call_inhibit_sync:
 * @proxy: A #XdpDbusImplInhibitProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_window: Argument to pass with the method invocation.
 * @arg_flags: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.Inhibit">Inhibit()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_inhibit_call_inhibit() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_inhibit_call_inhibit_sync (
    XdpDbusImplInhibit *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_window,
    guint arg_flags,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Inhibit",
    g_variant_new ("(ossu@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_window,
                   arg_flags,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_inhibit_call_create_monitor:
 * @proxy: A #XdpDbusImplInhibitProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_window: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.CreateMonitor">CreateMonitor()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_inhibit_call_create_monitor_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_inhibit_call_create_monitor_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_inhibit_call_create_monitor (
    XdpDbusImplInhibit *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    const gchar *arg_window,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateMonitor",
    g_variant_new ("(ooss)",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_window),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_inhibit_call_create_monitor_finish:
 * @proxy: A #XdpDbusImplInhibitProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_inhibit_call_create_monitor().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_inhibit_call_create_monitor().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_inhibit_call_create_monitor_finish (
    XdpDbusImplInhibit *proxy,
    guint *out_response,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_response);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_inhibit_call_create_monitor_sync:
 * @proxy: A #XdpDbusImplInhibitProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_window: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.CreateMonitor">CreateMonitor()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_inhibit_call_create_monitor() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_inhibit_call_create_monitor_sync (
    XdpDbusImplInhibit *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    const gchar *arg_window,
    guint *out_response,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateMonitor",
    g_variant_new ("(ooss)",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_window),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u)",
                 out_response);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_inhibit_call_query_end_response:
 * @proxy: A #XdpDbusImplInhibitProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.QueryEndResponse">QueryEndResponse()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_inhibit_call_query_end_response_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_inhibit_call_query_end_response_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_inhibit_call_query_end_response (
    XdpDbusImplInhibit *proxy,
    const gchar *arg_session_handle,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "QueryEndResponse",
    g_variant_new ("(o)",
                   arg_session_handle),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_inhibit_call_query_end_response_finish:
 * @proxy: A #XdpDbusImplInhibitProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_inhibit_call_query_end_response().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_inhibit_call_query_end_response().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_inhibit_call_query_end_response_finish (
    XdpDbusImplInhibit *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_inhibit_call_query_end_response_sync:
 * @proxy: A #XdpDbusImplInhibitProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.QueryEndResponse">QueryEndResponse()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_inhibit_call_query_end_response() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_inhibit_call_query_end_response_sync (
    XdpDbusImplInhibit *proxy,
    const gchar *arg_session_handle,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "QueryEndResponse",
    g_variant_new ("(o)",
                   arg_session_handle),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_inhibit_complete_inhibit:
 * @object: A #XdpDbusImplInhibit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.Inhibit">Inhibit()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_inhibit_complete_inhibit (
    XdpDbusImplInhibit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_dbus_impl_inhibit_complete_create_monitor:
 * @object: A #XdpDbusImplInhibit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.CreateMonitor">CreateMonitor()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_inhibit_complete_create_monitor (
    XdpDbusImplInhibit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u)",
                   response));
}

/**
 * xdp_dbus_impl_inhibit_complete_query_end_response:
 * @object: A #XdpDbusImplInhibit.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Inhibit.QueryEndResponse">QueryEndResponse()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_inhibit_complete_query_end_response (
    XdpDbusImplInhibit *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplInhibitProxy:
 *
 * The #XdpDbusImplInhibitProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplInhibitProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplInhibitProxy.
 */

struct _XdpDbusImplInhibitProxyPrivate
{
  GData *qdata;
};

static void xdp_dbus_impl_inhibit_proxy_iface_init (XdpDbusImplInhibitIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplInhibitProxy, xdp_dbus_impl_inhibit_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpDbusImplInhibitProxy)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_INHIBIT, xdp_dbus_impl_inhibit_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplInhibitProxy, xdp_dbus_impl_inhibit_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_INHIBIT, xdp_dbus_impl_inhibit_proxy_iface_init))

#endif
static void
xdp_dbus_impl_inhibit_proxy_finalize (GObject *object)
{
  XdpDbusImplInhibitProxy *proxy = XDP_DBUS_IMPL_INHIBIT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_dbus_impl_inhibit_proxy_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_inhibit_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_dbus_impl_inhibit_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_dbus_impl_inhibit_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_dbus_impl_inhibit_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_DBUS_IMPL_TYPE_INHIBIT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_INHIBIT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_dbus_impl_inhibit_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpDbusImplInhibitProxy *proxy = XDP_DBUS_IMPL_INHIBIT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_inhibit_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_inhibit_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_dbus_impl_inhibit_proxy_init (XdpDbusImplInhibitProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_dbus_impl_inhibit_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_DBUS_IMPL_TYPE_INHIBIT_PROXY, XdpDbusImplInhibitProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_dbus_impl_inhibit_interface_info ());
}

static void
xdp_dbus_impl_inhibit_proxy_class_init (XdpDbusImplInhibitProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_dbus_impl_inhibit_proxy_finalize;
  gobject_class->get_property = xdp_dbus_impl_inhibit_proxy_get_property;
  gobject_class->set_property = xdp_dbus_impl_inhibit_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_dbus_impl_inhibit_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_dbus_impl_inhibit_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplInhibitProxyPrivate));
#endif
}

static void
xdp_dbus_impl_inhibit_proxy_iface_init (XdpDbusImplInhibitIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_dbus_impl_inhibit_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Inhibit.top_of_page">org.freedesktop.impl.portal.Inhibit</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_inhibit_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_inhibit_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_inhibit_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_INHIBIT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Inhibit", NULL);
}

/**
 * xdp_dbus_impl_inhibit_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_inhibit_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_inhibit_proxy_new().
 *
 * Returns: (transfer full) (type XdpDbusImplInhibitProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplInhibit *
xdp_dbus_impl_inhibit_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_INHIBIT (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_inhibit_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Inhibit.top_of_page">org.freedesktop.impl.portal.Inhibit</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_inhibit_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplInhibitProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplInhibit *
xdp_dbus_impl_inhibit_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_INHIBIT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Inhibit", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_INHIBIT (ret);
  else
    return NULL;
}


/**
 * xdp_dbus_impl_inhibit_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_dbus_impl_inhibit_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_inhibit_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_inhibit_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_inhibit_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_INHIBIT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Inhibit", NULL);
}

/**
 * xdp_dbus_impl_inhibit_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_inhibit_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_inhibit_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpDbusImplInhibitProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplInhibit *
xdp_dbus_impl_inhibit_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_INHIBIT (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_inhibit_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_dbus_impl_inhibit_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_inhibit_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplInhibitProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplInhibit *
xdp_dbus_impl_inhibit_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_INHIBIT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Inhibit", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_INHIBIT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplInhibitSkeleton:
 *
 * The #XdpDbusImplInhibitSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplInhibitSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplInhibitSkeleton.
 */

struct _XdpDbusImplInhibitSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_dbus_impl_inhibit_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpDbusImplInhibitSkeleton *skeleton = XDP_DBUS_IMPL_INHIBIT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_DBUS_IMPL_TYPE_INHIBIT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_INHIBIT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_dbus_impl_inhibit_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplInhibitSkeleton *skeleton = XDP_DBUS_IMPL_INHIBIT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_inhibit_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_dbus_impl_inhibit_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplInhibitSkeleton *skeleton = XDP_DBUS_IMPL_INHIBIT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_inhibit_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_dbus_impl_inhibit_skeleton_vtable =
{
  _xdp_dbus_impl_inhibit_skeleton_handle_method_call,
  _xdp_dbus_impl_inhibit_skeleton_handle_get_property,
  _xdp_dbus_impl_inhibit_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_dbus_impl_inhibit_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_dbus_impl_inhibit_interface_info ();
}

static GDBusInterfaceVTable *
xdp_dbus_impl_inhibit_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_dbus_impl_inhibit_skeleton_vtable;
}

static GVariant *
xdp_dbus_impl_inhibit_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDbusImplInhibitSkeleton *skeleton = XDP_DBUS_IMPL_INHIBIT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_dbus_impl_inhibit_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_dbus_impl_inhibit_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_dbus_impl_inhibit_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_dbus_impl_inhibit_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Inhibit", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_dbus_impl_inhibit_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_xdp_dbus_impl_inhibit_on_signal_state_changed (
    XdpDbusImplInhibit *object,
    const gchar *arg_session_handle,
    GVariant *arg_state)
{
  XdpDbusImplInhibitSkeleton *skeleton = XDP_DBUS_IMPL_INHIBIT_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o@a{sv})",
                   arg_session_handle,
                   arg_state));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Inhibit", "StateChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void xdp_dbus_impl_inhibit_skeleton_iface_init (XdpDbusImplInhibitIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplInhibitSkeleton, xdp_dbus_impl_inhibit_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpDbusImplInhibitSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_INHIBIT, xdp_dbus_impl_inhibit_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplInhibitSkeleton, xdp_dbus_impl_inhibit_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_INHIBIT, xdp_dbus_impl_inhibit_skeleton_iface_init))

#endif
static void
xdp_dbus_impl_inhibit_skeleton_finalize (GObject *object)
{
  XdpDbusImplInhibitSkeleton *skeleton = XDP_DBUS_IMPL_INHIBIT_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_dbus_impl_inhibit_skeleton_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_inhibit_skeleton_init (XdpDbusImplInhibitSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_dbus_impl_inhibit_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_DBUS_IMPL_TYPE_INHIBIT_SKELETON, XdpDbusImplInhibitSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_dbus_impl_inhibit_skeleton_class_init (XdpDbusImplInhibitSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_dbus_impl_inhibit_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_dbus_impl_inhibit_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_dbus_impl_inhibit_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_dbus_impl_inhibit_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_dbus_impl_inhibit_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplInhibitSkeletonPrivate));
#endif
}

static void
xdp_dbus_impl_inhibit_skeleton_iface_init (XdpDbusImplInhibitIface *iface)
{
  iface->state_changed = _xdp_dbus_impl_inhibit_on_signal_state_changed;
}

/**
 * xdp_dbus_impl_inhibit_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Inhibit.top_of_page">org.freedesktop.impl.portal.Inhibit</link>.
 *
 * Returns: (transfer full) (type XdpDbusImplInhibitSkeleton): The skeleton object.
 */
XdpDbusImplInhibit *
xdp_dbus_impl_inhibit_skeleton_new (void)
{
  return XDP_DBUS_IMPL_INHIBIT (g_object_new (XDP_DBUS_IMPL_TYPE_INHIBIT_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Lockdown
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpDbusImplLockdown
 * @title: XdpDbusImplLockdown
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Lockdown D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Lockdown.top_of_page">org.freedesktop.impl.portal.Lockdown</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Lockdown ---- */

static const _ExtendedGDBusPropertyInfo _xdp_dbus_impl_lockdown_property_info_disable_printing =
{
  {
    -1,
    (gchar *) "disable-printing",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "disable-printing",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_dbus_impl_lockdown_property_info_disable_save_to_disk =
{
  {
    -1,
    (gchar *) "disable-save-to-disk",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "disable-save-to-disk",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_dbus_impl_lockdown_property_info_disable_application_handlers =
{
  {
    -1,
    (gchar *) "disable-application-handlers",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "disable-application-handlers",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_dbus_impl_lockdown_property_info_disable_location =
{
  {
    -1,
    (gchar *) "disable-location",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "disable-location",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_dbus_impl_lockdown_property_info_disable_camera =
{
  {
    -1,
    (gchar *) "disable-camera",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "disable-camera",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_dbus_impl_lockdown_property_info_disable_microphone =
{
  {
    -1,
    (gchar *) "disable-microphone",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "disable-microphone",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_dbus_impl_lockdown_property_info_disable_sound_output =
{
  {
    -1,
    (gchar *) "disable-sound-output",
    (gchar *) "b",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE,
    NULL
  },
  "disable-sound-output",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_dbus_impl_lockdown_property_info_pointers[] =
{
  &_xdp_dbus_impl_lockdown_property_info_disable_printing.parent_struct,
  &_xdp_dbus_impl_lockdown_property_info_disable_save_to_disk.parent_struct,
  &_xdp_dbus_impl_lockdown_property_info_disable_application_handlers.parent_struct,
  &_xdp_dbus_impl_lockdown_property_info_disable_location.parent_struct,
  &_xdp_dbus_impl_lockdown_property_info_disable_camera.parent_struct,
  &_xdp_dbus_impl_lockdown_property_info_disable_microphone.parent_struct,
  &_xdp_dbus_impl_lockdown_property_info_disable_sound_output.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_dbus_impl_lockdown_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Lockdown",
    NULL,
    NULL,
    (GDBusPropertyInfo **) &_xdp_dbus_impl_lockdown_property_info_pointers,
    NULL
  },
  "lockdown",
};


/**
 * xdp_dbus_impl_lockdown_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Lockdown.top_of_page">org.freedesktop.impl.portal.Lockdown</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_dbus_impl_lockdown_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_dbus_impl_lockdown_interface_info.parent_struct;
}

/**
 * xdp_dbus_impl_lockdown_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpDbusImplLockdown interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_dbus_impl_lockdown_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "disable-printing");
  g_object_class_override_property (klass, property_id_begin++, "disable-save-to-disk");
  g_object_class_override_property (klass, property_id_begin++, "disable-application-handlers");
  g_object_class_override_property (klass, property_id_begin++, "disable-location");
  g_object_class_override_property (klass, property_id_begin++, "disable-camera");
  g_object_class_override_property (klass, property_id_begin++, "disable-microphone");
  g_object_class_override_property (klass, property_id_begin++, "disable-sound-output");
  return property_id_begin - 1;
}



/**
 * XdpDbusImplLockdown:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Lockdown.top_of_page">org.freedesktop.impl.portal.Lockdown</link>.
 */

/**
 * XdpDbusImplLockdownIface:
 * @parent_iface: The parent interface.
 * @get_disable_application_handlers: Getter for the #XdpDbusImplLockdown:disable-application-handlers property.
 * @get_disable_camera: Getter for the #XdpDbusImplLockdown:disable-camera property.
 * @get_disable_location: Getter for the #XdpDbusImplLockdown:disable-location property.
 * @get_disable_microphone: Getter for the #XdpDbusImplLockdown:disable-microphone property.
 * @get_disable_printing: Getter for the #XdpDbusImplLockdown:disable-printing property.
 * @get_disable_save_to_disk: Getter for the #XdpDbusImplLockdown:disable-save-to-disk property.
 * @get_disable_sound_output: Getter for the #XdpDbusImplLockdown:disable-sound-output property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Lockdown.top_of_page">org.freedesktop.impl.portal.Lockdown</link>.
 */

typedef XdpDbusImplLockdownIface XdpDbusImplLockdownInterface;
G_DEFINE_INTERFACE (XdpDbusImplLockdown, xdp_dbus_impl_lockdown, G_TYPE_OBJECT)

static void
xdp_dbus_impl_lockdown_default_init (XdpDbusImplLockdownIface *iface)
{
  /* GObject properties for D-Bus properties: */
  /**
   * XdpDbusImplLockdown:disable-printing:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-printing">"disable-printing"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("disable-printing", "disable-printing", "disable-printing", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpDbusImplLockdown:disable-save-to-disk:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-save-to-disk">"disable-save-to-disk"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("disable-save-to-disk", "disable-save-to-disk", "disable-save-to-disk", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpDbusImplLockdown:disable-application-handlers:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-application-handlers">"disable-application-handlers"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("disable-application-handlers", "disable-application-handlers", "disable-application-handlers", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpDbusImplLockdown:disable-location:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-location">"disable-location"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("disable-location", "disable-location", "disable-location", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpDbusImplLockdown:disable-camera:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-camera">"disable-camera"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("disable-camera", "disable-camera", "disable-camera", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpDbusImplLockdown:disable-microphone:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-microphone">"disable-microphone"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("disable-microphone", "disable-microphone", "disable-microphone", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpDbusImplLockdown:disable-sound-output:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-sound-output">"disable-sound-output"</link>.
   *
   * Since the D-Bus property for this #GObject property is both readable and writable, it is meaningful to both read from it and write to it on both the service- and client-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boolean ("disable-sound-output", "disable-sound-output", "disable-sound-output", FALSE, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_dbus_impl_lockdown_get_disable_printing: (skip)
 * @object: A #XdpDbusImplLockdown.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-printing">"disable-printing"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xdp_dbus_impl_lockdown_get_disable_printing (XdpDbusImplLockdown *object)
{
  return XDP_DBUS_IMPL_LOCKDOWN_GET_IFACE (object)->get_disable_printing (object);
}

/**
 * xdp_dbus_impl_lockdown_set_disable_printing: (skip)
 * @object: A #XdpDbusImplLockdown.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-printing">"disable-printing"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
xdp_dbus_impl_lockdown_set_disable_printing (XdpDbusImplLockdown *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "disable-printing", value, NULL);
}

/**
 * xdp_dbus_impl_lockdown_get_disable_save_to_disk: (skip)
 * @object: A #XdpDbusImplLockdown.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-save-to-disk">"disable-save-to-disk"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xdp_dbus_impl_lockdown_get_disable_save_to_disk (XdpDbusImplLockdown *object)
{
  return XDP_DBUS_IMPL_LOCKDOWN_GET_IFACE (object)->get_disable_save_to_disk (object);
}

/**
 * xdp_dbus_impl_lockdown_set_disable_save_to_disk: (skip)
 * @object: A #XdpDbusImplLockdown.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-save-to-disk">"disable-save-to-disk"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
xdp_dbus_impl_lockdown_set_disable_save_to_disk (XdpDbusImplLockdown *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "disable-save-to-disk", value, NULL);
}

/**
 * xdp_dbus_impl_lockdown_get_disable_application_handlers: (skip)
 * @object: A #XdpDbusImplLockdown.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-application-handlers">"disable-application-handlers"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xdp_dbus_impl_lockdown_get_disable_application_handlers (XdpDbusImplLockdown *object)
{
  return XDP_DBUS_IMPL_LOCKDOWN_GET_IFACE (object)->get_disable_application_handlers (object);
}

/**
 * xdp_dbus_impl_lockdown_set_disable_application_handlers: (skip)
 * @object: A #XdpDbusImplLockdown.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-application-handlers">"disable-application-handlers"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
xdp_dbus_impl_lockdown_set_disable_application_handlers (XdpDbusImplLockdown *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "disable-application-handlers", value, NULL);
}

/**
 * xdp_dbus_impl_lockdown_get_disable_location: (skip)
 * @object: A #XdpDbusImplLockdown.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-location">"disable-location"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xdp_dbus_impl_lockdown_get_disable_location (XdpDbusImplLockdown *object)
{
  return XDP_DBUS_IMPL_LOCKDOWN_GET_IFACE (object)->get_disable_location (object);
}

/**
 * xdp_dbus_impl_lockdown_set_disable_location: (skip)
 * @object: A #XdpDbusImplLockdown.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-location">"disable-location"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
xdp_dbus_impl_lockdown_set_disable_location (XdpDbusImplLockdown *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "disable-location", value, NULL);
}

/**
 * xdp_dbus_impl_lockdown_get_disable_camera: (skip)
 * @object: A #XdpDbusImplLockdown.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-camera">"disable-camera"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xdp_dbus_impl_lockdown_get_disable_camera (XdpDbusImplLockdown *object)
{
  return XDP_DBUS_IMPL_LOCKDOWN_GET_IFACE (object)->get_disable_camera (object);
}

/**
 * xdp_dbus_impl_lockdown_set_disable_camera: (skip)
 * @object: A #XdpDbusImplLockdown.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-camera">"disable-camera"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
xdp_dbus_impl_lockdown_set_disable_camera (XdpDbusImplLockdown *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "disable-camera", value, NULL);
}

/**
 * xdp_dbus_impl_lockdown_get_disable_microphone: (skip)
 * @object: A #XdpDbusImplLockdown.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-microphone">"disable-microphone"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xdp_dbus_impl_lockdown_get_disable_microphone (XdpDbusImplLockdown *object)
{
  return XDP_DBUS_IMPL_LOCKDOWN_GET_IFACE (object)->get_disable_microphone (object);
}

/**
 * xdp_dbus_impl_lockdown_set_disable_microphone: (skip)
 * @object: A #XdpDbusImplLockdown.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-microphone">"disable-microphone"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
xdp_dbus_impl_lockdown_set_disable_microphone (XdpDbusImplLockdown *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "disable-microphone", value, NULL);
}

/**
 * xdp_dbus_impl_lockdown_get_disable_sound_output: (skip)
 * @object: A #XdpDbusImplLockdown.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-sound-output">"disable-sound-output"</link> D-Bus property.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
gboolean 
xdp_dbus_impl_lockdown_get_disable_sound_output (XdpDbusImplLockdown *object)
{
  return XDP_DBUS_IMPL_LOCKDOWN_GET_IFACE (object)->get_disable_sound_output (object);
}

/**
 * xdp_dbus_impl_lockdown_set_disable_sound_output: (skip)
 * @object: A #XdpDbusImplLockdown.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Lockdown.disable-sound-output">"disable-sound-output"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is both readable and writable, it is meaningful to use this function on both the client- and service-side.
 */
void
xdp_dbus_impl_lockdown_set_disable_sound_output (XdpDbusImplLockdown *object, gboolean value)
{
  g_object_set (G_OBJECT (object), "disable-sound-output", value, NULL);
}

/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplLockdownProxy:
 *
 * The #XdpDbusImplLockdownProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplLockdownProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplLockdownProxy.
 */

struct _XdpDbusImplLockdownProxyPrivate
{
  GData *qdata;
};

static void xdp_dbus_impl_lockdown_proxy_iface_init (XdpDbusImplLockdownIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplLockdownProxy, xdp_dbus_impl_lockdown_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpDbusImplLockdownProxy)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_LOCKDOWN, xdp_dbus_impl_lockdown_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplLockdownProxy, xdp_dbus_impl_lockdown_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_LOCKDOWN, xdp_dbus_impl_lockdown_proxy_iface_init))

#endif
static void
xdp_dbus_impl_lockdown_proxy_finalize (GObject *object)
{
  XdpDbusImplLockdownProxy *proxy = XDP_DBUS_IMPL_LOCKDOWN_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_dbus_impl_lockdown_proxy_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_lockdown_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_dbus_impl_lockdown_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_dbus_impl_lockdown_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.impl.portal.Lockdown: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_dbus_impl_lockdown_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_dbus_impl_lockdown_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.impl.portal.Lockdown", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_dbus_impl_lockdown_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_dbus_impl_lockdown_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_dbus_impl_lockdown_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_DBUS_IMPL_TYPE_LOCKDOWN);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_LOCKDOWN);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_dbus_impl_lockdown_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpDbusImplLockdownProxy *proxy = XDP_DBUS_IMPL_LOCKDOWN_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_lockdown_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_lockdown_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static gboolean 
xdp_dbus_impl_lockdown_proxy_get_disable_printing (XdpDbusImplLockdown *object)
{
  XdpDbusImplLockdownProxy *proxy = XDP_DBUS_IMPL_LOCKDOWN_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "disable-printing");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
xdp_dbus_impl_lockdown_proxy_get_disable_save_to_disk (XdpDbusImplLockdown *object)
{
  XdpDbusImplLockdownProxy *proxy = XDP_DBUS_IMPL_LOCKDOWN_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "disable-save-to-disk");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
xdp_dbus_impl_lockdown_proxy_get_disable_application_handlers (XdpDbusImplLockdown *object)
{
  XdpDbusImplLockdownProxy *proxy = XDP_DBUS_IMPL_LOCKDOWN_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "disable-application-handlers");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
xdp_dbus_impl_lockdown_proxy_get_disable_location (XdpDbusImplLockdown *object)
{
  XdpDbusImplLockdownProxy *proxy = XDP_DBUS_IMPL_LOCKDOWN_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "disable-location");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
xdp_dbus_impl_lockdown_proxy_get_disable_camera (XdpDbusImplLockdown *object)
{
  XdpDbusImplLockdownProxy *proxy = XDP_DBUS_IMPL_LOCKDOWN_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "disable-camera");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
xdp_dbus_impl_lockdown_proxy_get_disable_microphone (XdpDbusImplLockdown *object)
{
  XdpDbusImplLockdownProxy *proxy = XDP_DBUS_IMPL_LOCKDOWN_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "disable-microphone");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static gboolean 
xdp_dbus_impl_lockdown_proxy_get_disable_sound_output (XdpDbusImplLockdown *object)
{
  XdpDbusImplLockdownProxy *proxy = XDP_DBUS_IMPL_LOCKDOWN_PROXY (object);
  GVariant *variant;
  gboolean value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "disable-sound-output");
  if (variant != NULL)
    {
      value = g_variant_get_boolean (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_dbus_impl_lockdown_proxy_init (XdpDbusImplLockdownProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_dbus_impl_lockdown_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_DBUS_IMPL_TYPE_LOCKDOWN_PROXY, XdpDbusImplLockdownProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_dbus_impl_lockdown_interface_info ());
}

static void
xdp_dbus_impl_lockdown_proxy_class_init (XdpDbusImplLockdownProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_dbus_impl_lockdown_proxy_finalize;
  gobject_class->get_property = xdp_dbus_impl_lockdown_proxy_get_property;
  gobject_class->set_property = xdp_dbus_impl_lockdown_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_dbus_impl_lockdown_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_dbus_impl_lockdown_proxy_g_properties_changed;

  xdp_dbus_impl_lockdown_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplLockdownProxyPrivate));
#endif
}

static void
xdp_dbus_impl_lockdown_proxy_iface_init (XdpDbusImplLockdownIface *iface)
{
  iface->get_disable_printing = xdp_dbus_impl_lockdown_proxy_get_disable_printing;
  iface->get_disable_save_to_disk = xdp_dbus_impl_lockdown_proxy_get_disable_save_to_disk;
  iface->get_disable_application_handlers = xdp_dbus_impl_lockdown_proxy_get_disable_application_handlers;
  iface->get_disable_location = xdp_dbus_impl_lockdown_proxy_get_disable_location;
  iface->get_disable_camera = xdp_dbus_impl_lockdown_proxy_get_disable_camera;
  iface->get_disable_microphone = xdp_dbus_impl_lockdown_proxy_get_disable_microphone;
  iface->get_disable_sound_output = xdp_dbus_impl_lockdown_proxy_get_disable_sound_output;
}

/**
 * xdp_dbus_impl_lockdown_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Lockdown.top_of_page">org.freedesktop.impl.portal.Lockdown</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_lockdown_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_lockdown_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_lockdown_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_LOCKDOWN_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Lockdown", NULL);
}

/**
 * xdp_dbus_impl_lockdown_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_lockdown_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_lockdown_proxy_new().
 *
 * Returns: (transfer full) (type XdpDbusImplLockdownProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplLockdown *
xdp_dbus_impl_lockdown_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_LOCKDOWN (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_lockdown_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Lockdown.top_of_page">org.freedesktop.impl.portal.Lockdown</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_lockdown_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplLockdownProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplLockdown *
xdp_dbus_impl_lockdown_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_LOCKDOWN_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Lockdown", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_LOCKDOWN (ret);
  else
    return NULL;
}


/**
 * xdp_dbus_impl_lockdown_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_dbus_impl_lockdown_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_lockdown_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_lockdown_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_lockdown_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_LOCKDOWN_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Lockdown", NULL);
}

/**
 * xdp_dbus_impl_lockdown_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_lockdown_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_lockdown_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpDbusImplLockdownProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplLockdown *
xdp_dbus_impl_lockdown_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_LOCKDOWN (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_lockdown_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_dbus_impl_lockdown_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_lockdown_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplLockdownProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplLockdown *
xdp_dbus_impl_lockdown_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_LOCKDOWN_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Lockdown", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_LOCKDOWN (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplLockdownSkeleton:
 *
 * The #XdpDbusImplLockdownSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplLockdownSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplLockdownSkeleton.
 */

struct _XdpDbusImplLockdownSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_dbus_impl_lockdown_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpDbusImplLockdownSkeleton *skeleton = XDP_DBUS_IMPL_LOCKDOWN_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_DBUS_IMPL_TYPE_LOCKDOWN);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_LOCKDOWN);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_dbus_impl_lockdown_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplLockdownSkeleton *skeleton = XDP_DBUS_IMPL_LOCKDOWN_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_lockdown_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_dbus_impl_lockdown_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplLockdownSkeleton *skeleton = XDP_DBUS_IMPL_LOCKDOWN_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_lockdown_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_dbus_impl_lockdown_skeleton_vtable =
{
  _xdp_dbus_impl_lockdown_skeleton_handle_method_call,
  _xdp_dbus_impl_lockdown_skeleton_handle_get_property,
  _xdp_dbus_impl_lockdown_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_dbus_impl_lockdown_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_dbus_impl_lockdown_interface_info ();
}

static GDBusInterfaceVTable *
xdp_dbus_impl_lockdown_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_dbus_impl_lockdown_skeleton_vtable;
}

static GVariant *
xdp_dbus_impl_lockdown_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDbusImplLockdownSkeleton *skeleton = XDP_DBUS_IMPL_LOCKDOWN_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_dbus_impl_lockdown_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_dbus_impl_lockdown_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_dbus_impl_lockdown_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_dbus_impl_lockdown_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Lockdown", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_dbus_impl_lockdown_emit_changed (gpointer user_data);

static void
xdp_dbus_impl_lockdown_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDbusImplLockdownSkeleton *skeleton = XDP_DBUS_IMPL_LOCKDOWN_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_dbus_impl_lockdown_emit_changed (skeleton);
}

static void xdp_dbus_impl_lockdown_skeleton_iface_init (XdpDbusImplLockdownIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplLockdownSkeleton, xdp_dbus_impl_lockdown_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpDbusImplLockdownSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_LOCKDOWN, xdp_dbus_impl_lockdown_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplLockdownSkeleton, xdp_dbus_impl_lockdown_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_LOCKDOWN, xdp_dbus_impl_lockdown_skeleton_iface_init))

#endif
static void
xdp_dbus_impl_lockdown_skeleton_finalize (GObject *object)
{
  XdpDbusImplLockdownSkeleton *skeleton = XDP_DBUS_IMPL_LOCKDOWN_SKELETON (object);
  guint n;
  for (n = 0; n < 7; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_dbus_impl_lockdown_skeleton_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_lockdown_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpDbusImplLockdownSkeleton *skeleton = XDP_DBUS_IMPL_LOCKDOWN_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_dbus_impl_lockdown_emit_changed (gpointer user_data)
{
  XdpDbusImplLockdownSkeleton *skeleton = XDP_DBUS_IMPL_LOCKDOWN_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.impl.portal.Lockdown",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_dbus_impl_lockdown_schedule_emit_changed (XdpDbusImplLockdownSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_dbus_impl_lockdown_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpDbusImplLockdownSkeleton *skeleton = XDP_DBUS_IMPL_LOCKDOWN_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_dbus_impl_lockdown_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_dbus_impl_lockdown_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_dbus_impl_lockdown_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpDbusImplLockdownSkeleton *skeleton = XDP_DBUS_IMPL_LOCKDOWN_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 7);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_dbus_impl_lockdown_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_dbus_impl_lockdown_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_dbus_impl_lockdown_skeleton_init (XdpDbusImplLockdownSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_dbus_impl_lockdown_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_DBUS_IMPL_TYPE_LOCKDOWN_SKELETON, XdpDbusImplLockdownSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 7);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_BOOLEAN);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_BOOLEAN);
}

static gboolean 
xdp_dbus_impl_lockdown_skeleton_get_disable_printing (XdpDbusImplLockdown *object)
{
  XdpDbusImplLockdownSkeleton *skeleton = XDP_DBUS_IMPL_LOCKDOWN_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
xdp_dbus_impl_lockdown_skeleton_get_disable_save_to_disk (XdpDbusImplLockdown *object)
{
  XdpDbusImplLockdownSkeleton *skeleton = XDP_DBUS_IMPL_LOCKDOWN_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
xdp_dbus_impl_lockdown_skeleton_get_disable_application_handlers (XdpDbusImplLockdown *object)
{
  XdpDbusImplLockdownSkeleton *skeleton = XDP_DBUS_IMPL_LOCKDOWN_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
xdp_dbus_impl_lockdown_skeleton_get_disable_location (XdpDbusImplLockdown *object)
{
  XdpDbusImplLockdownSkeleton *skeleton = XDP_DBUS_IMPL_LOCKDOWN_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
xdp_dbus_impl_lockdown_skeleton_get_disable_camera (XdpDbusImplLockdown *object)
{
  XdpDbusImplLockdownSkeleton *skeleton = XDP_DBUS_IMPL_LOCKDOWN_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
xdp_dbus_impl_lockdown_skeleton_get_disable_microphone (XdpDbusImplLockdown *object)
{
  XdpDbusImplLockdownSkeleton *skeleton = XDP_DBUS_IMPL_LOCKDOWN_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static gboolean 
xdp_dbus_impl_lockdown_skeleton_get_disable_sound_output (XdpDbusImplLockdown *object)
{
  XdpDbusImplLockdownSkeleton *skeleton = XDP_DBUS_IMPL_LOCKDOWN_SKELETON (object);
  gboolean value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boolean (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_dbus_impl_lockdown_skeleton_class_init (XdpDbusImplLockdownSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_dbus_impl_lockdown_skeleton_finalize;
  gobject_class->get_property = xdp_dbus_impl_lockdown_skeleton_get_property;
  gobject_class->set_property = xdp_dbus_impl_lockdown_skeleton_set_property;
  gobject_class->notify       = xdp_dbus_impl_lockdown_skeleton_notify;


  xdp_dbus_impl_lockdown_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_dbus_impl_lockdown_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_dbus_impl_lockdown_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_dbus_impl_lockdown_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_dbus_impl_lockdown_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplLockdownSkeletonPrivate));
#endif
}

static void
xdp_dbus_impl_lockdown_skeleton_iface_init (XdpDbusImplLockdownIface *iface)
{
  iface->get_disable_printing = xdp_dbus_impl_lockdown_skeleton_get_disable_printing;
  iface->get_disable_save_to_disk = xdp_dbus_impl_lockdown_skeleton_get_disable_save_to_disk;
  iface->get_disable_application_handlers = xdp_dbus_impl_lockdown_skeleton_get_disable_application_handlers;
  iface->get_disable_location = xdp_dbus_impl_lockdown_skeleton_get_disable_location;
  iface->get_disable_camera = xdp_dbus_impl_lockdown_skeleton_get_disable_camera;
  iface->get_disable_microphone = xdp_dbus_impl_lockdown_skeleton_get_disable_microphone;
  iface->get_disable_sound_output = xdp_dbus_impl_lockdown_skeleton_get_disable_sound_output;
}

/**
 * xdp_dbus_impl_lockdown_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Lockdown.top_of_page">org.freedesktop.impl.portal.Lockdown</link>.
 *
 * Returns: (transfer full) (type XdpDbusImplLockdownSkeleton): The skeleton object.
 */
XdpDbusImplLockdown *
xdp_dbus_impl_lockdown_skeleton_new (void)
{
  return XDP_DBUS_IMPL_LOCKDOWN (g_object_new (XDP_DBUS_IMPL_TYPE_LOCKDOWN_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Notification
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpDbusImplNotification
 * @title: XdpDbusImplNotification
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Notification D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Notification.top_of_page">org.freedesktop.impl.portal.Notification</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Notification ---- */

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_notification_method_info_add_notification_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_notification_method_info_add_notification_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_notification_method_info_add_notification_IN_ARG_notification =
{
  {
    -1,
    (gchar *) "notification",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_notification_method_info_add_notification_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_notification_method_info_add_notification_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_notification_method_info_add_notification_IN_ARG_id.parent_struct,
  &_xdp_dbus_impl_notification_method_info_add_notification_IN_ARG_notification.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_notification_method_add_notification_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In2",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_dbus_impl_notification_method_add_notification_annotation_info_pointers[] =
{
  &_xdp_dbus_impl_notification_method_add_notification_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_notification_method_info_add_notification =
{
  {
    -1,
    (gchar *) "AddNotification",
    (GDBusArgInfo **) &_xdp_dbus_impl_notification_method_info_add_notification_IN_ARG_pointers,
    NULL,
    (GDBusAnnotationInfo **) &_xdp_dbus_impl_notification_method_add_notification_annotation_info_pointers
  },
  "handle-add-notification",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_notification_method_info_remove_notification_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_notification_method_info_remove_notification_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_notification_method_info_remove_notification_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_notification_method_info_remove_notification_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_notification_method_info_remove_notification_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_notification_method_info_remove_notification =
{
  {
    -1,
    (gchar *) "RemoveNotification",
    (GDBusArgInfo **) &_xdp_dbus_impl_notification_method_info_remove_notification_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-remove-notification",
  FALSE
};

static const GDBusMethodInfo * const _xdp_dbus_impl_notification_method_info_pointers[] =
{
  &_xdp_dbus_impl_notification_method_info_add_notification.parent_struct,
  &_xdp_dbus_impl_notification_method_info_remove_notification.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_notification_signal_info_action_invoked_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_notification_signal_info_action_invoked_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_notification_signal_info_action_invoked_ARG_action =
{
  {
    -1,
    (gchar *) "action",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_notification_signal_info_action_invoked_ARG_parameter =
{
  {
    -1,
    (gchar *) "parameter",
    (gchar *) "av",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_notification_signal_info_action_invoked_ARG_pointers[] =
{
  &_xdp_dbus_impl_notification_signal_info_action_invoked_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_notification_signal_info_action_invoked_ARG_id.parent_struct,
  &_xdp_dbus_impl_notification_signal_info_action_invoked_ARG_action.parent_struct,
  &_xdp_dbus_impl_notification_signal_info_action_invoked_ARG_parameter.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xdp_dbus_impl_notification_signal_info_action_invoked =
{
  {
    -1,
    (gchar *) "ActionInvoked",
    (GDBusArgInfo **) &_xdp_dbus_impl_notification_signal_info_action_invoked_ARG_pointers,
    NULL
  },
  "action-invoked"
};

static const GDBusSignalInfo * const _xdp_dbus_impl_notification_signal_info_pointers[] =
{
  &_xdp_dbus_impl_notification_signal_info_action_invoked.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_dbus_impl_notification_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Notification",
    (GDBusMethodInfo **) &_xdp_dbus_impl_notification_method_info_pointers,
    (GDBusSignalInfo **) &_xdp_dbus_impl_notification_signal_info_pointers,
    NULL,
    NULL
  },
  "notification",
};


/**
 * xdp_dbus_impl_notification_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Notification.top_of_page">org.freedesktop.impl.portal.Notification</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_dbus_impl_notification_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_dbus_impl_notification_interface_info.parent_struct;
}

/**
 * xdp_dbus_impl_notification_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpDbusImplNotification interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_dbus_impl_notification_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XdpDbusImplNotification:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Notification.top_of_page">org.freedesktop.impl.portal.Notification</link>.
 */

/**
 * XdpDbusImplNotificationIface:
 * @parent_iface: The parent interface.
 * @handle_add_notification: Handler for the #XdpDbusImplNotification::handle-add-notification signal.
 * @handle_remove_notification: Handler for the #XdpDbusImplNotification::handle-remove-notification signal.
 * @action_invoked: Handler for the #XdpDbusImplNotification::action-invoked signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Notification.top_of_page">org.freedesktop.impl.portal.Notification</link>.
 */

typedef XdpDbusImplNotificationIface XdpDbusImplNotificationInterface;
G_DEFINE_INTERFACE (XdpDbusImplNotification, xdp_dbus_impl_notification, G_TYPE_OBJECT)

static void
xdp_dbus_impl_notification_default_init (XdpDbusImplNotificationIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpDbusImplNotification::handle-add-notification:
   * @object: A #XdpDbusImplNotification.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   * @arg_notification: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Notification.AddNotification">AddNotification()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_notification_complete_add_notification() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-add-notification",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplNotificationIface, handle_add_notification),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpDbusImplNotification::handle-remove-notification:
   * @object: A #XdpDbusImplNotification.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Notification.RemoveNotification">RemoveNotification()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_notification_complete_remove_notification() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-remove-notification",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplNotificationIface, handle_remove_notification),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * XdpDbusImplNotification::action-invoked:
   * @object: A #XdpDbusImplNotification.
   * @arg_app_id: Argument.
   * @arg_id: Argument.
   * @arg_action: Argument.
   * @arg_parameter: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-impl-portal-Notification.ActionInvoked">"ActionInvoked"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("action-invoked",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplNotificationIface, action_invoked),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * xdp_dbus_impl_notification_emit_action_invoked:
 * @object: A #XdpDbusImplNotification.
 * @arg_app_id: Argument to pass with the signal.
 * @arg_id: Argument to pass with the signal.
 * @arg_action: Argument to pass with the signal.
 * @arg_parameter: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-impl-portal-Notification.ActionInvoked">"ActionInvoked"</link> D-Bus signal.
 */
void
xdp_dbus_impl_notification_emit_action_invoked (
    XdpDbusImplNotification *object,
    const gchar *arg_app_id,
    const gchar *arg_id,
    const gchar *arg_action,
    GVariant *arg_parameter)
{
  g_signal_emit_by_name (object, "action-invoked", arg_app_id, arg_id, arg_action, arg_parameter);
}

/**
 * xdp_dbus_impl_notification_call_add_notification:
 * @proxy: A #XdpDbusImplNotificationProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_notification: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Notification.AddNotification">AddNotification()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_notification_call_add_notification_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_notification_call_add_notification_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_notification_call_add_notification (
    XdpDbusImplNotification *proxy,
    const gchar *arg_app_id,
    const gchar *arg_id,
    GVariant *arg_notification,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "AddNotification",
    g_variant_new ("(ss@a{sv})",
                   arg_app_id,
                   arg_id,
                   arg_notification),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_notification_call_add_notification_finish:
 * @proxy: A #XdpDbusImplNotificationProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_notification_call_add_notification().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_notification_call_add_notification().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_notification_call_add_notification_finish (
    XdpDbusImplNotification *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_notification_call_add_notification_sync:
 * @proxy: A #XdpDbusImplNotificationProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_notification: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Notification.AddNotification">AddNotification()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_notification_call_add_notification() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_notification_call_add_notification_sync (
    XdpDbusImplNotification *proxy,
    const gchar *arg_app_id,
    const gchar *arg_id,
    GVariant *arg_notification,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "AddNotification",
    g_variant_new ("(ss@a{sv})",
                   arg_app_id,
                   arg_id,
                   arg_notification),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_notification_call_remove_notification:
 * @proxy: A #XdpDbusImplNotificationProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Notification.RemoveNotification">RemoveNotification()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_notification_call_remove_notification_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_notification_call_remove_notification_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_notification_call_remove_notification (
    XdpDbusImplNotification *proxy,
    const gchar *arg_app_id,
    const gchar *arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RemoveNotification",
    g_variant_new ("(ss)",
                   arg_app_id,
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_notification_call_remove_notification_finish:
 * @proxy: A #XdpDbusImplNotificationProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_notification_call_remove_notification().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_notification_call_remove_notification().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_notification_call_remove_notification_finish (
    XdpDbusImplNotification *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_notification_call_remove_notification_sync:
 * @proxy: A #XdpDbusImplNotificationProxy.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Notification.RemoveNotification">RemoveNotification()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_notification_call_remove_notification() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_notification_call_remove_notification_sync (
    XdpDbusImplNotification *proxy,
    const gchar *arg_app_id,
    const gchar *arg_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RemoveNotification",
    g_variant_new ("(ss)",
                   arg_app_id,
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_notification_complete_add_notification:
 * @object: A #XdpDbusImplNotification.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Notification.AddNotification">AddNotification()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_notification_complete_add_notification (
    XdpDbusImplNotification *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_dbus_impl_notification_complete_remove_notification:
 * @object: A #XdpDbusImplNotification.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Notification.RemoveNotification">RemoveNotification()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_notification_complete_remove_notification (
    XdpDbusImplNotification *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplNotificationProxy:
 *
 * The #XdpDbusImplNotificationProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplNotificationProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplNotificationProxy.
 */

struct _XdpDbusImplNotificationProxyPrivate
{
  GData *qdata;
};

static void xdp_dbus_impl_notification_proxy_iface_init (XdpDbusImplNotificationIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplNotificationProxy, xdp_dbus_impl_notification_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpDbusImplNotificationProxy)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_NOTIFICATION, xdp_dbus_impl_notification_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplNotificationProxy, xdp_dbus_impl_notification_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_NOTIFICATION, xdp_dbus_impl_notification_proxy_iface_init))

#endif
static void
xdp_dbus_impl_notification_proxy_finalize (GObject *object)
{
  XdpDbusImplNotificationProxy *proxy = XDP_DBUS_IMPL_NOTIFICATION_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_dbus_impl_notification_proxy_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_notification_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_dbus_impl_notification_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_dbus_impl_notification_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_dbus_impl_notification_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_DBUS_IMPL_TYPE_NOTIFICATION);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_NOTIFICATION);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_dbus_impl_notification_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpDbusImplNotificationProxy *proxy = XDP_DBUS_IMPL_NOTIFICATION_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_notification_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_notification_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_dbus_impl_notification_proxy_init (XdpDbusImplNotificationProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_dbus_impl_notification_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_DBUS_IMPL_TYPE_NOTIFICATION_PROXY, XdpDbusImplNotificationProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_dbus_impl_notification_interface_info ());
}

static void
xdp_dbus_impl_notification_proxy_class_init (XdpDbusImplNotificationProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_dbus_impl_notification_proxy_finalize;
  gobject_class->get_property = xdp_dbus_impl_notification_proxy_get_property;
  gobject_class->set_property = xdp_dbus_impl_notification_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_dbus_impl_notification_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_dbus_impl_notification_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplNotificationProxyPrivate));
#endif
}

static void
xdp_dbus_impl_notification_proxy_iface_init (XdpDbusImplNotificationIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_dbus_impl_notification_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Notification.top_of_page">org.freedesktop.impl.portal.Notification</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_notification_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_notification_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_notification_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_NOTIFICATION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Notification", NULL);
}

/**
 * xdp_dbus_impl_notification_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_notification_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_notification_proxy_new().
 *
 * Returns: (transfer full) (type XdpDbusImplNotificationProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplNotification *
xdp_dbus_impl_notification_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_NOTIFICATION (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_notification_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Notification.top_of_page">org.freedesktop.impl.portal.Notification</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_notification_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplNotificationProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplNotification *
xdp_dbus_impl_notification_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_NOTIFICATION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Notification", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_NOTIFICATION (ret);
  else
    return NULL;
}


/**
 * xdp_dbus_impl_notification_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_dbus_impl_notification_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_notification_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_notification_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_notification_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_NOTIFICATION_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Notification", NULL);
}

/**
 * xdp_dbus_impl_notification_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_notification_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_notification_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpDbusImplNotificationProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplNotification *
xdp_dbus_impl_notification_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_NOTIFICATION (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_notification_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_dbus_impl_notification_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_notification_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplNotificationProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplNotification *
xdp_dbus_impl_notification_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_NOTIFICATION_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Notification", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_NOTIFICATION (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplNotificationSkeleton:
 *
 * The #XdpDbusImplNotificationSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplNotificationSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplNotificationSkeleton.
 */

struct _XdpDbusImplNotificationSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_dbus_impl_notification_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpDbusImplNotificationSkeleton *skeleton = XDP_DBUS_IMPL_NOTIFICATION_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_DBUS_IMPL_TYPE_NOTIFICATION);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_NOTIFICATION);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_dbus_impl_notification_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplNotificationSkeleton *skeleton = XDP_DBUS_IMPL_NOTIFICATION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_notification_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_dbus_impl_notification_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplNotificationSkeleton *skeleton = XDP_DBUS_IMPL_NOTIFICATION_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_notification_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_dbus_impl_notification_skeleton_vtable =
{
  _xdp_dbus_impl_notification_skeleton_handle_method_call,
  _xdp_dbus_impl_notification_skeleton_handle_get_property,
  _xdp_dbus_impl_notification_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_dbus_impl_notification_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_dbus_impl_notification_interface_info ();
}

static GDBusInterfaceVTable *
xdp_dbus_impl_notification_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_dbus_impl_notification_skeleton_vtable;
}

static GVariant *
xdp_dbus_impl_notification_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDbusImplNotificationSkeleton *skeleton = XDP_DBUS_IMPL_NOTIFICATION_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_dbus_impl_notification_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_dbus_impl_notification_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_dbus_impl_notification_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_dbus_impl_notification_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Notification", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_dbus_impl_notification_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_xdp_dbus_impl_notification_on_signal_action_invoked (
    XdpDbusImplNotification *object,
    const gchar *arg_app_id,
    const gchar *arg_id,
    const gchar *arg_action,
    GVariant *arg_parameter)
{
  XdpDbusImplNotificationSkeleton *skeleton = XDP_DBUS_IMPL_NOTIFICATION_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(sss@av)",
                   arg_app_id,
                   arg_id,
                   arg_action,
                   arg_parameter));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Notification", "ActionInvoked",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void xdp_dbus_impl_notification_skeleton_iface_init (XdpDbusImplNotificationIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplNotificationSkeleton, xdp_dbus_impl_notification_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpDbusImplNotificationSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_NOTIFICATION, xdp_dbus_impl_notification_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplNotificationSkeleton, xdp_dbus_impl_notification_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_NOTIFICATION, xdp_dbus_impl_notification_skeleton_iface_init))

#endif
static void
xdp_dbus_impl_notification_skeleton_finalize (GObject *object)
{
  XdpDbusImplNotificationSkeleton *skeleton = XDP_DBUS_IMPL_NOTIFICATION_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_dbus_impl_notification_skeleton_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_notification_skeleton_init (XdpDbusImplNotificationSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_dbus_impl_notification_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_DBUS_IMPL_TYPE_NOTIFICATION_SKELETON, XdpDbusImplNotificationSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_dbus_impl_notification_skeleton_class_init (XdpDbusImplNotificationSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_dbus_impl_notification_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_dbus_impl_notification_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_dbus_impl_notification_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_dbus_impl_notification_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_dbus_impl_notification_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplNotificationSkeletonPrivate));
#endif
}

static void
xdp_dbus_impl_notification_skeleton_iface_init (XdpDbusImplNotificationIface *iface)
{
  iface->action_invoked = _xdp_dbus_impl_notification_on_signal_action_invoked;
}

/**
 * xdp_dbus_impl_notification_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Notification.top_of_page">org.freedesktop.impl.portal.Notification</link>.
 *
 * Returns: (transfer full) (type XdpDbusImplNotificationSkeleton): The skeleton object.
 */
XdpDbusImplNotification *
xdp_dbus_impl_notification_skeleton_new (void)
{
  return XDP_DBUS_IMPL_NOTIFICATION (g_object_new (XDP_DBUS_IMPL_TYPE_NOTIFICATION_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.PermissionStore
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpDbusImplPermissionStore
 * @title: XdpDbusImplPermissionStore
 * @short_description: Generated C code for the org.freedesktop.impl.portal.PermissionStore D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-PermissionStore.top_of_page">org.freedesktop.impl.portal.PermissionStore</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.PermissionStore ---- */

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_lookup_IN_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_lookup_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_permission_store_method_info_lookup_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_permission_store_method_info_lookup_IN_ARG_table.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_lookup_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_lookup_OUT_ARG_permissions =
{
  {
    -1,
    (gchar *) "permissions",
    (gchar *) "a{sas}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_lookup_OUT_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_permission_store_method_info_lookup_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_permission_store_method_info_lookup_OUT_ARG_permissions.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_lookup_OUT_ARG_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_permission_store_method_info_lookup =
{
  {
    -1,
    (gchar *) "Lookup",
    (GDBusArgInfo **) &_xdp_dbus_impl_permission_store_method_info_lookup_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_permission_store_method_info_lookup_OUT_ARG_pointers,
    NULL
  },
  "handle-lookup",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_set_IN_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_set_IN_ARG_create =
{
  {
    -1,
    (gchar *) "create",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_set_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_set_IN_ARG_app_permissions =
{
  {
    -1,
    (gchar *) "app_permissions",
    (gchar *) "a{sas}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_set_IN_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_permission_store_method_info_set_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_permission_store_method_info_set_IN_ARG_table.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_set_IN_ARG_create.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_set_IN_ARG_id.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_set_IN_ARG_app_permissions.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_set_IN_ARG_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_permission_store_method_info_set =
{
  {
    -1,
    (gchar *) "Set",
    (GDBusArgInfo **) &_xdp_dbus_impl_permission_store_method_info_set_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_delete_IN_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_delete_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_permission_store_method_info_delete_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_permission_store_method_info_delete_IN_ARG_table.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_delete_IN_ARG_id.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_permission_store_method_info_delete =
{
  {
    -1,
    (gchar *) "Delete",
    (GDBusArgInfo **) &_xdp_dbus_impl_permission_store_method_info_delete_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-delete",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_set_value_IN_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_set_value_IN_ARG_create =
{
  {
    -1,
    (gchar *) "create",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_set_value_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_set_value_IN_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_permission_store_method_info_set_value_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_permission_store_method_info_set_value_IN_ARG_table.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_set_value_IN_ARG_create.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_set_value_IN_ARG_id.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_set_value_IN_ARG_data.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_permission_store_method_info_set_value =
{
  {
    -1,
    (gchar *) "SetValue",
    (GDBusArgInfo **) &_xdp_dbus_impl_permission_store_method_info_set_value_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-value",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_set_permission_IN_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_set_permission_IN_ARG_create =
{
  {
    -1,
    (gchar *) "create",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_set_permission_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_set_permission_IN_ARG_app =
{
  {
    -1,
    (gchar *) "app",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_set_permission_IN_ARG_permissions =
{
  {
    -1,
    (gchar *) "permissions",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_permission_store_method_info_set_permission_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_permission_store_method_info_set_permission_IN_ARG_table.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_set_permission_IN_ARG_create.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_set_permission_IN_ARG_id.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_set_permission_IN_ARG_app.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_set_permission_IN_ARG_permissions.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_permission_store_method_info_set_permission =
{
  {
    -1,
    (gchar *) "SetPermission",
    (GDBusArgInfo **) &_xdp_dbus_impl_permission_store_method_info_set_permission_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-permission",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_delete_permission_IN_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_delete_permission_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_delete_permission_IN_ARG_app =
{
  {
    -1,
    (gchar *) "app",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_permission_store_method_info_delete_permission_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_permission_store_method_info_delete_permission_IN_ARG_table.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_delete_permission_IN_ARG_id.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_delete_permission_IN_ARG_app.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_permission_store_method_info_delete_permission =
{
  {
    -1,
    (gchar *) "DeletePermission",
    (GDBusArgInfo **) &_xdp_dbus_impl_permission_store_method_info_delete_permission_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-delete-permission",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_get_permission_IN_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_get_permission_IN_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_get_permission_IN_ARG_app =
{
  {
    -1,
    (gchar *) "app",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_permission_store_method_info_get_permission_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_permission_store_method_info_get_permission_IN_ARG_table.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_get_permission_IN_ARG_id.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_get_permission_IN_ARG_app.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_get_permission_OUT_ARG_permissions =
{
  {
    -1,
    (gchar *) "permissions",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_permission_store_method_info_get_permission_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_permission_store_method_info_get_permission_OUT_ARG_permissions.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_permission_store_method_info_get_permission =
{
  {
    -1,
    (gchar *) "GetPermission",
    (GDBusArgInfo **) &_xdp_dbus_impl_permission_store_method_info_get_permission_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_permission_store_method_info_get_permission_OUT_ARG_pointers,
    NULL
  },
  "handle-get-permission",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_list_IN_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_permission_store_method_info_list_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_permission_store_method_info_list_IN_ARG_table.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_method_info_list_OUT_ARG_ids =
{
  {
    -1,
    (gchar *) "ids",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_permission_store_method_info_list_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_permission_store_method_info_list_OUT_ARG_ids.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_permission_store_method_info_list =
{
  {
    -1,
    (gchar *) "List",
    (GDBusArgInfo **) &_xdp_dbus_impl_permission_store_method_info_list_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_permission_store_method_info_list_OUT_ARG_pointers,
    NULL
  },
  "handle-list",
  FALSE
};

static const GDBusMethodInfo * const _xdp_dbus_impl_permission_store_method_info_pointers[] =
{
  &_xdp_dbus_impl_permission_store_method_info_lookup.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_set.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_delete.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_set_value.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_set_permission.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_delete_permission.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_get_permission.parent_struct,
  &_xdp_dbus_impl_permission_store_method_info_list.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_signal_info_changed_ARG_table =
{
  {
    -1,
    (gchar *) "table",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_signal_info_changed_ARG_id =
{
  {
    -1,
    (gchar *) "id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_signal_info_changed_ARG_deleted =
{
  {
    -1,
    (gchar *) "deleted",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_signal_info_changed_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_permission_store_signal_info_changed_ARG_permissions =
{
  {
    -1,
    (gchar *) "permissions",
    (gchar *) "a{sas}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_permission_store_signal_info_changed_ARG_pointers[] =
{
  &_xdp_dbus_impl_permission_store_signal_info_changed_ARG_table.parent_struct,
  &_xdp_dbus_impl_permission_store_signal_info_changed_ARG_id.parent_struct,
  &_xdp_dbus_impl_permission_store_signal_info_changed_ARG_deleted.parent_struct,
  &_xdp_dbus_impl_permission_store_signal_info_changed_ARG_data.parent_struct,
  &_xdp_dbus_impl_permission_store_signal_info_changed_ARG_permissions.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _xdp_dbus_impl_permission_store_signal_info_changed =
{
  {
    -1,
    (gchar *) "Changed",
    (GDBusArgInfo **) &_xdp_dbus_impl_permission_store_signal_info_changed_ARG_pointers,
    NULL
  },
  "changed"
};

static const GDBusSignalInfo * const _xdp_dbus_impl_permission_store_signal_info_pointers[] =
{
  &_xdp_dbus_impl_permission_store_signal_info_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_dbus_impl_permission_store_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_dbus_impl_permission_store_property_info_pointers[] =
{
  &_xdp_dbus_impl_permission_store_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_dbus_impl_permission_store_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.PermissionStore",
    (GDBusMethodInfo **) &_xdp_dbus_impl_permission_store_method_info_pointers,
    (GDBusSignalInfo **) &_xdp_dbus_impl_permission_store_signal_info_pointers,
    (GDBusPropertyInfo **) &_xdp_dbus_impl_permission_store_property_info_pointers,
    NULL
  },
  "permission-store",
};


/**
 * xdp_dbus_impl_permission_store_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-PermissionStore.top_of_page">org.freedesktop.impl.portal.PermissionStore</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_dbus_impl_permission_store_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_dbus_impl_permission_store_interface_info.parent_struct;
}

/**
 * xdp_dbus_impl_permission_store_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpDbusImplPermissionStore interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_dbus_impl_permission_store_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpDbusImplPermissionStore:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-PermissionStore.top_of_page">org.freedesktop.impl.portal.PermissionStore</link>.
 */

/**
 * XdpDbusImplPermissionStoreIface:
 * @parent_iface: The parent interface.
 * @handle_delete: Handler for the #XdpDbusImplPermissionStore::handle-delete signal.
 * @handle_delete_permission: Handler for the #XdpDbusImplPermissionStore::handle-delete-permission signal.
 * @handle_get_permission: Handler for the #XdpDbusImplPermissionStore::handle-get-permission signal.
 * @handle_list: Handler for the #XdpDbusImplPermissionStore::handle-list signal.
 * @handle_lookup: Handler for the #XdpDbusImplPermissionStore::handle-lookup signal.
 * @handle_set: Handler for the #XdpDbusImplPermissionStore::handle-set signal.
 * @handle_set_permission: Handler for the #XdpDbusImplPermissionStore::handle-set-permission signal.
 * @handle_set_value: Handler for the #XdpDbusImplPermissionStore::handle-set-value signal.
 * @get_version: Getter for the #XdpDbusImplPermissionStore:version property.
 * @changed: Handler for the #XdpDbusImplPermissionStore::changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-PermissionStore.top_of_page">org.freedesktop.impl.portal.PermissionStore</link>.
 */

typedef XdpDbusImplPermissionStoreIface XdpDbusImplPermissionStoreInterface;
G_DEFINE_INTERFACE (XdpDbusImplPermissionStore, xdp_dbus_impl_permission_store, G_TYPE_OBJECT)

static void
xdp_dbus_impl_permission_store_default_init (XdpDbusImplPermissionStoreIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpDbusImplPermissionStore::handle-lookup:
   * @object: A #XdpDbusImplPermissionStore.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_table: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Lookup">Lookup()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_permission_store_complete_lookup() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-lookup",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplPermissionStoreIface, handle_lookup),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XdpDbusImplPermissionStore::handle-set:
   * @object: A #XdpDbusImplPermissionStore.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_table: Argument passed by remote caller.
   * @arg_create: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   * @arg_app_permissions: Argument passed by remote caller.
   * @arg_data: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Set">Set()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_permission_store_complete_set() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplPermissionStoreIface, handle_set),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * XdpDbusImplPermissionStore::handle-delete:
   * @object: A #XdpDbusImplPermissionStore.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_table: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Delete">Delete()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_permission_store_complete_delete() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-delete",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplPermissionStoreIface, handle_delete),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XdpDbusImplPermissionStore::handle-set-value:
   * @object: A #XdpDbusImplPermissionStore.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_table: Argument passed by remote caller.
   * @arg_create: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   * @arg_data: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.SetValue">SetValue()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_permission_store_complete_set_value() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-value",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplPermissionStoreIface, handle_set_value),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpDbusImplPermissionStore::handle-set-permission:
   * @object: A #XdpDbusImplPermissionStore.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_table: Argument passed by remote caller.
   * @arg_create: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   * @arg_app: Argument passed by remote caller.
   * @arg_permissions: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.SetPermission">SetPermission()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_permission_store_complete_set_permission() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-permission",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplPermissionStoreIface, handle_set_permission),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRV);

  /**
   * XdpDbusImplPermissionStore::handle-delete-permission:
   * @object: A #XdpDbusImplPermissionStore.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_table: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   * @arg_app: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.DeletePermission">DeletePermission()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_permission_store_complete_delete_permission() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-delete-permission",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplPermissionStoreIface, handle_delete_permission),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XdpDbusImplPermissionStore::handle-get-permission:
   * @object: A #XdpDbusImplPermissionStore.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_table: Argument passed by remote caller.
   * @arg_id: Argument passed by remote caller.
   * @arg_app: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.GetPermission">GetPermission()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_permission_store_complete_get_permission() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-permission",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplPermissionStoreIface, handle_get_permission),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * XdpDbusImplPermissionStore::handle-list:
   * @object: A #XdpDbusImplPermissionStore.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_table: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.List">List()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_permission_store_complete_list() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-list",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplPermissionStoreIface, handle_list),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /* GObject signals for received D-Bus signals: */
  /**
   * XdpDbusImplPermissionStore::changed:
   * @object: A #XdpDbusImplPermissionStore.
   * @arg_table: Argument.
   * @arg_id: Argument.
   * @arg_deleted: Argument.
   * @arg_data: Argument.
   * @arg_permissions: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-impl-portal-PermissionStore.Changed">"Changed"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("changed",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplPermissionStoreIface, changed),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    5, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpDbusImplPermissionStore:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-PermissionStore.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_dbus_impl_permission_store_get_version: (skip)
 * @object: A #XdpDbusImplPermissionStore.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-PermissionStore.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_dbus_impl_permission_store_get_version (XdpDbusImplPermissionStore *object)
{
  return XDP_DBUS_IMPL_PERMISSION_STORE_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_dbus_impl_permission_store_set_version: (skip)
 * @object: A #XdpDbusImplPermissionStore.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-PermissionStore.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_dbus_impl_permission_store_set_version (XdpDbusImplPermissionStore *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_dbus_impl_permission_store_emit_changed:
 * @object: A #XdpDbusImplPermissionStore.
 * @arg_table: Argument to pass with the signal.
 * @arg_id: Argument to pass with the signal.
 * @arg_deleted: Argument to pass with the signal.
 * @arg_data: Argument to pass with the signal.
 * @arg_permissions: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-impl-portal-PermissionStore.Changed">"Changed"</link> D-Bus signal.
 */
void
xdp_dbus_impl_permission_store_emit_changed (
    XdpDbusImplPermissionStore *object,
    const gchar *arg_table,
    const gchar *arg_id,
    gboolean arg_deleted,
    GVariant *arg_data,
    GVariant *arg_permissions)
{
  g_signal_emit_by_name (object, "changed", arg_table, arg_id, arg_deleted, arg_data, arg_permissions);
}

/**
 * xdp_dbus_impl_permission_store_call_lookup:
 * @proxy: A #XdpDbusImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Lookup">Lookup()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_permission_store_call_lookup_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_permission_store_call_lookup_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_permission_store_call_lookup (
    XdpDbusImplPermissionStore *proxy,
    const gchar *arg_table,
    const gchar *arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Lookup",
    g_variant_new ("(ss)",
                   arg_table,
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_permission_store_call_lookup_finish:
 * @proxy: A #XdpDbusImplPermissionStoreProxy.
 * @out_permissions: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_data: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_permission_store_call_lookup().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_permission_store_call_lookup().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_permission_store_call_lookup_finish (
    XdpDbusImplPermissionStore *proxy,
    GVariant **out_permissions,
    GVariant **out_data,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sas}@v)",
                 out_permissions,
                 out_data);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_permission_store_call_lookup_sync:
 * @proxy: A #XdpDbusImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @out_permissions: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_data: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Lookup">Lookup()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_permission_store_call_lookup() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_permission_store_call_lookup_sync (
    XdpDbusImplPermissionStore *proxy,
    const gchar *arg_table,
    const gchar *arg_id,
    GVariant **out_permissions,
    GVariant **out_data,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Lookup",
    g_variant_new ("(ss)",
                   arg_table,
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sas}@v)",
                 out_permissions,
                 out_data);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_permission_store_call_set:
 * @proxy: A #XdpDbusImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_create: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_app_permissions: Argument to pass with the method invocation.
 * @arg_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Set">Set()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_permission_store_call_set_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_permission_store_call_set_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_permission_store_call_set (
    XdpDbusImplPermissionStore *proxy,
    const gchar *arg_table,
    gboolean arg_create,
    const gchar *arg_id,
    GVariant *arg_app_permissions,
    GVariant *arg_data,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Set",
    g_variant_new ("(sbs@a{sas}@v)",
                   arg_table,
                   arg_create,
                   arg_id,
                   arg_app_permissions,
                   arg_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_permission_store_call_set_finish:
 * @proxy: A #XdpDbusImplPermissionStoreProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_permission_store_call_set().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_permission_store_call_set().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_permission_store_call_set_finish (
    XdpDbusImplPermissionStore *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_permission_store_call_set_sync:
 * @proxy: A #XdpDbusImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_create: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_app_permissions: Argument to pass with the method invocation.
 * @arg_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Set">Set()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_permission_store_call_set() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_permission_store_call_set_sync (
    XdpDbusImplPermissionStore *proxy,
    const gchar *arg_table,
    gboolean arg_create,
    const gchar *arg_id,
    GVariant *arg_app_permissions,
    GVariant *arg_data,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Set",
    g_variant_new ("(sbs@a{sas}@v)",
                   arg_table,
                   arg_create,
                   arg_id,
                   arg_app_permissions,
                   arg_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_permission_store_call_delete:
 * @proxy: A #XdpDbusImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Delete">Delete()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_permission_store_call_delete_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_permission_store_call_delete_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_permission_store_call_delete (
    XdpDbusImplPermissionStore *proxy,
    const gchar *arg_table,
    const gchar *arg_id,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("(ss)",
                   arg_table,
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_permission_store_call_delete_finish:
 * @proxy: A #XdpDbusImplPermissionStoreProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_permission_store_call_delete().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_permission_store_call_delete().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_permission_store_call_delete_finish (
    XdpDbusImplPermissionStore *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_permission_store_call_delete_sync:
 * @proxy: A #XdpDbusImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Delete">Delete()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_permission_store_call_delete() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_permission_store_call_delete_sync (
    XdpDbusImplPermissionStore *proxy,
    const gchar *arg_table,
    const gchar *arg_id,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Delete",
    g_variant_new ("(ss)",
                   arg_table,
                   arg_id),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_permission_store_call_set_value:
 * @proxy: A #XdpDbusImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_create: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.SetValue">SetValue()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_permission_store_call_set_value_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_permission_store_call_set_value_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_permission_store_call_set_value (
    XdpDbusImplPermissionStore *proxy,
    const gchar *arg_table,
    gboolean arg_create,
    const gchar *arg_id,
    GVariant *arg_data,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetValue",
    g_variant_new ("(sbs@v)",
                   arg_table,
                   arg_create,
                   arg_id,
                   arg_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_permission_store_call_set_value_finish:
 * @proxy: A #XdpDbusImplPermissionStoreProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_permission_store_call_set_value().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_permission_store_call_set_value().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_permission_store_call_set_value_finish (
    XdpDbusImplPermissionStore *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_permission_store_call_set_value_sync:
 * @proxy: A #XdpDbusImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_create: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_data: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.SetValue">SetValue()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_permission_store_call_set_value() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_permission_store_call_set_value_sync (
    XdpDbusImplPermissionStore *proxy,
    const gchar *arg_table,
    gboolean arg_create,
    const gchar *arg_id,
    GVariant *arg_data,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetValue",
    g_variant_new ("(sbs@v)",
                   arg_table,
                   arg_create,
                   arg_id,
                   arg_data),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_permission_store_call_set_permission:
 * @proxy: A #XdpDbusImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_create: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_app: Argument to pass with the method invocation.
 * @arg_permissions: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.SetPermission">SetPermission()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_permission_store_call_set_permission_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_permission_store_call_set_permission_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_permission_store_call_set_permission (
    XdpDbusImplPermissionStore *proxy,
    const gchar *arg_table,
    gboolean arg_create,
    const gchar *arg_id,
    const gchar *arg_app,
    const gchar *const *arg_permissions,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetPermission",
    g_variant_new ("(sbss^as)",
                   arg_table,
                   arg_create,
                   arg_id,
                   arg_app,
                   arg_permissions),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_permission_store_call_set_permission_finish:
 * @proxy: A #XdpDbusImplPermissionStoreProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_permission_store_call_set_permission().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_permission_store_call_set_permission().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_permission_store_call_set_permission_finish (
    XdpDbusImplPermissionStore *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_permission_store_call_set_permission_sync:
 * @proxy: A #XdpDbusImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_create: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_app: Argument to pass with the method invocation.
 * @arg_permissions: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.SetPermission">SetPermission()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_permission_store_call_set_permission() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_permission_store_call_set_permission_sync (
    XdpDbusImplPermissionStore *proxy,
    const gchar *arg_table,
    gboolean arg_create,
    const gchar *arg_id,
    const gchar *arg_app,
    const gchar *const *arg_permissions,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetPermission",
    g_variant_new ("(sbss^as)",
                   arg_table,
                   arg_create,
                   arg_id,
                   arg_app,
                   arg_permissions),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_permission_store_call_delete_permission:
 * @proxy: A #XdpDbusImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_app: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.DeletePermission">DeletePermission()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_permission_store_call_delete_permission_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_permission_store_call_delete_permission_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_permission_store_call_delete_permission (
    XdpDbusImplPermissionStore *proxy,
    const gchar *arg_table,
    const gchar *arg_id,
    const gchar *arg_app,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DeletePermission",
    g_variant_new ("(sss)",
                   arg_table,
                   arg_id,
                   arg_app),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_permission_store_call_delete_permission_finish:
 * @proxy: A #XdpDbusImplPermissionStoreProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_permission_store_call_delete_permission().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_permission_store_call_delete_permission().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_permission_store_call_delete_permission_finish (
    XdpDbusImplPermissionStore *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_permission_store_call_delete_permission_sync:
 * @proxy: A #XdpDbusImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_app: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.DeletePermission">DeletePermission()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_permission_store_call_delete_permission() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_permission_store_call_delete_permission_sync (
    XdpDbusImplPermissionStore *proxy,
    const gchar *arg_table,
    const gchar *arg_id,
    const gchar *arg_app,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DeletePermission",
    g_variant_new ("(sss)",
                   arg_table,
                   arg_id,
                   arg_app),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_permission_store_call_get_permission:
 * @proxy: A #XdpDbusImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_app: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.GetPermission">GetPermission()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_permission_store_call_get_permission_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_permission_store_call_get_permission_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_permission_store_call_get_permission (
    XdpDbusImplPermissionStore *proxy,
    const gchar *arg_table,
    const gchar *arg_id,
    const gchar *arg_app,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetPermission",
    g_variant_new ("(sss)",
                   arg_table,
                   arg_id,
                   arg_app),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_permission_store_call_get_permission_finish:
 * @proxy: A #XdpDbusImplPermissionStoreProxy.
 * @out_permissions: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_permission_store_call_get_permission().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_permission_store_call_get_permission().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_permission_store_call_get_permission_finish (
    XdpDbusImplPermissionStore *proxy,
    gchar ***out_permissions,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_permissions);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_permission_store_call_get_permission_sync:
 * @proxy: A #XdpDbusImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @arg_id: Argument to pass with the method invocation.
 * @arg_app: Argument to pass with the method invocation.
 * @out_permissions: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.GetPermission">GetPermission()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_permission_store_call_get_permission() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_permission_store_call_get_permission_sync (
    XdpDbusImplPermissionStore *proxy,
    const gchar *arg_table,
    const gchar *arg_id,
    const gchar *arg_app,
    gchar ***out_permissions,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetPermission",
    g_variant_new ("(sss)",
                   arg_table,
                   arg_id,
                   arg_app),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_permissions);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_permission_store_call_list:
 * @proxy: A #XdpDbusImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.List">List()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_permission_store_call_list_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_permission_store_call_list_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_permission_store_call_list (
    XdpDbusImplPermissionStore *proxy,
    const gchar *arg_table,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "List",
    g_variant_new ("(s)",
                   arg_table),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_permission_store_call_list_finish:
 * @proxy: A #XdpDbusImplPermissionStoreProxy.
 * @out_ids: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_permission_store_call_list().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_permission_store_call_list().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_permission_store_call_list_finish (
    XdpDbusImplPermissionStore *proxy,
    gchar ***out_ids,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_ids);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_permission_store_call_list_sync:
 * @proxy: A #XdpDbusImplPermissionStoreProxy.
 * @arg_table: Argument to pass with the method invocation.
 * @out_ids: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.List">List()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_permission_store_call_list() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_permission_store_call_list_sync (
    XdpDbusImplPermissionStore *proxy,
    const gchar *arg_table,
    gchar ***out_ids,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "List",
    g_variant_new ("(s)",
                   arg_table),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as)",
                 out_ids);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_permission_store_complete_lookup:
 * @object: A #XdpDbusImplPermissionStore.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @permissions: Parameter to return.
 * @data: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Lookup">Lookup()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_permission_store_complete_lookup (
    XdpDbusImplPermissionStore *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *permissions,
    GVariant *data)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sas}@v)",
                   permissions,
                   data));
}

/**
 * xdp_dbus_impl_permission_store_complete_set:
 * @object: A #XdpDbusImplPermissionStore.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Set">Set()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_permission_store_complete_set (
    XdpDbusImplPermissionStore *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_dbus_impl_permission_store_complete_delete:
 * @object: A #XdpDbusImplPermissionStore.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.Delete">Delete()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_permission_store_complete_delete (
    XdpDbusImplPermissionStore *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_dbus_impl_permission_store_complete_set_value:
 * @object: A #XdpDbusImplPermissionStore.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.SetValue">SetValue()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_permission_store_complete_set_value (
    XdpDbusImplPermissionStore *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_dbus_impl_permission_store_complete_set_permission:
 * @object: A #XdpDbusImplPermissionStore.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.SetPermission">SetPermission()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_permission_store_complete_set_permission (
    XdpDbusImplPermissionStore *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_dbus_impl_permission_store_complete_delete_permission:
 * @object: A #XdpDbusImplPermissionStore.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.DeletePermission">DeletePermission()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_permission_store_complete_delete_permission (
    XdpDbusImplPermissionStore *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_dbus_impl_permission_store_complete_get_permission:
 * @object: A #XdpDbusImplPermissionStore.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @permissions: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.GetPermission">GetPermission()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_permission_store_complete_get_permission (
    XdpDbusImplPermissionStore *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *permissions)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   permissions));
}

/**
 * xdp_dbus_impl_permission_store_complete_list:
 * @object: A #XdpDbusImplPermissionStore.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @ids: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-PermissionStore.List">List()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_permission_store_complete_list (
    XdpDbusImplPermissionStore *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *ids)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as)",
                   ids));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplPermissionStoreProxy:
 *
 * The #XdpDbusImplPermissionStoreProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplPermissionStoreProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplPermissionStoreProxy.
 */

struct _XdpDbusImplPermissionStoreProxyPrivate
{
  GData *qdata;
};

static void xdp_dbus_impl_permission_store_proxy_iface_init (XdpDbusImplPermissionStoreIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplPermissionStoreProxy, xdp_dbus_impl_permission_store_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpDbusImplPermissionStoreProxy)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_PERMISSION_STORE, xdp_dbus_impl_permission_store_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplPermissionStoreProxy, xdp_dbus_impl_permission_store_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_PERMISSION_STORE, xdp_dbus_impl_permission_store_proxy_iface_init))

#endif
static void
xdp_dbus_impl_permission_store_proxy_finalize (GObject *object)
{
  XdpDbusImplPermissionStoreProxy *proxy = XDP_DBUS_IMPL_PERMISSION_STORE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_dbus_impl_permission_store_proxy_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_permission_store_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_dbus_impl_permission_store_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_dbus_impl_permission_store_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.impl.portal.PermissionStore: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_dbus_impl_permission_store_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_dbus_impl_permission_store_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.impl.portal.PermissionStore", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_dbus_impl_permission_store_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_dbus_impl_permission_store_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_dbus_impl_permission_store_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_DBUS_IMPL_TYPE_PERMISSION_STORE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_PERMISSION_STORE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_dbus_impl_permission_store_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpDbusImplPermissionStoreProxy *proxy = XDP_DBUS_IMPL_PERMISSION_STORE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_permission_store_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_permission_store_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_dbus_impl_permission_store_proxy_get_version (XdpDbusImplPermissionStore *object)
{
  XdpDbusImplPermissionStoreProxy *proxy = XDP_DBUS_IMPL_PERMISSION_STORE_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_dbus_impl_permission_store_proxy_init (XdpDbusImplPermissionStoreProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_dbus_impl_permission_store_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_DBUS_IMPL_TYPE_PERMISSION_STORE_PROXY, XdpDbusImplPermissionStoreProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_dbus_impl_permission_store_interface_info ());
}

static void
xdp_dbus_impl_permission_store_proxy_class_init (XdpDbusImplPermissionStoreProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_dbus_impl_permission_store_proxy_finalize;
  gobject_class->get_property = xdp_dbus_impl_permission_store_proxy_get_property;
  gobject_class->set_property = xdp_dbus_impl_permission_store_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_dbus_impl_permission_store_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_dbus_impl_permission_store_proxy_g_properties_changed;

  xdp_dbus_impl_permission_store_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplPermissionStoreProxyPrivate));
#endif
}

static void
xdp_dbus_impl_permission_store_proxy_iface_init (XdpDbusImplPermissionStoreIface *iface)
{
  iface->get_version = xdp_dbus_impl_permission_store_proxy_get_version;
}

/**
 * xdp_dbus_impl_permission_store_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-PermissionStore.top_of_page">org.freedesktop.impl.portal.PermissionStore</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_permission_store_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_permission_store_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_permission_store_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_PERMISSION_STORE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.PermissionStore", NULL);
}

/**
 * xdp_dbus_impl_permission_store_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_permission_store_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_permission_store_proxy_new().
 *
 * Returns: (transfer full) (type XdpDbusImplPermissionStoreProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplPermissionStore *
xdp_dbus_impl_permission_store_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_PERMISSION_STORE (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_permission_store_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-PermissionStore.top_of_page">org.freedesktop.impl.portal.PermissionStore</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_permission_store_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplPermissionStoreProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplPermissionStore *
xdp_dbus_impl_permission_store_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_PERMISSION_STORE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.PermissionStore", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_PERMISSION_STORE (ret);
  else
    return NULL;
}


/**
 * xdp_dbus_impl_permission_store_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_dbus_impl_permission_store_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_permission_store_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_permission_store_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_permission_store_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_PERMISSION_STORE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.PermissionStore", NULL);
}

/**
 * xdp_dbus_impl_permission_store_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_permission_store_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_permission_store_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpDbusImplPermissionStoreProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplPermissionStore *
xdp_dbus_impl_permission_store_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_PERMISSION_STORE (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_permission_store_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_dbus_impl_permission_store_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_permission_store_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplPermissionStoreProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplPermissionStore *
xdp_dbus_impl_permission_store_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_PERMISSION_STORE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.PermissionStore", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_PERMISSION_STORE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplPermissionStoreSkeleton:
 *
 * The #XdpDbusImplPermissionStoreSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplPermissionStoreSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplPermissionStoreSkeleton.
 */

struct _XdpDbusImplPermissionStoreSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_dbus_impl_permission_store_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpDbusImplPermissionStoreSkeleton *skeleton = XDP_DBUS_IMPL_PERMISSION_STORE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_DBUS_IMPL_TYPE_PERMISSION_STORE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_PERMISSION_STORE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_dbus_impl_permission_store_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplPermissionStoreSkeleton *skeleton = XDP_DBUS_IMPL_PERMISSION_STORE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_permission_store_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_dbus_impl_permission_store_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplPermissionStoreSkeleton *skeleton = XDP_DBUS_IMPL_PERMISSION_STORE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_permission_store_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_dbus_impl_permission_store_skeleton_vtable =
{
  _xdp_dbus_impl_permission_store_skeleton_handle_method_call,
  _xdp_dbus_impl_permission_store_skeleton_handle_get_property,
  _xdp_dbus_impl_permission_store_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_dbus_impl_permission_store_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_dbus_impl_permission_store_interface_info ();
}

static GDBusInterfaceVTable *
xdp_dbus_impl_permission_store_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_dbus_impl_permission_store_skeleton_vtable;
}

static GVariant *
xdp_dbus_impl_permission_store_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDbusImplPermissionStoreSkeleton *skeleton = XDP_DBUS_IMPL_PERMISSION_STORE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_dbus_impl_permission_store_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_dbus_impl_permission_store_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_dbus_impl_permission_store_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_dbus_impl_permission_store_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.PermissionStore", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_dbus_impl_permission_store_emit_changed (gpointer user_data);

static void
xdp_dbus_impl_permission_store_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDbusImplPermissionStoreSkeleton *skeleton = XDP_DBUS_IMPL_PERMISSION_STORE_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_dbus_impl_permission_store_emit_changed (skeleton);
}

static void
_xdp_dbus_impl_permission_store_on_signal_changed (
    XdpDbusImplPermissionStore *object,
    const gchar *arg_table,
    const gchar *arg_id,
    gboolean arg_deleted,
    GVariant *arg_data,
    GVariant *arg_permissions)
{
  XdpDbusImplPermissionStoreSkeleton *skeleton = XDP_DBUS_IMPL_PERMISSION_STORE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ssb@v@a{sas})",
                   arg_table,
                   arg_id,
                   arg_deleted,
                   arg_data,
                   arg_permissions));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.PermissionStore", "Changed",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void xdp_dbus_impl_permission_store_skeleton_iface_init (XdpDbusImplPermissionStoreIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplPermissionStoreSkeleton, xdp_dbus_impl_permission_store_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpDbusImplPermissionStoreSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_PERMISSION_STORE, xdp_dbus_impl_permission_store_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplPermissionStoreSkeleton, xdp_dbus_impl_permission_store_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_PERMISSION_STORE, xdp_dbus_impl_permission_store_skeleton_iface_init))

#endif
static void
xdp_dbus_impl_permission_store_skeleton_finalize (GObject *object)
{
  XdpDbusImplPermissionStoreSkeleton *skeleton = XDP_DBUS_IMPL_PERMISSION_STORE_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_dbus_impl_permission_store_skeleton_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_permission_store_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpDbusImplPermissionStoreSkeleton *skeleton = XDP_DBUS_IMPL_PERMISSION_STORE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_dbus_impl_permission_store_emit_changed (gpointer user_data)
{
  XdpDbusImplPermissionStoreSkeleton *skeleton = XDP_DBUS_IMPL_PERMISSION_STORE_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.impl.portal.PermissionStore",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_dbus_impl_permission_store_schedule_emit_changed (XdpDbusImplPermissionStoreSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_dbus_impl_permission_store_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpDbusImplPermissionStoreSkeleton *skeleton = XDP_DBUS_IMPL_PERMISSION_STORE_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_dbus_impl_permission_store_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_dbus_impl_permission_store_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_dbus_impl_permission_store_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpDbusImplPermissionStoreSkeleton *skeleton = XDP_DBUS_IMPL_PERMISSION_STORE_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_dbus_impl_permission_store_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_dbus_impl_permission_store_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_dbus_impl_permission_store_skeleton_init (XdpDbusImplPermissionStoreSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_dbus_impl_permission_store_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_DBUS_IMPL_TYPE_PERMISSION_STORE_SKELETON, XdpDbusImplPermissionStoreSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
xdp_dbus_impl_permission_store_skeleton_get_version (XdpDbusImplPermissionStore *object)
{
  XdpDbusImplPermissionStoreSkeleton *skeleton = XDP_DBUS_IMPL_PERMISSION_STORE_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_dbus_impl_permission_store_skeleton_class_init (XdpDbusImplPermissionStoreSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_dbus_impl_permission_store_skeleton_finalize;
  gobject_class->get_property = xdp_dbus_impl_permission_store_skeleton_get_property;
  gobject_class->set_property = xdp_dbus_impl_permission_store_skeleton_set_property;
  gobject_class->notify       = xdp_dbus_impl_permission_store_skeleton_notify;


  xdp_dbus_impl_permission_store_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_dbus_impl_permission_store_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_dbus_impl_permission_store_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_dbus_impl_permission_store_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_dbus_impl_permission_store_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplPermissionStoreSkeletonPrivate));
#endif
}

static void
xdp_dbus_impl_permission_store_skeleton_iface_init (XdpDbusImplPermissionStoreIface *iface)
{
  iface->changed = _xdp_dbus_impl_permission_store_on_signal_changed;
  iface->get_version = xdp_dbus_impl_permission_store_skeleton_get_version;
}

/**
 * xdp_dbus_impl_permission_store_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-PermissionStore.top_of_page">org.freedesktop.impl.portal.PermissionStore</link>.
 *
 * Returns: (transfer full) (type XdpDbusImplPermissionStoreSkeleton): The skeleton object.
 */
XdpDbusImplPermissionStore *
xdp_dbus_impl_permission_store_skeleton_new (void)
{
  return XDP_DBUS_IMPL_PERMISSION_STORE (g_object_new (XDP_DBUS_IMPL_TYPE_PERMISSION_STORE_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Print
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpDbusImplPrint
 * @title: XdpDbusImplPrint
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Print D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Print.top_of_page">org.freedesktop.impl.portal.Print</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Print ---- */

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_print_method_info_print_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_print_method_info_print_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_print_method_info_print_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_print_method_info_print_IN_ARG_title =
{
  {
    -1,
    (gchar *) "title",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_print_method_info_print_IN_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_print_method_info_print_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_print_method_info_print_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_print_method_info_print_IN_ARG_handle.parent_struct,
  &_xdp_dbus_impl_print_method_info_print_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_print_method_info_print_IN_ARG_parent_window.parent_struct,
  &_xdp_dbus_impl_print_method_info_print_IN_ARG_title.parent_struct,
  &_xdp_dbus_impl_print_method_info_print_IN_ARG_fd.parent_struct,
  &_xdp_dbus_impl_print_method_info_print_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_print_method_info_print_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_print_method_info_print_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_print_method_info_print_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_print_method_info_print_OUT_ARG_response.parent_struct,
  &_xdp_dbus_impl_print_method_info_print_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_print_method_print_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In5",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_print_method_print_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_dbus_impl_print_method_print_annotation_info_pointers[] =
{
  &_xdp_dbus_impl_print_method_print_annotation_info_0,
  &_xdp_dbus_impl_print_method_print_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_print_method_info_print =
{
  {
    -1,
    (gchar *) "Print",
    (GDBusArgInfo **) &_xdp_dbus_impl_print_method_info_print_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_print_method_info_print_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_dbus_impl_print_method_print_annotation_info_pointers
  },
  "handle-print",
  TRUE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_print_method_info_prepare_print_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_print_method_info_prepare_print_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_print_method_info_prepare_print_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_print_method_info_prepare_print_IN_ARG_title =
{
  {
    -1,
    (gchar *) "title",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_print_method_info_prepare_print_IN_ARG_settings =
{
  {
    -1,
    (gchar *) "settings",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_print_method_info_prepare_print_IN_ARG_page_setup =
{
  {
    -1,
    (gchar *) "page_setup",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_print_method_info_prepare_print_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_print_method_info_prepare_print_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_print_method_info_prepare_print_IN_ARG_handle.parent_struct,
  &_xdp_dbus_impl_print_method_info_prepare_print_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_print_method_info_prepare_print_IN_ARG_parent_window.parent_struct,
  &_xdp_dbus_impl_print_method_info_prepare_print_IN_ARG_title.parent_struct,
  &_xdp_dbus_impl_print_method_info_prepare_print_IN_ARG_settings.parent_struct,
  &_xdp_dbus_impl_print_method_info_prepare_print_IN_ARG_page_setup.parent_struct,
  &_xdp_dbus_impl_print_method_info_prepare_print_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_print_method_info_prepare_print_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_print_method_info_prepare_print_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_print_method_info_prepare_print_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_print_method_info_prepare_print_OUT_ARG_response.parent_struct,
  &_xdp_dbus_impl_print_method_info_prepare_print_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_print_method_prepare_print_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In4",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_print_method_prepare_print_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In5",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_print_method_prepare_print_annotation_info_2 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In6",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_print_method_prepare_print_annotation_info_3 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_dbus_impl_print_method_prepare_print_annotation_info_pointers[] =
{
  &_xdp_dbus_impl_print_method_prepare_print_annotation_info_0,
  &_xdp_dbus_impl_print_method_prepare_print_annotation_info_1,
  &_xdp_dbus_impl_print_method_prepare_print_annotation_info_2,
  &_xdp_dbus_impl_print_method_prepare_print_annotation_info_3,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_print_method_info_prepare_print =
{
  {
    -1,
    (gchar *) "PreparePrint",
    (GDBusArgInfo **) &_xdp_dbus_impl_print_method_info_prepare_print_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_print_method_info_prepare_print_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_dbus_impl_print_method_prepare_print_annotation_info_pointers
  },
  "handle-prepare-print",
  FALSE
};

static const GDBusMethodInfo * const _xdp_dbus_impl_print_method_info_pointers[] =
{
  &_xdp_dbus_impl_print_method_info_print.parent_struct,
  &_xdp_dbus_impl_print_method_info_prepare_print.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_dbus_impl_print_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Print",
    (GDBusMethodInfo **) &_xdp_dbus_impl_print_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "print",
};


/**
 * xdp_dbus_impl_print_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Print.top_of_page">org.freedesktop.impl.portal.Print</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_dbus_impl_print_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_dbus_impl_print_interface_info.parent_struct;
}

/**
 * xdp_dbus_impl_print_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpDbusImplPrint interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_dbus_impl_print_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XdpDbusImplPrint:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Print.top_of_page">org.freedesktop.impl.portal.Print</link>.
 */

/**
 * XdpDbusImplPrintIface:
 * @parent_iface: The parent interface.
 * @handle_prepare_print: Handler for the #XdpDbusImplPrint::handle-prepare-print signal.
 * @handle_print: Handler for the #XdpDbusImplPrint::handle-print signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Print.top_of_page">org.freedesktop.impl.portal.Print</link>.
 */

typedef XdpDbusImplPrintIface XdpDbusImplPrintInterface;
G_DEFINE_INTERFACE (XdpDbusImplPrint, xdp_dbus_impl_print, G_TYPE_OBJECT)

static void
xdp_dbus_impl_print_default_init (XdpDbusImplPrintIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpDbusImplPrint::handle-print:
   * @object: A #XdpDbusImplPrint.
   * @invocation: A #GDBusMethodInvocation.
   * @fd_list: (nullable): A #GUnixFDList or %NULL.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_title: Argument passed by remote caller.
   * @arg_fd: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Print.Print">Print()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_print_complete_print() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-print",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplPrintIface, handle_print),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    8,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UNIX_FD_LIST, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * XdpDbusImplPrint::handle-prepare-print:
   * @object: A #XdpDbusImplPrint.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_title: Argument passed by remote caller.
   * @arg_settings: Argument passed by remote caller.
   * @arg_page_setup: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Print.PreparePrint">PreparePrint()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_print_complete_prepare_print() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-prepare-print",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplPrintIface, handle_prepare_print),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    8,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_VARIANT, G_TYPE_VARIANT);

}

/**
 * xdp_dbus_impl_print_call_print:
 * @proxy: A #XdpDbusImplPrintProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_fd: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Print.Print">Print()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_print_call_print_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_print_call_print_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_print_call_print (
    XdpDbusImplPrint *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_fd,
    GVariant *arg_options,
    GUnixFDList *fd_list,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call_with_unix_fd_list (G_DBUS_PROXY (proxy),
    "Print",
    g_variant_new ("(osss@h@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_fd,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_print_call_print_finish:
 * @proxy: A #XdpDbusImplPrintProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out) (optional): Return location for a #GUnixFDList or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_print_call_print().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_print_call_print().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_print_call_print_finish (
    XdpDbusImplPrint *proxy,
    guint *out_response,
    GVariant **out_results,
    GUnixFDList **out_fd_list,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_finish (G_DBUS_PROXY (proxy), out_fd_list, res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_print_call_print_sync:
 * @proxy: A #XdpDbusImplPrintProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_fd: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_fd_list: (out): Return location for a #GUnixFDList or %NULL.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Print.Print">Print()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_print_call_print() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_print_call_print_sync (
    XdpDbusImplPrint *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_fd,
    GVariant *arg_options,
    GUnixFDList  *fd_list,
    guint *out_response,
    GVariant **out_results,
    GUnixFDList **out_fd_list,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_with_unix_fd_list_sync (G_DBUS_PROXY (proxy),
    "Print",
    g_variant_new ("(osss@h@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_fd,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    fd_list,
    out_fd_list,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_print_call_prepare_print:
 * @proxy: A #XdpDbusImplPrintProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_settings: Argument to pass with the method invocation.
 * @arg_page_setup: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Print.PreparePrint">PreparePrint()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_print_call_prepare_print_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_print_call_prepare_print_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_print_call_prepare_print (
    XdpDbusImplPrint *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_settings,
    GVariant *arg_page_setup,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PreparePrint",
    g_variant_new ("(osss@a{sv}@a{sv}@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_settings,
                   arg_page_setup,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_print_call_prepare_print_finish:
 * @proxy: A #XdpDbusImplPrintProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_print_call_prepare_print().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_print_call_prepare_print().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_print_call_prepare_print_finish (
    XdpDbusImplPrint *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_print_call_prepare_print_sync:
 * @proxy: A #XdpDbusImplPrintProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_title: Argument to pass with the method invocation.
 * @arg_settings: Argument to pass with the method invocation.
 * @arg_page_setup: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Print.PreparePrint">PreparePrint()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_print_call_prepare_print() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_print_call_prepare_print_sync (
    XdpDbusImplPrint *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    const gchar *arg_title,
    GVariant *arg_settings,
    GVariant *arg_page_setup,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PreparePrint",
    g_variant_new ("(osss@a{sv}@a{sv}@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_title,
                   arg_settings,
                   arg_page_setup,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_print_complete_print:
 * @object: A #XdpDbusImplPrint.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @fd_list: (nullable): A #GUnixFDList or %NULL.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Print.Print">Print()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_print_complete_print (
    XdpDbusImplPrint *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GUnixFDList *fd_list,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value_with_unix_fd_list (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results),
    fd_list);
}

/**
 * xdp_dbus_impl_print_complete_prepare_print:
 * @object: A #XdpDbusImplPrint.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Print.PreparePrint">PreparePrint()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_print_complete_prepare_print (
    XdpDbusImplPrint *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplPrintProxy:
 *
 * The #XdpDbusImplPrintProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplPrintProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplPrintProxy.
 */

struct _XdpDbusImplPrintProxyPrivate
{
  GData *qdata;
};

static void xdp_dbus_impl_print_proxy_iface_init (XdpDbusImplPrintIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplPrintProxy, xdp_dbus_impl_print_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpDbusImplPrintProxy)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_PRINT, xdp_dbus_impl_print_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplPrintProxy, xdp_dbus_impl_print_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_PRINT, xdp_dbus_impl_print_proxy_iface_init))

#endif
static void
xdp_dbus_impl_print_proxy_finalize (GObject *object)
{
  XdpDbusImplPrintProxy *proxy = XDP_DBUS_IMPL_PRINT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_dbus_impl_print_proxy_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_print_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_dbus_impl_print_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_dbus_impl_print_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_dbus_impl_print_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_DBUS_IMPL_TYPE_PRINT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_PRINT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_dbus_impl_print_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpDbusImplPrintProxy *proxy = XDP_DBUS_IMPL_PRINT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_print_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_print_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_dbus_impl_print_proxy_init (XdpDbusImplPrintProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_dbus_impl_print_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_DBUS_IMPL_TYPE_PRINT_PROXY, XdpDbusImplPrintProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_dbus_impl_print_interface_info ());
}

static void
xdp_dbus_impl_print_proxy_class_init (XdpDbusImplPrintProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_dbus_impl_print_proxy_finalize;
  gobject_class->get_property = xdp_dbus_impl_print_proxy_get_property;
  gobject_class->set_property = xdp_dbus_impl_print_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_dbus_impl_print_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_dbus_impl_print_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplPrintProxyPrivate));
#endif
}

static void
xdp_dbus_impl_print_proxy_iface_init (XdpDbusImplPrintIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_dbus_impl_print_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Print.top_of_page">org.freedesktop.impl.portal.Print</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_print_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_print_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_print_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_PRINT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Print", NULL);
}

/**
 * xdp_dbus_impl_print_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_print_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_print_proxy_new().
 *
 * Returns: (transfer full) (type XdpDbusImplPrintProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplPrint *
xdp_dbus_impl_print_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_PRINT (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_print_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Print.top_of_page">org.freedesktop.impl.portal.Print</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_print_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplPrintProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplPrint *
xdp_dbus_impl_print_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_PRINT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Print", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_PRINT (ret);
  else
    return NULL;
}


/**
 * xdp_dbus_impl_print_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_dbus_impl_print_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_print_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_print_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_print_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_PRINT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Print", NULL);
}

/**
 * xdp_dbus_impl_print_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_print_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_print_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpDbusImplPrintProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplPrint *
xdp_dbus_impl_print_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_PRINT (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_print_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_dbus_impl_print_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_print_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplPrintProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplPrint *
xdp_dbus_impl_print_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_PRINT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Print", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_PRINT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplPrintSkeleton:
 *
 * The #XdpDbusImplPrintSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplPrintSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplPrintSkeleton.
 */

struct _XdpDbusImplPrintSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_dbus_impl_print_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpDbusImplPrintSkeleton *skeleton = XDP_DBUS_IMPL_PRINT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_DBUS_IMPL_TYPE_PRINT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_PRINT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_dbus_impl_print_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplPrintSkeleton *skeleton = XDP_DBUS_IMPL_PRINT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_print_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_dbus_impl_print_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplPrintSkeleton *skeleton = XDP_DBUS_IMPL_PRINT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_print_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_dbus_impl_print_skeleton_vtable =
{
  _xdp_dbus_impl_print_skeleton_handle_method_call,
  _xdp_dbus_impl_print_skeleton_handle_get_property,
  _xdp_dbus_impl_print_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_dbus_impl_print_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_dbus_impl_print_interface_info ();
}

static GDBusInterfaceVTable *
xdp_dbus_impl_print_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_dbus_impl_print_skeleton_vtable;
}

static GVariant *
xdp_dbus_impl_print_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDbusImplPrintSkeleton *skeleton = XDP_DBUS_IMPL_PRINT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_dbus_impl_print_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_dbus_impl_print_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_dbus_impl_print_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_dbus_impl_print_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Print", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_dbus_impl_print_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void xdp_dbus_impl_print_skeleton_iface_init (XdpDbusImplPrintIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplPrintSkeleton, xdp_dbus_impl_print_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpDbusImplPrintSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_PRINT, xdp_dbus_impl_print_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplPrintSkeleton, xdp_dbus_impl_print_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_PRINT, xdp_dbus_impl_print_skeleton_iface_init))

#endif
static void
xdp_dbus_impl_print_skeleton_finalize (GObject *object)
{
  XdpDbusImplPrintSkeleton *skeleton = XDP_DBUS_IMPL_PRINT_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_dbus_impl_print_skeleton_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_print_skeleton_init (XdpDbusImplPrintSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_dbus_impl_print_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_DBUS_IMPL_TYPE_PRINT_SKELETON, XdpDbusImplPrintSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_dbus_impl_print_skeleton_class_init (XdpDbusImplPrintSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_dbus_impl_print_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_dbus_impl_print_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_dbus_impl_print_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_dbus_impl_print_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_dbus_impl_print_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplPrintSkeletonPrivate));
#endif
}

static void
xdp_dbus_impl_print_skeleton_iface_init (XdpDbusImplPrintIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_dbus_impl_print_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Print.top_of_page">org.freedesktop.impl.portal.Print</link>.
 *
 * Returns: (transfer full) (type XdpDbusImplPrintSkeleton): The skeleton object.
 */
XdpDbusImplPrint *
xdp_dbus_impl_print_skeleton_new (void)
{
  return XDP_DBUS_IMPL_PRINT (g_object_new (XDP_DBUS_IMPL_TYPE_PRINT_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.RemoteDesktop
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpDbusImplRemoteDesktop
 * @title: XdpDbusImplRemoteDesktop
 * @short_description: Generated C code for the org.freedesktop.impl.portal.RemoteDesktop D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-RemoteDesktop.top_of_page">org.freedesktop.impl.portal.RemoteDesktop</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.RemoteDesktop ---- */

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_create_session_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_create_session_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_create_session_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_create_session_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_remote_desktop_method_info_create_session_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_remote_desktop_method_info_create_session_IN_ARG_handle.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_create_session_IN_ARG_session_handle.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_create_session_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_create_session_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_create_session_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_create_session_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_remote_desktop_method_info_create_session_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_remote_desktop_method_info_create_session_OUT_ARG_response.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_create_session_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_remote_desktop_method_create_session_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In3",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_remote_desktop_method_create_session_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_dbus_impl_remote_desktop_method_create_session_annotation_info_pointers[] =
{
  &_xdp_dbus_impl_remote_desktop_method_create_session_annotation_info_0,
  &_xdp_dbus_impl_remote_desktop_method_create_session_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_remote_desktop_method_info_create_session =
{
  {
    -1,
    (gchar *) "CreateSession",
    (GDBusArgInfo **) &_xdp_dbus_impl_remote_desktop_method_info_create_session_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_remote_desktop_method_info_create_session_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_dbus_impl_remote_desktop_method_create_session_annotation_info_pointers
  },
  "handle-create-session",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_select_devices_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_select_devices_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_select_devices_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_select_devices_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_remote_desktop_method_info_select_devices_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_remote_desktop_method_info_select_devices_IN_ARG_handle.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_select_devices_IN_ARG_session_handle.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_select_devices_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_select_devices_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_select_devices_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_select_devices_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_remote_desktop_method_info_select_devices_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_remote_desktop_method_info_select_devices_OUT_ARG_response.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_select_devices_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_remote_desktop_method_select_devices_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_dbus_impl_remote_desktop_method_select_devices_annotation_info_pointers[] =
{
  &_xdp_dbus_impl_remote_desktop_method_select_devices_annotation_info_0,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_remote_desktop_method_info_select_devices =
{
  {
    -1,
    (gchar *) "SelectDevices",
    (GDBusArgInfo **) &_xdp_dbus_impl_remote_desktop_method_info_select_devices_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_remote_desktop_method_info_select_devices_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_dbus_impl_remote_desktop_method_select_devices_annotation_info_pointers
  },
  "handle-select-devices",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_start_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_start_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_start_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_start_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_start_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_remote_desktop_method_info_start_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_remote_desktop_method_info_start_IN_ARG_handle.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_start_IN_ARG_session_handle.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_start_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_start_IN_ARG_parent_window.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_start_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_start_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_start_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_remote_desktop_method_info_start_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_remote_desktop_method_info_start_OUT_ARG_response.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_start_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_remote_desktop_method_start_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_remote_desktop_method_start_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_dbus_impl_remote_desktop_method_start_annotation_info_pointers[] =
{
  &_xdp_dbus_impl_remote_desktop_method_start_annotation_info_0,
  &_xdp_dbus_impl_remote_desktop_method_start_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_remote_desktop_method_info_start =
{
  {
    -1,
    (gchar *) "Start",
    (GDBusArgInfo **) &_xdp_dbus_impl_remote_desktop_method_info_start_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_remote_desktop_method_info_start_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_dbus_impl_remote_desktop_method_start_annotation_info_pointers
  },
  "handle-start",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion_IN_ARG_dx =
{
  {
    -1,
    (gchar *) "dx",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion_IN_ARG_dy =
{
  {
    -1,
    (gchar *) "dy",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion_IN_ARG_session_handle.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion_IN_ARG_options.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion_IN_ARG_dx.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion_IN_ARG_dy.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion =
{
  {
    -1,
    (gchar *) "NotifyPointerMotion",
    (GDBusArgInfo **) &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-motion",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion_absolute_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion_absolute_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion_absolute_IN_ARG_stream =
{
  {
    -1,
    (gchar *) "stream",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion_absolute_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion_absolute_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion_absolute_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion_absolute_IN_ARG_session_handle.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion_absolute_IN_ARG_options.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion_absolute_IN_ARG_stream.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion_absolute_IN_ARG_x.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion_absolute_IN_ARG_y.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion_absolute =
{
  {
    -1,
    (gchar *) "NotifyPointerMotionAbsolute",
    (GDBusArgInfo **) &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion_absolute_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-motion-absolute",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_button_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_button_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_button_IN_ARG_button =
{
  {
    -1,
    (gchar *) "button",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_button_IN_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_button_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_button_IN_ARG_session_handle.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_button_IN_ARG_options.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_button_IN_ARG_button.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_button_IN_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_button =
{
  {
    -1,
    (gchar *) "NotifyPointerButton",
    (GDBusArgInfo **) &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_button_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-button",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_axis_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_axis_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_axis_IN_ARG_dx =
{
  {
    -1,
    (gchar *) "dx",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_axis_IN_ARG_dy =
{
  {
    -1,
    (gchar *) "dy",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_axis_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_axis_IN_ARG_session_handle.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_axis_IN_ARG_options.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_axis_IN_ARG_dx.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_axis_IN_ARG_dy.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_axis =
{
  {
    -1,
    (gchar *) "NotifyPointerAxis",
    (GDBusArgInfo **) &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_axis_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-axis",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_axis_discrete_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_axis_discrete_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_axis_discrete_IN_ARG_axis =
{
  {
    -1,
    (gchar *) "axis",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_axis_discrete_IN_ARG_steps =
{
  {
    -1,
    (gchar *) "steps",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_axis_discrete_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_axis_discrete_IN_ARG_session_handle.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_axis_discrete_IN_ARG_options.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_axis_discrete_IN_ARG_axis.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_axis_discrete_IN_ARG_steps.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_remote_desktop_method_info_notify_pointer_axis_discrete =
{
  {
    -1,
    (gchar *) "NotifyPointerAxisDiscrete",
    (GDBusArgInfo **) &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_axis_discrete_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-pointer-axis-discrete",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_keyboard_keycode_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_keyboard_keycode_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_keyboard_keycode_IN_ARG_keycode =
{
  {
    -1,
    (gchar *) "keycode",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_keyboard_keycode_IN_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_remote_desktop_method_info_notify_keyboard_keycode_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_remote_desktop_method_info_notify_keyboard_keycode_IN_ARG_session_handle.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_keyboard_keycode_IN_ARG_options.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_keyboard_keycode_IN_ARG_keycode.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_keyboard_keycode_IN_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_remote_desktop_method_info_notify_keyboard_keycode =
{
  {
    -1,
    (gchar *) "NotifyKeyboardKeycode",
    (GDBusArgInfo **) &_xdp_dbus_impl_remote_desktop_method_info_notify_keyboard_keycode_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-keyboard-keycode",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_keyboard_keysym_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_keyboard_keysym_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_keyboard_keysym_IN_ARG_keysym =
{
  {
    -1,
    (gchar *) "keysym",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_keyboard_keysym_IN_ARG_state =
{
  {
    -1,
    (gchar *) "state",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_remote_desktop_method_info_notify_keyboard_keysym_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_remote_desktop_method_info_notify_keyboard_keysym_IN_ARG_session_handle.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_keyboard_keysym_IN_ARG_options.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_keyboard_keysym_IN_ARG_keysym.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_keyboard_keysym_IN_ARG_state.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_remote_desktop_method_info_notify_keyboard_keysym =
{
  {
    -1,
    (gchar *) "NotifyKeyboardKeysym",
    (GDBusArgInfo **) &_xdp_dbus_impl_remote_desktop_method_info_notify_keyboard_keysym_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-keyboard-keysym",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_stream =
{
  {
    -1,
    (gchar *) "stream",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_slot =
{
  {
    -1,
    (gchar *) "slot",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_session_handle.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_options.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_stream.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_slot.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_x.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_y.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_remote_desktop_method_info_notify_touch_down =
{
  {
    -1,
    (gchar *) "NotifyTouchDown",
    (GDBusArgInfo **) &_xdp_dbus_impl_remote_desktop_method_info_notify_touch_down_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-touch-down",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_stream =
{
  {
    -1,
    (gchar *) "stream",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_slot =
{
  {
    -1,
    (gchar *) "slot",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_x =
{
  {
    -1,
    (gchar *) "x",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_y =
{
  {
    -1,
    (gchar *) "y",
    (gchar *) "d",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_session_handle.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_options.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_stream.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_slot.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_x.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_y.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_remote_desktop_method_info_notify_touch_motion =
{
  {
    -1,
    (gchar *) "NotifyTouchMotion",
    (GDBusArgInfo **) &_xdp_dbus_impl_remote_desktop_method_info_notify_touch_motion_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-touch-motion",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_touch_up_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_touch_up_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_remote_desktop_method_info_notify_touch_up_IN_ARG_slot =
{
  {
    -1,
    (gchar *) "slot",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_remote_desktop_method_info_notify_touch_up_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_remote_desktop_method_info_notify_touch_up_IN_ARG_session_handle.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_touch_up_IN_ARG_options.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_touch_up_IN_ARG_slot.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_remote_desktop_method_info_notify_touch_up =
{
  {
    -1,
    (gchar *) "NotifyTouchUp",
    (GDBusArgInfo **) &_xdp_dbus_impl_remote_desktop_method_info_notify_touch_up_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-notify-touch-up",
  FALSE
};

static const GDBusMethodInfo * const _xdp_dbus_impl_remote_desktop_method_info_pointers[] =
{
  &_xdp_dbus_impl_remote_desktop_method_info_create_session.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_select_devices.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_start.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_motion_absolute.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_button.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_axis.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_pointer_axis_discrete.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_keyboard_keycode.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_keyboard_keysym.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_touch_down.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_touch_motion.parent_struct,
  &_xdp_dbus_impl_remote_desktop_method_info_notify_touch_up.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_dbus_impl_remote_desktop_property_info_available_device_types =
{
  {
    -1,
    (gchar *) "AvailableDeviceTypes",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "available-device-types",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_dbus_impl_remote_desktop_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_dbus_impl_remote_desktop_property_info_pointers[] =
{
  &_xdp_dbus_impl_remote_desktop_property_info_available_device_types.parent_struct,
  &_xdp_dbus_impl_remote_desktop_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_dbus_impl_remote_desktop_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.RemoteDesktop",
    (GDBusMethodInfo **) &_xdp_dbus_impl_remote_desktop_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_xdp_dbus_impl_remote_desktop_property_info_pointers,
    NULL
  },
  "remote-desktop",
};


/**
 * xdp_dbus_impl_remote_desktop_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-RemoteDesktop.top_of_page">org.freedesktop.impl.portal.RemoteDesktop</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_dbus_impl_remote_desktop_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_dbus_impl_remote_desktop_interface_info.parent_struct;
}

/**
 * xdp_dbus_impl_remote_desktop_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpDbusImplRemoteDesktop interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_dbus_impl_remote_desktop_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "available-device-types");
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpDbusImplRemoteDesktop:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-RemoteDesktop.top_of_page">org.freedesktop.impl.portal.RemoteDesktop</link>.
 */

/**
 * XdpDbusImplRemoteDesktopIface:
 * @parent_iface: The parent interface.
 * @handle_create_session: Handler for the #XdpDbusImplRemoteDesktop::handle-create-session signal.
 * @handle_notify_keyboard_keycode: Handler for the #XdpDbusImplRemoteDesktop::handle-notify-keyboard-keycode signal.
 * @handle_notify_keyboard_keysym: Handler for the #XdpDbusImplRemoteDesktop::handle-notify-keyboard-keysym signal.
 * @handle_notify_pointer_axis: Handler for the #XdpDbusImplRemoteDesktop::handle-notify-pointer-axis signal.
 * @handle_notify_pointer_axis_discrete: Handler for the #XdpDbusImplRemoteDesktop::handle-notify-pointer-axis-discrete signal.
 * @handle_notify_pointer_button: Handler for the #XdpDbusImplRemoteDesktop::handle-notify-pointer-button signal.
 * @handle_notify_pointer_motion: Handler for the #XdpDbusImplRemoteDesktop::handle-notify-pointer-motion signal.
 * @handle_notify_pointer_motion_absolute: Handler for the #XdpDbusImplRemoteDesktop::handle-notify-pointer-motion-absolute signal.
 * @handle_notify_touch_down: Handler for the #XdpDbusImplRemoteDesktop::handle-notify-touch-down signal.
 * @handle_notify_touch_motion: Handler for the #XdpDbusImplRemoteDesktop::handle-notify-touch-motion signal.
 * @handle_notify_touch_up: Handler for the #XdpDbusImplRemoteDesktop::handle-notify-touch-up signal.
 * @handle_select_devices: Handler for the #XdpDbusImplRemoteDesktop::handle-select-devices signal.
 * @handle_start: Handler for the #XdpDbusImplRemoteDesktop::handle-start signal.
 * @get_available_device_types: Getter for the #XdpDbusImplRemoteDesktop:available-device-types property.
 * @get_version: Getter for the #XdpDbusImplRemoteDesktop:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-RemoteDesktop.top_of_page">org.freedesktop.impl.portal.RemoteDesktop</link>.
 */

typedef XdpDbusImplRemoteDesktopIface XdpDbusImplRemoteDesktopInterface;
G_DEFINE_INTERFACE (XdpDbusImplRemoteDesktop, xdp_dbus_impl_remote_desktop, G_TYPE_OBJECT)

static void
xdp_dbus_impl_remote_desktop_default_init (XdpDbusImplRemoteDesktopIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpDbusImplRemoteDesktop::handle-create-session:
   * @object: A #XdpDbusImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.CreateSession">CreateSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_remote_desktop_complete_create_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplRemoteDesktopIface, handle_create_session),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpDbusImplRemoteDesktop::handle-select-devices:
   * @object: A #XdpDbusImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.SelectDevices">SelectDevices()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_remote_desktop_complete_select_devices() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-select-devices",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplRemoteDesktopIface, handle_select_devices),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpDbusImplRemoteDesktop::handle-start:
   * @object: A #XdpDbusImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.Start">Start()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_remote_desktop_complete_start() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplRemoteDesktopIface, handle_start),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpDbusImplRemoteDesktop::handle-notify-pointer-motion:
   * @object: A #XdpDbusImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   * @arg_dx: Argument passed by remote caller.
   * @arg_dy: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerMotion">NotifyPointerMotion()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_remote_desktop_complete_notify_pointer_motion() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-motion",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplRemoteDesktopIface, handle_notify_pointer_motion),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_DOUBLE, G_TYPE_DOUBLE);

  /**
   * XdpDbusImplRemoteDesktop::handle-notify-pointer-motion-absolute:
   * @object: A #XdpDbusImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   * @arg_stream: Argument passed by remote caller.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerMotionAbsolute">NotifyPointerMotionAbsolute()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_remote_desktop_complete_notify_pointer_motion_absolute() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-motion-absolute",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplRemoteDesktopIface, handle_notify_pointer_motion_absolute),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_UINT, G_TYPE_DOUBLE, G_TYPE_DOUBLE);

  /**
   * XdpDbusImplRemoteDesktop::handle-notify-pointer-button:
   * @object: A #XdpDbusImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   * @arg_button: Argument passed by remote caller.
   * @arg_state: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerButton">NotifyPointerButton()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_remote_desktop_complete_notify_pointer_button() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-button",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplRemoteDesktopIface, handle_notify_pointer_button),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_INT, G_TYPE_UINT);

  /**
   * XdpDbusImplRemoteDesktop::handle-notify-pointer-axis:
   * @object: A #XdpDbusImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   * @arg_dx: Argument passed by remote caller.
   * @arg_dy: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerAxis">NotifyPointerAxis()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_remote_desktop_complete_notify_pointer_axis() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-axis",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplRemoteDesktopIface, handle_notify_pointer_axis),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_DOUBLE, G_TYPE_DOUBLE);

  /**
   * XdpDbusImplRemoteDesktop::handle-notify-pointer-axis-discrete:
   * @object: A #XdpDbusImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   * @arg_axis: Argument passed by remote caller.
   * @arg_steps: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerAxisDiscrete">NotifyPointerAxisDiscrete()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_remote_desktop_complete_notify_pointer_axis_discrete() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-pointer-axis-discrete",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplRemoteDesktopIface, handle_notify_pointer_axis_discrete),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_UINT, G_TYPE_INT);

  /**
   * XdpDbusImplRemoteDesktop::handle-notify-keyboard-keycode:
   * @object: A #XdpDbusImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   * @arg_keycode: Argument passed by remote caller.
   * @arg_state: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyKeyboardKeycode">NotifyKeyboardKeycode()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_remote_desktop_complete_notify_keyboard_keycode() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-keyboard-keycode",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplRemoteDesktopIface, handle_notify_keyboard_keycode),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_INT, G_TYPE_UINT);

  /**
   * XdpDbusImplRemoteDesktop::handle-notify-keyboard-keysym:
   * @object: A #XdpDbusImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   * @arg_keysym: Argument passed by remote caller.
   * @arg_state: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyKeyboardKeysym">NotifyKeyboardKeysym()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_remote_desktop_complete_notify_keyboard_keysym() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-keyboard-keysym",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplRemoteDesktopIface, handle_notify_keyboard_keysym),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_INT, G_TYPE_UINT);

  /**
   * XdpDbusImplRemoteDesktop::handle-notify-touch-down:
   * @object: A #XdpDbusImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   * @arg_stream: Argument passed by remote caller.
   * @arg_slot: Argument passed by remote caller.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyTouchDown">NotifyTouchDown()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_remote_desktop_complete_notify_touch_down() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-touch-down",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplRemoteDesktopIface, handle_notify_touch_down),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    7,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_DOUBLE, G_TYPE_DOUBLE);

  /**
   * XdpDbusImplRemoteDesktop::handle-notify-touch-motion:
   * @object: A #XdpDbusImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   * @arg_stream: Argument passed by remote caller.
   * @arg_slot: Argument passed by remote caller.
   * @arg_x: Argument passed by remote caller.
   * @arg_y: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyTouchMotion">NotifyTouchMotion()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_remote_desktop_complete_notify_touch_motion() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-touch-motion",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplRemoteDesktopIface, handle_notify_touch_motion),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    7,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_DOUBLE, G_TYPE_DOUBLE);

  /**
   * XdpDbusImplRemoteDesktop::handle-notify-touch-up:
   * @object: A #XdpDbusImplRemoteDesktop.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   * @arg_slot: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyTouchUp">NotifyTouchUp()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_remote_desktop_complete_notify_touch_up() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-notify-touch-up",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplRemoteDesktopIface, handle_notify_touch_up),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT, G_TYPE_UINT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpDbusImplRemoteDesktop:available-device-types:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-RemoteDesktop.AvailableDeviceTypes">"AvailableDeviceTypes"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("available-device-types", "AvailableDeviceTypes", "AvailableDeviceTypes", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpDbusImplRemoteDesktop:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-RemoteDesktop.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_dbus_impl_remote_desktop_get_available_device_types: (skip)
 * @object: A #XdpDbusImplRemoteDesktop.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-RemoteDesktop.AvailableDeviceTypes">"AvailableDeviceTypes"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_dbus_impl_remote_desktop_get_available_device_types (XdpDbusImplRemoteDesktop *object)
{
  return XDP_DBUS_IMPL_REMOTE_DESKTOP_GET_IFACE (object)->get_available_device_types (object);
}

/**
 * xdp_dbus_impl_remote_desktop_set_available_device_types: (skip)
 * @object: A #XdpDbusImplRemoteDesktop.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-RemoteDesktop.AvailableDeviceTypes">"AvailableDeviceTypes"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_dbus_impl_remote_desktop_set_available_device_types (XdpDbusImplRemoteDesktop *object, guint value)
{
  g_object_set (G_OBJECT (object), "available-device-types", value, NULL);
}

/**
 * xdp_dbus_impl_remote_desktop_get_version: (skip)
 * @object: A #XdpDbusImplRemoteDesktop.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-RemoteDesktop.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_dbus_impl_remote_desktop_get_version (XdpDbusImplRemoteDesktop *object)
{
  return XDP_DBUS_IMPL_REMOTE_DESKTOP_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_dbus_impl_remote_desktop_set_version: (skip)
 * @object: A #XdpDbusImplRemoteDesktop.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-RemoteDesktop.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_dbus_impl_remote_desktop_set_version (XdpDbusImplRemoteDesktop *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_dbus_impl_remote_desktop_call_create_session:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.CreateSession">CreateSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_remote_desktop_call_create_session_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_remote_desktop_call_create_session_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_remote_desktop_call_create_session (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateSession",
    g_variant_new ("(oos@a{sv})",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_remote_desktop_call_create_session_finish:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_remote_desktop_call_create_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_remote_desktop_call_create_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_create_session_finish (
    XdpDbusImplRemoteDesktop *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_create_session_sync:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.CreateSession">CreateSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_remote_desktop_call_create_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_create_session_sync (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateSession",
    g_variant_new ("(oos@a{sv})",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_select_devices:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.SelectDevices">SelectDevices()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_remote_desktop_call_select_devices_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_remote_desktop_call_select_devices_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_remote_desktop_call_select_devices (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SelectDevices",
    g_variant_new ("(oos@a{sv})",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_remote_desktop_call_select_devices_finish:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_remote_desktop_call_select_devices().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_remote_desktop_call_select_devices().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_select_devices_finish (
    XdpDbusImplRemoteDesktop *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_select_devices_sync:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.SelectDevices">SelectDevices()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_remote_desktop_call_select_devices() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_select_devices_sync (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SelectDevices",
    g_variant_new ("(oos@a{sv})",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_start:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.Start">Start()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_remote_desktop_call_start_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_remote_desktop_call_start_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_remote_desktop_call_start (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("(ooss@a{sv})",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_remote_desktop_call_start_finish:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_remote_desktop_call_start().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_remote_desktop_call_start().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_start_finish (
    XdpDbusImplRemoteDesktop *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_start_sync:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.Start">Start()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_remote_desktop_call_start() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_start_sync (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("(ooss@a{sv})",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_pointer_motion:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_dx: Argument to pass with the method invocation.
 * @arg_dy: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerMotion">NotifyPointerMotion()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_remote_desktop_call_notify_pointer_motion_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_remote_desktop_call_notify_pointer_motion_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_remote_desktop_call_notify_pointer_motion (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    gdouble arg_dx,
    gdouble arg_dy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerMotion",
    g_variant_new ("(o@a{sv}dd)",
                   arg_session_handle,
                   arg_options,
                   arg_dx,
                   arg_dy),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_pointer_motion_finish:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_remote_desktop_call_notify_pointer_motion().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_remote_desktop_call_notify_pointer_motion().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_notify_pointer_motion_finish (
    XdpDbusImplRemoteDesktop *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_pointer_motion_sync:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_dx: Argument to pass with the method invocation.
 * @arg_dy: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerMotion">NotifyPointerMotion()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_remote_desktop_call_notify_pointer_motion() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_notify_pointer_motion_sync (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    gdouble arg_dx,
    gdouble arg_dy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerMotion",
    g_variant_new ("(o@a{sv}dd)",
                   arg_session_handle,
                   arg_options,
                   arg_dx,
                   arg_dy),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_pointer_motion_absolute:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerMotionAbsolute">NotifyPointerMotionAbsolute()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_remote_desktop_call_notify_pointer_motion_absolute_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_remote_desktop_call_notify_pointer_motion_absolute_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_remote_desktop_call_notify_pointer_motion_absolute (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    guint arg_stream,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerMotionAbsolute",
    g_variant_new ("(o@a{sv}udd)",
                   arg_session_handle,
                   arg_options,
                   arg_stream,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_pointer_motion_absolute_finish:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_remote_desktop_call_notify_pointer_motion_absolute().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_remote_desktop_call_notify_pointer_motion_absolute().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_notify_pointer_motion_absolute_finish (
    XdpDbusImplRemoteDesktop *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_pointer_motion_absolute_sync:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerMotionAbsolute">NotifyPointerMotionAbsolute()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_remote_desktop_call_notify_pointer_motion_absolute() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_notify_pointer_motion_absolute_sync (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    guint arg_stream,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerMotionAbsolute",
    g_variant_new ("(o@a{sv}udd)",
                   arg_session_handle,
                   arg_options,
                   arg_stream,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_pointer_button:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_button: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerButton">NotifyPointerButton()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_remote_desktop_call_notify_pointer_button_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_remote_desktop_call_notify_pointer_button_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_remote_desktop_call_notify_pointer_button (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    gint arg_button,
    guint arg_state,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerButton",
    g_variant_new ("(o@a{sv}iu)",
                   arg_session_handle,
                   arg_options,
                   arg_button,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_pointer_button_finish:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_remote_desktop_call_notify_pointer_button().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_remote_desktop_call_notify_pointer_button().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_notify_pointer_button_finish (
    XdpDbusImplRemoteDesktop *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_pointer_button_sync:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_button: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerButton">NotifyPointerButton()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_remote_desktop_call_notify_pointer_button() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_notify_pointer_button_sync (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    gint arg_button,
    guint arg_state,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerButton",
    g_variant_new ("(o@a{sv}iu)",
                   arg_session_handle,
                   arg_options,
                   arg_button,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_pointer_axis:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_dx: Argument to pass with the method invocation.
 * @arg_dy: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerAxis">NotifyPointerAxis()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_remote_desktop_call_notify_pointer_axis_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_remote_desktop_call_notify_pointer_axis_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_remote_desktop_call_notify_pointer_axis (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    gdouble arg_dx,
    gdouble arg_dy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerAxis",
    g_variant_new ("(o@a{sv}dd)",
                   arg_session_handle,
                   arg_options,
                   arg_dx,
                   arg_dy),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_pointer_axis_finish:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_remote_desktop_call_notify_pointer_axis().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_remote_desktop_call_notify_pointer_axis().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_notify_pointer_axis_finish (
    XdpDbusImplRemoteDesktop *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_pointer_axis_sync:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_dx: Argument to pass with the method invocation.
 * @arg_dy: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerAxis">NotifyPointerAxis()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_remote_desktop_call_notify_pointer_axis() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_notify_pointer_axis_sync (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    gdouble arg_dx,
    gdouble arg_dy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerAxis",
    g_variant_new ("(o@a{sv}dd)",
                   arg_session_handle,
                   arg_options,
                   arg_dx,
                   arg_dy),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_pointer_axis_discrete:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_axis: Argument to pass with the method invocation.
 * @arg_steps: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerAxisDiscrete">NotifyPointerAxisDiscrete()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_remote_desktop_call_notify_pointer_axis_discrete_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_remote_desktop_call_notify_pointer_axis_discrete_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_remote_desktop_call_notify_pointer_axis_discrete (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    guint arg_axis,
    gint arg_steps,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyPointerAxisDiscrete",
    g_variant_new ("(o@a{sv}ui)",
                   arg_session_handle,
                   arg_options,
                   arg_axis,
                   arg_steps),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_pointer_axis_discrete_finish:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_remote_desktop_call_notify_pointer_axis_discrete().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_remote_desktop_call_notify_pointer_axis_discrete().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_notify_pointer_axis_discrete_finish (
    XdpDbusImplRemoteDesktop *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_pointer_axis_discrete_sync:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_axis: Argument to pass with the method invocation.
 * @arg_steps: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerAxisDiscrete">NotifyPointerAxisDiscrete()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_remote_desktop_call_notify_pointer_axis_discrete() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_notify_pointer_axis_discrete_sync (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    guint arg_axis,
    gint arg_steps,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyPointerAxisDiscrete",
    g_variant_new ("(o@a{sv}ui)",
                   arg_session_handle,
                   arg_options,
                   arg_axis,
                   arg_steps),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_keyboard_keycode:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_keycode: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyKeyboardKeycode">NotifyKeyboardKeycode()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_remote_desktop_call_notify_keyboard_keycode_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_remote_desktop_call_notify_keyboard_keycode_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_remote_desktop_call_notify_keyboard_keycode (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    gint arg_keycode,
    guint arg_state,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyKeyboardKeycode",
    g_variant_new ("(o@a{sv}iu)",
                   arg_session_handle,
                   arg_options,
                   arg_keycode,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_keyboard_keycode_finish:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_remote_desktop_call_notify_keyboard_keycode().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_remote_desktop_call_notify_keyboard_keycode().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_notify_keyboard_keycode_finish (
    XdpDbusImplRemoteDesktop *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_keyboard_keycode_sync:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_keycode: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyKeyboardKeycode">NotifyKeyboardKeycode()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_remote_desktop_call_notify_keyboard_keycode() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_notify_keyboard_keycode_sync (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    gint arg_keycode,
    guint arg_state,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyKeyboardKeycode",
    g_variant_new ("(o@a{sv}iu)",
                   arg_session_handle,
                   arg_options,
                   arg_keycode,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_keyboard_keysym:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_keysym: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyKeyboardKeysym">NotifyKeyboardKeysym()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_remote_desktop_call_notify_keyboard_keysym_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_remote_desktop_call_notify_keyboard_keysym_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_remote_desktop_call_notify_keyboard_keysym (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    gint arg_keysym,
    guint arg_state,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyKeyboardKeysym",
    g_variant_new ("(o@a{sv}iu)",
                   arg_session_handle,
                   arg_options,
                   arg_keysym,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_keyboard_keysym_finish:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_remote_desktop_call_notify_keyboard_keysym().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_remote_desktop_call_notify_keyboard_keysym().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_notify_keyboard_keysym_finish (
    XdpDbusImplRemoteDesktop *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_keyboard_keysym_sync:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_keysym: Argument to pass with the method invocation.
 * @arg_state: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyKeyboardKeysym">NotifyKeyboardKeysym()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_remote_desktop_call_notify_keyboard_keysym() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_notify_keyboard_keysym_sync (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    gint arg_keysym,
    guint arg_state,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyKeyboardKeysym",
    g_variant_new ("(o@a{sv}iu)",
                   arg_session_handle,
                   arg_options,
                   arg_keysym,
                   arg_state),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_touch_down:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_slot: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyTouchDown">NotifyTouchDown()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_remote_desktop_call_notify_touch_down_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_remote_desktop_call_notify_touch_down_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_remote_desktop_call_notify_touch_down (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    guint arg_stream,
    guint arg_slot,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyTouchDown",
    g_variant_new ("(o@a{sv}uudd)",
                   arg_session_handle,
                   arg_options,
                   arg_stream,
                   arg_slot,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_touch_down_finish:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_remote_desktop_call_notify_touch_down().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_remote_desktop_call_notify_touch_down().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_notify_touch_down_finish (
    XdpDbusImplRemoteDesktop *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_touch_down_sync:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_slot: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyTouchDown">NotifyTouchDown()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_remote_desktop_call_notify_touch_down() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_notify_touch_down_sync (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    guint arg_stream,
    guint arg_slot,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyTouchDown",
    g_variant_new ("(o@a{sv}uudd)",
                   arg_session_handle,
                   arg_options,
                   arg_stream,
                   arg_slot,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_touch_motion:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_slot: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyTouchMotion">NotifyTouchMotion()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_remote_desktop_call_notify_touch_motion_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_remote_desktop_call_notify_touch_motion_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_remote_desktop_call_notify_touch_motion (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    guint arg_stream,
    guint arg_slot,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyTouchMotion",
    g_variant_new ("(o@a{sv}uudd)",
                   arg_session_handle,
                   arg_options,
                   arg_stream,
                   arg_slot,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_touch_motion_finish:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_remote_desktop_call_notify_touch_motion().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_remote_desktop_call_notify_touch_motion().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_notify_touch_motion_finish (
    XdpDbusImplRemoteDesktop *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_touch_motion_sync:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_stream: Argument to pass with the method invocation.
 * @arg_slot: Argument to pass with the method invocation.
 * @arg_x: Argument to pass with the method invocation.
 * @arg_y: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyTouchMotion">NotifyTouchMotion()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_remote_desktop_call_notify_touch_motion() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_notify_touch_motion_sync (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    guint arg_stream,
    guint arg_slot,
    gdouble arg_x,
    gdouble arg_y,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyTouchMotion",
    g_variant_new ("(o@a{sv}uudd)",
                   arg_session_handle,
                   arg_options,
                   arg_stream,
                   arg_slot,
                   arg_x,
                   arg_y),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_touch_up:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_slot: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyTouchUp">NotifyTouchUp()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_remote_desktop_call_notify_touch_up_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_remote_desktop_call_notify_touch_up_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_remote_desktop_call_notify_touch_up (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    guint arg_slot,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "NotifyTouchUp",
    g_variant_new ("(o@a{sv}u)",
                   arg_session_handle,
                   arg_options,
                   arg_slot),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_touch_up_finish:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_remote_desktop_call_notify_touch_up().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_remote_desktop_call_notify_touch_up().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_notify_touch_up_finish (
    XdpDbusImplRemoteDesktop *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_call_notify_touch_up_sync:
 * @proxy: A #XdpDbusImplRemoteDesktopProxy.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @arg_slot: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyTouchUp">NotifyTouchUp()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_remote_desktop_call_notify_touch_up() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_remote_desktop_call_notify_touch_up_sync (
    XdpDbusImplRemoteDesktop *proxy,
    const gchar *arg_session_handle,
    GVariant *arg_options,
    guint arg_slot,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "NotifyTouchUp",
    g_variant_new ("(o@a{sv}u)",
                   arg_session_handle,
                   arg_options,
                   arg_slot),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_complete_create_session:
 * @object: A #XdpDbusImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.CreateSession">CreateSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_remote_desktop_complete_create_session (
    XdpDbusImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * xdp_dbus_impl_remote_desktop_complete_select_devices:
 * @object: A #XdpDbusImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.SelectDevices">SelectDevices()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_remote_desktop_complete_select_devices (
    XdpDbusImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * xdp_dbus_impl_remote_desktop_complete_start:
 * @object: A #XdpDbusImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.Start">Start()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_remote_desktop_complete_start (
    XdpDbusImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * xdp_dbus_impl_remote_desktop_complete_notify_pointer_motion:
 * @object: A #XdpDbusImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerMotion">NotifyPointerMotion()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_remote_desktop_complete_notify_pointer_motion (
    XdpDbusImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_dbus_impl_remote_desktop_complete_notify_pointer_motion_absolute:
 * @object: A #XdpDbusImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerMotionAbsolute">NotifyPointerMotionAbsolute()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_remote_desktop_complete_notify_pointer_motion_absolute (
    XdpDbusImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_dbus_impl_remote_desktop_complete_notify_pointer_button:
 * @object: A #XdpDbusImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerButton">NotifyPointerButton()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_remote_desktop_complete_notify_pointer_button (
    XdpDbusImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_dbus_impl_remote_desktop_complete_notify_pointer_axis:
 * @object: A #XdpDbusImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerAxis">NotifyPointerAxis()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_remote_desktop_complete_notify_pointer_axis (
    XdpDbusImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_dbus_impl_remote_desktop_complete_notify_pointer_axis_discrete:
 * @object: A #XdpDbusImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyPointerAxisDiscrete">NotifyPointerAxisDiscrete()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_remote_desktop_complete_notify_pointer_axis_discrete (
    XdpDbusImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_dbus_impl_remote_desktop_complete_notify_keyboard_keycode:
 * @object: A #XdpDbusImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyKeyboardKeycode">NotifyKeyboardKeycode()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_remote_desktop_complete_notify_keyboard_keycode (
    XdpDbusImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_dbus_impl_remote_desktop_complete_notify_keyboard_keysym:
 * @object: A #XdpDbusImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyKeyboardKeysym">NotifyKeyboardKeysym()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_remote_desktop_complete_notify_keyboard_keysym (
    XdpDbusImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_dbus_impl_remote_desktop_complete_notify_touch_down:
 * @object: A #XdpDbusImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyTouchDown">NotifyTouchDown()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_remote_desktop_complete_notify_touch_down (
    XdpDbusImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_dbus_impl_remote_desktop_complete_notify_touch_motion:
 * @object: A #XdpDbusImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyTouchMotion">NotifyTouchMotion()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_remote_desktop_complete_notify_touch_motion (
    XdpDbusImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * xdp_dbus_impl_remote_desktop_complete_notify_touch_up:
 * @object: A #XdpDbusImplRemoteDesktop.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-RemoteDesktop.NotifyTouchUp">NotifyTouchUp()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_remote_desktop_complete_notify_touch_up (
    XdpDbusImplRemoteDesktop *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplRemoteDesktopProxy:
 *
 * The #XdpDbusImplRemoteDesktopProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplRemoteDesktopProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplRemoteDesktopProxy.
 */

struct _XdpDbusImplRemoteDesktopProxyPrivate
{
  GData *qdata;
};

static void xdp_dbus_impl_remote_desktop_proxy_iface_init (XdpDbusImplRemoteDesktopIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplRemoteDesktopProxy, xdp_dbus_impl_remote_desktop_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpDbusImplRemoteDesktopProxy)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_REMOTE_DESKTOP, xdp_dbus_impl_remote_desktop_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplRemoteDesktopProxy, xdp_dbus_impl_remote_desktop_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_REMOTE_DESKTOP, xdp_dbus_impl_remote_desktop_proxy_iface_init))

#endif
static void
xdp_dbus_impl_remote_desktop_proxy_finalize (GObject *object)
{
  XdpDbusImplRemoteDesktopProxy *proxy = XDP_DBUS_IMPL_REMOTE_DESKTOP_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_dbus_impl_remote_desktop_proxy_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_remote_desktop_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_dbus_impl_remote_desktop_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_dbus_impl_remote_desktop_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.impl.portal.RemoteDesktop: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_dbus_impl_remote_desktop_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_dbus_impl_remote_desktop_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.impl.portal.RemoteDesktop", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_dbus_impl_remote_desktop_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_dbus_impl_remote_desktop_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_dbus_impl_remote_desktop_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_DBUS_IMPL_TYPE_REMOTE_DESKTOP);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_REMOTE_DESKTOP);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_dbus_impl_remote_desktop_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpDbusImplRemoteDesktopProxy *proxy = XDP_DBUS_IMPL_REMOTE_DESKTOP_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_remote_desktop_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_remote_desktop_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_dbus_impl_remote_desktop_proxy_get_available_device_types (XdpDbusImplRemoteDesktop *object)
{
  XdpDbusImplRemoteDesktopProxy *proxy = XDP_DBUS_IMPL_REMOTE_DESKTOP_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AvailableDeviceTypes");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
xdp_dbus_impl_remote_desktop_proxy_get_version (XdpDbusImplRemoteDesktop *object)
{
  XdpDbusImplRemoteDesktopProxy *proxy = XDP_DBUS_IMPL_REMOTE_DESKTOP_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_dbus_impl_remote_desktop_proxy_init (XdpDbusImplRemoteDesktopProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_dbus_impl_remote_desktop_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_DBUS_IMPL_TYPE_REMOTE_DESKTOP_PROXY, XdpDbusImplRemoteDesktopProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_dbus_impl_remote_desktop_interface_info ());
}

static void
xdp_dbus_impl_remote_desktop_proxy_class_init (XdpDbusImplRemoteDesktopProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_dbus_impl_remote_desktop_proxy_finalize;
  gobject_class->get_property = xdp_dbus_impl_remote_desktop_proxy_get_property;
  gobject_class->set_property = xdp_dbus_impl_remote_desktop_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_dbus_impl_remote_desktop_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_dbus_impl_remote_desktop_proxy_g_properties_changed;

  xdp_dbus_impl_remote_desktop_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplRemoteDesktopProxyPrivate));
#endif
}

static void
xdp_dbus_impl_remote_desktop_proxy_iface_init (XdpDbusImplRemoteDesktopIface *iface)
{
  iface->get_available_device_types = xdp_dbus_impl_remote_desktop_proxy_get_available_device_types;
  iface->get_version = xdp_dbus_impl_remote_desktop_proxy_get_version;
}

/**
 * xdp_dbus_impl_remote_desktop_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-RemoteDesktop.top_of_page">org.freedesktop.impl.portal.RemoteDesktop</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_remote_desktop_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_remote_desktop_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_remote_desktop_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_REMOTE_DESKTOP_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.RemoteDesktop", NULL);
}

/**
 * xdp_dbus_impl_remote_desktop_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_remote_desktop_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_remote_desktop_proxy_new().
 *
 * Returns: (transfer full) (type XdpDbusImplRemoteDesktopProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplRemoteDesktop *
xdp_dbus_impl_remote_desktop_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_REMOTE_DESKTOP (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-RemoteDesktop.top_of_page">org.freedesktop.impl.portal.RemoteDesktop</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_remote_desktop_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplRemoteDesktopProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplRemoteDesktop *
xdp_dbus_impl_remote_desktop_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_REMOTE_DESKTOP_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.RemoteDesktop", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_REMOTE_DESKTOP (ret);
  else
    return NULL;
}


/**
 * xdp_dbus_impl_remote_desktop_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_dbus_impl_remote_desktop_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_remote_desktop_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_remote_desktop_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_remote_desktop_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_REMOTE_DESKTOP_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.RemoteDesktop", NULL);
}

/**
 * xdp_dbus_impl_remote_desktop_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_remote_desktop_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_remote_desktop_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpDbusImplRemoteDesktopProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplRemoteDesktop *
xdp_dbus_impl_remote_desktop_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_REMOTE_DESKTOP (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_remote_desktop_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_dbus_impl_remote_desktop_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_remote_desktop_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplRemoteDesktopProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplRemoteDesktop *
xdp_dbus_impl_remote_desktop_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_REMOTE_DESKTOP_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.RemoteDesktop", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_REMOTE_DESKTOP (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplRemoteDesktopSkeleton:
 *
 * The #XdpDbusImplRemoteDesktopSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplRemoteDesktopSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplRemoteDesktopSkeleton.
 */

struct _XdpDbusImplRemoteDesktopSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_dbus_impl_remote_desktop_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpDbusImplRemoteDesktopSkeleton *skeleton = XDP_DBUS_IMPL_REMOTE_DESKTOP_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_DBUS_IMPL_TYPE_REMOTE_DESKTOP);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_REMOTE_DESKTOP);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_dbus_impl_remote_desktop_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplRemoteDesktopSkeleton *skeleton = XDP_DBUS_IMPL_REMOTE_DESKTOP_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_remote_desktop_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_dbus_impl_remote_desktop_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplRemoteDesktopSkeleton *skeleton = XDP_DBUS_IMPL_REMOTE_DESKTOP_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_remote_desktop_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_dbus_impl_remote_desktop_skeleton_vtable =
{
  _xdp_dbus_impl_remote_desktop_skeleton_handle_method_call,
  _xdp_dbus_impl_remote_desktop_skeleton_handle_get_property,
  _xdp_dbus_impl_remote_desktop_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_dbus_impl_remote_desktop_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_dbus_impl_remote_desktop_interface_info ();
}

static GDBusInterfaceVTable *
xdp_dbus_impl_remote_desktop_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_dbus_impl_remote_desktop_skeleton_vtable;
}

static GVariant *
xdp_dbus_impl_remote_desktop_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDbusImplRemoteDesktopSkeleton *skeleton = XDP_DBUS_IMPL_REMOTE_DESKTOP_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_dbus_impl_remote_desktop_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_dbus_impl_remote_desktop_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_dbus_impl_remote_desktop_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_dbus_impl_remote_desktop_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.RemoteDesktop", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_dbus_impl_remote_desktop_emit_changed (gpointer user_data);

static void
xdp_dbus_impl_remote_desktop_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDbusImplRemoteDesktopSkeleton *skeleton = XDP_DBUS_IMPL_REMOTE_DESKTOP_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_dbus_impl_remote_desktop_emit_changed (skeleton);
}

static void xdp_dbus_impl_remote_desktop_skeleton_iface_init (XdpDbusImplRemoteDesktopIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplRemoteDesktopSkeleton, xdp_dbus_impl_remote_desktop_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpDbusImplRemoteDesktopSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_REMOTE_DESKTOP, xdp_dbus_impl_remote_desktop_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplRemoteDesktopSkeleton, xdp_dbus_impl_remote_desktop_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_REMOTE_DESKTOP, xdp_dbus_impl_remote_desktop_skeleton_iface_init))

#endif
static void
xdp_dbus_impl_remote_desktop_skeleton_finalize (GObject *object)
{
  XdpDbusImplRemoteDesktopSkeleton *skeleton = XDP_DBUS_IMPL_REMOTE_DESKTOP_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_dbus_impl_remote_desktop_skeleton_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_remote_desktop_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpDbusImplRemoteDesktopSkeleton *skeleton = XDP_DBUS_IMPL_REMOTE_DESKTOP_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_dbus_impl_remote_desktop_emit_changed (gpointer user_data)
{
  XdpDbusImplRemoteDesktopSkeleton *skeleton = XDP_DBUS_IMPL_REMOTE_DESKTOP_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.impl.portal.RemoteDesktop",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_dbus_impl_remote_desktop_schedule_emit_changed (XdpDbusImplRemoteDesktopSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_dbus_impl_remote_desktop_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpDbusImplRemoteDesktopSkeleton *skeleton = XDP_DBUS_IMPL_REMOTE_DESKTOP_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_dbus_impl_remote_desktop_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_dbus_impl_remote_desktop_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_dbus_impl_remote_desktop_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpDbusImplRemoteDesktopSkeleton *skeleton = XDP_DBUS_IMPL_REMOTE_DESKTOP_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_dbus_impl_remote_desktop_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_dbus_impl_remote_desktop_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_dbus_impl_remote_desktop_skeleton_init (XdpDbusImplRemoteDesktopSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_dbus_impl_remote_desktop_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_DBUS_IMPL_TYPE_REMOTE_DESKTOP_SKELETON, XdpDbusImplRemoteDesktopSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT);
}

static guint 
xdp_dbus_impl_remote_desktop_skeleton_get_available_device_types (XdpDbusImplRemoteDesktop *object)
{
  XdpDbusImplRemoteDesktopSkeleton *skeleton = XDP_DBUS_IMPL_REMOTE_DESKTOP_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
xdp_dbus_impl_remote_desktop_skeleton_get_version (XdpDbusImplRemoteDesktop *object)
{
  XdpDbusImplRemoteDesktopSkeleton *skeleton = XDP_DBUS_IMPL_REMOTE_DESKTOP_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_dbus_impl_remote_desktop_skeleton_class_init (XdpDbusImplRemoteDesktopSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_dbus_impl_remote_desktop_skeleton_finalize;
  gobject_class->get_property = xdp_dbus_impl_remote_desktop_skeleton_get_property;
  gobject_class->set_property = xdp_dbus_impl_remote_desktop_skeleton_set_property;
  gobject_class->notify       = xdp_dbus_impl_remote_desktop_skeleton_notify;


  xdp_dbus_impl_remote_desktop_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_dbus_impl_remote_desktop_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_dbus_impl_remote_desktop_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_dbus_impl_remote_desktop_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_dbus_impl_remote_desktop_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplRemoteDesktopSkeletonPrivate));
#endif
}

static void
xdp_dbus_impl_remote_desktop_skeleton_iface_init (XdpDbusImplRemoteDesktopIface *iface)
{
  iface->get_available_device_types = xdp_dbus_impl_remote_desktop_skeleton_get_available_device_types;
  iface->get_version = xdp_dbus_impl_remote_desktop_skeleton_get_version;
}

/**
 * xdp_dbus_impl_remote_desktop_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-RemoteDesktop.top_of_page">org.freedesktop.impl.portal.RemoteDesktop</link>.
 *
 * Returns: (transfer full) (type XdpDbusImplRemoteDesktopSkeleton): The skeleton object.
 */
XdpDbusImplRemoteDesktop *
xdp_dbus_impl_remote_desktop_skeleton_new (void)
{
  return XDP_DBUS_IMPL_REMOTE_DESKTOP (g_object_new (XDP_DBUS_IMPL_TYPE_REMOTE_DESKTOP_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Request
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpDbusImplRequest
 * @title: XdpDbusImplRequest
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Request D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Request ---- */

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_request_method_info_close =
{
  {
    -1,
    (gchar *) "Close",
    NULL,
    NULL,
    NULL
  },
  "handle-close",
  FALSE
};

static const GDBusMethodInfo * const _xdp_dbus_impl_request_method_info_pointers[] =
{
  &_xdp_dbus_impl_request_method_info_close.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_dbus_impl_request_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Request",
    (GDBusMethodInfo **) &_xdp_dbus_impl_request_method_info_pointers,
    NULL,
    NULL,
    NULL
  },
  "request",
};


/**
 * xdp_dbus_impl_request_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_dbus_impl_request_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_dbus_impl_request_interface_info.parent_struct;
}

/**
 * xdp_dbus_impl_request_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpDbusImplRequest interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_dbus_impl_request_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * XdpDbusImplRequest:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link>.
 */

/**
 * XdpDbusImplRequestIface:
 * @parent_iface: The parent interface.
 * @handle_close: Handler for the #XdpDbusImplRequest::handle-close signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link>.
 */

typedef XdpDbusImplRequestIface XdpDbusImplRequestInterface;
G_DEFINE_INTERFACE (XdpDbusImplRequest, xdp_dbus_impl_request, G_TYPE_OBJECT)

static void
xdp_dbus_impl_request_default_init (XdpDbusImplRequestIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpDbusImplRequest::handle-close:
   * @object: A #XdpDbusImplRequest.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Request.Close">Close()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_request_complete_close() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-close",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplRequestIface, handle_close),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

}

/**
 * xdp_dbus_impl_request_call_close:
 * @proxy: A #XdpDbusImplRequestProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Request.Close">Close()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_request_call_close_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_request_call_close_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_request_call_close (
    XdpDbusImplRequest *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_request_call_close_finish:
 * @proxy: A #XdpDbusImplRequestProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_request_call_close().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_request_call_close().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_request_call_close_finish (
    XdpDbusImplRequest *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_request_call_close_sync:
 * @proxy: A #XdpDbusImplRequestProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Request.Close">Close()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_request_call_close() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_request_call_close_sync (
    XdpDbusImplRequest *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Close",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_request_complete_close:
 * @object: A #XdpDbusImplRequest.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Request.Close">Close()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_request_complete_close (
    XdpDbusImplRequest *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplRequestProxy:
 *
 * The #XdpDbusImplRequestProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplRequestProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplRequestProxy.
 */

struct _XdpDbusImplRequestProxyPrivate
{
  GData *qdata;
};

static void xdp_dbus_impl_request_proxy_iface_init (XdpDbusImplRequestIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplRequestProxy, xdp_dbus_impl_request_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpDbusImplRequestProxy)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_REQUEST, xdp_dbus_impl_request_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplRequestProxy, xdp_dbus_impl_request_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_REQUEST, xdp_dbus_impl_request_proxy_iface_init))

#endif
static void
xdp_dbus_impl_request_proxy_finalize (GObject *object)
{
  XdpDbusImplRequestProxy *proxy = XDP_DBUS_IMPL_REQUEST_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_dbus_impl_request_proxy_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_request_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_dbus_impl_request_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
xdp_dbus_impl_request_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_dbus_impl_request_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_DBUS_IMPL_TYPE_REQUEST);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_REQUEST);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_dbus_impl_request_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpDbusImplRequestProxy *proxy = XDP_DBUS_IMPL_REQUEST_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_request_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_request_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
xdp_dbus_impl_request_proxy_init (XdpDbusImplRequestProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_dbus_impl_request_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_DBUS_IMPL_TYPE_REQUEST_PROXY, XdpDbusImplRequestProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_dbus_impl_request_interface_info ());
}

static void
xdp_dbus_impl_request_proxy_class_init (XdpDbusImplRequestProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_dbus_impl_request_proxy_finalize;
  gobject_class->get_property = xdp_dbus_impl_request_proxy_get_property;
  gobject_class->set_property = xdp_dbus_impl_request_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_dbus_impl_request_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_dbus_impl_request_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplRequestProxyPrivate));
#endif
}

static void
xdp_dbus_impl_request_proxy_iface_init (XdpDbusImplRequestIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_dbus_impl_request_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_request_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_request_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_request_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_REQUEST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Request", NULL);
}

/**
 * xdp_dbus_impl_request_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_request_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_request_proxy_new().
 *
 * Returns: (transfer full) (type XdpDbusImplRequestProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplRequest *
xdp_dbus_impl_request_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_REQUEST (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_request_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_request_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplRequestProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplRequest *
xdp_dbus_impl_request_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_REQUEST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Request", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_REQUEST (ret);
  else
    return NULL;
}


/**
 * xdp_dbus_impl_request_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_dbus_impl_request_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_request_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_request_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_request_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_REQUEST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Request", NULL);
}

/**
 * xdp_dbus_impl_request_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_request_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_request_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpDbusImplRequestProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplRequest *
xdp_dbus_impl_request_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_REQUEST (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_request_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_dbus_impl_request_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_request_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplRequestProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplRequest *
xdp_dbus_impl_request_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_REQUEST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Request", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_REQUEST (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplRequestSkeleton:
 *
 * The #XdpDbusImplRequestSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplRequestSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplRequestSkeleton.
 */

struct _XdpDbusImplRequestSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_dbus_impl_request_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpDbusImplRequestSkeleton *skeleton = XDP_DBUS_IMPL_REQUEST_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_DBUS_IMPL_TYPE_REQUEST);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_REQUEST);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_dbus_impl_request_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplRequestSkeleton *skeleton = XDP_DBUS_IMPL_REQUEST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_request_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_dbus_impl_request_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplRequestSkeleton *skeleton = XDP_DBUS_IMPL_REQUEST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_request_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_dbus_impl_request_skeleton_vtable =
{
  _xdp_dbus_impl_request_skeleton_handle_method_call,
  _xdp_dbus_impl_request_skeleton_handle_get_property,
  _xdp_dbus_impl_request_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_dbus_impl_request_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_dbus_impl_request_interface_info ();
}

static GDBusInterfaceVTable *
xdp_dbus_impl_request_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_dbus_impl_request_skeleton_vtable;
}

static GVariant *
xdp_dbus_impl_request_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDbusImplRequestSkeleton *skeleton = XDP_DBUS_IMPL_REQUEST_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_dbus_impl_request_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_dbus_impl_request_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_dbus_impl_request_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_dbus_impl_request_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Request", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
xdp_dbus_impl_request_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void xdp_dbus_impl_request_skeleton_iface_init (XdpDbusImplRequestIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplRequestSkeleton, xdp_dbus_impl_request_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpDbusImplRequestSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_REQUEST, xdp_dbus_impl_request_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplRequestSkeleton, xdp_dbus_impl_request_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_REQUEST, xdp_dbus_impl_request_skeleton_iface_init))

#endif
static void
xdp_dbus_impl_request_skeleton_finalize (GObject *object)
{
  XdpDbusImplRequestSkeleton *skeleton = XDP_DBUS_IMPL_REQUEST_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_dbus_impl_request_skeleton_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_request_skeleton_init (XdpDbusImplRequestSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_dbus_impl_request_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_DBUS_IMPL_TYPE_REQUEST_SKELETON, XdpDbusImplRequestSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
xdp_dbus_impl_request_skeleton_class_init (XdpDbusImplRequestSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_dbus_impl_request_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_dbus_impl_request_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_dbus_impl_request_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_dbus_impl_request_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_dbus_impl_request_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplRequestSkeletonPrivate));
#endif
}

static void
xdp_dbus_impl_request_skeleton_iface_init (XdpDbusImplRequestIface *iface G_GNUC_UNUSED)
{
}

/**
 * xdp_dbus_impl_request_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Request.top_of_page">org.freedesktop.impl.portal.Request</link>.
 *
 * Returns: (transfer full) (type XdpDbusImplRequestSkeleton): The skeleton object.
 */
XdpDbusImplRequest *
xdp_dbus_impl_request_skeleton_new (void)
{
  return XDP_DBUS_IMPL_REQUEST (g_object_new (XDP_DBUS_IMPL_TYPE_REQUEST_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.ScreenCast
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpDbusImplScreenCast
 * @title: XdpDbusImplScreenCast
 * @short_description: Generated C code for the org.freedesktop.impl.portal.ScreenCast D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-ScreenCast.top_of_page">org.freedesktop.impl.portal.ScreenCast</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.ScreenCast ---- */

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screen_cast_method_info_create_session_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screen_cast_method_info_create_session_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screen_cast_method_info_create_session_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screen_cast_method_info_create_session_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_screen_cast_method_info_create_session_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_screen_cast_method_info_create_session_IN_ARG_handle.parent_struct,
  &_xdp_dbus_impl_screen_cast_method_info_create_session_IN_ARG_session_handle.parent_struct,
  &_xdp_dbus_impl_screen_cast_method_info_create_session_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_screen_cast_method_info_create_session_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screen_cast_method_info_create_session_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screen_cast_method_info_create_session_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_screen_cast_method_info_create_session_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_screen_cast_method_info_create_session_OUT_ARG_response.parent_struct,
  &_xdp_dbus_impl_screen_cast_method_info_create_session_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_screen_cast_method_create_session_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In3",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_screen_cast_method_create_session_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_dbus_impl_screen_cast_method_create_session_annotation_info_pointers[] =
{
  &_xdp_dbus_impl_screen_cast_method_create_session_annotation_info_0,
  &_xdp_dbus_impl_screen_cast_method_create_session_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_screen_cast_method_info_create_session =
{
  {
    -1,
    (gchar *) "CreateSession",
    (GDBusArgInfo **) &_xdp_dbus_impl_screen_cast_method_info_create_session_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_screen_cast_method_info_create_session_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_dbus_impl_screen_cast_method_create_session_annotation_info_pointers
  },
  "handle-create-session",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screen_cast_method_info_select_sources_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screen_cast_method_info_select_sources_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screen_cast_method_info_select_sources_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screen_cast_method_info_select_sources_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_screen_cast_method_info_select_sources_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_screen_cast_method_info_select_sources_IN_ARG_handle.parent_struct,
  &_xdp_dbus_impl_screen_cast_method_info_select_sources_IN_ARG_session_handle.parent_struct,
  &_xdp_dbus_impl_screen_cast_method_info_select_sources_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_screen_cast_method_info_select_sources_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screen_cast_method_info_select_sources_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screen_cast_method_info_select_sources_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_screen_cast_method_info_select_sources_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_screen_cast_method_info_select_sources_OUT_ARG_response.parent_struct,
  &_xdp_dbus_impl_screen_cast_method_info_select_sources_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_screen_cast_method_select_sources_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In3",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_screen_cast_method_select_sources_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_dbus_impl_screen_cast_method_select_sources_annotation_info_pointers[] =
{
  &_xdp_dbus_impl_screen_cast_method_select_sources_annotation_info_0,
  &_xdp_dbus_impl_screen_cast_method_select_sources_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_screen_cast_method_info_select_sources =
{
  {
    -1,
    (gchar *) "SelectSources",
    (GDBusArgInfo **) &_xdp_dbus_impl_screen_cast_method_info_select_sources_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_screen_cast_method_info_select_sources_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_dbus_impl_screen_cast_method_select_sources_annotation_info_pointers
  },
  "handle-select-sources",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screen_cast_method_info_start_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screen_cast_method_info_start_IN_ARG_session_handle =
{
  {
    -1,
    (gchar *) "session_handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screen_cast_method_info_start_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screen_cast_method_info_start_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screen_cast_method_info_start_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_screen_cast_method_info_start_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_screen_cast_method_info_start_IN_ARG_handle.parent_struct,
  &_xdp_dbus_impl_screen_cast_method_info_start_IN_ARG_session_handle.parent_struct,
  &_xdp_dbus_impl_screen_cast_method_info_start_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_screen_cast_method_info_start_IN_ARG_parent_window.parent_struct,
  &_xdp_dbus_impl_screen_cast_method_info_start_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screen_cast_method_info_start_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screen_cast_method_info_start_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_screen_cast_method_info_start_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_screen_cast_method_info_start_OUT_ARG_response.parent_struct,
  &_xdp_dbus_impl_screen_cast_method_info_start_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_screen_cast_method_start_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In4",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_screen_cast_method_start_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_dbus_impl_screen_cast_method_start_annotation_info_pointers[] =
{
  &_xdp_dbus_impl_screen_cast_method_start_annotation_info_0,
  &_xdp_dbus_impl_screen_cast_method_start_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_screen_cast_method_info_start =
{
  {
    -1,
    (gchar *) "Start",
    (GDBusArgInfo **) &_xdp_dbus_impl_screen_cast_method_info_start_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_screen_cast_method_info_start_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_dbus_impl_screen_cast_method_start_annotation_info_pointers
  },
  "handle-start",
  FALSE
};

static const GDBusMethodInfo * const _xdp_dbus_impl_screen_cast_method_info_pointers[] =
{
  &_xdp_dbus_impl_screen_cast_method_info_create_session.parent_struct,
  &_xdp_dbus_impl_screen_cast_method_info_select_sources.parent_struct,
  &_xdp_dbus_impl_screen_cast_method_info_start.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_dbus_impl_screen_cast_property_info_available_source_types =
{
  {
    -1,
    (gchar *) "AvailableSourceTypes",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "available-source-types",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_dbus_impl_screen_cast_property_info_available_cursor_modes =
{
  {
    -1,
    (gchar *) "AvailableCursorModes",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "available-cursor-modes",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _xdp_dbus_impl_screen_cast_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_dbus_impl_screen_cast_property_info_pointers[] =
{
  &_xdp_dbus_impl_screen_cast_property_info_available_source_types.parent_struct,
  &_xdp_dbus_impl_screen_cast_property_info_available_cursor_modes.parent_struct,
  &_xdp_dbus_impl_screen_cast_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_dbus_impl_screen_cast_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.ScreenCast",
    (GDBusMethodInfo **) &_xdp_dbus_impl_screen_cast_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_xdp_dbus_impl_screen_cast_property_info_pointers,
    NULL
  },
  "screen-cast",
};


/**
 * xdp_dbus_impl_screen_cast_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-ScreenCast.top_of_page">org.freedesktop.impl.portal.ScreenCast</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_dbus_impl_screen_cast_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_dbus_impl_screen_cast_interface_info.parent_struct;
}

/**
 * xdp_dbus_impl_screen_cast_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpDbusImplScreenCast interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_dbus_impl_screen_cast_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "available-source-types");
  g_object_class_override_property (klass, property_id_begin++, "available-cursor-modes");
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpDbusImplScreenCast:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-ScreenCast.top_of_page">org.freedesktop.impl.portal.ScreenCast</link>.
 */

/**
 * XdpDbusImplScreenCastIface:
 * @parent_iface: The parent interface.
 * @handle_create_session: Handler for the #XdpDbusImplScreenCast::handle-create-session signal.
 * @handle_select_sources: Handler for the #XdpDbusImplScreenCast::handle-select-sources signal.
 * @handle_start: Handler for the #XdpDbusImplScreenCast::handle-start signal.
 * @get_available_cursor_modes: Getter for the #XdpDbusImplScreenCast:available-cursor-modes property.
 * @get_available_source_types: Getter for the #XdpDbusImplScreenCast:available-source-types property.
 * @get_version: Getter for the #XdpDbusImplScreenCast:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-ScreenCast.top_of_page">org.freedesktop.impl.portal.ScreenCast</link>.
 */

typedef XdpDbusImplScreenCastIface XdpDbusImplScreenCastInterface;
G_DEFINE_INTERFACE (XdpDbusImplScreenCast, xdp_dbus_impl_screen_cast, G_TYPE_OBJECT)

static void
xdp_dbus_impl_screen_cast_default_init (XdpDbusImplScreenCastIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpDbusImplScreenCast::handle-create-session:
   * @object: A #XdpDbusImplScreenCast.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-ScreenCast.CreateSession">CreateSession()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_screen_cast_complete_create_session() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-session",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplScreenCastIface, handle_create_session),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpDbusImplScreenCast::handle-select-sources:
   * @object: A #XdpDbusImplScreenCast.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-ScreenCast.SelectSources">SelectSources()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_screen_cast_complete_select_sources() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-select-sources",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplScreenCastIface, handle_select_sources),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpDbusImplScreenCast::handle-start:
   * @object: A #XdpDbusImplScreenCast.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_session_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-ScreenCast.Start">Start()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_screen_cast_complete_start() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-start",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplScreenCastIface, handle_start),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    6,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpDbusImplScreenCast:available-source-types:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-ScreenCast.AvailableSourceTypes">"AvailableSourceTypes"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("available-source-types", "AvailableSourceTypes", "AvailableSourceTypes", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpDbusImplScreenCast:available-cursor-modes:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-ScreenCast.AvailableCursorModes">"AvailableCursorModes"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("available-cursor-modes", "AvailableCursorModes", "AvailableCursorModes", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * XdpDbusImplScreenCast:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-ScreenCast.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_dbus_impl_screen_cast_get_available_source_types: (skip)
 * @object: A #XdpDbusImplScreenCast.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-ScreenCast.AvailableSourceTypes">"AvailableSourceTypes"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_dbus_impl_screen_cast_get_available_source_types (XdpDbusImplScreenCast *object)
{
  return XDP_DBUS_IMPL_SCREEN_CAST_GET_IFACE (object)->get_available_source_types (object);
}

/**
 * xdp_dbus_impl_screen_cast_set_available_source_types: (skip)
 * @object: A #XdpDbusImplScreenCast.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-ScreenCast.AvailableSourceTypes">"AvailableSourceTypes"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_dbus_impl_screen_cast_set_available_source_types (XdpDbusImplScreenCast *object, guint value)
{
  g_object_set (G_OBJECT (object), "available-source-types", value, NULL);
}

/**
 * xdp_dbus_impl_screen_cast_get_available_cursor_modes: (skip)
 * @object: A #XdpDbusImplScreenCast.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-ScreenCast.AvailableCursorModes">"AvailableCursorModes"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_dbus_impl_screen_cast_get_available_cursor_modes (XdpDbusImplScreenCast *object)
{
  return XDP_DBUS_IMPL_SCREEN_CAST_GET_IFACE (object)->get_available_cursor_modes (object);
}

/**
 * xdp_dbus_impl_screen_cast_set_available_cursor_modes: (skip)
 * @object: A #XdpDbusImplScreenCast.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-ScreenCast.AvailableCursorModes">"AvailableCursorModes"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_dbus_impl_screen_cast_set_available_cursor_modes (XdpDbusImplScreenCast *object, guint value)
{
  g_object_set (G_OBJECT (object), "available-cursor-modes", value, NULL);
}

/**
 * xdp_dbus_impl_screen_cast_get_version: (skip)
 * @object: A #XdpDbusImplScreenCast.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-ScreenCast.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_dbus_impl_screen_cast_get_version (XdpDbusImplScreenCast *object)
{
  return XDP_DBUS_IMPL_SCREEN_CAST_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_dbus_impl_screen_cast_set_version: (skip)
 * @object: A #XdpDbusImplScreenCast.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-ScreenCast.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_dbus_impl_screen_cast_set_version (XdpDbusImplScreenCast *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_dbus_impl_screen_cast_call_create_session:
 * @proxy: A #XdpDbusImplScreenCastProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-ScreenCast.CreateSession">CreateSession()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_screen_cast_call_create_session_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_screen_cast_call_create_session_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_screen_cast_call_create_session (
    XdpDbusImplScreenCast *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateSession",
    g_variant_new ("(oos@a{sv})",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_screen_cast_call_create_session_finish:
 * @proxy: A #XdpDbusImplScreenCastProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_screen_cast_call_create_session().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_screen_cast_call_create_session().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_screen_cast_call_create_session_finish (
    XdpDbusImplScreenCast *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_screen_cast_call_create_session_sync:
 * @proxy: A #XdpDbusImplScreenCastProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-ScreenCast.CreateSession">CreateSession()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_screen_cast_call_create_session() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_screen_cast_call_create_session_sync (
    XdpDbusImplScreenCast *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateSession",
    g_variant_new ("(oos@a{sv})",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_screen_cast_call_select_sources:
 * @proxy: A #XdpDbusImplScreenCastProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-ScreenCast.SelectSources">SelectSources()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_screen_cast_call_select_sources_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_screen_cast_call_select_sources_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_screen_cast_call_select_sources (
    XdpDbusImplScreenCast *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SelectSources",
    g_variant_new ("(oos@a{sv})",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_screen_cast_call_select_sources_finish:
 * @proxy: A #XdpDbusImplScreenCastProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_screen_cast_call_select_sources().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_screen_cast_call_select_sources().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_screen_cast_call_select_sources_finish (
    XdpDbusImplScreenCast *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_screen_cast_call_select_sources_sync:
 * @proxy: A #XdpDbusImplScreenCastProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-ScreenCast.SelectSources">SelectSources()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_screen_cast_call_select_sources() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_screen_cast_call_select_sources_sync (
    XdpDbusImplScreenCast *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SelectSources",
    g_variant_new ("(oos@a{sv})",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_screen_cast_call_start:
 * @proxy: A #XdpDbusImplScreenCastProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-ScreenCast.Start">Start()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_screen_cast_call_start_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_screen_cast_call_start_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_screen_cast_call_start (
    XdpDbusImplScreenCast *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("(ooss@a{sv})",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_screen_cast_call_start_finish:
 * @proxy: A #XdpDbusImplScreenCastProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_screen_cast_call_start().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_screen_cast_call_start().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_screen_cast_call_start_finish (
    XdpDbusImplScreenCast *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_screen_cast_call_start_sync:
 * @proxy: A #XdpDbusImplScreenCastProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_session_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-ScreenCast.Start">Start()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_screen_cast_call_start() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_screen_cast_call_start_sync (
    XdpDbusImplScreenCast *proxy,
    const gchar *arg_handle,
    const gchar *arg_session_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Start",
    g_variant_new ("(ooss@a{sv})",
                   arg_handle,
                   arg_session_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_screen_cast_complete_create_session:
 * @object: A #XdpDbusImplScreenCast.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-ScreenCast.CreateSession">CreateSession()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_screen_cast_complete_create_session (
    XdpDbusImplScreenCast *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * xdp_dbus_impl_screen_cast_complete_select_sources:
 * @object: A #XdpDbusImplScreenCast.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-ScreenCast.SelectSources">SelectSources()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_screen_cast_complete_select_sources (
    XdpDbusImplScreenCast *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * xdp_dbus_impl_screen_cast_complete_start:
 * @object: A #XdpDbusImplScreenCast.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-ScreenCast.Start">Start()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_screen_cast_complete_start (
    XdpDbusImplScreenCast *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplScreenCastProxy:
 *
 * The #XdpDbusImplScreenCastProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplScreenCastProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplScreenCastProxy.
 */

struct _XdpDbusImplScreenCastProxyPrivate
{
  GData *qdata;
};

static void xdp_dbus_impl_screen_cast_proxy_iface_init (XdpDbusImplScreenCastIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplScreenCastProxy, xdp_dbus_impl_screen_cast_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpDbusImplScreenCastProxy)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_SCREEN_CAST, xdp_dbus_impl_screen_cast_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplScreenCastProxy, xdp_dbus_impl_screen_cast_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_SCREEN_CAST, xdp_dbus_impl_screen_cast_proxy_iface_init))

#endif
static void
xdp_dbus_impl_screen_cast_proxy_finalize (GObject *object)
{
  XdpDbusImplScreenCastProxy *proxy = XDP_DBUS_IMPL_SCREEN_CAST_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_dbus_impl_screen_cast_proxy_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_screen_cast_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_dbus_impl_screen_cast_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_dbus_impl_screen_cast_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.impl.portal.ScreenCast: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_dbus_impl_screen_cast_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_dbus_impl_screen_cast_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.impl.portal.ScreenCast", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_dbus_impl_screen_cast_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_dbus_impl_screen_cast_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_dbus_impl_screen_cast_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_DBUS_IMPL_TYPE_SCREEN_CAST);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_SCREEN_CAST);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_dbus_impl_screen_cast_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpDbusImplScreenCastProxy *proxy = XDP_DBUS_IMPL_SCREEN_CAST_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_screen_cast_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_screen_cast_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_dbus_impl_screen_cast_proxy_get_available_source_types (XdpDbusImplScreenCast *object)
{
  XdpDbusImplScreenCastProxy *proxy = XDP_DBUS_IMPL_SCREEN_CAST_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AvailableSourceTypes");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
xdp_dbus_impl_screen_cast_proxy_get_available_cursor_modes (XdpDbusImplScreenCast *object)
{
  XdpDbusImplScreenCastProxy *proxy = XDP_DBUS_IMPL_SCREEN_CAST_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "AvailableCursorModes");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static guint 
xdp_dbus_impl_screen_cast_proxy_get_version (XdpDbusImplScreenCast *object)
{
  XdpDbusImplScreenCastProxy *proxy = XDP_DBUS_IMPL_SCREEN_CAST_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_dbus_impl_screen_cast_proxy_init (XdpDbusImplScreenCastProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_dbus_impl_screen_cast_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_DBUS_IMPL_TYPE_SCREEN_CAST_PROXY, XdpDbusImplScreenCastProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_dbus_impl_screen_cast_interface_info ());
}

static void
xdp_dbus_impl_screen_cast_proxy_class_init (XdpDbusImplScreenCastProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_dbus_impl_screen_cast_proxy_finalize;
  gobject_class->get_property = xdp_dbus_impl_screen_cast_proxy_get_property;
  gobject_class->set_property = xdp_dbus_impl_screen_cast_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_dbus_impl_screen_cast_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_dbus_impl_screen_cast_proxy_g_properties_changed;

  xdp_dbus_impl_screen_cast_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplScreenCastProxyPrivate));
#endif
}

static void
xdp_dbus_impl_screen_cast_proxy_iface_init (XdpDbusImplScreenCastIface *iface)
{
  iface->get_available_source_types = xdp_dbus_impl_screen_cast_proxy_get_available_source_types;
  iface->get_available_cursor_modes = xdp_dbus_impl_screen_cast_proxy_get_available_cursor_modes;
  iface->get_version = xdp_dbus_impl_screen_cast_proxy_get_version;
}

/**
 * xdp_dbus_impl_screen_cast_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-ScreenCast.top_of_page">org.freedesktop.impl.portal.ScreenCast</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_screen_cast_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_screen_cast_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_screen_cast_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_SCREEN_CAST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.ScreenCast", NULL);
}

/**
 * xdp_dbus_impl_screen_cast_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_screen_cast_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_screen_cast_proxy_new().
 *
 * Returns: (transfer full) (type XdpDbusImplScreenCastProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplScreenCast *
xdp_dbus_impl_screen_cast_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_SCREEN_CAST (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_screen_cast_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-ScreenCast.top_of_page">org.freedesktop.impl.portal.ScreenCast</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_screen_cast_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplScreenCastProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplScreenCast *
xdp_dbus_impl_screen_cast_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_SCREEN_CAST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.ScreenCast", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_SCREEN_CAST (ret);
  else
    return NULL;
}


/**
 * xdp_dbus_impl_screen_cast_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_dbus_impl_screen_cast_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_screen_cast_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_screen_cast_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_screen_cast_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_SCREEN_CAST_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.ScreenCast", NULL);
}

/**
 * xdp_dbus_impl_screen_cast_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_screen_cast_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_screen_cast_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpDbusImplScreenCastProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplScreenCast *
xdp_dbus_impl_screen_cast_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_SCREEN_CAST (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_screen_cast_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_dbus_impl_screen_cast_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_screen_cast_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplScreenCastProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplScreenCast *
xdp_dbus_impl_screen_cast_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_SCREEN_CAST_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.ScreenCast", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_SCREEN_CAST (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplScreenCastSkeleton:
 *
 * The #XdpDbusImplScreenCastSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplScreenCastSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplScreenCastSkeleton.
 */

struct _XdpDbusImplScreenCastSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_dbus_impl_screen_cast_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpDbusImplScreenCastSkeleton *skeleton = XDP_DBUS_IMPL_SCREEN_CAST_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_DBUS_IMPL_TYPE_SCREEN_CAST);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_SCREEN_CAST);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_dbus_impl_screen_cast_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplScreenCastSkeleton *skeleton = XDP_DBUS_IMPL_SCREEN_CAST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_screen_cast_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_dbus_impl_screen_cast_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplScreenCastSkeleton *skeleton = XDP_DBUS_IMPL_SCREEN_CAST_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_screen_cast_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_dbus_impl_screen_cast_skeleton_vtable =
{
  _xdp_dbus_impl_screen_cast_skeleton_handle_method_call,
  _xdp_dbus_impl_screen_cast_skeleton_handle_get_property,
  _xdp_dbus_impl_screen_cast_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_dbus_impl_screen_cast_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_dbus_impl_screen_cast_interface_info ();
}

static GDBusInterfaceVTable *
xdp_dbus_impl_screen_cast_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_dbus_impl_screen_cast_skeleton_vtable;
}

static GVariant *
xdp_dbus_impl_screen_cast_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDbusImplScreenCastSkeleton *skeleton = XDP_DBUS_IMPL_SCREEN_CAST_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_dbus_impl_screen_cast_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_dbus_impl_screen_cast_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_dbus_impl_screen_cast_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_dbus_impl_screen_cast_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.ScreenCast", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_dbus_impl_screen_cast_emit_changed (gpointer user_data);

static void
xdp_dbus_impl_screen_cast_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDbusImplScreenCastSkeleton *skeleton = XDP_DBUS_IMPL_SCREEN_CAST_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_dbus_impl_screen_cast_emit_changed (skeleton);
}

static void xdp_dbus_impl_screen_cast_skeleton_iface_init (XdpDbusImplScreenCastIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplScreenCastSkeleton, xdp_dbus_impl_screen_cast_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpDbusImplScreenCastSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_SCREEN_CAST, xdp_dbus_impl_screen_cast_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplScreenCastSkeleton, xdp_dbus_impl_screen_cast_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_SCREEN_CAST, xdp_dbus_impl_screen_cast_skeleton_iface_init))

#endif
static void
xdp_dbus_impl_screen_cast_skeleton_finalize (GObject *object)
{
  XdpDbusImplScreenCastSkeleton *skeleton = XDP_DBUS_IMPL_SCREEN_CAST_SKELETON (object);
  guint n;
  for (n = 0; n < 3; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_dbus_impl_screen_cast_skeleton_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_screen_cast_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpDbusImplScreenCastSkeleton *skeleton = XDP_DBUS_IMPL_SCREEN_CAST_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_dbus_impl_screen_cast_emit_changed (gpointer user_data)
{
  XdpDbusImplScreenCastSkeleton *skeleton = XDP_DBUS_IMPL_SCREEN_CAST_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.impl.portal.ScreenCast",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_dbus_impl_screen_cast_schedule_emit_changed (XdpDbusImplScreenCastSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_dbus_impl_screen_cast_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpDbusImplScreenCastSkeleton *skeleton = XDP_DBUS_IMPL_SCREEN_CAST_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_dbus_impl_screen_cast_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_dbus_impl_screen_cast_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_dbus_impl_screen_cast_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpDbusImplScreenCastSkeleton *skeleton = XDP_DBUS_IMPL_SCREEN_CAST_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_dbus_impl_screen_cast_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_dbus_impl_screen_cast_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_dbus_impl_screen_cast_skeleton_init (XdpDbusImplScreenCastSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_dbus_impl_screen_cast_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_DBUS_IMPL_TYPE_SCREEN_CAST_SKELETON, XdpDbusImplScreenCastSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 3);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_UINT);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_UINT);
}

static guint 
xdp_dbus_impl_screen_cast_skeleton_get_available_source_types (XdpDbusImplScreenCast *object)
{
  XdpDbusImplScreenCastSkeleton *skeleton = XDP_DBUS_IMPL_SCREEN_CAST_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
xdp_dbus_impl_screen_cast_skeleton_get_available_cursor_modes (XdpDbusImplScreenCast *object)
{
  XdpDbusImplScreenCastSkeleton *skeleton = XDP_DBUS_IMPL_SCREEN_CAST_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static guint 
xdp_dbus_impl_screen_cast_skeleton_get_version (XdpDbusImplScreenCast *object)
{
  XdpDbusImplScreenCastSkeleton *skeleton = XDP_DBUS_IMPL_SCREEN_CAST_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_dbus_impl_screen_cast_skeleton_class_init (XdpDbusImplScreenCastSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_dbus_impl_screen_cast_skeleton_finalize;
  gobject_class->get_property = xdp_dbus_impl_screen_cast_skeleton_get_property;
  gobject_class->set_property = xdp_dbus_impl_screen_cast_skeleton_set_property;
  gobject_class->notify       = xdp_dbus_impl_screen_cast_skeleton_notify;


  xdp_dbus_impl_screen_cast_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_dbus_impl_screen_cast_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_dbus_impl_screen_cast_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_dbus_impl_screen_cast_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_dbus_impl_screen_cast_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplScreenCastSkeletonPrivate));
#endif
}

static void
xdp_dbus_impl_screen_cast_skeleton_iface_init (XdpDbusImplScreenCastIface *iface)
{
  iface->get_available_source_types = xdp_dbus_impl_screen_cast_skeleton_get_available_source_types;
  iface->get_available_cursor_modes = xdp_dbus_impl_screen_cast_skeleton_get_available_cursor_modes;
  iface->get_version = xdp_dbus_impl_screen_cast_skeleton_get_version;
}

/**
 * xdp_dbus_impl_screen_cast_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-ScreenCast.top_of_page">org.freedesktop.impl.portal.ScreenCast</link>.
 *
 * Returns: (transfer full) (type XdpDbusImplScreenCastSkeleton): The skeleton object.
 */
XdpDbusImplScreenCast *
xdp_dbus_impl_screen_cast_skeleton_new (void)
{
  return XDP_DBUS_IMPL_SCREEN_CAST (g_object_new (XDP_DBUS_IMPL_TYPE_SCREEN_CAST_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Screenshot
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpDbusImplScreenshot
 * @title: XdpDbusImplScreenshot
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Screenshot D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Screenshot.top_of_page">org.freedesktop.impl.portal.Screenshot</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Screenshot ---- */

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screenshot_method_info_screenshot_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screenshot_method_info_screenshot_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screenshot_method_info_screenshot_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screenshot_method_info_screenshot_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_screenshot_method_info_screenshot_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_screenshot_method_info_screenshot_IN_ARG_handle.parent_struct,
  &_xdp_dbus_impl_screenshot_method_info_screenshot_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_screenshot_method_info_screenshot_IN_ARG_parent_window.parent_struct,
  &_xdp_dbus_impl_screenshot_method_info_screenshot_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screenshot_method_info_screenshot_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screenshot_method_info_screenshot_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_screenshot_method_info_screenshot_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_screenshot_method_info_screenshot_OUT_ARG_response.parent_struct,
  &_xdp_dbus_impl_screenshot_method_info_screenshot_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_screenshot_method_screenshot_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In3",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_screenshot_method_screenshot_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_dbus_impl_screenshot_method_screenshot_annotation_info_pointers[] =
{
  &_xdp_dbus_impl_screenshot_method_screenshot_annotation_info_0,
  &_xdp_dbus_impl_screenshot_method_screenshot_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_screenshot_method_info_screenshot =
{
  {
    -1,
    (gchar *) "Screenshot",
    (GDBusArgInfo **) &_xdp_dbus_impl_screenshot_method_info_screenshot_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_screenshot_method_info_screenshot_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_dbus_impl_screenshot_method_screenshot_annotation_info_pointers
  },
  "handle-screenshot",
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screenshot_method_info_pick_color_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screenshot_method_info_pick_color_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screenshot_method_info_pick_color_IN_ARG_parent_window =
{
  {
    -1,
    (gchar *) "parent_window",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screenshot_method_info_pick_color_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_screenshot_method_info_pick_color_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_screenshot_method_info_pick_color_IN_ARG_handle.parent_struct,
  &_xdp_dbus_impl_screenshot_method_info_pick_color_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_screenshot_method_info_pick_color_IN_ARG_parent_window.parent_struct,
  &_xdp_dbus_impl_screenshot_method_info_pick_color_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screenshot_method_info_pick_color_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_screenshot_method_info_pick_color_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_screenshot_method_info_pick_color_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_screenshot_method_info_pick_color_OUT_ARG_response.parent_struct,
  &_xdp_dbus_impl_screenshot_method_info_pick_color_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_screenshot_method_pick_color_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In3",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_screenshot_method_pick_color_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_dbus_impl_screenshot_method_pick_color_annotation_info_pointers[] =
{
  &_xdp_dbus_impl_screenshot_method_pick_color_annotation_info_0,
  &_xdp_dbus_impl_screenshot_method_pick_color_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_screenshot_method_info_pick_color =
{
  {
    -1,
    (gchar *) "PickColor",
    (GDBusArgInfo **) &_xdp_dbus_impl_screenshot_method_info_pick_color_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_screenshot_method_info_pick_color_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_dbus_impl_screenshot_method_pick_color_annotation_info_pointers
  },
  "handle-pick-color",
  FALSE
};

static const GDBusMethodInfo * const _xdp_dbus_impl_screenshot_method_info_pointers[] =
{
  &_xdp_dbus_impl_screenshot_method_info_screenshot.parent_struct,
  &_xdp_dbus_impl_screenshot_method_info_pick_color.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_dbus_impl_screenshot_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_dbus_impl_screenshot_property_info_pointers[] =
{
  &_xdp_dbus_impl_screenshot_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_dbus_impl_screenshot_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Screenshot",
    (GDBusMethodInfo **) &_xdp_dbus_impl_screenshot_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_xdp_dbus_impl_screenshot_property_info_pointers,
    NULL
  },
  "screenshot",
};


/**
 * xdp_dbus_impl_screenshot_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Screenshot.top_of_page">org.freedesktop.impl.portal.Screenshot</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_dbus_impl_screenshot_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_dbus_impl_screenshot_interface_info.parent_struct;
}

/**
 * xdp_dbus_impl_screenshot_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpDbusImplScreenshot interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_dbus_impl_screenshot_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpDbusImplScreenshot:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Screenshot.top_of_page">org.freedesktop.impl.portal.Screenshot</link>.
 */

/**
 * XdpDbusImplScreenshotIface:
 * @parent_iface: The parent interface.
 * @handle_pick_color: Handler for the #XdpDbusImplScreenshot::handle-pick-color signal.
 * @handle_screenshot: Handler for the #XdpDbusImplScreenshot::handle-screenshot signal.
 * @get_version: Getter for the #XdpDbusImplScreenshot:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Screenshot.top_of_page">org.freedesktop.impl.portal.Screenshot</link>.
 */

typedef XdpDbusImplScreenshotIface XdpDbusImplScreenshotInterface;
G_DEFINE_INTERFACE (XdpDbusImplScreenshot, xdp_dbus_impl_screenshot, G_TYPE_OBJECT)

static void
xdp_dbus_impl_screenshot_default_init (XdpDbusImplScreenshotIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * XdpDbusImplScreenshot::handle-screenshot:
   * @object: A #XdpDbusImplScreenshot.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Screenshot.Screenshot">Screenshot()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_screenshot_complete_screenshot() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-screenshot",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplScreenshotIface, handle_screenshot),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * XdpDbusImplScreenshot::handle-pick-color:
   * @object: A #XdpDbusImplScreenshot.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_handle: Argument passed by remote caller.
   * @arg_app_id: Argument passed by remote caller.
   * @arg_parent_window: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-impl-portal-Screenshot.PickColor">PickColor()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call xdp_dbus_impl_screenshot_complete_pick_color() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-pick-color",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (XdpDbusImplScreenshotIface, handle_pick_color),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * XdpDbusImplScreenshot:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-impl-portal-Screenshot.version">"version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT32, 0, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * xdp_dbus_impl_screenshot_get_version: (skip)
 * @object: A #XdpDbusImplScreenshot.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-impl-portal-Screenshot.version">"version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: The property value.
 */
guint 
xdp_dbus_impl_screenshot_get_version (XdpDbusImplScreenshot *object)
{
  return XDP_DBUS_IMPL_SCREENSHOT_GET_IFACE (object)->get_version (object);
}

/**
 * xdp_dbus_impl_screenshot_set_version: (skip)
 * @object: A #XdpDbusImplScreenshot.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-impl-portal-Screenshot.version">"version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
xdp_dbus_impl_screenshot_set_version (XdpDbusImplScreenshot *object, guint value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * xdp_dbus_impl_screenshot_call_screenshot:
 * @proxy: A #XdpDbusImplScreenshotProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Screenshot.Screenshot">Screenshot()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_screenshot_call_screenshot_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_screenshot_call_screenshot_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_screenshot_call_screenshot (
    XdpDbusImplScreenshot *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Screenshot",
    g_variant_new ("(oss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_screenshot_call_screenshot_finish:
 * @proxy: A #XdpDbusImplScreenshotProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_screenshot_call_screenshot().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_screenshot_call_screenshot().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_screenshot_call_screenshot_finish (
    XdpDbusImplScreenshot *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_screenshot_call_screenshot_sync:
 * @proxy: A #XdpDbusImplScreenshotProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Screenshot.Screenshot">Screenshot()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_screenshot_call_screenshot() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_screenshot_call_screenshot_sync (
    XdpDbusImplScreenshot *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Screenshot",
    g_variant_new ("(oss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_screenshot_call_pick_color:
 * @proxy: A #XdpDbusImplScreenshotProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Screenshot.PickColor">PickColor()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_screenshot_call_pick_color_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_screenshot_call_pick_color_sync() for the synchronous, blocking version of this method.
 */
void
xdp_dbus_impl_screenshot_call_pick_color (
    XdpDbusImplScreenshot *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PickColor",
    g_variant_new ("(oss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * xdp_dbus_impl_screenshot_call_pick_color_finish:
 * @proxy: A #XdpDbusImplScreenshotProxy.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_screenshot_call_pick_color().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with xdp_dbus_impl_screenshot_call_pick_color().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_screenshot_call_pick_color_finish (
    XdpDbusImplScreenshot *proxy,
    guint *out_response,
    GVariant **out_results,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_screenshot_call_pick_color_sync:
 * @proxy: A #XdpDbusImplScreenshotProxy.
 * @arg_handle: Argument to pass with the method invocation.
 * @arg_app_id: Argument to pass with the method invocation.
 * @arg_parent_window: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_response: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_results: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-impl-portal-Screenshot.PickColor">PickColor()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_screenshot_call_pick_color() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
xdp_dbus_impl_screenshot_call_pick_color_sync (
    XdpDbusImplScreenshot *proxy,
    const gchar *arg_handle,
    const gchar *arg_app_id,
    const gchar *arg_parent_window,
    GVariant *arg_options,
    guint *out_response,
    GVariant **out_results,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PickColor",
    g_variant_new ("(oss@a{sv})",
                   arg_handle,
                   arg_app_id,
                   arg_parent_window,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(u@a{sv})",
                 out_response,
                 out_results);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * xdp_dbus_impl_screenshot_complete_screenshot:
 * @object: A #XdpDbusImplScreenshot.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Screenshot.Screenshot">Screenshot()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_screenshot_complete_screenshot (
    XdpDbusImplScreenshot *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/**
 * xdp_dbus_impl_screenshot_complete_pick_color:
 * @object: A #XdpDbusImplScreenshot.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @response: Parameter to return.
 * @results: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-impl-portal-Screenshot.PickColor">PickColor()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
xdp_dbus_impl_screenshot_complete_pick_color (
    XdpDbusImplScreenshot *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    guint response,
    GVariant *results)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(u@a{sv})",
                   response,
                   results));
}

/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplScreenshotProxy:
 *
 * The #XdpDbusImplScreenshotProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplScreenshotProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplScreenshotProxy.
 */

struct _XdpDbusImplScreenshotProxyPrivate
{
  GData *qdata;
};

static void xdp_dbus_impl_screenshot_proxy_iface_init (XdpDbusImplScreenshotIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplScreenshotProxy, xdp_dbus_impl_screenshot_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (XdpDbusImplScreenshotProxy)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_SCREENSHOT, xdp_dbus_impl_screenshot_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplScreenshotProxy, xdp_dbus_impl_screenshot_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_SCREENSHOT, xdp_dbus_impl_screenshot_proxy_iface_init))

#endif
static void
xdp_dbus_impl_screenshot_proxy_finalize (GObject *object)
{
  XdpDbusImplScreenshotProxy *proxy = XDP_DBUS_IMPL_SCREENSHOT_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (xdp_dbus_impl_screenshot_proxy_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_screenshot_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_dbus_impl_screenshot_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
xdp_dbus_impl_screenshot_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.impl.portal.Screenshot: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
xdp_dbus_impl_screenshot_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_dbus_impl_screenshot_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.impl.portal.Screenshot", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) xdp_dbus_impl_screenshot_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
xdp_dbus_impl_screenshot_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_xdp_dbus_impl_screenshot_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], XDP_DBUS_IMPL_TYPE_SCREENSHOT);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_SCREENSHOT);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
xdp_dbus_impl_screenshot_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  XdpDbusImplScreenshotProxy *proxy = XDP_DBUS_IMPL_SCREENSHOT_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_screenshot_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_screenshot_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static guint 
xdp_dbus_impl_screenshot_proxy_get_version (XdpDbusImplScreenshot *object)
{
  XdpDbusImplScreenshotProxy *proxy = XDP_DBUS_IMPL_SCREENSHOT_PROXY (object);
  GVariant *variant;
  guint value = 0;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "version");
  if (variant != NULL)
    {
      value = g_variant_get_uint32 (variant);
      g_variant_unref (variant);
    }
  return value;
}

static void
xdp_dbus_impl_screenshot_proxy_init (XdpDbusImplScreenshotProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = xdp_dbus_impl_screenshot_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, XDP_DBUS_IMPL_TYPE_SCREENSHOT_PROXY, XdpDbusImplScreenshotProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), xdp_dbus_impl_screenshot_interface_info ());
}

static void
xdp_dbus_impl_screenshot_proxy_class_init (XdpDbusImplScreenshotProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = xdp_dbus_impl_screenshot_proxy_finalize;
  gobject_class->get_property = xdp_dbus_impl_screenshot_proxy_get_property;
  gobject_class->set_property = xdp_dbus_impl_screenshot_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = xdp_dbus_impl_screenshot_proxy_g_signal;
  proxy_class->g_properties_changed = xdp_dbus_impl_screenshot_proxy_g_properties_changed;

  xdp_dbus_impl_screenshot_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplScreenshotProxyPrivate));
#endif
}

static void
xdp_dbus_impl_screenshot_proxy_iface_init (XdpDbusImplScreenshotIface *iface)
{
  iface->get_version = xdp_dbus_impl_screenshot_proxy_get_version;
}

/**
 * xdp_dbus_impl_screenshot_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Screenshot.top_of_page">org.freedesktop.impl.portal.Screenshot</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_screenshot_proxy_new_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_screenshot_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_screenshot_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_SCREENSHOT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Screenshot", NULL);
}

/**
 * xdp_dbus_impl_screenshot_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_screenshot_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_screenshot_proxy_new().
 *
 * Returns: (transfer full) (type XdpDbusImplScreenshotProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplScreenshot *
xdp_dbus_impl_screenshot_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_SCREENSHOT (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_screenshot_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Screenshot.top_of_page">org.freedesktop.impl.portal.Screenshot</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_screenshot_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplScreenshotProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplScreenshot *
xdp_dbus_impl_screenshot_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_SCREENSHOT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Screenshot", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_SCREENSHOT (ret);
  else
    return NULL;
}


/**
 * xdp_dbus_impl_screenshot_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like xdp_dbus_impl_screenshot_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call xdp_dbus_impl_screenshot_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See xdp_dbus_impl_screenshot_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
xdp_dbus_impl_screenshot_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (XDP_DBUS_IMPL_TYPE_SCREENSHOT_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Screenshot", NULL);
}

/**
 * xdp_dbus_impl_screenshot_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to xdp_dbus_impl_screenshot_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with xdp_dbus_impl_screenshot_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type XdpDbusImplScreenshotProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplScreenshot *
xdp_dbus_impl_screenshot_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return XDP_DBUS_IMPL_SCREENSHOT (ret);
  else
    return NULL;
}

/**
 * xdp_dbus_impl_screenshot_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like xdp_dbus_impl_screenshot_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See xdp_dbus_impl_screenshot_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type XdpDbusImplScreenshotProxy): The constructed proxy object or %NULL if @error is set.
 */
XdpDbusImplScreenshot *
xdp_dbus_impl_screenshot_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (XDP_DBUS_IMPL_TYPE_SCREENSHOT_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.impl.portal.Screenshot", NULL);
  if (ret != NULL)
    return XDP_DBUS_IMPL_SCREENSHOT (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * XdpDbusImplScreenshotSkeleton:
 *
 * The #XdpDbusImplScreenshotSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * XdpDbusImplScreenshotSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #XdpDbusImplScreenshotSkeleton.
 */

struct _XdpDbusImplScreenshotSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_xdp_dbus_impl_screenshot_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  XdpDbusImplScreenshotSkeleton *skeleton = XDP_DBUS_IMPL_SCREENSHOT_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], XDP_DBUS_IMPL_TYPE_SCREENSHOT);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, XDP_DBUS_IMPL_TYPE_SCREENSHOT);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_xdp_dbus_impl_screenshot_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplScreenshotSkeleton *skeleton = XDP_DBUS_IMPL_SCREENSHOT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_screenshot_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_xdp_dbus_impl_screenshot_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  XdpDbusImplScreenshotSkeleton *skeleton = XDP_DBUS_IMPL_SCREENSHOT_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_xdp_dbus_impl_screenshot_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _xdp_dbus_impl_screenshot_skeleton_vtable =
{
  _xdp_dbus_impl_screenshot_skeleton_handle_method_call,
  _xdp_dbus_impl_screenshot_skeleton_handle_get_property,
  _xdp_dbus_impl_screenshot_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
xdp_dbus_impl_screenshot_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return xdp_dbus_impl_screenshot_interface_info ();
}

static GDBusInterfaceVTable *
xdp_dbus_impl_screenshot_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_xdp_dbus_impl_screenshot_skeleton_vtable;
}

static GVariant *
xdp_dbus_impl_screenshot_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDbusImplScreenshotSkeleton *skeleton = XDP_DBUS_IMPL_SCREENSHOT_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_xdp_dbus_impl_screenshot_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _xdp_dbus_impl_screenshot_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _xdp_dbus_impl_screenshot_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _xdp_dbus_impl_screenshot_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.impl.portal.Screenshot", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _xdp_dbus_impl_screenshot_emit_changed (gpointer user_data);

static void
xdp_dbus_impl_screenshot_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  XdpDbusImplScreenshotSkeleton *skeleton = XDP_DBUS_IMPL_SCREENSHOT_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _xdp_dbus_impl_screenshot_emit_changed (skeleton);
}

static void xdp_dbus_impl_screenshot_skeleton_iface_init (XdpDbusImplScreenshotIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplScreenshotSkeleton, xdp_dbus_impl_screenshot_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (XdpDbusImplScreenshotSkeleton)
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_SCREENSHOT, xdp_dbus_impl_screenshot_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (XdpDbusImplScreenshotSkeleton, xdp_dbus_impl_screenshot_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (XDP_DBUS_IMPL_TYPE_SCREENSHOT, xdp_dbus_impl_screenshot_skeleton_iface_init))

#endif
static void
xdp_dbus_impl_screenshot_skeleton_finalize (GObject *object)
{
  XdpDbusImplScreenshotSkeleton *skeleton = XDP_DBUS_IMPL_SCREENSHOT_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (xdp_dbus_impl_screenshot_skeleton_parent_class)->finalize (object);
}

static void
xdp_dbus_impl_screenshot_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  XdpDbusImplScreenshotSkeleton *skeleton = XDP_DBUS_IMPL_SCREENSHOT_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_xdp_dbus_impl_screenshot_emit_changed (gpointer user_data)
{
  XdpDbusImplScreenshotSkeleton *skeleton = XDP_DBUS_IMPL_SCREENSHOT_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.impl.portal.Screenshot",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_xdp_dbus_impl_screenshot_schedule_emit_changed (XdpDbusImplScreenshotSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
xdp_dbus_impl_screenshot_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  XdpDbusImplScreenshotSkeleton *skeleton = XDP_DBUS_IMPL_SCREENSHOT_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _xdp_dbus_impl_screenshot_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _xdp_dbus_impl_screenshot_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
xdp_dbus_impl_screenshot_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  XdpDbusImplScreenshotSkeleton *skeleton = XDP_DBUS_IMPL_SCREENSHOT_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _xdp_dbus_impl_screenshot_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _xdp_dbus_impl_screenshot_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
xdp_dbus_impl_screenshot_skeleton_init (XdpDbusImplScreenshotSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = xdp_dbus_impl_screenshot_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, XDP_DBUS_IMPL_TYPE_SCREENSHOT_SKELETON, XdpDbusImplScreenshotSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_UINT);
}

static guint 
xdp_dbus_impl_screenshot_skeleton_get_version (XdpDbusImplScreenshot *object)
{
  XdpDbusImplScreenshotSkeleton *skeleton = XDP_DBUS_IMPL_SCREENSHOT_SKELETON (object);
  guint value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_uint (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
xdp_dbus_impl_screenshot_skeleton_class_init (XdpDbusImplScreenshotSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = xdp_dbus_impl_screenshot_skeleton_finalize;
  gobject_class->get_property = xdp_dbus_impl_screenshot_skeleton_get_property;
  gobject_class->set_property = xdp_dbus_impl_screenshot_skeleton_set_property;
  gobject_class->notify       = xdp_dbus_impl_screenshot_skeleton_notify;


  xdp_dbus_impl_screenshot_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = xdp_dbus_impl_screenshot_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = xdp_dbus_impl_screenshot_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = xdp_dbus_impl_screenshot_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = xdp_dbus_impl_screenshot_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (XdpDbusImplScreenshotSkeletonPrivate));
#endif
}

static void
xdp_dbus_impl_screenshot_skeleton_iface_init (XdpDbusImplScreenshotIface *iface)
{
  iface->get_version = xdp_dbus_impl_screenshot_skeleton_get_version;
}

/**
 * xdp_dbus_impl_screenshot_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Screenshot.top_of_page">org.freedesktop.impl.portal.Screenshot</link>.
 *
 * Returns: (transfer full) (type XdpDbusImplScreenshotSkeleton): The skeleton object.
 */
XdpDbusImplScreenshot *
xdp_dbus_impl_screenshot_skeleton_new (void)
{
  return XDP_DBUS_IMPL_SCREENSHOT (g_object_new (XDP_DBUS_IMPL_TYPE_SCREENSHOT_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.impl.portal.Secret
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:XdpDbusImplSecret
 * @title: XdpDbusImplSecret
 * @short_description: Generated C code for the org.freedesktop.impl.portal.Secret D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Secret.top_of_page">org.freedesktop.impl.portal.Secret</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.impl.portal.Secret ---- */

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_secret_method_info_retrieve_secret_IN_ARG_handle =
{
  {
    -1,
    (gchar *) "handle",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_secret_method_info_retrieve_secret_IN_ARG_app_id =
{
  {
    -1,
    (gchar *) "app_id",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_secret_method_info_retrieve_secret_IN_ARG_fd =
{
  {
    -1,
    (gchar *) "fd",
    (gchar *) "h",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_secret_method_info_retrieve_secret_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_secret_method_info_retrieve_secret_IN_ARG_pointers[] =
{
  &_xdp_dbus_impl_secret_method_info_retrieve_secret_IN_ARG_handle.parent_struct,
  &_xdp_dbus_impl_secret_method_info_retrieve_secret_IN_ARG_app_id.parent_struct,
  &_xdp_dbus_impl_secret_method_info_retrieve_secret_IN_ARG_fd.parent_struct,
  &_xdp_dbus_impl_secret_method_info_retrieve_secret_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_secret_method_info_retrieve_secret_OUT_ARG_response =
{
  {
    -1,
    (gchar *) "response",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _xdp_dbus_impl_secret_method_info_retrieve_secret_OUT_ARG_results =
{
  {
    -1,
    (gchar *) "results",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _xdp_dbus_impl_secret_method_info_retrieve_secret_OUT_ARG_pointers[] =
{
  &_xdp_dbus_impl_secret_method_info_retrieve_secret_OUT_ARG_response.parent_struct,
  &_xdp_dbus_impl_secret_method_info_retrieve_secret_OUT_ARG_results.parent_struct,
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_secret_method_retrieve_secret_annotation_info_0 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.In3",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo _xdp_dbus_impl_secret_method_retrieve_secret_annotation_info_1 =
{
  -1,
  (gchar *) "org.qtproject.QtDBus.QtTypeName.Out1",
  (gchar *) "QVariantMap",
  NULL
};

static const GDBusAnnotationInfo * const _xdp_dbus_impl_secret_method_retrieve_secret_annotation_info_pointers[] =
{
  &_xdp_dbus_impl_secret_method_retrieve_secret_annotation_info_0,
  &_xdp_dbus_impl_secret_method_retrieve_secret_annotation_info_1,
  NULL
};

static const _ExtendedGDBusMethodInfo _xdp_dbus_impl_secret_method_info_retrieve_secret =
{
  {
    -1,
    (gchar *) "RetrieveSecret",
    (GDBusArgInfo **) &_xdp_dbus_impl_secret_method_info_retrieve_secret_IN_ARG_pointers,
    (GDBusArgInfo **) &_xdp_dbus_impl_secret_method_info_retrieve_secret_OUT_ARG_pointers,
    (GDBusAnnotationInfo **) &_xdp_dbus_impl_secret_method_retrieve_secret_annotation_info_pointers
  },
  "handle-retrieve-secret",
  TRUE
};

static const GDBusMethodInfo * const _xdp_dbus_impl_secret_method_info_pointers[] =
{
  &_xdp_dbus_impl_secret_method_info_retrieve_secret.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _xdp_dbus_impl_secret_property_info_version =
{
  {
    -1,
    (gchar *) "version",
    (gchar *) "u",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _xdp_dbus_impl_secret_property_info_pointers[] =
{
  &_xdp_dbus_impl_secret_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _xdp_dbus_impl_secret_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.impl.portal.Secret",
    (GDBusMethodInfo **) &_xdp_dbus_impl_secret_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_xdp_dbus_impl_secret_property_info_pointers,
    NULL
  },
  "secret",
};


/**
 * xdp_dbus_impl_secret_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-impl-portal-Secret.top_of_page">org.freedesktop.impl.portal.Secret</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
xdp_dbus_impl_secret_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_xdp_dbus_impl_secret_interface_info.parent_struct;
}

/**
 * xdp_dbus_impl_secret_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #XdpDbusImplSecret interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
xdp_dbus_impl_secret_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}



/**
 * XdpDbusImplSecret:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Secret.top_of_page">org.freedesktop.impl.portal.Secret</link>.
 */

/**
 * XdpDbusImplSecretIface:
 * @parent_iface: The parent interface.
 * @handle_retrieve_secret: Handler for the #XdpDbusImplSecret::handle-retrieve-secret signal.
 * @get_version: Getter for the #XdpDbusImplSecret:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-impl-portal-Secret.top_of_page">org.freedesktop.impl.portal.Secret</link>.
 */

typedef XdpDbusImplSecretIface XdpD