/* TrayApplet.c generated by valac 0.56.3, the Vala compiler
 * generated from TrayApplet.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "trayapplet.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "plugin.h"
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gobject/gvaluecollector.h>
#include "tray.h"
#include <gdk/gdkx.h>
#include <glib/gi18n-lib.h>
#include <libpeas/peas.h>

enum  {
	TRAY_PLUGIN_0_PROPERTY,
	TRAY_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* tray_plugin_properties[TRAY_PLUGIN_NUM_PROPERTIES];
enum  {
	TRAY_SETTINGS_0_PROPERTY,
	TRAY_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* tray_settings_properties[TRAY_SETTINGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_TRAY_ERROR_ICON (tray_error_icon_get_type ())
#define TRAY_ERROR_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRAY_ERROR_ICON, TrayErrorIcon))
#define TRAY_ERROR_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRAY_ERROR_ICON, TrayErrorIconClass))
#define IS_TRAY_ERROR_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRAY_ERROR_ICON))
#define IS_TRAY_ERROR_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRAY_ERROR_ICON))
#define TRAY_ERROR_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRAY_ERROR_ICON, TrayErrorIconClass))

typedef struct _TrayErrorIcon TrayErrorIcon;
typedef struct _TrayErrorIconClass TrayErrorIconClass;
typedef struct _TrayErrorIconPrivate TrayErrorIconPrivate;
typedef struct _ParamSpecTrayErrorIcon ParamSpecTrayErrorIcon;
enum  {
	TRAY_APPLET_0_PROPERTY,
	TRAY_APPLET_UUID_PROPERTY,
	TRAY_APPLET_NUM_PROPERTIES
};
static GParamSpec* tray_applet_properties[TRAY_APPLET_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _tray_error_icon_unref0(var) ((var == NULL) ? NULL : (var = (tray_error_icon_unref (var), NULL)))

struct _TraySettingsPrivate {
	GSettings* settings;
	GtkSpinButton* spinbutton_spacing;
};

struct _TrayErrorIcon {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TrayErrorIconPrivate * priv;
	BudgiePopoverManager* manager;
	BudgiePopover* popover;
};

struct _TrayErrorIconClass {
	GTypeClass parent_class;
	void (*finalize) (TrayErrorIcon *self);
};

struct _TrayErrorIconPrivate {
	GtkEventBox* parent;
};

struct _ParamSpecTrayErrorIcon {
	GParamSpec parent_instance;
};

struct _TrayAppletPrivate {
	gchar* _uuid;
	CarbonTray* tray;
	GtkEventBox* box;
	GSettings* settings;
	GtkOrientation orient;
	GdkX11Screen* screen;
	TrayErrorIcon* errorIcon;
};

static gpointer tray_plugin_parent_class = NULL;
static BudgiePluginIface * tray_plugin_budgie_plugin_parent_iface = NULL;
static GType tray_plugin_type_id = 0;
static gint TraySettings_private_offset;
static gpointer tray_settings_parent_class = NULL;
static GType tray_settings_type_id = 0;
static gint TrayErrorIcon_private_offset;
static gpointer tray_error_icon_parent_class = NULL;
static GType tray_error_icon_type_id = 0;
static gint TrayApplet_private_offset;
static gpointer tray_applet_parent_class = NULL;
static gchar* tray_applet_activeUuid;
static gchar* tray_applet_activeUuid = NULL;
static GType tray_applet_type_id = 0;

static BudgieApplet* tray_plugin_real_get_panel_widget (BudgiePlugin* base,
                                                 const gchar* uuid);
static void tray_settings_finalize (GObject * obj);
VALA_EXTERN gpointer tray_error_icon_ref (gpointer instance);
VALA_EXTERN void tray_error_icon_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_tray_error_icon (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_tray_error_icon (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_tray_error_icon (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_tray_error_icon (const GValue* value);
GType tray_error_icon_register_type (GTypeModule * module);
VALA_EXTERN GType tray_error_icon_get_type (void) G_GNUC_CONST ;
static gboolean tray_error_icon_on_button_press (TrayErrorIcon* self,
                                          GdkEventButton* event);
static gboolean _tray_error_icon_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                         GdkEventButton* event,
                                                                         gpointer self);
VALA_EXTERN TrayErrorIcon* tray_error_icon_new (GtkEventBox* parent,
                                    const gchar* text);
VALA_EXTERN TrayErrorIcon* tray_error_icon_construct (GType object_type,
                                          GtkEventBox* parent,
                                          const gchar* text);
VALA_EXTERN void tray_error_icon_register (TrayErrorIcon* self,
                               BudgiePopoverManager* newManager);
static void tray_error_icon_finalize (TrayErrorIcon * obj);
static void __lambda4_ (TrayApplet* self,
                 const gchar* key);
static void ___lambda4__g_settings_changed (GSettings* _sender,
                                     const gchar* key,
                                     gpointer self);
static void tray_applet_reintegrate_tray (TrayApplet* self);
static void _tray_applet_reintegrate_tray_gdk_screen_monitors_changed (GdkScreen* _sender,
                                                                gpointer self);
static void ___lambda5_ (TrayApplet* self,
                  GtkWidget* old_parent);
static void ____lambda5__gtk_widget_parent_set (GtkWidget* _sender,
                                         GtkWidget* previous_parent,
                                         gpointer self);
static void tray_applet_maybe_integrate_tray (TrayApplet* self);
static void tray_applet_real_panel_position_changed (BudgieApplet* base,
                                              BudgiePanelPosition position);
static void tray_applet_real_update_popovers (BudgieApplet* base,
                                       BudgiePopoverManager* manager);
static gboolean tray_applet_real_supports_settings (BudgieApplet* base);
static GtkWidget* tray_applet_real_get_settings_ui (BudgieApplet* base);
static void tray_applet_finalize (GObject * obj);
static void _vala_tray_applet_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_tray_applet_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);

static BudgieApplet*
tray_plugin_real_get_panel_widget (BudgiePlugin* base,
                                   const gchar* uuid)
{
	TrayPlugin * self;
	TrayApplet* _tmp0_;
	BudgieApplet* result;
	self = (TrayPlugin*) base;
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = tray_applet_new (uuid);
	g_object_ref_sink (_tmp0_);
	result = (BudgieApplet*) _tmp0_;
	return result;
}

TrayPlugin*
tray_plugin_construct (GType object_type)
{
	TrayPlugin * self = NULL;
	self = (TrayPlugin*) g_object_new (object_type, NULL);
	return self;
}

TrayPlugin*
tray_plugin_new (void)
{
	return tray_plugin_construct (TYPE_TRAY_PLUGIN);
}

static void
tray_plugin_class_init (TrayPluginClass * klass,
                        gpointer klass_data)
{
	tray_plugin_parent_class = g_type_class_peek_parent (klass);
}

static void
tray_plugin_budgie_plugin_interface_init (BudgiePluginIface * iface,
                                          gpointer iface_data)
{
	tray_plugin_budgie_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_panel_widget = (BudgieApplet* (*) (BudgiePlugin*, const gchar*)) tray_plugin_real_get_panel_widget;
}

static void
tray_plugin_instance_init (TrayPlugin * self,
                           gpointer klass)
{
}

GType
tray_plugin_get_type (void)
{
	return tray_plugin_type_id;
}

GType
tray_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrayPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tray_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrayPlugin), 0, (GInstanceInitFunc) tray_plugin_instance_init, NULL };
	static const GInterfaceInfo budgie_plugin_info = { (GInterfaceInitFunc) tray_plugin_budgie_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	tray_plugin_type_id = g_type_module_register_type (module, peas_extension_base_get_type (), "TrayPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, tray_plugin_type_id, budgie_plugin_get_type (), &budgie_plugin_info);
	return tray_plugin_type_id;
}

static inline gpointer
tray_settings_get_instance_private (TraySettings* self)
{
	return G_STRUCT_MEMBER_P (self, TraySettings_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

TraySettings*
tray_settings_construct (GType object_type,
                         GSettings* settings)
{
	TraySettings * self = NULL;
	GSettings* _tmp0_;
	GtkSpinButton* _tmp1_;
	self = (TraySettings*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->spinbutton_spacing;
	g_settings_bind (settings, "spacing", (GObject*) _tmp1_, "value", G_SETTINGS_BIND_DEFAULT);
	return self;
}

TraySettings*
tray_settings_new (GSettings* settings)
{
	return tray_settings_construct (TYPE_TRAY_SETTINGS, settings);
}

static void
tray_settings_class_init (TraySettingsClass * klass,
                          gpointer klass_data)
{
	tray_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TraySettings_private_offset);
	G_OBJECT_CLASS (klass)->finalize = tray_settings_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/solus-project/tray/settings.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "spinbutton_spacing", FALSE, TraySettings_private_offset + G_STRUCT_OFFSET (TraySettingsPrivate, spinbutton_spacing));
}

static void
tray_settings_instance_init (TraySettings * self,
                             gpointer klass)
{
	self->priv = tray_settings_get_instance_private (self);
	self->priv->settings = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
tray_settings_finalize (GObject * obj)
{
	TraySettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TRAY_SETTINGS, TraySettings);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (tray_settings_parent_class)->finalize (obj);
}

GType
tray_settings_get_type (void)
{
	return tray_settings_type_id;
}

GType
tray_settings_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (TraySettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tray_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TraySettings), 0, (GInstanceInitFunc) tray_settings_instance_init, NULL };
	tray_settings_type_id = g_type_module_register_type (module, gtk_grid_get_type (), "TraySettings", &g_define_type_info, 0);
	TraySettings_private_offset = sizeof (TraySettingsPrivate);
	return tray_settings_type_id;
}

static inline gpointer
tray_error_icon_get_instance_private (TrayErrorIcon* self)
{
	return G_STRUCT_MEMBER_P (self, TrayErrorIcon_private_offset);
}

static gboolean
_tray_error_icon_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                GdkEventButton* event,
                                                                gpointer self)
{
	gboolean result;
	result = tray_error_icon_on_button_press ((TrayErrorIcon*) self, event);
	return result;
}

TrayErrorIcon*
tray_error_icon_construct (GType object_type,
                           GtkEventBox* parent,
                           const gchar* text)
{
	TrayErrorIcon* self = NULL;
	GtkEventBox* _tmp0_;
	GtkImage* _tmp1_;
	GtkImage* _tmp2_;
	BudgiePopover* _tmp3_;
	BudgiePopover* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp6_;
	BudgiePopover* _tmp7_;
	BudgiePopover* _tmp8_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	self = (TrayErrorIcon*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (parent);
	_g_object_unref0 (self->priv->parent);
	self->priv->parent = _tmp0_;
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("gtk-dialog-error", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	gtk_container_add ((GtkContainer*) parent, (GtkWidget*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = (BudgiePopover*) budgie_popover_new ((GtkWidget*) parent);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->popover);
	self->popover = _tmp3_;
	_tmp4_ = self->popover;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
	gtk_style_context_add_class (_tmp5_, "system-tray-popover");
	_tmp6_ = (GtkLabel*) gtk_label_new (text);
	g_object_ref_sink (_tmp6_);
	label = _tmp6_;
	gtk_widget_show ((GtkWidget*) label);
	_tmp7_ = self->popover;
	gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) label);
	_tmp8_ = self->popover;
	gtk_widget_hide ((GtkWidget*) _tmp8_);
	g_signal_connect ((GtkWidget*) parent, "button-press-event", (GCallback) _tray_error_icon_on_button_press_gtk_widget_button_press_event, self);
	_g_object_unref0 (label);
	return self;
}

TrayErrorIcon*
tray_error_icon_new (GtkEventBox* parent,
                     const gchar* text)
{
	return tray_error_icon_construct (TYPE_TRAY_ERROR_ICON, parent, text);
}

void
tray_error_icon_register (TrayErrorIcon* self,
                          BudgiePopoverManager* newManager)
{
	BudgiePopoverManager* _tmp0_;
	BudgiePopoverManager* _tmp1_;
	GtkEventBox* _tmp2_;
	BudgiePopover* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (newManager != NULL);
	_tmp0_ = _g_object_ref0 (newManager);
	_g_object_unref0 (self->manager);
	self->manager = _tmp0_;
	_tmp1_ = self->manager;
	_tmp2_ = self->priv->parent;
	_tmp3_ = self->popover;
	budgie_popover_manager_register_popover (_tmp1_, (GtkWidget*) _tmp2_, _tmp3_);
}

static gboolean
tray_error_icon_on_button_press (TrayErrorIcon* self,
                                 GdkEventButton* event)
{
	BudgiePopover* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button != ((guint) 1)) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp0_ = self->popover;
	if (gtk_widget_get_visible ((GtkWidget*) _tmp0_)) {
		BudgiePopover* _tmp1_;
		_tmp1_ = self->popover;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	} else {
		BudgiePopoverManager* _tmp2_;
		GtkEventBox* _tmp3_;
		_tmp2_ = self->manager;
		_tmp3_ = self->priv->parent;
		budgie_popover_manager_show_popover (_tmp2_, (GtkWidget*) _tmp3_);
	}
	result = GDK_EVENT_STOP;
	return result;
}

static void
value_tray_error_icon_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_tray_error_icon_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		tray_error_icon_unref (value->data[0].v_pointer);
	}
}

static void
value_tray_error_icon_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tray_error_icon_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_tray_error_icon_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_tray_error_icon_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		TrayErrorIcon * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tray_error_icon_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_tray_error_icon_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	TrayErrorIcon ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tray_error_icon_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_tray_error_icon (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	ParamSpecTrayErrorIcon* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TRAY_ERROR_ICON), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_tray_error_icon (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TRAY_ERROR_ICON), NULL);
	return value->data[0].v_pointer;
}

void
value_set_tray_error_icon (GValue* value,
                           gpointer v_object)
{
	TrayErrorIcon * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TRAY_ERROR_ICON));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TRAY_ERROR_ICON));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tray_error_icon_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tray_error_icon_unref (old);
	}
}

void
value_take_tray_error_icon (GValue* value,
                            gpointer v_object)
{
	TrayErrorIcon * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TRAY_ERROR_ICON));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TRAY_ERROR_ICON));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tray_error_icon_unref (old);
	}
}

static void
tray_error_icon_class_init (TrayErrorIconClass * klass,
                            gpointer klass_data)
{
	tray_error_icon_parent_class = g_type_class_peek_parent (klass);
	((TrayErrorIconClass *) klass)->finalize = tray_error_icon_finalize;
	g_type_class_adjust_private_offset (klass, &TrayErrorIcon_private_offset);
}

static void
tray_error_icon_instance_init (TrayErrorIcon * self,
                               gpointer klass)
{
	self->priv = tray_error_icon_get_instance_private (self);
	self->ref_count = 1;
}

static void
tray_error_icon_finalize (TrayErrorIcon * obj)
{
	TrayErrorIcon * self;
	GtkEventBox* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TRAY_ERROR_ICON, TrayErrorIcon);
	g_signal_handlers_destroy (self);
	_tmp0_ = self->priv->parent;
	g_signal_parse_name ("button-press-event", gtk_widget_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkWidget*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _tray_error_icon_on_button_press_gtk_widget_button_press_event, self);
	_g_object_unref0 (self->manager);
	_g_object_unref0 (self->popover);
	_g_object_unref0 (self->priv->parent);
}

GType
tray_error_icon_get_type (void)
{
	return tray_error_icon_type_id;
}

GType
tray_error_icon_register_type (GTypeModule * module)
{
	static const GTypeValueTable g_define_type_value_table = { value_tray_error_icon_init, value_tray_error_icon_free_value, value_tray_error_icon_copy_value, value_tray_error_icon_peek_pointer, "p", value_tray_error_icon_collect_value, "p", value_tray_error_icon_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TrayErrorIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tray_error_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrayErrorIcon), 0, (GInstanceInitFunc) tray_error_icon_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	tray_error_icon_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TrayErrorIcon", &g_define_type_info, &g_define_type_fundamental_info, 0);
	TrayErrorIcon_private_offset = sizeof (TrayErrorIconPrivate);
	return tray_error_icon_type_id;
}

gpointer
tray_error_icon_ref (gpointer instance)
{
	TrayErrorIcon * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
tray_error_icon_unref (gpointer instance)
{
	TrayErrorIcon * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TRAY_ERROR_ICON_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
tray_applet_get_instance_private (TrayApplet* self)
{
	return G_STRUCT_MEMBER_P (self, TrayApplet_private_offset);
}

static void
__lambda4_ (TrayApplet* self,
            const gchar* key)
{
	CarbonTray* _tmp0_;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->tray;
	if (_tmp0_ != NULL) {
		CarbonTray* _tmp1_;
		GSettings* _tmp2_;
		_tmp1_ = self->priv->tray;
		_tmp2_ = self->priv->settings;
		carbon_tray_set_spacing (_tmp1_, g_settings_get_int (_tmp2_, "spacing"));
	}
}

static void
___lambda4__g_settings_changed (GSettings* _sender,
                                const gchar* key,
                                gpointer self)
{
	__lambda4_ ((TrayApplet*) self, key);
}

static void
_tray_applet_reintegrate_tray_gdk_screen_monitors_changed (GdkScreen* _sender,
                                                           gpointer self)
{
	tray_applet_reintegrate_tray ((TrayApplet*) self);
}

static void
___lambda5_ (TrayApplet* self,
             GtkWidget* old_parent)
{
	tray_applet_reintegrate_tray (self);
}

static void
____lambda5__gtk_widget_parent_set (GtkWidget* _sender,
                                    GtkWidget* previous_parent,
                                    gpointer self)
{
	___lambda5_ ((TrayApplet*) self, previous_parent);
}

TrayApplet*
tray_applet_construct (GType object_type,
                       const gchar* uuid)
{
	TrayApplet * self = NULL;
	GtkStyleContext* _tmp0_;
	GtkEventBox* _tmp1_;
	GtkEventBox* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	const gchar* _tmp5_;
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (TrayApplet*) g_object_new (object_type, "uuid", uuid, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "system-tray-applet");
	_tmp1_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->box);
	self->priv->box = _tmp1_;
	_tmp2_ = self->priv->box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
	budgie_applet_set_settings_schema ((BudgieApplet*) self, "com.solus-project.tray");
	budgie_applet_set_settings_prefix ((BudgieApplet*) self, "/com/solus-project/budgie-panel/instance/tray");
	_tmp3_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, uuid);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp3_;
	_tmp4_ = self->priv->settings;
	g_signal_connect_object (_tmp4_, "changed::spacing", (GCallback) ___lambda4__g_settings_changed, self, 0);
	_tmp5_ = tray_applet_activeUuid;
	if (_tmp5_ == NULL) {
		gchar* _tmp6_;
		GdkScreen* _tmp7_;
		GdkX11Screen* _tmp8_;
		GdkX11Screen* _tmp9_;
		_tmp6_ = g_strdup (uuid);
		_g_free0 (tray_applet_activeUuid);
		tray_applet_activeUuid = _tmp6_;
		_tmp7_ = gtk_widget_get_screen ((GtkWidget*) self);
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gdk_x11_screen_get_type (), GdkX11Screen));
		_g_object_unref0 (self->priv->screen);
		self->priv->screen = _tmp8_;
		_tmp9_ = self->priv->screen;
		g_signal_connect_object ((GdkScreen*) _tmp9_, "monitors-changed", (GCallback) _tray_applet_reintegrate_tray_gdk_screen_monitors_changed, self, 0);
		g_signal_connect_object ((GtkWidget*) self, "parent-set", (GCallback) ____lambda5__gtk_widget_parent_set, self, 0);
		tray_applet_maybe_integrate_tray (self);
	} else {
		GtkEventBox* _tmp10_;
		TrayErrorIcon* _tmp11_;
		_tmp10_ = self->priv->box;
		_tmp11_ = tray_error_icon_new (_tmp10_, _ ("Only one instance of the System Tray can be active at a time."));
		_tray_error_icon_unref0 (self->priv->errorIcon);
		self->priv->errorIcon = _tmp11_;
		gtk_widget_show_all ((GtkWidget*) self);
	}
	return self;
}

TrayApplet*
tray_applet_new (const gchar* uuid)
{
	return tray_applet_construct (TYPE_TRAY_APPLET, uuid);
}

static void
tray_applet_reintegrate_tray (TrayApplet* self)
{
	CarbonTray* _tmp0_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tray;
	if (_tmp0_ != NULL) {
		CarbonTray* _tmp1_;
		GtkEventBox* _tmp2_;
		CarbonTray* _tmp3_;
		_tmp1_ = self->priv->tray;
		_tmp2_ = self->priv->box;
		carbon_tray_remove_from_container (_tmp1_, (GtkContainer*) _tmp2_);
		_tmp3_ = self->priv->tray;
		g_object_run_dispose ((GObject*) _tmp3_);
		_g_object_unref0 (self->priv->tray);
		self->priv->tray = NULL;
	}
	_tmp5_ = tray_applet_activeUuid;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = tray_applet_activeUuid;
		_tmp7_ = self->priv->_uuid;
		_tmp4_ = g_strcmp0 (_tmp6_, _tmp7_) == 0;
	}
	if (_tmp4_) {
		tray_applet_maybe_integrate_tray (self);
	}
}

static void
tray_applet_maybe_integrate_tray (TrayApplet* self)
{
	GSettings* _tmp0_;
	CarbonTray* _tmp1_;
	CarbonTray* _tmp2_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	CarbonTray* _tmp11_;
	GtkEventBox* _tmp12_;
	CarbonTray* _tmp13_;
	GdkX11Screen* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = (CarbonTray*) carbon_tray_new (self->priv->orient, 24, g_settings_get_int (_tmp0_, "spacing"));
	_g_object_unref0 (self->priv->tray);
	self->priv->tray = _tmp1_;
	_tmp2_ = self->priv->tray;
	if (_tmp2_ == NULL) {
		GtkEventBox* _tmp3_;
		TrayErrorIcon* _tmp4_;
		_g_free0 (tray_applet_activeUuid);
		tray_applet_activeUuid = NULL;
		_tmp3_ = self->priv->box;
		_tmp4_ = tray_error_icon_new (_tmp3_, _ ("The System Tray failed to initialize."));
		_tray_error_icon_unref0 (self->priv->errorIcon);
		self->priv->errorIcon = _tmp4_;
		gtk_widget_show_all ((GtkWidget*) self);
		return;
	}
	_tmp5_ = self->priv->_uuid;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (tray_applet_activeUuid);
	tray_applet_activeUuid = _tmp6_;
	switch (self->priv->orient) {
		case GTK_ORIENTATION_HORIZONTAL:
		{
			GtkEventBox* _tmp7_;
			GtkEventBox* _tmp8_;
			gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_START);
			gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_FILL);
			_tmp7_ = self->priv->box;
			gtk_widget_set_halign ((GtkWidget*) _tmp7_, GTK_ALIGN_START);
			_tmp8_ = self->priv->box;
			gtk_widget_set_valign ((GtkWidget*) _tmp8_, GTK_ALIGN_FILL);
			break;
		}
		case GTK_ORIENTATION_VERTICAL:
		{
			GtkEventBox* _tmp9_;
			GtkEventBox* _tmp10_;
			gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_FILL);
			gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_START);
			_tmp9_ = self->priv->box;
			gtk_widget_set_halign ((GtkWidget*) _tmp9_, GTK_ALIGN_FILL);
			_tmp10_ = self->priv->box;
			gtk_widget_set_valign ((GtkWidget*) _tmp10_, GTK_ALIGN_START);
			break;
		}
		default:
		break;
	}
	_tmp11_ = self->priv->tray;
	_tmp12_ = self->priv->box;
	carbon_tray_add_to_container (_tmp11_, (GtkContainer*) _tmp12_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp13_ = self->priv->tray;
	_tmp14_ = self->priv->screen;
	carbon_tray_register (_tmp13_, _tmp14_);
}

static void
tray_applet_real_panel_position_changed (BudgieApplet* base,
                                         BudgiePanelPosition position)
{
	TrayApplet * self;
	gboolean _tmp0_ = FALSE;
	self = (TrayApplet*) base;
	if (position == BUDGIE_PANEL_POSITION_LEFT) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = position == BUDGIE_PANEL_POSITION_RIGHT;
	}
	if (_tmp0_) {
		self->priv->orient = GTK_ORIENTATION_VERTICAL;
	} else {
		self->priv->orient = GTK_ORIENTATION_HORIZONTAL;
	}
	tray_applet_reintegrate_tray (self);
}

static void
tray_applet_real_update_popovers (BudgieApplet* base,
                                  BudgiePopoverManager* manager)
{
	TrayApplet * self;
	TrayErrorIcon* _tmp0_;
	self = (TrayApplet*) base;
	_tmp0_ = self->priv->errorIcon;
	if (_tmp0_ != NULL) {
		TrayErrorIcon* _tmp1_;
		_tmp1_ = self->priv->errorIcon;
		tray_error_icon_register (_tmp1_, manager);
	}
}

static gboolean
tray_applet_real_supports_settings (BudgieApplet* base)
{
	TrayApplet * self;
	gboolean result;
	self = (TrayApplet*) base;
	result = TRUE;
	return result;
}

static GtkWidget*
tray_applet_real_get_settings_ui (BudgieApplet* base)
{
	TrayApplet * self;
	const gchar* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	TraySettings* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* result;
	self = (TrayApplet*) base;
	_tmp0_ = self->priv->_uuid;
	_tmp1_ = budgie_applet_get_applet_settings ((BudgieApplet*) self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = tray_settings_new (_tmp2_);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = (GtkWidget*) _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}

const gchar*
tray_applet_get_uuid (TrayApplet* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uuid;
	result = _tmp0_;
	return result;
}

void
tray_applet_set_uuid (TrayApplet* self,
                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = tray_applet_get_uuid (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uuid);
		self->priv->_uuid = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tray_applet_properties[TRAY_APPLET_UUID_PROPERTY]);
	}
}

static void
tray_applet_class_init (TrayAppletClass * klass,
                        gpointer klass_data)
{
	tray_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TrayApplet_private_offset);
	((BudgieAppletClass *) klass)->panel_position_changed = (void (*) (BudgieApplet*, BudgiePanelPosition)) tray_applet_real_panel_position_changed;
	((BudgieAppletClass *) klass)->update_popovers = (void (*) (BudgieApplet*, BudgiePopoverManager*)) tray_applet_real_update_popovers;
	((BudgieAppletClass *) klass)->supports_settings = (gboolean (*) (BudgieApplet*)) tray_applet_real_supports_settings;
	((BudgieAppletClass *) klass)->get_settings_ui = (GtkWidget* (*) (BudgieApplet*)) tray_applet_real_get_settings_ui;
	G_OBJECT_CLASS (klass)->get_property = _vala_tray_applet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tray_applet_set_property;
	G_OBJECT_CLASS (klass)->finalize = tray_applet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRAY_APPLET_UUID_PROPERTY, tray_applet_properties[TRAY_APPLET_UUID_PROPERTY] = g_param_spec_string ("uuid", "uuid", "uuid", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
tray_applet_instance_init (TrayApplet * self,
                           gpointer klass)
{
	self->priv = tray_applet_get_instance_private (self);
}

static void
tray_applet_finalize (GObject * obj)
{
	TrayApplet * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TRAY_APPLET, TrayApplet);
	_tmp0_ = tray_applet_activeUuid;
	_tmp1_ = self->priv->_uuid;
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
		_g_free0 (tray_applet_activeUuid);
		tray_applet_activeUuid = NULL;
	}
	_g_free0 (self->priv->_uuid);
	_g_object_unref0 (self->priv->tray);
	_g_object_unref0 (self->priv->box);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->screen);
	_tray_error_icon_unref0 (self->priv->errorIcon);
	G_OBJECT_CLASS (tray_applet_parent_class)->finalize (obj);
}

GType
tray_applet_get_type (void)
{
	return tray_applet_type_id;
}

GType
tray_applet_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (TrayAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tray_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrayApplet), 0, (GInstanceInitFunc) tray_applet_instance_init, NULL };
	tray_applet_type_id = g_type_module_register_type (module, budgie_applet_get_type (), "TrayApplet", &g_define_type_info, 0);
	TrayApplet_private_offset = sizeof (TrayAppletPrivate);
	return tray_applet_type_id;
}

static void
_vala_tray_applet_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	TrayApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TRAY_APPLET, TrayApplet);
	switch (property_id) {
		case TRAY_APPLET_UUID_PROPERTY:
		g_value_set_string (value, tray_applet_get_uuid (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tray_applet_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	TrayApplet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TRAY_APPLET, TrayApplet);
	switch (property_id) {
		case TRAY_APPLET_UUID_PROPERTY:
		tray_applet_set_uuid (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

void
peas_register_types (GTypeModule* module)
{
	PeasObjectModule* objmodule = NULL;
	PeasObjectModule* _tmp0_;
	g_return_if_fail (module != NULL);
	tray_plugin_register_type (module);
	tray_settings_register_type (module);
	tray_error_icon_register_type (module);
	tray_applet_register_type (module);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (module, peas_object_module_get_type ()) ? ((PeasObjectModule*) module) : NULL);
	objmodule = _tmp0_;
	peas_object_module_register_extension_type (objmodule, budgie_plugin_get_type (), TYPE_TRAY_PLUGIN);
	_g_object_unref0 (objmodule);
}

