/* settings_panel_applets.c generated by valac 0.56.3, the Vala compiler
 * generated from settings_panel_applets.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include "plugin.h"
#include "budgie-private.h"
#include <stdlib.h>
#include <string.h>
#include <libpeas/peas.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_APPLET_SETTINGS_FRAME (budgie_applet_settings_frame_get_type ())
#define BUDGIE_APPLET_SETTINGS_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_APPLET_SETTINGS_FRAME, BudgieAppletSettingsFrame))
#define BUDGIE_APPLET_SETTINGS_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_APPLET_SETTINGS_FRAME, BudgieAppletSettingsFrameClass))
#define BUDGIE_IS_APPLET_SETTINGS_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_APPLET_SETTINGS_FRAME))
#define BUDGIE_IS_APPLET_SETTINGS_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_APPLET_SETTINGS_FRAME))
#define BUDGIE_APPLET_SETTINGS_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_APPLET_SETTINGS_FRAME, BudgieAppletSettingsFrameClass))

typedef struct _BudgieAppletSettingsFrame BudgieAppletSettingsFrame;
typedef struct _BudgieAppletSettingsFrameClass BudgieAppletSettingsFrameClass;
typedef struct _BudgieAppletSettingsFramePrivate BudgieAppletSettingsFramePrivate;
enum  {
	BUDGIE_APPLET_SETTINGS_FRAME_0_PROPERTY,
	BUDGIE_APPLET_SETTINGS_FRAME_NUM_PROPERTIES
};
static GParamSpec* budgie_applet_settings_frame_properties[BUDGIE_APPLET_SETTINGS_FRAME_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BUDGIE_TYPE_APPLET_ITEM (budgie_applet_item_get_type ())
#define BUDGIE_APPLET_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_APPLET_ITEM, BudgieAppletItem))
#define BUDGIE_APPLET_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_APPLET_ITEM, BudgieAppletItemClass))
#define BUDGIE_IS_APPLET_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_APPLET_ITEM))
#define BUDGIE_IS_APPLET_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_APPLET_ITEM))
#define BUDGIE_APPLET_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_APPLET_ITEM, BudgieAppletItemClass))

typedef struct _BudgieAppletItem BudgieAppletItem;
typedef struct _BudgieAppletItemClass BudgieAppletItemClass;
typedef struct _BudgieAppletItemPrivate BudgieAppletItemPrivate;
enum  {
	BUDGIE_APPLET_ITEM_0_PROPERTY,
	BUDGIE_APPLET_ITEM_APPLET_PROPERTY,
	BUDGIE_APPLET_ITEM_NUM_PROPERTIES
};
static GParamSpec* budgie_applet_item_properties[BUDGIE_APPLET_ITEM_NUM_PROPERTIES];

#define BUDGIE_TYPE_APPLETS_PAGE (budgie_applets_page_get_type ())
#define BUDGIE_APPLETS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_APPLETS_PAGE, BudgieAppletsPage))
#define BUDGIE_APPLETS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_APPLETS_PAGE, BudgieAppletsPageClass))
#define BUDGIE_IS_APPLETS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_APPLETS_PAGE))
#define BUDGIE_IS_APPLETS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_APPLETS_PAGE))
#define BUDGIE_APPLETS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_APPLETS_PAGE, BudgieAppletsPageClass))

typedef struct _BudgieAppletsPage BudgieAppletsPage;
typedef struct _BudgieAppletsPageClass BudgieAppletsPageClass;
typedef struct _BudgieAppletsPagePrivate BudgieAppletsPagePrivate;
enum  {
	BUDGIE_APPLETS_PAGE_0_PROPERTY,
	BUDGIE_APPLETS_PAGE_NUM_PROPERTIES
};
static GParamSpec* budgie_applets_page_properties[BUDGIE_APPLETS_PAGE_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define BUDGIE_TYPE_SETTINGS_GRID (budgie_settings_grid_get_type ())
#define BUDGIE_SETTINGS_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_GRID, BudgieSettingsGrid))
#define BUDGIE_SETTINGS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_GRID, BudgieSettingsGridClass))
#define BUDGIE_IS_SETTINGS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_GRID))
#define BUDGIE_IS_SETTINGS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_GRID))
#define BUDGIE_SETTINGS_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_GRID, BudgieSettingsGridClass))

typedef struct _BudgieSettingsGrid BudgieSettingsGrid;
typedef struct _BudgieSettingsGridClass BudgieSettingsGridClass;
typedef struct _BudgieSettingsGridPrivate BudgieSettingsGridPrivate;

#define BUDGIE_TYPE_SETTINGS_ROW (budgie_settings_row_get_type ())
#define BUDGIE_SETTINGS_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SETTINGS_ROW, BudgieSettingsRow))
#define BUDGIE_SETTINGS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SETTINGS_ROW, BudgieSettingsRowClass))
#define BUDGIE_IS_SETTINGS_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SETTINGS_ROW))
#define BUDGIE_IS_SETTINGS_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SETTINGS_ROW))
#define BUDGIE_SETTINGS_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SETTINGS_ROW, BudgieSettingsRowClass))

typedef struct _BudgieSettingsRow BudgieSettingsRow;
typedef struct _BudgieSettingsRowClass BudgieSettingsRowClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define BUDGIE_TYPE_APPLET_CHOOSER (budgie_applet_chooser_get_type ())
#define BUDGIE_APPLET_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_APPLET_CHOOSER, BudgieAppletChooser))
#define BUDGIE_APPLET_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_APPLET_CHOOSER, BudgieAppletChooserClass))
#define BUDGIE_IS_APPLET_CHOOSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_APPLET_CHOOSER))
#define BUDGIE_IS_APPLET_CHOOSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_APPLET_CHOOSER))
#define BUDGIE_APPLET_CHOOSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_APPLET_CHOOSER, BudgieAppletChooserClass))

typedef struct _BudgieAppletChooser BudgieAppletChooser;
typedef struct _BudgieAppletChooserClass BudgieAppletChooserClass;

#define BUDGIE_TYPE_REMOVE_APPLET_DIALOG (budgie_remove_applet_dialog_get_type ())
#define BUDGIE_REMOVE_APPLET_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_REMOVE_APPLET_DIALOG, BudgieRemoveAppletDialog))
#define BUDGIE_REMOVE_APPLET_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_REMOVE_APPLET_DIALOG, BudgieRemoveAppletDialogClass))
#define BUDGIE_IS_REMOVE_APPLET_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_REMOVE_APPLET_DIALOG))
#define BUDGIE_IS_REMOVE_APPLET_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_REMOVE_APPLET_DIALOG))
#define BUDGIE_REMOVE_APPLET_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_REMOVE_APPLET_DIALOG, BudgieRemoveAppletDialogClass))

typedef struct _BudgieRemoveAppletDialog BudgieRemoveAppletDialog;
typedef struct _BudgieRemoveAppletDialogClass BudgieRemoveAppletDialogClass;

struct _BudgieAppletSettingsFrame {
	GtkBox parent_instance;
	BudgieAppletSettingsFramePrivate * priv;
};

struct _BudgieAppletSettingsFrameClass {
	GtkBoxClass parent_class;
};

struct _BudgieAppletItem {
	GtkBox parent_instance;
	BudgieAppletItemPrivate * priv;
};

struct _BudgieAppletItemClass {
	GtkBoxClass parent_class;
};

struct _BudgieAppletItemPrivate {
	BudgieAppletInfo* _applet;
	GtkImage* image;
	GtkLabel* label;
};

struct _BudgieAppletsPage {
	GtkBox parent_instance;
	BudgieAppletsPagePrivate * priv;
};

struct _BudgieAppletsPageClass {
	GtkBoxClass parent_class;
};

struct _BudgieAppletsPagePrivate {
	BudgieToplevel* toplevel;
	BudgieDesktopManager* manager;
	GtkButton* button_add;
	GtkButton* button_move_applet_up;
	GtkButton* button_move_applet_down;
	GtkButton* button_remove_applet;
	GtkListBox* listbox_applets;
	GHashTable* items;
	GtkStack* settings_stack;
	BudgieAppletInfo* current_info;
};

struct _BudgieSettingsGrid {
	GtkGrid parent_instance;
	BudgieSettingsGridPrivate * priv;
	gint current_row;
	gboolean small_mode;
};

struct _BudgieSettingsGridClass {
	GtkGridClass parent_class;
};

static gpointer budgie_applet_settings_frame_parent_class = NULL;
static gint BudgieAppletItem_private_offset;
static gpointer budgie_applet_item_parent_class = NULL;
static gint BudgieAppletsPage_private_offset;
static gpointer budgie_applets_page_parent_class = NULL;

VALA_EXTERN GType budgie_applet_settings_frame_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieAppletSettingsFrame, g_object_unref)
VALA_EXTERN BudgieAppletSettingsFrame* budgie_applet_settings_frame_new (void);
VALA_EXTERN BudgieAppletSettingsFrame* budgie_applet_settings_frame_construct (GType object_type);
static void budgie_applet_settings_frame_real_add (GtkContainer* base,
                                            GtkWidget* widget);
static GType budgie_applet_settings_frame_get_type_once (void);
VALA_EXTERN GType budgie_applet_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieAppletItem, g_object_unref)
VALA_EXTERN BudgieAppletItem* budgie_applet_item_new (BudgieAppletInfo* info);
VALA_EXTERN BudgieAppletItem* budgie_applet_item_construct (GType object_type,
                                                BudgieAppletInfo* info);
VALA_EXTERN BudgieAppletInfo* budgie_applet_item_get_applet (BudgieAppletItem* self);
VALA_EXTERN void budgie_applet_item_set_applet (BudgieAppletItem* self,
                                    BudgieAppletInfo* value);
static void budgie_applet_item_finalize (GObject * obj);
static GType budgie_applet_item_get_type_once (void);
static void _vala_budgie_applet_item_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_budgie_applet_item_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
VALA_EXTERN GType budgie_applets_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieAppletsPage, g_object_unref)
VALA_EXTERN BudgieAppletsPage* budgie_applets_page_new (BudgieDesktopManager* manager,
                                            BudgieToplevel* toplevel);
VALA_EXTERN BudgieAppletsPage* budgie_applets_page_construct (GType object_type,
                                                  BudgieDesktopManager* manager,
                                                  BudgieToplevel* toplevel);
static void budgie_applets_page_configure_list (BudgieAppletsPage* self);
static void budgie_applets_page_configure_actions (BudgieAppletsPage* self);
static void budgie_applets_page_update_action_buttons (BudgieAppletsPage* self);
static void budgie_applets_page_applet_added (BudgieAppletsPage* self,
                                       BudgieAppletInfo* applet);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gboolean __lambda18_ (BudgieAppletsPage* self);
static gboolean ___lambda18__gsource_func (gpointer self);
static void _budgie_applets_page_applet_added_budgie_toplevel_applet_added (BudgieToplevel* _sender,
                                                                     BudgieAppletInfo* info,
                                                                     gpointer self);
static void budgie_applets_page_applet_removed (BudgieAppletsPage* self,
                                         const gchar* uuid);
static void _budgie_applets_page_applet_removed_budgie_toplevel_applet_removed (BudgieToplevel* _sender,
                                                                         const gchar* uuid,
                                                                         gpointer self);
static void budgie_applets_page_applets_changed (BudgieAppletsPage* self);
static void _budgie_applets_page_applets_changed_budgie_toplevel_applets_changed (BudgieToplevel* _sender,
                                                                           gpointer self);
static void _g_free0_ (gpointer var);
static void budgie_applets_page_move_applet_up (BudgieAppletsPage* self);
static void _budgie_applets_page_move_applet_up_gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self);
static void budgie_applets_page_move_applet_down (BudgieAppletsPage* self);
static void _budgie_applets_page_move_applet_down_gtk_button_clicked (GtkButton* _sender,
                                                               gpointer self);
static void budgie_applets_page_remove_applet (BudgieAppletsPage* self);
static void _budgie_applets_page_remove_applet_gtk_button_clicked (GtkButton* _sender,
                                                            gpointer self);
static void budgie_applets_page_row_selected (BudgieAppletsPage* self,
                                       GtkListBoxRow* row);
static void _budgie_applets_page_row_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                                  GtkListBoxRow* row,
                                                                  gpointer self);
static gint budgie_applets_page_do_sort (BudgieAppletsPage* self,
                                  GtkListBoxRow* before,
                                  GtkListBoxRow* after);
static gint _budgie_applets_page_do_sort_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                          GtkListBoxRow* row2,
                                                          gpointer self);
static void budgie_applets_page_do_headers (BudgieAppletsPage* self,
                                     GtkListBoxRow* before,
                                     GtkListBoxRow* after);
static void _budgie_applets_page_do_headers_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                      GtkListBoxRow* before,
                                                                      gpointer self);
VALA_EXTERN GType budgie_settings_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsGrid, g_object_unref)
VALA_EXTERN BudgieSettingsGrid* budgie_settings_grid_new (void);
VALA_EXTERN BudgieSettingsGrid* budgie_settings_grid_construct (GType object_type);
static void budgie_applets_page_add_applet (BudgieAppletsPage* self);
static void _budgie_applets_page_add_applet_gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self);
VALA_EXTERN GType budgie_settings_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieSettingsRow, g_object_unref)
VALA_EXTERN void budgie_settings_grid_add_row (BudgieSettingsGrid* self,
                                   BudgieSettingsRow* row);
VALA_EXTERN BudgieSettingsRow* budgie_settings_row_new (GtkWidget* widget,
                                            const gchar* label,
                                            const gchar* description);
VALA_EXTERN BudgieSettingsRow* budgie_settings_row_construct (GType object_type,
                                                  GtkWidget* widget,
                                                  const gchar* label,
                                                  const gchar* description);
static gint budgie_applets_page_align_to_int (BudgieAppletsPage* self,
                                       const gchar* al);
VALA_EXTERN GType budgie_applet_chooser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieAppletChooser, g_object_unref)
VALA_EXTERN BudgieAppletChooser* budgie_applet_chooser_new (GtkWindow* parent);
VALA_EXTERN BudgieAppletChooser* budgie_applet_chooser_construct (GType object_type,
                                                      GtkWindow* parent);
VALA_EXTERN void budgie_applet_chooser_set_plugin_list (BudgieAppletChooser* self,
                                            GList* plugins);
static void _vala_PeasPluginInfo_free (PeasPluginInfo* self);
static void __vala_PeasPluginInfo_free0_ (gpointer var);
static inline void _g_list_free___vala_PeasPluginInfo_free0_ (GList* self);
VALA_EXTERN gchar* budgie_applet_chooser_run (BudgieAppletChooser* self);
VALA_EXTERN GType budgie_remove_applet_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieRemoveAppletDialog, g_object_unref)
VALA_EXTERN BudgieRemoveAppletDialog* budgie_remove_applet_dialog_new (GtkWindow* parent);
VALA_EXTERN BudgieRemoveAppletDialog* budgie_remove_applet_dialog_construct (GType object_type,
                                                                 GtkWindow* parent);
VALA_EXTERN gboolean budgie_remove_applet_dialog_run (BudgieRemoveAppletDialog* self);
static void budgie_applets_page_finalize (GObject * obj);
static GType budgie_applets_page_get_type_once (void);

BudgieAppletSettingsFrame*
budgie_applet_settings_frame_construct (GType object_type)
{
	BudgieAppletSettingsFrame * self = NULL;
	GtkLabel* lab = NULL;
	GtkLabel* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkSeparator* sep = NULL;
	GtkSeparator* _tmp3_;
	self = (BudgieAppletSettingsFrame*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 0, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (_ ("Configure applet"));
	g_object_ref_sink (_tmp0_);
	lab = _tmp0_;
	gtk_label_set_use_markup (lab, TRUE);
	gtk_widget_set_halign ((GtkWidget*) lab, GTK_ALIGN_START);
	gtk_widget_set_margin_bottom ((GtkWidget*) lab, 6);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_START);
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp1_, "settings-frame");
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) lab);
	gtk_style_context_add_class (_tmp2_, "settings-title");
	_tmp3_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp3_);
	sep = _tmp3_;
	gtk_widget_set_margin_bottom ((GtkWidget*) sep, 6);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) lab, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) sep, FALSE, FALSE, (guint) 0);
	_g_object_unref0 (sep);
	_g_object_unref0 (lab);
	return self;
}

BudgieAppletSettingsFrame*
budgie_applet_settings_frame_new (void)
{
	return budgie_applet_settings_frame_construct (BUDGIE_TYPE_APPLET_SETTINGS_FRAME);
}

static void
budgie_applet_settings_frame_real_add (GtkContainer* base,
                                       GtkWidget* widget)
{
	BudgieAppletSettingsFrame * self;
	self = (BudgieAppletSettingsFrame*) base;
	g_return_if_fail (widget != NULL);
	gtk_box_pack_start ((GtkBox*) self, widget, FALSE, FALSE, (guint) 0);
}

static void
budgie_applet_settings_frame_class_init (BudgieAppletSettingsFrameClass * klass,
                                         gpointer klass_data)
{
	budgie_applet_settings_frame_parent_class = g_type_class_peek_parent (klass);
	((GtkContainerClass *) klass)->add = (void (*) (GtkContainer*, GtkWidget*)) budgie_applet_settings_frame_real_add;
}

static void
budgie_applet_settings_frame_instance_init (BudgieAppletSettingsFrame * self,
                                            gpointer klass)
{
}

/**
* AppletSettingsFrame provides a UI wrapper for Applet Settings
*/
static GType
budgie_applet_settings_frame_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieAppletSettingsFrameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_applet_settings_frame_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieAppletSettingsFrame), 0, (GInstanceInitFunc) budgie_applet_settings_frame_instance_init, NULL };
	GType budgie_applet_settings_frame_type_id;
	budgie_applet_settings_frame_type_id = g_type_register_static (gtk_box_get_type (), "BudgieAppletSettingsFrame", &g_define_type_info, 0);
	return budgie_applet_settings_frame_type_id;
}

GType
budgie_applet_settings_frame_get_type (void)
{
	static volatile gsize budgie_applet_settings_frame_type_id__once = 0;
	if (g_once_init_enter (&budgie_applet_settings_frame_type_id__once)) {
		GType budgie_applet_settings_frame_type_id;
		budgie_applet_settings_frame_type_id = budgie_applet_settings_frame_get_type_once ();
		g_once_init_leave (&budgie_applet_settings_frame_type_id__once, budgie_applet_settings_frame_type_id);
	}
	return budgie_applet_settings_frame_type_id__once;
}

static inline gpointer
budgie_applet_item_get_instance_private (BudgieAppletItem* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieAppletItem_private_offset);
}

/**
* Construct a new AppletItem for the given applet
*/
BudgieAppletItem*
budgie_applet_item_construct (GType object_type,
                              BudgieAppletInfo* info)
{
	BudgieAppletItem * self = NULL;
	GtkStyleContext* _tmp0_;
	GtkImage* _tmp1_;
	GtkImage* _tmp2_;
	GtkImage* _tmp3_;
	GtkImage* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	BudgieAppletInfo* _tmp9_;
	GtkLabel* _tmp10_;
	BudgieAppletInfo* _tmp11_;
	GtkImage* _tmp12_;
	GtkImage* _tmp13_;
	self = (BudgieAppletItem*) g_object_new (object_type, "applet", info, NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "applet-item");
	gtk_widget_set_margin_top ((GtkWidget*) self, 4);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 4);
	_tmp1_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp1_;
	_tmp2_ = self->priv->image;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp2_, 12);
	_tmp3_ = self->priv->image;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp3_, 14);
	_tmp4_ = self->priv->image;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp4_, FALSE, FALSE, (guint) 0);
	_tmp5_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->label);
	self->priv->label = _tmp5_;
	_tmp6_ = self->priv->label;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp6_, 18);
	_tmp7_ = self->priv->label;
	gtk_widget_set_halign ((GtkWidget*) _tmp7_, GTK_ALIGN_START);
	_tmp8_ = self->priv->label;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp8_, FALSE, FALSE, (guint) 0);
	_tmp9_ = self->priv->_applet;
	_tmp10_ = self->priv->label;
	g_object_bind_property_with_closures ((GObject*) _tmp9_, "name", (GObject*) _tmp10_, "label", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp11_ = self->priv->_applet;
	_tmp12_ = self->priv->image;
	g_object_bind_property_with_closures ((GObject*) _tmp11_, "icon", (GObject*) _tmp12_, "icon-name", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp13_ = self->priv->image;
	g_object_set (_tmp13_, "icon-size", (gint) GTK_ICON_SIZE_MENU, NULL);
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}

BudgieAppletItem*
budgie_applet_item_new (BudgieAppletInfo* info)
{
	return budgie_applet_item_construct (BUDGIE_TYPE_APPLET_ITEM, info);
}

BudgieAppletInfo*
budgie_applet_item_get_applet (BudgieAppletItem* self)
{
	BudgieAppletInfo* result;
	BudgieAppletInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_applet;
	result = _tmp0_;
	return result;
}

void
budgie_applet_item_set_applet (BudgieAppletItem* self,
                               BudgieAppletInfo* value)
{
	BudgieAppletInfo* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_applet_item_get_applet (self);
	if (old_value != value) {
		self->priv->_applet = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_applet_item_properties[BUDGIE_APPLET_ITEM_APPLET_PROPERTY]);
	}
}

static void
budgie_applet_item_class_init (BudgieAppletItemClass * klass,
                               gpointer klass_data)
{
	budgie_applet_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieAppletItem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_applet_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_applet_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_applet_item_finalize;
	/**
	* We're bound to the info
	*/
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_APPLET_ITEM_APPLET_PROPERTY, budgie_applet_item_properties[BUDGIE_APPLET_ITEM_APPLET_PROPERTY] = g_param_spec_object ("applet", "applet", "applet", budgie_applet_info_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
budgie_applet_item_instance_init (BudgieAppletItem * self,
                                  gpointer klass)
{
	self->priv = budgie_applet_item_get_instance_private (self);
}

static void
budgie_applet_item_finalize (GObject * obj)
{
	BudgieAppletItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_APPLET_ITEM, BudgieAppletItem);
	_g_object_unref0 (self->priv->image);
	_g_object_unref0 (self->priv->label);
	G_OBJECT_CLASS (budgie_applet_item_parent_class)->finalize (obj);
}

/**
* AppletItem is used to represent a Budgie Applet in the list
*/
static GType
budgie_applet_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieAppletItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_applet_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieAppletItem), 0, (GInstanceInitFunc) budgie_applet_item_instance_init, NULL };
	GType budgie_applet_item_type_id;
	budgie_applet_item_type_id = g_type_register_static (gtk_box_get_type (), "BudgieAppletItem", &g_define_type_info, 0);
	BudgieAppletItem_private_offset = g_type_add_instance_private (budgie_applet_item_type_id, sizeof (BudgieAppletItemPrivate));
	return budgie_applet_item_type_id;
}

GType
budgie_applet_item_get_type (void)
{
	static volatile gsize budgie_applet_item_type_id__once = 0;
	if (g_once_init_enter (&budgie_applet_item_type_id__once)) {
		GType budgie_applet_item_type_id;
		budgie_applet_item_type_id = budgie_applet_item_get_type_once ();
		g_once_init_leave (&budgie_applet_item_type_id__once, budgie_applet_item_type_id);
	}
	return budgie_applet_item_type_id__once;
}

static void
_vala_budgie_applet_item_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	BudgieAppletItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_APPLET_ITEM, BudgieAppletItem);
	switch (property_id) {
		case BUDGIE_APPLET_ITEM_APPLET_PROPERTY:
		g_value_set_object (value, budgie_applet_item_get_applet (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_applet_item_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	BudgieAppletItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_APPLET_ITEM, BudgieAppletItem);
	switch (property_id) {
		case BUDGIE_APPLET_ITEM_APPLET_PROPERTY:
		budgie_applet_item_set_applet (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
budgie_applets_page_get_instance_private (BudgieAppletsPage* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieAppletsPage_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
__lambda18_ (BudgieAppletsPage* self)
{
	GtkStack* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->settings_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "main");
	result = FALSE;
	return result;
}

static gboolean
___lambda18__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda18_ ((BudgieAppletsPage*) self);
	return result;
}

static void
_budgie_applets_page_applet_added_budgie_toplevel_applet_added (BudgieToplevel* _sender,
                                                                BudgieAppletInfo* info,
                                                                gpointer self)
{
	budgie_applets_page_applet_added ((BudgieAppletsPage*) self, info);
}

static void
_budgie_applets_page_applet_removed_budgie_toplevel_applet_removed (BudgieToplevel* _sender,
                                                                    const gchar* uuid,
                                                                    gpointer self)
{
	budgie_applets_page_applet_removed ((BudgieAppletsPage*) self, uuid);
}

static void
_budgie_applets_page_applets_changed_budgie_toplevel_applets_changed (BudgieToplevel* _sender,
                                                                      gpointer self)
{
	budgie_applets_page_applets_changed ((BudgieAppletsPage*) self);
}

BudgieAppletsPage*
budgie_applets_page_construct (GType object_type,
                               BudgieDesktopManager* manager,
                               BudgieToplevel* toplevel)
{
	BudgieAppletsPage * self = NULL;
	BudgieToplevel* _tmp0_;
	GList* _tmp1_;
	self = (BudgieAppletsPage*) g_object_new (object_type, "orientation", GTK_ORIENTATION_HORIZONTAL, "spacing", 0, NULL);
	self->priv->manager = manager;
	self->priv->toplevel = toplevel;
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_FILL);
	gtk_widget_set_vexpand ((GtkWidget*) self, FALSE);
	g_object_set ((GtkWidget*) self, "margin", 6, NULL);
	budgie_applets_page_configure_list (self);
	budgie_applets_page_configure_actions (self);
	budgie_applets_page_update_action_buttons (self);
	_tmp0_ = self->priv->toplevel;
	_tmp1_ = budgie_toplevel_get_applets (_tmp0_);
	{
		GList* applet_collection = NULL;
		GList* applet_it = NULL;
		applet_collection = _tmp1_;
		for (applet_it = applet_collection; applet_it != NULL; applet_it = applet_it->next) {
			BudgieAppletInfo* _tmp2_;
			BudgieAppletInfo* applet = NULL;
			_tmp2_ = _g_object_ref0 ((BudgieAppletInfo*) applet_it->data);
			applet = _tmp2_;
			{
				BudgieAppletInfo* _tmp3_;
				_tmp3_ = applet;
				budgie_applets_page_applet_added (self, _tmp3_);
				_g_object_unref0 (applet);
			}
		}
		(applet_collection == NULL) ? NULL : (applet_collection = (_g_list_free__g_object_unref0_ (applet_collection), NULL));
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda18__gsource_func, g_object_ref (self), g_object_unref);
	g_signal_connect_object (toplevel, "applet-added", (GCallback) _budgie_applets_page_applet_added_budgie_toplevel_applet_added, self, 0);
	g_signal_connect_object (toplevel, "applet-removed", (GCallback) _budgie_applets_page_applet_removed_budgie_toplevel_applet_removed, self, 0);
	g_signal_connect_object (toplevel, "applets-changed", (GCallback) _budgie_applets_page_applets_changed_budgie_toplevel_applets_changed, self, 0);
	budgie_applets_page_applets_changed (self);
	return self;
}

BudgieAppletsPage*
budgie_applets_page_new (BudgieDesktopManager* manager,
                         BudgieToplevel* toplevel)
{
	return budgie_applets_page_construct (BUDGIE_TYPE_APPLETS_PAGE, manager, toplevel);
}

/**
* Something in the applet availability changed for this panel.
*/
static void
budgie_applets_page_applets_changed (BudgieAppletsPage* self)
{
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->listbox_applets;
	gtk_list_box_invalidate_sort (_tmp0_);
	_tmp1_ = self->priv->listbox_applets;
	gtk_list_box_invalidate_headers (_tmp1_);
	budgie_applets_page_update_action_buttons (self);
}

/**
* Update the sensitivity of the action buttons based on the current
* selection.
*/
static void
budgie_applets_page_update_action_buttons (BudgieAppletsPage* self)
{
	GtkListBoxRow* row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	BudgieAppletInfo* info = NULL;
	GtkListBoxRow* _tmp2_;
	BudgieAppletInfo* _tmp8_;
	BudgieAppletInfo* _tmp12_;
	GtkButton* _tmp13_;
	GtkButton* _tmp14_;
	BudgieToplevel* _tmp15_;
	BudgieAppletInfo* _tmp16_;
	GtkButton* _tmp17_;
	BudgieToplevel* _tmp18_;
	BudgieAppletInfo* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->listbox_applets;
	_tmp1_ = gtk_list_box_get_selected_row (_tmp0_);
	row = _tmp1_;
	info = NULL;
	_tmp2_ = row;
	if (_tmp2_ != NULL) {
		GtkListBoxRow* _tmp3_;
		GtkWidget* _tmp4_;
		BudgieAppletInfo* _tmp5_;
		BudgieAppletInfo* _tmp6_;
		BudgieAppletInfo* _tmp7_;
		_tmp3_ = row;
		_tmp4_ = gtk_bin_get_child ((GtkBin*) _tmp3_);
		_tmp5_ = budgie_applet_item_get_applet (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, BUDGIE_TYPE_APPLET_ITEM, BudgieAppletItem));
		_tmp6_ = _tmp5_;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (info);
		info = _tmp7_;
	}
	_tmp8_ = info;
	if (_tmp8_ == NULL) {
		GtkButton* _tmp9_;
		GtkButton* _tmp10_;
		GtkButton* _tmp11_;
		self->priv->current_info = NULL;
		_tmp9_ = self->priv->button_remove_applet;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, FALSE);
		_tmp10_ = self->priv->button_move_applet_up;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, FALSE);
		_tmp11_ = self->priv->button_move_applet_down;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, FALSE);
		_g_object_unref0 (info);
		return;
	}
	_tmp12_ = info;
	self->priv->current_info = _tmp12_;
	_tmp13_ = self->priv->button_remove_applet;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, TRUE);
	_tmp14_ = self->priv->button_move_applet_up;
	_tmp15_ = self->priv->toplevel;
	_tmp16_ = info;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, budgie_toplevel_can_move_applet_left (_tmp15_, _tmp16_));
	_tmp17_ = self->priv->button_move_applet_down;
	_tmp18_ = self->priv->toplevel;
	_tmp19_ = info;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp17_, budgie_toplevel_can_move_applet_right (_tmp18_, _tmp19_));
	_g_object_unref0 (info);
}

/**
* Configure the main display list used to show the currently used
* applets for the panel
*/
static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_budgie_applets_page_move_applet_up_gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self)
{
	budgie_applets_page_move_applet_up ((BudgieAppletsPage*) self);
}

static void
_budgie_applets_page_move_applet_down_gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self)
{
	budgie_applets_page_move_applet_down ((BudgieAppletsPage*) self);
}

static void
_budgie_applets_page_remove_applet_gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self)
{
	budgie_applets_page_remove_applet ((BudgieAppletsPage*) self);
}

static void
_budgie_applets_page_row_selected_gtk_list_box_row_selected (GtkListBox* _sender,
                                                             GtkListBoxRow* row,
                                                             gpointer self)
{
	budgie_applets_page_row_selected ((BudgieAppletsPage*) self, row);
}

static gint
_budgie_applets_page_do_sort_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                     GtkListBoxRow* row2,
                                                     gpointer self)
{
	gint result;
	result = budgie_applets_page_do_sort ((BudgieAppletsPage*) self, row1, row2);
	return result;
}

static void
_budgie_applets_page_do_headers_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                 GtkListBoxRow* before,
                                                                 gpointer self)
{
	budgie_applets_page_do_headers ((BudgieAppletsPage*) self, row, before);
}

static void
budgie_applets_page_configure_list (BudgieAppletsPage* self)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GtkBox* frame_box = NULL;
	GtkBox* _tmp3_;
	GtkButtonBox* move_box = NULL;
	GtkButtonBox* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	GtkButton* _tmp10_;
	GtkButton* _tmp11_;
	GtkButton* _tmp12_;
	GtkButton* _tmp13_;
	GtkButton* _tmp14_;
	GtkFrame* frame = NULL;
	GtkFrame* _tmp15_;
	GtkListBox* _tmp16_;
	GtkListBox* _tmp17_;
	GtkListBox* _tmp18_;
	GtkScrolledWindow* scroll = NULL;
	GtkScrolledWindow* _tmp19_;
	GtkListBox* _tmp20_;
	GtkStyleContext* _tmp21_;
	GtkListBox* _tmp22_;
	GtkStyleContext* _tmp23_;
	GtkListBox* _tmp24_;
	GtkListBox* _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->items);
	self->priv->items = _tmp2_;
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp3_);
	frame_box = _tmp3_;
	_tmp4_ = (GtkButtonBox*) gtk_button_box_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp4_);
	move_box = _tmp4_;
	gtk_button_box_set_layout (move_box, GTK_BUTTONBOX_START);
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) move_box);
	gtk_style_context_add_class (_tmp5_, GTK_STYLE_CLASS_INLINE_TOOLBAR);
	_tmp6_ = (GtkButton*) gtk_button_new_from_icon_name ("go-up-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->button_move_applet_up);
	self->priv->button_move_applet_up = _tmp6_;
	_tmp7_ = self->priv->button_move_applet_up;
	g_signal_connect_object (_tmp7_, "clicked", (GCallback) _budgie_applets_page_move_applet_up_gtk_button_clicked, self, 0);
	_tmp8_ = (GtkButton*) gtk_button_new_from_icon_name ("go-down-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->button_move_applet_down);
	self->priv->button_move_applet_down = _tmp8_;
	_tmp9_ = self->priv->button_move_applet_down;
	g_signal_connect_object (_tmp9_, "clicked", (GCallback) _budgie_applets_page_move_applet_down_gtk_button_clicked, self, 0);
	_tmp10_ = self->priv->button_move_applet_up;
	gtk_container_add ((GtkContainer*) move_box, (GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->button_move_applet_down;
	gtk_container_add ((GtkContainer*) move_box, (GtkWidget*) _tmp11_);
	_tmp12_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-delete-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->button_remove_applet);
	self->priv->button_remove_applet = _tmp12_;
	_tmp13_ = self->priv->button_remove_applet;
	g_signal_connect_object (_tmp13_, "clicked", (GCallback) _budgie_applets_page_remove_applet_gtk_button_clicked, self, 0);
	_tmp14_ = self->priv->button_remove_applet;
	gtk_container_add ((GtkContainer*) move_box, (GtkWidget*) _tmp14_);
	gtk_box_pack_start (frame_box, (GtkWidget*) move_box, FALSE, FALSE, (guint) 0);
	_tmp15_ = (GtkFrame*) gtk_frame_new (NULL);
	g_object_ref_sink (_tmp15_);
	frame = _tmp15_;
	gtk_widget_set_vexpand ((GtkWidget*) frame, FALSE);
	gtk_widget_set_margin_end ((GtkWidget*) frame, 20);
	gtk_widget_set_margin_top ((GtkWidget*) frame, 12);
	gtk_container_add ((GtkContainer*) frame, (GtkWidget*) frame_box);
	_tmp16_ = (GtkListBox*) gtk_list_box_new ();
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->listbox_applets);
	self->priv->listbox_applets = _tmp16_;
	_tmp17_ = self->priv->listbox_applets;
	gtk_list_box_set_activate_on_single_click (_tmp17_, TRUE);
	_tmp18_ = self->priv->listbox_applets;
	g_signal_connect_object (_tmp18_, "row-selected", (GCallback) _budgie_applets_page_row_selected_gtk_list_box_row_selected, self, 0);
	_tmp19_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp19_);
	scroll = _tmp19_;
	_tmp20_ = self->priv->listbox_applets;
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) _tmp20_);
	gtk_scrolled_window_set_policy (scroll, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start (frame_box, (GtkWidget*) scroll, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) frame, FALSE, TRUE, (guint) 0);
	_tmp21_ = gtk_widget_get_style_context ((GtkWidget*) move_box);
	gtk_style_context_set_junction_sides (_tmp21_, GTK_JUNCTION_BOTTOM);
	_tmp22_ = self->priv->listbox_applets;
	_tmp23_ = gtk_widget_get_style_context ((GtkWidget*) _tmp22_);
	gtk_style_context_set_junction_sides (_tmp23_, GTK_JUNCTION_TOP);
	_tmp24_ = self->priv->listbox_applets;
	gtk_list_box_set_sort_func (_tmp24_, _budgie_applets_page_do_sort_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp25_ = self->priv->listbox_applets;
	gtk_list_box_set_header_func (_tmp25_, _budgie_applets_page_do_headers_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (scroll);
	_g_object_unref0 (frame);
	_g_object_unref0 (move_box);
	_g_object_unref0 (frame_box);
}

/**
* Configure the action grid to manipulation the applets
*/
static void
_budgie_applets_page_add_applet_gtk_button_clicked (GtkButton* _sender,
                                                    gpointer self)
{
	budgie_applets_page_add_applet ((BudgieAppletsPage*) self);
}

static void
budgie_applets_page_configure_actions (BudgieAppletsPage* self)
{
	BudgieSettingsGrid* grid = NULL;
	BudgieSettingsGrid* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkButton* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkButton* _tmp8_;
	GtkButton* _tmp9_;
	BudgieSettingsRow* _tmp10_;
	BudgieSettingsRow* _tmp11_;
	GtkStack* _tmp12_;
	GtkStack* _tmp13_;
	GtkStack* _tmp14_;
	GtkStack* _tmp15_;
	GtkStack* _tmp16_;
	GtkStack* _tmp17_;
	gint _tmp18_;
	GtkBox* placeholder = NULL;
	GtkBox* _tmp19_;
	GtkImage* placeholder_img = NULL;
	GtkImage* _tmp20_;
	GtkLabel* placeholder_text = NULL;
	GtkLabel* _tmp21_;
	GtkStack* _tmp22_;
	GtkEventBox* empty = NULL;
	GtkEventBox* _tmp23_;
	GtkStack* _tmp24_;
	g_return_if_fail (self != NULL);
	_tmp0_ = budgie_settings_grid_new ();
	g_object_ref_sink (_tmp0_);
	grid = _tmp0_;
	grid->small_mode = TRUE;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) grid, FALSE, FALSE, (guint) 0);
	_tmp1_ = (GtkButton*) gtk_button_new_from_icon_name ("list-add-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->button_add);
	self->priv->button_add = _tmp1_;
	_tmp2_ = self->priv->button_add;
	gtk_widget_set_valign ((GtkWidget*) _tmp2_, GTK_ALIGN_CENTER);
	_tmp3_ = self->priv->button_add;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp3_, FALSE);
	_tmp4_ = self->priv->button_add;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
	gtk_style_context_add_class (_tmp5_, GTK_STYLE_CLASS_SUGGESTED_ACTION);
	_tmp6_ = self->priv->button_add;
	_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) _tmp6_);
	gtk_style_context_add_class (_tmp7_, "round-button");
	_tmp8_ = self->priv->button_add;
	g_signal_connect_object (_tmp8_, "clicked", (GCallback) _budgie_applets_page_add_applet_gtk_button_clicked, self, 0);
	_tmp9_ = self->priv->button_add;
	_tmp10_ = budgie_settings_row_new ((GtkWidget*) _tmp9_, _ ("Add applet"), _ ("Choose a new applet to add to this panel"));
	_tmp11_ = _tmp10_;
	budgie_settings_grid_add_row (grid, _tmp11_);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->settings_stack);
	self->priv->settings_stack = _tmp12_;
	_tmp13_ = self->priv->settings_stack;
	gtk_stack_set_homogeneous (_tmp13_, FALSE);
	_tmp14_ = self->priv->settings_stack;
	gtk_widget_set_halign ((GtkWidget*) _tmp14_, GTK_ALIGN_FILL);
	_tmp15_ = self->priv->settings_stack;
	gtk_widget_set_valign ((GtkWidget*) _tmp15_, GTK_ALIGN_START);
	_tmp16_ = self->priv->settings_stack;
	gtk_widget_set_margin_top ((GtkWidget*) _tmp16_, 24);
	_tmp17_ = self->priv->settings_stack;
	grid->current_row = grid->current_row + 1;
	_tmp18_ = grid->current_row;
	gtk_grid_attach ((GtkGrid*) grid, (GtkWidget*) _tmp17_, 0, _tmp18_, 2, 1);
	_tmp19_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp19_);
	placeholder = _tmp19_;
	gtk_widget_set_valign ((GtkWidget*) placeholder, GTK_ALIGN_START);
	_tmp20_ = (GtkImage*) gtk_image_new_from_icon_name ("dialog-information-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp20_);
	placeholder_img = _tmp20_;
	_tmp21_ = (GtkLabel*) gtk_label_new (_ ("No settings available"));
	g_object_ref_sink (_tmp21_);
	placeholder_text = _tmp21_;
	gtk_widget_set_margin_start ((GtkWidget*) placeholder_text, 10);
	gtk_box_pack_start (placeholder, (GtkWidget*) placeholder_img, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start (placeholder, (GtkWidget*) placeholder_text, FALSE, FALSE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) placeholder);
	gtk_widget_set_valign ((GtkWidget*) placeholder_img, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) placeholder_text, GTK_ALIGN_CENTER);
	_tmp22_ = self->priv->settings_stack;
	gtk_stack_add_named (_tmp22_, (GtkWidget*) placeholder, "no-settings");
	_tmp23_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp23_);
	empty = _tmp23_;
	_tmp24_ = self->priv->settings_stack;
	gtk_stack_add_named (_tmp24_, (GtkWidget*) empty, "main");
	_g_object_unref0 (empty);
	_g_object_unref0 (placeholder_text);
	_g_object_unref0 (placeholder_img);
	_g_object_unref0 (placeholder);
	_g_object_unref0 (grid);
}

/**
* Changed the row so update the UI
*/
static void
budgie_applets_page_row_selected (BudgieAppletsPage* self,
                                  GtkListBoxRow* row)
{
	BudgieAppletItem* item = NULL;
	GtkWidget* _tmp1_;
	GtkWidget* lookup = NULL;
	GtkStack* _tmp2_;
	BudgieAppletItem* _tmp3_;
	BudgieAppletInfo* _tmp4_;
	BudgieAppletInfo* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GtkWidget* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* _tmp11_;
	GtkStack* _tmp13_;
	GtkWidget* _tmp14_;
	g_return_if_fail (self != NULL);
	if (row == NULL) {
		GtkStack* _tmp0_;
		_tmp0_ = self->priv->settings_stack;
		gtk_stack_set_visible_child_name (_tmp0_, "main");
		return;
	}
	budgie_applets_page_update_action_buttons (self);
	_tmp1_ = gtk_bin_get_child ((GtkBin*) row);
	item = BUDGIE_IS_APPLET_ITEM (_tmp1_) ? ((BudgieAppletItem*) _tmp1_) : NULL;
	_tmp2_ = self->priv->settings_stack;
	_tmp3_ = item;
	_tmp4_ = budgie_applet_item_get_applet (_tmp3_);
	_tmp5_ = _tmp4_;
	g_object_get (_tmp5_, "uuid", &_tmp6_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = gtk_stack_get_child_by_name (_tmp2_, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	lookup = _tmp10_;
	_tmp11_ = lookup;
	if (_tmp11_ == NULL) {
		GtkStack* _tmp12_;
		_tmp12_ = self->priv->settings_stack;
		gtk_stack_set_visible_child_name (_tmp12_, "no-settings");
		return;
	}
	_tmp13_ = self->priv->settings_stack;
	_tmp14_ = lookup;
	gtk_stack_set_visible_child (_tmp13_, _tmp14_);
}

/**
* We have a new applet, so stored it in the list
*/
static void
budgie_applets_page_applet_added (BudgieAppletsPage* self,
                                  BudgieAppletInfo* applet)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	BudgieApplet* _tmp5_;
	BudgieApplet* _tmp6_;
	BudgieApplet* _tmp7_;
	gboolean _tmp8_;
	BudgieAppletItem* item = NULL;
	BudgieAppletItem* _tmp24_;
	BudgieAppletItem* _tmp25_;
	GtkListBox* _tmp26_;
	BudgieAppletItem* _tmp27_;
	GHashTable* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	BudgieAppletItem* _tmp31_;
	BudgieAppletItem* _tmp32_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->items;
	g_object_get (applet, "uuid", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_hash_table_contains (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		return;
	}
	g_object_get (applet, "applet", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = budgie_applet_supports_settings (_tmp7_);
	_g_object_unref0 (_tmp7_);
	if (_tmp8_) {
		BudgieAppletSettingsFrame* frame = NULL;
		BudgieAppletSettingsFrame* _tmp9_;
		GtkWidget* ui = NULL;
		BudgieApplet* _tmp10_;
		BudgieApplet* _tmp11_;
		BudgieApplet* _tmp12_;
		GtkWidget* _tmp13_;
		GtkWidget* _tmp14_;
		BudgieAppletSettingsFrame* _tmp15_;
		GtkWidget* _tmp16_;
		GtkWidget* _tmp17_;
		BudgieAppletSettingsFrame* _tmp18_;
		GtkStack* _tmp19_;
		BudgieAppletSettingsFrame* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp9_ = budgie_applet_settings_frame_new ();
		g_object_ref_sink (_tmp9_);
		frame = _tmp9_;
		g_object_get (applet, "applet", &_tmp10_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		_tmp13_ = budgie_applet_get_settings_ui (_tmp12_);
		_tmp14_ = _tmp13_;
		_g_object_unref0 (_tmp12_);
		ui = _tmp14_;
		_tmp15_ = frame;
		_tmp16_ = ui;
		gtk_container_add ((GtkContainer*) _tmp15_, _tmp16_);
		_tmp17_ = ui;
		gtk_widget_show (_tmp17_);
		_tmp18_ = frame;
		gtk_widget_show ((GtkWidget*) _tmp18_);
		_tmp19_ = self->priv->settings_stack;
		_tmp20_ = frame;
		g_object_get (applet, "uuid", &_tmp21_, NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_;
		gtk_stack_add_named (_tmp19_, (GtkWidget*) _tmp20_, _tmp23_);
		_g_free0 (_tmp23_);
		_g_object_unref0 (ui);
		_g_object_unref0 (frame);
	}
	_tmp24_ = budgie_applet_item_new (applet);
	g_object_ref_sink (_tmp24_);
	item = _tmp24_;
	_tmp25_ = item;
	gtk_widget_show_all ((GtkWidget*) _tmp25_);
	_tmp26_ = self->priv->listbox_applets;
	_tmp27_ = item;
	gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = self->priv->items;
	g_object_get (applet, "uuid", &_tmp29_, NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = item;
	_tmp32_ = _g_object_ref0 (_tmp31_);
	g_hash_table_insert (_tmp28_, _tmp30_, _tmp32_);
	_g_object_unref0 (item);
}

/**
* An applet was removed, so remove from our list also
*/
static void
budgie_applets_page_applet_removed (BudgieAppletsPage* self,
                                    const gchar* uuid)
{
	BudgieAppletItem* item = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	BudgieAppletItem* _tmp2_;
	GtkWidget* lookup = NULL;
	BudgieAppletItem* _tmp3_;
	GtkStack* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	BudgieAppletItem* _tmp9_;
	GtkContainer* _tmp10_;
	GHashTable* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uuid != NULL);
	_tmp0_ = self->priv->items;
	_tmp1_ = g_hash_table_lookup (_tmp0_, uuid);
	_tmp2_ = _g_object_ref0 ((BudgieAppletItem*) _tmp1_);
	item = _tmp2_;
	lookup = NULL;
	_tmp3_ = item;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (lookup);
		_g_object_unref0 (item);
		return;
	}
	_tmp4_ = self->priv->settings_stack;
	_tmp5_ = gtk_stack_get_child_by_name (_tmp4_, uuid);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (lookup);
	lookup = _tmp6_;
	_tmp7_ = lookup;
	if (_tmp7_ != NULL) {
		GtkWidget* _tmp8_;
		_tmp8_ = lookup;
		gtk_widget_destroy (_tmp8_);
	}
	_tmp9_ = item;
	_tmp10_ = gtk_widget_get_parent ((GtkWidget*) _tmp9_);
	gtk_widget_destroy ((GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->items;
	g_hash_table_remove (_tmp11_, uuid);
	_g_object_unref0 (lookup);
	_g_object_unref0 (item);
}

/**
* Convert a string alignment into one that is sortable
*/
static gint
budgie_applets_page_align_to_int (BudgieAppletsPage* self,
                                  const gchar* al)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (al != NULL, 0);
	_tmp0_ = al;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("start")))) {
		switch (0) {
			default:
			{
				result = 0;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("center")))) {
		switch (0) {
			default:
			{
				result = 1;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = 2;
				return result;
			}
		}
	}
}

/**
* Sort the list in accordance with alignment and actual position
*/
static gint
budgie_applets_page_do_sort (BudgieAppletsPage* self,
                             GtkListBoxRow* before,
                             GtkListBoxRow* after)
{
	BudgieAppletItem* before_child = NULL;
	GtkWidget* _tmp0_;
	BudgieAppletItem* _tmp1_;
	BudgieAppletItem* after_child = NULL;
	GtkWidget* _tmp2_;
	BudgieAppletItem* _tmp3_;
	gboolean _tmp4_ = FALSE;
	BudgieAppletItem* _tmp5_;
	BudgieAppletInfo* before_info = NULL;
	BudgieAppletItem* _tmp7_;
	BudgieAppletInfo* _tmp8_;
	BudgieAppletInfo* _tmp9_;
	BudgieAppletInfo* after_info = NULL;
	BudgieAppletItem* _tmp10_;
	BudgieAppletInfo* _tmp11_;
	BudgieAppletInfo* _tmp12_;
	gboolean _tmp13_ = FALSE;
	BudgieAppletInfo* _tmp14_;
	BudgieAppletInfo* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	BudgieAppletInfo* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gboolean _tmp24_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_bin_get_child ((GtkBin*) before);
	_tmp1_ = _g_object_ref0 (BUDGIE_IS_APPLET_ITEM (_tmp0_) ? ((BudgieAppletItem*) _tmp0_) : NULL);
	before_child = _tmp1_;
	_tmp2_ = gtk_bin_get_child ((GtkBin*) after);
	_tmp3_ = _g_object_ref0 (BUDGIE_IS_APPLET_ITEM (_tmp2_) ? ((BudgieAppletItem*) _tmp2_) : NULL);
	after_child = _tmp3_;
	_tmp5_ = before_child;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		BudgieAppletItem* _tmp6_;
		_tmp6_ = after_child;
		_tmp4_ = _tmp6_ == NULL;
	}
	if (_tmp4_) {
		result = 0;
		_g_object_unref0 (after_child);
		_g_object_unref0 (before_child);
		return result;
	}
	_tmp7_ = before_child;
	_tmp8_ = budgie_applet_item_get_applet (_tmp7_);
	_tmp9_ = _tmp8_;
	before_info = _tmp9_;
	_tmp10_ = after_child;
	_tmp11_ = budgie_applet_item_get_applet (_tmp10_);
	_tmp12_ = _tmp11_;
	after_info = _tmp12_;
	_tmp14_ = before_info;
	if (_tmp14_ == NULL) {
		_tmp13_ = TRUE;
	} else {
		BudgieAppletInfo* _tmp15_;
		_tmp15_ = after_info;
		_tmp13_ = _tmp15_ == NULL;
	}
	if (_tmp13_) {
		result = 0;
		_g_object_unref0 (after_child);
		_g_object_unref0 (before_child);
		return result;
	}
	_tmp16_ = before_info;
	g_object_get (_tmp16_, "alignment", &_tmp17_, NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = _tmp18_;
	_tmp20_ = after_info;
	g_object_get (_tmp20_, "alignment", &_tmp21_, NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strcmp0 (_tmp19_, _tmp23_) != 0;
	_g_free0 (_tmp23_);
	_g_free0 (_tmp19_);
	if (_tmp24_) {
		gint bi = 0;
		BudgieAppletInfo* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gint _tmp29_;
		gint ai = 0;
		BudgieAppletInfo* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gint _tmp34_;
		_tmp25_ = before_info;
		g_object_get (_tmp25_, "alignment", &_tmp26_, NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = _tmp27_;
		_tmp29_ = budgie_applets_page_align_to_int (self, _tmp28_);
		_g_free0 (_tmp28_);
		bi = _tmp29_;
		_tmp30_ = after_info;
		g_object_get (_tmp30_, "alignment", &_tmp31_, NULL);
		_tmp32_ = _tmp31_;
		_tmp33_ = _tmp32_;
		_tmp34_ = budgie_applets_page_align_to_int (self, _tmp33_);
		_g_free0 (_tmp33_);
		ai = _tmp34_;
		if (ai > bi) {
			result = -1;
			_g_object_unref0 (after_child);
			_g_object_unref0 (before_child);
			return result;
		} else {
			result = 1;
			_g_object_unref0 (after_child);
			_g_object_unref0 (before_child);
			return result;
		}
	} else {
		BudgieAppletInfo* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		BudgieAppletInfo* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		_tmp35_ = before_info;
		g_object_get (_tmp35_, "position", &_tmp36_, NULL);
		_tmp37_ = _tmp36_;
		_tmp38_ = after_info;
		g_object_get (_tmp38_, "position", &_tmp39_, NULL);
		_tmp40_ = _tmp39_;
		if (_tmp37_ < _tmp40_) {
			result = -1;
			_g_object_unref0 (after_child);
			_g_object_unref0 (before_child);
			return result;
		} else {
			BudgieAppletInfo* _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			BudgieAppletInfo* _tmp44_;
			gint _tmp45_;
			gint _tmp46_;
			_tmp41_ = before_info;
			g_object_get (_tmp41_, "position", &_tmp42_, NULL);
			_tmp43_ = _tmp42_;
			_tmp44_ = after_info;
			g_object_get (_tmp44_, "position", &_tmp45_, NULL);
			_tmp46_ = _tmp45_;
			if (_tmp43_ > _tmp46_) {
				result = 1;
				_g_object_unref0 (after_child);
				_g_object_unref0 (before_child);
				return result;
			}
		}
	}
	result = 0;
	_g_object_unref0 (after_child);
	_g_object_unref0 (before_child);
	return result;
}

/**
* Provide headers in the list to separate the visual positions
*/
static void
budgie_applets_page_do_headers (BudgieAppletsPage* self,
                                GtkListBoxRow* before,
                                GtkListBoxRow* after)
{
	gchar* prev = NULL;
	gchar* next = NULL;
	BudgieAppletInfo* before_info = NULL;
	BudgieAppletInfo* after_info = NULL;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (self != NULL);
	prev = NULL;
	next = NULL;
	before_info = NULL;
	after_info = NULL;
	if (before != NULL) {
		GtkWidget* _tmp0_;
		BudgieAppletInfo* _tmp1_;
		BudgieAppletInfo* _tmp2_;
		BudgieAppletInfo* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp0_ = gtk_bin_get_child ((GtkBin*) before);
		_tmp1_ = budgie_applet_item_get_applet (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, BUDGIE_TYPE_APPLET_ITEM, BudgieAppletItem));
		_tmp2_ = _tmp1_;
		before_info = _tmp2_;
		_tmp3_ = before_info;
		g_object_get (_tmp3_, "alignment", &_tmp4_, NULL);
		_tmp5_ = _tmp4_;
		_g_free0 (prev);
		prev = _tmp5_;
	}
	if (after != NULL) {
		GtkWidget* _tmp6_;
		BudgieAppletInfo* _tmp7_;
		BudgieAppletInfo* _tmp8_;
		BudgieAppletInfo* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp6_ = gtk_bin_get_child ((GtkBin*) after);
		_tmp7_ = budgie_applet_item_get_applet (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, BUDGIE_TYPE_APPLET_ITEM, BudgieAppletItem));
		_tmp8_ = _tmp7_;
		after_info = _tmp8_;
		_tmp9_ = after_info;
		g_object_get (_tmp9_, "alignment", &_tmp10_, NULL);
		_tmp11_ = _tmp10_;
		_g_free0 (next);
		next = _tmp11_;
	}
	if (after == NULL) {
		_tmp12_ = TRUE;
	} else {
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp13_ = prev;
		_tmp14_ = next;
		_tmp12_ = g_strcmp0 (_tmp13_, _tmp14_) != 0;
	}
	if (_tmp12_) {
		GtkLabel* label = NULL;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		GQuark _tmp18_ = 0U;
		static GQuark _tmp17_label0 = 0;
		static GQuark _tmp17_label1 = 0;
		GtkLabel* _tmp22_;
		GtkStyleContext* _tmp23_;
		GtkLabel* _tmp24_;
		GtkStyleContext* _tmp25_;
		GtkLabel* _tmp26_;
		GtkLabel* _tmp27_;
		GtkLabel* _tmp28_;
		GtkLabel* _tmp29_;
		GtkLabel* _tmp30_;
		GtkLabel* _tmp31_;
		GtkLabel* _tmp32_;
		label = NULL;
		_tmp15_ = prev;
		_tmp16_ = _tmp15_;
		_tmp18_ = (NULL == _tmp16_) ? 0 : g_quark_from_string (_tmp16_);
		if (_tmp18_ == ((0 != _tmp17_label0) ? _tmp17_label0 : (_tmp17_label0 = g_quark_from_static_string ("start")))) {
			switch (0) {
				default:
				{
					GtkLabel* _tmp19_;
					_tmp19_ = (GtkLabel*) gtk_label_new (_ ("Start"));
					g_object_ref_sink (_tmp19_);
					_g_object_unref0 (label);
					label = _tmp19_;
					break;
				}
			}
		} else if (_tmp18_ == ((0 != _tmp17_label1) ? _tmp17_label1 : (_tmp17_label1 = g_quark_from_static_string ("center")))) {
			switch (0) {
				default:
				{
					GtkLabel* _tmp20_;
					_tmp20_ = (GtkLabel*) gtk_label_new (_ ("Center"));
					g_object_ref_sink (_tmp20_);
					_g_object_unref0 (label);
					label = _tmp20_;
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					GtkLabel* _tmp21_;
					_tmp21_ = (GtkLabel*) gtk_label_new (_ ("End"));
					g_object_ref_sink (_tmp21_);
					_g_object_unref0 (label);
					label = _tmp21_;
					break;
				}
			}
		}
		_tmp22_ = label;
		_tmp23_ = gtk_widget_get_style_context ((GtkWidget*) _tmp22_);
		gtk_style_context_add_class (_tmp23_, "dim-label");
		_tmp24_ = label;
		_tmp25_ = gtk_widget_get_style_context ((GtkWidget*) _tmp24_);
		gtk_style_context_add_class (_tmp25_, "applet-row-header");
		_tmp26_ = label;
		gtk_widget_set_halign ((GtkWidget*) _tmp26_, GTK_ALIGN_START);
		_tmp27_ = label;
		gtk_widget_set_margin_start ((GtkWidget*) _tmp27_, 4);
		_tmp28_ = label;
		gtk_widget_set_margin_top ((GtkWidget*) _tmp28_, 2);
		_tmp29_ = label;
		gtk_widget_set_margin_bottom ((GtkWidget*) _tmp29_, 2);
		_tmp30_ = label;
		gtk_widget_set_valign ((GtkWidget*) _tmp30_, GTK_ALIGN_CENTER);
		_tmp31_ = label;
		gtk_label_set_use_markup (_tmp31_, TRUE);
		_tmp32_ = label;
		gtk_list_box_row_set_header (before, (GtkWidget*) _tmp32_);
		_g_object_unref0 (label);
	} else {
		gtk_list_box_row_set_header (before, NULL);
	}
	_g_free0 (next);
	_g_free0 (prev);
}

/**
* User requested to add a new applet to the active panel,
* show a chooser dialog
*/
static void
_vala_PeasPluginInfo_free (PeasPluginInfo* self)
{
	g_boxed_free (peas_plugin_info_get_type (), self);
}

static void
__vala_PeasPluginInfo_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_PeasPluginInfo_free (var), NULL));
}

static inline void
_g_list_free___vala_PeasPluginInfo_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) __vala_PeasPluginInfo_free0_);
}

static void
budgie_applets_page_add_applet (BudgieAppletsPage* self)
{
	BudgieAppletChooser* dlg = NULL;
	GtkWidget* _tmp0_;
	BudgieAppletChooser* _tmp1_;
	BudgieAppletChooser* _tmp2_;
	BudgieDesktopManager* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	gchar* applet_id = NULL;
	BudgieAppletChooser* _tmp6_;
	gchar* _tmp7_;
	BudgieAppletChooser* _tmp8_;
	const gchar* _tmp9_;
	BudgieToplevel* _tmp10_;
	const gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = budgie_applet_chooser_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp0_) : NULL);
	g_object_ref_sink (_tmp1_);
	dlg = _tmp1_;
	_tmp2_ = dlg;
	_tmp3_ = self->priv->manager;
	_tmp4_ = budgie_desktop_manager_get_panel_plugins (_tmp3_);
	_tmp5_ = _tmp4_;
	budgie_applet_chooser_set_plugin_list (_tmp2_, _tmp5_);
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (_g_list_free___vala_PeasPluginInfo_free0_ (_tmp5_), NULL));
	_tmp6_ = dlg;
	_tmp7_ = budgie_applet_chooser_run (_tmp6_);
	applet_id = _tmp7_;
	_tmp8_ = dlg;
	gtk_widget_destroy ((GtkWidget*) _tmp8_);
	_tmp9_ = applet_id;
	if (_tmp9_ == NULL) {
		_g_free0 (applet_id);
		_g_object_unref0 (dlg);
		return;
	}
	_tmp10_ = self->priv->toplevel;
	_tmp11_ = applet_id;
	budgie_toplevel_add_new_applet (_tmp10_, _tmp11_);
	_g_free0 (applet_id);
	_g_object_unref0 (dlg);
}

/**
* User requested we delete this applet. Make sure they meant it!
*/
static void
budgie_applets_page_remove_applet (BudgieAppletsPage* self)
{
	BudgieAppletInfo* _tmp0_;
	BudgieRemoveAppletDialog* dlg = NULL;
	GtkWidget* _tmp1_;
	BudgieRemoveAppletDialog* _tmp2_;
	gboolean del = FALSE;
	BudgieRemoveAppletDialog* _tmp3_;
	BudgieRemoveAppletDialog* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current_info;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp2_ = budgie_remove_applet_dialog_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp1_) : NULL);
	g_object_ref_sink (_tmp2_);
	dlg = _tmp2_;
	_tmp3_ = dlg;
	del = budgie_remove_applet_dialog_run (_tmp3_);
	_tmp4_ = dlg;
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
	if (del) {
		BudgieToplevel* _tmp5_;
		BudgieAppletInfo* _tmp6_;
		GtkButton* _tmp7_;
		GtkButton* _tmp8_;
		GtkButton* _tmp9_;
		_tmp5_ = self->priv->toplevel;
		_tmp6_ = self->priv->current_info;
		budgie_toplevel_remove_applet (_tmp5_, _tmp6_);
		self->priv->current_info = NULL;
		_tmp7_ = self->priv->button_remove_applet;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, FALSE);
		_tmp8_ = self->priv->button_move_applet_up;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp8_, FALSE);
		_tmp9_ = self->priv->button_move_applet_down;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, FALSE);
	}
	_g_object_unref0 (dlg);
}

/**
* User moved the applet up in the list (left in budgie terms)
*/
static void
budgie_applets_page_move_applet_up (BudgieAppletsPage* self)
{
	gboolean _tmp0_ = FALSE;
	BudgieAppletInfo* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->current_info;
	if (_tmp1_ != NULL) {
		BudgieToplevel* _tmp2_;
		BudgieAppletInfo* _tmp3_;
		_tmp2_ = self->priv->toplevel;
		_tmp3_ = self->priv->current_info;
		_tmp0_ = budgie_toplevel_can_move_applet_left (_tmp2_, _tmp3_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		BudgieToplevel* _tmp4_;
		BudgieAppletInfo* _tmp5_;
		_tmp4_ = self->priv->toplevel;
		_tmp5_ = self->priv->current_info;
		budgie_toplevel_move_applet_left (_tmp4_, _tmp5_);
	}
}

/**
* User moved the applet down in the list (right in budgie terms)
*/
static void
budgie_applets_page_move_applet_down (BudgieAppletsPage* self)
{
	gboolean _tmp0_ = FALSE;
	BudgieAppletInfo* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->current_info;
	if (_tmp1_ != NULL) {
		BudgieToplevel* _tmp2_;
		BudgieAppletInfo* _tmp3_;
		_tmp2_ = self->priv->toplevel;
		_tmp3_ = self->priv->current_info;
		_tmp0_ = budgie_toplevel_can_move_applet_right (_tmp2_, _tmp3_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		BudgieToplevel* _tmp4_;
		BudgieAppletInfo* _tmp5_;
		_tmp4_ = self->priv->toplevel;
		_tmp5_ = self->priv->current_info;
		budgie_toplevel_move_applet_right (_tmp4_, _tmp5_);
	}
}

static void
budgie_applets_page_class_init (BudgieAppletsPageClass * klass,
                                gpointer klass_data)
{
	budgie_applets_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieAppletsPage_private_offset);
	G_OBJECT_CLASS (klass)->finalize = budgie_applets_page_finalize;
}

static void
budgie_applets_page_instance_init (BudgieAppletsPage * self,
                                   gpointer klass)
{
	self->priv = budgie_applets_page_get_instance_private (self);
	self->priv->manager = NULL;
	self->priv->current_info = NULL;
}

static void
budgie_applets_page_finalize (GObject * obj)
{
	BudgieAppletsPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_APPLETS_PAGE, BudgieAppletsPage);
	_g_object_unref0 (self->priv->button_add);
	_g_object_unref0 (self->priv->button_move_applet_up);
	_g_object_unref0 (self->priv->button_move_applet_down);
	_g_object_unref0 (self->priv->button_remove_applet);
	_g_object_unref0 (self->priv->listbox_applets);
	_g_hash_table_unref0 (self->priv->items);
	_g_object_unref0 (self->priv->settings_stack);
	G_OBJECT_CLASS (budgie_applets_page_parent_class)->finalize (obj);
}

/**
* AppletsPage contains the applets view for a given panel
*/
static GType
budgie_applets_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieAppletsPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_applets_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieAppletsPage), 0, (GInstanceInitFunc) budgie_applets_page_instance_init, NULL };
	GType budgie_applets_page_type_id;
	budgie_applets_page_type_id = g_type_register_static (gtk_box_get_type (), "BudgieAppletsPage", &g_define_type_info, 0);
	BudgieAppletsPage_private_offset = g_type_add_instance_private (budgie_applets_page_type_id, sizeof (BudgieAppletsPagePrivate));
	return budgie_applets_page_type_id;
}

GType
budgie_applets_page_get_type (void)
{
	static volatile gsize budgie_applets_page_type_id__once = 0;
	if (g_once_init_enter (&budgie_applets_page_type_id__once)) {
		GType budgie_applets_page_type_id;
		budgie_applets_page_type_id = budgie_applets_page_get_type_once ();
		g_once_init_leave (&budgie_applets_page_type_id__once, budgie_applets_page_type_id);
	}
	return budgie_applets_page_type_id__once;
}

