/* background.c generated by valac 0.56.3, the Vala compiler
 * generated from background.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright © 2015-2022 Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <clutter/clutter.h>
#include <glib-object.h>
#include <meta/meta-background-group.h>
#include <meta/display.h>
#include <gio/gio.h>
#include <meta/meta-background-image.h>
#include <meta/meta-plugin.h>
#include <libgnome-desktop/gnome-bg-crossfade.h>
#include <libgnome-desktop/gnome-bg-slide-show.h>
#include <libgnome-desktop/gnome-bg.h>
#include <libgnome-desktop/gnome-desktop-thumbnail.h>
#include <libgnome-desktop/gnome-idle-monitor.h>
#include <libgnome-desktop/gnome-languages.h>
#include <libgnome-desktop/gnome-pnp-ids.h>
#include <libgnome-desktop/gnome-rr-config.h>
#include <libgnome-desktop/gnome-rr.h>
#include <libgnome-desktop/gnome-wall-clock.h>
#include <libgnome-desktop/gnome-xkb-info.h>
#include <gsettings-desktop-schemas/gdesktop-enums.h>
#include <meta/main.h>
#include <float.h>
#include <math.h>
#include <meta/meta-background.h>
#include <meta/meta-background-actor.h>
#include <meta/meta-background-content.h>

#define BUDGIE_BACKGROUND_SCHEMA "org.gnome.desktop.background"
#define BUDGIE_PICTURE_URI_KEY "picture-uri"
#define BUDGIE_PRIMARY_COLOR_KEY "primary-color"
#define BUDGIE_SECONDARY_COLOR_KEY "secondary-color"
#define BUDGIE_COLOR_SHADING_TYPE_KEY "color-shading-type"
#define BUDGIE_BACKGROUND_STYLE_KEY "picture-options"
#define BUDGIE_GNOME_COLOR_HACK "budgie-control-center/pixmaps/noise-texture-light.png"
#define BUDGIE_ACCOUNTS_SCHEMA "org.freedesktop.Accounts"
#define BUDGIE_BUDGIE_BACKGROUND_BACKGROUND_TIMEOUT 850
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_BUDGIE_BACKGROUND (budgie_budgie_background_get_type ())
#define BUDGIE_BUDGIE_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_BUDGIE_BACKGROUND, BudgieBudgieBackground))
#define BUDGIE_BUDGIE_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_BUDGIE_BACKGROUND, BudgieBudgieBackgroundClass))
#define BUDGIE_IS_BUDGIE_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_BUDGIE_BACKGROUND))
#define BUDGIE_IS_BUDGIE_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_BUDGIE_BACKGROUND))
#define BUDGIE_BUDGIE_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_BUDGIE_BACKGROUND, BudgieBudgieBackgroundClass))

typedef struct _BudgieBudgieBackground BudgieBudgieBackground;
typedef struct _BudgieBudgieBackgroundClass BudgieBudgieBackgroundClass;
typedef struct _BudgieBudgieBackgroundPrivate BudgieBudgieBackgroundPrivate;

#define BUDGIE_TYPE_BUDGIE_WM (budgie_budgie_wm_get_type ())
#define BUDGIE_BUDGIE_WM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_BUDGIE_WM, BudgieBudgieWM))
#define BUDGIE_BUDGIE_WM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_BUDGIE_WM, BudgieBudgieWMClass))
#define BUDGIE_IS_BUDGIE_WM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_BUDGIE_WM))
#define BUDGIE_IS_BUDGIE_WM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_BUDGIE_WM))
#define BUDGIE_BUDGIE_WM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_BUDGIE_WM, BudgieBudgieWMClass))

typedef struct _BudgieBudgieWM BudgieBudgieWM;
typedef struct _BudgieBudgieWMClass BudgieBudgieWMClass;
enum  {
	BUDGIE_BUDGIE_BACKGROUND_0_PROPERTY,
	BUDGIE_BUDGIE_BACKGROUND_DISPLAY_PROPERTY,
	BUDGIE_BUDGIE_BACKGROUND_INDEX_PROPERTY,
	BUDGIE_BUDGIE_BACKGROUND_NUM_PROPERTIES
};
static GParamSpec* budgie_budgie_background_properties[BUDGIE_BUDGIE_BACKGROUND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _BudgieBudgieBackgroundLoadUriData BudgieBudgieBackgroundLoadUriData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
typedef struct _Block2Data Block2Data;
#define __vala_ClutterColor_free0(var) ((var == NULL) ? NULL : (var = (_vala_ClutterColor_free (var), NULL)))
typedef struct _Block3Data Block3Data;

struct _BudgieBudgieBackground {
	ClutterActor parent_instance;
	BudgieBudgieBackgroundPrivate * priv;
};

struct _BudgieBudgieBackgroundClass {
	ClutterActorClass parent_class;
};

struct _BudgieBudgieBackgroundPrivate {
	MetaBackgroundGroup* bg_group;
	MetaDisplay* _display;
	gint _index;
	GSettings* settings;
	ClutterActor* bg;
	ClutterActor* old_bg;
	MetaBackgroundImageCache* cache;
	BudgieBudgieWM* wm;
	GnomeBG* gnome_bg;
	GHashTable* images;
};

struct _Block1Data {
	int _ref_count_;
	BudgieBudgieBackground* self;
	MetaBackgroundImage* image;
	gulong rid;
	gpointer _async_data_;
};

struct _BudgieBudgieBackgroundLoadUriData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BudgieBudgieBackground* self;
	gchar* uri;
	Block1Data* _data1_;
	GHashTable* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GFile* f;
	GFile* _tmp4_;
	ClutterActor* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	MetaBackgroundImageCache* _tmp8_;
	GFile* _tmp9_;
	MetaBackgroundImage* _tmp10_;
	MetaBackgroundImage* _tmp11_;
	GHashTable* _tmp12_;
	gchar* _tmp13_;
	MetaBackgroundImage* _tmp14_;
	MetaBackgroundImage* _tmp15_;
	MetaBackgroundImage* _tmp16_;
	gulong _tmp17_;
};

struct _Block2Data {
	int _ref_count_;
	BudgieBudgieBackground* self;
	gchar* bg_filename;
	MetaBackground* background;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	GFile* bg_file;
};

static gint BudgieBudgieBackground_private_offset;
static gpointer budgie_budgie_background_parent_class = NULL;

VALA_EXTERN GType budgie_budgie_background_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieBudgieBackground, g_object_unref)
VALA_EXTERN GType budgie_budgie_wm_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieBudgieWM, g_object_unref)
static gboolean budgie_budgie_background_is_color_wallpaper (BudgieBudgieBackground* self,
                                                      const gchar* bg_filename);
VALA_EXTERN BudgieBudgieBackground* budgie_budgie_background_new (MetaDisplay* display,
                                                      gint index,
                                                      BudgieBudgieWM* wm);
VALA_EXTERN BudgieBudgieBackground* budgie_budgie_background_construct (GType object_type,
                                                            MetaDisplay* display,
                                                            gint index,
                                                            BudgieBudgieWM* wm);
VALA_EXTERN gint budgie_budgie_background_get_index (BudgieBudgieBackground* self);
static gboolean __lambda20_ (BudgieBudgieBackground* self);
static gboolean ___lambda20__g_settings_change_event (GSettings* _sender,
                                               GQuark* keys,
                                               gint n_keys,
                                               gpointer self);
static void __lambda21_ (BudgieBudgieBackground* self);
static void budgie_budgie_background_update (BudgieBudgieBackground* self);
static void ___lambda21__gnome_bg_changed (GnomeBG* _sender,
                                    gpointer self);
static void budgie_budgie_background_remove_old (BudgieBudgieBackground* self,
                                          ClutterActor* actor);
static void budgie_budgie_background_load_uri_data_free (gpointer _data);
static void budgie_budgie_background_load_uri (BudgieBudgieBackground* self,
                                        const gchar* uri,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void budgie_budgie_background_load_uri_finish (BudgieBudgieBackground* self,
                                               GAsyncResult* _res_);
static gboolean budgie_budgie_background_load_uri_co (BudgieBudgieBackgroundLoadUriData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void __lambda22_ (Block1Data* _data1_);
static gboolean _budgie_budgie_background_load_uri_co_gsource_func (gpointer self);
static void ___lambda22__meta_background_image_loaded (MetaBackgroundImage* _sender,
                                                gpointer self);
static void budgie_budgie_background_begin_remove_old (BudgieBudgieBackground* self,
                                                ClutterActor* actor);
static void _budgie_budgie_background_remove_old_clutter_actor_transitions_completed (ClutterActor* _sender,
                                                                               gpointer self);
VALA_EXTERN gboolean budgie_budgie_wm_get_use_animations (BudgieBudgieWM* self);
static void budgie_budgie_background_set_accountsservice_user_bg (BudgieBudgieBackground* self,
                                                           const gchar* background);
static void budgie_budgie_background_on_update (BudgieBudgieBackground* self);
static void _budgie_budgie_background_begin_remove_old_clutter_actor_transitions_completed (ClutterActor* _sender,
                                                                                     gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static ClutterColor* _vala_ClutterColor_copy (ClutterColor* self);
VALA_EXTERN MetaDisplay* budgie_budgie_background_get_display (BudgieBudgieBackground* self);
static void _vala_ClutterColor_free (ClutterColor* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ___lambda23_ (Block3Data* _data3_);
static void ____lambda23__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void _budgie_budgie_background_on_update_meta_background_changed (MetaBackground* _sender,
                                                                  gpointer self);
VALA_EXTERN void budgie_budgie_background_set_display (BudgieBudgieBackground* self,
                                           MetaDisplay* value);
VALA_EXTERN void budgie_budgie_background_set_index (BudgieBudgieBackground* self,
                                         gint value);
static void budgie_budgie_background_finalize (GObject * obj);
static GType budgie_budgie_background_get_type_once (void);
static void _vala_budgie_budgie_background_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_budgie_budgie_background_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);

static inline gpointer
budgie_budgie_background_get_instance_private (BudgieBudgieBackground* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieBudgieBackground_private_offset);
}

/**
* Determine if the wallpaper is a colour wallpaper or not
*/
static gboolean
budgie_budgie_background_is_color_wallpaper (BudgieBudgieBackground* self,
                                             const gchar* bg_filename)
{
	gboolean _tmp0_ = FALSE;
	GnomeBG* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bg_filename != NULL, FALSE);
	_tmp1_ = self->priv->gnome_bg;
	if (gnome_bg_get_placement (_tmp1_) == G_DESKTOP_BACKGROUND_STYLE_NONE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_str_has_suffix (bg_filename, BUDGIE_GNOME_COLOR_HACK);
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
__lambda20_ (BudgieBudgieBackground* self)
{
	GnomeBG* _tmp0_;
	GSettings* _tmp1_;
	gboolean result;
	_tmp0_ = self->priv->gnome_bg;
	_tmp1_ = self->priv->settings;
	gnome_bg_load_from_preferences (_tmp0_, _tmp1_);
	result = FALSE;
	return result;
}

static gboolean
___lambda20__g_settings_change_event (GSettings* _sender,
                                      GQuark* keys,
                                      gint n_keys,
                                      gpointer self)
{
	gboolean result;
	result = __lambda20_ ((BudgieBudgieBackground*) self);
	return result;
}

static void
__lambda21_ (BudgieBudgieBackground* self)
{
	budgie_budgie_background_update (self);
}

static void
___lambda21__gnome_bg_changed (GnomeBG* _sender,
                               gpointer self)
{
	__lambda21_ ((BudgieBudgieBackground*) self);
}

BudgieBudgieBackground*
budgie_budgie_background_construct (GType object_type,
                                    MetaDisplay* display,
                                    gint index,
                                    BudgieBudgieWM* wm)
{
	BudgieBudgieBackground * self = NULL;
	MetaRectangle rect = {0};
	MetaBackgroundGroup* _tmp0_;
	MetaBackgroundGroup* _tmp1_;
	MetaBackgroundImageCache* _tmp2_;
	MetaBackgroundImageCache* _tmp3_;
	GSettings* _tmp4_;
	GnomeBG* _tmp5_;
	gint _tmp6_;
	MetaRectangle _tmp7_ = {0};
	MetaRectangle _tmp8_;
	MetaRectangle _tmp9_;
	MetaRectangle _tmp10_;
	MetaRectangle _tmp11_;
	GSettings* _tmp12_;
	GnomeBG* _tmp13_;
	GnomeBG* _tmp14_;
	GSettings* _tmp15_;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (BudgieBudgieBackground*) g_object_new (object_type, "display", display, "index", index, NULL);
	self->priv->wm = wm;
	_tmp0_ = (MetaBackgroundGroup*) meta_background_group_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->bg_group);
	self->priv->bg_group = _tmp0_;
	_tmp1_ = self->priv->bg_group;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp1_);
	_tmp2_ = meta_background_image_cache_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->cache);
	self->priv->cache = _tmp3_;
	_tmp4_ = g_settings_new ("org.gnome.desktop.background");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp4_;
	_tmp5_ = gnome_bg_new ();
	_g_object_unref0 (self->priv->gnome_bg);
	self->priv->gnome_bg = _tmp5_;
	_tmp6_ = self->priv->_index;
	meta_display_get_monitor_geometry (display, _tmp6_, &_tmp7_);
	rect = _tmp7_;
	_tmp8_ = rect;
	_tmp9_ = rect;
	clutter_actor_set_position ((ClutterActor*) self, (gfloat) _tmp8_.x, (gfloat) _tmp9_.y);
	_tmp10_ = rect;
	_tmp11_ = rect;
	clutter_actor_set_size ((ClutterActor*) self, (gfloat) _tmp10_.width, (gfloat) _tmp11_.height);
	_tmp12_ = self->priv->settings;
	g_signal_connect_object (_tmp12_, "change-event", (GCallback) ___lambda20__g_settings_change_event, self, 0);
	_tmp13_ = self->priv->gnome_bg;
	g_signal_connect_object (_tmp13_, "changed", (GCallback) ___lambda21__gnome_bg_changed, self, 0);
	clutter_actor_set_background_color ((ClutterActor*) self, clutter_color_get_static (CLUTTER_COLOR_BLACK));
	_tmp14_ = self->priv->gnome_bg;
	_tmp15_ = self->priv->settings;
	gnome_bg_load_from_preferences (_tmp14_, _tmp15_);
	return self;
}

BudgieBudgieBackground*
budgie_budgie_background_new (MetaDisplay* display,
                              gint index,
                              BudgieBudgieWM* wm)
{
	return budgie_budgie_background_construct (BUDGIE_TYPE_BUDGIE_BACKGROUND, display, index, wm);
}

static void
budgie_budgie_background_remove_old (BudgieBudgieBackground* self,
                                     ClutterActor* actor)
{
	GFile* bwm_file = NULL;
	gconstpointer _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_object_get_data ((GObject*) actor, "_bwm_uri");
	_tmp1_ = _g_object_ref0 ((GFile*) _tmp0_);
	bwm_file = _tmp1_;
	_tmp2_ = bwm_file;
	if (_tmp2_ != NULL) {
		MetaBackgroundImageCache* _tmp3_;
		GFile* _tmp4_;
		GHashTable* _tmp5_;
		GFile* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp3_ = self->priv->cache;
		_tmp4_ = bwm_file;
		meta_background_image_cache_purge (_tmp3_, _tmp4_);
		_tmp5_ = self->priv->images;
		_tmp6_ = bwm_file;
		_tmp7_ = g_file_get_uri (_tmp6_);
		_tmp8_ = _tmp7_;
		g_hash_table_remove (_tmp5_, _tmp8_);
		_g_free0 (_tmp8_);
		_g_object_unref0 (bwm_file);
		bwm_file = NULL;
	}
	clutter_actor_destroy (actor);
	_g_object_unref0 (self->priv->old_bg);
	self->priv->old_bg = NULL;
	_g_object_unref0 (bwm_file);
}

static void
budgie_budgie_background_load_uri_data_free (gpointer _data)
{
	BudgieBudgieBackgroundLoadUriData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieBudgieBackgroundLoadUriData, _data_);
}

static void
budgie_budgie_background_load_uri (BudgieBudgieBackground* self,
                                   const gchar* uri,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	BudgieBudgieBackgroundLoadUriData* _data_;
	BudgieBudgieBackground* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_data_ = g_slice_new0 (BudgieBudgieBackgroundLoadUriData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, budgie_budgie_background_load_uri_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	budgie_budgie_background_load_uri_co (_data_);
}

static void
budgie_budgie_background_load_uri_finish (BudgieBudgieBackground* self,
                                          GAsyncResult* _res_)
{
	BudgieBudgieBackgroundLoadUriData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
* Load the image from the meta background cache
*
* Note we purposefully load the image into the cache manually, as this will
* enable smooth background transitions
*/
static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		BudgieBudgieBackground* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->image);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gboolean
_budgie_budgie_background_load_uri_co_gsource_func (gpointer self)
{
	gboolean result;
	result = budgie_budgie_background_load_uri_co (self);
	return result;
}

static void
__lambda22_ (Block1Data* _data1_)
{
	BudgieBudgieBackground* self;
	MetaBackgroundImage* _tmp0_;
	self = _data1_->self;
	_tmp0_ = _data1_->image;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _data1_->rid);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _budgie_budgie_background_load_uri_co_gsource_func, _data1_->_async_data_, NULL);
}

static void
___lambda22__meta_background_image_loaded (MetaBackgroundImage* _sender,
                                           gpointer self)
{
	__lambda22_ (self);
}

static gboolean
budgie_budgie_background_load_uri_co (BudgieBudgieBackgroundLoadUriData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->images;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = g_str_hash;
		_data_->_tmp2_ = g_str_equal;
		_data_->_tmp3_ = g_hash_table_new_full (_data_->_tmp1_, _data_->_tmp2_, _g_free0_, _g_object_unref0_);
		_g_hash_table_unref0 (_data_->self->priv->images);
		_data_->self->priv->images = _data_->_tmp3_;
	}
	_data_->_tmp4_ = g_file_new_for_uri (_data_->uri);
	_data_->f = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->self->priv->bg;
	_data_->_tmp6_ = _data_->f;
	_data_->_tmp7_ = _g_object_ref0 (_data_->_tmp6_);
	g_object_set_data_full ((GObject*) _data_->_tmp5_, "_bwm_uri", _data_->_tmp7_, g_object_unref);
	_data_->_tmp8_ = _data_->self->priv->cache;
	_data_->_tmp9_ = _data_->f;
	_data_->_tmp10_ = meta_background_image_cache_load (_data_->_tmp8_, _data_->_tmp9_);
	_data_->_data1_->image = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->_data1_->image;
	if (meta_background_image_is_loaded (_data_->_tmp11_)) {
		_g_object_unref0 (_data_->f);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->self->priv->images;
	_data_->_tmp13_ = g_strdup (_data_->uri);
	_data_->_tmp14_ = _data_->_data1_->image;
	_data_->_tmp15_ = _g_object_ref0 (_data_->_tmp14_);
	g_hash_table_insert (_data_->_tmp12_, _data_->_tmp13_, _data_->_tmp15_);
	_data_->_data1_->rid = (gulong) 0;
	_data_->_tmp16_ = _data_->_data1_->image;
	_data_->_tmp17_ = g_signal_connect_data (_data_->_tmp16_, "loaded", (GCallback) ___lambda22__meta_background_image_loaded, block1_data_ref (_data_->_data1_), (GClosureNotify) block1_data_unref, 0);
	_data_->_data1_->rid = _data_->_tmp17_;
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_g_object_unref0 (_data_->f);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
* Remove the old wallpaper during the new wallpaper update
*/
static void
_budgie_budgie_background_remove_old_clutter_actor_transitions_completed (ClutterActor* _sender,
                                                                          gpointer self)
{
	budgie_budgie_background_remove_old ((BudgieBudgieBackground*) self, _sender);
}

static void
budgie_budgie_background_begin_remove_old (BudgieBudgieBackground* self,
                                           ClutterActor* actor)
{
	gboolean _tmp0_ = FALSE;
	ClutterActor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->old_bg;
	if (_tmp1_ != NULL) {
		ClutterActor* _tmp2_;
		ClutterActor* _tmp3_;
		_tmp2_ = self->priv->old_bg;
		_tmp3_ = self->priv->bg;
		_tmp0_ = _tmp2_ != _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ClutterActor* _tmp4_;
		ClutterActor* _tmp5_;
		ClutterActor* _tmp6_;
		gint timeout = 0;
		BudgieBudgieWM* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		ClutterActor* _tmp10_;
		ClutterActor* _tmp11_;
		ClutterActor* _tmp12_;
		_tmp4_ = self->priv->old_bg;
		g_signal_connect_object (_tmp4_, "transitions-completed", (GCallback) _budgie_budgie_background_remove_old_clutter_actor_transitions_completed, self, 0);
		_tmp5_ = self->priv->old_bg;
		clutter_actor_save_easing_state (_tmp5_);
		_tmp6_ = self->priv->old_bg;
		clutter_actor_set_easing_mode (_tmp6_, CLUTTER_EASE_OUT_QUAD);
		timeout = 0;
		_tmp7_ = self->priv->wm;
		_tmp8_ = budgie_budgie_wm_get_use_animations (_tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp9_) {
			timeout = BUDGIE_BUDGIE_BACKGROUND_BACKGROUND_TIMEOUT;
		}
		_tmp10_ = self->priv->old_bg;
		clutter_actor_set_easing_duration (_tmp10_, (guint) timeout);
		_tmp11_ = self->priv->old_bg;
		g_object_set ((GObject*) _tmp11_, "opacity", 0, NULL);
		_tmp12_ = self->priv->old_bg;
		clutter_actor_restore_easing_state (_tmp12_);
	}
}

/**
* call accountsservice dbus with the background file name
* to update the greeter background if the display
* manager supports the dbus call.
*/
static void
budgie_budgie_background_set_accountsservice_user_bg (BudgieBudgieBackground* self,
                                                      const gchar* background)
{
	GDBusConnection* bus = NULL;
	GVariant* variant = NULL;
	gchar* object_path = NULL;
	GVariant* _tmp18_;
	GVariant* _tmp19_;
	GVariant* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (background != NULL);
	{
		GDBusConnection* _tmp0_ = NULL;
		GDBusConnection* _tmp1_;
		GDBusConnection* _tmp2_;
		_tmp1_ = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			_g_variant_unref0 (variant);
			_g_object_unref0 (bus);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (bus);
		bus = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("background.vala:158: Failed to get system bus: %s", _tmp4_);
		_g_error_free0 (e);
		_g_variant_unref0 (variant);
		_g_object_unref0 (bus);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_variant_unref0 (variant);
		_g_object_unref0 (bus);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		GVariant* _tmp5_ = NULL;
		GDBusConnection* _tmp6_;
		const gchar* _tmp7_;
		GVariant* _tmp8_;
		GVariant* _tmp9_;
		GVariantType* _tmp10_;
		GVariantType* _tmp11_;
		GVariant* _tmp12_;
		GVariant* _tmp13_;
		GVariant* _tmp14_;
		_tmp6_ = bus;
		_tmp7_ = g_get_user_name ();
		_tmp8_ = g_variant_new ("(s)", _tmp7_, NULL);
		g_variant_ref_sink (_tmp8_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_variant_type_new ("(o)");
		_tmp11_ = _tmp10_;
		_tmp12_ = g_dbus_connection_call_sync (_tmp6_, BUDGIE_ACCOUNTS_SCHEMA, "/org/freedesktop/Accounts", BUDGIE_ACCOUNTS_SCHEMA, "FindUserByName", _tmp9_, _tmp11_, G_DBUS_CALL_FLAGS_NONE, -1, NULL, &_inner_error0_);
		_tmp13_ = _tmp12_;
		_g_variant_type_free0 (_tmp11_);
		_g_variant_unref0 (_tmp9_);
		_tmp5_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp14_ = _tmp5_;
		_tmp5_ = NULL;
		_g_variant_unref0 (variant);
		variant = _tmp14_;
		_g_variant_unref0 (_tmp5_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = g_get_user_name ();
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning ("background.vala:166: Could not contact accounts service to look up '%s" \
"': %s", _tmp15_, _tmp17_);
		_g_error_free0 (e);
		_g_variant_unref0 (variant);
		_g_object_unref0 (bus);
		return;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_variant_unref0 (variant);
		_g_object_unref0 (bus);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp18_ = variant;
	_tmp19_ = g_variant_get_child_value (_tmp18_, (gsize) 0);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_variant_get_string (_tmp20_, NULL);
	_tmp22_ = g_strdup (_tmp21_);
	_tmp23_ = _tmp22_;
	_g_variant_unref0 (_tmp20_);
	object_path = _tmp23_;
	{
		GDBusConnection* _tmp24_;
		const gchar* _tmp25_;
		GVariant* _tmp26_;
		GVariant* _tmp27_;
		GVariant* _tmp28_;
		GVariant* _tmp29_;
		GVariantType* _tmp30_;
		GVariantType* _tmp31_;
		GVariant* _tmp32_;
		GVariant* _tmp33_;
		_tmp24_ = bus;
		_tmp25_ = object_path;
		_tmp26_ = g_variant_new_string (background);
		g_variant_ref_sink (_tmp26_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_variant_new ("(ssv)", "org.freedesktop.DisplayManager.AccountsService", "BackgroundFile", _tmp27_, NULL);
		g_variant_ref_sink (_tmp28_);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_variant_type_new ("()");
		_tmp31_ = _tmp30_;
		_tmp32_ = g_dbus_connection_call_sync (_tmp24_, BUDGIE_ACCOUNTS_SCHEMA, _tmp25_, "org.freedesktop.DBus.Properties", "Set", _tmp29_, _tmp31_, G_DBUS_CALL_FLAGS_NONE, -1, NULL, &_inner_error0_);
		_tmp33_ = _tmp32_;
		_g_variant_unref0 (_tmp33_);
		_g_variant_type_free0 (_tmp31_);
		_g_variant_unref0 (_tmp29_);
		_g_variant_unref0 (_tmp27_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp34_;
		const gchar* _tmp35_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp34_ = e;
		_tmp35_ = _tmp34_->message;
		g_warning ("background.vala:178: Failed to set the background '%s': %s", background, _tmp35_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (object_path);
		_g_variant_unref0 (variant);
		_g_object_unref0 (bus);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (object_path);
	_g_variant_unref0 (variant);
	_g_object_unref0 (bus);
}

/**
* Wallpaper updated, begin modifying the new one
*/
static void
_budgie_budgie_background_begin_remove_old_clutter_actor_transitions_completed (ClutterActor* _sender,
                                                                                gpointer self)
{
	budgie_budgie_background_begin_remove_old ((BudgieBudgieBackground*) self, _sender);
}

static void
budgie_budgie_background_on_update (BudgieBudgieBackground* self)
{
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	gint timeout = 0;
	BudgieBudgieWM* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	ClutterActor* _tmp6_;
	ClutterActor* _tmp7_;
	ClutterActor* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bg;
	clutter_actor_save_easing_state (_tmp0_);
	_tmp1_ = self->priv->bg;
	g_signal_connect_object (_tmp1_, "transitions-completed", (GCallback) _budgie_budgie_background_begin_remove_old_clutter_actor_transitions_completed, self, 0);
	_tmp2_ = self->priv->bg;
	clutter_actor_set_easing_mode (_tmp2_, CLUTTER_EASE_IN_EXPO);
	timeout = 0;
	_tmp3_ = self->priv->wm;
	_tmp4_ = budgie_budgie_wm_get_use_animations (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		timeout = BUDGIE_BUDGIE_BACKGROUND_BACKGROUND_TIMEOUT;
	}
	_tmp6_ = self->priv->bg;
	clutter_actor_set_easing_duration (_tmp6_, (guint) timeout);
	_tmp7_ = self->priv->bg;
	g_object_set ((GObject*) _tmp7_, "opacity", 255, NULL);
	_tmp8_ = self->priv->bg;
	clutter_actor_restore_easing_state (_tmp8_);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		BudgieBudgieBackground* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->background);
		_g_free0 (_data2_->bg_filename);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static ClutterColor*
_vala_ClutterColor_copy (ClutterColor* self)
{
	return g_boxed_copy (clutter_color_get_type (), self);
}

static gpointer
__vala_ClutterColor_copy0 (gpointer self)
{
	return self ? _vala_ClutterColor_copy (self) : NULL;
}

static void
_vala_ClutterColor_free (ClutterColor* self)
{
	g_boxed_free (clutter_color_get_type (), self);
}

static ClutterColor*
_vala_clutter_color_from_string (const gchar* str)
{
	ClutterColor* color = NULL;
	ClutterColor* _tmp0_;
	ClutterColor* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = clutter_color_alloc ();
	color = _tmp0_;
	clutter_color_from_string (color, str);
	result = color;
	return result;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		BudgieBudgieBackground* self;
		self = _data3_->_data2_->self;
		_g_object_unref0 (_data3_->bg_file);
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}

static void
___lambda23_ (Block3Data* _data3_)
{
	Block2Data* _data2_;
	BudgieBudgieBackground* self;
	MetaBackground* _tmp0_;
	GFile* _tmp1_;
	GnomeBG* _tmp2_;
	const gchar* _tmp3_;
	_data2_ = _data3_->_data2_;
	self = _data2_->self;
	_tmp0_ = _data2_->background;
	_tmp1_ = _data3_->bg_file;
	_tmp2_ = self->priv->gnome_bg;
	meta_background_set_file (_tmp0_, _tmp1_, gnome_bg_get_placement (_tmp2_));
	budgie_budgie_background_on_update (self);
	_tmp3_ = _data2_->bg_filename;
	budgie_budgie_background_set_accountsservice_user_bg (self, _tmp3_);
}

static void
____lambda23__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda23_ (self);
	block3_data_unref (self);
}

static void
_budgie_budgie_background_on_update_meta_background_changed (MetaBackground* _sender,
                                                             gpointer self)
{
	budgie_budgie_background_on_update ((BudgieBudgieBackground*) self);
}

static void
budgie_budgie_background_update (BudgieBudgieBackground* self)
{
	Block2Data* _data2_;
	GnomeBG* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GDesktopBackgroundShading shading_direction = 0;
	MetaRectangle rect = {0};
	ClutterColor* primary_color = NULL;
	ClutterColor _tmp3_ = {0};
	ClutterColor* _tmp4_;
	ClutterColor* secondary_color = NULL;
	ClutterColor _tmp5_ = {0};
	ClutterColor* _tmp6_;
	MetaBackgroundActor* actor = NULL;
	MetaDisplay* _tmp7_;
	gint _tmp8_;
	MetaBackgroundActor* _tmp9_;
	MetaDisplay* _tmp10_;
	MetaBackground* _tmp11_;
	ClutterContent* content = NULL;
	MetaBackgroundActor* _tmp12_;
	ClutterContent* _tmp13_;
	ClutterContent* _tmp14_;
	MetaBackgroundContent* background_content = NULL;
	ClutterContent* _tmp15_;
	MetaBackgroundContent* _tmp16_;
	MetaBackground* _tmp17_;
	MetaDisplay* _tmp18_;
	gint _tmp19_;
	MetaRectangle _tmp20_ = {0};
	MetaBackgroundActor* _tmp21_;
	MetaRectangle _tmp22_;
	MetaRectangle _tmp23_;
	MetaBackgroundActor* _tmp24_;
	MetaBackgroundActor* _tmp25_;
	MetaBackgroundActor* _tmp26_;
	ClutterActor* _tmp27_;
	MetaBackgroundActor* _tmp30_;
	ClutterActor* _tmp31_;
	GSettings* _tmp32_;
	gchar* color_str = NULL;
	GSettings* _tmp33_;
	gchar* _tmp34_;
	gboolean _tmp35_ = FALSE;
	const gchar* _tmp36_;
	GSettings* _tmp43_;
	gchar* _tmp44_;
	gboolean _tmp45_ = FALSE;
	const gchar* _tmp46_;
	gboolean _tmp61_ = FALSE;
	const gchar* _tmp62_;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = self->priv->gnome_bg;
	_tmp1_ = gnome_bg_get_filename (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	_data2_->bg_filename = _tmp2_;
	memset (&_tmp3_, 0, sizeof (ClutterColor));
	_tmp4_ = __vala_ClutterColor_copy0 (&_tmp3_);
	primary_color = _tmp4_;
	memset (&_tmp5_, 0, sizeof (ClutterColor));
	_tmp6_ = __vala_ClutterColor_copy0 (&_tmp5_);
	secondary_color = _tmp6_;
	_tmp7_ = self->priv->_display;
	_tmp8_ = self->priv->_index;
	_tmp9_ = (MetaBackgroundActor*) meta_background_actor_new (_tmp7_, _tmp8_);
	g_object_ref_sink (_tmp9_);
	actor = _tmp9_;
	_tmp10_ = self->priv->_display;
	_tmp11_ = meta_background_new (_tmp10_);
	_data2_->background = _tmp11_;
	_tmp12_ = actor;
	_tmp13_ = clutter_actor_get_content ((ClutterActor*) _tmp12_);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	content = _tmp14_;
	_tmp15_ = content;
	background_content = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, meta_background_content_get_type (), MetaBackgroundContent);
	_tmp16_ = background_content;
	_tmp17_ = _data2_->background;
	meta_background_content_set_background (_tmp16_, _tmp17_);
	_tmp18_ = self->priv->_display;
	_tmp19_ = self->priv->_index;
	meta_display_get_monitor_geometry (_tmp18_, _tmp19_, &_tmp20_);
	rect = _tmp20_;
	_tmp21_ = actor;
	_tmp22_ = rect;
	_tmp23_ = rect;
	clutter_actor_set_size ((ClutterActor*) _tmp21_, (gfloat) _tmp22_.width, (gfloat) _tmp23_.height);
	_tmp24_ = actor;
	g_object_set ((GObject*) _tmp24_, "opacity", 0, NULL);
	_tmp25_ = actor;
	clutter_actor_show ((ClutterActor*) _tmp25_);
	_tmp26_ = actor;
	clutter_actor_insert_child_at_index ((ClutterActor*) self, (ClutterActor*) _tmp26_, -1);
	_tmp27_ = self->priv->bg;
	if (_tmp27_ != NULL) {
		ClutterActor* _tmp28_;
		ClutterActor* _tmp29_;
		_tmp28_ = self->priv->bg;
		_tmp29_ = _g_object_ref0 (_tmp28_);
		_g_object_unref0 (self->priv->old_bg);
		self->priv->old_bg = _tmp29_;
	}
	_tmp30_ = actor;
	_tmp31_ = _g_object_ref0 ((ClutterActor*) _tmp30_);
	_g_object_unref0 (self->priv->bg);
	self->priv->bg = _tmp31_;
	_tmp32_ = self->priv->settings;
	shading_direction = (GDesktopBackgroundShading) g_settings_get_enum (_tmp32_, BUDGIE_COLOR_SHADING_TYPE_KEY);
	_tmp33_ = self->priv->settings;
	_tmp34_ = g_settings_get_string (_tmp33_, BUDGIE_PRIMARY_COLOR_KEY);
	color_str = _tmp34_;
	_tmp36_ = color_str;
	if (_tmp36_ != NULL) {
		const gchar* _tmp37_;
		_tmp37_ = color_str;
		_tmp35_ = g_strcmp0 (_tmp37_, "") != 0;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		ClutterColor _tmp38_ = {0};
		ClutterColor* _tmp39_;
		const gchar* _tmp40_;
		ClutterColor* _tmp41_;
		ClutterColor* _tmp42_;
		memset (&_tmp38_, 0, sizeof (ClutterColor));
		_tmp39_ = __vala_ClutterColor_copy0 (&_tmp38_);
		__vala_ClutterColor_free0 (primary_color);
		primary_color = _tmp39_;
		_tmp40_ = color_str;
		_tmp41_ = _vala_clutter_color_from_string (_tmp40_);
		_tmp42_ = _tmp41_;
		__vala_ClutterColor_free0 (_tmp42_);
		_g_free0 (color_str);
		color_str = NULL;
	}
	_tmp43_ = self->priv->settings;
	_tmp44_ = g_settings_get_string (_tmp43_, BUDGIE_SECONDARY_COLOR_KEY);
	_g_free0 (color_str);
	color_str = _tmp44_;
	_tmp46_ = color_str;
	if (_tmp46_ != NULL) {
		const gchar* _tmp47_;
		_tmp47_ = color_str;
		_tmp45_ = g_strcmp0 (_tmp47_, "") != 0;
	} else {
		_tmp45_ = FALSE;
	}
	if (_tmp45_) {
		ClutterColor _tmp48_ = {0};
		ClutterColor* _tmp49_;
		const gchar* _tmp50_;
		ClutterColor* _tmp51_;
		ClutterColor* _tmp52_;
		memset (&_tmp48_, 0, sizeof (ClutterColor));
		_tmp49_ = __vala_ClutterColor_copy0 (&_tmp48_);
		__vala_ClutterColor_free0 (secondary_color);
		secondary_color = _tmp49_;
		_tmp50_ = color_str;
		_tmp51_ = _vala_clutter_color_from_string (_tmp50_);
		_tmp52_ = _tmp51_;
		__vala_ClutterColor_free0 (_tmp52_);
		_g_free0 (color_str);
		color_str = NULL;
	}
	if (shading_direction == G_DESKTOP_BACKGROUND_SHADING_SOLID) {
		MetaBackground* _tmp53_;
		ClutterColor* _tmp54_;
		ClutterColor _tmp55_;
		_tmp53_ = _data2_->background;
		_tmp54_ = primary_color;
		_tmp55_ = *_tmp54_;
		meta_background_set_color (_tmp53_, &_tmp55_);
	} else {
		MetaBackground* _tmp56_;
		ClutterColor* _tmp57_;
		ClutterColor* _tmp58_;
		ClutterColor _tmp59_;
		ClutterColor _tmp60_;
		_tmp56_ = _data2_->background;
		_tmp57_ = primary_color;
		_tmp58_ = secondary_color;
		_tmp59_ = *_tmp57_;
		_tmp60_ = *_tmp58_;
		meta_background_set_gradient (_tmp56_, shading_direction, &_tmp59_, &_tmp60_);
	}
	_tmp62_ = _data2_->bg_filename;
	if (!budgie_budgie_background_is_color_wallpaper (self, _tmp62_)) {
		const gchar* _tmp63_;
		_tmp63_ = _data2_->bg_filename;
		_tmp61_ = !g_str_has_suffix (_tmp63_, ".xml");
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		Block3Data* _data3_;
		const gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		GFile* _tmp67_;
		GFile* _tmp68_;
		const gchar* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		_data3_ = g_slice_new0 (Block3Data);
		_data3_->_ref_count_ = 1;
		_data3_->_data2_ = block2_data_ref (_data2_);
		_tmp64_ = _data2_->bg_filename;
		_tmp65_ = g_strconcat ("file://", _tmp64_, NULL);
		_tmp66_ = _tmp65_;
		_tmp67_ = g_file_new_for_uri (_tmp66_);
		_tmp68_ = _tmp67_;
		_g_free0 (_tmp66_);
		_data3_->bg_file = _tmp68_;
		_tmp69_ = _data2_->bg_filename;
		_tmp70_ = g_strconcat ("file://", _tmp69_, NULL);
		_tmp71_ = _tmp70_;
		budgie_budgie_background_load_uri (self, _tmp71_, ____lambda23__gasync_ready_callback, block3_data_ref (_data3_));
		_g_free0 (_tmp71_);
		block3_data_unref (_data3_);
		_data3_ = NULL;
	} else {
		MetaBackground* _tmp72_;
		_tmp72_ = _data2_->background;
		g_signal_connect_object (_tmp72_, "changed", (GCallback) _budgie_budgie_background_on_update_meta_background_changed, self, 0);
	}
	_g_free0 (color_str);
	_g_object_unref0 (content);
	_g_object_unref0 (actor);
	__vala_ClutterColor_free0 (secondary_color);
	__vala_ClutterColor_free0 (primary_color);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

MetaDisplay*
budgie_budgie_background_get_display (BudgieBudgieBackground* self)
{
	MetaDisplay* result;
	MetaDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

void
budgie_budgie_background_set_display (BudgieBudgieBackground* self,
                                      MetaDisplay* value)
{
	MetaDisplay* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_budgie_background_get_display (self);
	if (old_value != value) {
		self->priv->_display = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_budgie_background_properties[BUDGIE_BUDGIE_BACKGROUND_DISPLAY_PROPERTY]);
	}
}

gint
budgie_budgie_background_get_index (BudgieBudgieBackground* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_index;
	return result;
}

void
budgie_budgie_background_set_index (BudgieBudgieBackground* self,
                                    gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_budgie_background_get_index (self);
	if (old_value != value) {
		self->priv->_index = value;
		g_object_notify_by_pspec ((GObject *) self, budgie_budgie_background_properties[BUDGIE_BUDGIE_BACKGROUND_INDEX_PROPERTY]);
	}
}

static void
budgie_budgie_background_class_init (BudgieBudgieBackgroundClass * klass,
                                     gpointer klass_data)
{
	budgie_budgie_background_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieBudgieBackground_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_budgie_background_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_budgie_background_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_budgie_background_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_BUDGIE_BACKGROUND_DISPLAY_PROPERTY, budgie_budgie_background_properties[BUDGIE_BUDGIE_BACKGROUND_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", meta_display_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_BUDGIE_BACKGROUND_INDEX_PROPERTY, budgie_budgie_background_properties[BUDGIE_BUDGIE_BACKGROUND_INDEX_PROPERTY] = g_param_spec_int ("index", "index", "index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
budgie_budgie_background_instance_init (BudgieBudgieBackground * self,
                                        gpointer klass)
{
	self->priv = budgie_budgie_background_get_instance_private (self);
	self->priv->settings = NULL;
	self->priv->bg = NULL;
	self->priv->old_bg = NULL;
	self->priv->cache = NULL;
	self->priv->wm = NULL;
	self->priv->images = NULL;
}

static void
budgie_budgie_background_finalize (GObject * obj)
{
	BudgieBudgieBackground * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_BUDGIE_BACKGROUND, BudgieBudgieBackground);
	_g_object_unref0 (self->priv->bg_group);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->bg);
	_g_object_unref0 (self->priv->old_bg);
	_g_object_unref0 (self->priv->cache);
	_g_object_unref0 (self->priv->gnome_bg);
	_g_hash_table_unref0 (self->priv->images);
	G_OBJECT_CLASS (budgie_budgie_background_parent_class)->finalize (obj);
}

static GType
budgie_budgie_background_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieBudgieBackgroundClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_budgie_background_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieBudgieBackground), 0, (GInstanceInitFunc) budgie_budgie_background_instance_init, NULL };
	GType budgie_budgie_background_type_id;
	budgie_budgie_background_type_id = g_type_register_static (clutter_actor_get_type (), "BudgieBudgieBackground", &g_define_type_info, 0);
	BudgieBudgieBackground_private_offset = g_type_add_instance_private (budgie_budgie_background_type_id, sizeof (BudgieBudgieBackgroundPrivate));
	return budgie_budgie_background_type_id;
}

GType
budgie_budgie_background_get_type (void)
{
	static volatile gsize budgie_budgie_background_type_id__once = 0;
	if (g_once_init_enter (&budgie_budgie_background_type_id__once)) {
		GType budgie_budgie_background_type_id;
		budgie_budgie_background_type_id = budgie_budgie_background_get_type_once ();
		g_once_init_leave (&budgie_budgie_background_type_id__once, budgie_budgie_background_type_id);
	}
	return budgie_budgie_background_type_id__once;
}

static void
_vala_budgie_budgie_background_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	BudgieBudgieBackground * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_BUDGIE_BACKGROUND, BudgieBudgieBackground);
	switch (property_id) {
		case BUDGIE_BUDGIE_BACKGROUND_DISPLAY_PROPERTY:
		g_value_set_object (value, budgie_budgie_background_get_display (self));
		break;
		case BUDGIE_BUDGIE_BACKGROUND_INDEX_PROPERTY:
		g_value_set_int (value, budgie_budgie_background_get_index (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_budgie_background_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	BudgieBudgieBackground * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_BUDGIE_BACKGROUND, BudgieBudgieBackground);
	switch (property_id) {
		case BUDGIE_BUDGIE_BACKGROUND_DISPLAY_PROPERTY:
		budgie_budgie_background_set_display (self, g_value_get_object (value));
		break;
		case BUDGIE_BUDGIE_BACKGROUND_INDEX_PROPERTY:
		budgie_budgie_background_set_index (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

