#!/bin/sh
# the next line restarts using tclsh \
exec tclsh "$0" "$@"

# Edit the path below to reflect installed Hamlib extension
lappend ::auto_path /usr/lib/tcl8.6/Hamlib

## Brute force loading
#load "/usr/lib/tcl8.6/Hamlib/hamlibtcl.so" Hamlib

## Preferred package loading
package require hamlib

set tclver [info tclversion]
puts "Tcl $tclver test, $hamlib_version\n"

#rig_set_debug $RIG_DEBUG_TRACE
rig_set_debug $RIG_DEBUG_NONE

# Init RIG_MODEL_DUMMY
Rig my_rig $RIG_MODEL_DUMMY

my_rig open
my_rig set_freq $RIG_VFO_A 145550000

puts "status:\t\t[my_rig cget -error_status]"

# get_mode returns a tuple
set moderes [my_rig get_mode]
set mode [rig_strrmode [lindex $moderes 0]]
puts "mode:\t\t$mode\nbandwidth:\t[lindex $moderes 1]Hz"

set state [my_rig cget -state]

# The following works well also

set rigcaps [my_rig cget -caps]
#set model [$rigcaps cget -model_name]
puts "Model:\t\t[$rigcaps cget -model_name]"
puts "Manufacturer:\t\t[$rigcaps cget -mfg_name]"
puts "Backend version:\t[$rigcaps cget -version]"
puts "Backend license:\t[$rigcaps cget -copyright]"
puts "Attenuators:\t[$rigcaps cget -attenuator]"

puts "getinfo:\t[my_rig get_info]"

my_rig set_level "VOXDELAY"  1
puts "status:\t\t[my_rig cget -error_status]"
puts "VOX delay:\t[my_rig get_level_i 'VOXDELAY']"
puts "status:\t\t[my_rig cget -error_status]"
my_rig set_level $RIG_LEVEL_VOXDELAY 5
puts "status:\t\t[my_rig cget -error_status]"
puts "VOX delay:\t[my_rig get_level_i $RIG_LEVEL_VOXDELAY]"
puts "status:\t\t[my_rig cget -error_status]"

puts "strength:\t[my_rig get_level_i $RIG_LEVEL_STRENGTH]"
puts "status:\t\t[my_rig cget -error_status]"
puts "status(str):\t[rigerror [my_rig cget -error_status]]"

puts "\nSending Morse, '73'"
my_rig send_morse $RIG_VFO_A "73"

my_rig close
#my_rig cleanup


exit 0
