/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.osmand.IProgress;
import net.osmand.PlatformUtil;
import org.apache.commons.logging.Log;

public class Algorithms {
    private static final int BUFFER_SIZE = 1024;
    private static final Log log = PlatformUtil.getLog(Algorithms.class);
    private static final char CHAR_TOSPLIT = '\u0001';

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static boolean stringsEqual(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null) {
            return false;
        }
        if (s2 == null) {
            return false;
        }
        return s2.equals(s1);
    }

    public static long parseLongSilently(String input, long def) {
        if (input != null && input.length() > 0) {
            try {
                return Long.parseLong(input);
            }
            catch (NumberFormatException e) {
                return def;
            }
        }
        return def;
    }

    public static String getFileNameWithoutExtension(File f) {
        String name = f.getName();
        int i = name.indexOf(46);
        if (i >= 0) {
            name = name.substring(0, i);
        }
        return name;
    }

    public static File[] getSortedFilesVersions(File dir) {
        File[] listFiles = dir.listFiles();
        if (listFiles != null) {
            Arrays.sort(listFiles, Algorithms.getFileVersionComparator());
        }
        return listFiles;
    }

    public static Comparator<File> getFileVersionComparator() {
        return new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return -this.simplifyFileName(o1.getName()).compareTo(this.simplifyFileName(o2.getName()));
            }

            public String simplifyFileName(String fn) {
                String lc = fn.toLowerCase();
                if (lc.indexOf(".") != -1) {
                    lc = lc.substring(0, lc.indexOf("."));
                }
                if (lc.endsWith("_2")) {
                    lc = lc.substring(0, lc.length() - "_2".length());
                }
                boolean hasTimestampEnd = false;
                for (int i = 0; i < lc.length(); ++i) {
                    if (lc.charAt(i) < '0' || lc.charAt(i) > '9') continue;
                    hasTimestampEnd = true;
                    break;
                }
                if (!hasTimestampEnd) {
                    lc = lc + "_00_00_00";
                }
                return lc;
            }
        };
    }

    public static Map<String, String> decodeMap(String s) {
        if (Algorithms.isEmpty(s)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> names = new HashMap<String, String>();
        String[] split = s.split("\u0001");
        for (int i = 1; i < split.length; i += 2) {
            names.put(split[i - 1], split[i]);
        }
        return names;
    }

    public static String encodeMap(Map<String, String> names) {
        if (names != null) {
            Iterator<Map.Entry<String, String>> it = names.entrySet().iterator();
            StringBuilder bld = new StringBuilder();
            while (it.hasNext()) {
                Map.Entry<String, String> e = it.next();
                bld.append(e.getKey()).append('\u0001').append(e.getValue().replace('\u0001', '\u0002'));
                bld.append('\u0001');
            }
            return bld.toString();
        }
        return "";
    }

    public static int findFirstNumberEndIndex(String value) {
        int i = 0;
        boolean valid = false;
        if (value.length() > 0 && value.charAt(0) == '-') {
            ++i;
        }
        while (i < value.length() && (Algorithms.isDigit(value.charAt(i)) || value.charAt(i) == '.')) {
            ++i;
            valid = true;
        }
        if (valid) {
            return i;
        }
        return -1;
    }

    public static boolean isDigit(char charAt) {
        return charAt >= '0' && charAt <= '9';
    }

    public static boolean isZipFile(File file) throws IOException {
        if (file.isDirectory()) {
            return false;
        }
        if (!file.canRead()) {
            throw new IOException("Cannot read file " + file.getAbsolutePath());
        }
        if (file.length() < 4L) {
            return false;
        }
        FileInputStream in = new FileInputStream(file);
        int test = Algorithms.readInt(in);
        in.close();
        return test == 1347093252;
    }

    private static final int readInt(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    public static String capitalizeFirstLetterAndLowercase(String s) {
        if (s != null && s.length() > 1) {
            return Character.toUpperCase(s.charAt(0)) + s.substring(1).toLowerCase();
        }
        return s;
    }

    public static boolean objectEquals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static int parseColor(String colorString) {
        if (colorString.charAt(0) == '#') {
            if (colorString.length() == 4) {
                colorString = "#" + colorString.charAt(1) + colorString.charAt(1) + colorString.charAt(2) + colorString.charAt(2) + colorString.charAt(3) + colorString.charAt(3);
            }
            long color2 = Long.parseLong(colorString.substring(1), 16);
            if (colorString.length() == 7) {
                color2 |= 0xFFFFFFFFFF000000L;
            } else if (colorString.length() != 9) {
                throw new IllegalArgumentException("Unknown color " + colorString);
            }
            return (int)color2;
        }
        throw new IllegalArgumentException("Unknown color " + colorString);
    }

    public static int extractFirstIntegerNumber(String s) {
        int i = 0;
        for (int k = 0; k < s.length() && Algorithms.isDigit(s.charAt(k)); ++k) {
            i = i * 10 + (s.charAt(k) - 48);
        }
        return i;
    }

    public static int extractIntegerNumber(String s) {
        int i = 0;
        int k = 0;
        for (k = 0; k < s.length() && !Algorithms.isDigit(s.charAt(k)); ++k) {
        }
        while (k < s.length() && Algorithms.isDigit(s.charAt(k))) {
            i = i * 10 + (s.charAt(k) - 48);
            ++k;
        }
        return i;
    }

    public static String extractIntegerPrefix(String s) {
        for (int k = 0; k < s.length(); ++k) {
            if (!Character.isDigit(s.charAt(k))) continue;
            return s.substring(0, k);
        }
        return "";
    }

    public static String extractOnlyIntegerSuffix(String s) {
        for (int k = 0; k < s.length(); ++k) {
            if (!Character.isDigit(s.charAt(k))) continue;
            return s.substring(k);
        }
        return "";
    }

    public static String extractIntegerSuffix(String s) {
        for (int k = 0; k < s.length(); ++k) {
            if (Character.isDigit(s.charAt(k))) continue;
            return s.substring(k);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileCopy(File src, File dst) throws IOException {
        try (FileOutputStream fout = new FileOutputStream(dst);
             FileInputStream fin = new FileInputStream(src);){
            Algorithms.streamCopy(fin, fout);
        }
    }

    public static void streamCopy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] b = new byte[1024];
        while ((read = in.read(b)) != -1) {
            out.write(b, 0, read);
        }
    }

    public static void streamCopy(InputStream in, OutputStream out, IProgress pg, int bytesDivisor) throws IOException {
        int read;
        byte[] b = new byte[1024];
        int cp = 0;
        while ((read = in.read(b)) != -1) {
            out.write(b, 0, read);
            if (pg == null || (cp += read) <= bytesDivisor) continue;
            pg.progress(cp / bytesDivisor);
            cp %= bytesDivisor;
        }
    }

    public static void oneByteStreamCopy(InputStream in, OutputStream out) throws IOException {
        int read;
        while ((read = in.read()) != -1) {
            out.write(read);
        }
    }

    public static void closeStream(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            log.warn((Object)"Closing stream warn", (Throwable)e);
        }
    }

    public static void updateAllExistingImgTilesToOsmandFormat(File f) {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                Algorithms.updateAllExistingImgTilesToOsmandFormat(c);
            }
        } else if (f.getName().endsWith(".png") || f.getName().endsWith(".jpg")) {
            f.renameTo(new File(f.getAbsolutePath() + ".tile"));
        } else if (f.getName().endsWith(".andnav2")) {
            f.renameTo(new File(f.getAbsolutePath().substring(0, f.getAbsolutePath().length() - ".andnav2".length()) + ".tile"));
        }
    }

    public static StringBuilder readFromInputStream(InputStream i) throws IOException {
        StringBuilder responseBody = new StringBuilder();
        responseBody.setLength(0);
        if (i != null) {
            String s;
            BufferedReader in = new BufferedReader(new InputStreamReader(i, "UTF-8"), 256);
            boolean f = true;
            while ((s = in.readLine()) != null) {
                if (!f) {
                    responseBody.append("\n");
                } else {
                    f = false;
                }
                responseBody.append(s);
            }
        }
        return responseBody;
    }

    public static boolean removeAllFiles(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            File[] fs = f.listFiles();
            if (fs != null) {
                for (File c : fs) {
                    Algorithms.removeAllFiles(c);
                }
            }
            return f.delete();
        }
        return f.delete();
    }

    public static long parseLongFromBytes(byte[] bytes, int offset) {
        long o = 0xFF & bytes[offset + 7];
        o = o << 8 | (long)(0xFF & bytes[offset + 6]);
        o = o << 8 | (long)(0xFF & bytes[offset + 5]);
        o = o << 8 | (long)(0xFF & bytes[offset + 4]);
        o = o << 8 | (long)(0xFF & bytes[offset + 3]);
        o = o << 8 | (long)(0xFF & bytes[offset + 2]);
        o = o << 8 | (long)(0xFF & bytes[offset + 1]);
        o = o << 8 | (long)(0xFF & bytes[offset]);
        return o;
    }

    public static void putLongToBytes(byte[] bytes, int offset, long l) {
        bytes[offset] = (byte)(l & 0xFFL);
        bytes[offset + 1] = (byte)((l >>= 8) & 0xFFL);
        bytes[offset + 2] = (byte)((l >>= 8) & 0xFFL);
        bytes[offset + 3] = (byte)((l >>= 8) & 0xFFL);
        bytes[offset + 4] = (byte)((l >>= 8) & 0xFFL);
        bytes[offset + 5] = (byte)((l >>= 8) & 0xFFL);
        bytes[offset + 6] = (byte)((l >>= 8) & 0xFFL);
        bytes[offset + 7] = (byte)((l >>= 8) & 0xFFL);
    }

    public static int parseIntFromBytes(byte[] bytes, int offset) {
        int o = (0xFF & bytes[offset + 3]) << 24;
        o |= (0xFF & bytes[offset + 2]) << 16;
        o |= (0xFF & bytes[offset + 1]) << 8;
        return o |= 0xFF & bytes[offset];
    }

    public static void putIntToBytes(byte[] bytes, int offset, int l) {
        bytes[offset] = (byte)(l & 0xFF);
        bytes[offset + 1] = (byte)((l >>= 8) & 0xFF);
        bytes[offset + 2] = (byte)((l >>= 8) & 0xFF);
        bytes[offset + 3] = (byte)((l >>= 8) & 0xFF);
    }

    public static void writeLongInt(OutputStream stream, long l) throws IOException {
        stream.write((int)(l & 0xFFL));
        stream.write((int)((l >>= 8) & 0xFFL));
        stream.write((int)((l >>= 8) & 0xFFL));
        stream.write((int)((l >>= 8) & 0xFFL));
        stream.write((int)((l >>= 8) & 0xFFL));
        stream.write((int)((l >>= 8) & 0xFFL));
        stream.write((int)((l >>= 8) & 0xFFL));
        stream.write((int)((l >>= 8) & 0xFFL));
    }

    public static void writeInt(OutputStream stream, int l) throws IOException {
        stream.write(l & 0xFF);
        stream.write((l >>= 8) & 0xFF);
        stream.write((l >>= 8) & 0xFF);
        stream.write((l >>= 8) & 0xFF);
    }

    public static void writeSmallInt(OutputStream stream, int l) throws IOException {
        stream.write(l & 0xFF);
        stream.write((l >>= 8) & 0xFF);
        l >>= 8;
    }

    public static int parseSmallIntFromBytes(byte[] bytes, int offset) {
        int s = (0xFF & bytes[offset + 1]) << 8;
        return s |= 0xFF & bytes[offset];
    }

    public static void putSmallIntBytes(byte[] bytes, int offset, int s) {
        bytes[offset] = (byte)(s & 0xFF);
        bytes[offset + 1] = (byte)((s >>= 8) & 0xFF);
        s >>= 8;
    }

    public static boolean containsDigit(String name) {
        for (int i = 0; i < name.length(); ++i) {
            if (!Character.isDigit(name.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String formatDuration(int seconds) {
        String sec = seconds % 60 < 10 ? "0" + seconds % 60 : seconds % 60 + "";
        int minutes = seconds / 60;
        if (minutes < 60) {
            return minutes + ":" + sec;
        }
        String min = minutes % 60 < 10 ? "0" + minutes % 60 : minutes % 60 + "";
        int hours = minutes / 60;
        return hours + ":" + min + ":" + sec;
    }

    public static String formatMinutesDuration(int minutes) {
        if (minutes < 60) {
            return String.valueOf(minutes);
        }
        int min = minutes % 60;
        int hours = minutes / 60;
        return String.format("%02d:%02d", hours, min);
    }

    public static <T extends Enum<T>> T parseEnumValue(T[] cl, String val, T defaultValue) {
        for (int i = 0; i < cl.length; ++i) {
            if (!((Enum)cl[i]).name().equalsIgnoreCase(val)) continue;
            return cl[i];
        }
        return defaultValue;
    }

    public static String colorToString(int color2) {
        if ((0xFF000000 & color2) == -16777216) {
            return "#" + Algorithms.format(6, Integer.toHexString(color2 & 0xFFFFFF));
        }
        return "#" + Algorithms.format(8, Integer.toHexString(color2));
    }

    private static String format(int i, String hexString) {
        while (hexString.length() < i) {
            hexString = "0" + hexString;
        }
        return hexString;
    }
}

