/* WallpaperContainer.c generated by valac 0.56.3, the Vala compiler
 * generated from WallpaperContainer.vala, do not modify */

/*-
 * Copyright 2015-2022 elementary, Inc. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Erasmo Marín
 *
 */

#include "pantheon-desktop.h"
#include <gtk/gtk.h>
#include <granite.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gexiv2/gexiv2.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#define PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_WIDTH 162
#define PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_HEIGHT 100

enum  {
	PANTHEON_SHELL_WALLPAPER_CONTAINER_0_PROPERTY,
	PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_PATH_PROPERTY,
	PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_VALID_PROPERTY,
	PANTHEON_SHELL_WALLPAPER_CONTAINER_URI_PROPERTY,
	PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_PROPERTY,
	PANTHEON_SHELL_WALLPAPER_CONTAINER_CHECKED_PROPERTY,
	PANTHEON_SHELL_WALLPAPER_CONTAINER_SELECTED_PROPERTY,
	PANTHEON_SHELL_WALLPAPER_CONTAINER_NUM_PROPERTIES
};
static GParamSpec* pantheon_shell_wallpaper_container_properties[PANTHEON_SHELL_WALLPAPER_CONTAINER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _pantheon_shell_thumbnail_generator_unref0(var) ((var == NULL) ? NULL : (var = (pantheon_shell_thumbnail_generator_unref (var), NULL)))
typedef struct _PantheonShellWallpaperContainerUpdateThumbData PantheonShellWallpaperContainerUpdateThumbData;
enum  {
	PANTHEON_SHELL_WALLPAPER_CONTAINER_TRASH_SIGNAL,
	PANTHEON_SHELL_WALLPAPER_CONTAINER_NUM_SIGNALS
};
static guint pantheon_shell_wallpaper_container_signals[PANTHEON_SHELL_WALLPAPER_CONTAINER_NUM_SIGNALS] = {0};

struct _PantheonShellWallpaperContainerPrivate {
	GtkGrid* card_box;
	GtkMenu* context_menu;
	GtkRevealer* check_revealer;
	GraniteAsyncImage* image;
	gchar* _thumb_path;
	gboolean _thumb_valid;
	gchar* _uri;
	GdkPixbuf* _thumb;
	gint scale;
};

struct _PantheonShellWallpaperContainerUpdateThumbData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	PantheonShellWallpaperContainer* self;
	const gchar* _tmp0_;
	GraniteAsyncImage* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GError* e;
	GError* _tmp5_;
	const gchar* _tmp6_;
	GError* _inner_error0_;
};

static gint PantheonShellWallpaperContainer_private_offset;
static gpointer pantheon_shell_wallpaper_container_parent_class = NULL;

static void pantheon_shell_wallpaper_container_generate_and_load_thumb (PantheonShellWallpaperContainer* self);
static void __lambda6_ (PantheonShellWallpaperContainer* self);
static void pantheon_shell_wallpaper_container_update_thumb (PantheonShellWallpaperContainer* self,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static void pantheon_shell_wallpaper_container_update_thumb_finish (PantheonShellWallpaperContainer* self,
                                                             GAsyncResult* _res_);
static void ___lambda6__pantheon_shell_thumbnail_generator_thumbnail_ready (gpointer self);
static void pantheon_shell_wallpaper_container_load_artist_tooltip (PantheonShellWallpaperContainer* self);
static gboolean pantheon_shell_wallpaper_container_show_context_menu (PantheonShellWallpaperContainer* self,
                                                               GtkWidget* sender,
                                                               GdkEventButton* evt);
static void pantheon_shell_wallpaper_container_update_thumb_data_free (gpointer _data);
static gboolean pantheon_shell_wallpaper_container_update_thumb_co (PantheonShellWallpaperContainerUpdateThumbData* _data_);
static void pantheon_shell_wallpaper_container_update_thumb_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_);
static GObject * pantheon_shell_wallpaper_container_constructor (GType type,
                                                          guint n_construct_properties,
                                                          GObjectConstructParam * construct_properties);
static void _pantheon_shell_wallpaper_container____lambda7_ (PantheonShellWallpaperContainer* self);
static void __pantheon_shell_wallpaper_container____lambda7__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                              gpointer self);
static void _pantheon_shell_wallpaper_container___lambda8_ (PantheonShellWallpaperContainer* self);
static void __pantheon_shell_wallpaper_container___lambda8__gtk_flow_box_child_activate (GtkFlowBoxChild* _sender,
                                                                                  gpointer self);
static gboolean _pantheon_shell_wallpaper_container_show_context_menu_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                              GdkEventButton* event,
                                                                                              gpointer self);
static void pantheon_shell_wallpaper_container_finalize (GObject * obj);
static GType pantheon_shell_wallpaper_container_get_type_once (void);
static void _vala_pantheon_shell_wallpaper_container_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
static void _vala_pantheon_shell_wallpaper_container_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec);

static inline gpointer
pantheon_shell_wallpaper_container_get_instance_private (PantheonShellWallpaperContainer* self)
{
	return G_STRUCT_MEMBER_P (self, PantheonShellWallpaperContainer_private_offset);
}

PantheonShellWallpaperContainer*
pantheon_shell_wallpaper_container_construct (GType object_type,
                                              const gchar* uri,
                                              const gchar* thumb_path,
                                              gboolean thumb_valid)
{
	PantheonShellWallpaperContainer * self = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	self = (PantheonShellWallpaperContainer*) g_object_new (object_type, "uri", uri, "thumb-path", thumb_path, "thumb-valid", thumb_valid, NULL);
	return self;
}

PantheonShellWallpaperContainer*
pantheon_shell_wallpaper_container_new (const gchar* uri,
                                        const gchar* thumb_path,
                                        gboolean thumb_valid)
{
	return pantheon_shell_wallpaper_container_construct (PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, uri, thumb_path, thumb_valid);
}

static void
__lambda6_ (PantheonShellWallpaperContainer* self)
{
	GError* _inner_error0_ = NULL;
	{
		GFile* file = NULL;
		const gchar* _tmp0_;
		GFile* _tmp1_;
		GFileInfo* info = NULL;
		GFileInfo* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = self->priv->_uri;
		_tmp1_ = g_file_new_for_uri (_tmp0_);
		file = _tmp1_;
		_tmp2_ = g_file_query_info (file, G_FILE_ATTRIBUTE_THUMBNAIL_PATH "," G_FILE_ATTRIBUTE_THUMBNAIL_IS_VALID, 0, NULL, &_inner_error0_);
		info = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			goto __catch0_g_error;
		}
		_tmp3_ = g_file_info_get_attribute_as_string (info, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
		_tmp4_ = _tmp3_;
		pantheon_shell_wallpaper_container_set_thumb_path (self, _tmp4_);
		_g_free0 (_tmp4_);
		pantheon_shell_wallpaper_container_update_thumb (self, NULL, NULL);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = self->priv->_uri;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("WallpaperContainer.vala:169: Error loading thumbnail for '%s': %s", _tmp5_, _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda6__pantheon_shell_thumbnail_generator_thumbnail_ready (gpointer self)
{
	__lambda6_ ((PantheonShellWallpaperContainer*) self);
}

static void
pantheon_shell_wallpaper_container_generate_and_load_thumb (PantheonShellWallpaperContainer* self)
{
	PantheonShellThumbnailGenerator* _tmp0_;
	PantheonShellThumbnailGenerator* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = pantheon_shell_thumbnail_generator_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_uri;
	pantheon_shell_thumbnail_generator_get_thumbnail (_tmp1_, _tmp2_, (guint) (PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_WIDTH * self->priv->scale), ___lambda6__pantheon_shell_thumbnail_generator_thumbnail_ready, self);
	_pantheon_shell_thumbnail_generator_unref0 (_tmp1_);
}

static void
pantheon_shell_wallpaper_container_load_artist_tooltip (PantheonShellWallpaperContainer* self)
{
	const gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_uri;
	if (_tmp0_ != NULL) {
		gchar* path = NULL;
		gchar* _tmp1_;
		GExiv2Metadata* metadata = NULL;
		GExiv2Metadata* _tmp12_;
		_tmp1_ = g_strdup ("");
		path = _tmp1_;
		{
			gchar* _tmp2_ = NULL;
			const gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			GExiv2Metadata* _tmp6_;
			GExiv2Metadata* _tmp7_;
			const gchar* _tmp8_;
			_tmp3_ = self->priv->_uri;
			_tmp4_ = g_filename_from_uri (_tmp3_, NULL, &_inner_error0_);
			_tmp2_ = _tmp4_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp5_ = _tmp2_;
			_tmp2_ = NULL;
			_g_free0 (path);
			path = _tmp5_;
			_tmp6_ = gexiv2_metadata_new ();
			_g_object_unref0 (metadata);
			metadata = _tmp6_;
			_tmp7_ = metadata;
			_tmp8_ = path;
			gexiv2_metadata_open_path (_tmp7_, _tmp8_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (_tmp2_);
				goto __catch0_g_error;
			}
			_g_free0 (_tmp2_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp9_;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = path;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			g_warning ("WallpaperContainer.vala:183: Error parsing exif metadata of \"%s\": %s", _tmp9_, _tmp11_);
			_g_error_free0 (e);
			_g_object_unref0 (metadata);
			_g_free0 (path);
			return;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (metadata);
			_g_free0 (path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp12_ = metadata;
		if (gexiv2_metadata_has_exif (_tmp12_)) {
			gchar* artist_name = NULL;
			GExiv2Metadata* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp13_ = metadata;
			_tmp14_ = gexiv2_metadata_get_tag_string (_tmp13_, "Exif.Image.Artist");
			artist_name = _tmp14_;
			_tmp15_ = artist_name;
			if (_tmp15_ != NULL) {
				const gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp16_ = artist_name;
				_tmp17_ = g_strdup_printf (_ ("Artist: %s"), _tmp16_);
				_tmp18_ = _tmp17_;
				gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp18_);
				_g_free0 (_tmp18_);
			}
			_g_free0 (artist_name);
		}
		_g_object_unref0 (metadata);
		_g_free0 (path);
	}
}

static gboolean
pantheon_shell_wallpaper_container_show_context_menu (PantheonShellWallpaperContainer* self,
                                                      GtkWidget* sender,
                                                      GdkEventButton* evt)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	if (evt->type == GDK_BUTTON_PRESS) {
		_tmp0_ = evt->button == ((guint) 3);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkMenu* _tmp1_;
		_tmp1_ = self->priv->context_menu;
		gtk_menu_popup_at_pointer (_tmp1_, NULL);
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static void
pantheon_shell_wallpaper_container_update_thumb_data_free (gpointer _data)
{
	PantheonShellWallpaperContainerUpdateThumbData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (PantheonShellWallpaperContainerUpdateThumbData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
pantheon_shell_wallpaper_container_update_thumb (PantheonShellWallpaperContainer* self,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	PantheonShellWallpaperContainerUpdateThumbData* _data_;
	PantheonShellWallpaperContainer* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (PantheonShellWallpaperContainerUpdateThumbData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, pantheon_shell_wallpaper_container_update_thumb_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	pantheon_shell_wallpaper_container_update_thumb_co (_data_);
}

static void
pantheon_shell_wallpaper_container_update_thumb_finish (PantheonShellWallpaperContainer* self,
                                                        GAsyncResult* _res_)
{
	PantheonShellWallpaperContainerUpdateThumbData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
pantheon_shell_wallpaper_container_update_thumb_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_)
{
	PantheonShellWallpaperContainerUpdateThumbData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	pantheon_shell_wallpaper_container_update_thumb_co (_data_);
}

static gboolean
pantheon_shell_wallpaper_container_update_thumb_co (PantheonShellWallpaperContainerUpdateThumbData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_thumb_path;
	if (_data_->_tmp0_ == NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp1_ = _data_->self->priv->image;
		_data_->_tmp2_ = _data_->self->priv->_thumb_path;
		_data_->_tmp3_ = g_file_new_for_path (_data_->_tmp2_);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_state_ = 1;
		granite_async_image_set_from_file_async (_data_->_tmp1_, _data_->_tmp4_, PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_WIDTH, PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_HEIGHT, FALSE, NULL, pantheon_shell_wallpaper_container_update_thumb_ready, _data_);
		return FALSE;
		_state_1:
		granite_async_image_set_from_file_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		_g_object_unref0 (_data_->_tmp4_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp5_ = _data_->e;
		_data_->_tmp6_ = _data_->_tmp5_->message;
		g_warning ("WallpaperContainer.vala:212: %s", _data_->_tmp6_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	pantheon_shell_wallpaper_container_load_artist_tooltip (_data_->self);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

const gchar*
pantheon_shell_wallpaper_container_get_thumb_path (PantheonShellWallpaperContainer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_thumb_path;
	result = _tmp0_;
	return result;
}

void
pantheon_shell_wallpaper_container_set_thumb_path (PantheonShellWallpaperContainer* self,
                                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pantheon_shell_wallpaper_container_get_thumb_path (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_thumb_path);
		self->priv->_thumb_path = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pantheon_shell_wallpaper_container_properties[PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_PATH_PROPERTY]);
	}
}

gboolean
pantheon_shell_wallpaper_container_get_thumb_valid (PantheonShellWallpaperContainer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_thumb_valid;
	return result;
}

static void
pantheon_shell_wallpaper_container_set_thumb_valid (PantheonShellWallpaperContainer* self,
                                                    gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = pantheon_shell_wallpaper_container_get_thumb_valid (self);
	if (old_value != value) {
		self->priv->_thumb_valid = value;
		g_object_notify_by_pspec ((GObject *) self, pantheon_shell_wallpaper_container_properties[PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_VALID_PROPERTY]);
	}
}

const gchar*
pantheon_shell_wallpaper_container_get_uri (PantheonShellWallpaperContainer* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uri;
	result = _tmp0_;
	return result;
}

static void
pantheon_shell_wallpaper_container_set_uri (PantheonShellWallpaperContainer* self,
                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = pantheon_shell_wallpaper_container_get_uri (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uri);
		self->priv->_uri = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pantheon_shell_wallpaper_container_properties[PANTHEON_SHELL_WALLPAPER_CONTAINER_URI_PROPERTY]);
	}
}

GdkPixbuf*
pantheon_shell_wallpaper_container_get_thumb (PantheonShellWallpaperContainer* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_thumb;
	result = _tmp0_;
	return result;
}

void
pantheon_shell_wallpaper_container_set_thumb (PantheonShellWallpaperContainer* self,
                                              GdkPixbuf* value)
{
	GdkPixbuf* old_value;
	g_return_if_fail (self != NULL);
	old_value = pantheon_shell_wallpaper_container_get_thumb (self);
	if (old_value != value) {
		GdkPixbuf* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_thumb);
		self->priv->_thumb = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, pantheon_shell_wallpaper_container_properties[PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_PROPERTY]);
	}
}

gboolean
pantheon_shell_wallpaper_container_get_checked (PantheonShellWallpaperContainer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = (gtk_widget_get_state_flags ((GtkWidget*) self) & GTK_STATE_FLAG_CHECKED) == GTK_STATE_FLAG_CHECKED;
	return result;
}

void
pantheon_shell_wallpaper_container_set_checked (PantheonShellWallpaperContainer* self,
                                                gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value) {
		GtkGrid* _tmp0_;
		GtkRevealer* _tmp1_;
		_tmp0_ = self->priv->card_box;
		gtk_widget_set_state_flags ((GtkWidget*) _tmp0_, GTK_STATE_FLAG_CHECKED, FALSE);
		_tmp1_ = self->priv->check_revealer;
		gtk_revealer_set_reveal_child (_tmp1_, TRUE);
	} else {
		GtkGrid* _tmp2_;
		GtkRevealer* _tmp3_;
		_tmp2_ = self->priv->card_box;
		gtk_widget_unset_state_flags ((GtkWidget*) _tmp2_, GTK_STATE_FLAG_CHECKED);
		_tmp3_ = self->priv->check_revealer;
		gtk_revealer_set_reveal_child (_tmp3_, FALSE);
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, pantheon_shell_wallpaper_container_properties[PANTHEON_SHELL_WALLPAPER_CONTAINER_CHECKED_PROPERTY]);
}

gboolean
pantheon_shell_wallpaper_container_get_selected (PantheonShellWallpaperContainer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = (gtk_widget_get_state_flags ((GtkWidget*) self) & GTK_STATE_FLAG_SELECTED) == GTK_STATE_FLAG_SELECTED;
	return result;
}

void
pantheon_shell_wallpaper_container_set_selected (PantheonShellWallpaperContainer* self,
                                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value) {
		gtk_widget_set_state_flags ((GtkWidget*) self, GTK_STATE_FLAG_SELECTED, FALSE);
	} else {
		gtk_widget_unset_state_flags ((GtkWidget*) self, GTK_STATE_FLAG_SELECTED);
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, pantheon_shell_wallpaper_container_properties[PANTHEON_SHELL_WALLPAPER_CONTAINER_SELECTED_PROPERTY]);
}

static void
_pantheon_shell_wallpaper_container____lambda7_ (PantheonShellWallpaperContainer* self)
{
	g_signal_emit (self, pantheon_shell_wallpaper_container_signals[PANTHEON_SHELL_WALLPAPER_CONTAINER_TRASH_SIGNAL], 0);
}

static void
__pantheon_shell_wallpaper_container____lambda7__gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                         gpointer self)
{
	_pantheon_shell_wallpaper_container____lambda7_ ((PantheonShellWallpaperContainer*) self);
}

static void
_pantheon_shell_wallpaper_container___lambda8_ (PantheonShellWallpaperContainer* self)
{
	pantheon_shell_wallpaper_container_set_checked (self, TRUE);
}

static void
__pantheon_shell_wallpaper_container___lambda8__gtk_flow_box_child_activate (GtkFlowBoxChild* _sender,
                                                                             gpointer self)
{
	_pantheon_shell_wallpaper_container___lambda8_ ((PantheonShellWallpaperContainer*) self);
}

static gboolean
_pantheon_shell_wallpaper_container_show_context_menu_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                     GdkEventButton* event,
                                                                                     gpointer self)
{
	gboolean result;
	result = pantheon_shell_wallpaper_container_show_context_menu ((PantheonShellWallpaperContainer*) self, _sender, event);
	return result;
}

static GObject *
pantheon_shell_wallpaper_container_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PantheonShellWallpaperContainer * self;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	GraniteAsyncImage* _tmp4_;
	GraniteAsyncImage* _tmp5_;
	GraniteAsyncImage* _tmp6_;
	GraniteAsyncImage* _tmp7_;
	GtkStyleContext* _tmp8_;
	GtkGrid* _tmp9_;
	GtkGrid* _tmp10_;
	GtkStyleContext* _tmp11_;
	GtkGrid* _tmp12_;
	GraniteAsyncImage* _tmp13_;
	GtkGrid* _tmp14_;
	GtkCssProvider* check_provider = NULL;
	GtkCssProvider* _tmp15_;
	GtkCssProvider* _tmp16_;
	GtkRadioButton* check = NULL;
	GtkRadioButton* _tmp17_ = NULL;
	GtkRadioButton* _tmp18_;
	GtkStyleContext* _tmp19_;
	GtkCssProvider* _tmp20_;
	GtkRevealer* _tmp21_;
	GtkRevealer* _tmp22_;
	GtkRevealer* _tmp23_;
	GtkRadioButton* _tmp24_;
	GtkOverlay* overlay = NULL;
	GtkOverlay* _tmp25_;
	GtkOverlay* _tmp26_;
	GtkGrid* _tmp27_;
	GtkOverlay* _tmp28_;
	GtkRevealer* _tmp29_;
	GtkEventBox* event_box = NULL;
	GtkEventBox* _tmp30_;
	GtkEventBox* _tmp31_;
	GtkOverlay* _tmp32_;
	GtkEventBox* _tmp33_;
	const gchar* _tmp34_;
	GtkEventBox* _tmp50_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (pantheon_shell_wallpaper_container_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, PantheonShellWallpaperContainer);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	style_context = _tmp1_;
	_tmp2_ = style_context;
	gtk_style_context_add_class (_tmp2_, "wallpaper-container");
	_tmp3_ = style_context;
	self->priv->scale = gtk_style_context_get_scale (_tmp3_);
	g_object_set ((GtkWidget*) self, "height-request", PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_HEIGHT + 18, NULL);
	g_object_set ((GtkWidget*) self, "width-request", PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_WIDTH + 18, NULL);
	_tmp4_ = granite_async_image_new (TRUE, TRUE);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->image);
	self->priv->image = _tmp4_;
	_tmp5_ = self->priv->image;
	gtk_widget_set_halign ((GtkWidget*) _tmp5_, GTK_ALIGN_CENTER);
	_tmp6_ = self->priv->image;
	gtk_widget_set_valign ((GtkWidget*) _tmp6_, GTK_ALIGN_CENTER);
	_tmp7_ = self->priv->image;
	_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
	gtk_style_context_set_scale (_tmp8_, 1);
	_tmp9_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->card_box);
	self->priv->card_box = _tmp9_;
	_tmp10_ = self->priv->card_box;
	_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) _tmp10_);
	gtk_style_context_add_class (_tmp11_, "card");
	_tmp12_ = self->priv->card_box;
	_tmp13_ = self->priv->image;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->card_box;
	g_object_set ((GtkWidget*) _tmp14_, "margin", 9, NULL);
	_tmp15_ = gtk_css_provider_new ();
	check_provider = _tmp15_;
	_tmp16_ = check_provider;
	gtk_css_provider_load_from_resource (_tmp16_, "/io/elementary/switchboard/plug/pantheon-shell/Check.css");
	_tmp17_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	gtk_widget_set_halign ((GtkWidget*) _tmp17_, GTK_ALIGN_START);
	gtk_widget_set_valign ((GtkWidget*) _tmp17_, GTK_ALIGN_START);
	gtk_widget_set_can_focus ((GtkWidget*) _tmp17_, FALSE);
	g_object_ref_sink (_tmp17_);
	check = _tmp17_;
	_tmp18_ = check;
	_tmp19_ = gtk_widget_get_style_context ((GtkWidget*) _tmp18_);
	_tmp20_ = check_provider;
	gtk_style_context_add_provider (_tmp19_, (GtkStyleProvider*) _tmp20_, (guint) GTK_STYLE_PROVIDER_PRIORITY_USER);
	_tmp21_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp21_);
	_g_object_unref0 (self->priv->check_revealer);
	self->priv->check_revealer = _tmp21_;
	_tmp22_ = self->priv->check_revealer;
	gtk_revealer_set_transition_type (_tmp22_, GTK_REVEALER_TRANSITION_TYPE_CROSSFADE);
	_tmp23_ = self->priv->check_revealer;
	_tmp24_ = check;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp25_);
	overlay = _tmp25_;
	_tmp26_ = overlay;
	_tmp27_ = self->priv->card_box;
	gtk_container_add ((GtkContainer*) _tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = overlay;
	_tmp29_ = self->priv->check_revealer;
	gtk_overlay_add_overlay (_tmp28_, (GtkWidget*) _tmp29_);
	_tmp30_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp30_);
	event_box = _tmp30_;
	_tmp31_ = event_box;
	_tmp32_ = overlay;
	gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) _tmp32_);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	g_object_set ((GtkWidget*) self, "margin", 6, NULL);
	_tmp33_ = event_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp33_);
	_tmp34_ = self->priv->_uri;
	if (_tmp34_ != NULL) {
		GtkMenuItem* move_to_trash = NULL;
		GtkMenuItem* _tmp35_;
		GtkMenuItem* _tmp36_;
		GFile* file = NULL;
		const gchar* _tmp37_;
		GFile* _tmp38_;
		GtkMenu* _tmp46_;
		GtkMenu* _tmp47_;
		GtkMenuItem* _tmp48_;
		GtkMenu* _tmp49_;
		_tmp35_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Remove"));
		g_object_ref_sink (_tmp35_);
		move_to_trash = _tmp35_;
		_tmp36_ = move_to_trash;
		g_signal_connect_object (_tmp36_, "activate", (GCallback) __pantheon_shell_wallpaper_container____lambda7__gtk_menu_item_activate, self, 0);
		_tmp37_ = self->priv->_uri;
		_tmp38_ = g_file_new_for_uri (_tmp37_);
		file = _tmp38_;
		{
			GFileInfo* info = NULL;
			GFile* _tmp39_;
			GFileInfo* _tmp40_;
			GFileInfo* _tmp41_;
			GtkMenuItem* _tmp42_;
			GFileInfo* _tmp43_;
			_tmp39_ = file;
			_tmp40_ = g_file_query_info (_tmp39_, "*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
			info = _tmp40_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp41_ = info;
			self->creation_date = g_file_info_get_attribute_uint64 (_tmp41_, G_FILE_ATTRIBUTE_TIME_CREATED);
			_tmp42_ = move_to_trash;
			_tmp43_ = info;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp42_, g_file_info_get_attribute_boolean (_tmp43_, G_FILE_ATTRIBUTE_ACCESS_CAN_DELETE));
			_g_object_unref0 (info);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp44_;
			const gchar* _tmp45_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp44_ = e;
			_tmp45_ = _tmp44_->message;
			g_critical ("WallpaperContainer.vala:130: %s", _tmp45_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			_g_object_unref0 (move_to_trash);
			_g_object_unref0 (event_box);
			_g_object_unref0 (overlay);
			_g_object_unref0 (check);
			_g_object_unref0 (check_provider);
			_g_object_unref0 (style_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp46_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp46_);
		_g_object_unref0 (self->priv->context_menu);
		self->priv->context_menu = _tmp46_;
		_tmp47_ = self->priv->context_menu;
		_tmp48_ = move_to_trash;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp47_, _tmp48_);
		_tmp49_ = self->priv->context_menu;
		gtk_widget_show_all ((GtkWidget*) _tmp49_);
		_g_object_unref0 (file);
		_g_object_unref0 (move_to_trash);
	}
	g_signal_connect_object ((GtkFlowBoxChild*) self, "activate", (GCallback) __pantheon_shell_wallpaper_container___lambda8__gtk_flow_box_child_activate, self, 0);
	_tmp50_ = event_box;
	g_signal_connect_object ((GtkWidget*) _tmp50_, "button-press-event", (GCallback) _pantheon_shell_wallpaper_container_show_context_menu_gtk_widget_button_press_event, self, 0);
	{
		const gchar* _tmp51_;
		_tmp51_ = self->priv->_uri;
		if (_tmp51_ != NULL) {
			gboolean _tmp52_ = FALSE;
			const gchar* _tmp53_;
			_tmp53_ = self->priv->_thumb_path;
			if (_tmp53_ != NULL) {
				gboolean _tmp54_;
				_tmp54_ = self->priv->_thumb_valid;
				_tmp52_ = _tmp54_;
			} else {
				_tmp52_ = FALSE;
			}
			if (_tmp52_) {
				pantheon_shell_wallpaper_container_update_thumb (self, NULL, NULL);
			} else {
				pantheon_shell_wallpaper_container_generate_and_load_thumb (self);
			}
		} else {
			GdkPixbuf* _tmp55_;
			GdkPixbuf* _tmp56_;
			GraniteAsyncImage* _tmp57_;
			GdkPixbuf* _tmp58_;
			_tmp55_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_WIDTH * self->priv->scale, PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_HEIGHT * self->priv->scale);
			_tmp56_ = _tmp55_;
			pantheon_shell_wallpaper_container_set_thumb (self, _tmp56_);
			_g_object_unref0 (_tmp56_);
			_tmp57_ = self->priv->image;
			_tmp58_ = self->priv->_thumb;
			g_object_set ((GtkImage*) _tmp57_, "gicon", (GIcon*) _tmp58_, NULL);
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp59_;
		const gchar* _tmp60_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp59_ = e;
		_tmp60_ = _tmp59_->message;
		g_critical ("WallpaperContainer.vala:156: Failed to load wallpaper thumbnail: %s", _tmp60_);
		_g_error_free0 (e);
		_g_object_unref0 (event_box);
		_g_object_unref0 (overlay);
		_g_object_unref0 (check);
		_g_object_unref0 (check_provider);
		_g_object_unref0 (style_context);
		return obj;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (event_box);
		_g_object_unref0 (overlay);
		_g_object_unref0 (check);
		_g_object_unref0 (check_provider);
		_g_object_unref0 (style_context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_g_object_unref0 (event_box);
	_g_object_unref0 (overlay);
	_g_object_unref0 (check);
	_g_object_unref0 (check_provider);
	_g_object_unref0 (style_context);
	return obj;
}

static void
pantheon_shell_wallpaper_container_class_init (PantheonShellWallpaperContainerClass * klass,
                                               gpointer klass_data)
{
	pantheon_shell_wallpaper_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PantheonShellWallpaperContainer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_pantheon_shell_wallpaper_container_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_pantheon_shell_wallpaper_container_set_property;
	G_OBJECT_CLASS (klass)->constructor = pantheon_shell_wallpaper_container_constructor;
	G_OBJECT_CLASS (klass)->finalize = pantheon_shell_wallpaper_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_PATH_PROPERTY, pantheon_shell_wallpaper_container_properties[PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_PATH_PROPERTY] = g_param_spec_string ("thumb-path", "thumb-path", "thumb-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_VALID_PROPERTY, pantheon_shell_wallpaper_container_properties[PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_VALID_PROPERTY] = g_param_spec_boolean ("thumb-valid", "thumb-valid", "thumb-valid", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHEON_SHELL_WALLPAPER_CONTAINER_URI_PROPERTY, pantheon_shell_wallpaper_container_properties[PANTHEON_SHELL_WALLPAPER_CONTAINER_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_PROPERTY, pantheon_shell_wallpaper_container_properties[PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_PROPERTY] = g_param_spec_object ("thumb", "thumb", "thumb", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHEON_SHELL_WALLPAPER_CONTAINER_CHECKED_PROPERTY, pantheon_shell_wallpaper_container_properties[PANTHEON_SHELL_WALLPAPER_CONTAINER_CHECKED_PROPERTY] = g_param_spec_boolean ("checked", "checked", "checked", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PANTHEON_SHELL_WALLPAPER_CONTAINER_SELECTED_PROPERTY, pantheon_shell_wallpaper_container_properties[PANTHEON_SHELL_WALLPAPER_CONTAINER_SELECTED_PROPERTY] = g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	pantheon_shell_wallpaper_container_signals[PANTHEON_SHELL_WALLPAPER_CONTAINER_TRASH_SIGNAL] = g_signal_new ("trash", PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
pantheon_shell_wallpaper_container_instance_init (PantheonShellWallpaperContainer * self,
                                                  gpointer klass)
{
	self->priv = pantheon_shell_wallpaper_container_get_instance_private (self);
	self->creation_date = (guint64) 0;
}

static void
pantheon_shell_wallpaper_container_finalize (GObject * obj)
{
	PantheonShellWallpaperContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, PantheonShellWallpaperContainer);
	_g_object_unref0 (self->priv->card_box);
	_g_object_unref0 (self->priv->context_menu);
	_g_object_unref0 (self->priv->check_revealer);
	_g_object_unref0 (self->priv->image);
	_g_free0 (self->priv->_thumb_path);
	_g_free0 (self->priv->_uri);
	_g_object_unref0 (self->priv->_thumb);
	G_OBJECT_CLASS (pantheon_shell_wallpaper_container_parent_class)->finalize (obj);
}

static GType
pantheon_shell_wallpaper_container_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PantheonShellWallpaperContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_shell_wallpaper_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantheonShellWallpaperContainer), 0, (GInstanceInitFunc) pantheon_shell_wallpaper_container_instance_init, NULL };
	GType pantheon_shell_wallpaper_container_type_id;
	pantheon_shell_wallpaper_container_type_id = g_type_register_static (gtk_flow_box_child_get_type (), "PantheonShellWallpaperContainer", &g_define_type_info, 0);
	PantheonShellWallpaperContainer_private_offset = g_type_add_instance_private (pantheon_shell_wallpaper_container_type_id, sizeof (PantheonShellWallpaperContainerPrivate));
	return pantheon_shell_wallpaper_container_type_id;
}

GType
pantheon_shell_wallpaper_container_get_type (void)
{
	static volatile gsize pantheon_shell_wallpaper_container_type_id__once = 0;
	if (g_once_init_enter (&pantheon_shell_wallpaper_container_type_id__once)) {
		GType pantheon_shell_wallpaper_container_type_id;
		pantheon_shell_wallpaper_container_type_id = pantheon_shell_wallpaper_container_get_type_once ();
		g_once_init_leave (&pantheon_shell_wallpaper_container_type_id__once, pantheon_shell_wallpaper_container_type_id);
	}
	return pantheon_shell_wallpaper_container_type_id__once;
}

static void
_vala_pantheon_shell_wallpaper_container_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	PantheonShellWallpaperContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, PantheonShellWallpaperContainer);
	switch (property_id) {
		case PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_PATH_PROPERTY:
		g_value_set_string (value, pantheon_shell_wallpaper_container_get_thumb_path (self));
		break;
		case PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_VALID_PROPERTY:
		g_value_set_boolean (value, pantheon_shell_wallpaper_container_get_thumb_valid (self));
		break;
		case PANTHEON_SHELL_WALLPAPER_CONTAINER_URI_PROPERTY:
		g_value_set_string (value, pantheon_shell_wallpaper_container_get_uri (self));
		break;
		case PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_PROPERTY:
		g_value_set_object (value, pantheon_shell_wallpaper_container_get_thumb (self));
		break;
		case PANTHEON_SHELL_WALLPAPER_CONTAINER_CHECKED_PROPERTY:
		g_value_set_boolean (value, pantheon_shell_wallpaper_container_get_checked (self));
		break;
		case PANTHEON_SHELL_WALLPAPER_CONTAINER_SELECTED_PROPERTY:
		g_value_set_boolean (value, pantheon_shell_wallpaper_container_get_selected (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_pantheon_shell_wallpaper_container_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec)
{
	PantheonShellWallpaperContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PANTHEON_SHELL_TYPE_WALLPAPER_CONTAINER, PantheonShellWallpaperContainer);
	switch (property_id) {
		case PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_PATH_PROPERTY:
		pantheon_shell_wallpaper_container_set_thumb_path (self, g_value_get_string (value));
		break;
		case PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_VALID_PROPERTY:
		pantheon_shell_wallpaper_container_set_thumb_valid (self, g_value_get_boolean (value));
		break;
		case PANTHEON_SHELL_WALLPAPER_CONTAINER_URI_PROPERTY:
		pantheon_shell_wallpaper_container_set_uri (self, g_value_get_string (value));
		break;
		case PANTHEON_SHELL_WALLPAPER_CONTAINER_THUMB_PROPERTY:
		pantheon_shell_wallpaper_container_set_thumb (self, g_value_get_object (value));
		break;
		case PANTHEON_SHELL_WALLPAPER_CONTAINER_CHECKED_PROPERTY:
		pantheon_shell_wallpaper_container_set_checked (self, g_value_get_boolean (value));
		break;
		case PANTHEON_SHELL_WALLPAPER_CONTAINER_SELECTED_PROPERTY:
		pantheon_shell_wallpaper_container_set_selected (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

