"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecretKeyRequiredError = exports.S3Error = exports.InvalidXMLError = exports.InvalidPrefixError = exports.InvalidPortError = exports.InvalidObjectNameError = exports.InvalidEndpointError = exports.InvalidDateError = exports.InvalidBucketPolicyError = exports.InvalidBucketNameError = exports.InvalidArgumentError = exports.IncorrectSizeError = exports.ExpiresParamError = exports.AnonymousRequestError = exports.AccessKeyRequiredError = void 0;

var _es6Error = _interopRequireDefault(require("es6-error"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * MinIO Javascript Library for Amazon S3 Compatible Cloud Storage, (C) 2015 MinIO, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// AnonymousRequestError is generated for anonymous keys on specific
// APIs. NOTE: PresignedURL generation always requires access keys.
class AnonymousRequestError extends _es6Error.default {
  constructor(message) {
    super(message);
  }

} // InvalidArgumentError is generated for all invalid arguments.


exports.AnonymousRequestError = AnonymousRequestError;

class InvalidArgumentError extends _es6Error.default {
  constructor(message) {
    super(message);
  }

} // InvalidPortError is generated when a non integer value is provided
// for ports.


exports.InvalidArgumentError = InvalidArgumentError;

class InvalidPortError extends _es6Error.default {
  constructor(message) {
    super(message);
  }

} // InvalidEndpointError is generated when an invalid end point value is
// provided which does not follow domain standards.


exports.InvalidPortError = InvalidPortError;

class InvalidEndpointError extends _es6Error.default {
  constructor(message) {
    super(message);
  }

} // InvalidBucketNameError is generated when an invalid bucket name is
// provided which does not follow AWS S3 specifications.
// http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html


exports.InvalidEndpointError = InvalidEndpointError;

class InvalidBucketNameError extends _es6Error.default {
  constructor(message) {
    super(message);
  }

} // InvalidObjectNameError is generated when an invalid object name is
// provided which does not follow AWS S3 specifications.
// http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html


exports.InvalidBucketNameError = InvalidBucketNameError;

class InvalidObjectNameError extends _es6Error.default {
  constructor(message) {
    super(message);
  }

} // AccessKeyRequiredError generated by signature methods when access
// key is not found.


exports.InvalidObjectNameError = InvalidObjectNameError;

class AccessKeyRequiredError extends _es6Error.default {
  constructor(message) {
    super(message);
  }

} // SecretKeyRequiredError generated by signature methods when secret
// key is not found.


exports.AccessKeyRequiredError = AccessKeyRequiredError;

class SecretKeyRequiredError extends _es6Error.default {
  constructor(message) {
    super(message);
  }

} // ExpiresParamError generated when expires parameter value is not
// well within stipulated limits.


exports.SecretKeyRequiredError = SecretKeyRequiredError;

class ExpiresParamError extends _es6Error.default {
  constructor(message) {
    super(message);
  }

} // InvalidDateError generated when invalid date is found.


exports.ExpiresParamError = ExpiresParamError;

class InvalidDateError extends _es6Error.default {
  constructor(message) {
    super(message);
  }

} // InvalidPrefixError generated when object prefix provided is invalid
// or does not conform to AWS S3 object key restrictions.


exports.InvalidDateError = InvalidDateError;

class InvalidPrefixError extends _es6Error.default {
  constructor(message) {
    super(message);
  }

} // InvalidBucketPolicyError generated when the given bucket policy is invalid.


exports.InvalidPrefixError = InvalidPrefixError;

class InvalidBucketPolicyError extends _es6Error.default {
  constructor(message) {
    super(message);
  }

} // IncorrectSizeError generated when total data read mismatches with
// the input size.


exports.InvalidBucketPolicyError = InvalidBucketPolicyError;

class IncorrectSizeError extends _es6Error.default {
  constructor(message) {
    super(message);
  }

} // InvalidXMLError generated when an unknown XML is found.


exports.IncorrectSizeError = IncorrectSizeError;

class InvalidXMLError extends _es6Error.default {
  constructor(message) {
    super(message);
  }

} // S3Error is generated for errors returned from S3 server.
// see getErrorTransformer for details


exports.InvalidXMLError = InvalidXMLError;

class S3Error extends _es6Error.default {
  constructor(message) {
    super(message);
  }

}

exports.S3Error = S3Error;
//# sourceMappingURL=errors.js.map
