"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseQuota = void 0;
var dav_1 = require("./dav");
function parseQuota(result) {
    try {
        var responseItem = result.multistatus.response[0];
        var _a = responseItem.propstat.prop, quotaUsed = _a["quota-used-bytes"], quotaAvail = _a["quota-available-bytes"];
        return typeof quotaUsed !== "undefined" && typeof quotaAvail !== "undefined"
            ? {
                used: parseInt(quotaUsed, 10),
                available: (0, dav_1.translateDiskSpace)(quotaAvail)
            }
            : null;
    }
    catch (err) {
        /* ignore */
    }
    return null;
}
exports.parseQuota = parseQuota;
