## 1.5.5 (May 1, 2020)

* Ensure that feeds retrieved with `force_feed` do not share the same cache as those retrieved without. [#643](https://github.com/simplepie/simplepie/pull/643)
* Removed references to removed PHP directives and some PHP < 5.6 checks. [#645](https://github.com/simplepie/simplepie/pull/645)
* Corrected incorrect alumni name. [#638](https://github.com/simplepie/simplepie/pull/638)

## 1.5.4 (December 17, 2019)

* PHP 5.6 or newer is now required. [#625](https://github.com/simplepie/simplepie/pull/625)
* Fixed invalid docblock parameter types [#633](https://github.com/simplepie/simplepie/pull/633)
* Added support for German short forms for weekdays and months. [#632](https://github.com/simplepie/simplepie/pull/632)
* PHP 7.4 support: Fixed instances of accessing array offset on null type values. [#628](https://github.com/simplepie/simplepie/pull/628)
* Return an effective feed URL when asking for non-permanent `subscribe_url`. [#627](https://github.com/simplepie/simplepie/pull/627)

## 1.5.3 (September 22, 2019)

* Replaced `pow()` call with `**` operator (micro performance optimization). [#622](https://github.com/simplepie/simplepie/pull/622)
* Match links containing `feed` in the Locator class. [#621](https://github.com/simplepie/simplepie/pull/621)
* PHP 7.4 support: Ensure the proper argument order for `implode()` calls. [#617](https://github.com/simplepie/simplepie/pull/617)
* Added support for Russian dates. [#607](https://github.com/simplepie/simplepie/pull/607)
* Preemptively changed `is_writeable()` calls to `is_writable()` in case the former is deprecated in PHP. [#604](https://github.com/simplepie/simplepie/pull/604)

## 1.5.2 (August 2, 2018)

* Added support for PHPUnit 6. [#565](https://github.com/simplepie/simplepie/pull/565)
* Added PHP module requirements to Composer. [#590](https://github.com/simplepie/simplepie/pull/590)
* Added support for Redis password and database. [#589](https://github.com/simplepie/simplepie/pull/589)
* Changed the spelling of `writeable` to `writable` within inline documentation. [#586](https://github.com/simplepie/simplepie/pull/586)
* Fixed various issues in the test suite and Travis. [#576](https://github.com/simplepie/simplepie/pull/576)
* Removed ambiguous tests failing on `usort()` in PHP 7. [#578](https://github.com/simplepie/simplepie/pull/578)
* Simplified logic for some function returns. [#573](https://github.com/simplepie/simplepie/pull/573)
* Fixed inline documentation for return value types for accuracy. [#570](https://github.com/simplepie/simplepie/pull/570)
* Fixed Travis to run `composer install`. [#567](https://github.com/simplepie/simplepie/pull/567)
* Removed unnecessary `else`s when a value has already been returned. [#566](https://github.com/simplepie/simplepie/pull/566)
* Fixed a bug where URL fragments are included when `SimplePie_File` normalizes URLs when really old versions of cURL are used. [#564](https://github.com/simplepie/simplepie/pull/564)
* Updated `SimplePie_Locator` to respect cURL options specified. [#561](https://github.com/simplepie/simplepie/pull/561)

## 1.5.1 (November 17, 2017)

* Fixed photos so they are not added if the URL is empty. [#530](https://github.com/simplepie/simplepie/pull/530)
* Fixed issues with retrieving feeds from behind a proxy. [#512](https://github.com/simplepie/simplepie/pull/512)/[#548](https://github.com/simplepie/simplepie/pull/548)
* Updated favicon URL in `get_favicon()`. [#525](https://github.com/simplepie/simplepie/pull/525)
* Fixed inline documentation typo. [#540](https://github.com/simplepie/simplepie/pull/540)
* Removed extra closing `<a>` tag. [#537](https://github.com/simplepie/simplepie/pull/537)
* Removed and updated feed URLs in the demo. [#535](https://github.com/simplepie/simplepie/pull/535)
* Improvements to microformat feed parsing. [#533](https://github.com/simplepie/simplepie/pull/533)
* Switched from regex to xpath for microformats discovery. [#536](https://github.com/simplepie/simplepie/pull/536)
* Update the registry if the Sanitize class has been changed. [#532](https://github.com/simplepie/simplepie/pull/532)
* Changed the sanitization type for author and category back to text from HTML. [#531](https://github.com/simplepie/simplepie/pull/531)

## 1.5 (April 17, 2017)

* Introduced `SimplePie_Category->get_type()` for retrieving category type. [#492](https://github.com/simplepie/simplepie/pull/492)
* Added `$enable_exceptions` to the class property declarations for `SimplePie` class. [#504](https://github.com/simplepie/simplepie/pull/504)
* Titles are now parsed for ATOM10 enclosure links. [#507](https://github.com/simplepie/simplepie/pull/507)
* `$item->get_id()` can now be forced to return the supplied ID instead of generating a new one. [#509](https://github.com/simplepie/simplepie/pull/509)

## 1.4.3 (November 26, 2016)

* Removed support for PHP 5.2. [#469](https://github.com/simplepie/simplepie/pull/469)
* Added support for the PHP `UConverter` class. [#485](https://github.com/simplepie/simplepie/pull/485)
* PHP 7.1 Support: Fixed PHP error when trying to use a non-numeric value in `round()`. [#458](https://github.com/simplepie/simplepie/pull/458)
* PHP 7 Support: Fixed deprecated message for old style constructors. [#489](https://github.com/simplepie/simplepie/pull/489)
* Fixed the error message shown when a feed has an empty body. [#487](https://github.com/simplepie/simplepie/pull/487)
* Added an error message when the XML or PCRE PHP extensions are missing. [#468](https://github.com/simplepie/simplepie/pull/468)
* Check the result of sanitize before returning in `get_content()` and `get_description()`. [#494](https://github.com/simplepie/simplepie/pull/494)
* Use `saveHTML()` to fix issues with non UTF-8 characters. [#470](https://github.com/simplepie/simplepie/pull/470)
* Stop passing compressed data through `trim()`. [#455](https://github.com/simplepie/simplepie/pull/455)
* Refactored the UTF-8 conversion error message. [#467](https://github.com/simplepie/simplepie/pull/467)
* Updated the readme file. [#486](https://github.com/simplepie/simplepie/pull/486)
* Added command line support for compayibility test. [#481](https://github.com/simplepie/simplepie/pull/481)
* Added PHP 7.1 to the testing matrix. [#462](https://github.com/simplepie/simplepie/pull/462)
* Use the latest HHVM version in testing (3.15.2). [#480](https://github.com/simplepie/simplepie/pull/480)
* Added PHPUnit as a `dev-dependency` in Composer. [#463](https://github.com/simplepie/simplepie/pull/463)
* Added `mf2/mf2` as a suggestion in Composer for use with microformats. [#491](https://github.com/simplepie/simplepie/pull/491)
* Fixed misspelled occurrences of "separated". [#459](https://github.com/simplepie/simplepie/pull/459) 
* Improvements to the compatibility test and error messages. [#488](https://github.com/simplepie/simplepie/pull/488)

## 1.4.2 (June 14, 2016)

* Fixed a bug with IRI parsing.
* More cleanly separates discovery of microformats and parsing when php-mf2 is not present. 

## 1.4.1 (June 2, 2016)

* Fixed inconsistent hash results in `SimplePie_Item->get_id()`.
* Leading and trailing whitespace is now trimmed from XML feed content to prevent errors. [#445](https://github.com/simplepie/simplepie/pull/445)
* Improved support for microformat feeds.

## 1.4.0 (April 25, 2016)

* Dropped support for PHP 5.2. [#348](https://github.com/simplepie/simplepie/pull/348)
* Serialized data is now used for hashing in `SimplePie_Item->get_id()`. [#348](https://github.com/simplepie/simplepie/pull/348)
* Added support for PHP 5.5 and 5.6. [#348](https://github.com/simplepie/simplepie/pull/348)
* Added the `add_attributes()` method to `SimplePie`. [#394](https://github.com/simplepie/simplepie/pull/394)
* Added the `force_cache_fallback()` method to `SimplePie` to allow an expired cache to be used when a feed is unavailable. [#389](https://github.com/simplepie/simplepie/pull/389)
* Added Memcached. [#386](https://github.com/simplepie/simplepie/pull/386)
* Added `set_curl_options()` method to `SimplePie` to allow custom options. [#348](https://github.com/simplepie/simplepie/pull/348)
* Added Redis Caching. [#348](https://github.com/simplepie/simplepie/pull/348)
* Added the CEST timezone. [#380](https://github.com/simplepie/simplepie/pull/380)
* Added support for HTTP 301 Moved Permanently. [#348](https://github.com/simplepie/simplepie/pull/348)
* Added support for `application/x-rss+xml` in `SimplePie_Locator`. [#348](https://github.com/simplepie/simplepie/pull/348)
* Added photo de-duping in microformats. [#348](https://github.com/simplepie/simplepie/pull/348)
* Added decoding for special characters in MAYBE_HTML. [#400](https://github.com/simplepie/simplepie/pull/400)
* Added `SimplePie_Exception` for internally reporting errors. Also, use this to show an error when trying to load the class instead of causing a failure. [#241](https://github.com/simplepie/simplepie/pull/241) 
* Added sanitization of the `</html>` and `</body>` tags. [#348](https://github.com/simplepie/simplepie/pull/348)
* Added support for media thumbnails through `SimplePie_Item->get_thumbnail()`. [#348](https://github.com/simplepie/simplepie/pull/348)
* Added the `feed_url` to a returned error message. [#348](https://github.com/simplepie/simplepie/pull/348)
* Added cache purging after a specified period of time when using MySQL cache. [#329](https://github.com/simplepie/simplepie/pull/329)
* Added backwards compatibility for removed `subscribe_*()` and `enable_xml_dump()` methods. [#348](https://github.com/simplepie/simplepie/pull/348)
* Re-added the deprecated `get/set_favicon()` methods for backwards compatibility.
* Charsets are now compared without case sensitivity to avoid duplicates. [#352](https://github.com/simplepie/simplepie/pull/352)
* Fixed encoding of ampersands in `SimplePie->subscribe_url()`. [#348](https://github.com/simplepie/simplepie/pull/348)
* The feed URL is now updated based on the URL returned by cURL. [#348](https://github.com/simplepie/simplepie/pull/348)
* Explicitly use UTF-8 in `SimplePie_Misc->get_element()` and `Simple_ie_Misc->element_implode()`. [#348](https://github.com/simplepie/simplepie/pull/348)
* Improved support, feed and authorship discovery, and parsing for microformats. [#348](https://github.com/simplepie/simplepie/pull/348)
* `rss:pubDate` is now used over `atom:updated` when determining the posting date. [#288](https://github.com/simplepie/simplepie/pull/288)
* Simplified the use of `mtime()` and `touch()`. [#403](https://github.com/simplepie/simplepie/pull/403)
* All items are now forced to have a timestamp. [#348](https://github.com/simplepie/simplepie/pull/348)
* Fixed typo in the date parser that incorrectly identified September as month 8. [#348](https://github.com/simplepie/simplepie/pull/348)
* Fixed backwards compatibility with cache subclasses. [#243](https://github.com/simplepie/simplepie/pull/243)
* Fixed a bug where the updated date was not fetched correctly. [#239](https://github.com/simplepie/simplepie/pull/239)
* Fixed the datatype for `items.data` to be more appropriate in when using MySQL cache. [#302](https://github.com/simplepie/simplepie/pull/302)
* Fixed cURL not failing when the server returns an error. [#425](https://github.com/simplepie/simplepie/pull/425)
* Fixed an error caused when trying to instantiate a `SimplePie_File` object with a bad URI. [#272](https://github.com/simplepie/simplepie/pull/272)
* Fixed a PHP notice that occurs when a date starts with `(`. [#348](https://github.com/simplepie/simplepie/pull/348)
* Fixed uninitialized string offeset PHP notices. [#353](https://github.com/simplepie/simplepie/pull/353)
* Fixed call to non-existent property in Memcache. [#311](https://github.com/simplepie/simplepie/pull/311) 
* Fixed a bug where MySQL statements were not being passed thorugh `prepare()`. [#348](https://github.com/simplepie/simplepie/pull/348)
* Fixed an instance where an error message in `SimplePie` was not being triggered correctly. [#348](https://github.com/simplepie/simplepie/pull/348)
* Fixed a bug with Russian feeds. [#348](https://github.com/simplepie/simplepie/pull/348)
* Fixed an issue with memory leaks. [#287](https://github.com/simplepie/simplepie/pull/287)
* Fixed use of `DOMElement` as array. [#315](https://github.com/simplepie/simplepie/pull/315)
* Improved the error message when a feed cannot be found. [#348](https://github.com/simplepie/simplepie/pull/348)
