/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpAuthException;
import com.ericsson.otp.erlang.OtpEpmd;
import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangExit;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangLong;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangPid;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.ericsson.otp.erlang.OtpGenericTransportFactory;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpLocalNode;
import com.ericsson.otp.erlang.OtpMD5;
import com.ericsson.otp.erlang.OtpMsg;
import com.ericsson.otp.erlang.OtpOutputStream;
import com.ericsson.otp.erlang.OtpPeer;
import com.ericsson.otp.erlang.OtpTransport;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;

public abstract class AbstractConnection
extends Thread {
    protected static final int headerLen = 2048;
    protected static final byte passThrough = 112;
    protected static final byte version = -125;
    protected static final int linkTag = 1;
    protected static final int sendTag = 2;
    protected static final int exitTag = 3;
    protected static final int unlinkTag = 4;
    protected static final int regSendTag = 6;
    protected static final int groupLeaderTag = 7;
    protected static final int exit2Tag = 8;
    protected static final int sendTTTag = 12;
    protected static final int exitTTTag = 13;
    protected static final int regSendTTTag = 16;
    protected static final int exit2TTTag = 18;
    protected static final int unlinkIdTag = 35;
    protected static final int unlinkIdAckTag = 36;
    protected static final int ChallengeReply = 114;
    protected static final int ChallengeAck = 97;
    protected static final int ChallengeStatus = 115;
    private volatile boolean done = false;
    protected boolean connected = false;
    protected OtpTransport socket;
    protected OtpPeer peer;
    protected OtpLocalNode localNode;
    String name;
    protected boolean cookieOk = false;
    protected boolean sendCookie = true;
    protected int traceLevel = 0;
    protected static int defaultLevel = 0;
    protected static int sendThreshold = 1;
    protected static int ctrlThreshold = 2;
    protected static int handshakeThreshold = 3;
    protected static Random random = null;
    private int flags = 0;

    protected AbstractConnection(OtpLocalNode otpLocalNode, OtpTransport otpTransport) throws IOException, OtpAuthException {
        this.localNode = otpLocalNode;
        this.peer = new OtpPeer(otpLocalNode.transportFactory);
        this.socket = otpTransport;
        this.traceLevel = defaultLevel;
        this.setDaemon(true);
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("<- ACCEPT FROM " + String.valueOf(otpTransport));
        }
        this.doAccept();
        this.name = this.peer.node();
    }

    protected AbstractConnection(OtpLocalNode otpLocalNode, OtpPeer otpPeer) throws IOException, OtpAuthException {
        this.peer = otpPeer;
        this.localNode = otpLocalNode;
        this.traceLevel = defaultLevel;
        this.setDaemon(true);
        if (this.peer.proto != otpLocalNode.proto || otpLocalNode.distHigh < this.peer.distLow || otpLocalNode.distLow > this.peer.distHigh) {
            throw new IOException("No common protocol found - cannot connect");
        }
        int n = this.peer.distChoose = this.peer.distHigh > otpLocalNode.distHigh ? otpLocalNode.distHigh : this.peer.distHigh;
        if (otpLocalNode.transportFactory instanceof OtpGenericTransportFactory) {
            this.doGenericConnect();
        } else {
            int n2 = OtpEpmd.lookupPort(this.peer);
            if (n2 == 0) {
                throw new IOException("No remote node found - cannot connect");
            }
            this.doPortConnect(n2);
        }
        this.name = this.peer.node();
        this.connected = true;
    }

    public abstract void deliver(Exception var1);

    public abstract void deliver(OtpMsg var1);

    protected void sendBuf(OtpErlangPid otpErlangPid, String string, OtpOutputStream otpOutputStream) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        OtpOutputStream otpOutputStream2 = new OtpOutputStream(2048);
        otpOutputStream2.write4BE(0L);
        otpOutputStream2.write1(112L);
        otpOutputStream2.write1(-125L);
        otpOutputStream2.write_tuple_head(4);
        otpOutputStream2.write_long(6L);
        otpOutputStream2.write_any(otpErlangPid);
        if (this.sendCookie) {
            otpOutputStream2.write_atom(this.localNode.cookie());
        } else {
            otpOutputStream2.write_atom("");
        }
        otpOutputStream2.write_atom(string);
        otpOutputStream2.write1(-125L);
        otpOutputStream2.poke4BE(0, otpOutputStream2.size() + otpOutputStream.size() - 4);
        this.do_send(otpOutputStream2, otpOutputStream);
    }

    protected void sendBuf(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2, OtpOutputStream otpOutputStream) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        OtpOutputStream otpOutputStream2 = new OtpOutputStream(2048);
        otpOutputStream2.write4BE(0L);
        otpOutputStream2.write1(112L);
        otpOutputStream2.write1(-125L);
        otpOutputStream2.write_tuple_head(3);
        otpOutputStream2.write_long(2L);
        if (this.sendCookie) {
            otpOutputStream2.write_atom(this.localNode.cookie());
        } else {
            otpOutputStream2.write_atom("");
        }
        otpOutputStream2.write_any(otpErlangPid2);
        otpOutputStream2.write1(-125L);
        otpOutputStream2.poke4BE(0, otpOutputStream2.size() + otpOutputStream.size() - 4);
        this.do_send(otpOutputStream2, otpOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cookieError(OtpLocalNode otpLocalNode, OtpErlangAtom otpErlangAtom) throws OtpAuthException {
        try {
            OtpOutputStream otpOutputStream = new OtpOutputStream(2048);
            otpOutputStream.write4BE(0L);
            otpOutputStream.write1(112L);
            otpOutputStream.write1(-125L);
            otpOutputStream.write_tuple_head(4);
            otpOutputStream.write_long(6L);
            otpOutputStream.write_any(otpLocalNode.createPid());
            otpOutputStream.write_atom(otpErlangAtom.atomValue());
            otpOutputStream.write_atom("auth");
            otpOutputStream.write1(-125L);
            OtpErlangObject[] otpErlangObjectArray = new OtpErlangObject[2];
            OtpErlangObject[] otpErlangObjectArray2 = new OtpErlangObject[]{new OtpErlangAtom("print"), new OtpErlangString("~n** Bad cookie sent to " + String.valueOf(otpLocalNode) + " **~n"), new OtpErlangList()};
            otpErlangObjectArray[0] = new OtpErlangAtom("$gen_cast");
            otpErlangObjectArray[1] = new OtpErlangTuple(otpErlangObjectArray2);
            OtpOutputStream otpOutputStream2 = new OtpOutputStream(new OtpErlangTuple(otpErlangObjectArray));
            otpOutputStream.poke4BE(0, otpOutputStream.size() + otpOutputStream2.size() - 4);
            try {
                this.do_send(otpOutputStream, otpOutputStream2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            this.close();
        }
        throw new OtpAuthException("Remote cookie not authorized: " + otpErlangAtom.atomValue());
    }

    protected void sendLink(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        OtpOutputStream otpOutputStream = new OtpOutputStream(2048);
        otpOutputStream.write4BE(0L);
        otpOutputStream.write1(112L);
        otpOutputStream.write1(-125L);
        otpOutputStream.write_tuple_head(3);
        otpOutputStream.write_long(1L);
        otpOutputStream.write_any(otpErlangPid);
        otpOutputStream.write_any(otpErlangPid2);
        otpOutputStream.poke4BE(0, otpOutputStream.size() - 4);
        this.do_send(otpOutputStream);
    }

    protected void sendUnlink(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2, long l) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        OtpOutputStream otpOutputStream = new OtpOutputStream(2048);
        otpOutputStream.write4BE(0L);
        otpOutputStream.write1(112L);
        otpOutputStream.write1(-125L);
        if ((this.peer.flags & 0x2000000L) != 0L) {
            otpOutputStream.write_tuple_head(4);
            otpOutputStream.write_long(35L);
            otpOutputStream.write_long(l);
            otpOutputStream.write_any(otpErlangPid);
            otpOutputStream.write_any(otpErlangPid2);
        } else {
            otpOutputStream.write_tuple_head(3);
            otpOutputStream.write_long(4L);
            otpOutputStream.write_any(otpErlangPid);
            otpOutputStream.write_any(otpErlangPid2);
            this.deliver(new OtpMsg(36, otpErlangPid2, otpErlangPid, l));
        }
        otpOutputStream.poke4BE(0, otpOutputStream.size() - 4);
        this.do_send(otpOutputStream);
    }

    protected void sendUnlinkAck(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2, long l) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        if ((this.peer.flags & 0x2000000L) != 0L) {
            OtpOutputStream otpOutputStream = new OtpOutputStream(2048);
            otpOutputStream.write4BE(0L);
            otpOutputStream.write1(112L);
            otpOutputStream.write1(-125L);
            otpOutputStream.write_tuple_head(4);
            otpOutputStream.write_long(36L);
            otpOutputStream.write_long(l);
            otpOutputStream.write_any(otpErlangPid);
            otpOutputStream.write_any(otpErlangPid2);
            otpOutputStream.poke4BE(0, otpOutputStream.size() - 4);
            this.do_send(otpOutputStream);
        }
    }

    protected void sendExit(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2, OtpErlangObject otpErlangObject) throws IOException {
        this.sendExit(3, otpErlangPid, otpErlangPid2, otpErlangObject);
    }

    protected void sendExit2(OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2, OtpErlangObject otpErlangObject) throws IOException {
        this.sendExit(8, otpErlangPid, otpErlangPid2, otpErlangObject);
    }

    private void sendExit(int n, OtpErlangPid otpErlangPid, OtpErlangPid otpErlangPid2, OtpErlangObject otpErlangObject) throws IOException {
        if (!this.connected) {
            throw new IOException("Not connected");
        }
        OtpOutputStream otpOutputStream = new OtpOutputStream(2048);
        otpOutputStream.write4BE(0L);
        otpOutputStream.write1(112L);
        otpOutputStream.write1(-125L);
        otpOutputStream.write_tuple_head(4);
        otpOutputStream.write_long(n);
        otpOutputStream.write_any(otpErlangPid);
        otpOutputStream.write_any(otpErlangPid2);
        otpOutputStream.write_any(otpErlangObject);
        otpOutputStream.poke4BE(0, otpOutputStream.size() - 4);
        this.do_send(otpOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (!this.connected) {
            this.deliver(new IOException("Not connected"));
            return;
        }
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[]{0, 0, 0, 0};
        try {
            block20: while (!this.done) {
                Object object;
                Object object2;
                OtpInputStream otpInputStream;
                int n;
                do {
                    this.readSock(this.socket, byArray);
                    otpInputStream = new OtpInputStream(byArray, this.flags);
                    n = otpInputStream.read4BE();
                    if (n != 0) continue;
                    object2 = this;
                    synchronized (object2) {
                        if (this.socket == null) {
                            throw new IOException("socket was closed");
                        }
                        object = this.socket.getOutputStream();
                        ((OutputStream)object).write(byArray2);
                        ((OutputStream)object).flush();
                    }
                } while (n == 0);
                object2 = new byte[n];
                this.readSock(this.socket, (byte[])object2);
                otpInputStream.close();
                otpInputStream = new OtpInputStream((byte[])object2, this.flags);
                if (otpInputStream.read1() != 112) break;
                object = null;
                OtpErlangAtom otpErlangAtom = null;
                OtpErlangObject otpErlangObject = null;
                OtpErlangTuple otpErlangTuple = null;
                otpErlangObject = otpInputStream.read_any();
                if (!(otpErlangObject instanceof OtpErlangTuple) || !((otpErlangTuple = (OtpErlangTuple)otpErlangObject).elementAt(0) instanceof OtpErlangLong)) break;
                int n2 = (int)((OtpErlangLong)otpErlangTuple.elementAt(0)).longValue();
                switch (n2) {
                    case 2: 
                    case 12: {
                        OtpErlangObject otpErlangObject2;
                        if (!this.cookieOk) {
                            if (!(otpErlangTuple.elementAt(1) instanceof OtpErlangAtom)) break block20;
                            otpErlangAtom = (OtpErlangAtom)otpErlangTuple.elementAt(1);
                            if (this.sendCookie) {
                                if (!otpErlangAtom.atomValue().equals(this.localNode.cookie())) {
                                    this.cookieError(this.localNode, otpErlangAtom);
                                }
                            } else if (!otpErlangAtom.atomValue().equals("")) {
                                this.cookieError(this.localNode, otpErlangAtom);
                            }
                            this.cookieOk = true;
                        }
                        if (this.traceLevel >= sendThreshold) {
                            System.out.println("<- " + this.headerType(otpErlangTuple) + " " + String.valueOf(otpErlangTuple));
                            otpInputStream.mark(0);
                            otpErlangObject2 = otpInputStream.read_any();
                            if (otpErlangObject2 != null) {
                                System.out.println("   " + String.valueOf(otpErlangObject2));
                            } else {
                                System.out.println("   (null)");
                            }
                            otpInputStream.reset();
                        }
                        OtpErlangPid otpErlangPid2 = (OtpErlangPid)otpErlangTuple.elementAt(2);
                        this.deliver(new OtpMsg(otpErlangPid2, otpInputStream));
                        continue block20;
                    }
                    case 6: 
                    case 16: {
                        OtpErlangObject otpErlangObject2;
                        if (!this.cookieOk) {
                            if (!(otpErlangTuple.elementAt(2) instanceof OtpErlangAtom)) break block20;
                            otpErlangAtom = (OtpErlangAtom)otpErlangTuple.elementAt(2);
                            if (this.sendCookie) {
                                if (!otpErlangAtom.atomValue().equals(this.localNode.cookie())) {
                                    this.cookieError(this.localNode, otpErlangAtom);
                                }
                            } else if (!otpErlangAtom.atomValue().equals("")) {
                                this.cookieError(this.localNode, otpErlangAtom);
                            }
                            this.cookieOk = true;
                        }
                        if (this.traceLevel >= sendThreshold) {
                            System.out.println("<- " + this.headerType(otpErlangTuple) + " " + String.valueOf(otpErlangTuple));
                            otpInputStream.mark(0);
                            otpErlangObject2 = otpInputStream.read_any();
                            if (otpErlangObject2 != null) {
                                System.out.println("   " + String.valueOf(otpErlangObject2));
                            } else {
                                System.out.println("   (null)");
                            }
                            otpInputStream.reset();
                        }
                        OtpErlangPid otpErlangPid = (OtpErlangPid)otpErlangTuple.elementAt(1);
                        OtpErlangAtom otpErlangAtom2 = (OtpErlangAtom)otpErlangTuple.elementAt(3);
                        this.deliver(new OtpMsg(otpErlangPid, otpErlangAtom2.atomValue(), otpInputStream));
                        continue block20;
                    }
                    case 3: 
                    case 8: {
                        if (otpErlangTuple.elementAt(3) == null) break block20;
                        if (this.traceLevel >= ctrlThreshold) {
                            System.out.println("<- " + this.headerType(otpErlangTuple) + " " + String.valueOf(otpErlangTuple));
                        }
                        OtpErlangPid otpErlangPid = (OtpErlangPid)otpErlangTuple.elementAt(1);
                        OtpErlangPid otpErlangPid2 = (OtpErlangPid)otpErlangTuple.elementAt(2);
                        object = otpErlangTuple.elementAt(3);
                        this.deliver(new OtpMsg(n2, otpErlangPid, otpErlangPid2, (OtpErlangObject)object));
                        continue block20;
                    }
                    case 13: 
                    case 18: {
                        if (otpErlangTuple.elementAt(4) == null) break block20;
                        if (this.traceLevel >= ctrlThreshold) {
                            System.out.println("<- " + this.headerType(otpErlangTuple) + " " + String.valueOf(otpErlangTuple));
                        }
                        OtpErlangPid otpErlangPid = (OtpErlangPid)otpErlangTuple.elementAt(1);
                        OtpErlangPid otpErlangPid2 = (OtpErlangPid)otpErlangTuple.elementAt(2);
                        object = otpErlangTuple.elementAt(4);
                        this.deliver(new OtpMsg(n2, otpErlangPid, otpErlangPid2, (OtpErlangObject)object));
                        continue block20;
                    }
                    case 1: 
                    case 4: {
                        if (this.traceLevel >= ctrlThreshold) {
                            System.out.println("<- " + this.headerType(otpErlangTuple) + " " + String.valueOf(otpErlangTuple));
                        }
                        OtpErlangPid otpErlangPid = (OtpErlangPid)otpErlangTuple.elementAt(1);
                        OtpErlangPid otpErlangPid2 = (OtpErlangPid)otpErlangTuple.elementAt(2);
                        this.deliver(new OtpMsg(n2, otpErlangPid, otpErlangPid2, 0L));
                        continue block20;
                    }
                    case 35: 
                    case 36: {
                        if (this.traceLevel >= ctrlThreshold) {
                            System.out.println("<- " + this.headerType(otpErlangTuple) + " " + String.valueOf(otpErlangTuple));
                        }
                        long l = ((OtpErlangLong)otpErlangTuple.elementAt(1)).longValue();
                        OtpErlangPid otpErlangPid = (OtpErlangPid)otpErlangTuple.elementAt(2);
                        OtpErlangPid otpErlangPid2 = (OtpErlangPid)otpErlangTuple.elementAt(3);
                        this.deliver(new OtpMsg(n2, otpErlangPid, otpErlangPid2, l));
                        continue block20;
                    }
                    case 7: {
                        if (this.traceLevel < ctrlThreshold) continue block20;
                        System.out.println("<- " + this.headerType(otpErlangTuple) + " " + String.valueOf(otpErlangTuple));
                        continue block20;
                    }
                }
            }
            this.deliver(new OtpErlangExit("Remote is sending garbage"));
            return;
        }
        catch (OtpAuthException otpAuthException) {
            this.deliver(otpAuthException);
            return;
        }
        catch (OtpErlangDecodeException otpErlangDecodeException) {
            this.deliver(new OtpErlangExit("Remote is sending garbage"));
            return;
        }
        catch (IOException iOException) {
            this.deliver(new OtpErlangExit("Remote has closed connection"));
            return;
        }
        finally {
            this.close();
        }
    }

    public int setTraceLevel(int n) {
        int n2 = this.traceLevel;
        int n3 = n;
        if (n < 0) {
            n3 = 0;
        } else if (n > 4) {
            n3 = 4;
        }
        this.traceLevel = n3;
        return n2;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.done = true;
        this.connected = false;
        AbstractConnection abstractConnection = this;
        synchronized (abstractConnection) {
            try {
                if (this.socket != null) {
                    if (this.traceLevel >= ctrlThreshold) {
                        System.out.println("-> CLOSE");
                    }
                    this.socket.close();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.socket = null;
            }
        }
    }

    protected void finalize() {
        this.close();
    }

    public boolean isConnected() {
        return this.connected;
    }

    protected synchronized void do_send(OtpOutputStream otpOutputStream, OtpOutputStream otpOutputStream2) throws IOException {
        try {
            Object object;
            if (this.traceLevel >= sendThreshold) {
                try {
                    object = otpOutputStream.getOtpInputStream(5).read_any();
                    System.out.println("-> " + this.headerType((OtpErlangObject)object) + " " + String.valueOf(object));
                    OtpErlangObject otpErlangObject = otpOutputStream2.getOtpInputStream(0).read_any();
                    System.out.println("   " + String.valueOf(otpErlangObject));
                    otpErlangObject = null;
                }
                catch (OtpErlangDecodeException otpErlangDecodeException) {
                    System.out.println("   can't decode output buffer:" + String.valueOf(otpErlangDecodeException));
                }
            }
            object = this.socket.getOutputStream();
            otpOutputStream.writeTo((OutputStream)object);
            otpOutputStream2.writeTo((OutputStream)object);
            ((OutputStream)object).flush();
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    protected synchronized void do_send(OtpOutputStream otpOutputStream) throws IOException {
        try {
            if (this.traceLevel >= ctrlThreshold) {
                try {
                    OtpErlangObject otpErlangObject = otpOutputStream.getOtpInputStream(5).read_any();
                    System.out.println("-> " + this.headerType(otpErlangObject) + " " + String.valueOf(otpErlangObject));
                }
                catch (OtpErlangDecodeException otpErlangDecodeException) {
                    System.out.println("   can't decode output buffer: " + String.valueOf(otpErlangDecodeException));
                }
            }
            otpOutputStream.writeToAndFlush(this.socket.getOutputStream());
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    protected String headerType(OtpErlangObject otpErlangObject) {
        int n = -1;
        if (otpErlangObject instanceof OtpErlangTuple) {
            n = (int)((OtpErlangLong)((OtpErlangTuple)otpErlangObject).elementAt(0)).longValue();
        }
        switch (n) {
            case 1: {
                return "LINK";
            }
            case 2: {
                return "SEND";
            }
            case 3: {
                return "EXIT";
            }
            case 4: {
                return "UNLINK";
            }
            case 35: {
                return "UNLINK_ID";
            }
            case 36: {
                return "UNLINK_ID_ACK";
            }
            case 6: {
                return "REG_SEND";
            }
            case 7: {
                return "GROUP_LEADER";
            }
            case 8: {
                return "EXIT2";
            }
            case 12: {
                return "SEND_TT";
            }
            case 13: {
                return "EXIT_TT";
            }
            case 16: {
                return "REG_SEND_TT";
            }
            case 18: {
                return "EXIT2_TT";
            }
        }
        return "(unknown type)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int readSock(OtpTransport otpTransport, byte[] byArray) throws IOException {
        int n;
        int n2;
        int n3 = byArray.length;
        AbstractConnection abstractConnection = this;
        synchronized (abstractConnection) {
            if (otpTransport == null) {
                throw new IOException("expected " + n3 + " bytes, socket was closed");
            }
        }
        for (n = 0; n < n3; n += n2) {
            n2 = otpTransport.getInputStream().read(byArray, n, n3 - n);
            if (n2 < 0) {
                throw new IOException("expected " + n3 + " bytes, got EOF after " + n + " bytes");
            }
            if (n2 != 0 || n3 == 0) continue;
            throw new IOException("Remote connection closed");
        }
        return n;
    }

    protected void doAccept() throws IOException, OtpAuthException {
        int n = this.recvName(this.peer);
        try {
            this.sendStatus("ok");
            int n2 = AbstractConnection.genChallenge();
            this.sendChallenge(this.peer.flags, this.localNode.flags, n2);
            int n3 = this.recvChallengeReply(n2);
            byte[] byArray = this.genDigest(n3, this.localNode.cookie());
            this.sendChallengeAck(byArray);
            this.connected = true;
            this.cookieOk = true;
            this.sendCookie = false;
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
        catch (OtpAuthException otpAuthException) {
            this.close();
            throw otpAuthException;
        }
        catch (Exception exception) {
            String string = this.peer.node();
            this.close();
            IOException iOException = new IOException("Error accepting connection from " + string);
            iOException.initCause(exception);
            throw iOException;
        }
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("<- MD5 ACCEPTED " + this.peer.host());
        }
    }

    protected void doPortConnect(int n) throws IOException, OtpAuthException {
        try {
            this.socket = this.peer.createTransport(this.peer.host(), n);
            if (this.traceLevel >= handshakeThreshold) {
                System.out.println("-> MD5 CONNECT TO " + this.peer.host() + ":" + n);
            }
            this.doConnect();
        }
        catch (OtpAuthException otpAuthException) {
            this.close();
            throw otpAuthException;
        }
        catch (Exception exception) {
            this.close();
            IOException iOException = new IOException("Cannot connect to peer node");
            iOException.initCause(exception);
            throw iOException;
        }
    }

    protected void doConnect() throws IOException, OtpAuthException {
        int n = this.sendName(this.peer.distChoose, this.localNode.flags, this.localNode.creation());
        this.recvStatus();
        int n2 = this.recvChallenge();
        byte[] byArray = this.genDigest(n2, this.localNode.cookie());
        int n3 = AbstractConnection.genChallenge();
        this.sendChallengeReply(n3, byArray);
        this.recvChallengeAck(n3);
        this.cookieOk = true;
        this.sendCookie = false;
    }

    protected void doGenericConnect() throws IOException, OtpAuthException {
        try {
            this.socket = this.peer.createTransport(this.peer);
            if (this.traceLevel >= handshakeThreshold) {
                System.out.println("-> MD5 CONNECT TO " + this.peer.node());
            }
            this.doConnect();
        }
        catch (OtpAuthException otpAuthException) {
            this.close();
            throw otpAuthException;
        }
        catch (Exception exception) {
            this.close();
            IOException iOException = new IOException("Cannot connect to peer node");
            iOException.initCause(exception);
            throw iOException;
        }
    }

    protected static int genChallenge() {
        return random.nextInt();
    }

    static String hex0(byte n) {
        int n2;
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        if (n < 0) {
            n2 = n & 0x7F;
            n2 |= 0x80;
        } else {
            n2 = n;
        }
        return "" + cArray[n2 >>> 4] + cArray[n2 & 0xF];
    }

    static String hex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append(AbstractConnection.hex0(byArray[i]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    protected byte[] genDigest(int n, String string) {
        long l;
        if (n < 0) {
            l = 0x80000000L;
            l |= (long)(n & Integer.MAX_VALUE);
        } else {
            l = n;
        }
        OtpMD5 otpMD5 = new OtpMD5();
        otpMD5.update(string);
        otpMD5.update("" + l);
        int[] nArray = otpMD5.final_bytes();
        byte[] byArray = new byte[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)(nArray[i] & 0xFF);
        }
        return byArray;
    }

    protected int sendName(int n, long l, int n2) throws IOException {
        OtpOutputStream otpOutputStream = new OtpOutputStream();
        String string = this.localNode.node();
        otpOutputStream.write2BE(15 + string.length());
        int n3 = 78;
        otpOutputStream.write1(n3);
        otpOutputStream.write8BE(l);
        otpOutputStream.write4BE(n2);
        otpOutputStream.write2BE(string.length());
        otpOutputStream.write(string.getBytes());
        otpOutputStream.writeToAndFlush(this.socket.getOutputStream());
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("-> HANDSHAKE sendName flags=" + l + " local=" + String.valueOf(this.localNode));
        }
        return n3;
    }

    protected void sendChallenge(long l, long l2, int n) throws IOException {
        OtpOutputStream otpOutputStream = new OtpOutputStream();
        String string = this.localNode.node();
        otpOutputStream.write2BE(19 + string.length());
        otpOutputStream.write1(78L);
        otpOutputStream.write8BE(l2);
        otpOutputStream.write4BE(n);
        otpOutputStream.write4BE(this.localNode.creation());
        otpOutputStream.write2BE(string.length());
        otpOutputStream.write(string.getBytes());
        otpOutputStream.writeToAndFlush(this.socket.getOutputStream());
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("-> HANDSHAKE sendChallenge flags=" + l2 + " challenge=" + n + " local=" + String.valueOf(this.localNode));
        }
    }

    protected byte[] read2BytePackage() throws IOException, OtpErlangDecodeException {
        byte[] byArray = new byte[2];
        this.readSock(this.socket, byArray);
        OtpInputStream otpInputStream = new OtpInputStream(byArray, 0);
        int n = otpInputStream.read2BE();
        byte[] byArray2 = new byte[n];
        this.readSock(this.socket, byArray2);
        return byArray2;
    }

    protected int recvName(OtpPeer otpPeer) throws IOException {
        int n;
        String string = "";
        try {
            byte[] byArray = this.read2BytePackage();
            OtpInputStream otpInputStream = new OtpInputStream(byArray, 0);
            int n2 = byArray.length;
            n = otpInputStream.read1();
            switch (n) {
                case 78: {
                    otpPeer.distHigh = 6;
                    otpPeer.distLow = 6;
                    otpPeer.flags = otpInputStream.read8BE();
                    if ((otpPeer.flags & 0x4000000L) != 0L) {
                        otpPeer.flags |= 0x1070F94L;
                    }
                    if ((otpPeer.flags & 0x1000000L) == 0L) {
                        throw new IOException("Missing DFLAG_HANDSHAKE_23");
                    }
                    otpPeer.setCreation(otpInputStream.read4BE());
                    int n3 = otpInputStream.read2BE();
                    byte[] byArray2 = new byte[n3];
                    otpInputStream.readN(byArray2);
                    string = OtpErlangString.newString(byArray2);
                    break;
                }
                default: {
                    throw new IOException("Unknown remote node type");
                }
            }
            if ((otpPeer.flags & 0x1070F94L) != 17239956L) {
                throw new IOException("Handshake failed - peer cannot handle all mandatory capabilities");
            }
        }
        catch (OtpErlangDecodeException otpErlangDecodeException) {
            throw new IOException("Handshake failed - not enough data");
        }
        int n4 = string.indexOf(64);
        otpPeer.node = string;
        otpPeer.alive = string.substring(0, n4);
        otpPeer.host = string.substring(n4 + 1, string.length());
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("<- HANDSHAKE ntype=" + otpPeer.ntype + " dist=" + otpPeer.distHigh + " remote=" + String.valueOf(otpPeer));
        }
        return n;
    }

    protected int recvChallenge() throws IOException {
        int n;
        try {
            byte[] byArray = this.read2BytePackage();
            OtpInputStream otpInputStream = new OtpInputStream(byArray, 0);
            byte[] byArray2 = new byte[switch (otpInputStream.read1()) {
                case 78 -> {
                    this.peer.distChoose = 6;
                    this.peer.distHigh = 6;
                    this.peer.distLow = 6;
                    this.peer.flags = otpInputStream.read8BE();
                    if ((this.peer.flags & 0x4000000L) != 0L) {
                        this.peer.flags |= 0x1070F94L;
                    }
                    if ((this.peer.flags & 0x1000000L) == 0L) {
                        throw new IOException("New challenge missing DFLAG_HANDHAKE_23");
                    }
                    n = otpInputStream.read4BE();
                    this.peer.setCreation(otpInputStream.read4BE());
                    yield otpInputStream.read2BE();
                }
                default -> throw new IOException("Unexpected peer type");
            }];
            otpInputStream.readN(byArray2);
            String string = OtpErlangString.newString(byArray2);
            if (!string.equals(this.peer.node)) {
                throw new IOException("Handshake failed - peer has wrong name: " + string);
            }
            if ((this.peer.flags & 0x1070F94L) != 17239956L) {
                throw new IOException("Handshake failed - peer cannot handle all mandatory capabilities");
            }
        }
        catch (OtpErlangDecodeException otpErlangDecodeException) {
            throw new IOException("Handshake failed - not enough data");
        }
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("<- HANDSHAKE recvChallenge from=" + this.peer.node + " challenge=" + n + " local=" + String.valueOf(this.localNode));
        }
        return n;
    }

    protected void sendChallengeReply(int n, byte[] byArray) throws IOException {
        OtpOutputStream otpOutputStream = new OtpOutputStream();
        otpOutputStream.write2BE(21L);
        otpOutputStream.write1(114L);
        otpOutputStream.write4BE(n);
        otpOutputStream.write(byArray);
        otpOutputStream.writeToAndFlush(this.socket.getOutputStream());
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("-> HANDSHAKE sendChallengeReply challenge=" + n + " digest=" + AbstractConnection.hex(byArray) + " local=" + String.valueOf(this.localNode));
        }
    }

    private boolean digests_equals(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < 16; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    protected int recvChallengeReply(int n) throws IOException, OtpAuthException {
        int n2;
        byte[] byArray = new byte[16];
        try {
            byte[] byArray2 = this.read2BytePackage();
            OtpInputStream otpInputStream = new OtpInputStream(byArray2, 0);
            int n3 = otpInputStream.read1();
            if (n3 != 114) {
                throw new IOException("Handshake protocol error");
            }
            n2 = otpInputStream.read4BE();
            otpInputStream.readN(byArray);
            byte[] byArray3 = this.genDigest(n, this.localNode.cookie());
            if (!this.digests_equals(byArray, byArray3)) {
                throw new OtpAuthException("Peer authentication error.");
            }
        }
        catch (OtpErlangDecodeException otpErlangDecodeException) {
            throw new IOException("Handshake failed - not enough data");
        }
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("<- HANDSHAKE recvChallengeReply from=" + this.peer.node + " challenge=" + n2 + " digest=" + AbstractConnection.hex(byArray) + " local=" + String.valueOf(this.localNode));
        }
        return n2;
    }

    protected void sendChallengeAck(byte[] byArray) throws IOException {
        OtpOutputStream otpOutputStream = new OtpOutputStream();
        otpOutputStream.write2BE(17L);
        otpOutputStream.write1(97L);
        otpOutputStream.write(byArray);
        otpOutputStream.writeToAndFlush(this.socket.getOutputStream());
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("-> HANDSHAKE sendChallengeAck digest=" + AbstractConnection.hex(byArray) + " local=" + String.valueOf(this.localNode));
        }
    }

    protected void recvChallengeAck(int n) throws IOException, OtpAuthException {
        byte[] byArray = new byte[16];
        try {
            byte[] byArray2 = this.read2BytePackage();
            OtpInputStream otpInputStream = new OtpInputStream(byArray2, 0);
            int n2 = otpInputStream.read1();
            if (n2 != 97) {
                throw new IOException("Handshake protocol error");
            }
            otpInputStream.readN(byArray);
            byte[] byArray3 = this.genDigest(n, this.localNode.cookie());
            if (!this.digests_equals(byArray, byArray3)) {
                throw new OtpAuthException("Peer authentication error.");
            }
        }
        catch (OtpErlangDecodeException otpErlangDecodeException) {
            throw new IOException("Handshake failed - not enough data");
        }
        catch (Exception exception) {
            throw new OtpAuthException("Peer authentication error.");
        }
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("<- HANDSHAKE recvChallengeAck from=" + this.peer.node + " digest=" + AbstractConnection.hex(byArray) + " local=" + String.valueOf(this.localNode));
        }
    }

    protected void sendStatus(String string) throws IOException {
        OtpOutputStream otpOutputStream = new OtpOutputStream();
        otpOutputStream.write2BE(string.length() + 1);
        otpOutputStream.write1(115L);
        otpOutputStream.write(string.getBytes());
        otpOutputStream.writeToAndFlush(this.socket.getOutputStream());
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("-> HANDSHAKE sendStatus status=" + string + " local=" + String.valueOf(this.localNode));
        }
    }

    protected void recvStatus() throws IOException {
        try {
            byte[] byArray = this.read2BytePackage();
            OtpInputStream otpInputStream = new OtpInputStream(byArray, 0);
            int n = otpInputStream.read1();
            if (n != 115) {
                throw new IOException("Handshake protocol error");
            }
            byte[] byArray2 = new byte[byArray.length - 1];
            otpInputStream.readN(byArray2);
            String string = OtpErlangString.newString(byArray2);
            if (string.compareTo("ok") != 0) {
                throw new IOException("Peer replied with status '" + string + "' instead of 'ok'");
            }
        }
        catch (OtpErlangDecodeException otpErlangDecodeException) {
            throw new IOException("Handshake failed - not enough data");
        }
        if (this.traceLevel >= handshakeThreshold) {
            System.out.println("<- HANDSHAKE recvStatus (ok) local=" + String.valueOf(this.localNode));
        }
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public int getFlags() {
        return this.flags;
    }

    static {
        String string = System.getProperties().getProperty("OtpConnection.trace");
        try {
            if (string != null) {
                defaultLevel = Integer.valueOf(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            defaultLevel = 0;
        }
        random = new Random();
    }
}

