/* DesktopIntegration.c generated by valac 0.56.3, the Vala compiler
 * generated from DesktopIntegration.vala, do not modify */

/*
 * Copyright 2022 elementary, Inc. <https://elementary.io>
 * Copyright 2022 Corentin Noël <tintou@noel.tf>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <glib-object.h>
#include <gio/gio.h>
#include "gala.h"
#include <glib.h>
#include <meta/meta-plugin.h>
#include <stdlib.h>
#include <string.h>
#include <meta/window.h>
#include <meta/boxes.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_DESKTOP_INTEGRATION (gala_desktop_integration_get_type ())
#define GALA_DESKTOP_INTEGRATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_DESKTOP_INTEGRATION, GalaDesktopIntegration))
#define GALA_DESKTOP_INTEGRATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_DESKTOP_INTEGRATION, GalaDesktopIntegrationClass))
#define GALA_IS_DESKTOP_INTEGRATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_DESKTOP_INTEGRATION))
#define GALA_IS_DESKTOP_INTEGRATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_DESKTOP_INTEGRATION))
#define GALA_DESKTOP_INTEGRATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_DESKTOP_INTEGRATION, GalaDesktopIntegrationClass))

typedef struct _GalaDesktopIntegration GalaDesktopIntegration;
typedef struct _GalaDesktopIntegrationClass GalaDesktopIntegrationClass;
typedef struct _GalaDesktopIntegrationPrivate GalaDesktopIntegrationPrivate;
enum  {
	GALA_DESKTOP_INTEGRATION_0_PROPERTY,
	GALA_DESKTOP_INTEGRATION_VERSION_PROPERTY,
	GALA_DESKTOP_INTEGRATION_NUM_PROPERTIES
};
static GParamSpec* gala_desktop_integration_properties[GALA_DESKTOP_INTEGRATION_NUM_PROPERTIES];

#define GALA_TYPE_WINDOW_MANAGER_GALA (gala_window_manager_gala_get_type ())
#define GALA_WINDOW_MANAGER_GALA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_MANAGER_GALA, GalaWindowManagerGala))
#define GALA_WINDOW_MANAGER_GALA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_MANAGER_GALA, GalaWindowManagerGalaClass))
#define GALA_IS_WINDOW_MANAGER_GALA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_MANAGER_GALA))
#define GALA_IS_WINDOW_MANAGER_GALA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_MANAGER_GALA))
#define GALA_WINDOW_MANAGER_GALA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_MANAGER_GALA, GalaWindowManagerGalaClass))

typedef struct _GalaWindowManagerGala GalaWindowManagerGala;
typedef struct _GalaWindowManagerGalaClass GalaWindowManagerGalaClass;

#define GALA_TYPE_WINDOW_TRACKER (gala_window_tracker_get_type ())
#define GALA_WINDOW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_TRACKER, GalaWindowTracker))
#define GALA_WINDOW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_TRACKER, GalaWindowTrackerClass))
#define GALA_IS_WINDOW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_TRACKER))
#define GALA_IS_WINDOW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_TRACKER))
#define GALA_WINDOW_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_TRACKER, GalaWindowTrackerClass))

typedef struct _GalaWindowTracker GalaWindowTracker;
typedef struct _GalaWindowTrackerClass GalaWindowTrackerClass;

#define GALA_DESKTOP_INTEGRATION_TYPE_RUNNING_APPLICATION (gala_desktop_integration_running_application_get_type ())
typedef struct _GalaDesktopIntegrationRunningApplication GalaDesktopIntegrationRunningApplication;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define GALA_DESKTOP_INTEGRATION_TYPE_WINDOW (gala_desktop_integration_window_get_type ())
typedef struct _GalaDesktopIntegrationWindow GalaDesktopIntegrationWindow;
enum  {
	GALA_DESKTOP_INTEGRATION_RUNNING_APPLICATIONS_CHANGED_SIGNAL,
	GALA_DESKTOP_INTEGRATION_WINDOWS_CHANGED_SIGNAL,
	GALA_DESKTOP_INTEGRATION_NUM_SIGNALS
};
static guint gala_desktop_integration_signals[GALA_DESKTOP_INTEGRATION_NUM_SIGNALS] = {0};

struct _GalaDesktopIntegration {
	GObject parent_instance;
	GalaDesktopIntegrationPrivate * priv;
};

struct _GalaDesktopIntegrationClass {
	GObjectClass parent_class;
};

struct _GalaDesktopIntegrationPrivate {
	GalaWindowManager* wm;
	guint _version;
};

struct _GalaDesktopIntegrationRunningApplication {
	gchar* app_id;
	GHashTable* details;
};

struct _GalaDesktopIntegrationWindow {
	guint64 uid;
	GHashTable* properties;
};

static gint GalaDesktopIntegration_private_offset;
static gpointer gala_desktop_integration_parent_class = NULL;

VALA_EXTERN GType gala_desktop_integration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaDesktopIntegration, g_object_unref)
VALA_EXTERN guint gala_desktop_integration_register_object (void* object,
                                                GDBusConnection* connection,
                                                const gchar* path,
                                                GError** error);
VALA_EXTERN GalaDesktopIntegration* gala_desktop_integration_new (GalaWindowManager* wm);
VALA_EXTERN GalaDesktopIntegration* gala_desktop_integration_construct (GType object_type,
                                                            GalaWindowManager* wm);
VALA_EXTERN GType gala_window_manager_gala_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowManagerGala, g_object_unref)
VALA_EXTERN GType gala_window_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowTracker, g_object_unref)
VALA_EXTERN GalaWindowTracker* gala_window_manager_gala_get_window_tracker (GalaWindowManagerGala* self);
static void ___lambda169_ (GalaDesktopIntegration* self);
static void ____lambda169__gala_window_tracker_windows_changed (GalaWindowTracker* _sender,
                                                         gpointer self);
VALA_EXTERN GType gala_desktop_integration_running_application_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GalaDesktopIntegrationRunningApplication* gala_desktop_integration_running_application_dup (const GalaDesktopIntegrationRunningApplication* self);
VALA_EXTERN void gala_desktop_integration_running_application_free (GalaDesktopIntegrationRunningApplication* self);
VALA_EXTERN void gala_desktop_integration_running_application_copy (const GalaDesktopIntegrationRunningApplication* self,
                                                        GalaDesktopIntegrationRunningApplication* dest);
VALA_EXTERN void gala_desktop_integration_running_application_destroy (GalaDesktopIntegrationRunningApplication* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (GalaDesktopIntegrationRunningApplication, gala_desktop_integration_running_application_destroy)
VALA_EXTERN GalaDesktopIntegrationRunningApplication* gala_desktop_integration_get_running_applications (GalaDesktopIntegration* self,
                                                                                             gint* result_length1,
                                                                                             GError** error);
static void _g_variant_unref0_ (gpointer var);
static void _vala_array_add2 (GalaDesktopIntegrationRunningApplication* * array,
                       gint* length,
                       gint* size,
                       const GalaDesktopIntegrationRunningApplication* value);
static void _vala_GalaDesktopIntegrationRunningApplication_array_free (GalaDesktopIntegrationRunningApplication * array,
                                                                gssize array_length);
static gboolean gala_desktop_integration_is_eligible_window (GalaDesktopIntegration* self,
                                                      MetaWindow* window);
VALA_EXTERN GType gala_desktop_integration_window_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GalaDesktopIntegrationWindow* gala_desktop_integration_window_dup (const GalaDesktopIntegrationWindow* self);
VALA_EXTERN void gala_desktop_integration_window_free (GalaDesktopIntegrationWindow* self);
VALA_EXTERN void gala_desktop_integration_window_copy (const GalaDesktopIntegrationWindow* self,
                                           GalaDesktopIntegrationWindow* dest);
VALA_EXTERN void gala_desktop_integration_window_destroy (GalaDesktopIntegrationWindow* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (GalaDesktopIntegrationWindow, gala_desktop_integration_window_destroy)
VALA_EXTERN GalaDesktopIntegrationWindow* gala_desktop_integration_get_windows (GalaDesktopIntegration* self,
                                                                    gint* result_length1,
                                                                    GError** error);
static void _vala_array_add3 (GalaDesktopIntegrationWindow* * array,
                       gint* length,
                       gint* size,
                       const GalaDesktopIntegrationWindow* value);
static void _vala_GalaDesktopIntegrationWindow_array_free (GalaDesktopIntegrationWindow * array,
                                                    gssize array_length);
VALA_EXTERN guint gala_desktop_integration_get_version (GalaDesktopIntegration* self);
static void gala_desktop_integration_finalize (GObject * obj);
static GType gala_desktop_integration_get_type_once (void);
static void _vala_gala_desktop_integration_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _dbus_gala_desktop_integration_get_running_applications (GalaDesktopIntegration* self,
                                                              GVariant* _parameters_,
                                                              GDBusMethodInvocation* invocation);
static void _dbus_gala_desktop_integration_get_windows (GalaDesktopIntegration* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void gala_desktop_integration_dbus_interface_method_call (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* method_name,
                                                          GVariant* parameters,
                                                          GDBusMethodInvocation* invocation,
                                                          gpointer user_data);
static GVariant* gala_desktop_integration_dbus_interface_get_property (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* property_name,
                                                                GError** error,
                                                                gpointer user_data);
static GVariant* _dbus_gala_desktop_integration_get_version (GalaDesktopIntegration* self);
static gboolean gala_desktop_integration_dbus_interface_set_property (GDBusConnection* connection,
                                                               const gchar* sender,
                                                               const gchar* object_path,
                                                               const gchar* interface_name,
                                                               const gchar* property_name,
                                                               GVariant* value,
                                                               GError** error,
                                                               gpointer user_data);
static void _dbus_gala_desktop_integration_running_applications_changed (GObject* _sender,
                                                                  gpointer* _data);
static void _dbus_gala_desktop_integration_windows_changed (GObject* _sender,
                                                     gpointer* _data);
static void _gala_desktop_integration_unregister_object (gpointer user_data);

static const GDBusArgInfo _gala_desktop_integration_dbus_arg_info_get_running_applications_result = {-1, "result", "a(sa{sv})", NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_get_running_applications_in[] = {NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_get_running_applications_out[] = {&_gala_desktop_integration_dbus_arg_info_get_running_applications_result, NULL};
static const GDBusMethodInfo _gala_desktop_integration_dbus_method_info_get_running_applications = {-1, "GetRunningApplications", (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_get_running_applications_in), (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_get_running_applications_out), NULL};
static const GDBusArgInfo _gala_desktop_integration_dbus_arg_info_get_windows_result = {-1, "result", "a(ta{sv})", NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_get_windows_in[] = {NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_get_windows_out[] = {&_gala_desktop_integration_dbus_arg_info_get_windows_result, NULL};
static const GDBusMethodInfo _gala_desktop_integration_dbus_method_info_get_windows = {-1, "GetWindows", (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_get_windows_in), (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_get_windows_out), NULL};
static const GDBusMethodInfo * const _gala_desktop_integration_dbus_method_info[] = {&_gala_desktop_integration_dbus_method_info_get_running_applications, &_gala_desktop_integration_dbus_method_info_get_windows, NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_running_applications_changed[] = {NULL};
static const GDBusSignalInfo _gala_desktop_integration_dbus_signal_info_running_applications_changed = {-1, "RunningApplicationsChanged", (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_running_applications_changed), NULL};
static const GDBusArgInfo * const _gala_desktop_integration_dbus_arg_info_windows_changed[] = {NULL};
static const GDBusSignalInfo _gala_desktop_integration_dbus_signal_info_windows_changed = {-1, "WindowsChanged", (GDBusArgInfo **) (&_gala_desktop_integration_dbus_arg_info_windows_changed), NULL};
static const GDBusSignalInfo * const _gala_desktop_integration_dbus_signal_info[] = {&_gala_desktop_integration_dbus_signal_info_running_applications_changed, &_gala_desktop_integration_dbus_signal_info_windows_changed, NULL};
static const GDBusPropertyInfo _gala_desktop_integration_dbus_property_info_version = {-1, "Version", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _gala_desktop_integration_dbus_property_info[] = {&_gala_desktop_integration_dbus_property_info_version, NULL};
static const GDBusInterfaceInfo _gala_desktop_integration_dbus_interface_info = {-1, "org.pantheon.gala.DesktopIntegration", (GDBusMethodInfo **) (&_gala_desktop_integration_dbus_method_info), (GDBusSignalInfo **) (&_gala_desktop_integration_dbus_signal_info), (GDBusPropertyInfo **) (&_gala_desktop_integration_dbus_property_info), NULL};
static const GDBusInterfaceVTable _gala_desktop_integration_dbus_interface_vtable = {gala_desktop_integration_dbus_interface_method_call, gala_desktop_integration_dbus_interface_get_property, gala_desktop_integration_dbus_interface_set_property};

static inline gpointer
gala_desktop_integration_get_instance_private (GalaDesktopIntegration* self)
{
	return G_STRUCT_MEMBER_P (self, GalaDesktopIntegration_private_offset);
}

static void
___lambda169_ (GalaDesktopIntegration* self)
{
	g_signal_emit (self, gala_desktop_integration_signals[GALA_DESKTOP_INTEGRATION_WINDOWS_CHANGED_SIGNAL], 0);
}

static void
____lambda169__gala_window_tracker_windows_changed (GalaWindowTracker* _sender,
                                                    gpointer self)
{
	___lambda169_ ((GalaDesktopIntegration*) self);
}

GalaDesktopIntegration*
gala_desktop_integration_construct (GType object_type,
                                    GalaWindowManager* wm)
{
	GalaDesktopIntegration * self = NULL;
	GalaWindowManagerGala* gala_wm = NULL;
	GalaWindowManagerGala* _tmp0_;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaDesktopIntegration*) g_object_new (object_type, NULL);
	self->priv->wm = wm;
	gala_wm = GALA_IS_WINDOW_MANAGER_GALA (wm) ? ((GalaWindowManagerGala*) wm) : NULL;
	_tmp0_ = gala_wm;
	if (_tmp0_ != NULL) {
		GalaWindowManagerGala* _tmp1_;
		GalaWindowTracker* _tmp2_;
		GalaWindowTracker* _tmp3_;
		_tmp1_ = gala_wm;
		_tmp2_ = gala_window_manager_gala_get_window_tracker (_tmp1_);
		_tmp3_ = _tmp2_;
		g_signal_connect_object (_tmp3_, "windows-changed", (GCallback) ____lambda169__gala_window_tracker_windows_changed, self, 0);
	}
	return self;
}

GalaDesktopIntegration*
gala_desktop_integration_new (GalaWindowManager* wm)
{
	return gala_desktop_integration_construct (GALA_TYPE_DESKTOP_INTEGRATION, wm);
}

static void
_g_variant_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}

static void
_vala_array_add2 (GalaDesktopIntegrationRunningApplication* * array,
                  gint* length,
                  gint* size,
                  const GalaDesktopIntegrationRunningApplication* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GalaDesktopIntegrationRunningApplication, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_GalaDesktopIntegrationRunningApplication_array_free (GalaDesktopIntegrationRunningApplication * array,
                                                           gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			gala_desktop_integration_running_application_destroy (&array[i]);
		}
	}
	g_free (array);
}

GalaDesktopIntegrationRunningApplication*
gala_desktop_integration_get_running_applications (GalaDesktopIntegration* self,
                                                   gint* result_length1,
                                                   GError** error)
{
	GalaDesktopIntegrationRunningApplication* returned_apps = NULL;
	GalaDesktopIntegrationRunningApplication* _tmp0_;
	gint returned_apps_length1;
	gint _returned_apps_size_;
	GList* apps = NULL;
	GalaAppSystem* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	GalaDesktopIntegrationRunningApplication* _tmp12_;
	gint _tmp12__length1;
	GalaDesktopIntegrationRunningApplication* _tmp13_;
	gint _tmp13__length1;
	GalaDesktopIntegrationRunningApplication* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (GalaDesktopIntegrationRunningApplication, 0);
	returned_apps = _tmp0_;
	returned_apps_length1 = 0;
	_returned_apps_size_ = returned_apps_length1;
	_tmp1_ = gala_app_system_get_default ();
	_tmp2_ = gala_app_system_get_running_apps (_tmp1_);
	apps = _tmp2_;
	_tmp3_ = apps;
	{
		GList* app_collection = NULL;
		GList* app_it = NULL;
		app_collection = _tmp3_;
		for (app_it = app_collection; app_it != NULL; app_it = app_it->next) {
			GalaApp* app = NULL;
			app = (GalaApp*) app_it->data;
			{
				GalaApp* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				GHashFunc _tmp8_;
				GEqualFunc _tmp9_;
				GHashTable* _tmp10_;
				GalaDesktopIntegrationRunningApplication _tmp11_ = {0};
				_tmp4_ = app;
				_tmp5_ = gala_app_get_id (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_strdup (_tmp6_);
				_tmp8_ = g_str_hash;
				_tmp9_ = g_str_equal;
				_tmp10_ = g_hash_table_new_full (_tmp8_, _tmp9_, NULL, _g_variant_unref0_);
				memset (&_tmp11_, 0, sizeof (GalaDesktopIntegrationRunningApplication));
				_g_free0 (_tmp11_.app_id);
				_tmp11_.app_id = _tmp7_;
				_g_hash_table_unref0 (_tmp11_.details);
				_tmp11_.details = _tmp10_;
				_vala_array_add2 (&returned_apps, &returned_apps_length1, &_returned_apps_size_, &_tmp11_);
			}
		}
	}
	_tmp12_ = returned_apps;
	_tmp12__length1 = returned_apps_length1;
	returned_apps = NULL;
	returned_apps_length1 = 0;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = _tmp12__length1;
	if (result_length1) {
		*result_length1 = _tmp13__length1;
	}
	result = _tmp13_;
	(apps == NULL) ? NULL : (apps = (g_list_free (apps), NULL));
	returned_apps = (_vala_GalaDesktopIntegrationRunningApplication_array_free (returned_apps, returned_apps_length1), NULL);
	return result;
}

static gboolean
gala_desktop_integration_is_eligible_window (GalaDesktopIntegration* self,
                                             MetaWindow* window)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (window != NULL, FALSE);
	if (meta_window_is_override_redirect (window)) {
		result = FALSE;
		return result;
	}
	switch (meta_window_get_window_type (window)) {
		case META_WINDOW_NORMAL:
		case META_WINDOW_DIALOG:
		case META_WINDOW_MODAL_DIALOG:
		case META_WINDOW_UTILITY:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static void
_vala_array_add3 (GalaDesktopIntegrationWindow* * array,
                  gint* length,
                  gint* size,
                  const GalaDesktopIntegrationWindow* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GalaDesktopIntegrationWindow, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static void
_vala_GalaDesktopIntegrationWindow_array_free (GalaDesktopIntegrationWindow * array,
                                               gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			gala_desktop_integration_window_destroy (&array[i]);
		}
	}
	g_free (array);
}

GalaDesktopIntegrationWindow*
gala_desktop_integration_get_windows (GalaDesktopIntegration* self,
                                      gint* result_length1,
                                      GError** error)
{
	GalaDesktopIntegrationWindow* returned_windows = NULL;
	GalaDesktopIntegrationWindow* _tmp0_;
	gint returned_windows_length1;
	gint _returned_windows_size_;
	GList* apps = NULL;
	GalaAppSystem* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	GalaDesktopIntegrationWindow* _tmp54_;
	gint _tmp54__length1;
	GalaDesktopIntegrationWindow* _tmp55_;
	gint _tmp55__length1;
	GalaDesktopIntegrationWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (GalaDesktopIntegrationWindow, 0);
	returned_windows = _tmp0_;
	returned_windows_length1 = 0;
	_returned_windows_size_ = returned_windows_length1;
	_tmp1_ = gala_app_system_get_default ();
	_tmp2_ = gala_app_system_get_running_apps (_tmp1_);
	apps = _tmp2_;
	_tmp3_ = apps;
	{
		GList* app_collection = NULL;
		GList* app_it = NULL;
		app_collection = _tmp3_;
		for (app_it = app_collection; app_it != NULL; app_it = app_it->next) {
			GalaApp* app = NULL;
			app = (GalaApp*) app_it->data;
			{
				GalaApp* _tmp4_;
				GSList* _tmp5_;
				_tmp4_ = app;
				_tmp5_ = gala_app_get_windows (_tmp4_);
				{
					GSList* window_collection = NULL;
					GSList* window_it = NULL;
					window_collection = _tmp5_;
					for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
						MetaWindow* window = NULL;
						window = (MetaWindow*) window_it->data;
						{
							MetaWindow* _tmp6_;
							GHashTable* properties = NULL;
							GHashFunc _tmp7_;
							GEqualFunc _tmp8_;
							GHashTable* _tmp9_;
							MetaRectangle frame_rect = {0};
							MetaWindow* _tmp10_;
							MetaRectangle _tmp11_ = {0};
							const gchar* title = NULL;
							MetaWindow* _tmp12_;
							const gchar* _tmp13_;
							const gchar* wm_class = NULL;
							MetaWindow* _tmp14_;
							const gchar* _tmp15_;
							const gchar* sandboxed_app_id = NULL;
							MetaWindow* _tmp16_;
							const gchar* _tmp17_;
							GHashTable* _tmp18_;
							GalaApp* _tmp19_;
							const gchar* _tmp20_;
							const gchar* _tmp21_;
							GVariant* _tmp22_;
							GHashTable* _tmp23_;
							MetaWindow* _tmp24_;
							GVariant* _tmp25_;
							GHashTable* _tmp26_;
							MetaWindow* _tmp27_;
							GVariant* _tmp28_;
							GHashTable* _tmp29_;
							MetaWindow* _tmp30_;
							GVariant* _tmp31_;
							GHashTable* _tmp32_;
							MetaRectangle _tmp33_;
							GVariant* _tmp34_;
							GHashTable* _tmp35_;
							MetaRectangle _tmp36_;
							GVariant* _tmp37_;
							const gchar* _tmp38_;
							const gchar* _tmp42_;
							const gchar* _tmp46_;
							MetaWindow* _tmp50_;
							GHashTable* _tmp51_;
							GHashTable* _tmp52_;
							GalaDesktopIntegrationWindow _tmp53_ = {0};
							_tmp6_ = window;
							if (!gala_desktop_integration_is_eligible_window (self, _tmp6_)) {
								continue;
							}
							_tmp7_ = g_str_hash;
							_tmp8_ = g_str_equal;
							_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, NULL, _g_variant_unref0_);
							properties = _tmp9_;
							_tmp10_ = window;
							meta_window_get_frame_rect (_tmp10_, &_tmp11_);
							frame_rect = _tmp11_;
							_tmp12_ = window;
							_tmp13_ = meta_window_get_title (_tmp12_);
							title = _tmp13_;
							_tmp14_ = window;
							_tmp15_ = meta_window_get_wm_class (_tmp14_);
							wm_class = _tmp15_;
							_tmp16_ = window;
							_tmp17_ = meta_window_get_sandboxed_app_id (_tmp16_);
							sandboxed_app_id = _tmp17_;
							_tmp18_ = properties;
							_tmp19_ = app;
							_tmp20_ = gala_app_get_id (_tmp19_);
							_tmp21_ = _tmp20_;
							_tmp22_ = g_variant_new_string (_tmp21_);
							g_variant_ref_sink (_tmp22_);
							g_hash_table_insert (_tmp18_, "app-id", _tmp22_);
							_tmp23_ = properties;
							_tmp24_ = window;
							_tmp25_ = g_variant_new_uint32 ((guint32) meta_window_get_client_type (_tmp24_));
							g_variant_ref_sink (_tmp25_);
							g_hash_table_insert (_tmp23_, "client-type", _tmp25_);
							_tmp26_ = properties;
							_tmp27_ = window;
							_tmp28_ = g_variant_new_boolean (meta_window_is_hidden (_tmp27_));
							g_variant_ref_sink (_tmp28_);
							g_hash_table_insert (_tmp26_, "is-hidden", _tmp28_);
							_tmp29_ = properties;
							_tmp30_ = window;
							_tmp31_ = g_variant_new_boolean (meta_window_has_focus (_tmp30_));
							g_variant_ref_sink (_tmp31_);
							g_hash_table_insert (_tmp29_, "has-focus", _tmp31_);
							_tmp32_ = properties;
							_tmp33_ = frame_rect;
							_tmp34_ = g_variant_new_uint32 ((guint32) _tmp33_.width);
							g_variant_ref_sink (_tmp34_);
							g_hash_table_insert (_tmp32_, "width", _tmp34_);
							_tmp35_ = properties;
							_tmp36_ = frame_rect;
							_tmp37_ = g_variant_new_uint32 ((guint32) _tmp36_.height);
							g_variant_ref_sink (_tmp37_);
							g_hash_table_insert (_tmp35_, "height", _tmp37_);
							_tmp38_ = title;
							if (_tmp38_ != NULL) {
								GHashTable* _tmp39_;
								const gchar* _tmp40_;
								GVariant* _tmp41_;
								_tmp39_ = properties;
								_tmp40_ = title;
								_tmp41_ = g_variant_new_string (_tmp40_);
								g_variant_ref_sink (_tmp41_);
								g_hash_table_insert (_tmp39_, "title", _tmp41_);
							}
							_tmp42_ = wm_class;
							if (_tmp42_ != NULL) {
								GHashTable* _tmp43_;
								const gchar* _tmp44_;
								GVariant* _tmp45_;
								_tmp43_ = properties;
								_tmp44_ = wm_class;
								_tmp45_ = g_variant_new_string (_tmp44_);
								g_variant_ref_sink (_tmp45_);
								g_hash_table_insert (_tmp43_, "wm-class", _tmp45_);
							}
							_tmp46_ = sandboxed_app_id;
							if (_tmp46_ != NULL) {
								GHashTable* _tmp47_;
								const gchar* _tmp48_;
								GVariant* _tmp49_;
								_tmp47_ = properties;
								_tmp48_ = sandboxed_app_id;
								_tmp49_ = g_variant_new_string (_tmp48_);
								g_variant_ref_sink (_tmp49_);
								g_hash_table_insert (_tmp47_, "sandboxed-app-id", _tmp49_);
							}
							_tmp50_ = window;
							_tmp51_ = properties;
							_tmp52_ = _g_hash_table_ref0 (_tmp51_);
							memset (&_tmp53_, 0, sizeof (GalaDesktopIntegrationWindow));
							_tmp53_.uid = meta_window_get_id (_tmp50_);
							_g_hash_table_unref0 (_tmp53_.properties);
							_tmp53_.properties = _tmp52_;
							_vala_array_add3 (&returned_windows, &returned_windows_length1, &_returned_windows_size_, &_tmp53_);
							_g_hash_table_unref0 (properties);
						}
					}
				}
			}
		}
	}
	_tmp54_ = returned_windows;
	_tmp54__length1 = returned_windows_length1;
	returned_windows = NULL;
	returned_windows_length1 = 0;
	_tmp55_ = _tmp54_;
	_tmp55__length1 = _tmp54__length1;
	if (result_length1) {
		*result_length1 = _tmp55__length1;
	}
	result = _tmp55_;
	(apps == NULL) ? NULL : (apps = (g_list_free (apps), NULL));
	returned_windows = (_vala_GalaDesktopIntegrationWindow_array_free (returned_windows, returned_windows_length1), NULL);
	return result;
}

guint
gala_desktop_integration_get_version (GalaDesktopIntegration* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_version;
	return result;
}

void
gala_desktop_integration_running_application_copy (const GalaDesktopIntegrationRunningApplication* self,
                                                   GalaDesktopIntegrationRunningApplication* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	_tmp0_ = (*self).app_id;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).app_id);
	(*dest).app_id = _tmp1_;
	_tmp2_ = (*self).details;
	_tmp3_ = _g_hash_table_ref0 (_tmp2_);
	_g_hash_table_unref0 ((*dest).details);
	(*dest).details = _tmp3_;
}

void
gala_desktop_integration_running_application_destroy (GalaDesktopIntegrationRunningApplication* self)
{
	_g_free0 ((*self).app_id);
	_g_hash_table_unref0 ((*self).details);
}

GalaDesktopIntegrationRunningApplication*
gala_desktop_integration_running_application_dup (const GalaDesktopIntegrationRunningApplication* self)
{
	GalaDesktopIntegrationRunningApplication* dup;
	dup = g_new0 (GalaDesktopIntegrationRunningApplication, 1);
	gala_desktop_integration_running_application_copy (self, dup);
	return dup;
}

void
gala_desktop_integration_running_application_free (GalaDesktopIntegrationRunningApplication* self)
{
	gala_desktop_integration_running_application_destroy (self);
	g_free (self);
}

static GType
gala_desktop_integration_running_application_get_type_once (void)
{
	GType gala_desktop_integration_running_application_type_id;
	gala_desktop_integration_running_application_type_id = g_boxed_type_register_static ("GalaDesktopIntegrationRunningApplication", (GBoxedCopyFunc) gala_desktop_integration_running_application_dup, (GBoxedFreeFunc) gala_desktop_integration_running_application_free);
	return gala_desktop_integration_running_application_type_id;
}

GType
gala_desktop_integration_running_application_get_type (void)
{
	static volatile gsize gala_desktop_integration_running_application_type_id__once = 0;
	if (g_once_init_enter (&gala_desktop_integration_running_application_type_id__once)) {
		GType gala_desktop_integration_running_application_type_id;
		gala_desktop_integration_running_application_type_id = gala_desktop_integration_running_application_get_type_once ();
		g_once_init_leave (&gala_desktop_integration_running_application_type_id__once, gala_desktop_integration_running_application_type_id);
	}
	return gala_desktop_integration_running_application_type_id__once;
}

void
gala_desktop_integration_window_copy (const GalaDesktopIntegrationWindow* self,
                                      GalaDesktopIntegrationWindow* dest)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	(*dest).uid = (*self).uid;
	_tmp0_ = (*self).properties;
	_tmp1_ = _g_hash_table_ref0 (_tmp0_);
	_g_hash_table_unref0 ((*dest).properties);
	(*dest).properties = _tmp1_;
}

void
gala_desktop_integration_window_destroy (GalaDesktopIntegrationWindow* self)
{
	_g_hash_table_unref0 ((*self).properties);
}

GalaDesktopIntegrationWindow*
gala_desktop_integration_window_dup (const GalaDesktopIntegrationWindow* self)
{
	GalaDesktopIntegrationWindow* dup;
	dup = g_new0 (GalaDesktopIntegrationWindow, 1);
	gala_desktop_integration_window_copy (self, dup);
	return dup;
}

void
gala_desktop_integration_window_free (GalaDesktopIntegrationWindow* self)
{
	gala_desktop_integration_window_destroy (self);
	g_free (self);
}

static GType
gala_desktop_integration_window_get_type_once (void)
{
	GType gala_desktop_integration_window_type_id;
	gala_desktop_integration_window_type_id = g_boxed_type_register_static ("GalaDesktopIntegrationWindow", (GBoxedCopyFunc) gala_desktop_integration_window_dup, (GBoxedFreeFunc) gala_desktop_integration_window_free);
	return gala_desktop_integration_window_type_id;
}

GType
gala_desktop_integration_window_get_type (void)
{
	static volatile gsize gala_desktop_integration_window_type_id__once = 0;
	if (g_once_init_enter (&gala_desktop_integration_window_type_id__once)) {
		GType gala_desktop_integration_window_type_id;
		gala_desktop_integration_window_type_id = gala_desktop_integration_window_get_type_once ();
		g_once_init_leave (&gala_desktop_integration_window_type_id__once, gala_desktop_integration_window_type_id);
	}
	return gala_desktop_integration_window_type_id__once;
}

static void
gala_desktop_integration_class_init (GalaDesktopIntegrationClass * klass,
                                     gpointer klass_data)
{
	gala_desktop_integration_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaDesktopIntegration_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_desktop_integration_get_property;
	G_OBJECT_CLASS (klass)->finalize = gala_desktop_integration_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_DESKTOP_INTEGRATION_VERSION_PROPERTY, gala_desktop_integration_properties[GALA_DESKTOP_INTEGRATION_VERSION_PROPERTY] = g_param_spec_uint ("version", "version", "version", 0, G_MAXUINT, (guint) 1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gala_desktop_integration_signals[GALA_DESKTOP_INTEGRATION_RUNNING_APPLICATIONS_CHANGED_SIGNAL] = g_signal_new ("running-applications-changed", GALA_TYPE_DESKTOP_INTEGRATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gala_desktop_integration_signals[GALA_DESKTOP_INTEGRATION_WINDOWS_CHANGED_SIGNAL] = g_signal_new ("windows-changed", GALA_TYPE_DESKTOP_INTEGRATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_desktop_integration_instance_init (GalaDesktopIntegration * self,
                                        gpointer klass)
{
	self->priv = gala_desktop_integration_get_instance_private (self);
	self->priv->_version = (guint) 1;
}

static void
gala_desktop_integration_finalize (GObject * obj)
{
	GalaDesktopIntegration * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_DESKTOP_INTEGRATION, GalaDesktopIntegration);
	G_OBJECT_CLASS (gala_desktop_integration_parent_class)->finalize (obj);
}

static GType
gala_desktop_integration_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaDesktopIntegrationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_desktop_integration_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaDesktopIntegration), 0, (GInstanceInitFunc) gala_desktop_integration_instance_init, NULL };
	GType gala_desktop_integration_type_id;
	gala_desktop_integration_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaDesktopIntegration", &g_define_type_info, 0);
	g_type_set_qdata (gala_desktop_integration_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) gala_desktop_integration_register_object);
	GalaDesktopIntegration_private_offset = g_type_add_instance_private (gala_desktop_integration_type_id, sizeof (GalaDesktopIntegrationPrivate));
	return gala_desktop_integration_type_id;
}

GType
gala_desktop_integration_get_type (void)
{
	static volatile gsize gala_desktop_integration_type_id__once = 0;
	if (g_once_init_enter (&gala_desktop_integration_type_id__once)) {
		GType gala_desktop_integration_type_id;
		gala_desktop_integration_type_id = gala_desktop_integration_get_type_once ();
		g_once_init_leave (&gala_desktop_integration_type_id__once, gala_desktop_integration_type_id);
	}
	return gala_desktop_integration_type_id__once;
}

static void
_vala_gala_desktop_integration_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	GalaDesktopIntegration * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_DESKTOP_INTEGRATION, GalaDesktopIntegration);
	switch (property_id) {
		case GALA_DESKTOP_INTEGRATION_VERSION_PROPERTY:
		g_value_set_uint (value, gala_desktop_integration_get_version (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_dbus_gala_desktop_integration_get_running_applications (GalaDesktopIntegration* self,
                                                         GVariant* _parameters_,
                                                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GalaDesktopIntegrationRunningApplication* result;
	gint result_length1 = 0;
	GalaDesktopIntegrationRunningApplication* _tmp36_;
	GVariantBuilder _tmp37_;
	gint _tmp38_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = gala_desktop_integration_get_running_applications (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp36_ = result;
	g_variant_builder_init (&_tmp37_, G_VARIANT_TYPE ("a(sa{sv})"));
	for (_tmp38_ = 0; _tmp38_ < result_length1; _tmp38_++) {
		GVariantBuilder _tmp39_;
		GVariantBuilder _tmp40_;
		GHashTableIter _tmp41_;
		gpointer _tmp42_;
		gpointer _tmp43_;
		g_variant_builder_init (&_tmp39_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp39_, g_variant_new_string ((*_tmp36_).app_id));
		g_hash_table_iter_init (&_tmp41_, (*_tmp36_).details);
		g_variant_builder_init (&_tmp40_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp41_, &_tmp42_, &_tmp43_)) {
			const gchar* _key;
			GVariant* _value;
			_key = (const gchar*) _tmp42_;
			_value = (GVariant*) _tmp43_;
			g_variant_builder_add (&_tmp40_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp39_, g_variant_builder_end (&_tmp40_));
		g_variant_builder_add_value (&_tmp37_, g_variant_builder_end (&_tmp39_));
		_tmp36_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp37_));
	result = (_vala_GalaDesktopIntegrationRunningApplication_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_gala_desktop_integration_get_windows (GalaDesktopIntegration* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GalaDesktopIntegrationWindow* result;
	gint result_length1 = 0;
	GalaDesktopIntegrationWindow* _tmp44_;
	GVariantBuilder _tmp45_;
	gint _tmp46_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = gala_desktop_integration_get_windows (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp44_ = result;
	g_variant_builder_init (&_tmp45_, G_VARIANT_TYPE ("a(ta{sv})"));
	for (_tmp46_ = 0; _tmp46_ < result_length1; _tmp46_++) {
		GVariantBuilder _tmp47_;
		GVariantBuilder _tmp48_;
		GHashTableIter _tmp49_;
		gpointer _tmp50_;
		gpointer _tmp51_;
		g_variant_builder_init (&_tmp47_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp47_, g_variant_new_uint64 ((*_tmp44_).uid));
		g_hash_table_iter_init (&_tmp49_, (*_tmp44_).properties);
		g_variant_builder_init (&_tmp48_, G_VARIANT_TYPE ("a{sv}"));
		while (g_hash_table_iter_next (&_tmp49_, &_tmp50_, &_tmp51_)) {
			const gchar* _key;
			GVariant* _value;
			_key = (const gchar*) _tmp50_;
			_value = (GVariant*) _tmp51_;
			g_variant_builder_add (&_tmp48_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
		}
		g_variant_builder_add_value (&_tmp47_, g_variant_builder_end (&_tmp48_));
		g_variant_builder_add_value (&_tmp45_, g_variant_builder_end (&_tmp47_));
		_tmp44_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp45_));
	result = (_vala_GalaDesktopIntegrationWindow_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
gala_desktop_integration_dbus_interface_method_call (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* method_name,
                                                     GVariant* parameters,
                                                     GDBusMethodInvocation* invocation,
                                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GetRunningApplications") == 0) {
		_dbus_gala_desktop_integration_get_running_applications (object, parameters, invocation);
	} else if (strcmp (method_name, "GetWindows") == 0) {
		_dbus_gala_desktop_integration_get_windows (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_gala_desktop_integration_get_version (GalaDesktopIntegration* self)
{
	guint result;
	GVariant* _reply;
	result = gala_desktop_integration_get_version (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}

static GVariant*
gala_desktop_integration_dbus_interface_get_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GError** error,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Version") == 0) {
		return _dbus_gala_desktop_integration_get_version (object);
	}
	return NULL;
}

static gboolean
gala_desktop_integration_dbus_interface_set_property (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* property_name,
                                                      GVariant* value,
                                                      GError** error,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_gala_desktop_integration_running_applications_changed (GObject* _sender,
                                                             gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.pantheon.gala.DesktopIntegration", "RunningApplicationsChanged", _arguments, NULL);
}

static void
_dbus_gala_desktop_integration_windows_changed (GObject* _sender,
                                                gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.pantheon.gala.DesktopIntegration", "WindowsChanged", _arguments, NULL);
}

guint
gala_desktop_integration_register_object (gpointer object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_gala_desktop_integration_dbus_interface_info), &_gala_desktop_integration_dbus_interface_vtable, data, _gala_desktop_integration_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "running-applications-changed", (GCallback) _dbus_gala_desktop_integration_running_applications_changed, data);
	g_signal_connect (object, "windows-changed", (GCallback) _dbus_gala_desktop_integration_windows_changed, data);
	return result;
}

static void
_gala_desktop_integration_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_gala_desktop_integration_running_applications_changed, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_gala_desktop_integration_windows_changed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

