# LinearAlgebraForCAP, single 1
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("linearalgebraforcap01.tst");

# doc/_Chapter_Examples_and_Tests.xml:10-255
gap> Q := HomalgFieldOfRationals();;
gap> a := VectorSpaceObject( 3, Q );
<A vector space object over Q of dimension 3>
gap> HasIsProjective( a ) and IsProjective( a );
true
gap> vec := MatrixCategory( Q );;
gap> ap := 3/vec;;
gap> IsEqualForObjects( a, ap );
true
gap> b := VectorSpaceObject( 4, Q );
<A vector space object over Q of dimension 4>
gap> homalg_matrix := HomalgMatrix( [ [ 1, 0, 0, 0 ],
>                                   [ 0, 1, 0, -1 ],
>                                   [ -1, 0, 2, 1 ] ], 3, 4, Q );
<A 3 x 4 matrix over an internal ring>
gap> alpha := VectorSpaceMorphism( a, homalg_matrix, b );
<A morphism in Category of matrices over Q>
gap> Display( alpha );
[ [   1,   0,   0,   0 ],
  [   0,   1,   0,  -1 ],
  [  -1,   0,   2,   1 ] ]

A morphism in Category of matrices over Q
gap> alphap := homalg_matrix/vec;;
gap> IsCongruentForMorphisms( alpha, alphap );
true
gap> homalg_matrix := HomalgMatrix( [ [ 1, 1, 0, 0 ],
>                                   [ 0, 1, 0, -1 ],
>                                   [ -1, 0, 2, 1 ] ], 3, 4, Q );
<A 3 x 4 matrix over an internal ring>
gap> beta := VectorSpaceMorphism( a, homalg_matrix, b );
<A morphism in Category of matrices over Q>
gap> CokernelObject( alpha );
<A vector space object over Q of dimension 1>
gap> c := CokernelProjection( alpha );;
gap> Display( c );
[ [     0 ],
  [     1 ],
  [  -1/2 ],
  [     1 ] ]

A split epimorphism in Category of matrices over Q
gap> gamma := UniversalMorphismIntoDirectSum( [ c, c ] );;
gap> Display( gamma );
[ [     0,     0 ],
  [     1,     1 ],
  [  -1/2,  -1/2 ],
  [     1,     1 ] ]

A morphism in Category of matrices over Q
gap> colift := CokernelColift( alpha, gamma );;
gap> IsEqualForMorphisms( PreCompose( c, colift ), gamma );
true
gap> FiberProduct( alpha, beta );
<A vector space object over Q of dimension 2>
gap> F := FiberProduct( alpha, beta );
<A vector space object over Q of dimension 2>
gap> p1 := ProjectionInFactorOfFiberProduct( [ alpha, beta ], 1 );
<A morphism in Category of matrices over Q>
gap> Display( PreCompose( p1, alpha ) );
[ [   0,   1,   0,  -1 ],
  [  -1,   0,   2,   1 ] ]

A morphism in Category of matrices over Q
gap> Pushout( alpha, beta );
<A vector space object over Q of dimension 5>
gap> i1 := InjectionOfCofactorOfPushout( [ alpha, beta ], 1 );
<A morphism in Category of matrices over Q>
gap> i2 := InjectionOfCofactorOfPushout( [ alpha, beta ], 2 );
<A morphism in Category of matrices over Q>
gap> u := UniversalMorphismFromDirectSum( [ b, b ], [ i1, i2 ] );
<A morphism in Category of matrices over Q>
gap> Display( u );
[ [     0,     1,     1,     0,     0 ],
  [     1,     0,     1,     0,    -1 ],
  [  -1/2,     0,   1/2,     1,   1/2 ],
  [     1,     0,     0,     0,     0 ],
  [     0,     1,     0,     0,     0 ],
  [     0,     0,     1,     0,     0 ],
  [     0,     0,     0,     1,     0 ],
  [     0,     0,     0,     0,     1 ] ]

A morphism in Category of matrices over Q
gap> KernelObjectFunctorial( u, IdentityMorphism( Source( u ) ), u ) = IdentityMorphism( VectorSpaceObject( 3, Q ) );
true
gap> IsZero( CokernelObjectFunctorial( u, IdentityMorphism( Range( u ) ), u ) );
true
gap> DirectProductFunctorial( [ u, u ] ) = DirectSumFunctorial( [ u, u ] );
true
gap> CoproductFunctorial( [ u, u ] ) = DirectSumFunctorial( [ u, u ] );
true
gap> IsOne( FiberProductFunctorial( [ u, u ], [ IdentityMorphism( Source( u ) ), IdentityMorphism( Source( u ) ) ], [ u, u ] ) );
true
gap> IsOne( PushoutFunctorial( [ u, u ], [ IdentityMorphism( Range( u ) ), IdentityMorphism( Range( u ) ) ], [ u, u ] ) );
true
gap> IsCongruentForMorphisms( (1/2) * alpha, alpha * (1/2) );
true
gap> Dimension( HomomorphismStructureOnObjects( a, b ) ) = Dimension( a ) * Dimension( b );
true
gap> IsCongruentForMorphisms(
>     PreCompose( [ u, DualOnMorphisms( i1 ), DualOnMorphisms( alpha ) ] ),
>     InterpretMorphismFromDistinguishedObjectToHomomorphismStructureAsMorphism( Source( u ), Source( alpha ),
>          PreCompose(
>              InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructure( DualOnMorphisms( i1 ) ),
>              HomomorphismStructureOnMorphisms( u, DualOnMorphisms( alpha ) )
>          )
>     )
> );
true
gap> alpha_op := Opposite( alpha );
<A morphism in Opposite of Category of matrices over Q>
gap> basis := BasisOfExternalHom( Source( alpha_op ), Range( alpha_op ) );;
gap> coeffs := CoefficientsOfMorphism( alpha_op );
[ 1, 0, 0, 0, 0, 1, 0, -1, -1, 0, 2, 1 ]
gap> IsEqualForMorphisms( alpha_op, coeffs * basis );
true
gap> vec := CapCategory( alpha );;
gap> t := TensorUnit( vec );;
gap> z := ZeroObject( vec );;
gap> IsCongruentForMorphisms(
>     ZeroObjectFunctorial( vec ),
>     InterpretMorphismFromDistinguishedObjectToHomomorphismStructureAsMorphism( z, z, ZeroMorphism( t, z ) )
> );
true
gap> IsCongruentForMorphisms(
>     ZeroObjectFunctorial( vec ),
>     InterpretMorphismFromDistinguishedObjectToHomomorphismStructureAsMorphism(
>         z, z,
>         InterpretMorphismAsMorphismFromDistinguishedObjectToHomomorphismStructure( ZeroObjectFunctorial( vec ) )
>     )
> );
true
gap> right_side := PreCompose( [ i1, DualOnMorphisms( u ), u ] );;
gap> x := SolveLinearSystemInAbCategory( [ [ i1 ] ], [ [ u ] ], [ right_side ] )[1];;
gap> IsCongruentForMorphisms( PreCompose( [ i1, x, u ] ), right_side );
true
gap> a_otimes_b := TensorProductOnObjects( a, b );
<A vector space object over Q of dimension 12>
gap> hom_ab := InternalHomOnObjects( a, b );
<A vector space object over Q of dimension 12>
gap> cohom_ab := InternalCoHomOnObjects( a, b );
<A vector space object over Q of dimension 12>
gap> hom_ab = cohom_ab;
true
gap> 1_ab := VectorSpaceMorphism(
>           a_otimes_b,
>           HomalgIdentityMatrix( Dimension( a_otimes_b ), Q ),
>           a_otimes_b
>           );
<A morphism in Category of matrices over Q>
gap> 1_hom_ab := VectorSpaceMorphism(
>               hom_ab,
>               HomalgIdentityMatrix( Dimension( hom_ab ), Q ),
>               hom_ab
>             );
<A morphism in Category of matrices over Q>
gap> 1_cohom_ab := VectorSpaceMorphism(
>                 cohom_ab,
>                 HomalgIdentityMatrix( Dimension( cohom_ab ), Q ),
>                 cohom_ab
>               );
<A morphism in Category of matrices over Q>
gap> ev_ab := EvaluationMorphism( a, b );
<A morphism in Category of matrices over Q>
gap> coev_ab := CoevaluationMorphism( a, b );
<A morphism in Category of matrices over Q>
gap> cocl_ev_ab := CoclosedEvaluationMorphism( a, b );
<A morphism in Category of matrices over Q>
gap> cocl_ev_ba := CoclosedEvaluationMorphism( b, a );
<A morphism in Category of matrices over Q>
gap> cocl_coev_ab := CoclosedCoevaluationMorphism( a, b );
<A morphism in Category of matrices over Q>
gap> UnderlyingMatrix( ev_ab ) = TransposedMatrix( UnderlyingMatrix( cocl_ev_ba ) );
true
gap> UnderlyingMatrix( coev_ab ) = TransposedMatrix( UnderlyingMatrix( cocl_coev_ab ) );
true
gap> tensor_hom_adj_1_hom_ab := InternalHomToTensorProductAdjunctionMap( a, b, 1_hom_ab );
<A morphism in Category of matrices over Q>
gap> cohom_tensor_adj_1_cohom_ab := InternalCoHomToTensorProductAdjunctionMap( a, b, 1_cohom_ab );
<A morphism in Category of matrices over Q>
gap> tensor_hom_adj_1_ab := TensorProductToInternalHomAdjunctionMap( a, b, 1_ab );
<A morphism in Category of matrices over Q>
gap> cohom_tensor_adj_1_ab := TensorProductToInternalCoHomAdjunctionMap( a, b, 1_ab );
<A morphism in Category of matrices over Q>
gap> ev_ab = tensor_hom_adj_1_hom_ab;
true
gap> cocl_ev_ab = cohom_tensor_adj_1_cohom_ab;
true
gap> coev_ab = tensor_hom_adj_1_ab;
true
gap> cocl_coev_ab = cohom_tensor_adj_1_ab;
true
gap> c := VectorSpaceObject(2,Q);
<A vector space object over Q of dimension 2>
gap> d := VectorSpaceObject(1,Q);
<A vector space object over Q of dimension 1>
gap> pre_compose := MonoidalPreComposeMorphism( a, b, c );
<A morphism in Category of matrices over Q>
gap> post_compose := MonoidalPostComposeMorphism( a, b, c );
<A morphism in Category of matrices over Q>
gap> pre_cocompose := MonoidalPreCoComposeMorphism( c, b, a );
<A morphism in Category of matrices over Q>
gap> post_cocompose := MonoidalPostCoComposeMorphism( c, b, a );
<A morphism in Category of matrices over Q>
gap> UnderlyingMatrix( pre_compose ) = TransposedMatrix( UnderlyingMatrix( pre_cocompose ) );
true
gap> UnderlyingMatrix( post_compose ) = TransposedMatrix( UnderlyingMatrix( post_cocompose ) );
true
gap> tp_hom_comp := TensorProductInternalHomCompatibilityMorphism( [ a, b, c, d ] );
<A morphism in Category of matrices over Q>
gap> cohom_tp_comp := InternalCoHomTensorProductCompatibilityMorphism( [ b, d, a, c ] );
<A morphism in Category of matrices over Q>
gap> UnderlyingMatrix( tp_hom_comp ) = TransposedMatrix( UnderlyingMatrix( cohom_tp_comp ) );
true
gap> lambda := LambdaIntroduction( alpha );
<A morphism in Category of matrices over Q>
gap> lambda_elim := LambdaElimination( a, b, lambda );
<A morphism in Category of matrices over Q>
gap> alpha = lambda_elim;
true
gap> alpha_op := VectorSpaceMorphism( b, TransposedMatrix( UnderlyingMatrix( alpha ) ), a );
<A morphism in Category of matrices over Q>
gap> colambda := CoLambdaIntroduction( alpha_op );
<A morphism in Category of matrices over Q>
gap> colambda_elim := CoLambdaElimination( b, a, colambda );
<A morphism in Category of matrices over Q>
gap> alpha_op = colambda_elim;
true
gap> UnderlyingMatrix( lambda ) = TransposedMatrix( UnderlyingMatrix( colambda ) );
true
gap> delta := PreCompose( colambda, lambda);
<A morphism in Category of matrices over Q>
gap> Display( TraceMap( delta ) );
[ [  9 ] ]

A morphism in Category of matrices over Q
gap> Display( CoTraceMap( delta ) );
[ [  9 ] ]

A morphism in Category of matrices over Q
gap> TraceMap( delta ) = CoTraceMap( delta );
true
gap> RankMorphism( a ) = CoRankMorphism( a );
true

#
gap> STOP_TEST("linearalgebraforcap01.tst", 1);
