/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.boot.loader.tools.Layer;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class LayersIndex {
    private final Iterable<Layer> layers;
    private final Node root = new Node();

    public LayersIndex(Layer ... layers) {
        this(Arrays.asList(layers));
    }

    public LayersIndex(Iterable<Layer> layers) {
        this.layers = layers;
    }

    public void add(Layer layer, String name) {
        String[] segments = name.split("/");
        Node node = this.root;
        for (int i = 0; i < segments.length; ++i) {
            boolean isDirectory = i < segments.length - 1;
            node = node.updateOrAddNode(segments[i], isDirectory, layer);
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        LinkedMultiValueMap index = new LinkedMultiValueMap();
        this.root.buildIndex("", (MultiValueMap<Layer, String>)index);
        index.values().forEach(Collections::sort);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        for (Layer layer : this.layers) {
            List names = (List)index.get((Object)layer);
            writer.write("- \"" + layer + "\":\n");
            if (names == null) continue;
            for (String name : names) {
                writer.write("  - \"" + name + "\"\n");
            }
        }
        writer.flush();
    }

    private static class Node {
        private final String name;
        private final Set<Layer> layers;
        private final List<Node> children = new ArrayList<Node>();

        Node() {
            this.name = "";
            this.layers = new HashSet<Layer>();
        }

        Node(String name, Layer layer) {
            this.name = name;
            this.layers = new HashSet<Layer>(Collections.singleton(layer));
        }

        Node updateOrAddNode(String segment, boolean isDirectory, Layer layer) {
            String name = segment + (isDirectory ? "/" : "");
            for (Node child : this.children) {
                if (!name.equals(child.name)) continue;
                child.layers.add(layer);
                return child;
            }
            Node child = new Node(name, layer);
            this.children.add(child);
            return child;
        }

        void buildIndex(String path, MultiValueMap<Layer, String> index) {
            String name = path + this.name;
            if (this.layers.size() == 1) {
                index.add((Object)this.layers.iterator().next(), (Object)name);
            } else {
                for (Node child : this.children) {
                    child.buildIndex(name, index);
                }
            }
        }
    }
}

