/*
 * Decompiled with CFR 0.152.
 */
package javajs.img;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javajs.img.CRCEncoder;

public class PngEncoder
extends CRCEncoder {
    public static final int FILTER_NONE = 0;
    public static final int FILTER_SUB = 1;
    public static final int FILTER_UP = 2;
    public static final int FILTER_LAST = 2;
    private static final int PT_FIRST_TAG = 37;
    private boolean encodeAlpha;
    private int filter = 0;
    private int bytesPerPixel;
    private int compressionLevel;
    private String type;
    private Integer transparentColor;
    private byte[] appData;
    private String appPrefix;
    private String comment;
    private byte[] bytes;
    private byte[] scanLines;
    private int byteWidth;

    @Override
    protected void setParams(Map<String, Object> map) {
        if (this.quality < 0) {
            int n = this.quality = map.containsKey("qualityPNG") ? (Integer)map.get("qualityPNG") : 2;
        }
        if (this.quality > 9) {
            this.quality = 9;
        }
        this.encodeAlpha = false;
        this.filter = 0;
        this.compressionLevel = this.quality;
        this.transparentColor = (Integer)map.get("transparentColor");
        this.comment = (String)map.get("comment");
        this.type = (map.get("type") + "0000").substring(0, 4);
        this.bytes = (byte[])map.get("pngImgData");
        this.appData = (byte[])map.get("pngAppData");
        this.appPrefix = (String)map.get("pngAppPrefix");
    }

    @Override
    protected void generate() throws IOException {
        if (this.bytes == null) {
            if (!this.pngEncode()) {
                this.out.cancel();
                return;
            }
            this.bytes = this.getBytes();
        } else {
            this.dataLen = this.bytes.length;
        }
        int n = this.dataLen;
        if (this.appData != null) {
            PngEncoder.setJmolTypeText(this.appPrefix, this.bytes, n, this.appData.length, this.type);
            this.out.write(this.bytes, 0, n);
            this.bytes = this.appData;
            n = this.appData.length;
        }
        this.out.write(this.bytes, 0, n);
    }

    private boolean pngEncode() {
        byte[] byArray = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        this.writeBytes(byArray);
        this.writeHeader();
        this.writeText(PngEncoder.getApplicationText(this.appPrefix, this.type, 0, 0));
        this.writeText("Software\u0000Jmol " + this.comment);
        this.writeText("Creation Time\u0000" + this.date);
        if (!this.encodeAlpha && this.transparentColor != null) {
            this.writeTransparentColor(this.transparentColor);
        }
        return this.writeImageData();
    }

    private static void setJmolTypeText(String string, byte[] byArray, int n, int n2, String string2) {
        String string3 = "tEXt" + PngEncoder.getApplicationText(string, string2, n, n2);
        PngEncoder pngEncoder = new PngEncoder();
        byte[] byArray2 = string3.substring(0, 4 + string.length()).getBytes();
        int n3 = byArray2.length;
        while (--n3 >= 0) {
            if (byArray[n3 + 37] == byArray2[n3]) continue;
            System.out.println("image is not of the right form; appending data, but not adding tEXt tag.");
            return;
        }
        pngEncoder.setData(byArray, 37);
        pngEncoder.writeString(string3);
        pngEncoder.writeCRC();
    }

    private static String getApplicationText(String string, String string2, int n, int n2) {
        String string3 = "000000000" + n;
        string3 = string3.substring(string3.length() - 9);
        String string4 = "000000000" + n2;
        string4 = string4.substring(string4.length() - 9);
        return String.valueOf(string) + "\u0000" + string2 + (string2.equals("PNG") ? "0" : "") + string3 + "+" + string4;
    }

    private void writeHeader() {
        this.writeInt4(13);
        this.startPos = this.bytePos;
        this.writeString("IHDR");
        this.writeInt4(this.width);
        this.writeInt4(this.height);
        this.writeByte(8);
        this.writeByte(this.encodeAlpha ? 6 : 2);
        this.writeByte(0);
        this.writeByte(0);
        this.writeByte(0);
        this.writeCRC();
    }

    private void writeText(String string) {
        this.writeInt4(string.length());
        this.startPos = this.bytePos;
        this.writeString("tEXt" + string);
        this.writeCRC();
    }

    private void writeTransparentColor(int n) {
        this.writeInt4(6);
        this.startPos = this.bytePos;
        this.writeString("tRNS");
        this.writeInt2(n >> 16 & 0xFF);
        this.writeInt2(n >> 8 & 0xFF);
        this.writeInt2(n & 0xFF);
        this.writeCRC();
    }

    private boolean writeImageData() {
        this.bytesPerPixel = this.encodeAlpha ? 4 : 3;
        this.byteWidth = this.width * this.bytesPerPixel;
        int n = this.byteWidth + 1;
        int n2 = this.height;
        Deflater deflater = new Deflater(this.compressionLevel);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
        int n3 = 0;
        try {
            while (n2 > 0) {
                int n4 = Math.max(1, Math.min(Short.MAX_VALUE / n, n2));
                this.scanLines = new byte[n * n4];
                int n5 = this.width * n4;
                int n6 = 0;
                int n7 = 0;
                while (n7 < n5) {
                    if (n7 % this.width == 0) {
                        this.scanLines[n6++] = (byte)this.filter;
                    }
                    this.scanLines[n6++] = (byte)(this.pixels[n3] >> 16 & 0xFF);
                    this.scanLines[n6++] = (byte)(this.pixels[n3] >> 8 & 0xFF);
                    this.scanLines[n6++] = (byte)(this.pixels[n3] & 0xFF);
                    if (this.encodeAlpha) {
                        this.scanLines[n6++] = (byte)(this.pixels[n3] >> 24 & 0xFF);
                    }
                    ++n7;
                    ++n3;
                }
                deflaterOutputStream.write(this.scanLines, 0, n6);
                n2 -= n4;
            }
            deflaterOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            this.writeInt4(byArray.length);
            this.startPos = this.bytePos;
            this.writeString("IDAT");
            this.writeBytes(byArray);
            this.writeCRC();
            this.writeEnd();
            deflater.finish();
            return true;
        }
        catch (IOException iOException) {
            System.err.println(iOException.toString());
            return false;
        }
    }

    private void writeEnd() {
        this.writeInt4(0);
        this.startPos = this.bytePos;
        this.writeString("IEND");
        this.writeCRC();
    }
}

