/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import javajs.api.EigenInterface;
import javajs.util.V3;

public class Eigen
implements EigenInterface {
    private int n = 3;
    private double[] d;
    private double[] e;
    private double[][] V;

    public Eigen set(int n) {
        this.n = n;
        this.V = new double[n][n];
        this.d = new double[n];
        this.e = new double[n];
        return this;
    }

    @Override
    public Eigen setM(double[][] dArray) {
        this.set(dArray.length);
        this.calc(dArray);
        return this;
    }

    @Override
    public double[] getEigenvalues() {
        return this.d;
    }

    @Override
    public void fillFloatArrays(V3[] v3Array, float[] fArray) {
        int n = 0;
        while (n < 3) {
            if (v3Array != null) {
                if (v3Array[n] == null) {
                    v3Array[n] = new V3();
                }
                v3Array[n].set((float)this.V[0][n], (float)this.V[1][n], (float)this.V[2][n]);
            }
            if (fArray != null) {
                fArray[n] = (float)this.d[n];
            }
            ++n;
        }
    }

    @Override
    public float[][] getEigenvectorsFloatTransposed() {
        float[][] fArray = new float[this.n][this.n];
        int n = this.n;
        while (--n >= 0) {
            int n2 = this.n;
            while (--n2 >= 0) {
                fArray[n2][n] = (float)this.V[n][n2];
            }
        }
        return fArray;
    }

    public void calc(double[][] dArray) {
        int n = 0;
        while (n < this.n) {
            int n2 = 0;
            while (n2 < this.n) {
                this.V[n][n2] = dArray[n][n2];
                ++n2;
            }
            ++n;
        }
        this.tred2();
        this.tql2();
    }

    public double[] getRealEigenvalues() {
        return this.d;
    }

    public double[] getImagEigenvalues() {
        return this.e;
    }

    private void tred2() {
        double d;
        int n = 0;
        while (n < this.n) {
            this.d[n] = this.V[this.n - 1][n];
            ++n;
        }
        n = this.n - 1;
        while (n > 0) {
            d = 0.0;
            double d2 = 0.0;
            int n2 = 0;
            while (n2 < n) {
                d += Math.abs(this.d[n2]);
                ++n2;
            }
            if (d == 0.0) {
                this.e[n] = this.d[n - 1];
                n2 = 0;
                while (n2 < n) {
                    this.d[n2] = this.V[n - 1][n2];
                    this.V[n][n2] = 0.0;
                    this.V[n2][n] = 0.0;
                    ++n2;
                }
            } else {
                n2 = 0;
                while (n2 < n) {
                    int n3 = n2;
                    this.d[n3] = this.d[n3] / d;
                    d2 += this.d[n2] * this.d[n2];
                    ++n2;
                }
                double d3 = this.d[n - 1];
                double d4 = Math.sqrt(d2);
                if (d3 > 0.0) {
                    d4 = -d4;
                }
                this.e[n] = d * d4;
                d2 -= d3 * d4;
                this.d[n - 1] = d3 - d4;
                int n4 = 0;
                while (n4 < n) {
                    this.e[n4] = 0.0;
                    ++n4;
                }
                n4 = 0;
                while (n4 < n) {
                    this.V[n4][n] = d3 = this.d[n4];
                    d4 = this.e[n4] + this.V[n4][n4] * d3;
                    int n5 = n4 + 1;
                    while (n5 <= n - 1) {
                        d4 += this.V[n5][n4] * this.d[n5];
                        int n6 = n5;
                        this.e[n6] = this.e[n6] + this.V[n5][n4] * d3;
                        ++n5;
                    }
                    this.e[n4] = d4;
                    ++n4;
                }
                d3 = 0.0;
                n4 = 0;
                while (n4 < n) {
                    int n7 = n4;
                    this.e[n7] = this.e[n7] / d2;
                    d3 += this.e[n4] * this.d[n4];
                    ++n4;
                }
                double d5 = d3 / (d2 + d2);
                int n8 = 0;
                while (n8 < n) {
                    int n9 = n8;
                    this.e[n9] = this.e[n9] - d5 * this.d[n8];
                    ++n8;
                }
                n8 = 0;
                while (n8 < n) {
                    d3 = this.d[n8];
                    d4 = this.e[n8];
                    int n10 = n8;
                    while (n10 <= n - 1) {
                        double[] dArray = this.V[n10];
                        int n11 = n8;
                        dArray[n11] = dArray[n11] - (d3 * this.e[n10] + d4 * this.d[n10]);
                        ++n10;
                    }
                    this.d[n8] = this.V[n - 1][n8];
                    this.V[n][n8] = 0.0;
                    ++n8;
                }
            }
            this.d[n] = d2;
            --n;
        }
        n = 0;
        while (n < this.n - 1) {
            this.V[this.n - 1][n] = this.V[n][n];
            this.V[n][n] = 1.0;
            d = this.d[n + 1];
            if (d != 0.0) {
                int n12 = 0;
                while (n12 <= n) {
                    this.d[n12] = this.V[n12][n + 1] / d;
                    ++n12;
                }
                n12 = 0;
                while (n12 <= n) {
                    double d6 = 0.0;
                    int n13 = 0;
                    while (n13 <= n) {
                        d6 += this.V[n13][n + 1] * this.V[n13][n12];
                        ++n13;
                    }
                    n13 = 0;
                    while (n13 <= n) {
                        double[] dArray = this.V[n13];
                        int n14 = n12;
                        dArray[n14] = dArray[n14] - d6 * this.d[n13];
                        ++n13;
                    }
                    ++n12;
                }
            }
            int n15 = 0;
            while (n15 <= n) {
                this.V[n15][n + 1] = 0.0;
                ++n15;
            }
            ++n;
        }
        n = 0;
        while (n < this.n) {
            this.d[n] = this.V[this.n - 1][n];
            this.V[this.n - 1][n] = 0.0;
            ++n;
        }
        this.V[this.n - 1][this.n - 1] = 1.0;
        this.e[0] = 0.0;
    }

    private void tql2() {
        int n;
        int n2 = 1;
        while (n2 < this.n) {
            this.e[n2 - 1] = this.e[n2];
            ++n2;
        }
        this.e[this.n - 1] = 0.0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = Math.pow(2.0, -52.0);
        int n3 = 0;
        while (n3 < this.n) {
            d2 = Math.max(d2, Math.abs(this.d[n3]) + Math.abs(this.e[n3]));
            n = n3;
            while (n < this.n) {
                if (Math.abs(this.e[n]) <= d3 * d2) break;
                ++n;
            }
            if (n > n3) {
                int n4 = 0;
                do {
                    double d4;
                    ++n4;
                    double d5 = this.d[n3];
                    double d6 = (this.d[n3 + 1] - d5) / (2.0 * this.e[n3]);
                    double d7 = Eigen.hypot(d6, 1.0);
                    if (d6 < 0.0) {
                        d7 = -d7;
                    }
                    this.d[n3] = this.e[n3] / (d6 + d7);
                    this.d[n3 + 1] = this.e[n3] * (d6 + d7);
                    double d8 = this.d[n3 + 1];
                    double d9 = d5 - this.d[n3];
                    int n5 = n3 + 2;
                    while (n5 < this.n) {
                        int n6 = n5++;
                        this.d[n6] = this.d[n6] - d9;
                    }
                    d += d9;
                    d6 = this.d[n];
                    double d10 = d4 = 1.0;
                    double d11 = d4;
                    double d12 = this.e[n3 + 1];
                    double d13 = 0.0;
                    double d14 = 0.0;
                    int n7 = n - 1;
                    while (n7 >= n3) {
                        d11 = d10;
                        d10 = d4;
                        d14 = d13;
                        d5 = d4 * this.e[n7];
                        d9 = d4 * d6;
                        d7 = Eigen.hypot(d6, this.e[n7]);
                        this.e[n7 + 1] = d13 * d7;
                        d13 = this.e[n7] / d7;
                        d4 = d6 / d7;
                        d6 = d4 * this.d[n7] - d13 * d5;
                        this.d[n7 + 1] = d9 + d13 * (d4 * d5 + d13 * this.d[n7]);
                        int n8 = 0;
                        while (n8 < this.n) {
                            d9 = this.V[n8][n7 + 1];
                            this.V[n8][n7 + 1] = d13 * this.V[n8][n7] + d4 * d9;
                            this.V[n8][n7] = d4 * this.V[n8][n7] - d13 * d9;
                            ++n8;
                        }
                        --n7;
                    }
                    d6 = -d13 * d14 * d11 * d12 * this.e[n3] / d8;
                    this.e[n3] = d13 * d6;
                    this.d[n3] = d4 * d6;
                } while (Math.abs(this.e[n3]) > d3 * d2);
            }
            this.d[n3] = this.d[n3] + d;
            this.e[n3] = 0.0;
            ++n3;
        }
        n3 = 0;
        while (n3 < this.n - 1) {
            n = n3;
            double d15 = this.d[n3];
            int n9 = n3 + 1;
            while (n9 < this.n) {
                if (this.d[n9] < d15) {
                    n = n9;
                    d15 = this.d[n9];
                }
                ++n9;
            }
            if (n != n3) {
                this.d[n] = this.d[n3];
                this.d[n3] = d15;
                n9 = 0;
                while (n9 < this.n) {
                    d15 = this.V[n9][n3];
                    this.V[n9][n3] = this.V[n9][n];
                    this.V[n9][n] = d15;
                    ++n9;
                }
            }
            ++n3;
        }
    }

    private static double hypot(double d, double d2) {
        double d3;
        if (Math.abs(d) > Math.abs(d2)) {
            d3 = d2 / d;
            d3 = Math.abs(d) * Math.sqrt(1.0 + d3 * d3);
        } else if (d2 != 0.0) {
            d3 = d / d2;
            d3 = Math.abs(d2) * Math.sqrt(1.0 + d3 * d3);
        } else {
            d3 = 0.0;
        }
        return d3;
    }
}

