/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import javajs.util.P3i;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.G3DRenderer;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.PrecisionRenderer;
import org.jmol.util.GData;
import org.jmol.util.Rgb16;

public class TriangleRenderer
extends PrecisionRenderer
implements G3DRenderer {
    private Graphics3D g3d;
    private static final int DEFAULT = 64;
    private int[] ax = new int[3];
    private int[] ay = new int[3];
    private int[] az = new int[3];
    private float[] aa = new float[64];
    private float[] bb = new float[64];
    private int[] axW = new int[64];
    private int[] azW = new int[64];
    private int[] axE = new int[64];
    private int[] azE = new int[64];
    private Rgb16[] rgb16sW;
    private Rgb16[] rgb16sE;
    private Rgb16[] rgb16sGouraud;
    private final Rgb16 rgb16t1 = new Rgb16();
    private final Rgb16 rgb16t2 = new Rgb16();

    @Override
    public G3DRenderer set(JmolRendererInterface g3d, GData gdata) {
        try {
            this.rgb16sW = new Rgb16[64];
            this.rgb16sE = new Rgb16[64];
            int i = 64;
            while (--i >= 0) {
                this.rgb16sW[i] = new Rgb16();
                this.rgb16sE[i] = new Rgb16();
            }
            this.g3d = (Graphics3D)g3d;
            this.rgb16sGouraud = new Rgb16[3];
            i = 3;
            while (--i >= 0) {
                this.rgb16sGouraud[i] = new Rgb16();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    private Rgb16[] reallocRgb16s(Rgb16[] rgb16s, int n) {
        Rgb16[] t = new Rgb16[n];
        System.arraycopy(rgb16s, 0, t, 0, rgb16s.length);
        for (int i = rgb16s.length; i < n; ++i) {
            t[i] = new Rgb16();
        }
        return t;
    }

    void setGouraud(int rgbA, int rgbB, int rgbC) {
        this.rgb16sGouraud[0].setInt(rgbA);
        this.rgb16sGouraud[1].setInt(rgbB);
        this.rgb16sGouraud[2].setInt(rgbC);
    }

    void fillTriangle(P3i screenA, P3i screenB, P3i screenC, boolean useGouraud) {
        int xW;
        int t;
        Rgb16[] gouraudE;
        Rgb16[] gouraudW;
        int iMaxY;
        int iMidY;
        boolean isClipped;
        int cc2;
        int cc1;
        this.ax[0] = screenA.x;
        this.ax[1] = screenB.x;
        this.ax[2] = screenC.x;
        this.ay[0] = screenA.y;
        this.ay[1] = screenB.y;
        this.ay[2] = screenC.y;
        this.az[0] = screenA.z;
        this.az[1] = screenB.z;
        this.az[2] = screenC.z;
        if (this.az[0] <= 1 || this.az[1] <= 1 || this.az[2] <= 1) {
            return;
        }
        int cc0 = this.g3d.clipCode3(this.ax[0], this.ay[0], this.az[0]);
        int c = cc0 | (cc1 = this.g3d.clipCode3(this.ax[1], this.ay[1], this.az[1])) | (cc2 = this.g3d.clipCode3(this.ax[2], this.ay[2], this.az[2]));
        boolean bl = isClipped = c != 0;
        if (isClipped && (c == -1 || (cc0 & cc1 & cc2) != 0)) {
            return;
        }
        int iMinY = 0;
        if (this.ay[1] < this.ay[iMinY]) {
            iMinY = 1;
        }
        if (this.ay[2] < this.ay[iMinY]) {
            iMinY = 2;
        }
        if (this.ay[iMidY = (iMinY + 1) % 3] > this.ay[iMaxY = (iMinY + 2) % 3]) {
            int t2 = iMidY;
            iMidY = iMaxY;
            iMaxY = t2;
        }
        int yMin = this.ay[iMinY];
        int yMid = this.ay[iMidY];
        int yMax = this.ay[iMaxY];
        int nLines = yMax - yMin + 1;
        if (nLines > this.g3d.height * 3) {
            return;
        }
        if (nLines > this.axW.length) {
            int n = nLines + 31 & 0xFFFFFFE0;
            this.axW = new int[n];
            this.azW = new int[n];
            this.axE = new int[n];
            this.azE = new int[n];
            this.aa = new float[n];
            this.bb = new float[n];
            this.rgb16sW = this.reallocRgb16s(this.rgb16sW, n);
            this.rgb16sE = this.reallocRgb16s(this.rgb16sE, n);
        }
        if (useGouraud) {
            gouraudW = this.rgb16sW;
            gouraudE = this.rgb16sE;
        } else {
            gouraudE = null;
            gouraudW = null;
        }
        int dyMidMin = yMid - yMin;
        if (dyMidMin == 0) {
            if (this.ax[iMidY] < this.ax[iMinY]) {
                t = iMidY;
                iMidY = iMinY;
                iMinY = t;
            }
            this.generateRaster(nLines, iMinY, iMaxY, this.axW, this.azW, 0, gouraudW);
            this.generateRaster(nLines, iMidY, iMaxY, this.axE, this.azE, 0, gouraudE);
        } else if (yMid == yMax) {
            if (this.ax[iMaxY] < this.ax[iMidY]) {
                t = iMidY;
                iMidY = iMaxY;
                iMaxY = t;
            }
            this.generateRaster(nLines, iMinY, iMidY, this.axW, this.azW, 0, gouraudW);
            this.generateRaster(nLines, iMinY, iMaxY, this.axE, this.azE, 0, gouraudE);
        } else {
            int axSplit;
            int dxMaxMin = this.ax[iMaxY] - this.ax[iMinY];
            int roundFactor = GData.roundInt(nLines / 2);
            if (dxMaxMin < 0) {
                roundFactor = -roundFactor;
            }
            if ((axSplit = this.ax[iMinY] + (dxMaxMin * dyMidMin + roundFactor) / nLines) < this.ax[iMidY]) {
                this.generateRaster(nLines, iMinY, iMaxY, this.axW, this.azW, 0, gouraudW);
                this.generateRaster(dyMidMin + 1, iMinY, iMidY, this.axE, this.azE, 0, gouraudE);
                this.generateRaster(nLines - dyMidMin, iMidY, iMaxY, this.axE, this.azE, dyMidMin, gouraudE);
            } else {
                this.generateRaster(dyMidMin + 1, iMinY, iMidY, this.axW, this.azW, 0, gouraudW);
                this.generateRaster(nLines - dyMidMin, iMidY, iMaxY, this.axW, this.azW, dyMidMin, gouraudW);
                this.generateRaster(nLines, iMinY, iMaxY, this.axE, this.azE, 0, gouraudE);
            }
        }
        this.g3d.setZMargin(5);
        int pass2Row = this.g3d.pass2Flag01;
        int pass2Off = 1 - pass2Row;
        int i = 0;
        if (yMin < 0) {
            nLines += yMin;
            i -= yMin;
            yMin = 0;
        }
        if (yMin + nLines > this.g3d.height) {
            nLines = this.g3d.height - yMin;
        }
        if (useGouraud) {
            if (isClipped) {
                while (--nLines >= pass2Row) {
                    xW = this.axW[i];
                    int pixelCount = this.axE[i] - xW + pass2Off;
                    if (pixelCount > 0) {
                        this.g3d.plotPixelsClippedRaster(pixelCount, xW, yMin, this.azW[i], this.azE[i], this.rgb16sW[i], this.rgb16sE[i]);
                    }
                    ++yMin;
                    ++i;
                }
            } else {
                while (--nLines >= pass2Row) {
                    xW = this.axW[i];
                    int pixelCount = this.axE[i] - xW + pass2Off;
                    if (pass2Row == 1 && pixelCount < 0) {
                        pixelCount = 1;
                        --xW;
                    }
                    if (pixelCount > 0) {
                        this.g3d.plotPixelsUnclippedRaster(pixelCount, xW, yMin, this.azW[i], this.azE[i], this.rgb16sW[i], this.rgb16sE[i]);
                    }
                    ++yMin;
                    ++i;
                }
            }
        } else if (isClipped) {
            while (--nLines >= pass2Row) {
                xW = this.axW[i];
                int pixelCount = this.axE[i] - xW + pass2Off;
                if (pixelCount > 0) {
                    this.g3d.plotPixelsClippedRasterBits(pixelCount, xW, yMin, this.azW[i], this.azE[i], null, null, this.aa[i], this.bb[i]);
                }
                ++yMin;
                ++i;
            }
        } else {
            while (--nLines >= pass2Row) {
                xW = this.axW[i];
                int pixelCount = this.axE[i] - xW + pass2Off;
                if (pass2Row == 1 && pixelCount < 0) {
                    pixelCount = 1;
                    --xW;
                }
                if (pixelCount > 0) {
                    this.g3d.plotPixelsUnclippedRasterBits(pixelCount, xW, yMin, null, null, this.aa[i], this.bb[i]);
                }
                ++yMin;
                ++i;
            }
        }
        this.g3d.setZMargin(0);
    }

    private void generateRaster(int dy, int iN, int iS, int[] axRaster, int[] azRaster, int iRaster, Rgb16[] gouraud) {
        int xMajorError;
        int xMajorIncrement;
        int errorTerm;
        int width;
        int xIncrement;
        int xN = this.ax[iN];
        int xS = this.ax[iS];
        int dx = xS - xN;
        int xCurrent = xN;
        if (dx >= 0) {
            xIncrement = 1;
            width = dx;
            errorTerm = 0;
        } else {
            xIncrement = -1;
            width = -dx;
            errorTerm = 1 - dy;
        }
        if (width <= dy) {
            xMajorIncrement = 0;
            xMajorError = width;
        } else {
            xMajorIncrement = GData.roundInt(dx / dy);
            xMajorError = width % dy;
        }
        this.setRastAB(this.ay[iN], this.az[iN], this.ay[iS], this.az[iS]);
        float a0 = this.a;
        float b0 = this.b;
        boolean isEast = axRaster == this.axE;
        int y = 0;
        int zy = this.ay[iN];
        int lastY = dy - 1;
        int i = iRaster;
        while (y <= lastY) {
            if (i == 0 || i > iRaster) {
                axRaster[i] = y == lastY ? this.ax[iS] : xCurrent;
                azRaster[i] = this.getZCurrent(a0, b0, zy);
                if (isEast) {
                    this.setRastAB(this.axW[i], this.azW[i], axRaster[i], azRaster[i]);
                    this.aa[i] = this.a;
                    this.bb[i] = this.b;
                }
            }
            xCurrent += xMajorIncrement;
            if ((errorTerm += xMajorError) > 0) {
                xCurrent += xIncrement;
                errorTerm -= dy;
            }
            ++i;
            ++y;
            ++zy;
        }
        if (gouraud != null) {
            Rgb16 rgb16Base = this.rgb16t1;
            rgb16Base.setRgb(this.rgb16sGouraud[iN]);
            Rgb16 rgb16Increment = this.rgb16t2;
            rgb16Increment.diffDiv(this.rgb16sGouraud[iS], rgb16Base, dy);
            int iMax = iRaster + dy;
            for (int i2 = iRaster; i2 < iMax; ++i2) {
                gouraud[i2].setAndIncrement(rgb16Base, rgb16Increment);
            }
        }
    }
}

