/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.data;

import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.SB;
import org.jmol.jvxl.data.JvxlCoder;

public class JvxlData {
    public String msg = "";
    public boolean wasJvxl;
    public boolean wasCubic;
    public String jvxlFileSource;
    public String jvxlFileTitle;
    public String jvxlFileMessage;
    public String jvxlSurfaceData;
    public String jvxlEdgeData;
    public String jvxlColorData;
    public String jvxlVolumeDataXml;
    public BS[] jvxlExcluded = new BS[4];
    public P4 jvxlPlane;
    public boolean isJvxlPrecisionColor;
    public boolean jvxlDataIsColorMapped;
    public boolean jvxlDataIs2dContour;
    public boolean jvxlDataIsColorDensity;
    public boolean isColorReversed;
    public BS thisSet = null;
    public int edgeFractionBase = 35;
    public int edgeFractionRange = 90;
    public int colorFractionBase = 35;
    public int colorFractionRange = 90;
    public boolean isValid = true;
    public boolean insideOut;
    public boolean isXLowToHigh;
    public boolean isContoured;
    public boolean isBicolorMap;
    public boolean isTruncated;
    public boolean isCutoffAbsolute;
    public boolean isModelConnected;
    public boolean vertexDataOnly;
    public float mappedDataMin;
    public float mappedDataMax;
    public float valueMappedToRed;
    public float valueMappedToBlue;
    public float cutoff;
    public float[] cutoffRange;
    public float pointsPerAngstrom;
    public int nPointsX;
    public int nPointsY;
    public int nPointsZ;
    public long nBytes;
    public int nContours;
    public int nEdges;
    public int nSurfaceInts;
    public int vertexCount;
    public Lst<Object>[] vContours;
    public short[] contourColixes;
    public String contourColors;
    public float[] contourValues;
    public float[] contourValuesUsed;
    public int thisContour = -1;
    public float scale3d;
    public short minColorIndex = (short)-1;
    public short maxColorIndex = 0;
    public String[] title;
    public String version;
    public P3[] boundingBox;
    public int excludedTriangleCount;
    public int excludedVertexCount;
    public boolean colorDensity;
    public float pointSize;
    public String moleculeXml;
    public float dataMin;
    public float dataMax;
    public int saveVertexCount;
    public Map<String, BS> vertexColorMap;
    public int nVertexColors;
    public int[] vertexColors;
    public String color;
    public String meshColor;
    public float translucency;
    public String colorScheme;
    public String rendering;
    public int slabValue = Integer.MIN_VALUE;
    public boolean isSlabbable;
    public int diameter;
    public String slabInfo;
    public boolean allowVolumeRender;
    public float voxelVolume;
    public P3 mapLattice;
    public P3 fixedLattice;
    public String baseColor;
    public float integration = Float.NaN;
    public SB sbOut;

    public void clear() {
        this.allowVolumeRender = true;
        this.jvxlSurfaceData = "";
        this.jvxlEdgeData = "";
        this.jvxlColorData = "";
        this.jvxlVolumeDataXml = "";
        this.color = null;
        this.colorScheme = null;
        this.colorDensity = false;
        this.pointSize = Float.NaN;
        this.contourValues = null;
        this.contourValuesUsed = null;
        this.contourColixes = null;
        this.contourColors = null;
        this.integration = Float.NaN;
        this.isSlabbable = false;
        this.isValid = true;
        this.mapLattice = null;
        this.meshColor = null;
        this.msg = "";
        this.nPointsX = 0;
        this.nVertexColors = 0;
        this.fixedLattice = null;
        this.slabInfo = null;
        this.slabValue = Integer.MIN_VALUE;
        this.thisSet = null;
        this.rendering = null;
        this.thisContour = -1;
        this.translucency = 0.0f;
        this.vContours = null;
        this.vertexColorMap = null;
        this.vertexColors = null;
        this.voxelVolume = 0.0f;
    }

    public void setSurfaceInfo(P4 thePlane, P3 mapLattice, int nSurfaceInts, String surfaceData) {
        this.jvxlSurfaceData = surfaceData;
        if (this.jvxlSurfaceData.indexOf("--") == 0) {
            this.jvxlSurfaceData = this.jvxlSurfaceData.substring(2);
        }
        this.jvxlPlane = thePlane;
        this.mapLattice = mapLattice;
        this.nSurfaceInts = nSurfaceInts;
    }

    public void setSurfaceInfoFromBitSet(BS bs, P4 thePlane) {
        this.setSurfaceInfoFromBitSetPts(bs, thePlane, null);
    }

    public void setSurfaceInfoFromBitSetPts(BS bs, P4 thePlane, P3 mapLattice) {
        SB sb = new SB();
        int nSurfaceInts = thePlane != null ? 0 : JvxlCoder.jvxlEncodeBitSetBuffer(bs, this.nPointsX * this.nPointsY * this.nPointsZ, sb);
        this.setSurfaceInfo(thePlane, mapLattice, nSurfaceInts, sb.toString());
    }

    public void jvxlUpdateInfo(String[] title, long nBytes) {
        this.title = title;
        this.nBytes = nBytes;
    }

    public static String updateSurfaceData(String edgeData, float[] vertexValues, int vertexCount, int vertexIncrement, char isNaN) {
        if (edgeData.length() == 0) {
            return "";
        }
        char[] chars = edgeData.toCharArray();
        int i = 0;
        int ipt = 0;
        while (i < vertexCount) {
            if (Float.isNaN(vertexValues[i])) {
                chars[ipt] = isNaN;
            }
            i += vertexIncrement;
            ++ipt;
        }
        return String.copyValueOf(chars);
    }
}

