/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.HB;
import org.jmol.c.VDW;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.Parameters;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.script.T;
import org.jmol.shapesurface.Isosurface;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.ColorEncoder;
import org.jmol.util.ContactPair;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.TempArray;

public class Contact
extends Isosurface {
    protected int displayType;
    protected Atom[] atoms;
    private int ac;
    private float minData;
    private float maxData;
    private static final RadiusData rdVDW = new RadiusData(null, 1.0f, RadiusData.EnumType.FACTOR, VDW.AUTO);
    private V3 vZ = new V3();
    private V3 vY = new V3();
    private V3 vX = new V3();
    private P3 pt1 = new P3();
    private P3 pt2 = new P3();

    @Override
    public void initShape() {
        super.initShape();
        this.myType = "contact";
    }

    @Override
    public Object getProperty(String property, int index) {
        return this.getPropC(property, index);
    }

    protected Object getPropC(String property, int index) {
        IsosurfaceMesh thisMesh = this.thisMesh;
        if (index >= 0 && (index >= this.meshCount || (thisMesh = this.isomeshes[index]) == null)) {
            return null;
        }
        if (property == "jvxlFileInfo") {
            thisMesh.setJvxlColorMap(false);
            if (this.displayType == 134217750) {
                JvxlCoder.jvxlCreateColorData(this.jvxlData, thisMesh.vvs);
                float[] minmax = thisMesh.getDataMinMax();
                this.jvxlData.mappedDataMin = minmax[0];
                this.jvxlData.mappedDataMax = minmax[1];
            }
            return JvxlCoder.jvxlGetInfo(this.jvxlData);
        }
        return this.getPropI(property, index);
    }

    @Override
    public void setProperty(String propertyName, Object value, BS bs) {
        if ("set" == propertyName) {
            this.setContacts((Object[])value, !this.vwr.getBoolean(603979965));
            return;
        }
        if ("init" == propertyName) {
            this.translucentLevel = 0.0f;
        }
        this.setPropI(propertyName, value, bs);
    }

    private void setContacts(Object[] value, boolean doEditCpList) {
        float ptSize;
        int contactType = (Integer)value[0];
        int displayType = (Integer)value[1];
        boolean colorDensity = (Boolean)value[2];
        boolean colorByType = (Boolean)value[3];
        BS bsA = (BS)value[4];
        BS bsB = (BS)value[5];
        RadiusData rd = (RadiusData)value[6];
        float saProbeRadius = ((Float)value[7]).floatValue();
        float[] parameters = (float[])value[8];
        int modelIndex = (Integer)value[9];
        String command = (String)value[10];
        if (Float.isNaN(saProbeRadius)) {
            saProbeRadius = 0.0f;
        }
        if (rd == null) {
            rd = new RadiusData(null, saProbeRadius, RadiusData.EnumType.OFFSET, VDW.AUTO);
        }
        if (colorDensity) {
            switch (displayType) {
                case 134217750: 
                case 1073741961: 
                case 1275068932: {
                    displayType = 1275068932;
                    break;
                }
                case 4106: 
                case 2097180: 
                case 0x400000D4: 
                case 1073742135: {
                    break;
                }
                case 0x40000033: {
                    colorDensity = false;
                }
            }
        }
        this.ac = this.vwr.ms.ac;
        this.atoms = this.vwr.ms.at;
        int intramolecularMode = (int)(parameters == null || parameters.length < 2 ? 0.0f : parameters[1]);
        float f = ptSize = colorDensity && parameters != null && parameters[0] < 0.0f ? Math.abs(parameters[0]) : 0.15f;
        if (Logger.debugging) {
            Logger.debug("Contact intramolecularMode " + intramolecularMode);
            Logger.debug("Contacts for " + bsA.cardinality() + ": " + Escape.eBS(bsA));
            Logger.debug("Contacts to " + bsB.cardinality() + ": " + Escape.eBS(bsB));
        }
        this.setPropI("newObject", null, null);
        this.thisMesh.setMerged(true);
        this.thisMesh.nSets = 0;
        this.thisMesh.info = null;
        String func = null;
        boolean fullyLit = true;
        switch (displayType) {
            case 1073741961: {
                func = "(a>b?a:b)";
                break;
            }
            case 134217750: 
            case 0x40000033: {
                func = "a-b";
                break;
            }
            case 4106: {
                func = "a+b";
            }
        }
        switch (displayType) {
            case 0x400000D4: {
                fullyLit = false;
                colorByType = false;
                BS bs = BSUtil.copy(bsA);
                bs.or(bsB);
                if (parameters[0] < 0.0f) {
                    parameters[0] = 0.0f;
                }
                this.sg.params.colorDensity = colorDensity;
                this.sg.params.bsSelected = bs;
                this.sg.params.bsSolvent = bsB;
                this.sg.setProp("parameters", parameters, null);
                this.setPropI("nci", Boolean.TRUE, null);
                break;
            }
            case 2097180: 
            case 1073742135: {
                fullyLit = false;
                colorByType = false;
                this.thisMesh.nSets = 1;
                this.newSurface(2097180, null, bsA, bsB, rd, null, null, colorDensity, null, saProbeRadius);
                break;
            }
            case 0x40000033: {
                fullyLit = false;
                colorByType = false;
                this.thisMesh.nSets = 1;
                this.newSurface(554176565, null, bsA, bsB, rd, null, null, false, null, 0.0f);
                this.sg.initState();
                this.newSurface(134217750, null, bsA, bsB, rd, parameters, func, colorDensity, this.sg.volumeDataTemp, 0.0f);
                this.mergeMesh(null);
                break;
            }
            case 1073741961: 
            case 1275068932: {
                colorByType = false;
                this.newSurface(1275068932, null, bsA, bsB, rd, null, null, colorDensity, null, 0.0f);
                if (displayType == 1073741961) {
                    this.sg.initState();
                    this.newSurface(1275068932, null, bsB, bsA, rd, parameters, func, colorDensity, null, 0.0f);
                    this.mergeMesh(null);
                    break;
                }
                MeshData meshData = new MeshData();
                this.fillMeshData(meshData, 1, null);
                meshData.getSurfaceSet();
                this.fillMeshData(meshData, 3, null);
                break;
            }
            case 4106: 
            case 134217750: {
                Lst<ContactPair> pairs;
                float volume = 0.0f;
                this.thisMesh.info = pairs = this.getPairs(bsA, bsB, rd, intramolecularMode, doEditCpList);
                this.thisMesh.calculatedVolume = Float.valueOf(volume += this.combineSurfaces(pairs, contactType, displayType, parameters, func, colorDensity, colorByType));
                this.mergeMesh(null);
            }
        }
        this.thisMesh.setMerged(false);
        if (modelIndex != Integer.MIN_VALUE) {
            this.thisMesh.modelIndex = modelIndex;
        }
        this.thisMesh.jvxlData.vertexDataOnly = true;
        this.thisMesh.reinitializeLightingAndColor(this.vwr);
        if (contactType != 0x400000D4) {
            this.thisMesh.bsVdw = new BS();
            this.thisMesh.bsVdw.or(bsA);
            this.thisMesh.bsVdw.or(bsB);
        }
        this.setPropI("finalize", command, null);
        if (colorDensity) {
            this.setPropI("pointSize", Float.valueOf(ptSize), null);
        } else {
            this.setPropI("token", fullyLit ? 1073741964 : 1073741958, null);
        }
        if (this.thisMesh.slabOptions != null) {
            this.thisMesh.slabOptions = null;
            this.thisMesh.polygonCount0 = -1;
        }
        this.discardTempData(true);
        String defaultColor = null;
        switch (contactType) {
            case 1613238294: {
                defaultColor = "lightgreen";
                break;
            }
            case 1073741881: {
                defaultColor = "yellow";
                break;
            }
            case 2097180: {
                defaultColor = "skyblue";
            }
        }
        ColorEncoder ce = null;
        if (colorByType) {
            ce = this.vwr.cm.getColorEncoder("rwb");
            ce.setRange(-0.5f, 0.5f, false);
        } else if (defaultColor != null) {
            this.setPropI("color", CU.getArgbFromString(defaultColor), null);
        } else if (displayType == 0x400000D4) {
            ce = this.vwr.cm.getColorEncoder("bgr");
            ce.setRange(-0.03f, 0.03f, false);
        } else {
            ce = this.vwr.cm.getColorEncoder("rgb");
            if (colorDensity) {
                ce.setRange(-0.3f, 0.3f, false);
            } else {
                ce.setRange(-0.5f, 1.0f, false);
            }
        }
        if (ce != null) {
            this.thisMesh.remapColors(this.vwr, ce, this.translucentLevel);
        }
    }

    private float combineSurfaces(Lst<ContactPair> pairs, int contactType, int displayType, float[] parameters, Object func, boolean isColorDensity, boolean colorByType) {
        VolumeData volumeData = new VolumeData();
        int logLevel = Logger.getLogLevel();
        Logger.setLogLevel(0);
        float resolution = this.sg.params.resolution;
        int nContacts = pairs.size();
        double volume = 0.0;
        if (displayType == 1073741961 && resolution == Float.MAX_VALUE) {
            resolution = nContacts > 1000 ? 3 : 10;
        }
        BoxInfo box = new BoxInfo();
        int i = nContacts;
        while (--i >= 0) {
            boolean isVdwClash;
            ContactPair cp = (ContactPair)pairs.get(i);
            float oldScore = cp.score;
            boolean bl = isVdwClash = displayType == 134217750 && (contactType == 1648363544 || contactType == 0) && cp.setForVdwClash(true);
            if (isVdwClash) {
                cp.score = 0.0f;
            }
            if (contactType != 0 && cp.contactType != contactType) continue;
            int nV = this.thisMesh.vc;
            ++this.thisMesh.nSets;
            if (contactType != 0 || cp.contactType != 1648363544) {
                volume += cp.volume;
            }
            this.setVolumeData(displayType, volumeData, cp, resolution, nContacts);
            switch (displayType) {
                case 1073741961: {
                    this.newSurface(displayType, cp, null, null, null, null, func, isColorDensity, volumeData, 0.0f);
                    cp.switchAtoms();
                    this.newSurface(displayType, cp, null, null, null, null, null, isColorDensity, volumeData, 0.0f);
                    break;
                }
                case 4106: 
                case 134217750: 
                case 1275068932: {
                    this.newSurface(displayType, cp, null, null, null, parameters, func, isColorDensity, volumeData, 0.0f);
                    if (!isVdwClash || !cp.setForVdwClash(false)) break;
                    if (colorByType) {
                        nV = this.setColorByScore(cp.score, nV);
                    }
                    cp.score = oldScore;
                    volume += cp.volume;
                    this.newSurface(displayType, cp, null, null, null, parameters, func, isColorDensity, volumeData, 0.0f);
                }
            }
            if (i > 0 && i % 1000 == 0 && logLevel == 4) {
                Logger.setLogLevel(4);
                Logger.info("contact..." + i);
                Logger.setLogLevel(0);
            }
            if (colorByType) {
                this.setColorByScore(cp.contactType == 1613238294 ? 4.0f : cp.score, nV);
            }
            int j = this.thisMesh.vc;
            while (--j >= 0) {
                box.addBoundBoxPoint(this.thisMesh.vs[j]);
            }
        }
        Logger.setLogLevel(logLevel);
        if (this.jvxlData.boundingBox == null) {
            System.out.println("???");
        } else {
            this.jvxlData.boundingBox[0] = box.bbCorner0;
            this.jvxlData.boundingBox[1] = box.bbCorner1;
        }
        this.displayType = displayType;
        return (float)volume;
    }

    private int setColorByScore(float score, int nV) {
        int iv = this.thisMesh.vc;
        while (--iv >= nV) {
            this.thisMesh.vvs[iv] = score;
        }
        return this.thisMesh.vc;
    }

    private Lst<ContactPair> getPairs(BS bsA, BS bsB, RadiusData rd, int intramolecularMode, boolean doEditCpList) {
        int i;
        Lst<ContactPair> list = new Lst<ContactPair>();
        AtomData ad = new AtomData();
        ad.radiusData = rd;
        BS bs = BSUtil.copy(bsA);
        bs.or(bsB);
        if (bs.isEmpty()) {
            return list;
        }
        ad.bsSelected = bs;
        short iModel = this.atoms[bs.nextSetBit((int)0)].mi;
        boolean isMultiModel = iModel != this.atoms[bs.length() - 1].mi;
        ad.modelIndex = isMultiModel ? -1 : (int)iModel;
        boolean isSelf = bsA.equals(bsB);
        this.vwr.fillAtomData(ad, 2 | (isMultiModel ? 16 : 0) | 4);
        float maxRadius = 0.0f;
        int ib = bsB.nextSetBit(0);
        while (ib >= 0) {
            if (ad.atomRadius[ib] > maxRadius) {
                maxRadius = ad.atomRadius[ib];
            }
            ib = bsB.nextSetBit(ib + 1);
        }
        AtomIndexIterator iter = this.vwr.getSelectedAtomIterator(bsB, isSelf, false, isMultiModel);
        int ia = bsA.nextSetBit(0);
        while (ia >= 0) {
            Atom atomA = this.atoms[ia];
            float vdwA = atomA.getVanderwaalsRadiusFloat(this.vwr, VDW.AUTO);
            if (isMultiModel) {
                this.vwr.setIteratorForPoint(iter, -1, ad.atoms[ia], ad.atomRadius[ia] + maxRadius);
            } else {
                this.vwr.setIteratorForAtom(iter, ia, ad.atomRadius[ia] + maxRadius);
            }
            block10: while (iter.hasNext()) {
                float hbondCutoff;
                HB typeA;
                boolean isSameMolecule;
                int ib2 = iter.next();
                if (isMultiModel && !bsB.get(ib2)) continue;
                Atom atomB = this.atoms[ib2];
                boolean bl = isSameMolecule = ad.atomMolecule[ia] == ad.atomMolecule[ib2];
                if (ia == ib2 || isSameMolecule && this.isWithinFourBonds(atomA, atomB)) continue;
                switch (intramolecularMode) {
                    case 0: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (isSameMolecule == (intramolecularMode == 1)) break;
                        continue block10;
                    }
                }
                float vdwB = atomB.getVanderwaalsRadiusFloat(this.vwr, VDW.AUTO);
                float ra = ad.atomRadius[ia];
                float rb = ad.atomRadius[ib2];
                float d = atomA.distance(atomB);
                if (d > ra + rb) continue;
                ContactPair cp = new ContactPair(this.atoms, ia, ib2, ra, rb, vdwA, vdwB);
                if (cp.score < 0.0f) {
                    Contact.getVdwClashRadius(cp, ra - vdwA, vdwA, vdwB, d);
                }
                HB typeB = (typeA = HB.getType(atomA)) == HB.NOT ? HB.NOT : HB.getType(atomB);
                boolean isHBond = HB.isPossibleHBond(typeA, typeB);
                float f = hbondCutoff = atomA.getElementNumber() == 1 || atomB.getElementNumber() == 1 ? -1.2f : -1.0f;
                if (isHBond && cp.score < hbondCutoff) {
                    isHBond = false;
                }
                if (isHBond && cp.score < 0.0f) {
                    cp.contactType = 1613238294;
                }
                list.addLast(cp);
            }
            ia = bsA.nextSetBit(ia + 1);
        }
        iter.release();
        iter = null;
        if (!doEditCpList) {
            return list;
        }
        int n = list.size() - 1;
        BS bsBad = new BS();
        for (i = 0; i < n; ++i) {
            ContactPair cp1 = (ContactPair)list.get(i);
            for (int j = i + 1; j <= n; ++j) {
                ContactPair cp2 = (ContactPair)list.get(j);
                for (int m = 0; m < 2; ++m) {
                    block14: for (int p = 0; p < 2; ++p) {
                        switch (Contact.checkCp(cp1, cp2, m, p)) {
                            case 1: {
                                bsBad.set(i);
                                continue block14;
                            }
                            case 2: {
                                bsBad.set(j);
                                continue block14;
                            }
                        }
                    }
                }
            }
        }
        i = bsBad.length();
        while (--i >= 0) {
            if (!bsBad.get(i)) continue;
            list.removeItemAt(i);
        }
        if (Logger.debugging) {
            for (i = 0; i < list.size(); ++i) {
                Logger.debug(((ContactPair)list.get(i)).toString());
            }
        }
        Logger.info("Contact pairs: " + list.size());
        return list;
    }

    private boolean isWithinFourBonds(Atom atomA, Atom atomB) {
        if (atomA.mi != atomB.mi) {
            return false;
        }
        if (atomA.isCovalentlyBonded(atomB)) {
            return true;
        }
        Bond[] bondsOther = atomB.bonds;
        Bond[] bonds = atomA.bonds;
        if (bondsOther != null && bonds != null) {
            for (int i = 0; i < bondsOther.length; ++i) {
                Atom atom2 = bondsOther[i].getOtherAtom(atomB);
                if (atomA.isCovalentlyBonded(atom2)) {
                    return true;
                }
                for (int j = 0; j < bonds.length; ++j) {
                    if (!bonds[j].getOtherAtom(atomA).isCovalentlyBonded(atom2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static int checkCp(ContactPair cp1, ContactPair cp2, int i1, int i2) {
        boolean clash2;
        if (cp1.myAtoms[i1] != cp2.myAtoms[i2]) {
            return 0;
        }
        boolean clash1 = cp1.pt.distance(cp2.myAtoms[1 - i2]) < cp2.radii[1 - i2];
        boolean bl = clash2 = cp2.pt.distance(cp1.myAtoms[1 - i1]) < cp1.radii[1 - i1];
        return !clash1 && !clash2 ? 0 : (cp1.score > cp2.score ? 1 : 2);
    }

    private void newSurface(int displayType, ContactPair cp, BS bs1, BS bs2, RadiusData rd, float[] parameters, Object func, boolean isColorDensity, VolumeData volumeData, float sasurfaceRadius) {
        Parameters params = this.sg.params;
        params.isSilent = true;
        if (cp == null) {
            bs2.andNot(bs1);
            if (bs1.isEmpty() || bs2.isEmpty()) {
                return;
            }
        } else {
            params.contactPair = cp;
        }
        int iSlab0 = 0;
        int iSlab1 = 0;
        this.sg.initState();
        switch (displayType) {
            case 2097180: 
            case 554176565: 
            case 1073741961: 
            case 1073742135: 
            case 1275068932: {
                RadiusData rdB;
                RadiusData rdA;
                if (displayType == 2097180) {
                    rdA = rdVDW;
                    rdB = new RadiusData(null, rd.factorType == RadiusData.EnumType.OFFSET ? rd.value * 2.0f : (rd.value - 1.0f) * 2.0f + 1.0f, rd.factorType, rd.vdwType);
                } else {
                    rdA = rdB = rd;
                }
                params.colorDensity = isColorDensity;
                if (isColorDensity) {
                    this.setPropI("cutoffRange", new float[]{-100.0f, 0.0f}, null);
                }
                if (cp == null) {
                    params.atomRadiusData = rdA;
                    params.bsIgnore = BSUtil.copyInvert(bs1, this.ac);
                    params.bsSelected = bs1;
                    params.bsSolvent = null;
                }
                params.volumeData = volumeData;
                this.setPropI("sasurface", Float.valueOf(sasurfaceRadius), null);
                this.setPropI("map", Boolean.TRUE, null);
                if (cp == null) {
                    params.atomRadiusData = rdB;
                    params.bsIgnore = BSUtil.copyInvert(bs2, this.ac);
                    params.bsSelected = bs2;
                }
                params.volumeData = volumeData;
                this.setPropI("sasurface", Float.valueOf(sasurfaceRadius), null);
                switch (displayType) {
                    case 1073741961: 
                    case 1275068932: {
                        iSlab0 = -100;
                        break;
                    }
                    case 2097180: 
                    case 1073742135: {
                        if (!isColorDensity) break;
                        iSlab0 = -100;
                        break;
                    }
                    case 554176565: {
                        iSlab1 = -100;
                    }
                }
                break;
            }
            case 4106: 
            case 134217750: {
                if (displayType == 4106) {
                    this.sg.setProp("parameters", parameters, null);
                }
                if (cp == null) {
                    params.atomRadiusData = rd;
                    params.bsIgnore = BSUtil.copyInvert(bs2, this.ac);
                    params.bsIgnore.andNot(bs1);
                }
                params.func = func;
                params.intersection = new BS[]{bs1, bs2};
                params.volumeData = volumeData;
                params.colorDensity = isColorDensity;
                if (isColorDensity) {
                    this.setPropI("cutoffRange", new float[]{-5.0f, 0.0f}, null);
                }
                this.setPropI("sasurface", Float.valueOf(0.0f), null);
                this.setPropI("map", Boolean.TRUE, null);
                params.volumeData = volumeData;
                this.setPropI("sasurface", Float.valueOf(0.0f), null);
                if (displayType != 134217750) break;
                iSlab0 = -100;
            }
        }
        if (iSlab0 != iSlab1) {
            this.thisMesh.getMeshSlicer().slabPolygons(TempArray.getSlabWithinRange(iSlab0, iSlab1), false);
        }
        if (displayType != 2097180) {
            this.thisMesh.setMerged(true);
        }
    }

    private void setVolumeData(int type, VolumeData volumeData, ContactPair cp, float resolution, int nPairs) {
        int nYZ;
        int nX;
        this.pt1.setT(cp.myAtoms[0]);
        this.pt2.setT(cp.myAtoms[1]);
        this.vX.sub2(this.pt2, this.pt1);
        float dAB = this.vX.length();
        float dYZ = (cp.radii[0] * cp.radii[0] + dAB * dAB - cp.radii[1] * cp.radii[1]) / (2.0f * dAB * cp.radii[0]);
        dYZ = 2.1f * (float)((double)cp.radii[0] * Math.sin(Math.acos(dYZ)));
        Measure.getNormalToLine(this.pt1, this.pt2, this.vZ);
        this.vZ.scale(dYZ);
        this.vY.cross(this.vZ, this.vX);
        this.vY.normalize();
        this.vY.scale(dYZ);
        if (type != 4106) {
            this.vX.normalize();
            this.pt1.scaleAdd2((dAB - cp.radii[1]) * 0.95f, this.vX, this.pt1);
            this.pt2.scaleAdd2((cp.radii[0] - dAB) * 0.95f, this.vX, this.pt2);
            this.vX.sub2(this.pt2, this.pt1);
        }
        if (resolution == Float.MAX_VALUE) {
            resolution = nPairs > 100 ? 3 : 10;
        }
        if ((nX = Math.max(5, (int)Math.floor(this.pt1.distance(this.pt2) * resolution + 1.0f))) % 2 == 0) {
            ++nX;
        }
        if ((nYZ = Math.max(7, (int)Math.floor(dYZ * resolution + 1.0f))) % 2 == 0) {
            ++nYZ;
        }
        volumeData.setVoxelCounts(nX, nYZ, nYZ);
        this.pt1.scaleAdd2(-0.5f, this.vY, this.pt1);
        this.pt1.scaleAdd2(-0.5f, this.vZ, this.pt1);
        volumeData.setVolumetricOrigin(this.pt1.x, this.pt1.y, this.pt1.z);
        this.vX.scale(1.0f / (float)(nX - 1));
        this.vY.scale(1.0f / (float)(nYZ - 1));
        this.vZ.scale(1.0f / (float)(nYZ - 1));
        volumeData.setVolumetricVector(0, this.vX.x, this.vX.y, this.vX.z);
        volumeData.setVolumetricVector(1, this.vY.x, this.vY.y, this.vY.z);
        volumeData.setVolumetricVector(2, this.vZ.x, this.vZ.y, this.vZ.z);
    }

    private void mergeMesh(MeshData md) {
        this.thisMesh.merge(md);
        if (this.minData != Float.MAX_VALUE) {
            if (this.jvxlData.mappedDataMin == Float.MAX_VALUE) {
                this.jvxlData.mappedDataMin = this.minData;
                this.jvxlData.mappedDataMax = this.maxData;
            } else {
                this.jvxlData.mappedDataMin = Math.min(this.minData, this.jvxlData.mappedDataMin);
                this.jvxlData.mappedDataMax = Math.max(this.maxData, this.jvxlData.mappedDataMax);
            }
        }
        this.minData = this.jvxlData.mappedDataMin;
        this.maxData = this.jvxlData.mappedDataMax;
        this.jvxlData.valueMappedToBlue = this.minData;
        this.jvxlData.valueMappedToRed = this.maxData;
    }

    @Override
    protected void addMeshInfo(IsosurfaceMesh mesh, Map<String, Object> info) {
        if (mesh.info == null) {
            return;
        }
        Lst pairInfo = new Lst();
        info.put("pairInfo", pairInfo);
        Lst list = (Lst)mesh.info;
        for (int i = 0; i < list.size(); ++i) {
            Hashtable<String, Object> cpInfo = new Hashtable<String, Object>();
            pairInfo.addLast(cpInfo);
            ContactPair cp = (ContactPair)list.get(i);
            cpInfo.put("type", T.nameOf(cp.contactType));
            cpInfo.put("volume", cp.volume);
            cpInfo.put("vdwVolume", cp.vdwVolume);
            if (!Float.isNaN(cp.xVdwClash)) {
                cpInfo.put("xVdwClash", Double.valueOf(cp.xVdwClash));
            }
            cpInfo.put("score", Double.valueOf(cp.score));
            cpInfo.put("atoms", cp.myAtoms);
            cpInfo.put("radii", cp.radii);
            cpInfo.put("vdws", cp.vdws);
        }
    }

    private static void getVdwClashRadius(ContactPair cp, double x0, double vdwA, double vdwB, double d) {
        double costheta;
        double sum = vdwA + vdwB;
        double dif2 = vdwA - vdwB;
        dif2 *= dif2;
        double v0_nopi = x0 * x0 * (sum + 1.3333333333333333 * x0 - dif2 / sum);
        cp.vdwVolume = cp.volume - v0_nopi * Math.PI;
        double a = sum - d;
        double b = d + 2.0 * sum - 3.0 * dif2 / d;
        double c = v0_nopi * 12.0;
        double a2 = a * a;
        double a3 = a * a2;
        double b2 = b * b;
        double b3 = b * b2;
        double f = -a * 2.0 / 3.0 - b / 6.0;
        double g = (4.0 * a2 - 4.0 * a * b + b2) / 36.0;
        double v = a3 / 27.0 - a2 * b / 18.0 + a * b2 / 36.0 - b3 / 216.0 + c / 4.0;
        double u = -c / 432.0 * (8.0 * a3 - 12.0 * a2 * b + 6.0 * a * b2 - b3 + 27.0 * c);
        double theta = Math.atan2(Math.sqrt(u), v);
        double vvu = Math.pow(v * v + u, 0.16666666666666666);
        double x = f + (g / vvu + vvu) * (costheta = Math.cos(theta / 3.0));
        if (x > 0.0) {
            cp.xVdwClash = (float)(x / 2.0);
        }
    }
}

