/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine.behavior;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public interface IElementSerializer {
    public <T> byte[] serialize(T var1) throws IOException;

    public <T> T deSerialize(byte[] var1, ClassLoader var2) throws IOException, ClassNotFoundException;

    default public <T> int serializeTo(T obj, OutputStream os) throws IOException {
        byte[] serialized = this.serialize(obj);
        ByteBuffer buffer = ByteBuffer.allocate(4 + serialized.length);
        buffer.putInt(serialized.length);
        buffer.put(serialized);
        buffer.flip();
        os.write(buffer.array());
        return buffer.capacity();
    }

    default public <T> int serializeTo(T obj, WritableByteChannel oc) throws IOException {
        byte[] serialized = this.serialize(obj);
        ByteBuffer buffer = ByteBuffer.allocate(4 + serialized.length);
        buffer.putInt(serialized.length);
        buffer.put(serialized);
        buffer.flip();
        int count = 0;
        while (buffer.hasRemaining()) {
            count += oc.write(buffer);
        }
        return count;
    }

    default public <T> int serializeTo(T obj, AsynchronousByteChannel oc, int writeTimeoutMs) throws IOException {
        byte[] serialized = this.serialize(obj);
        ByteBuffer buffer = ByteBuffer.allocate(4 + serialized.length);
        buffer.putInt(serialized.length);
        buffer.put(serialized);
        buffer.flip();
        int count = 0;
        while (buffer.hasRemaining()) {
            Future<Integer> bytesWritten = oc.write(buffer);
            try {
                count += bytesWritten.get(writeTimeoutMs, TimeUnit.MILLISECONDS).intValue();
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new IOException("Write timeout exceeded " + writeTimeoutMs, e);
            }
        }
        return count;
    }

    default public <T> T deSerializeFrom(InputStream is, ClassLoader loader) throws IOException, ClassNotFoundException {
        byte[] bufferSize = new byte[4];
        int read = is.read(bufferSize);
        if (read < 0) {
            throw new EOFException("End of stream reached");
        }
        if (!1.$assertionsDisabled && read != bufferSize.length) {
            throw new AssertionError();
        }
        ByteBuffer size = ByteBuffer.wrap(bufferSize);
        byte[] serialized = new byte[size.getInt()];
        read = is.read(serialized);
        if (!1.$assertionsDisabled && read != serialized.length) {
            throw new AssertionError();
        }
        return this.deSerialize(serialized, loader);
    }

    default public <T> T deSerializeFrom(ReadableByteChannel ic, ClassLoader loader) throws IOException, ClassNotFoundException {
        ByteBuffer bufferSize = ByteBuffer.allocate(4);
        int read = ic.read(bufferSize);
        if (read < 0) {
            throw new EOFException("End of stream reached (length)");
        }
        if (!1.$assertionsDisabled && read != bufferSize.capacity()) {
            throw new AssertionError();
        }
        bufferSize.flip();
        ByteBuffer serialized = ByteBuffer.allocate(bufferSize.getInt());
        while (serialized.remaining() > 0) {
            read = ic.read(serialized);
            if (read >= 0) continue;
            throw new EOFException("End of stream reached (object)");
        }
        serialized.flip();
        return this.deSerialize(serialized.array(), loader);
    }

    default public <T> T deSerializeFrom(AsynchronousByteChannel ic, int readTimeoutMs, ClassLoader loader) throws IOException, ClassNotFoundException {
        ByteBuffer bufferSize = ByteBuffer.allocate(4);
        Future<Integer> readFuture = ic.read(bufferSize);
        try {
            int read = readFuture.get(readTimeoutMs, TimeUnit.MILLISECONDS);
            if (read < 0) {
                throw new EOFException("End of stream reached (length)");
            }
            if (!1.$assertionsDisabled && read != bufferSize.capacity()) {
                throw new AssertionError();
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new IOException("Read timeout exceeded (length)" + readTimeoutMs, e);
        }
        bufferSize.flip();
        ByteBuffer serialized = ByteBuffer.allocate(bufferSize.getInt());
        while (serialized.remaining() > 0) {
            readFuture = ic.read(serialized);
            try {
                int read = readFuture.get(readTimeoutMs, TimeUnit.MILLISECONDS);
                if (read >= 0) continue;
                throw new EOFException("End of stream reached (object)");
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new IOException("Read timeout exceeded (object)" + readTimeoutMs, e);
            }
        }
        serialized.flip();
        return this.deSerialize(serialized.array(), loader);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

